import { ChartThemeDefinition } from '../ChartTheme/ChartTheme';
export declare const getCustomTheme: (themeColor: string, themeVariant: string, customTheme: ChartThemeDefinition) => ChartThemeDefinition;
export declare const getAxisTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletComparativeErrorMeasureTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletComparativeMeasureTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletComparativeWarningMeasureTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletGroupTitleTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletPrimaryDotMeasureTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletPrimaryNegativeMeasureTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletPrimarySegmentedMeasureTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getBulletQualitativeRangeTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getChartTheme: (themeColor: string, themeVariant: string, showAxis: boolean) => ChartThemeDefinition;
export declare const getDonutTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getDonutThresholdDynamicTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getDonutThresholdStaticTheme: (themeColor: string, themeVariant: string, invert?: boolean) => ChartThemeDefinition;
export declare const getDonutUtilizationTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getDarkThemeColors: (themeColor: string) => {
    area: {
        colorScale: string[];
        style: {
            data: {
                fill: string;
            };
        };
    };
    axis: {
        colorScale: string[];
    };
    bar: {
        colorScale: string[];
        style: {
            data: {
                fill: string;
            };
        };
    };
    boxplot: {
        colorScale: string[];
    };
    candlestick: {
        colorScale: string[];
    };
    chart: {
        colorScale: string[];
    };
    errorbar: {
        colorScale: string[];
    };
    group: {
        colorScale: string[];
    };
    legend: {
        colorScale: string[];
    };
    line: {
        colorScale: string[];
        style: {
            data: {
                stroke: string;
            };
        };
    };
    pie: {
        colorScale: string[];
    };
    scatter: {
        colorScale: string[];
    };
    stack: {
        colorScale: string[];
    };
    voronoi: {
        colorScale: string[];
    };
};
export declare const getLightThemeColors: (themeColor: string) => {
    area: {
        colorScale: string[];
        style: {
            data: {
                fill: string;
            };
        };
    };
    axis: {
        colorScale: string[];
    };
    bar: {
        colorScale: string[];
        style: {
            data: {
                fill: string;
            };
        };
    };
    boxplot: {
        colorScale: string[];
    };
    candlestick: {
        colorScale: string[];
    };
    chart: {
        colorScale: string[];
    };
    errorbar: {
        colorScale: string[];
    };
    group: {
        colorScale: string[];
    };
    legend: {
        colorScale: string[];
    };
    line: {
        colorScale: string[];
        style: {
            data: {
                stroke: string;
            };
        };
    };
    pie: {
        colorScale: string[];
    };
    scatter: {
        colorScale: string[];
    };
    stack: {
        colorScale: string[];
    };
    voronoi: {
        colorScale: string[];
    };
};
export declare const getTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
export declare const getThresholdTheme: (themeColor: string, themeVariant: string) => ChartThemeDefinition;
//# sourceMappingURL=chart-theme.d.ts.map