import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
/* eslint-disable camelcase */
import chart_legend_Margin from '@patternfly/react-tokens/dist/esm/chart_legend_Margin';
import { VictoryChart } from 'victory-chart';
import { ChartContainer } from '../ChartContainer';
import { ChartLegend, ChartLegendPosition } from '../ChartLegend';
import { ChartCommonStyles } from '../ChartTheme';
import { getChartTheme, getClassName, getComputedLegend, getLabelTextSize, getPaddingForSide } from '../ChartUtils';
export const Chart = (_a) => {
    var { ariaDesc, ariaTitle, children, legendAllowWrap = false, legendComponent = React.createElement(ChartLegend, null), legendData, legendPosition = ChartCommonStyles.legend.position, padding, showAxis = true, themeColor, themeVariant, 
    // destructure last
    theme = getChartTheme(themeColor, themeVariant, showAxis), containerComponent = React.createElement(ChartContainer, null), legendOrientation = theme.legend.orientation, height = theme.chart.height, width = theme.chart.width } = _a, rest = __rest(_a, ["ariaDesc", "ariaTitle", "children", "legendAllowWrap", "legendComponent", "legendData", "legendPosition", "padding", "showAxis", "themeColor", "themeVariant", "theme", "containerComponent", "legendOrientation", "height", "width"]);
    const defaultPadding = {
        bottom: getPaddingForSide('bottom', padding, theme.chart.padding),
        left: getPaddingForSide('left', padding, theme.chart.padding),
        right: getPaddingForSide('right', padding, theme.chart.padding),
        top: getPaddingForSide('top', padding, theme.chart.padding)
    };
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign(Object.assign({ desc: ariaDesc, title: ariaTitle, theme }, containerComponent.props), { className: getClassName({ className: containerComponent.props.className }) // Override VictoryContainer class name
     }));
    const legend = React.cloneElement(legendComponent, Object.assign({ data: legendData, orientation: legendOrientation, theme }, legendComponent.props));
    // Returns a computed legend
    const getLegend = () => {
        if (!legend.props.data) {
            return null;
        }
        let dx = 0;
        let dy = 0;
        let xAxisLabelHeight = 0;
        let legendTitleHeight = legend.props.title ? 10 : 0;
        // Adjust for axis label
        React.Children.toArray(children).map((child) => {
            if (child.type.role === 'axis' && child.props.label && !child.props.dependentAxis) {
                xAxisLabelHeight = getLabelTextSize({ text: child.props.label, theme }).height + 10;
                legendTitleHeight = 0;
            }
        });
        if (legendPosition === ChartLegendPosition.bottom) {
            dy += xAxisLabelHeight + legendTitleHeight;
        }
        else if (legendPosition === ChartLegendPosition.bottomLeft) {
            dy += xAxisLabelHeight + legendTitleHeight;
            dx = -10;
        }
        // Adjust legend position when axis is hidden
        if (!showAxis) {
            dy -= chart_legend_Margin.value;
        }
        return getComputedLegend({
            allowWrap: legendAllowWrap,
            chartType: 'chart',
            dx,
            dy,
            height,
            legendComponent: legend,
            padding: defaultPadding,
            position: legendPosition,
            theme,
            width
        });
    };
    // Note: containerComponent is required for theme
    return (React.createElement(VictoryChart, Object.assign({ containerComponent: container, height: height, padding: defaultPadding, theme: theme, width: width }, rest),
        children,
        getLegend()));
};
Chart.displayName = 'Chart';
hoistNonReactStatics(Chart, VictoryChart);
//# sourceMappingURL=Chart.js.map