import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/MultipleFileUpload/multiple-file-upload';
import { css } from '@patternfly/react-styles';
import { ExpandableSection } from '../ExpandableSection';
export const MultipleFileUploadStatus = (_a) => {
    var { children, className, statusToggleText, statusToggleIcon } = _a, props = __rest(_a, ["children", "className", "statusToggleText", "statusToggleIcon"]);
    const toggle = (React.createElement("div", { className: styles.multipleFileUploadStatusProgress },
        React.createElement("div", { className: styles.multipleFileUploadStatusProgressIcon }, statusToggleIcon),
        React.createElement("div", { className: styles.multipleFileUploadStatusItemProgressText }, statusToggleText)));
    const [isOpen, setIsOpen] = React.useState(true);
    const toggleExpandableSection = () => {
        setIsOpen(!isOpen);
    };
    return (React.createElement("div", Object.assign({ className: css(styles.multipleFileUploadStatus, className) }, props),
        React.createElement(ExpandableSection, { toggleContent: toggle, isExpanded: isOpen, onToggle: toggleExpandableSection },
            React.createElement("ul", { className: "pf-c-multiple-file-upload__status-list" }, children))));
};
MultipleFileUploadStatus.displayName = 'MultipleFileUploadStatus';
//# sourceMappingURL=MultipleFileUploadStatus.js.map