import { SelectionSetNode } from 'graphql';
import { Reference, StoreObject } from '../../utilities';
import { Cache } from '../core/types/Cache';
import { DiffQueryAgainstStoreOptions, ReadMergeModifyContext } from './types';
import { InMemoryCache } from './inMemoryCache';
import { MissingFieldError } from '../core/types/common';
import { ObjectCanon } from './object-canon';
export declare type VariableMap = {
    [name: string]: any;
};
export declare type ExecResult<R = any> = {
    result: R;
    missing?: MissingFieldError[];
};
export interface StoreReaderConfig {
    cache: InMemoryCache;
    addTypename?: boolean;
    resultCacheMaxSize?: number;
    canon?: ObjectCanon;
}
export declare class StoreReader {
    private executeSelectionSet;
    private executeSubSelectedArray;
    private config;
    private knownResults;
    canon: ObjectCanon;
    resetCanon(): void;
    constructor(config: StoreReaderConfig);
    diffQueryAgainstStore<T>({ store, query, rootId, variables, returnPartialData, canonizeResults, }: DiffQueryAgainstStoreOptions): Cache.DiffResult<T>;
    isFresh(result: Record<string, any>, parent: StoreObject | Reference, selectionSet: SelectionSetNode, context: ReadMergeModifyContext): boolean;
    private execSelectionSetImpl;
    private execSubSelectedArrayImpl;
}
//# sourceMappingURL=readFromStore.d.ts.map