/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/submariner-io/submariner/pkg/apis/submariner.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// GlobalEgressIPLister helps list GlobalEgressIPs.
// All objects returned here must be treated as read-only.
type GlobalEgressIPLister interface {
	// List lists all GlobalEgressIPs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.GlobalEgressIP, err error)
	// GlobalEgressIPs returns an object that can list and get GlobalEgressIPs.
	GlobalEgressIPs(namespace string) GlobalEgressIPNamespaceLister
	GlobalEgressIPListerExpansion
}

// globalEgressIPLister implements the GlobalEgressIPLister interface.
type globalEgressIPLister struct {
	indexer cache.Indexer
}

// NewGlobalEgressIPLister returns a new GlobalEgressIPLister.
func NewGlobalEgressIPLister(indexer cache.Indexer) GlobalEgressIPLister {
	return &globalEgressIPLister{indexer: indexer}
}

// List lists all GlobalEgressIPs in the indexer.
func (s *globalEgressIPLister) List(selector labels.Selector) (ret []*v1.GlobalEgressIP, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GlobalEgressIP))
	})
	return ret, err
}

// GlobalEgressIPs returns an object that can list and get GlobalEgressIPs.
func (s *globalEgressIPLister) GlobalEgressIPs(namespace string) GlobalEgressIPNamespaceLister {
	return globalEgressIPNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GlobalEgressIPNamespaceLister helps list and get GlobalEgressIPs.
// All objects returned here must be treated as read-only.
type GlobalEgressIPNamespaceLister interface {
	// List lists all GlobalEgressIPs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.GlobalEgressIP, err error)
	// Get retrieves the GlobalEgressIP from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.GlobalEgressIP, error)
	GlobalEgressIPNamespaceListerExpansion
}

// globalEgressIPNamespaceLister implements the GlobalEgressIPNamespaceLister
// interface.
type globalEgressIPNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GlobalEgressIPs in the indexer for a given namespace.
func (s globalEgressIPNamespaceLister) List(selector labels.Selector) (ret []*v1.GlobalEgressIP, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.GlobalEgressIP))
	})
	return ret, err
}

// Get retrieves the GlobalEgressIP from the indexer for a given namespace and name.
func (s globalEgressIPNamespaceLister) Get(name string) (*v1.GlobalEgressIP, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("globalegressip"), name)
	}
	return obj.(*v1.GlobalEgressIP), nil
}
