// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafkaconnect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateConnector = "CreateConnector"

// CreateConnectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnector for more information on using the CreateConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectorRequest method.
//    req, resp := client.CreateConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateConnector
func (c *KafkaConnect) CreateConnectorRequest(input *CreateConnectorInput) (req *request.Request, output *CreateConnectorOutput) {
	op := &request.Operation{
		Name:       opCreateConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/connectors",
	}

	if input == nil {
		input = &CreateConnectorInput{}
	}

	output = &CreateConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnector API operation for Managed Streaming for Kafka Connect.
//
// Creates a connector using the specified properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation CreateConnector for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * ConflictException
//   HTTP Status Code 409: Conflict. A resource with this name already exists.
//   Retry your request with another name.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateConnector
func (c *KafkaConnect) CreateConnector(input *CreateConnectorInput) (*CreateConnectorOutput, error) {
	req, out := c.CreateConnectorRequest(input)
	return out, req.Send()
}

// CreateConnectorWithContext is the same as CreateConnector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) CreateConnectorWithContext(ctx aws.Context, input *CreateConnectorInput, opts ...request.Option) (*CreateConnectorOutput, error) {
	req, out := c.CreateConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomPlugin = "CreateCustomPlugin"

// CreateCustomPluginRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomPlugin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomPlugin for more information on using the CreateCustomPlugin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomPluginRequest method.
//    req, resp := client.CreateCustomPluginRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateCustomPlugin
func (c *KafkaConnect) CreateCustomPluginRequest(input *CreateCustomPluginInput) (req *request.Request, output *CreateCustomPluginOutput) {
	op := &request.Operation{
		Name:       opCreateCustomPlugin,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/custom-plugins",
	}

	if input == nil {
		input = &CreateCustomPluginInput{}
	}

	output = &CreateCustomPluginOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomPlugin API operation for Managed Streaming for Kafka Connect.
//
// Creates a custom plugin using the specified properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation CreateCustomPlugin for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * ConflictException
//   HTTP Status Code 409: Conflict. A resource with this name already exists.
//   Retry your request with another name.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateCustomPlugin
func (c *KafkaConnect) CreateCustomPlugin(input *CreateCustomPluginInput) (*CreateCustomPluginOutput, error) {
	req, out := c.CreateCustomPluginRequest(input)
	return out, req.Send()
}

// CreateCustomPluginWithContext is the same as CreateCustomPlugin with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomPlugin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) CreateCustomPluginWithContext(ctx aws.Context, input *CreateCustomPluginInput, opts ...request.Option) (*CreateCustomPluginOutput, error) {
	req, out := c.CreateCustomPluginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkerConfiguration = "CreateWorkerConfiguration"

// CreateWorkerConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkerConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkerConfiguration for more information on using the CreateWorkerConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkerConfigurationRequest method.
//    req, resp := client.CreateWorkerConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateWorkerConfiguration
func (c *KafkaConnect) CreateWorkerConfigurationRequest(input *CreateWorkerConfigurationInput) (req *request.Request, output *CreateWorkerConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateWorkerConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/worker-configurations",
	}

	if input == nil {
		input = &CreateWorkerConfigurationInput{}
	}

	output = &CreateWorkerConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkerConfiguration API operation for Managed Streaming for Kafka Connect.
//
// Creates a worker configuration using the specified properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation CreateWorkerConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * ConflictException
//   HTTP Status Code 409: Conflict. A resource with this name already exists.
//   Retry your request with another name.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateWorkerConfiguration
func (c *KafkaConnect) CreateWorkerConfiguration(input *CreateWorkerConfigurationInput) (*CreateWorkerConfigurationOutput, error) {
	req, out := c.CreateWorkerConfigurationRequest(input)
	return out, req.Send()
}

// CreateWorkerConfigurationWithContext is the same as CreateWorkerConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkerConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) CreateWorkerConfigurationWithContext(ctx aws.Context, input *CreateWorkerConfigurationInput, opts ...request.Option) (*CreateWorkerConfigurationOutput, error) {
	req, out := c.CreateWorkerConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnector = "DeleteConnector"

// DeleteConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnector for more information on using the DeleteConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectorRequest method.
//    req, resp := client.DeleteConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteConnector
func (c *KafkaConnect) DeleteConnectorRequest(input *DeleteConnectorInput) (req *request.Request, output *DeleteConnectorOutput) {
	op := &request.Operation{
		Name:       opDeleteConnector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/connectors/{connectorArn}",
	}

	if input == nil {
		input = &DeleteConnectorInput{}
	}

	output = &DeleteConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnector API operation for Managed Streaming for Kafka Connect.
//
// Deletes the specified connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation DeleteConnector for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteConnector
func (c *KafkaConnect) DeleteConnector(input *DeleteConnectorInput) (*DeleteConnectorOutput, error) {
	req, out := c.DeleteConnectorRequest(input)
	return out, req.Send()
}

// DeleteConnectorWithContext is the same as DeleteConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) DeleteConnectorWithContext(ctx aws.Context, input *DeleteConnectorInput, opts ...request.Option) (*DeleteConnectorOutput, error) {
	req, out := c.DeleteConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnector = "DescribeConnector"

// DescribeConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnector for more information on using the DescribeConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectorRequest method.
//    req, resp := client.DescribeConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeConnector
func (c *KafkaConnect) DescribeConnectorRequest(input *DescribeConnectorInput) (req *request.Request, output *DescribeConnectorOutput) {
	op := &request.Operation{
		Name:       opDescribeConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/connectors/{connectorArn}",
	}

	if input == nil {
		input = &DescribeConnectorInput{}
	}

	output = &DescribeConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnector API operation for Managed Streaming for Kafka Connect.
//
// Returns summary information about the connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation DescribeConnector for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeConnector
func (c *KafkaConnect) DescribeConnector(input *DescribeConnectorInput) (*DescribeConnectorOutput, error) {
	req, out := c.DescribeConnectorRequest(input)
	return out, req.Send()
}

// DescribeConnectorWithContext is the same as DescribeConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) DescribeConnectorWithContext(ctx aws.Context, input *DescribeConnectorInput, opts ...request.Option) (*DescribeConnectorOutput, error) {
	req, out := c.DescribeConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomPlugin = "DescribeCustomPlugin"

// DescribeCustomPluginRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomPlugin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomPlugin for more information on using the DescribeCustomPlugin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCustomPluginRequest method.
//    req, resp := client.DescribeCustomPluginRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeCustomPlugin
func (c *KafkaConnect) DescribeCustomPluginRequest(input *DescribeCustomPluginInput) (req *request.Request, output *DescribeCustomPluginOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomPlugin,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/custom-plugins/{customPluginArn}",
	}

	if input == nil {
		input = &DescribeCustomPluginInput{}
	}

	output = &DescribeCustomPluginOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomPlugin API operation for Managed Streaming for Kafka Connect.
//
// A summary description of the custom plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation DescribeCustomPlugin for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeCustomPlugin
func (c *KafkaConnect) DescribeCustomPlugin(input *DescribeCustomPluginInput) (*DescribeCustomPluginOutput, error) {
	req, out := c.DescribeCustomPluginRequest(input)
	return out, req.Send()
}

// DescribeCustomPluginWithContext is the same as DescribeCustomPlugin with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomPlugin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) DescribeCustomPluginWithContext(ctx aws.Context, input *DescribeCustomPluginInput, opts ...request.Option) (*DescribeCustomPluginOutput, error) {
	req, out := c.DescribeCustomPluginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkerConfiguration = "DescribeWorkerConfiguration"

// DescribeWorkerConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkerConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkerConfiguration for more information on using the DescribeWorkerConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkerConfigurationRequest method.
//    req, resp := client.DescribeWorkerConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeWorkerConfiguration
func (c *KafkaConnect) DescribeWorkerConfigurationRequest(input *DescribeWorkerConfigurationInput) (req *request.Request, output *DescribeWorkerConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkerConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/worker-configurations/{workerConfigurationArn}",
	}

	if input == nil {
		input = &DescribeWorkerConfigurationInput{}
	}

	output = &DescribeWorkerConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkerConfiguration API operation for Managed Streaming for Kafka Connect.
//
// Returns information about a worker configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation DescribeWorkerConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeWorkerConfiguration
func (c *KafkaConnect) DescribeWorkerConfiguration(input *DescribeWorkerConfigurationInput) (*DescribeWorkerConfigurationOutput, error) {
	req, out := c.DescribeWorkerConfigurationRequest(input)
	return out, req.Send()
}

// DescribeWorkerConfigurationWithContext is the same as DescribeWorkerConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkerConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) DescribeWorkerConfigurationWithContext(ctx aws.Context, input *DescribeWorkerConfigurationInput, opts ...request.Option) (*DescribeWorkerConfigurationOutput, error) {
	req, out := c.DescribeWorkerConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConnectors = "ListConnectors"

// ListConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnectors for more information on using the ListConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConnectorsRequest method.
//    req, resp := client.ListConnectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors
func (c *KafkaConnect) ListConnectorsRequest(input *ListConnectorsInput) (req *request.Request, output *ListConnectorsOutput) {
	op := &request.Operation{
		Name:       opListConnectors,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConnectorsInput{}
	}

	output = &ListConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnectors API operation for Managed Streaming for Kafka Connect.
//
// Returns a list of all the connectors in this account and Region. The list
// is limited to connectors whose name starts with the specified prefix. The
// response also includes a description of each of the listed connectors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation ListConnectors for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors
func (c *KafkaConnect) ListConnectors(input *ListConnectorsInput) (*ListConnectorsOutput, error) {
	req, out := c.ListConnectorsRequest(input)
	return out, req.Send()
}

// ListConnectorsWithContext is the same as ListConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) ListConnectorsWithContext(ctx aws.Context, input *ListConnectorsInput, opts ...request.Option) (*ListConnectorsOutput, error) {
	req, out := c.ListConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConnectorsPages iterates over the pages of a ListConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConnectors operation.
//    pageNum := 0
//    err := client.ListConnectorsPages(params,
//        func(page *kafkaconnect.ListConnectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KafkaConnect) ListConnectorsPages(input *ListConnectorsInput, fn func(*ListConnectorsOutput, bool) bool) error {
	return c.ListConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConnectorsPagesWithContext same as ListConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) ListConnectorsPagesWithContext(ctx aws.Context, input *ListConnectorsInput, fn func(*ListConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomPlugins = "ListCustomPlugins"

// ListCustomPluginsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomPlugins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomPlugins for more information on using the ListCustomPlugins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCustomPluginsRequest method.
//    req, resp := client.ListCustomPluginsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins
func (c *KafkaConnect) ListCustomPluginsRequest(input *ListCustomPluginsInput) (req *request.Request, output *ListCustomPluginsOutput) {
	op := &request.Operation{
		Name:       opListCustomPlugins,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/custom-plugins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomPluginsInput{}
	}

	output = &ListCustomPluginsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomPlugins API operation for Managed Streaming for Kafka Connect.
//
// Returns a list of all of the custom plugins in this account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation ListCustomPlugins for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins
func (c *KafkaConnect) ListCustomPlugins(input *ListCustomPluginsInput) (*ListCustomPluginsOutput, error) {
	req, out := c.ListCustomPluginsRequest(input)
	return out, req.Send()
}

// ListCustomPluginsWithContext is the same as ListCustomPlugins with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomPlugins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) ListCustomPluginsWithContext(ctx aws.Context, input *ListCustomPluginsInput, opts ...request.Option) (*ListCustomPluginsOutput, error) {
	req, out := c.ListCustomPluginsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomPluginsPages iterates over the pages of a ListCustomPlugins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomPlugins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCustomPlugins operation.
//    pageNum := 0
//    err := client.ListCustomPluginsPages(params,
//        func(page *kafkaconnect.ListCustomPluginsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KafkaConnect) ListCustomPluginsPages(input *ListCustomPluginsInput, fn func(*ListCustomPluginsOutput, bool) bool) error {
	return c.ListCustomPluginsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomPluginsPagesWithContext same as ListCustomPluginsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) ListCustomPluginsPagesWithContext(ctx aws.Context, input *ListCustomPluginsInput, fn func(*ListCustomPluginsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomPluginsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomPluginsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomPluginsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkerConfigurations = "ListWorkerConfigurations"

// ListWorkerConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkerConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkerConfigurations for more information on using the ListWorkerConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkerConfigurationsRequest method.
//    req, resp := client.ListWorkerConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations
func (c *KafkaConnect) ListWorkerConfigurationsRequest(input *ListWorkerConfigurationsInput) (req *request.Request, output *ListWorkerConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListWorkerConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/worker-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkerConfigurationsInput{}
	}

	output = &ListWorkerConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkerConfigurations API operation for Managed Streaming for Kafka Connect.
//
// Returns a list of all of the worker configurations in this account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation ListWorkerConfigurations for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations
func (c *KafkaConnect) ListWorkerConfigurations(input *ListWorkerConfigurationsInput) (*ListWorkerConfigurationsOutput, error) {
	req, out := c.ListWorkerConfigurationsRequest(input)
	return out, req.Send()
}

// ListWorkerConfigurationsWithContext is the same as ListWorkerConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkerConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) ListWorkerConfigurationsWithContext(ctx aws.Context, input *ListWorkerConfigurationsInput, opts ...request.Option) (*ListWorkerConfigurationsOutput, error) {
	req, out := c.ListWorkerConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkerConfigurationsPages iterates over the pages of a ListWorkerConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkerConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkerConfigurations operation.
//    pageNum := 0
//    err := client.ListWorkerConfigurationsPages(params,
//        func(page *kafkaconnect.ListWorkerConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KafkaConnect) ListWorkerConfigurationsPages(input *ListWorkerConfigurationsInput, fn func(*ListWorkerConfigurationsOutput, bool) bool) error {
	return c.ListWorkerConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkerConfigurationsPagesWithContext same as ListWorkerConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) ListWorkerConfigurationsPagesWithContext(ctx aws.Context, input *ListWorkerConfigurationsInput, fn func(*ListWorkerConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkerConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkerConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkerConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateConnector = "UpdateConnector"

// UpdateConnectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnector for more information on using the UpdateConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectorRequest method.
//    req, resp := client.UpdateConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/UpdateConnector
func (c *KafkaConnect) UpdateConnectorRequest(input *UpdateConnectorInput) (req *request.Request, output *UpdateConnectorOutput) {
	op := &request.Operation{
		Name:       opUpdateConnector,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/connectors/{connectorArn}",
	}

	if input == nil {
		input = &UpdateConnectorInput{}
	}

	output = &UpdateConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnector API operation for Managed Streaming for Kafka Connect.
//
// Updates the specified connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka Connect's
// API operation UpdateConnector for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   HTTP Status Code 404: Resource not found due to incorrect input. Correct
//   your request and then retry it.
//
//   * BadRequestException
//   HTTP Status Code 400: Bad request due to incorrect input. Correct your request
//   and then retry it.
//
//   * ForbiddenException
//   HTTP Status Code 403: Access forbidden. Correct your credentials and then
//   retry your request.
//
//   * ServiceUnavailableException
//   HTTP Status Code 503: Service Unavailable. Retrying your request in some
//   time might resolve the issue.
//
//   * TooManyRequestsException
//   HTTP Status Code 429: Limit exceeded. Resource limit reached.
//
//   * UnauthorizedException
//   HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
//   be validated.
//
//   * InternalServerErrorException
//   HTTP Status Code 500: Unexpected internal server error. Retrying your request
//   might resolve the issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/UpdateConnector
func (c *KafkaConnect) UpdateConnector(input *UpdateConnectorInput) (*UpdateConnectorOutput, error) {
	req, out := c.UpdateConnectorRequest(input)
	return out, req.Send()
}

// UpdateConnectorWithContext is the same as UpdateConnector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KafkaConnect) UpdateConnectorWithContext(ctx aws.Context, input *UpdateConnectorInput, opts ...request.Option) (*UpdateConnectorOutput, error) {
	req, out := c.UpdateConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The details of the Apache Kafka cluster to which the connector is connected.
type ApacheKafkaCluster struct {
	_ struct{} `type:"structure"`

	// The bootstrap servers of the cluster.
	//
	// BootstrapServers is a required field
	BootstrapServers *string `locationName:"bootstrapServers" type:"string" required:"true"`

	// Details of an Amazon VPC which has network connectivity to the Apache Kafka
	// cluster.
	//
	// Vpc is a required field
	Vpc *Vpc `locationName:"vpc" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApacheKafkaCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApacheKafkaCluster) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApacheKafkaCluster) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApacheKafkaCluster"}
	if s.BootstrapServers == nil {
		invalidParams.Add(request.NewErrParamRequired("BootstrapServers"))
	}
	if s.Vpc == nil {
		invalidParams.Add(request.NewErrParamRequired("Vpc"))
	}
	if s.Vpc != nil {
		if err := s.Vpc.Validate(); err != nil {
			invalidParams.AddNested("Vpc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBootstrapServers sets the BootstrapServers field's value.
func (s *ApacheKafkaCluster) SetBootstrapServers(v string) *ApacheKafkaCluster {
	s.BootstrapServers = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *ApacheKafkaCluster) SetVpc(v *Vpc) *ApacheKafkaCluster {
	s.Vpc = v
	return s
}

// The description of the Apache Kafka cluster to which the connector is connected.
type ApacheKafkaClusterDescription struct {
	_ struct{} `type:"structure"`

	// The bootstrap servers of the cluster.
	BootstrapServers *string `locationName:"bootstrapServers" type:"string"`

	// Details of an Amazon VPC which has network connectivity to the Apache Kafka
	// cluster.
	Vpc *VpcDescription `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApacheKafkaClusterDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApacheKafkaClusterDescription) GoString() string {
	return s.String()
}

// SetBootstrapServers sets the BootstrapServers field's value.
func (s *ApacheKafkaClusterDescription) SetBootstrapServers(v string) *ApacheKafkaClusterDescription {
	s.BootstrapServers = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *ApacheKafkaClusterDescription) SetVpc(v *VpcDescription) *ApacheKafkaClusterDescription {
	s.Vpc = v
	return s
}

// Specifies how the connector scales.
type AutoScaling struct {
	_ struct{} `type:"structure"`

	// The maximum number of workers allocated to the connector.
	//
	// MaxWorkerCount is a required field
	MaxWorkerCount *int64 `locationName:"maxWorkerCount" min:"1" type:"integer" required:"true"`

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	//
	// McuCount is a required field
	McuCount *int64 `locationName:"mcuCount" min:"1" type:"integer" required:"true"`

	// The minimum number of workers allocated to the connector.
	//
	// MinWorkerCount is a required field
	MinWorkerCount *int64 `locationName:"minWorkerCount" min:"1" type:"integer" required:"true"`

	// The sacle-in policy for the connector.
	ScaleInPolicy *ScaleInPolicy `locationName:"scaleInPolicy" type:"structure"`

	// The sacle-out policy for the connector.
	ScaleOutPolicy *ScaleOutPolicy `locationName:"scaleOutPolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScaling) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScaling) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScaling) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScaling"}
	if s.MaxWorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxWorkerCount"))
	}
	if s.MaxWorkerCount != nil && *s.MaxWorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxWorkerCount", 1))
	}
	if s.McuCount == nil {
		invalidParams.Add(request.NewErrParamRequired("McuCount"))
	}
	if s.McuCount != nil && *s.McuCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("McuCount", 1))
	}
	if s.MinWorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MinWorkerCount"))
	}
	if s.MinWorkerCount != nil && *s.MinWorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinWorkerCount", 1))
	}
	if s.ScaleInPolicy != nil {
		if err := s.ScaleInPolicy.Validate(); err != nil {
			invalidParams.AddNested("ScaleInPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.ScaleOutPolicy != nil {
		if err := s.ScaleOutPolicy.Validate(); err != nil {
			invalidParams.AddNested("ScaleOutPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxWorkerCount sets the MaxWorkerCount field's value.
func (s *AutoScaling) SetMaxWorkerCount(v int64) *AutoScaling {
	s.MaxWorkerCount = &v
	return s
}

// SetMcuCount sets the McuCount field's value.
func (s *AutoScaling) SetMcuCount(v int64) *AutoScaling {
	s.McuCount = &v
	return s
}

// SetMinWorkerCount sets the MinWorkerCount field's value.
func (s *AutoScaling) SetMinWorkerCount(v int64) *AutoScaling {
	s.MinWorkerCount = &v
	return s
}

// SetScaleInPolicy sets the ScaleInPolicy field's value.
func (s *AutoScaling) SetScaleInPolicy(v *ScaleInPolicy) *AutoScaling {
	s.ScaleInPolicy = v
	return s
}

// SetScaleOutPolicy sets the ScaleOutPolicy field's value.
func (s *AutoScaling) SetScaleOutPolicy(v *ScaleOutPolicy) *AutoScaling {
	s.ScaleOutPolicy = v
	return s
}

// Information about the auto scaling parameters for the connector.
type AutoScalingDescription struct {
	_ struct{} `type:"structure"`

	// The maximum number of workers allocated to the connector.
	MaxWorkerCount *int64 `locationName:"maxWorkerCount" type:"integer"`

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	McuCount *int64 `locationName:"mcuCount" type:"integer"`

	// The minimum number of workers allocated to the connector.
	MinWorkerCount *int64 `locationName:"minWorkerCount" type:"integer"`

	// The sacle-in policy for the connector.
	ScaleInPolicy *ScaleInPolicyDescription `locationName:"scaleInPolicy" type:"structure"`

	// The sacle-out policy for the connector.>
	ScaleOutPolicy *ScaleOutPolicyDescription `locationName:"scaleOutPolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingDescription) GoString() string {
	return s.String()
}

// SetMaxWorkerCount sets the MaxWorkerCount field's value.
func (s *AutoScalingDescription) SetMaxWorkerCount(v int64) *AutoScalingDescription {
	s.MaxWorkerCount = &v
	return s
}

// SetMcuCount sets the McuCount field's value.
func (s *AutoScalingDescription) SetMcuCount(v int64) *AutoScalingDescription {
	s.McuCount = &v
	return s
}

// SetMinWorkerCount sets the MinWorkerCount field's value.
func (s *AutoScalingDescription) SetMinWorkerCount(v int64) *AutoScalingDescription {
	s.MinWorkerCount = &v
	return s
}

// SetScaleInPolicy sets the ScaleInPolicy field's value.
func (s *AutoScalingDescription) SetScaleInPolicy(v *ScaleInPolicyDescription) *AutoScalingDescription {
	s.ScaleInPolicy = v
	return s
}

// SetScaleOutPolicy sets the ScaleOutPolicy field's value.
func (s *AutoScalingDescription) SetScaleOutPolicy(v *ScaleOutPolicyDescription) *AutoScalingDescription {
	s.ScaleOutPolicy = v
	return s
}

// The updates to the auto scaling parameters for the connector.
type AutoScalingUpdate struct {
	_ struct{} `type:"structure"`

	// The target maximum number of workers allocated to the connector.
	//
	// MaxWorkerCount is a required field
	MaxWorkerCount *int64 `locationName:"maxWorkerCount" min:"1" type:"integer" required:"true"`

	// The target number of microcontroller units (MCUs) allocated to each connector
	// worker. The valid values are 1,2,4,8.
	//
	// McuCount is a required field
	McuCount *int64 `locationName:"mcuCount" min:"1" type:"integer" required:"true"`

	// The target minimum number of workers allocated to the connector.
	//
	// MinWorkerCount is a required field
	MinWorkerCount *int64 `locationName:"minWorkerCount" min:"1" type:"integer" required:"true"`

	// The target sacle-in policy for the connector.
	//
	// ScaleInPolicy is a required field
	ScaleInPolicy *ScaleInPolicyUpdate `locationName:"scaleInPolicy" type:"structure" required:"true"`

	// The target sacle-out policy for the connector.
	//
	// ScaleOutPolicy is a required field
	ScaleOutPolicy *ScaleOutPolicyUpdate `locationName:"scaleOutPolicy" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingUpdate"}
	if s.MaxWorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxWorkerCount"))
	}
	if s.MaxWorkerCount != nil && *s.MaxWorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxWorkerCount", 1))
	}
	if s.McuCount == nil {
		invalidParams.Add(request.NewErrParamRequired("McuCount"))
	}
	if s.McuCount != nil && *s.McuCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("McuCount", 1))
	}
	if s.MinWorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MinWorkerCount"))
	}
	if s.MinWorkerCount != nil && *s.MinWorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinWorkerCount", 1))
	}
	if s.ScaleInPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ScaleInPolicy"))
	}
	if s.ScaleOutPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ScaleOutPolicy"))
	}
	if s.ScaleInPolicy != nil {
		if err := s.ScaleInPolicy.Validate(); err != nil {
			invalidParams.AddNested("ScaleInPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.ScaleOutPolicy != nil {
		if err := s.ScaleOutPolicy.Validate(); err != nil {
			invalidParams.AddNested("ScaleOutPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxWorkerCount sets the MaxWorkerCount field's value.
func (s *AutoScalingUpdate) SetMaxWorkerCount(v int64) *AutoScalingUpdate {
	s.MaxWorkerCount = &v
	return s
}

// SetMcuCount sets the McuCount field's value.
func (s *AutoScalingUpdate) SetMcuCount(v int64) *AutoScalingUpdate {
	s.McuCount = &v
	return s
}

// SetMinWorkerCount sets the MinWorkerCount field's value.
func (s *AutoScalingUpdate) SetMinWorkerCount(v int64) *AutoScalingUpdate {
	s.MinWorkerCount = &v
	return s
}

// SetScaleInPolicy sets the ScaleInPolicy field's value.
func (s *AutoScalingUpdate) SetScaleInPolicy(v *ScaleInPolicyUpdate) *AutoScalingUpdate {
	s.ScaleInPolicy = v
	return s
}

// SetScaleOutPolicy sets the ScaleOutPolicy field's value.
func (s *AutoScalingUpdate) SetScaleOutPolicy(v *ScaleOutPolicyUpdate) *AutoScalingUpdate {
	s.ScaleOutPolicy = v
	return s
}

// HTTP Status Code 400: Bad request due to incorrect input. Correct your request
// and then retry it.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the capacity of the connector, whether it is auto scaled
// or provisioned.
type Capacity struct {
	_ struct{} `type:"structure"`

	// Information about the auto scaling parameters for the connector.
	AutoScaling *AutoScaling `locationName:"autoScaling" type:"structure"`

	// Details about a fixed capacity allocated to a connector.
	ProvisionedCapacity *ProvisionedCapacity `locationName:"provisionedCapacity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Capacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Capacity"}
	if s.AutoScaling != nil {
		if err := s.AutoScaling.Validate(); err != nil {
			invalidParams.AddNested("AutoScaling", err.(request.ErrInvalidParams))
		}
	}
	if s.ProvisionedCapacity != nil {
		if err := s.ProvisionedCapacity.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScaling sets the AutoScaling field's value.
func (s *Capacity) SetAutoScaling(v *AutoScaling) *Capacity {
	s.AutoScaling = v
	return s
}

// SetProvisionedCapacity sets the ProvisionedCapacity field's value.
func (s *Capacity) SetProvisionedCapacity(v *ProvisionedCapacity) *Capacity {
	s.ProvisionedCapacity = v
	return s
}

// A description of the connector's capacity.
type CapacityDescription struct {
	_ struct{} `type:"structure"`

	// Describes the connector's auto scaling capacity.
	AutoScaling *AutoScalingDescription `locationName:"autoScaling" type:"structure"`

	// Describes a connector's provisioned capacity.
	ProvisionedCapacity *ProvisionedCapacityDescription `locationName:"provisionedCapacity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityDescription) GoString() string {
	return s.String()
}

// SetAutoScaling sets the AutoScaling field's value.
func (s *CapacityDescription) SetAutoScaling(v *AutoScalingDescription) *CapacityDescription {
	s.AutoScaling = v
	return s
}

// SetProvisionedCapacity sets the ProvisionedCapacity field's value.
func (s *CapacityDescription) SetProvisionedCapacity(v *ProvisionedCapacityDescription) *CapacityDescription {
	s.ProvisionedCapacity = v
	return s
}

// The target capacity for the connector. The capacity can be auto scaled or
// provisioned.
type CapacityUpdate struct {
	_ struct{} `type:"structure"`

	// The target auto scaling setting.
	AutoScaling *AutoScalingUpdate `locationName:"autoScaling" type:"structure"`

	// The target settings for provisioned capacity.
	ProvisionedCapacity *ProvisionedCapacityUpdate `locationName:"provisionedCapacity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityUpdate"}
	if s.AutoScaling != nil {
		if err := s.AutoScaling.Validate(); err != nil {
			invalidParams.AddNested("AutoScaling", err.(request.ErrInvalidParams))
		}
	}
	if s.ProvisionedCapacity != nil {
		if err := s.ProvisionedCapacity.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScaling sets the AutoScaling field's value.
func (s *CapacityUpdate) SetAutoScaling(v *AutoScalingUpdate) *CapacityUpdate {
	s.AutoScaling = v
	return s
}

// SetProvisionedCapacity sets the ProvisionedCapacity field's value.
func (s *CapacityUpdate) SetProvisionedCapacity(v *ProvisionedCapacityUpdate) *CapacityUpdate {
	s.ProvisionedCapacity = v
	return s
}

// The settings for delivering connector logs to Amazon CloudWatch Logs.
type CloudWatchLogsLogDelivery struct {
	_ struct{} `type:"structure"`

	// Whether log delivery to Amazon CloudWatch Logs is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The name of the CloudWatch log group that is the destination for log delivery.
	LogGroup *string `locationName:"logGroup" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsLogDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsLogDelivery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsLogDelivery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogsLogDelivery"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLogsLogDelivery) SetEnabled(v bool) *CloudWatchLogsLogDelivery {
	s.Enabled = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogsLogDelivery) SetLogGroup(v string) *CloudWatchLogsLogDelivery {
	s.LogGroup = &v
	return s
}

// A description of the log delivery settings.
type CloudWatchLogsLogDeliveryDescription struct {
	_ struct{} `type:"structure"`

	// Whether log delivery to Amazon CloudWatch Logs is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The name of the CloudWatch log group that is the destination for log delivery.
	LogGroup *string `locationName:"logGroup" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsLogDeliveryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsLogDeliveryDescription) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLogsLogDeliveryDescription) SetEnabled(v bool) *CloudWatchLogsLogDeliveryDescription {
	s.Enabled = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogsLogDeliveryDescription) SetLogGroup(v string) *CloudWatchLogsLogDeliveryDescription {
	s.LogGroup = &v
	return s
}

// HTTP Status Code 409: Conflict. A resource with this name already exists.
// Retry your request with another name.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary of a connector.
type ConnectorSummary struct {
	_ struct{} `type:"structure"`

	// The connector's compute capacity settings.
	Capacity *CapacityDescription `locationName:"capacity" type:"structure"`

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `locationName:"connectorArn" type:"string"`

	// The description of the connector.
	ConnectorDescription *string `locationName:"connectorDescription" type:"string"`

	// The name of the connector.
	ConnectorName *string `locationName:"connectorName" type:"string"`

	// The state of the connector.
	ConnectorState *string `locationName:"connectorState" type:"string" enum:"ConnectorState"`

	// The time that the connector was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The current version of the connector.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// The details of the Apache Kafka cluster to which the connector is connected.
	KafkaCluster *KafkaClusterDescription `locationName:"kafkaCluster" type:"structure"`

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// The value is NONE when no client authentication is used.
	KafkaClusterClientAuthentication *KafkaClusterClientAuthenticationDescription `locationName:"kafkaClusterClientAuthentication" type:"structure"`

	// Details of encryption in transit to the Apache Kafka cluster.
	KafkaClusterEncryptionInTransit *KafkaClusterEncryptionInTransitDescription `locationName:"kafkaClusterEncryptionInTransit" type:"structure"`

	// The version of Kafka Connect. It has to be compatible with both the Apache
	// Kafka cluster's version and the plugins.
	KafkaConnectVersion *string `locationName:"kafkaConnectVersion" type:"string"`

	// The settings for delivering connector logs to Amazon CloudWatch Logs.
	LogDelivery *LogDeliveryDescription `locationName:"logDelivery" type:"structure"`

	// Specifies which plugins were used for this connector.
	Plugins []*PluginDescription `locationName:"plugins" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role used by the connector to access
	// Amazon Web Services resources.
	ServiceExecutionRoleArn *string `locationName:"serviceExecutionRoleArn" type:"string"`

	// The worker configurations that are in use with the connector.
	WorkerConfiguration *WorkerConfigurationDescription `locationName:"workerConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorSummary) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *ConnectorSummary) SetCapacity(v *CapacityDescription) *ConnectorSummary {
	s.Capacity = v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ConnectorSummary) SetConnectorArn(v string) *ConnectorSummary {
	s.ConnectorArn = &v
	return s
}

// SetConnectorDescription sets the ConnectorDescription field's value.
func (s *ConnectorSummary) SetConnectorDescription(v string) *ConnectorSummary {
	s.ConnectorDescription = &v
	return s
}

// SetConnectorName sets the ConnectorName field's value.
func (s *ConnectorSummary) SetConnectorName(v string) *ConnectorSummary {
	s.ConnectorName = &v
	return s
}

// SetConnectorState sets the ConnectorState field's value.
func (s *ConnectorSummary) SetConnectorState(v string) *ConnectorSummary {
	s.ConnectorState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ConnectorSummary) SetCreationTime(v time.Time) *ConnectorSummary {
	s.CreationTime = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ConnectorSummary) SetCurrentVersion(v string) *ConnectorSummary {
	s.CurrentVersion = &v
	return s
}

// SetKafkaCluster sets the KafkaCluster field's value.
func (s *ConnectorSummary) SetKafkaCluster(v *KafkaClusterDescription) *ConnectorSummary {
	s.KafkaCluster = v
	return s
}

// SetKafkaClusterClientAuthentication sets the KafkaClusterClientAuthentication field's value.
func (s *ConnectorSummary) SetKafkaClusterClientAuthentication(v *KafkaClusterClientAuthenticationDescription) *ConnectorSummary {
	s.KafkaClusterClientAuthentication = v
	return s
}

// SetKafkaClusterEncryptionInTransit sets the KafkaClusterEncryptionInTransit field's value.
func (s *ConnectorSummary) SetKafkaClusterEncryptionInTransit(v *KafkaClusterEncryptionInTransitDescription) *ConnectorSummary {
	s.KafkaClusterEncryptionInTransit = v
	return s
}

// SetKafkaConnectVersion sets the KafkaConnectVersion field's value.
func (s *ConnectorSummary) SetKafkaConnectVersion(v string) *ConnectorSummary {
	s.KafkaConnectVersion = &v
	return s
}

// SetLogDelivery sets the LogDelivery field's value.
func (s *ConnectorSummary) SetLogDelivery(v *LogDeliveryDescription) *ConnectorSummary {
	s.LogDelivery = v
	return s
}

// SetPlugins sets the Plugins field's value.
func (s *ConnectorSummary) SetPlugins(v []*PluginDescription) *ConnectorSummary {
	s.Plugins = v
	return s
}

// SetServiceExecutionRoleArn sets the ServiceExecutionRoleArn field's value.
func (s *ConnectorSummary) SetServiceExecutionRoleArn(v string) *ConnectorSummary {
	s.ServiceExecutionRoleArn = &v
	return s
}

// SetWorkerConfiguration sets the WorkerConfiguration field's value.
func (s *ConnectorSummary) SetWorkerConfiguration(v *WorkerConfigurationDescription) *ConnectorSummary {
	s.WorkerConfiguration = v
	return s
}

type CreateConnectorInput struct {
	_ struct{} `type:"structure"`

	// Information about the capacity allocated to the connector. Exactly one of
	// the two properties must be specified.
	//
	// Capacity is a required field
	Capacity *Capacity `locationName:"capacity" type:"structure" required:"true"`

	// A map of keys to values that represent the configuration for the connector.
	//
	// ConnectorConfiguration is a required field
	ConnectorConfiguration map[string]*string `locationName:"connectorConfiguration" type:"map" required:"true"`

	// A summary description of the connector.
	ConnectorDescription *string `locationName:"connectorDescription" type:"string"`

	// The name of the connector.
	//
	// ConnectorName is a required field
	ConnectorName *string `locationName:"connectorName" min:"1" type:"string" required:"true"`

	// Specifies which Apache Kafka cluster to connect to.
	//
	// KafkaCluster is a required field
	KafkaCluster *KafkaCluster `locationName:"kafkaCluster" type:"structure" required:"true"`

	// Details of the client authentication used by the Apache Kafka cluster.
	//
	// KafkaClusterClientAuthentication is a required field
	KafkaClusterClientAuthentication *KafkaClusterClientAuthentication `locationName:"kafkaClusterClientAuthentication" type:"structure" required:"true"`

	// Details of encryption in transit to the Apache Kafka cluster.
	//
	// KafkaClusterEncryptionInTransit is a required field
	KafkaClusterEncryptionInTransit *KafkaClusterEncryptionInTransit `locationName:"kafkaClusterEncryptionInTransit" type:"structure" required:"true"`

	// The version of Kafka Connect. It has to be compatible with both the Apache
	// Kafka cluster's version and the plugins.
	//
	// KafkaConnectVersion is a required field
	KafkaConnectVersion *string `locationName:"kafkaConnectVersion" type:"string" required:"true"`

	// Details about log delivery.
	LogDelivery *LogDelivery `locationName:"logDelivery" type:"structure"`

	// Specifies which plugins to use for the connector.
	//
	// Plugins is a required field
	Plugins []*Plugin `locationName:"plugins" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used by the connector to access
	// the Amazon Web Services resources that it needs. The types of resources depends
	// on the logic of the connector. For example, a connector that has Amazon S3
	// as a destination must have permissions that allow it to write to the S3 destination
	// bucket.
	//
	// ServiceExecutionRoleArn is a required field
	ServiceExecutionRoleArn *string `locationName:"serviceExecutionRoleArn" type:"string" required:"true"`

	// Specifies which worker configuration to use with the connector.
	WorkerConfiguration *WorkerConfiguration `locationName:"workerConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectorInput"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.ConnectorConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorConfiguration"))
	}
	if s.ConnectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorName"))
	}
	if s.ConnectorName != nil && len(*s.ConnectorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorName", 1))
	}
	if s.KafkaCluster == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaCluster"))
	}
	if s.KafkaClusterClientAuthentication == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaClusterClientAuthentication"))
	}
	if s.KafkaClusterEncryptionInTransit == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaClusterEncryptionInTransit"))
	}
	if s.KafkaConnectVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaConnectVersion"))
	}
	if s.Plugins == nil {
		invalidParams.Add(request.NewErrParamRequired("Plugins"))
	}
	if s.ServiceExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceExecutionRoleArn"))
	}
	if s.Capacity != nil {
		if err := s.Capacity.Validate(); err != nil {
			invalidParams.AddNested("Capacity", err.(request.ErrInvalidParams))
		}
	}
	if s.KafkaCluster != nil {
		if err := s.KafkaCluster.Validate(); err != nil {
			invalidParams.AddNested("KafkaCluster", err.(request.ErrInvalidParams))
		}
	}
	if s.KafkaClusterClientAuthentication != nil {
		if err := s.KafkaClusterClientAuthentication.Validate(); err != nil {
			invalidParams.AddNested("KafkaClusterClientAuthentication", err.(request.ErrInvalidParams))
		}
	}
	if s.KafkaClusterEncryptionInTransit != nil {
		if err := s.KafkaClusterEncryptionInTransit.Validate(); err != nil {
			invalidParams.AddNested("KafkaClusterEncryptionInTransit", err.(request.ErrInvalidParams))
		}
	}
	if s.LogDelivery != nil {
		if err := s.LogDelivery.Validate(); err != nil {
			invalidParams.AddNested("LogDelivery", err.(request.ErrInvalidParams))
		}
	}
	if s.Plugins != nil {
		for i, v := range s.Plugins {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Plugins", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WorkerConfiguration != nil {
		if err := s.WorkerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WorkerConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *CreateConnectorInput) SetCapacity(v *Capacity) *CreateConnectorInput {
	s.Capacity = v
	return s
}

// SetConnectorConfiguration sets the ConnectorConfiguration field's value.
func (s *CreateConnectorInput) SetConnectorConfiguration(v map[string]*string) *CreateConnectorInput {
	s.ConnectorConfiguration = v
	return s
}

// SetConnectorDescription sets the ConnectorDescription field's value.
func (s *CreateConnectorInput) SetConnectorDescription(v string) *CreateConnectorInput {
	s.ConnectorDescription = &v
	return s
}

// SetConnectorName sets the ConnectorName field's value.
func (s *CreateConnectorInput) SetConnectorName(v string) *CreateConnectorInput {
	s.ConnectorName = &v
	return s
}

// SetKafkaCluster sets the KafkaCluster field's value.
func (s *CreateConnectorInput) SetKafkaCluster(v *KafkaCluster) *CreateConnectorInput {
	s.KafkaCluster = v
	return s
}

// SetKafkaClusterClientAuthentication sets the KafkaClusterClientAuthentication field's value.
func (s *CreateConnectorInput) SetKafkaClusterClientAuthentication(v *KafkaClusterClientAuthentication) *CreateConnectorInput {
	s.KafkaClusterClientAuthentication = v
	return s
}

// SetKafkaClusterEncryptionInTransit sets the KafkaClusterEncryptionInTransit field's value.
func (s *CreateConnectorInput) SetKafkaClusterEncryptionInTransit(v *KafkaClusterEncryptionInTransit) *CreateConnectorInput {
	s.KafkaClusterEncryptionInTransit = v
	return s
}

// SetKafkaConnectVersion sets the KafkaConnectVersion field's value.
func (s *CreateConnectorInput) SetKafkaConnectVersion(v string) *CreateConnectorInput {
	s.KafkaConnectVersion = &v
	return s
}

// SetLogDelivery sets the LogDelivery field's value.
func (s *CreateConnectorInput) SetLogDelivery(v *LogDelivery) *CreateConnectorInput {
	s.LogDelivery = v
	return s
}

// SetPlugins sets the Plugins field's value.
func (s *CreateConnectorInput) SetPlugins(v []*Plugin) *CreateConnectorInput {
	s.Plugins = v
	return s
}

// SetServiceExecutionRoleArn sets the ServiceExecutionRoleArn field's value.
func (s *CreateConnectorInput) SetServiceExecutionRoleArn(v string) *CreateConnectorInput {
	s.ServiceExecutionRoleArn = &v
	return s
}

// SetWorkerConfiguration sets the WorkerConfiguration field's value.
func (s *CreateConnectorInput) SetWorkerConfiguration(v *WorkerConfiguration) *CreateConnectorInput {
	s.WorkerConfiguration = v
	return s
}

type CreateConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that Amazon assigned to the connector.
	ConnectorArn *string `locationName:"connectorArn" type:"string"`

	// The name of the connector.
	ConnectorName *string `locationName:"connectorName" type:"string"`

	// The state of the connector.
	ConnectorState *string `locationName:"connectorState" type:"string" enum:"ConnectorState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorOutput) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *CreateConnectorOutput) SetConnectorArn(v string) *CreateConnectorOutput {
	s.ConnectorArn = &v
	return s
}

// SetConnectorName sets the ConnectorName field's value.
func (s *CreateConnectorOutput) SetConnectorName(v string) *CreateConnectorOutput {
	s.ConnectorName = &v
	return s
}

// SetConnectorState sets the ConnectorState field's value.
func (s *CreateConnectorOutput) SetConnectorState(v string) *CreateConnectorOutput {
	s.ConnectorState = &v
	return s
}

type CreateCustomPluginInput struct {
	_ struct{} `type:"structure"`

	// The type of the plugin file.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true" enum:"CustomPluginContentType"`

	// A summary description of the custom plugin.
	Description *string `locationName:"description" type:"string"`

	// Information about the location of a custom plugin.
	//
	// Location is a required field
	Location *CustomPluginLocation `locationName:"location" type:"structure" required:"true"`

	// The name of the custom plugin.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomPluginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomPluginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomPluginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomPluginInput"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *CreateCustomPluginInput) SetContentType(v string) *CreateCustomPluginInput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCustomPluginInput) SetDescription(v string) *CreateCustomPluginInput {
	s.Description = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateCustomPluginInput) SetLocation(v *CustomPluginLocation) *CreateCustomPluginInput {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCustomPluginInput) SetName(v string) *CreateCustomPluginInput {
	s.Name = &v
	return s
}

type CreateCustomPluginOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.
	CustomPluginArn *string `locationName:"customPluginArn" type:"string"`

	// The state of the custom plugin.
	CustomPluginState *string `locationName:"customPluginState" type:"string" enum:"CustomPluginState"`

	// The name of the custom plugin.
	Name *string `locationName:"name" type:"string"`

	// The revision of the custom plugin.
	Revision *int64 `locationName:"revision" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomPluginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomPluginOutput) GoString() string {
	return s.String()
}

// SetCustomPluginArn sets the CustomPluginArn field's value.
func (s *CreateCustomPluginOutput) SetCustomPluginArn(v string) *CreateCustomPluginOutput {
	s.CustomPluginArn = &v
	return s
}

// SetCustomPluginState sets the CustomPluginState field's value.
func (s *CreateCustomPluginOutput) SetCustomPluginState(v string) *CreateCustomPluginOutput {
	s.CustomPluginState = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCustomPluginOutput) SetName(v string) *CreateCustomPluginOutput {
	s.Name = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CreateCustomPluginOutput) SetRevision(v int64) *CreateCustomPluginOutput {
	s.Revision = &v
	return s
}

type CreateWorkerConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A summary description of the worker configuration.
	Description *string `locationName:"description" type:"string"`

	// The name of the worker configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Base64 encoded contents of connect-distributed.properties file.
	//
	// PropertiesFileContent is a required field
	PropertiesFileContent *string `locationName:"propertiesFileContent" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkerConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkerConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PropertiesFileContent == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertiesFileContent"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkerConfigurationInput) SetDescription(v string) *CreateWorkerConfigurationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkerConfigurationInput) SetName(v string) *CreateWorkerConfigurationInput {
	s.Name = &v
	return s
}

// SetPropertiesFileContent sets the PropertiesFileContent field's value.
func (s *CreateWorkerConfigurationInput) SetPropertiesFileContent(v string) *CreateWorkerConfigurationInput {
	s.PropertiesFileContent = &v
	return s
}

type CreateWorkerConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The time that the worker configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The latest revision of the worker configuration.
	LatestRevision *WorkerConfigurationRevisionSummary `locationName:"latestRevision" type:"structure"`

	// The name of the worker configuration.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.
	WorkerConfigurationArn *string `locationName:"workerConfigurationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateWorkerConfigurationOutput) SetCreationTime(v time.Time) *CreateWorkerConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *CreateWorkerConfigurationOutput) SetLatestRevision(v *WorkerConfigurationRevisionSummary) *CreateWorkerConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkerConfigurationOutput) SetName(v string) *CreateWorkerConfigurationOutput {
	s.Name = &v
	return s
}

// SetWorkerConfigurationArn sets the WorkerConfigurationArn field's value.
func (s *CreateWorkerConfigurationOutput) SetWorkerConfigurationArn(v string) *CreateWorkerConfigurationOutput {
	s.WorkerConfigurationArn = &v
	return s
}

// A plugin is an AWS resource that contains the code that defines a connector's
// logic.
type CustomPlugin struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom plugin.
	//
	// CustomPluginArn is a required field
	CustomPluginArn *string `locationName:"customPluginArn" type:"string" required:"true"`

	// The revision of the custom plugin.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPlugin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPlugin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomPlugin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomPlugin"}
	if s.CustomPluginArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomPluginArn"))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}
	if s.Revision != nil && *s.Revision < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Revision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomPluginArn sets the CustomPluginArn field's value.
func (s *CustomPlugin) SetCustomPluginArn(v string) *CustomPlugin {
	s.CustomPluginArn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CustomPlugin) SetRevision(v int64) *CustomPlugin {
	s.Revision = &v
	return s
}

// Details about a custom plugin.
type CustomPluginDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom plugin.
	CustomPluginArn *string `locationName:"customPluginArn" type:"string"`

	// The revision of the custom plugin.
	Revision *int64 `locationName:"revision" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginDescription) GoString() string {
	return s.String()
}

// SetCustomPluginArn sets the CustomPluginArn field's value.
func (s *CustomPluginDescription) SetCustomPluginArn(v string) *CustomPluginDescription {
	s.CustomPluginArn = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CustomPluginDescription) SetRevision(v int64) *CustomPluginDescription {
	s.Revision = &v
	return s
}

// Details about a custom plugin file.
type CustomPluginFileDescription struct {
	_ struct{} `type:"structure"`

	// The hex-encoded MD5 checksum of the custom plugin file. You can use it to
	// validate the file.
	FileMd5 *string `locationName:"fileMd5" type:"string"`

	// The size in bytes of the custom plugin file. You can use it to validate the
	// file.
	FileSize *int64 `locationName:"fileSize" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginFileDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginFileDescription) GoString() string {
	return s.String()
}

// SetFileMd5 sets the FileMd5 field's value.
func (s *CustomPluginFileDescription) SetFileMd5(v string) *CustomPluginFileDescription {
	s.FileMd5 = &v
	return s
}

// SetFileSize sets the FileSize field's value.
func (s *CustomPluginFileDescription) SetFileSize(v int64) *CustomPluginFileDescription {
	s.FileSize = &v
	return s
}

// Information about the location of a custom plugin.
type CustomPluginLocation struct {
	_ struct{} `type:"structure"`

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of
	// the plugin file stored in Amazon S3.
	//
	// S3Location is a required field
	S3Location *S3Location `locationName:"s3Location" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomPluginLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomPluginLocation"}
	if s.S3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Location"))
	}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *CustomPluginLocation) SetS3Location(v *S3Location) *CustomPluginLocation {
	s.S3Location = v
	return s
}

// Information about the location of a custom plugin.
type CustomPluginLocationDescription struct {
	_ struct{} `type:"structure"`

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of
	// the plugin file stored in Amazon S3.
	S3Location *S3LocationDescription `locationName:"s3Location" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginLocationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginLocationDescription) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *CustomPluginLocationDescription) SetS3Location(v *S3LocationDescription) *CustomPluginLocationDescription {
	s.S3Location = v
	return s
}

// Details about the revision of a custom plugin.
type CustomPluginRevisionSummary struct {
	_ struct{} `type:"structure"`

	// The format of the plugin file.
	ContentType *string `locationName:"contentType" type:"string" enum:"CustomPluginContentType"`

	// The time that the custom plugin was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the custom plugin.
	Description *string `locationName:"description" type:"string"`

	// Details about the custom plugin file.
	FileDescription *CustomPluginFileDescription `locationName:"fileDescription" type:"structure"`

	// Information about the location of the custom plugin.
	Location *CustomPluginLocationDescription `locationName:"location" type:"structure"`

	// The revision of the custom plugin.
	Revision *int64 `locationName:"revision" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginRevisionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginRevisionSummary) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *CustomPluginRevisionSummary) SetContentType(v string) *CustomPluginRevisionSummary {
	s.ContentType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CustomPluginRevisionSummary) SetCreationTime(v time.Time) *CustomPluginRevisionSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomPluginRevisionSummary) SetDescription(v string) *CustomPluginRevisionSummary {
	s.Description = &v
	return s
}

// SetFileDescription sets the FileDescription field's value.
func (s *CustomPluginRevisionSummary) SetFileDescription(v *CustomPluginFileDescription) *CustomPluginRevisionSummary {
	s.FileDescription = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CustomPluginRevisionSummary) SetLocation(v *CustomPluginLocationDescription) *CustomPluginRevisionSummary {
	s.Location = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CustomPluginRevisionSummary) SetRevision(v int64) *CustomPluginRevisionSummary {
	s.Revision = &v
	return s
}

// A summary of the custom plugin.
type CustomPluginSummary struct {
	_ struct{} `type:"structure"`

	// The time that the custom plugin was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the custom plugin.
	CustomPluginArn *string `locationName:"customPluginArn" type:"string"`

	// The state of the custom plugin.
	CustomPluginState *string `locationName:"customPluginState" type:"string" enum:"CustomPluginState"`

	// A description of the custom plugin.
	Description *string `locationName:"description" type:"string"`

	// The latest revision of the custom plugin.
	LatestRevision *CustomPluginRevisionSummary `locationName:"latestRevision" type:"structure"`

	// The name of the custom plugin.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CustomPluginSummary) SetCreationTime(v time.Time) *CustomPluginSummary {
	s.CreationTime = &v
	return s
}

// SetCustomPluginArn sets the CustomPluginArn field's value.
func (s *CustomPluginSummary) SetCustomPluginArn(v string) *CustomPluginSummary {
	s.CustomPluginArn = &v
	return s
}

// SetCustomPluginState sets the CustomPluginState field's value.
func (s *CustomPluginSummary) SetCustomPluginState(v string) *CustomPluginSummary {
	s.CustomPluginState = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomPluginSummary) SetDescription(v string) *CustomPluginSummary {
	s.Description = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *CustomPluginSummary) SetLatestRevision(v *CustomPluginRevisionSummary) *CustomPluginSummary {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *CustomPluginSummary) SetName(v string) *CustomPluginSummary {
	s.Name = &v
	return s
}

type DeleteConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector that you want to delete.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"connectorArn" type:"string" required:"true"`

	// The current version of the connector that you want to delete.
	CurrentVersion *string `location:"querystring" locationName:"currentVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectorInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DeleteConnectorInput) SetConnectorArn(v string) *DeleteConnectorInput {
	s.ConnectorArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *DeleteConnectorInput) SetCurrentVersion(v string) *DeleteConnectorInput {
	s.CurrentVersion = &v
	return s
}

type DeleteConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector that you requested to delete.
	ConnectorArn *string `locationName:"connectorArn" type:"string"`

	// The state of the connector that you requested to delete.
	ConnectorState *string `locationName:"connectorState" type:"string" enum:"ConnectorState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorOutput) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DeleteConnectorOutput) SetConnectorArn(v string) *DeleteConnectorOutput {
	s.ConnectorArn = &v
	return s
}

// SetConnectorState sets the ConnectorState field's value.
func (s *DeleteConnectorOutput) SetConnectorState(v string) *DeleteConnectorOutput {
	s.ConnectorState = &v
	return s
}

type DescribeConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector that you want to describe.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"connectorArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectorInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DescribeConnectorInput) SetConnectorArn(v string) *DescribeConnectorInput {
	s.ConnectorArn = &v
	return s
}

type DescribeConnectorOutput struct {
	_ struct{} `type:"structure"`

	// Information about the capacity of the connector, whether it is auto scaled
	// or provisioned.
	Capacity *CapacityDescription `locationName:"capacity" type:"structure"`

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `locationName:"connectorArn" type:"string"`

	// A map of keys to values that represent the configuration for the connector.
	ConnectorConfiguration map[string]*string `locationName:"connectorConfiguration" type:"map"`

	// A summary description of the connector.
	ConnectorDescription *string `locationName:"connectorDescription" type:"string"`

	// The name of the connector.
	ConnectorName *string `locationName:"connectorName" type:"string"`

	// The state of the connector.
	ConnectorState *string `locationName:"connectorState" type:"string" enum:"ConnectorState"`

	// The time the connector was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The current version of the connector.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// The Apache Kafka cluster that the connector is connected to.
	KafkaCluster *KafkaClusterDescription `locationName:"kafkaCluster" type:"structure"`

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// The value is NONE when no client authentication is used.
	KafkaClusterClientAuthentication *KafkaClusterClientAuthenticationDescription `locationName:"kafkaClusterClientAuthentication" type:"structure"`

	// Details of encryption in transit to the Apache Kafka cluster.
	KafkaClusterEncryptionInTransit *KafkaClusterEncryptionInTransitDescription `locationName:"kafkaClusterEncryptionInTransit" type:"structure"`

	// The version of Kafka Connect. It has to be compatible with both the Apache
	// Kafka cluster's version and the plugins.
	KafkaConnectVersion *string `locationName:"kafkaConnectVersion" type:"string"`

	// Details about delivering logs to Amazon CloudWatch Logs.
	LogDelivery *LogDeliveryDescription `locationName:"logDelivery" type:"structure"`

	// Specifies which plugins were used for this connector.
	Plugins []*PluginDescription `locationName:"plugins" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role used by the connector to access
	// Amazon Web Services resources.
	ServiceExecutionRoleArn *string `locationName:"serviceExecutionRoleArn" type:"string"`

	// Specifies which worker configuration was used for the connector.
	WorkerConfiguration *WorkerConfigurationDescription `locationName:"workerConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectorOutput) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *DescribeConnectorOutput) SetCapacity(v *CapacityDescription) *DescribeConnectorOutput {
	s.Capacity = v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DescribeConnectorOutput) SetConnectorArn(v string) *DescribeConnectorOutput {
	s.ConnectorArn = &v
	return s
}

// SetConnectorConfiguration sets the ConnectorConfiguration field's value.
func (s *DescribeConnectorOutput) SetConnectorConfiguration(v map[string]*string) *DescribeConnectorOutput {
	s.ConnectorConfiguration = v
	return s
}

// SetConnectorDescription sets the ConnectorDescription field's value.
func (s *DescribeConnectorOutput) SetConnectorDescription(v string) *DescribeConnectorOutput {
	s.ConnectorDescription = &v
	return s
}

// SetConnectorName sets the ConnectorName field's value.
func (s *DescribeConnectorOutput) SetConnectorName(v string) *DescribeConnectorOutput {
	s.ConnectorName = &v
	return s
}

// SetConnectorState sets the ConnectorState field's value.
func (s *DescribeConnectorOutput) SetConnectorState(v string) *DescribeConnectorOutput {
	s.ConnectorState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeConnectorOutput) SetCreationTime(v time.Time) *DescribeConnectorOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *DescribeConnectorOutput) SetCurrentVersion(v string) *DescribeConnectorOutput {
	s.CurrentVersion = &v
	return s
}

// SetKafkaCluster sets the KafkaCluster field's value.
func (s *DescribeConnectorOutput) SetKafkaCluster(v *KafkaClusterDescription) *DescribeConnectorOutput {
	s.KafkaCluster = v
	return s
}

// SetKafkaClusterClientAuthentication sets the KafkaClusterClientAuthentication field's value.
func (s *DescribeConnectorOutput) SetKafkaClusterClientAuthentication(v *KafkaClusterClientAuthenticationDescription) *DescribeConnectorOutput {
	s.KafkaClusterClientAuthentication = v
	return s
}

// SetKafkaClusterEncryptionInTransit sets the KafkaClusterEncryptionInTransit field's value.
func (s *DescribeConnectorOutput) SetKafkaClusterEncryptionInTransit(v *KafkaClusterEncryptionInTransitDescription) *DescribeConnectorOutput {
	s.KafkaClusterEncryptionInTransit = v
	return s
}

// SetKafkaConnectVersion sets the KafkaConnectVersion field's value.
func (s *DescribeConnectorOutput) SetKafkaConnectVersion(v string) *DescribeConnectorOutput {
	s.KafkaConnectVersion = &v
	return s
}

// SetLogDelivery sets the LogDelivery field's value.
func (s *DescribeConnectorOutput) SetLogDelivery(v *LogDeliveryDescription) *DescribeConnectorOutput {
	s.LogDelivery = v
	return s
}

// SetPlugins sets the Plugins field's value.
func (s *DescribeConnectorOutput) SetPlugins(v []*PluginDescription) *DescribeConnectorOutput {
	s.Plugins = v
	return s
}

// SetServiceExecutionRoleArn sets the ServiceExecutionRoleArn field's value.
func (s *DescribeConnectorOutput) SetServiceExecutionRoleArn(v string) *DescribeConnectorOutput {
	s.ServiceExecutionRoleArn = &v
	return s
}

// SetWorkerConfiguration sets the WorkerConfiguration field's value.
func (s *DescribeConnectorOutput) SetWorkerConfiguration(v *WorkerConfigurationDescription) *DescribeConnectorOutput {
	s.WorkerConfiguration = v
	return s
}

type DescribeCustomPluginInput struct {
	_ struct{} `type:"structure"`

	// Returns information about a custom plugin.
	//
	// CustomPluginArn is a required field
	CustomPluginArn *string `location:"uri" locationName:"customPluginArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomPluginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomPluginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomPluginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomPluginInput"}
	if s.CustomPluginArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomPluginArn"))
	}
	if s.CustomPluginArn != nil && len(*s.CustomPluginArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomPluginArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomPluginArn sets the CustomPluginArn field's value.
func (s *DescribeCustomPluginInput) SetCustomPluginArn(v string) *DescribeCustomPluginInput {
	s.CustomPluginArn = &v
	return s
}

type DescribeCustomPluginOutput struct {
	_ struct{} `type:"structure"`

	// The time that the custom plugin was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the custom plugin.
	CustomPluginArn *string `locationName:"customPluginArn" type:"string"`

	// The state of the custom plugin.
	CustomPluginState *string `locationName:"customPluginState" type:"string" enum:"CustomPluginState"`

	// The description of the custom plugin.
	Description *string `locationName:"description" type:"string"`

	// The latest successfully created revision of the custom plugin. If there are
	// no successfully created revisions, this field will be absent.
	LatestRevision *CustomPluginRevisionSummary `locationName:"latestRevision" type:"structure"`

	// The name of the custom plugin.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomPluginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomPluginOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeCustomPluginOutput) SetCreationTime(v time.Time) *DescribeCustomPluginOutput {
	s.CreationTime = &v
	return s
}

// SetCustomPluginArn sets the CustomPluginArn field's value.
func (s *DescribeCustomPluginOutput) SetCustomPluginArn(v string) *DescribeCustomPluginOutput {
	s.CustomPluginArn = &v
	return s
}

// SetCustomPluginState sets the CustomPluginState field's value.
func (s *DescribeCustomPluginOutput) SetCustomPluginState(v string) *DescribeCustomPluginOutput {
	s.CustomPluginState = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeCustomPluginOutput) SetDescription(v string) *DescribeCustomPluginOutput {
	s.Description = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *DescribeCustomPluginOutput) SetLatestRevision(v *CustomPluginRevisionSummary) *DescribeCustomPluginOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeCustomPluginOutput) SetName(v string) *DescribeCustomPluginOutput {
	s.Name = &v
	return s
}

type DescribeWorkerConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the worker configuration that you want
	// to get information about.
	//
	// WorkerConfigurationArn is a required field
	WorkerConfigurationArn *string `location:"uri" locationName:"workerConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkerConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkerConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkerConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkerConfigurationInput"}
	if s.WorkerConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerConfigurationArn"))
	}
	if s.WorkerConfigurationArn != nil && len(*s.WorkerConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerConfigurationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkerConfigurationArn sets the WorkerConfigurationArn field's value.
func (s *DescribeWorkerConfigurationInput) SetWorkerConfigurationArn(v string) *DescribeWorkerConfigurationInput {
	s.WorkerConfigurationArn = &v
	return s
}

type DescribeWorkerConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The time that the worker configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the worker configuration.
	Description *string `locationName:"description" type:"string"`

	// The latest revision of the custom configuration.
	LatestRevision *WorkerConfigurationRevisionDescription `locationName:"latestRevision" type:"structure"`

	// The name of the worker configuration.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the custom configuration.
	WorkerConfigurationArn *string `locationName:"workerConfigurationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkerConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkerConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeWorkerConfigurationOutput) SetCreationTime(v time.Time) *DescribeWorkerConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeWorkerConfigurationOutput) SetDescription(v string) *DescribeWorkerConfigurationOutput {
	s.Description = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *DescribeWorkerConfigurationOutput) SetLatestRevision(v *WorkerConfigurationRevisionDescription) *DescribeWorkerConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeWorkerConfigurationOutput) SetName(v string) *DescribeWorkerConfigurationOutput {
	s.Name = &v
	return s
}

// SetWorkerConfigurationArn sets the WorkerConfigurationArn field's value.
func (s *DescribeWorkerConfigurationOutput) SetWorkerConfigurationArn(v string) *DescribeWorkerConfigurationOutput {
	s.WorkerConfigurationArn = &v
	return s
}

// The settings for delivering logs to Amazon Kinesis Data Firehose.
type FirehoseLogDelivery struct {
	_ struct{} `type:"structure"`

	// The name of the Kinesis Data Firehose delivery stream that is the destination
	// for log delivery.
	DeliveryStream *string `locationName:"deliveryStream" type:"string"`

	// Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDelivery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseLogDelivery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirehoseLogDelivery"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStream sets the DeliveryStream field's value.
func (s *FirehoseLogDelivery) SetDeliveryStream(v string) *FirehoseLogDelivery {
	s.DeliveryStream = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *FirehoseLogDelivery) SetEnabled(v bool) *FirehoseLogDelivery {
	s.Enabled = &v
	return s
}

// A description of the settings for delivering logs to Amazon Kinesis Data
// Firehose.
type FirehoseLogDeliveryDescription struct {
	_ struct{} `type:"structure"`

	// The name of the Kinesis Data Firehose delivery stream that is the destination
	// for log delivery.
	DeliveryStream *string `locationName:"deliveryStream" type:"string"`

	// Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDeliveryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDeliveryDescription) GoString() string {
	return s.String()
}

// SetDeliveryStream sets the DeliveryStream field's value.
func (s *FirehoseLogDeliveryDescription) SetDeliveryStream(v string) *FirehoseLogDeliveryDescription {
	s.DeliveryStream = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *FirehoseLogDeliveryDescription) SetEnabled(v bool) *FirehoseLogDeliveryDescription {
	s.Enabled = &v
	return s
}

// HTTP Status Code 403: Access forbidden. Correct your credentials and then
// retry your request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// HTTP Status Code 500: Unexpected internal server error. Retrying your request
// might resolve the issue.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of the Apache Kafka cluster to which the connector is connected.
type KafkaCluster struct {
	_ struct{} `type:"structure"`

	// The Apache Kafka cluster to which the connector is connected.
	//
	// ApacheKafkaCluster is a required field
	ApacheKafkaCluster *ApacheKafkaCluster `locationName:"apacheKafkaCluster" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaCluster) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KafkaCluster) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KafkaCluster"}
	if s.ApacheKafkaCluster == nil {
		invalidParams.Add(request.NewErrParamRequired("ApacheKafkaCluster"))
	}
	if s.ApacheKafkaCluster != nil {
		if err := s.ApacheKafkaCluster.Validate(); err != nil {
			invalidParams.AddNested("ApacheKafkaCluster", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApacheKafkaCluster sets the ApacheKafkaCluster field's value.
func (s *KafkaCluster) SetApacheKafkaCluster(v *ApacheKafkaCluster) *KafkaCluster {
	s.ApacheKafkaCluster = v
	return s
}

// The client authentication information used in order to authenticate with
// the Apache Kafka cluster.
type KafkaClusterClientAuthentication struct {
	_ struct{} `type:"structure"`

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// Value NONE means that no client authentication is used.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `locationName:"authenticationType" type:"string" required:"true" enum:"KafkaClusterClientAuthenticationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterClientAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterClientAuthentication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KafkaClusterClientAuthentication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KafkaClusterClientAuthentication"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *KafkaClusterClientAuthentication) SetAuthenticationType(v string) *KafkaClusterClientAuthentication {
	s.AuthenticationType = &v
	return s
}

// The client authentication information used in order to authenticate with
// the Apache Kafka cluster.
type KafkaClusterClientAuthenticationDescription struct {
	_ struct{} `type:"structure"`

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// Value NONE means that no client authentication is used.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"KafkaClusterClientAuthenticationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterClientAuthenticationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterClientAuthenticationDescription) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *KafkaClusterClientAuthenticationDescription) SetAuthenticationType(v string) *KafkaClusterClientAuthenticationDescription {
	s.AuthenticationType = &v
	return s
}

// Details of how to connect to the Apache Kafka cluster.
type KafkaClusterDescription struct {
	_ struct{} `type:"structure"`

	// The Apache Kafka cluster to which the connector is connected.
	ApacheKafkaCluster *ApacheKafkaClusterDescription `locationName:"apacheKafkaCluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterDescription) GoString() string {
	return s.String()
}

// SetApacheKafkaCluster sets the ApacheKafkaCluster field's value.
func (s *KafkaClusterDescription) SetApacheKafkaCluster(v *ApacheKafkaClusterDescription) *KafkaClusterDescription {
	s.ApacheKafkaCluster = v
	return s
}

// Details of encryption in transit to the Apache Kafka cluster.
type KafkaClusterEncryptionInTransit struct {
	_ struct{} `type:"structure"`

	// The type of encryption in transit to the Apache Kafka cluster.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"KafkaClusterEncryptionInTransitType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterEncryptionInTransit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterEncryptionInTransit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KafkaClusterEncryptionInTransit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KafkaClusterEncryptionInTransit"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *KafkaClusterEncryptionInTransit) SetEncryptionType(v string) *KafkaClusterEncryptionInTransit {
	s.EncryptionType = &v
	return s
}

// The description of the encryption in transit to the Apache Kafka cluster.
type KafkaClusterEncryptionInTransitDescription struct {
	_ struct{} `type:"structure"`

	// The type of encryption in transit to the Apache Kafka cluster.
	EncryptionType *string `locationName:"encryptionType" type:"string" enum:"KafkaClusterEncryptionInTransitType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterEncryptionInTransitDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KafkaClusterEncryptionInTransitDescription) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *KafkaClusterEncryptionInTransitDescription) SetEncryptionType(v string) *KafkaClusterEncryptionInTransitDescription {
	s.EncryptionType = &v
	return s
}

type ListConnectorsInput struct {
	_ struct{} `type:"structure"`

	// The name prefix that you want to use to search for and list connectors.
	ConnectorNamePrefix *string `location:"querystring" locationName:"connectorNamePrefix" type:"string"`

	// The maximum number of connectors to list in one response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the response of a ListConnectors operation is truncated, it will include
	// a NextToken. Send this NextToken in a subsequent request to continue listing
	// from where the previous operation left off.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorNamePrefix sets the ConnectorNamePrefix field's value.
func (s *ListConnectorsInput) SetConnectorNamePrefix(v string) *ListConnectorsInput {
	s.ConnectorNamePrefix = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectorsInput) SetMaxResults(v int64) *ListConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorsInput) SetNextToken(v string) *ListConnectorsInput {
	s.NextToken = &v
	return s
}

type ListConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// An array of connector descriptions.
	Connectors []*ConnectorSummary `locationName:"connectors" type:"list"`

	// If the response of a ListConnectors operation is truncated, it will include
	// a NextToken. Send this NextToken in a subsequent request to continue listing
	// from where it left off.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsOutput) GoString() string {
	return s.String()
}

// SetConnectors sets the Connectors field's value.
func (s *ListConnectorsOutput) SetConnectors(v []*ConnectorSummary) *ListConnectorsOutput {
	s.Connectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorsOutput) SetNextToken(v string) *ListConnectorsOutput {
	s.NextToken = &v
	return s
}

type ListCustomPluginsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom plugins to list in one response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the response of a ListCustomPlugins operation is truncated, it will include
	// a NextToken. Send this NextToken in a subsequent request to continue listing
	// from where the previous operation left off.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomPluginsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomPluginsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomPluginsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomPluginsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomPluginsInput) SetMaxResults(v int64) *ListCustomPluginsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomPluginsInput) SetNextToken(v string) *ListCustomPluginsInput {
	s.NextToken = &v
	return s
}

type ListCustomPluginsOutput struct {
	_ struct{} `type:"structure"`

	// An array of custom plugin descriptions.
	CustomPlugins []*CustomPluginSummary `locationName:"customPlugins" type:"list"`

	// If the response of a ListCustomPlugins operation is truncated, it will include
	// a NextToken. Send this NextToken in a subsequent request to continue listing
	// from where the previous operation left off.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomPluginsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomPluginsOutput) GoString() string {
	return s.String()
}

// SetCustomPlugins sets the CustomPlugins field's value.
func (s *ListCustomPluginsOutput) SetCustomPlugins(v []*CustomPluginSummary) *ListCustomPluginsOutput {
	s.CustomPlugins = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomPluginsOutput) SetNextToken(v string) *ListCustomPluginsOutput {
	s.NextToken = &v
	return s
}

type ListWorkerConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of worker configurations to list in one response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the response of a ListWorkerConfigurations operation is truncated, it
	// will include a NextToken. Send this NextToken in a subsequent request to
	// continue listing from where the previous operation left off.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkerConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkerConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkerConfigurationsInput) SetMaxResults(v int64) *ListWorkerConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkerConfigurationsInput) SetNextToken(v string) *ListWorkerConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListWorkerConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If the response of a ListWorkerConfigurations operation is truncated, it
	// will include a NextToken. Send this NextToken in a subsequent request to
	// continue listing from where the previous operation left off.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of worker configuration descriptions.
	WorkerConfigurations []*WorkerConfigurationSummary `locationName:"workerConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkerConfigurationsOutput) SetNextToken(v string) *ListWorkerConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetWorkerConfigurations sets the WorkerConfigurations field's value.
func (s *ListWorkerConfigurationsOutput) SetWorkerConfigurations(v []*WorkerConfigurationSummary) *ListWorkerConfigurationsOutput {
	s.WorkerConfigurations = v
	return s
}

// Details about log delivery.
type LogDelivery struct {
	_ struct{} `type:"structure"`

	// The workers can send worker logs to different destination types. This configuration
	// specifies the details of these destinations.
	//
	// WorkerLogDelivery is a required field
	WorkerLogDelivery *WorkerLogDelivery `locationName:"workerLogDelivery" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDelivery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogDelivery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogDelivery"}
	if s.WorkerLogDelivery == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerLogDelivery"))
	}
	if s.WorkerLogDelivery != nil {
		if err := s.WorkerLogDelivery.Validate(); err != nil {
			invalidParams.AddNested("WorkerLogDelivery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkerLogDelivery sets the WorkerLogDelivery field's value.
func (s *LogDelivery) SetWorkerLogDelivery(v *WorkerLogDelivery) *LogDelivery {
	s.WorkerLogDelivery = v
	return s
}

// The description of the log delivery settings.
type LogDeliveryDescription struct {
	_ struct{} `type:"structure"`

	// The workers can send worker logs to different destination types. This configuration
	// specifies the details of these destinations.
	WorkerLogDelivery *WorkerLogDeliveryDescription `locationName:"workerLogDelivery" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDeliveryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDeliveryDescription) GoString() string {
	return s.String()
}

// SetWorkerLogDelivery sets the WorkerLogDelivery field's value.
func (s *LogDeliveryDescription) SetWorkerLogDelivery(v *WorkerLogDeliveryDescription) *LogDeliveryDescription {
	s.WorkerLogDelivery = v
	return s
}

// HTTP Status Code 404: Resource not found due to incorrect input. Correct
// your request and then retry it.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A plugin is an AWS resource that contains the code that defines your connector
// logic.
type Plugin struct {
	_ struct{} `type:"structure"`

	// Details about a custom plugin.
	//
	// CustomPlugin is a required field
	CustomPlugin *CustomPlugin `locationName:"customPlugin" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plugin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plugin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Plugin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Plugin"}
	if s.CustomPlugin == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomPlugin"))
	}
	if s.CustomPlugin != nil {
		if err := s.CustomPlugin.Validate(); err != nil {
			invalidParams.AddNested("CustomPlugin", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomPlugin sets the CustomPlugin field's value.
func (s *Plugin) SetCustomPlugin(v *CustomPlugin) *Plugin {
	s.CustomPlugin = v
	return s
}

// The description of the plugin.
type PluginDescription struct {
	_ struct{} `type:"structure"`

	// Details about a custom plugin.
	CustomPlugin *CustomPluginDescription `locationName:"customPlugin" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginDescription) GoString() string {
	return s.String()
}

// SetCustomPlugin sets the CustomPlugin field's value.
func (s *PluginDescription) SetCustomPlugin(v *CustomPluginDescription) *PluginDescription {
	s.CustomPlugin = v
	return s
}

// Details about a connector's provisioned capacity.
type ProvisionedCapacity struct {
	_ struct{} `type:"structure"`

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	//
	// McuCount is a required field
	McuCount *int64 `locationName:"mcuCount" min:"1" type:"integer" required:"true"`

	// The number of workers that are allocated to the connector.
	//
	// WorkerCount is a required field
	WorkerCount *int64 `locationName:"workerCount" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedCapacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedCapacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionedCapacity"}
	if s.McuCount == nil {
		invalidParams.Add(request.NewErrParamRequired("McuCount"))
	}
	if s.McuCount != nil && *s.McuCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("McuCount", 1))
	}
	if s.WorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerCount"))
	}
	if s.WorkerCount != nil && *s.WorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("WorkerCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMcuCount sets the McuCount field's value.
func (s *ProvisionedCapacity) SetMcuCount(v int64) *ProvisionedCapacity {
	s.McuCount = &v
	return s
}

// SetWorkerCount sets the WorkerCount field's value.
func (s *ProvisionedCapacity) SetWorkerCount(v int64) *ProvisionedCapacity {
	s.WorkerCount = &v
	return s
}

// The description of a connector's provisioned capacity.
type ProvisionedCapacityDescription struct {
	_ struct{} `type:"structure"`

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	McuCount *int64 `locationName:"mcuCount" type:"integer"`

	// The number of workers that are allocated to the connector.
	WorkerCount *int64 `locationName:"workerCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedCapacityDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedCapacityDescription) GoString() string {
	return s.String()
}

// SetMcuCount sets the McuCount field's value.
func (s *ProvisionedCapacityDescription) SetMcuCount(v int64) *ProvisionedCapacityDescription {
	s.McuCount = &v
	return s
}

// SetWorkerCount sets the WorkerCount field's value.
func (s *ProvisionedCapacityDescription) SetWorkerCount(v int64) *ProvisionedCapacityDescription {
	s.WorkerCount = &v
	return s
}

// An update to a connector's fixed capacity.
type ProvisionedCapacityUpdate struct {
	_ struct{} `type:"structure"`

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	//
	// McuCount is a required field
	McuCount *int64 `locationName:"mcuCount" min:"1" type:"integer" required:"true"`

	// The number of workers that are allocated to the connector.
	//
	// WorkerCount is a required field
	WorkerCount *int64 `locationName:"workerCount" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedCapacityUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedCapacityUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedCapacityUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionedCapacityUpdate"}
	if s.McuCount == nil {
		invalidParams.Add(request.NewErrParamRequired("McuCount"))
	}
	if s.McuCount != nil && *s.McuCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("McuCount", 1))
	}
	if s.WorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerCount"))
	}
	if s.WorkerCount != nil && *s.WorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("WorkerCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMcuCount sets the McuCount field's value.
func (s *ProvisionedCapacityUpdate) SetMcuCount(v int64) *ProvisionedCapacityUpdate {
	s.McuCount = &v
	return s
}

// SetWorkerCount sets the WorkerCount field's value.
func (s *ProvisionedCapacityUpdate) SetWorkerCount(v int64) *ProvisionedCapacityUpdate {
	s.WorkerCount = &v
	return s
}

// The location of an object in Amazon S3.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an S3 bucket.
	//
	// BucketArn is a required field
	BucketArn *string `locationName:"bucketArn" type:"string" required:"true"`

	// The file key for an object in an S3 bucket.
	//
	// FileKey is a required field
	FileKey *string `locationName:"fileKey" type:"string" required:"true"`

	// The version of an object in an S3 bucket.
	ObjectVersion *string `locationName:"objectVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.BucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketArn"))
	}
	if s.FileKey == nil {
		invalidParams.Add(request.NewErrParamRequired("FileKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3Location) SetBucketArn(v string) *S3Location {
	s.BucketArn = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3Location) SetFileKey(v string) *S3Location {
	s.FileKey = &v
	return s
}

// SetObjectVersion sets the ObjectVersion field's value.
func (s *S3Location) SetObjectVersion(v string) *S3Location {
	s.ObjectVersion = &v
	return s
}

// The description of the location of an object in Amazon S3.
type S3LocationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an S3 bucket.
	BucketArn *string `locationName:"bucketArn" type:"string"`

	// The file key for an object in an S3 bucket.
	FileKey *string `locationName:"fileKey" type:"string"`

	// The version of an object in an S3 bucket.
	ObjectVersion *string `locationName:"objectVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LocationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LocationDescription) GoString() string {
	return s.String()
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3LocationDescription) SetBucketArn(v string) *S3LocationDescription {
	s.BucketArn = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3LocationDescription) SetFileKey(v string) *S3LocationDescription {
	s.FileKey = &v
	return s
}

// SetObjectVersion sets the ObjectVersion field's value.
func (s *S3LocationDescription) SetObjectVersion(v string) *S3LocationDescription {
	s.ObjectVersion = &v
	return s
}

// Details about delivering logs to Amazon S3.
type S3LogDelivery struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that is the destination for log delivery.
	Bucket *string `locationName:"bucket" type:"string"`

	// Specifies whether connector logs get sent to the specified Amazon S3 destination.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The S3 prefix that is the destination for log delivery.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDelivery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3LogDelivery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3LogDelivery"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3LogDelivery) SetBucket(v string) *S3LogDelivery {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *S3LogDelivery) SetEnabled(v bool) *S3LogDelivery {
	s.Enabled = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3LogDelivery) SetPrefix(v string) *S3LogDelivery {
	s.Prefix = &v
	return s
}

// The description of the details about delivering logs to Amazon S3.
type S3LogDeliveryDescription struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that is the destination for log delivery.
	Bucket *string `locationName:"bucket" type:"string"`

	// Specifies whether connector logs get sent to the specified Amazon S3 destination.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The S3 prefix that is the destination for log delivery.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDeliveryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDeliveryDescription) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3LogDeliveryDescription) SetBucket(v string) *S3LogDeliveryDescription {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *S3LogDeliveryDescription) SetEnabled(v bool) *S3LogDeliveryDescription {
	s.Enabled = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3LogDeliveryDescription) SetPrefix(v string) *S3LogDeliveryDescription {
	s.Prefix = &v
	return s
}

// The scale-in policy for the connector.
type ScaleInPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies the CPU utilization percentage threshold at which you want connector
	// scale in to be triggered.
	//
	// CpuUtilizationPercentage is a required field
	CpuUtilizationPercentage *int64 `locationName:"cpuUtilizationPercentage" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleInPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleInPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScaleInPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScaleInPolicy"}
	if s.CpuUtilizationPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("CpuUtilizationPercentage"))
	}
	if s.CpuUtilizationPercentage != nil && *s.CpuUtilizationPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CpuUtilizationPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpuUtilizationPercentage sets the CpuUtilizationPercentage field's value.
func (s *ScaleInPolicy) SetCpuUtilizationPercentage(v int64) *ScaleInPolicy {
	s.CpuUtilizationPercentage = &v
	return s
}

// The description of the scale-in policy for the connector.
type ScaleInPolicyDescription struct {
	_ struct{} `type:"structure"`

	// Specifies the CPU utilization percentage threshold at which you want connector
	// scale in to be triggered.
	CpuUtilizationPercentage *int64 `locationName:"cpuUtilizationPercentage" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleInPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleInPolicyDescription) GoString() string {
	return s.String()
}

// SetCpuUtilizationPercentage sets the CpuUtilizationPercentage field's value.
func (s *ScaleInPolicyDescription) SetCpuUtilizationPercentage(v int64) *ScaleInPolicyDescription {
	s.CpuUtilizationPercentage = &v
	return s
}

// An update to the connector's scale-in policy.
type ScaleInPolicyUpdate struct {
	_ struct{} `type:"structure"`

	// The target CPU utilization percentage threshold at which you want connector
	// scale in to be triggered.
	//
	// CpuUtilizationPercentage is a required field
	CpuUtilizationPercentage *int64 `locationName:"cpuUtilizationPercentage" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleInPolicyUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleInPolicyUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScaleInPolicyUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScaleInPolicyUpdate"}
	if s.CpuUtilizationPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("CpuUtilizationPercentage"))
	}
	if s.CpuUtilizationPercentage != nil && *s.CpuUtilizationPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CpuUtilizationPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpuUtilizationPercentage sets the CpuUtilizationPercentage field's value.
func (s *ScaleInPolicyUpdate) SetCpuUtilizationPercentage(v int64) *ScaleInPolicyUpdate {
	s.CpuUtilizationPercentage = &v
	return s
}

// The scale-out policy for the connector.
type ScaleOutPolicy struct {
	_ struct{} `type:"structure"`

	// The CPU utilization percentage threshold at which you want connector scale
	// out to be triggered.
	//
	// CpuUtilizationPercentage is a required field
	CpuUtilizationPercentage *int64 `locationName:"cpuUtilizationPercentage" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleOutPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleOutPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScaleOutPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScaleOutPolicy"}
	if s.CpuUtilizationPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("CpuUtilizationPercentage"))
	}
	if s.CpuUtilizationPercentage != nil && *s.CpuUtilizationPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CpuUtilizationPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpuUtilizationPercentage sets the CpuUtilizationPercentage field's value.
func (s *ScaleOutPolicy) SetCpuUtilizationPercentage(v int64) *ScaleOutPolicy {
	s.CpuUtilizationPercentage = &v
	return s
}

// The description of the scale-out policy for the connector.
type ScaleOutPolicyDescription struct {
	_ struct{} `type:"structure"`

	// The CPU utilization percentage threshold at which you want connector scale
	// out to be triggered.
	CpuUtilizationPercentage *int64 `locationName:"cpuUtilizationPercentage" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleOutPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleOutPolicyDescription) GoString() string {
	return s.String()
}

// SetCpuUtilizationPercentage sets the CpuUtilizationPercentage field's value.
func (s *ScaleOutPolicyDescription) SetCpuUtilizationPercentage(v int64) *ScaleOutPolicyDescription {
	s.CpuUtilizationPercentage = &v
	return s
}

// An update to the connector's scale-out policy.
type ScaleOutPolicyUpdate struct {
	_ struct{} `type:"structure"`

	// The target CPU utilization percentage threshold at which you want connector
	// scale out to be triggered.
	//
	// CpuUtilizationPercentage is a required field
	CpuUtilizationPercentage *int64 `locationName:"cpuUtilizationPercentage" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleOutPolicyUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScaleOutPolicyUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScaleOutPolicyUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScaleOutPolicyUpdate"}
	if s.CpuUtilizationPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("CpuUtilizationPercentage"))
	}
	if s.CpuUtilizationPercentage != nil && *s.CpuUtilizationPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CpuUtilizationPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpuUtilizationPercentage sets the CpuUtilizationPercentage field's value.
func (s *ScaleOutPolicyUpdate) SetCpuUtilizationPercentage(v int64) *ScaleOutPolicyUpdate {
	s.CpuUtilizationPercentage = &v
	return s
}

// HTTP Status Code 503: Service Unavailable. Retrying your request in some
// time might resolve the issue.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// HTTP Status Code 429: Limit exceeded. Resource limit reached.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
// be validated.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateConnectorInput struct {
	_ struct{} `type:"structure"`

	// The target capacity.
	//
	// Capacity is a required field
	Capacity *CapacityUpdate `locationName:"capacity" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the connector that you want to update.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"connectorArn" type:"string" required:"true"`

	// The current version of the connector that you want to update.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `location:"querystring" locationName:"currentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectorInput"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 1))
	}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.Capacity != nil {
		if err := s.Capacity.Validate(); err != nil {
			invalidParams.AddNested("Capacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *UpdateConnectorInput) SetCapacity(v *CapacityUpdate) *UpdateConnectorInput {
	s.Capacity = v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *UpdateConnectorInput) SetConnectorArn(v string) *UpdateConnectorInput {
	s.ConnectorArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateConnectorInput) SetCurrentVersion(v string) *UpdateConnectorInput {
	s.CurrentVersion = &v
	return s
}

type UpdateConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `locationName:"connectorArn" type:"string"`

	// The state of the connector.
	ConnectorState *string `locationName:"connectorState" type:"string" enum:"ConnectorState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectorOutput) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *UpdateConnectorOutput) SetConnectorArn(v string) *UpdateConnectorOutput {
	s.ConnectorArn = &v
	return s
}

// SetConnectorState sets the ConnectorState field's value.
func (s *UpdateConnectorOutput) SetConnectorState(v string) *UpdateConnectorOutput {
	s.ConnectorState = &v
	return s
}

// Information about the VPC in which the connector resides.
type Vpc struct {
	_ struct{} `type:"structure"`

	// The security groups for the connector.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The subnets for the connector.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Vpc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Vpc) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Vpc) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Vpc"}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Vpc) SetSecurityGroups(v []*string) *Vpc {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *Vpc) SetSubnets(v []*string) *Vpc {
	s.Subnets = v
	return s
}

// The description of the VPC in which the connector resides.
type VpcDescription struct {
	_ struct{} `type:"structure"`

	// The security groups for the connector.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The subnets for the connector.
	Subnets []*string `locationName:"subnets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcDescription) GoString() string {
	return s.String()
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *VpcDescription) SetSecurityGroups(v []*string) *VpcDescription {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *VpcDescription) SetSubnets(v []*string) *VpcDescription {
	s.Subnets = v
	return s
}

// The configuration of the workers, which are the processes that run the connector
// logic.
type WorkerConfiguration struct {
	_ struct{} `type:"structure"`

	// The revision of the worker configuration.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" min:"1" type:"long" required:"true"`

	// The Amazon Resource Name (ARN) of the worker configuration.
	//
	// WorkerConfigurationArn is a required field
	WorkerConfigurationArn *string `locationName:"workerConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkerConfiguration"}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}
	if s.Revision != nil && *s.Revision < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Revision", 1))
	}
	if s.WorkerConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRevision sets the Revision field's value.
func (s *WorkerConfiguration) SetRevision(v int64) *WorkerConfiguration {
	s.Revision = &v
	return s
}

// SetWorkerConfigurationArn sets the WorkerConfigurationArn field's value.
func (s *WorkerConfiguration) SetWorkerConfigurationArn(v string) *WorkerConfiguration {
	s.WorkerConfigurationArn = &v
	return s
}

// The description of the worker configuration.
type WorkerConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The revision of the worker configuration.
	Revision *int64 `locationName:"revision" type:"long"`

	// The Amazon Resource Name (ARN) of the worker configuration.
	WorkerConfigurationArn *string `locationName:"workerConfigurationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationDescription) GoString() string {
	return s.String()
}

// SetRevision sets the Revision field's value.
func (s *WorkerConfigurationDescription) SetRevision(v int64) *WorkerConfigurationDescription {
	s.Revision = &v
	return s
}

// SetWorkerConfigurationArn sets the WorkerConfigurationArn field's value.
func (s *WorkerConfigurationDescription) SetWorkerConfigurationArn(v string) *WorkerConfigurationDescription {
	s.WorkerConfigurationArn = &v
	return s
}

// The description of the worker configuration revision.
type WorkerConfigurationRevisionDescription struct {
	_ struct{} `type:"structure"`

	// The time that the worker configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the worker configuration revision.
	Description *string `locationName:"description" type:"string"`

	// Base64 encoded contents of the connect-distributed.properties file.
	PropertiesFileContent *string `locationName:"propertiesFileContent" type:"string"`

	// The description of a revision of the worker configuration.
	Revision *int64 `locationName:"revision" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationRevisionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationRevisionDescription) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkerConfigurationRevisionDescription) SetCreationTime(v time.Time) *WorkerConfigurationRevisionDescription {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkerConfigurationRevisionDescription) SetDescription(v string) *WorkerConfigurationRevisionDescription {
	s.Description = &v
	return s
}

// SetPropertiesFileContent sets the PropertiesFileContent field's value.
func (s *WorkerConfigurationRevisionDescription) SetPropertiesFileContent(v string) *WorkerConfigurationRevisionDescription {
	s.PropertiesFileContent = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *WorkerConfigurationRevisionDescription) SetRevision(v int64) *WorkerConfigurationRevisionDescription {
	s.Revision = &v
	return s
}

// The summary of a worker configuration revision.
type WorkerConfigurationRevisionSummary struct {
	_ struct{} `type:"structure"`

	// The time that a worker configuration revision was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of a worker configuration revision.
	Description *string `locationName:"description" type:"string"`

	// The revision of a worker configuration.
	Revision *int64 `locationName:"revision" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationRevisionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationRevisionSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkerConfigurationRevisionSummary) SetCreationTime(v time.Time) *WorkerConfigurationRevisionSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkerConfigurationRevisionSummary) SetDescription(v string) *WorkerConfigurationRevisionSummary {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *WorkerConfigurationRevisionSummary) SetRevision(v int64) *WorkerConfigurationRevisionSummary {
	s.Revision = &v
	return s
}

// The summary of a worker configuration.
type WorkerConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The time that a worker configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of a worker configuration.
	Description *string `locationName:"description" type:"string"`

	// The latest revision of a worker configuration.
	LatestRevision *WorkerConfigurationRevisionSummary `locationName:"latestRevision" type:"structure"`

	// The name of the worker configuration.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the worker configuration.
	WorkerConfigurationArn *string `locationName:"workerConfigurationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerConfigurationSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkerConfigurationSummary) SetCreationTime(v time.Time) *WorkerConfigurationSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkerConfigurationSummary) SetDescription(v string) *WorkerConfigurationSummary {
	s.Description = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *WorkerConfigurationSummary) SetLatestRevision(v *WorkerConfigurationRevisionSummary) *WorkerConfigurationSummary {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *WorkerConfigurationSummary) SetName(v string) *WorkerConfigurationSummary {
	s.Name = &v
	return s
}

// SetWorkerConfigurationArn sets the WorkerConfigurationArn field's value.
func (s *WorkerConfigurationSummary) SetWorkerConfigurationArn(v string) *WorkerConfigurationSummary {
	s.WorkerConfigurationArn = &v
	return s
}

// Workers can send worker logs to different destination types. This configuration
// specifies the details of these destinations.
type WorkerLogDelivery struct {
	_ struct{} `type:"structure"`

	// Details about delivering logs to Amazon CloudWatch Logs.
	CloudWatchLogs *CloudWatchLogsLogDelivery `locationName:"cloudWatchLogs" type:"structure"`

	// Details about delivering logs to Amazon Kinesis Data Firehose.
	Firehose *FirehoseLogDelivery `locationName:"firehose" type:"structure"`

	// Details about delivering logs to Amazon S3.
	S3 *S3LogDelivery `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerLogDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerLogDelivery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkerLogDelivery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkerLogDelivery"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *WorkerLogDelivery) SetCloudWatchLogs(v *CloudWatchLogsLogDelivery) *WorkerLogDelivery {
	s.CloudWatchLogs = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *WorkerLogDelivery) SetFirehose(v *FirehoseLogDelivery) *WorkerLogDelivery {
	s.Firehose = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *WorkerLogDelivery) SetS3(v *S3LogDelivery) *WorkerLogDelivery {
	s.S3 = v
	return s
}

// Workers can send worker logs to different destination types. This configuration
// specifies the details of these destinations.
type WorkerLogDeliveryDescription struct {
	_ struct{} `type:"structure"`

	// Details about delivering logs to Amazon CloudWatch Logs.
	CloudWatchLogs *CloudWatchLogsLogDeliveryDescription `locationName:"cloudWatchLogs" type:"structure"`

	// Details about delivering logs to Amazon Kinesis Data Firehose.
	Firehose *FirehoseLogDeliveryDescription `locationName:"firehose" type:"structure"`

	// Details about delivering logs to Amazon S3.
	S3 *S3LogDeliveryDescription `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerLogDeliveryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerLogDeliveryDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *WorkerLogDeliveryDescription) SetCloudWatchLogs(v *CloudWatchLogsLogDeliveryDescription) *WorkerLogDeliveryDescription {
	s.CloudWatchLogs = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *WorkerLogDeliveryDescription) SetFirehose(v *FirehoseLogDeliveryDescription) *WorkerLogDeliveryDescription {
	s.Firehose = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *WorkerLogDeliveryDescription) SetS3(v *S3LogDeliveryDescription) *WorkerLogDeliveryDescription {
	s.S3 = v
	return s
}

const (
	// ConnectorStateRunning is a ConnectorState enum value
	ConnectorStateRunning = "RUNNING"

	// ConnectorStateCreating is a ConnectorState enum value
	ConnectorStateCreating = "CREATING"

	// ConnectorStateUpdating is a ConnectorState enum value
	ConnectorStateUpdating = "UPDATING"

	// ConnectorStateDeleting is a ConnectorState enum value
	ConnectorStateDeleting = "DELETING"

	// ConnectorStateFailed is a ConnectorState enum value
	ConnectorStateFailed = "FAILED"
)

// ConnectorState_Values returns all elements of the ConnectorState enum
func ConnectorState_Values() []string {
	return []string{
		ConnectorStateRunning,
		ConnectorStateCreating,
		ConnectorStateUpdating,
		ConnectorStateDeleting,
		ConnectorStateFailed,
	}
}

const (
	// CustomPluginContentTypeJar is a CustomPluginContentType enum value
	CustomPluginContentTypeJar = "JAR"

	// CustomPluginContentTypeZip is a CustomPluginContentType enum value
	CustomPluginContentTypeZip = "ZIP"
)

// CustomPluginContentType_Values returns all elements of the CustomPluginContentType enum
func CustomPluginContentType_Values() []string {
	return []string{
		CustomPluginContentTypeJar,
		CustomPluginContentTypeZip,
	}
}

const (
	// CustomPluginStateCreating is a CustomPluginState enum value
	CustomPluginStateCreating = "CREATING"

	// CustomPluginStateCreateFailed is a CustomPluginState enum value
	CustomPluginStateCreateFailed = "CREATE_FAILED"

	// CustomPluginStateActive is a CustomPluginState enum value
	CustomPluginStateActive = "ACTIVE"

	// CustomPluginStateUpdating is a CustomPluginState enum value
	CustomPluginStateUpdating = "UPDATING"

	// CustomPluginStateUpdateFailed is a CustomPluginState enum value
	CustomPluginStateUpdateFailed = "UPDATE_FAILED"

	// CustomPluginStateDeleting is a CustomPluginState enum value
	CustomPluginStateDeleting = "DELETING"
)

// CustomPluginState_Values returns all elements of the CustomPluginState enum
func CustomPluginState_Values() []string {
	return []string{
		CustomPluginStateCreating,
		CustomPluginStateCreateFailed,
		CustomPluginStateActive,
		CustomPluginStateUpdating,
		CustomPluginStateUpdateFailed,
		CustomPluginStateDeleting,
	}
}

const (
	// KafkaClusterClientAuthenticationTypeNone is a KafkaClusterClientAuthenticationType enum value
	KafkaClusterClientAuthenticationTypeNone = "NONE"

	// KafkaClusterClientAuthenticationTypeIam is a KafkaClusterClientAuthenticationType enum value
	KafkaClusterClientAuthenticationTypeIam = "IAM"
)

// KafkaClusterClientAuthenticationType_Values returns all elements of the KafkaClusterClientAuthenticationType enum
func KafkaClusterClientAuthenticationType_Values() []string {
	return []string{
		KafkaClusterClientAuthenticationTypeNone,
		KafkaClusterClientAuthenticationTypeIam,
	}
}

const (
	// KafkaClusterEncryptionInTransitTypePlaintext is a KafkaClusterEncryptionInTransitType enum value
	KafkaClusterEncryptionInTransitTypePlaintext = "PLAINTEXT"

	// KafkaClusterEncryptionInTransitTypeTls is a KafkaClusterEncryptionInTransitType enum value
	KafkaClusterEncryptionInTransitTypeTls = "TLS"
)

// KafkaClusterEncryptionInTransitType_Values returns all elements of the KafkaClusterEncryptionInTransitType enum
func KafkaClusterEncryptionInTransitType_Values() []string {
	return []string{
		KafkaClusterEncryptionInTransitTypePlaintext,
		KafkaClusterEncryptionInTransitTypeTls,
	}
}
