// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackagevod

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opConfigureLogs = "ConfigureLogs"

// ConfigureLogsRequest generates a "aws/request.Request" representing the
// client's request for the ConfigureLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfigureLogs for more information on using the ConfigureLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfigureLogsRequest method.
//    req, resp := client.ConfigureLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ConfigureLogs
func (c *MediaPackageVod) ConfigureLogsRequest(input *ConfigureLogsInput) (req *request.Request, output *ConfigureLogsOutput) {
	op := &request.Operation{
		Name:       opConfigureLogs,
		HTTPMethod: "PUT",
		HTTPPath:   "/packaging_groups/{id}/configure_logs",
	}

	if input == nil {
		input = &ConfigureLogsInput{}
	}

	output = &ConfigureLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfigureLogs API operation for AWS Elemental MediaPackage VOD.
//
// Changes the packaging group's properities to configure log subscription
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation ConfigureLogs for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ConfigureLogs
func (c *MediaPackageVod) ConfigureLogs(input *ConfigureLogsInput) (*ConfigureLogsOutput, error) {
	req, out := c.ConfigureLogsRequest(input)
	return out, req.Send()
}

// ConfigureLogsWithContext is the same as ConfigureLogs with the addition of
// the ability to pass a context and additional request options.
//
// See ConfigureLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ConfigureLogsWithContext(ctx aws.Context, input *ConfigureLogsInput, opts ...request.Option) (*ConfigureLogsOutput, error) {
	req, out := c.ConfigureLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAsset = "CreateAsset"

// CreateAssetRequest generates a "aws/request.Request" representing the
// client's request for the CreateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAsset for more information on using the CreateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssetRequest method.
//    req, resp := client.CreateAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreateAsset
func (c *MediaPackageVod) CreateAssetRequest(input *CreateAssetInput) (req *request.Request, output *CreateAssetOutput) {
	op := &request.Operation{
		Name:       opCreateAsset,
		HTTPMethod: "POST",
		HTTPPath:   "/assets",
	}

	if input == nil {
		input = &CreateAssetInput{}
	}

	output = &CreateAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAsset API operation for AWS Elemental MediaPackage VOD.
//
// Creates a new MediaPackage VOD Asset resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation CreateAsset for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreateAsset
func (c *MediaPackageVod) CreateAsset(input *CreateAssetInput) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	return out, req.Send()
}

// CreateAssetWithContext is the same as CreateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) CreateAssetWithContext(ctx aws.Context, input *CreateAssetInput, opts ...request.Option) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackagingConfiguration = "CreatePackagingConfiguration"

// CreatePackagingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackagingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackagingConfiguration for more information on using the CreatePackagingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePackagingConfigurationRequest method.
//    req, resp := client.CreatePackagingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingConfiguration
func (c *MediaPackageVod) CreatePackagingConfigurationRequest(input *CreatePackagingConfigurationInput) (req *request.Request, output *CreatePackagingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreatePackagingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/packaging_configurations",
	}

	if input == nil {
		input = &CreatePackagingConfigurationInput{}
	}

	output = &CreatePackagingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackagingConfiguration API operation for AWS Elemental MediaPackage VOD.
//
// Creates a new MediaPackage VOD PackagingConfiguration resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation CreatePackagingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingConfiguration
func (c *MediaPackageVod) CreatePackagingConfiguration(input *CreatePackagingConfigurationInput) (*CreatePackagingConfigurationOutput, error) {
	req, out := c.CreatePackagingConfigurationRequest(input)
	return out, req.Send()
}

// CreatePackagingConfigurationWithContext is the same as CreatePackagingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackagingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) CreatePackagingConfigurationWithContext(ctx aws.Context, input *CreatePackagingConfigurationInput, opts ...request.Option) (*CreatePackagingConfigurationOutput, error) {
	req, out := c.CreatePackagingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackagingGroup = "CreatePackagingGroup"

// CreatePackagingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackagingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackagingGroup for more information on using the CreatePackagingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePackagingGroupRequest method.
//    req, resp := client.CreatePackagingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingGroup
func (c *MediaPackageVod) CreatePackagingGroupRequest(input *CreatePackagingGroupInput) (req *request.Request, output *CreatePackagingGroupOutput) {
	op := &request.Operation{
		Name:       opCreatePackagingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/packaging_groups",
	}

	if input == nil {
		input = &CreatePackagingGroupInput{}
	}

	output = &CreatePackagingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackagingGroup API operation for AWS Elemental MediaPackage VOD.
//
// Creates a new MediaPackage VOD PackagingGroup resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation CreatePackagingGroup for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/CreatePackagingGroup
func (c *MediaPackageVod) CreatePackagingGroup(input *CreatePackagingGroupInput) (*CreatePackagingGroupOutput, error) {
	req, out := c.CreatePackagingGroupRequest(input)
	return out, req.Send()
}

// CreatePackagingGroupWithContext is the same as CreatePackagingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackagingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) CreatePackagingGroupWithContext(ctx aws.Context, input *CreatePackagingGroupInput, opts ...request.Option) (*CreatePackagingGroupOutput, error) {
	req, out := c.CreatePackagingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAsset = "DeleteAsset"

// DeleteAssetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAsset for more information on using the DeleteAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssetRequest method.
//    req, resp := client.DeleteAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeleteAsset
func (c *MediaPackageVod) DeleteAssetRequest(input *DeleteAssetInput) (req *request.Request, output *DeleteAssetOutput) {
	op := &request.Operation{
		Name:       opDeleteAsset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assets/{id}",
	}

	if input == nil {
		input = &DeleteAssetInput{}
	}

	output = &DeleteAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAsset API operation for AWS Elemental MediaPackage VOD.
//
// Deletes an existing MediaPackage VOD Asset resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation DeleteAsset for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeleteAsset
func (c *MediaPackageVod) DeleteAsset(input *DeleteAssetInput) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	return out, req.Send()
}

// DeleteAssetWithContext is the same as DeleteAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) DeleteAssetWithContext(ctx aws.Context, input *DeleteAssetInput, opts ...request.Option) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackagingConfiguration = "DeletePackagingConfiguration"

// DeletePackagingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackagingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackagingConfiguration for more information on using the DeletePackagingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePackagingConfigurationRequest method.
//    req, resp := client.DeletePackagingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingConfiguration
func (c *MediaPackageVod) DeletePackagingConfigurationRequest(input *DeletePackagingConfigurationInput) (req *request.Request, output *DeletePackagingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeletePackagingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/packaging_configurations/{id}",
	}

	if input == nil {
		input = &DeletePackagingConfigurationInput{}
	}

	output = &DeletePackagingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePackagingConfiguration API operation for AWS Elemental MediaPackage VOD.
//
// Deletes a MediaPackage VOD PackagingConfiguration resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation DeletePackagingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingConfiguration
func (c *MediaPackageVod) DeletePackagingConfiguration(input *DeletePackagingConfigurationInput) (*DeletePackagingConfigurationOutput, error) {
	req, out := c.DeletePackagingConfigurationRequest(input)
	return out, req.Send()
}

// DeletePackagingConfigurationWithContext is the same as DeletePackagingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackagingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) DeletePackagingConfigurationWithContext(ctx aws.Context, input *DeletePackagingConfigurationInput, opts ...request.Option) (*DeletePackagingConfigurationOutput, error) {
	req, out := c.DeletePackagingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackagingGroup = "DeletePackagingGroup"

// DeletePackagingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackagingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackagingGroup for more information on using the DeletePackagingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePackagingGroupRequest method.
//    req, resp := client.DeletePackagingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingGroup
func (c *MediaPackageVod) DeletePackagingGroupRequest(input *DeletePackagingGroupInput) (req *request.Request, output *DeletePackagingGroupOutput) {
	op := &request.Operation{
		Name:       opDeletePackagingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/packaging_groups/{id}",
	}

	if input == nil {
		input = &DeletePackagingGroupInput{}
	}

	output = &DeletePackagingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePackagingGroup API operation for AWS Elemental MediaPackage VOD.
//
// Deletes a MediaPackage VOD PackagingGroup resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation DeletePackagingGroup for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DeletePackagingGroup
func (c *MediaPackageVod) DeletePackagingGroup(input *DeletePackagingGroupInput) (*DeletePackagingGroupOutput, error) {
	req, out := c.DeletePackagingGroupRequest(input)
	return out, req.Send()
}

// DeletePackagingGroupWithContext is the same as DeletePackagingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackagingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) DeletePackagingGroupWithContext(ctx aws.Context, input *DeletePackagingGroupInput, opts ...request.Option) (*DeletePackagingGroupOutput, error) {
	req, out := c.DeletePackagingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAsset = "DescribeAsset"

// DescribeAssetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAsset for more information on using the DescribeAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetRequest method.
//    req, resp := client.DescribeAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAsset
func (c *MediaPackageVod) DescribeAssetRequest(input *DescribeAssetInput) (req *request.Request, output *DescribeAssetOutput) {
	op := &request.Operation{
		Name:       opDescribeAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{id}",
	}

	if input == nil {
		input = &DescribeAssetInput{}
	}

	output = &DescribeAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAsset API operation for AWS Elemental MediaPackage VOD.
//
// Returns a description of a MediaPackage VOD Asset resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation DescribeAsset for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAsset
func (c *MediaPackageVod) DescribeAsset(input *DescribeAssetInput) (*DescribeAssetOutput, error) {
	req, out := c.DescribeAssetRequest(input)
	return out, req.Send()
}

// DescribeAssetWithContext is the same as DescribeAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) DescribeAssetWithContext(ctx aws.Context, input *DescribeAssetInput, opts ...request.Option) (*DescribeAssetOutput, error) {
	req, out := c.DescribeAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackagingConfiguration = "DescribePackagingConfiguration"

// DescribePackagingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackagingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackagingConfiguration for more information on using the DescribePackagingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePackagingConfigurationRequest method.
//    req, resp := client.DescribePackagingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingConfiguration
func (c *MediaPackageVod) DescribePackagingConfigurationRequest(input *DescribePackagingConfigurationInput) (req *request.Request, output *DescribePackagingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribePackagingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/packaging_configurations/{id}",
	}

	if input == nil {
		input = &DescribePackagingConfigurationInput{}
	}

	output = &DescribePackagingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackagingConfiguration API operation for AWS Elemental MediaPackage VOD.
//
// Returns a description of a MediaPackage VOD PackagingConfiguration resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation DescribePackagingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingConfiguration
func (c *MediaPackageVod) DescribePackagingConfiguration(input *DescribePackagingConfigurationInput) (*DescribePackagingConfigurationOutput, error) {
	req, out := c.DescribePackagingConfigurationRequest(input)
	return out, req.Send()
}

// DescribePackagingConfigurationWithContext is the same as DescribePackagingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackagingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) DescribePackagingConfigurationWithContext(ctx aws.Context, input *DescribePackagingConfigurationInput, opts ...request.Option) (*DescribePackagingConfigurationOutput, error) {
	req, out := c.DescribePackagingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackagingGroup = "DescribePackagingGroup"

// DescribePackagingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackagingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackagingGroup for more information on using the DescribePackagingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePackagingGroupRequest method.
//    req, resp := client.DescribePackagingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingGroup
func (c *MediaPackageVod) DescribePackagingGroupRequest(input *DescribePackagingGroupInput) (req *request.Request, output *DescribePackagingGroupOutput) {
	op := &request.Operation{
		Name:       opDescribePackagingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/packaging_groups/{id}",
	}

	if input == nil {
		input = &DescribePackagingGroupInput{}
	}

	output = &DescribePackagingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackagingGroup API operation for AWS Elemental MediaPackage VOD.
//
// Returns a description of a MediaPackage VOD PackagingGroup resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation DescribePackagingGroup for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribePackagingGroup
func (c *MediaPackageVod) DescribePackagingGroup(input *DescribePackagingGroupInput) (*DescribePackagingGroupOutput, error) {
	req, out := c.DescribePackagingGroupRequest(input)
	return out, req.Send()
}

// DescribePackagingGroupWithContext is the same as DescribePackagingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackagingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) DescribePackagingGroupWithContext(ctx aws.Context, input *DescribePackagingGroupInput, opts ...request.Option) (*DescribePackagingGroupOutput, error) {
	req, out := c.DescribePackagingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssets = "ListAssets"

// ListAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssets for more information on using the ListAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssetsRequest method.
//    req, resp := client.ListAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListAssets
func (c *MediaPackageVod) ListAssetsRequest(input *ListAssetsInput) (req *request.Request, output *ListAssetsOutput) {
	op := &request.Operation{
		Name:       opListAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetsInput{}
	}

	output = &ListAssetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssets API operation for AWS Elemental MediaPackage VOD.
//
// Returns a collection of MediaPackage VOD Asset resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation ListAssets for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListAssets
func (c *MediaPackageVod) ListAssets(input *ListAssetsInput) (*ListAssetsOutput, error) {
	req, out := c.ListAssetsRequest(input)
	return out, req.Send()
}

// ListAssetsWithContext is the same as ListAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListAssetsWithContext(ctx aws.Context, input *ListAssetsInput, opts ...request.Option) (*ListAssetsOutput, error) {
	req, out := c.ListAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetsPages iterates over the pages of a ListAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssets operation.
//    pageNum := 0
//    err := client.ListAssetsPages(params,
//        func(page *mediapackagevod.ListAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaPackageVod) ListAssetsPages(input *ListAssetsInput, fn func(*ListAssetsOutput, bool) bool) error {
	return c.ListAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetsPagesWithContext same as ListAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListAssetsPagesWithContext(ctx aws.Context, input *ListAssetsInput, fn func(*ListAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackagingConfigurations = "ListPackagingConfigurations"

// ListPackagingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPackagingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackagingConfigurations for more information on using the ListPackagingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPackagingConfigurationsRequest method.
//    req, resp := client.ListPackagingConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingConfigurations
func (c *MediaPackageVod) ListPackagingConfigurationsRequest(input *ListPackagingConfigurationsInput) (req *request.Request, output *ListPackagingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListPackagingConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/packaging_configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagingConfigurationsInput{}
	}

	output = &ListPackagingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackagingConfigurations API operation for AWS Elemental MediaPackage VOD.
//
// Returns a collection of MediaPackage VOD PackagingConfiguration resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation ListPackagingConfigurations for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingConfigurations
func (c *MediaPackageVod) ListPackagingConfigurations(input *ListPackagingConfigurationsInput) (*ListPackagingConfigurationsOutput, error) {
	req, out := c.ListPackagingConfigurationsRequest(input)
	return out, req.Send()
}

// ListPackagingConfigurationsWithContext is the same as ListPackagingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackagingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListPackagingConfigurationsWithContext(ctx aws.Context, input *ListPackagingConfigurationsInput, opts ...request.Option) (*ListPackagingConfigurationsOutput, error) {
	req, out := c.ListPackagingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagingConfigurationsPages iterates over the pages of a ListPackagingConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackagingConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPackagingConfigurations operation.
//    pageNum := 0
//    err := client.ListPackagingConfigurationsPages(params,
//        func(page *mediapackagevod.ListPackagingConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaPackageVod) ListPackagingConfigurationsPages(input *ListPackagingConfigurationsInput, fn func(*ListPackagingConfigurationsOutput, bool) bool) error {
	return c.ListPackagingConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagingConfigurationsPagesWithContext same as ListPackagingConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListPackagingConfigurationsPagesWithContext(ctx aws.Context, input *ListPackagingConfigurationsInput, fn func(*ListPackagingConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagingConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagingConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagingConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackagingGroups = "ListPackagingGroups"

// ListPackagingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListPackagingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackagingGroups for more information on using the ListPackagingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPackagingGroupsRequest method.
//    req, resp := client.ListPackagingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingGroups
func (c *MediaPackageVod) ListPackagingGroupsRequest(input *ListPackagingGroupsInput) (req *request.Request, output *ListPackagingGroupsOutput) {
	op := &request.Operation{
		Name:       opListPackagingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/packaging_groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagingGroupsInput{}
	}

	output = &ListPackagingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackagingGroups API operation for AWS Elemental MediaPackage VOD.
//
// Returns a collection of MediaPackage VOD PackagingGroup resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation ListPackagingGroups for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListPackagingGroups
func (c *MediaPackageVod) ListPackagingGroups(input *ListPackagingGroupsInput) (*ListPackagingGroupsOutput, error) {
	req, out := c.ListPackagingGroupsRequest(input)
	return out, req.Send()
}

// ListPackagingGroupsWithContext is the same as ListPackagingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackagingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListPackagingGroupsWithContext(ctx aws.Context, input *ListPackagingGroupsInput, opts ...request.Option) (*ListPackagingGroupsOutput, error) {
	req, out := c.ListPackagingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagingGroupsPages iterates over the pages of a ListPackagingGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackagingGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPackagingGroups operation.
//    pageNum := 0
//    err := client.ListPackagingGroupsPages(params,
//        func(page *mediapackagevod.ListPackagingGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaPackageVod) ListPackagingGroupsPages(input *ListPackagingGroupsInput, fn func(*ListPackagingGroupsOutput, bool) bool) error {
	return c.ListPackagingGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagingGroupsPagesWithContext same as ListPackagingGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListPackagingGroupsPagesWithContext(ctx aws.Context, input *ListPackagingGroupsInput, fn func(*ListPackagingGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagingGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagingGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagingGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListTagsForResource
func (c *MediaPackageVod) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elemental MediaPackage VOD.
//
// Returns a list of the tags assigned to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/ListTagsForResource
func (c *MediaPackageVod) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/TagResource
func (c *MediaPackageVod) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Elemental MediaPackage VOD.
//
// Adds tags to the specified resource. You can specify one or more tags to
// add.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/TagResource
func (c *MediaPackageVod) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UntagResource
func (c *MediaPackageVod) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Elemental MediaPackage VOD.
//
// Removes tags from the specified resource. You can specify one or more tags
// to remove.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UntagResource
func (c *MediaPackageVod) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePackagingGroup = "UpdatePackagingGroup"

// UpdatePackagingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePackagingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePackagingGroup for more information on using the UpdatePackagingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePackagingGroupRequest method.
//    req, resp := client.UpdatePackagingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UpdatePackagingGroup
func (c *MediaPackageVod) UpdatePackagingGroupRequest(input *UpdatePackagingGroupInput) (req *request.Request, output *UpdatePackagingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdatePackagingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/packaging_groups/{id}",
	}

	if input == nil {
		input = &UpdatePackagingGroupInput{}
	}

	output = &UpdatePackagingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePackagingGroup API operation for AWS Elemental MediaPackage VOD.
//
// Updates a specific packaging group. You can't change the id attribute or
// any other system-generated attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage VOD's
// API operation UpdatePackagingGroup for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UpdatePackagingGroup
func (c *MediaPackageVod) UpdatePackagingGroup(input *UpdatePackagingGroupInput) (*UpdatePackagingGroupOutput, error) {
	req, out := c.UpdatePackagingGroupRequest(input)
	return out, req.Send()
}

// UpdatePackagingGroupWithContext is the same as UpdatePackagingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePackagingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageVod) UpdatePackagingGroupWithContext(ctx aws.Context, input *UpdatePackagingGroupInput, opts ...request.Option) (*UpdatePackagingGroupOutput, error) {
	req, out := c.UpdatePackagingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A MediaPackage VOD Asset resource.
type AssetShallow struct {
	_ struct{} `type:"structure"`

	// The ARN of the Asset.
	Arn *string `locationName:"arn" type:"string"`

	// The time the Asset was initially submitted for Ingest.
	CreatedAt *string `locationName:"createdAt" type:"string"`

	// The unique identifier for the Asset.
	Id *string `locationName:"id" type:"string"`

	// The ID of the PackagingGroup for the Asset.
	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	// The resource ID to include in SPEKE key requests.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// ARN of the source object in S3.
	SourceArn *string `locationName:"sourceArn" type:"string"`

	// The IAM role ARN used to access the source S3 bucket.
	SourceRoleArn *string `locationName:"sourceRoleArn" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetShallow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetShallow) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetShallow) SetArn(v string) *AssetShallow {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetShallow) SetCreatedAt(v string) *AssetShallow {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetShallow) SetId(v string) *AssetShallow {
	s.Id = &v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *AssetShallow) SetPackagingGroupId(v string) *AssetShallow {
	s.PackagingGroupId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssetShallow) SetResourceId(v string) *AssetShallow {
	s.ResourceId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AssetShallow) SetSourceArn(v string) *AssetShallow {
	s.SourceArn = &v
	return s
}

// SetSourceRoleArn sets the SourceRoleArn field's value.
func (s *AssetShallow) SetSourceRoleArn(v string) *AssetShallow {
	s.SourceRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssetShallow) SetTags(v map[string]*string) *AssetShallow {
	s.Tags = v
	return s
}

// CDN Authorization credentials
type Authorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that
	// is used for CDN authorization.
	//
	// CdnIdentifierSecret is a required field
	CdnIdentifierSecret *string `locationName:"cdnIdentifierSecret" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage
	// to communicate with AWS Secrets Manager.
	//
	// SecretsRoleArn is a required field
	SecretsRoleArn *string `locationName:"secretsRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Authorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Authorization) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Authorization) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Authorization"}
	if s.CdnIdentifierSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("CdnIdentifierSecret"))
	}
	if s.SecretsRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretsRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdnIdentifierSecret sets the CdnIdentifierSecret field's value.
func (s *Authorization) SetCdnIdentifierSecret(v string) *Authorization {
	s.CdnIdentifierSecret = &v
	return s
}

// SetSecretsRoleArn sets the SecretsRoleArn field's value.
func (s *Authorization) SetSecretsRoleArn(v string) *Authorization {
	s.SecretsRoleArn = &v
	return s
}

// A CMAF encryption configuration.
type CmafEncryption struct {
	_ struct{} `type:"structure"`

	// An optional 128-bit, 16-byte hex value represented by a 32-character string,
	// used in conjunction with the key for encrypting blocks. If you don't specify
	// a value, then MediaPackage creates the constant initialization vector (IV).
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CmafEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *CmafEncryption) SetConstantInitializationVector(v string) *CmafEncryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *CmafEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *CmafEncryption {
	s.SpekeKeyProvider = v
	return s
}

// A CMAF packaging configuration.
type CmafPackage struct {
	_ struct{} `type:"structure"`

	// A CMAF encryption configuration.
	Encryption *CmafEncryption `locationName:"encryption" type:"structure"`

	// A list of HLS manifest configurations.
	//
	// HlsManifests is a required field
	HlsManifests []*HlsManifest `locationName:"hlsManifests" type:"list" required:"true"`

	// When includeEncoderConfigurationInSegments is set to true, MediaPackage places
	// your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS),
	// and Video Parameter Set (VPS) metadata in every video segment instead of
	// in the init fragment. This lets you use different SPS/PPS/VPS settings for
	// your assets during content playback.
	IncludeEncoderConfigurationInSegments *bool `locationName:"includeEncoderConfigurationInSegments" type:"boolean"`

	// Duration (in seconds) of each fragment. Actual fragments will berounded to
	// the nearest multiple of the source fragment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CmafPackage"}
	if s.HlsManifests == nil {
		invalidParams.Add(request.NewErrParamRequired("HlsManifests"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *CmafPackage) SetEncryption(v *CmafEncryption) *CmafPackage {
	s.Encryption = v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *CmafPackage) SetHlsManifests(v []*HlsManifest) *CmafPackage {
	s.HlsManifests = v
	return s
}

// SetIncludeEncoderConfigurationInSegments sets the IncludeEncoderConfigurationInSegments field's value.
func (s *CmafPackage) SetIncludeEncoderConfigurationInSegments(v bool) *CmafPackage {
	s.IncludeEncoderConfigurationInSegments = &v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *CmafPackage) SetSegmentDurationSeconds(v int64) *CmafPackage {
	s.SegmentDurationSeconds = &v
	return s
}

type ConfigureLogsInput struct {
	_ struct{} `type:"structure"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigureLogsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *ConfigureLogsInput) SetEgressAccessLogs(v *EgressAccessLogs) *ConfigureLogsInput {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *ConfigureLogsInput) SetId(v string) *ConfigureLogsInput {
	s.Id = &v
	return s
}

type ConfigureLogsOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureLogsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConfigureLogsOutput) SetArn(v string) *ConfigureLogsOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *ConfigureLogsOutput) SetAuthorization(v *Authorization) *ConfigureLogsOutput {
	s.Authorization = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ConfigureLogsOutput) SetDomainName(v string) *ConfigureLogsOutput {
	s.DomainName = &v
	return s
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *ConfigureLogsOutput) SetEgressAccessLogs(v *EgressAccessLogs) *ConfigureLogsOutput {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *ConfigureLogsOutput) SetId(v string) *ConfigureLogsOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConfigureLogsOutput) SetTags(v map[string]*string) *ConfigureLogsOutput {
	s.Tags = v
	return s
}

type CreateAssetInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// PackagingGroupId is a required field
	PackagingGroupId *string `locationName:"packagingGroupId" type:"string" required:"true"`

	ResourceId *string `locationName:"resourceId" type:"string"`

	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" type:"string" required:"true"`

	// SourceRoleArn is a required field
	SourceRoleArn *string `locationName:"sourceRoleArn" type:"string" required:"true"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.PackagingGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackagingGroupId"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CreateAssetInput) SetId(v string) *CreateAssetInput {
	s.Id = &v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *CreateAssetInput) SetPackagingGroupId(v string) *CreateAssetInput {
	s.PackagingGroupId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateAssetInput) SetResourceId(v string) *CreateAssetInput {
	s.ResourceId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateAssetInput) SetSourceArn(v string) *CreateAssetInput {
	s.SourceArn = &v
	return s
}

// SetSourceRoleArn sets the SourceRoleArn field's value.
func (s *CreateAssetInput) SetSourceRoleArn(v string) *CreateAssetInput {
	s.SourceRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssetInput) SetTags(v map[string]*string) *CreateAssetInput {
	s.Tags = v
	return s
}

type CreateAssetOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *string `locationName:"createdAt" type:"string"`

	EgressEndpoints []*EgressEndpoint `locationName:"egressEndpoints" type:"list"`

	Id *string `locationName:"id" type:"string"`

	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	ResourceId *string `locationName:"resourceId" type:"string"`

	SourceArn *string `locationName:"sourceArn" type:"string"`

	SourceRoleArn *string `locationName:"sourceRoleArn" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateAssetOutput) SetArn(v string) *CreateAssetOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAssetOutput) SetCreatedAt(v string) *CreateAssetOutput {
	s.CreatedAt = &v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *CreateAssetOutput) SetEgressEndpoints(v []*EgressEndpoint) *CreateAssetOutput {
	s.EgressEndpoints = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAssetOutput) SetId(v string) *CreateAssetOutput {
	s.Id = &v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *CreateAssetOutput) SetPackagingGroupId(v string) *CreateAssetOutput {
	s.PackagingGroupId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateAssetOutput) SetResourceId(v string) *CreateAssetOutput {
	s.ResourceId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateAssetOutput) SetSourceArn(v string) *CreateAssetOutput {
	s.SourceArn = &v
	return s
}

// SetSourceRoleArn sets the SourceRoleArn field's value.
func (s *CreateAssetOutput) SetSourceRoleArn(v string) *CreateAssetOutput {
	s.SourceRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssetOutput) SetTags(v map[string]*string) *CreateAssetOutput {
	s.Tags = v
	return s
}

type CreatePackagingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A CMAF packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	// PackagingGroupId is a required field
	PackagingGroupId *string `locationName:"packagingGroupId" type:"string" required:"true"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackagingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackagingConfigurationInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.PackagingGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackagingGroupId"))
	}
	if s.CmafPackage != nil {
		if err := s.CmafPackage.Validate(); err != nil {
			invalidParams.AddNested("CmafPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.DashPackage != nil {
		if err := s.DashPackage.Validate(); err != nil {
			invalidParams.AddNested("DashPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsPackage != nil {
		if err := s.HlsPackage.Validate(); err != nil {
			invalidParams.AddNested("HlsPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.MssPackage != nil {
		if err := s.MssPackage.Validate(); err != nil {
			invalidParams.AddNested("MssPackage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *CreatePackagingConfigurationInput) SetCmafPackage(v *CmafPackage) *CreatePackagingConfigurationInput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *CreatePackagingConfigurationInput) SetDashPackage(v *DashPackage) *CreatePackagingConfigurationInput {
	s.DashPackage = v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *CreatePackagingConfigurationInput) SetHlsPackage(v *HlsPackage) *CreatePackagingConfigurationInput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *CreatePackagingConfigurationInput) SetId(v string) *CreatePackagingConfigurationInput {
	s.Id = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *CreatePackagingConfigurationInput) SetMssPackage(v *MssPackage) *CreatePackagingConfigurationInput {
	s.MssPackage = v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *CreatePackagingConfigurationInput) SetPackagingGroupId(v string) *CreatePackagingConfigurationInput {
	s.PackagingGroupId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePackagingConfigurationInput) SetTags(v map[string]*string) *CreatePackagingConfigurationInput {
	s.Tags = v
	return s
}

type CreatePackagingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A CMAF packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePackagingConfigurationOutput) SetArn(v string) *CreatePackagingConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *CreatePackagingConfigurationOutput) SetCmafPackage(v *CmafPackage) *CreatePackagingConfigurationOutput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *CreatePackagingConfigurationOutput) SetDashPackage(v *DashPackage) *CreatePackagingConfigurationOutput {
	s.DashPackage = v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *CreatePackagingConfigurationOutput) SetHlsPackage(v *HlsPackage) *CreatePackagingConfigurationOutput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *CreatePackagingConfigurationOutput) SetId(v string) *CreatePackagingConfigurationOutput {
	s.Id = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *CreatePackagingConfigurationOutput) SetMssPackage(v *MssPackage) *CreatePackagingConfigurationOutput {
	s.MssPackage = v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *CreatePackagingConfigurationOutput) SetPackagingGroupId(v string) *CreatePackagingConfigurationOutput {
	s.PackagingGroupId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePackagingConfigurationOutput) SetTags(v map[string]*string) *CreatePackagingConfigurationOutput {
	s.Tags = v
	return s
}

type CreatePackagingGroupInput struct {
	_ struct{} `type:"structure"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackagingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackagingGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Authorization != nil {
		if err := s.Authorization.Validate(); err != nil {
			invalidParams.AddNested("Authorization", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorization sets the Authorization field's value.
func (s *CreatePackagingGroupInput) SetAuthorization(v *Authorization) *CreatePackagingGroupInput {
	s.Authorization = v
	return s
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *CreatePackagingGroupInput) SetEgressAccessLogs(v *EgressAccessLogs) *CreatePackagingGroupInput {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *CreatePackagingGroupInput) SetId(v string) *CreatePackagingGroupInput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePackagingGroupInput) SetTags(v map[string]*string) *CreatePackagingGroupInput {
	s.Tags = v
	return s
}

type CreatePackagingGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackagingGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePackagingGroupOutput) SetArn(v string) *CreatePackagingGroupOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *CreatePackagingGroupOutput) SetAuthorization(v *Authorization) *CreatePackagingGroupOutput {
	s.Authorization = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreatePackagingGroupOutput) SetDomainName(v string) *CreatePackagingGroupOutput {
	s.DomainName = &v
	return s
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *CreatePackagingGroupOutput) SetEgressAccessLogs(v *EgressAccessLogs) *CreatePackagingGroupOutput {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *CreatePackagingGroupOutput) SetId(v string) *CreatePackagingGroupOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePackagingGroupOutput) SetTags(v map[string]*string) *CreatePackagingGroupOutput {
	s.Tags = v
	return s
}

// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
type DashEncryption struct {
	_ struct{} `type:"structure"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *DashEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *DashEncryption {
	s.SpekeKeyProvider = v
	return s
}

// A DASH manifest configuration.
type DashManifest struct {
	_ struct{} `type:"structure"`

	// Determines the position of some tags in the Media Presentation Description
	// (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection
	// are included in each Representation. When set to COMPACT, duplicate elements
	// are combined and presented at the AdaptationSet level.
	ManifestLayout *string `locationName:"manifestLayout" type:"string" enum:"ManifestLayout"`

	// An optional string to include in the name of the manifest.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// Minimum duration (in seconds) that a player will buffer media before starting
	// the presentation.
	MinBufferTimeSeconds *int64 `locationName:"minBufferTimeSeconds" type:"integer"`

	// The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to
	// "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
	Profile *string `locationName:"profile" type:"string" enum:"Profile"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashManifest) GoString() string {
	return s.String()
}

// SetManifestLayout sets the ManifestLayout field's value.
func (s *DashManifest) SetManifestLayout(v string) *DashManifest {
	s.ManifestLayout = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *DashManifest) SetManifestName(v string) *DashManifest {
	s.ManifestName = &v
	return s
}

// SetMinBufferTimeSeconds sets the MinBufferTimeSeconds field's value.
func (s *DashManifest) SetMinBufferTimeSeconds(v int64) *DashManifest {
	s.MinBufferTimeSeconds = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *DashManifest) SetProfile(v string) *DashManifest {
	s.Profile = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *DashManifest) SetStreamSelection(v *StreamSelection) *DashManifest {
	s.StreamSelection = v
	return s
}

// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
type DashPackage struct {
	_ struct{} `type:"structure"`

	// A list of DASH manifest configurations.
	//
	// DashManifests is a required field
	DashManifests []*DashManifest `locationName:"dashManifests" type:"list" required:"true"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
	Encryption *DashEncryption `locationName:"encryption" type:"structure"`

	// When includeEncoderConfigurationInSegments is set to true, MediaPackage places
	// your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS),
	// and Video Parameter Set (VPS) metadata in every video segment instead of
	// in the init fragment. This lets you use different SPS/PPS/VPS settings for
	// your assets during content playback.
	IncludeEncoderConfigurationInSegments *bool `locationName:"includeEncoderConfigurationInSegments" type:"boolean"`

	// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming
	// over HTTP (DASH)Media Presentation Description (MPD) will be partitioned
	// into multiple periods. If empty, the content will notbe partitioned into
	// more than one period. If the list contains "ADS", new periods will be created
	// wherethe Asset contains SCTE-35 ad markers.
	PeriodTriggers []*string `locationName:"periodTriggers" type:"list"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// Determines the type of SegmentTemplate included in the Media Presentation
	// Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented
	// in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE,
	// a full timeline is presented in each SegmentTemplate, with $Time$ media URLs.
	// When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate,
	// with $Number$ media URLs.
	SegmentTemplateFormat *string `locationName:"segmentTemplateFormat" type:"string" enum:"SegmentTemplateFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashPackage"}
	if s.DashManifests == nil {
		invalidParams.Add(request.NewErrParamRequired("DashManifests"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashManifests sets the DashManifests field's value.
func (s *DashPackage) SetDashManifests(v []*DashManifest) *DashPackage {
	s.DashManifests = v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *DashPackage) SetEncryption(v *DashEncryption) *DashPackage {
	s.Encryption = v
	return s
}

// SetIncludeEncoderConfigurationInSegments sets the IncludeEncoderConfigurationInSegments field's value.
func (s *DashPackage) SetIncludeEncoderConfigurationInSegments(v bool) *DashPackage {
	s.IncludeEncoderConfigurationInSegments = &v
	return s
}

// SetPeriodTriggers sets the PeriodTriggers field's value.
func (s *DashPackage) SetPeriodTriggers(v []*string) *DashPackage {
	s.PeriodTriggers = v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *DashPackage) SetSegmentDurationSeconds(v int64) *DashPackage {
	s.SegmentDurationSeconds = &v
	return s
}

// SetSegmentTemplateFormat sets the SegmentTemplateFormat field's value.
func (s *DashPackage) SetSegmentTemplateFormat(v string) *DashPackage {
	s.SegmentTemplateFormat = &v
	return s
}

type DeleteAssetInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteAssetInput) SetId(v string) *DeleteAssetInput {
	s.Id = &v
	return s
}

type DeleteAssetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) GoString() string {
	return s.String()
}

type DeletePackagingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackagingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackagingConfigurationInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeletePackagingConfigurationInput) SetId(v string) *DeletePackagingConfigurationInput {
	s.Id = &v
	return s
}

type DeletePackagingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePackagingGroupInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackagingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackagingGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeletePackagingGroupInput) SetId(v string) *DeletePackagingGroupInput {
	s.Id = &v
	return s
}

type DeletePackagingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackagingGroupOutput) GoString() string {
	return s.String()
}

type DescribeAssetInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeAssetInput) SetId(v string) *DescribeAssetInput {
	s.Id = &v
	return s
}

type DescribeAssetOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *string `locationName:"createdAt" type:"string"`

	EgressEndpoints []*EgressEndpoint `locationName:"egressEndpoints" type:"list"`

	Id *string `locationName:"id" type:"string"`

	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	ResourceId *string `locationName:"resourceId" type:"string"`

	SourceArn *string `locationName:"sourceArn" type:"string"`

	SourceRoleArn *string `locationName:"sourceRoleArn" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAssetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeAssetOutput) SetArn(v string) *DescribeAssetOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeAssetOutput) SetCreatedAt(v string) *DescribeAssetOutput {
	s.CreatedAt = &v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DescribeAssetOutput) SetEgressEndpoints(v []*EgressEndpoint) *DescribeAssetOutput {
	s.EgressEndpoints = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeAssetOutput) SetId(v string) *DescribeAssetOutput {
	s.Id = &v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *DescribeAssetOutput) SetPackagingGroupId(v string) *DescribeAssetOutput {
	s.PackagingGroupId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeAssetOutput) SetResourceId(v string) *DescribeAssetOutput {
	s.ResourceId = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *DescribeAssetOutput) SetSourceArn(v string) *DescribeAssetOutput {
	s.SourceArn = &v
	return s
}

// SetSourceRoleArn sets the SourceRoleArn field's value.
func (s *DescribeAssetOutput) SetSourceRoleArn(v string) *DescribeAssetOutput {
	s.SourceRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeAssetOutput) SetTags(v map[string]*string) *DescribeAssetOutput {
	s.Tags = v
	return s
}

type DescribePackagingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackagingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackagingConfigurationInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribePackagingConfigurationInput) SetId(v string) *DescribePackagingConfigurationInput {
	s.Id = &v
	return s
}

type DescribePackagingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A CMAF packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribePackagingConfigurationOutput) SetArn(v string) *DescribePackagingConfigurationOutput {
	s.Arn = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *DescribePackagingConfigurationOutput) SetCmafPackage(v *CmafPackage) *DescribePackagingConfigurationOutput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *DescribePackagingConfigurationOutput) SetDashPackage(v *DashPackage) *DescribePackagingConfigurationOutput {
	s.DashPackage = v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *DescribePackagingConfigurationOutput) SetHlsPackage(v *HlsPackage) *DescribePackagingConfigurationOutput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribePackagingConfigurationOutput) SetId(v string) *DescribePackagingConfigurationOutput {
	s.Id = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *DescribePackagingConfigurationOutput) SetMssPackage(v *MssPackage) *DescribePackagingConfigurationOutput {
	s.MssPackage = v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *DescribePackagingConfigurationOutput) SetPackagingGroupId(v string) *DescribePackagingConfigurationOutput {
	s.PackagingGroupId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribePackagingConfigurationOutput) SetTags(v map[string]*string) *DescribePackagingConfigurationOutput {
	s.Tags = v
	return s
}

type DescribePackagingGroupInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackagingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackagingGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribePackagingGroupInput) SetId(v string) *DescribePackagingGroupInput {
	s.Id = &v
	return s
}

type DescribePackagingGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagingGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribePackagingGroupOutput) SetArn(v string) *DescribePackagingGroupOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *DescribePackagingGroupOutput) SetAuthorization(v *Authorization) *DescribePackagingGroupOutput {
	s.Authorization = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribePackagingGroupOutput) SetDomainName(v string) *DescribePackagingGroupOutput {
	s.DomainName = &v
	return s
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *DescribePackagingGroupOutput) SetEgressAccessLogs(v *EgressAccessLogs) *DescribePackagingGroupOutput {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribePackagingGroupOutput) SetId(v string) *DescribePackagingGroupOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribePackagingGroupOutput) SetTags(v map[string]*string) *DescribePackagingGroupOutput {
	s.Tags = v
	return s
}

// Configure egress access logging.
type EgressAccessLogs struct {
	_ struct{} `type:"structure"`

	// Customize the log group name.
	LogGroupName *string `locationName:"logGroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressAccessLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressAccessLogs) GoString() string {
	return s.String()
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *EgressAccessLogs) SetLogGroupName(v string) *EgressAccessLogs {
	s.LogGroupName = &v
	return s
}

// The endpoint URL used to access an Asset using one PackagingConfiguration.
type EgressEndpoint struct {
	_ struct{} `type:"structure"`

	// The ID of the PackagingConfiguration being applied to the Asset.
	PackagingConfigurationId *string `locationName:"packagingConfigurationId" type:"string"`

	// The current processing status of the asset used for the packaging configuration.
	// The status can be either QUEUED, PROCESSING, PLAYABLE, or FAILED. Status
	// information won't be available for most assets ingested before 2021-09-30.
	Status *string `locationName:"status" type:"string"`

	// The URL of the parent manifest for the repackaged Asset.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressEndpoint) GoString() string {
	return s.String()
}

// SetPackagingConfigurationId sets the PackagingConfigurationId field's value.
func (s *EgressEndpoint) SetPackagingConfigurationId(v string) *EgressEndpoint {
	s.PackagingConfigurationId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EgressEndpoint) SetStatus(v string) *EgressEndpoint {
	s.Status = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *EgressEndpoint) SetUrl(v string) *EgressEndpoint {
	s.Url = &v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An HTTP Live Streaming (HLS) encryption configuration.
type HlsEncryption struct {
	_ struct{} `type:"structure"`

	// A constant initialization vector for encryption (optional).When not specified
	// the initialization vector will be periodically rotated.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The encryption method to use.
	EncryptionMethod *string `locationName:"encryptionMethod" type:"string" enum:"EncryptionMethod"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *HlsEncryption) SetConstantInitializationVector(v string) *HlsEncryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetEncryptionMethod sets the EncryptionMethod field's value.
func (s *HlsEncryption) SetEncryptionMethod(v string) *HlsEncryption {
	s.EncryptionMethod = &v
	return s
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *HlsEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *HlsEncryption {
	s.SpekeKeyProvider = v
	return s
}

// An HTTP Live Streaming (HLS) manifest configuration.
type HlsManifest struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers *string `locationName:"adMarkers" type:"string" enum:"AdMarkers"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// An optional string to include in the name of the manifest.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`

	// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
	RepeatExtXKey *bool `locationName:"repeatExtXKey" type:"boolean"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsManifest) GoString() string {
	return s.String()
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsManifest) SetAdMarkers(v string) *HlsManifest {
	s.AdMarkers = &v
	return s
}

// SetIncludeIframeOnlyStream sets the IncludeIframeOnlyStream field's value.
func (s *HlsManifest) SetIncludeIframeOnlyStream(v bool) *HlsManifest {
	s.IncludeIframeOnlyStream = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *HlsManifest) SetManifestName(v string) *HlsManifest {
	s.ManifestName = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *HlsManifest) SetProgramDateTimeIntervalSeconds(v int64) *HlsManifest {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetRepeatExtXKey sets the RepeatExtXKey field's value.
func (s *HlsManifest) SetRepeatExtXKey(v bool) *HlsManifest {
	s.RepeatExtXKey = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *HlsManifest) SetStreamSelection(v *StreamSelection) *HlsManifest {
	s.StreamSelection = v
	return s
}

// An HTTP Live Streaming (HLS) packaging configuration.
type HlsPackage struct {
	_ struct{} `type:"structure"`

	// An HTTP Live Streaming (HLS) encryption configuration.
	Encryption *HlsEncryption `locationName:"encryption" type:"structure"`

	// A list of HLS manifest configurations.
	//
	// HlsManifests is a required field
	HlsManifests []*HlsManifest `locationName:"hlsManifests" type:"list" required:"true"`

	// Duration (in seconds) of each fragment. Actual fragments will berounded to
	// the nearest multiple of the source fragment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// When enabled, audio streams will be placed in rendition groups in the output.
	UseAudioRenditionGroup *bool `locationName:"useAudioRenditionGroup" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsPackage"}
	if s.HlsManifests == nil {
		invalidParams.Add(request.NewErrParamRequired("HlsManifests"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *HlsPackage) SetEncryption(v *HlsEncryption) *HlsPackage {
	s.Encryption = v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *HlsPackage) SetHlsManifests(v []*HlsManifest) *HlsPackage {
	s.HlsManifests = v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *HlsPackage) SetSegmentDurationSeconds(v int64) *HlsPackage {
	s.SegmentDurationSeconds = &v
	return s
}

// SetUseAudioRenditionGroup sets the UseAudioRenditionGroup field's value.
func (s *HlsPackage) SetUseAudioRenditionGroup(v bool) *HlsPackage {
	s.UseAudioRenditionGroup = &v
	return s
}

type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAssetsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	PackagingGroupId *string `location:"querystring" locationName:"packagingGroupId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetsInput) SetMaxResults(v int64) *ListAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetsInput) SetNextToken(v string) *ListAssetsInput {
	s.NextToken = &v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *ListAssetsInput) SetPackagingGroupId(v string) *ListAssetsInput {
	s.PackagingGroupId = &v
	return s
}

type ListAssetsOutput struct {
	_ struct{} `type:"structure"`

	Assets []*AssetShallow `locationName:"assets" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetsOutput) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *ListAssetsOutput) SetAssets(v []*AssetShallow) *ListAssetsOutput {
	s.Assets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetsOutput) SetNextToken(v string) *ListAssetsOutput {
	s.NextToken = &v
	return s
}

type ListPackagingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	PackagingGroupId *string `location:"querystring" locationName:"packagingGroupId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagingConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagingConfigurationsInput) SetMaxResults(v int64) *ListPackagingConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagingConfigurationsInput) SetNextToken(v string) *ListPackagingConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *ListPackagingConfigurationsInput) SetPackagingGroupId(v string) *ListPackagingConfigurationsInput {
	s.PackagingGroupId = &v
	return s
}

type ListPackagingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	PackagingConfigurations []*PackagingConfiguration `locationName:"packagingConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagingConfigurationsOutput) SetNextToken(v string) *ListPackagingConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetPackagingConfigurations sets the PackagingConfigurations field's value.
func (s *ListPackagingConfigurationsOutput) SetPackagingConfigurations(v []*PackagingConfiguration) *ListPackagingConfigurationsOutput {
	s.PackagingConfigurations = v
	return s
}

type ListPackagingGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagingGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagingGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagingGroupsInput) SetMaxResults(v int64) *ListPackagingGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagingGroupsInput) SetNextToken(v string) *ListPackagingGroupsInput {
	s.NextToken = &v
	return s
}

type ListPackagingGroupsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	PackagingGroups []*PackagingGroup `locationName:"packagingGroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagingGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagingGroupsOutput) SetNextToken(v string) *ListPackagingGroupsOutput {
	s.NextToken = &v
	return s
}

// SetPackagingGroups sets the PackagingGroups field's value.
func (s *ListPackagingGroupsOutput) SetPackagingGroups(v []*PackagingGroup) *ListPackagingGroupsOutput {
	s.PackagingGroups = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A Microsoft Smooth Streaming (MSS) encryption configuration.
type MssEncryption struct {
	_ struct{} `type:"structure"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MssEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MssEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MssEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MssEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *MssEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *MssEncryption {
	s.SpekeKeyProvider = v
	return s
}

// A Microsoft Smooth Streaming (MSS) manifest configuration.
type MssManifest struct {
	_ struct{} `type:"structure"`

	// An optional string to include in the name of the manifest.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MssManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MssManifest) GoString() string {
	return s.String()
}

// SetManifestName sets the ManifestName field's value.
func (s *MssManifest) SetManifestName(v string) *MssManifest {
	s.ManifestName = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *MssManifest) SetStreamSelection(v *StreamSelection) *MssManifest {
	s.StreamSelection = v
	return s
}

// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
type MssPackage struct {
	_ struct{} `type:"structure"`

	// A Microsoft Smooth Streaming (MSS) encryption configuration.
	Encryption *MssEncryption `locationName:"encryption" type:"structure"`

	// A list of MSS manifest configurations.
	//
	// MssManifests is a required field
	MssManifests []*MssManifest `locationName:"mssManifests" type:"list" required:"true"`

	// The duration (in seconds) of each segment.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MssPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MssPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MssPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MssPackage"}
	if s.MssManifests == nil {
		invalidParams.Add(request.NewErrParamRequired("MssManifests"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *MssPackage) SetEncryption(v *MssEncryption) *MssPackage {
	s.Encryption = v
	return s
}

// SetMssManifests sets the MssManifests field's value.
func (s *MssPackage) SetMssManifests(v []*MssManifest) *MssPackage {
	s.MssManifests = v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *MssPackage) SetSegmentDurationSeconds(v int64) *MssPackage {
	s.SegmentDurationSeconds = &v
	return s
}

type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A MediaPackage VOD PackagingConfiguration resource.
type PackagingConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the PackagingConfiguration.
	Arn *string `locationName:"arn" type:"string"`

	// A CMAF packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	// The ID of the PackagingConfiguration.
	Id *string `locationName:"id" type:"string"`

	// A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	// The ID of a PackagingGroup.
	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackagingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackagingConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PackagingConfiguration) SetArn(v string) *PackagingConfiguration {
	s.Arn = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *PackagingConfiguration) SetCmafPackage(v *CmafPackage) *PackagingConfiguration {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *PackagingConfiguration) SetDashPackage(v *DashPackage) *PackagingConfiguration {
	s.DashPackage = v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *PackagingConfiguration) SetHlsPackage(v *HlsPackage) *PackagingConfiguration {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *PackagingConfiguration) SetId(v string) *PackagingConfiguration {
	s.Id = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *PackagingConfiguration) SetMssPackage(v *MssPackage) *PackagingConfiguration {
	s.MssPackage = v
	return s
}

// SetPackagingGroupId sets the PackagingGroupId field's value.
func (s *PackagingConfiguration) SetPackagingGroupId(v string) *PackagingConfiguration {
	s.PackagingGroupId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PackagingConfiguration) SetTags(v map[string]*string) *PackagingConfiguration {
	s.Tags = v
	return s
}

// A MediaPackage VOD PackagingGroup resource.
type PackagingGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the PackagingGroup.
	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// The fully qualified domain name for Assets in the PackagingGroup.
	DomainName *string `locationName:"domainName" type:"string"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	// The ID of the PackagingGroup.
	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackagingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackagingGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PackagingGroup) SetArn(v string) *PackagingGroup {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *PackagingGroup) SetAuthorization(v *Authorization) *PackagingGroup {
	s.Authorization = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *PackagingGroup) SetDomainName(v string) *PackagingGroup {
	s.DomainName = &v
	return s
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *PackagingGroup) SetEgressAccessLogs(v *EgressAccessLogs) *PackagingGroup {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *PackagingGroup) SetId(v string) *PackagingGroup {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PackagingGroup) SetTags(v map[string]*string) *PackagingGroup {
	s.Tags = v
	return s
}

type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A configuration for accessing an external Secure Packager and Encoder Key
// Exchange (SPEKE) service that will provide encryption keys.
type SpekeKeyProvider struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) of an IAM role that AWS ElementalMediaPackage
	// will assume when accessing the key provider service.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The system IDs to include in key requests.
	//
	// SystemIds is a required field
	SystemIds []*string `locationName:"systemIds" type:"list" required:"true"`

	// The URL of the external key provider service.
	//
	// Url is a required field
	Url *string `locationName:"url" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpekeKeyProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpekeKeyProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpekeKeyProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SpekeKeyProvider"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SystemIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SystemIds"))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *SpekeKeyProvider) SetRoleArn(v string) *SpekeKeyProvider {
	s.RoleArn = &v
	return s
}

// SetSystemIds sets the SystemIds field's value.
func (s *SpekeKeyProvider) SetSystemIds(v []*string) *SpekeKeyProvider {
	s.SystemIds = v
	return s
}

// SetUrl sets the Url field's value.
func (s *SpekeKeyProvider) SetUrl(v string) *SpekeKeyProvider {
	s.Url = &v
	return s
}

// A StreamSelection configuration.
type StreamSelection struct {
	_ struct{} `type:"structure"`

	// The maximum video bitrate (bps) to include in output.
	MaxVideoBitsPerSecond *int64 `locationName:"maxVideoBitsPerSecond" type:"integer"`

	// The minimum video bitrate (bps) to include in output.
	MinVideoBitsPerSecond *int64 `locationName:"minVideoBitsPerSecond" type:"integer"`

	// A directive that determines the order of streams in the output.
	StreamOrder *string `locationName:"streamOrder" type:"string" enum:"StreamOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSelection) GoString() string {
	return s.String()
}

// SetMaxVideoBitsPerSecond sets the MaxVideoBitsPerSecond field's value.
func (s *StreamSelection) SetMaxVideoBitsPerSecond(v int64) *StreamSelection {
	s.MaxVideoBitsPerSecond = &v
	return s
}

// SetMinVideoBitsPerSecond sets the MinVideoBitsPerSecond field's value.
func (s *StreamSelection) SetMinVideoBitsPerSecond(v int64) *StreamSelection {
	s.MinVideoBitsPerSecond = &v
	return s
}

// SetStreamOrder sets the StreamOrder field's value.
func (s *StreamSelection) SetStreamOrder(v string) *StreamSelection {
	s.StreamOrder = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UnprocessableEntityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessableEntityException) GoString() string {
	return s.String()
}

func newErrorUnprocessableEntityException(v protocol.ResponseMetadata) error {
	return &UnprocessableEntityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnprocessableEntityException) Code() string {
	return "UnprocessableEntityException"
}

// Message returns the exception's message.
func (s *UnprocessableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnprocessableEntityException) OrigErr() error {
	return nil
}

func (s *UnprocessableEntityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnprocessableEntityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnprocessableEntityException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdatePackagingGroupInput struct {
	_ struct{} `type:"structure"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackagingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackagingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackagingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePackagingGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Authorization != nil {
		if err := s.Authorization.Validate(); err != nil {
			invalidParams.AddNested("Authorization", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorization sets the Authorization field's value.
func (s *UpdatePackagingGroupInput) SetAuthorization(v *Authorization) *UpdatePackagingGroupInput {
	s.Authorization = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdatePackagingGroupInput) SetId(v string) *UpdatePackagingGroupInput {
	s.Id = &v
	return s
}

type UpdatePackagingGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`

	// Configure egress access logging.
	EgressAccessLogs *EgressAccessLogs `locationName:"egressAccessLogs" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackagingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackagingGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePackagingGroupOutput) SetArn(v string) *UpdatePackagingGroupOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *UpdatePackagingGroupOutput) SetAuthorization(v *Authorization) *UpdatePackagingGroupOutput {
	s.Authorization = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdatePackagingGroupOutput) SetDomainName(v string) *UpdatePackagingGroupOutput {
	s.DomainName = &v
	return s
}

// SetEgressAccessLogs sets the EgressAccessLogs field's value.
func (s *UpdatePackagingGroupOutput) SetEgressAccessLogs(v *EgressAccessLogs) *UpdatePackagingGroupOutput {
	s.EgressAccessLogs = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdatePackagingGroupOutput) SetId(v string) *UpdatePackagingGroupOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdatePackagingGroupOutput) SetTags(v map[string]*string) *UpdatePackagingGroupOutput {
	s.Tags = v
	return s
}

const (
	// AdMarkersNone is a AdMarkers enum value
	AdMarkersNone = "NONE"

	// AdMarkersScte35Enhanced is a AdMarkers enum value
	AdMarkersScte35Enhanced = "SCTE35_ENHANCED"

	// AdMarkersPassthrough is a AdMarkers enum value
	AdMarkersPassthrough = "PASSTHROUGH"
)

// AdMarkers_Values returns all elements of the AdMarkers enum
func AdMarkers_Values() []string {
	return []string{
		AdMarkersNone,
		AdMarkersScte35Enhanced,
		AdMarkersPassthrough,
	}
}

const (
	// EncryptionMethodAes128 is a EncryptionMethod enum value
	EncryptionMethodAes128 = "AES_128"

	// EncryptionMethodSampleAes is a EncryptionMethod enum value
	EncryptionMethodSampleAes = "SAMPLE_AES"
)

// EncryptionMethod_Values returns all elements of the EncryptionMethod enum
func EncryptionMethod_Values() []string {
	return []string{
		EncryptionMethodAes128,
		EncryptionMethodSampleAes,
	}
}

const (
	// ManifestLayoutFull is a ManifestLayout enum value
	ManifestLayoutFull = "FULL"

	// ManifestLayoutCompact is a ManifestLayout enum value
	ManifestLayoutCompact = "COMPACT"
)

// ManifestLayout_Values returns all elements of the ManifestLayout enum
func ManifestLayout_Values() []string {
	return []string{
		ManifestLayoutFull,
		ManifestLayoutCompact,
	}
}

const (
	// PeriodTriggersElementAds is a PeriodTriggersElement enum value
	PeriodTriggersElementAds = "ADS"
)

// PeriodTriggersElement_Values returns all elements of the PeriodTriggersElement enum
func PeriodTriggersElement_Values() []string {
	return []string{
		PeriodTriggersElementAds,
	}
}

const (
	// ProfileNone is a Profile enum value
	ProfileNone = "NONE"

	// ProfileHbbtv15 is a Profile enum value
	ProfileHbbtv15 = "HBBTV_1_5"
)

// Profile_Values returns all elements of the Profile enum
func Profile_Values() []string {
	return []string{
		ProfileNone,
		ProfileHbbtv15,
	}
}

const (
	// SegmentTemplateFormatNumberWithTimeline is a SegmentTemplateFormat enum value
	SegmentTemplateFormatNumberWithTimeline = "NUMBER_WITH_TIMELINE"

	// SegmentTemplateFormatTimeWithTimeline is a SegmentTemplateFormat enum value
	SegmentTemplateFormatTimeWithTimeline = "TIME_WITH_TIMELINE"

	// SegmentTemplateFormatNumberWithDuration is a SegmentTemplateFormat enum value
	SegmentTemplateFormatNumberWithDuration = "NUMBER_WITH_DURATION"
)

// SegmentTemplateFormat_Values returns all elements of the SegmentTemplateFormat enum
func SegmentTemplateFormat_Values() []string {
	return []string{
		SegmentTemplateFormatNumberWithTimeline,
		SegmentTemplateFormatTimeWithTimeline,
		SegmentTemplateFormatNumberWithDuration,
	}
}

const (
	// StreamOrderOriginal is a StreamOrder enum value
	StreamOrderOriginal = "ORIGINAL"

	// StreamOrderVideoBitrateAscending is a StreamOrder enum value
	StreamOrderVideoBitrateAscending = "VIDEO_BITRATE_ASCENDING"

	// StreamOrderVideoBitrateDescending is a StreamOrder enum value
	StreamOrderVideoBitrateDescending = "VIDEO_BITRATE_DESCENDING"
)

// StreamOrder_Values returns all elements of the StreamOrder enum
func StreamOrder_Values() []string {
	return []string{
		StreamOrderOriginal,
		StreamOrderVideoBitrateAscending,
		StreamOrderVideoBitrateDescending,
	}
}
