// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (397B)
// assets/dns/daemonset.yaml (6.128kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (520B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x90\xb1\x4e\xc4\x30\x10\x44\x7b\x7f\x85\x75\xfd\x05\xd1\xa1\xb4\x14\xf4\x14\xf4\x1b\x67\x50\x96\xe4\x76\xad\xdd\x75\x4e\xe2\xeb\x51\x2e\x57\xa0\x8b\xa0\x9b\x19\xd9\xf3\x3c\x9e\x59\xc6\x3e\xbf\x2e\xcd\x03\xf6\xae\x0b\x12\x55\xfe\x80\x39\xab\xf4\xd9\x06\x2a\x1d\xb5\x98\xd4\xf8\x9b\x82\x55\xba\xf9\xc5\x3b\xd6\xa7\xf5\x39\x5d\x10\x34\x52\x50\x9f\x72\x16\xba\xa0\xcf\x5a\x21\x3e\xf1\x67\x9c\x47\xf1\x64\x6d\x81\xf7\xe9\x9c\xa9\xf2\x9b\x69\xab\xbe\x9d\x3c\xe7\xd3\x29\xe5\x6c\x70\x6d\x56\x70\xcf\x20\x63\x55\x96\xf0\x9b\x73\xd8\xca\x05\xbb\xa9\x3a\xee\x62\x63\x78\xa5\x3d\x5f\x61\xc3\xfd\xee\xc2\x1e\x37\x71\xa5\x28\x53\x3a\x02\xb7\x01\x90\xe0\xf2\x7b\xc1\xf1\x0d\xa1\x33\xc4\xb0\x32\xae\x0f\x84\x62\xa0\xc0\x1f\xcd\x8f\x5f\x73\x2c\xf6\x36\x7c\xa1\x04\x95\x02\xf7\xff\x00\x3f\x01\x00\x00\xff\xff\x76\x1b\x55\x2e\x8d\x01\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 397, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x84, 0xae, 0xd1, 0xba, 0xfa, 0x6b, 0xf8, 0x6e, 0x8d, 0x28, 0xc2, 0xa7, 0xaf, 0xc9, 0x3b, 0xc7, 0xcd, 0x80, 0xbe, 0xec, 0x98, 0xb4, 0x61, 0xa0, 0x9, 0xae, 0xa, 0xd8, 0xb2, 0x2e, 0x16, 0xf2}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x58\x5d\x73\xdb\xb6\xd2\xbe\xf7\xaf\xd8\xd2\x9e\x38\x79\x6b\x4a\x72\x12\xa7\x79\x99\xb8\xa7\xaa\x2c\xd7\x9e\x46\xb6\xc6\x52\x9a\x0b\x8f\x47\x03\x81\x2b\x11\x47\x20\x80\x02\x20\x6d\x8d\xed\xff\x7e\x06\xa4\x28\xf1\x43\x51\x9a\x73\xa6\x33\xcd\x85\x22\x63\x77\x1f\xec\x2e\xf6\x53\x0b\x26\xc2\x00\xce\x08\xc6\x52\x8c\xd0\xee\x11\xc5\xfe\x40\x6d\x98\x14\x01\x10\xa5\x4c\x3b\x3d\xde\xdb\x07\x41\x62\x3c\xca\x3e\x8d\x22\x14\x81\x88\x10\x38\x99\x22\x37\x40\x34\x82\x41\x0b\xc4\x82\x4e\x84\x65\x31\xee\x19\x85\x34\xd8\x03\xb0\x18\x2b\x4e\x2c\xba\xef\x00\xc5\x69\xf6\x1d\x75\xca\x28\x76\x29\x95\x89\xb0\x57\x24\xc6\x00\x42\x61\x56\x54\xa5\x99\xd4\xcc\x2e\x7b\x9c\x18\x93\x13\xcd\xd2\x58\x8c\x7d\x21\x43\xf4\xa9\x66\x96\x51\xc2\x57\xdc\x54\x0a\x4b\x98\x40\x6d\x0a\x74\x3f\xd3\xb4\x8c\x08\xb0\x0f\x2c\x26\x73\x04\x66\xea\xda\x16\x1c\x19\x7d\x98\x70\x3e\x94\x9c\xd1\x65\x00\x97\xb3\x2b\x69\x87\x1a\x0d\x0a\xbb\xe6\xb2\xa8\x63\x26\x88\x65\x52\x0c\xd0\x18\x27\xb2\x62\x3f\x27\x9c\x4f\x09\x5d\x8c\xe5\x27\x39\x37\xd7\xa2\xaf\xb5\xd4\x6b\x39\x2a\xe3\x98\x38\x57\xdf\x82\x47\xa5\xc6\x50\x18\x0f\xee\xd6\x64\xa2\xe7\x26\xa3\xf9\x54\x8a\x99\x77\x04\x5e\x1b\x2d\x6d\xaf\x38\xdb\x3d\xa9\x71\xc6\x38\x96\x45\x52\xc9\x93\x18\x07\xce\x81\x6b\xcb\x37\xb6\x3b\x18\x36\xf7\x73\xa6\x35\x15\x20\x76\xfc\x43\x62\xa3\x00\xca\x37\x94\x38\x34\x92\xf0\x5a\xf0\x65\x00\x56\x27\x1b\x51\x25\x75\xf5\x9e\xb5\xdf\x87\x52\xdb\x00\x4e\xde\x9c\xbc\x29\xa1\x34\x5f\xc0\xbd\xab\xb4\x92\x4a\x1e\xc0\xe7\xb3\xe1\xf7\x23\xf9\x96\xaa\xad\x68\xe3\xde\x06\xcd\x69\xcf\x04\x1a\x33\xd4\x72\x8a\x41\x89\x3f\xb2\x56\xfd\x86\xb6\x7c\x04\xa0\x72\x4f\x44\x48\xb8\x8d\xaa\x94\x4c\x97\xf7\x9d\xf7\x9d\xca\xb1\xa1\x11\x3a\x7d\x2e\xc6\xe3\x61\x89\xc0\x04\xb3\x8c\xf0\x33\xe4\x64\x39\x42\x2a\x45\x68\x02\x38\x2e\x8b\x2a\xd4\x4c\x86\xdb\x69\x26\xa1\x14\x8d\x19\x47\x1a\x4d\x24\x79\x18\xc0\x71\x89\x3a\x23\x8c\x27\x1a\x4b\xd4\xb2\x7b\x5c\x0c\xcb\xc4\x6e\x03\xe6\x2c\xc5\x7f\x88\x2b\xde\x75\x76\xa8\x7c\xf2\x3f\xb8\xe2\xa4\xf4\xf2\x46\x26\x9a\xa2\x29\x9b\xc5\x59\xcc\xac\xa9\x1a\x1a\x63\x2c\xf5\x32\x80\x93\xe3\xd7\x03\x56\x09\xfc\x3f\x13\x34\x75\x6e\xaa\x92\x00\x4e\x3a\xf1\x56\x88\x9f\x3a\x6b\x84\x22\xf1\x16\xc9\x14\x7d\x3d\x25\xd4\x57\x5a\x3e\x2c\xbf\xa3\x00\x65\x35\xa0\x94\x16\xbe\xcf\xe5\xdc\x4a\x63\x43\xd4\xba\x72\x6e\x90\x26\x1a\x7d\xce\x8c\x45\xe1\x93\x30\xd4\x68\xcc\x69\xf0\xff\xc7\x27\x6f\x2b\x7c\x96\x1b\x9f\x32\x15\xa1\xf6\x4d\xc2\x2c\x9a\xd3\xf1\xa7\xd1\xa4\xdf\x3b\xbb\xe8\x4f\x6e\x46\xdd\xc9\x97\xcb\xf1\xc5\xa4\xdb\x1f\x4d\x8e\x5f\xbf\x9f\xfc\xd6\x1b\x4c\x46\x17\xdd\xd7\x27\xef\x8e\x36\x5c\xfd\xde\xd9\x37\xf8\x1a\x38\xbd\x5f\x7b\x7f\x09\x67\x2b\xdf\x0e\xb4\x8a\x65\x89\x32\x56\x23\x89\x4f\x5d\x28\x07\xed\xf6\xf1\xeb\x9f\x5a\x9d\x56\xa7\x75\xec\x9c\xf0\xa6\xdd\xf4\x02\x6a\xeb\xbb\x0a\x7a\x9a\x55\x3d\xcb\x4d\x5b\x69\x96\x12\x8b\xee\x7b\x8b\x6a\xdb\x10\x59\xd1\xfd\x05\x2e\x77\x48\x2e\x70\xf9\x97\x4b\x64\xe5\x7d\x8a\xc2\x16\xa3\xd5\x8c\x9a\xdd\x61\xbc\x23\x34\x8f\xbf\x12\x9a\x6f\x3b\xa5\xe0\xfe\x5a\xaf\xa8\x77\x83\x92\x75\x5f\x53\xd4\xf9\xe6\x5b\xdd\xa2\xd4\x80\xf3\x96\xed\x8c\xe2\x29\xea\x7f\x4c\x3b\xce\x32\xc8\x8d\x18\x52\x58\x7c\xa8\x54\x42\x67\x3f\xe3\x38\xc7\xb0\xd6\x01\x77\x37\xdc\x48\x1a\x6b\xb2\x40\xd9\xd1\x6d\x33\xa6\x92\x13\x50\xa4\x70\xd5\x1d\xf4\x47\xfd\x9b\x3f\xfa\x37\xd9\x58\xd5\xfb\xf4\x79\x34\xee\xdf\x4c\xce\xae\x07\xdd\xcb\xab\x6d\xe3\x55\x21\x8e\x22\x6d\xaa\xe1\x90\x2e\x7b\xfd\x51\x49\x89\x7d\xe8\xb9\xe1\x03\xa4\x86\x7c\x7a\x33\xa8\x88\x26\x16\x43\x70\x15\x04\xe4\xac\x98\xc7\x4c\x45\xea\xea\x7a\xdc\x0f\xe0\x5c\x6a\x10\xf2\xfe\x08\x50\x98\x44\x23\xd8\x08\x0d\x66\x6a\x69\xe4\xc4\xb2\x14\xf3\xb9\xf0\x03\xcc\xa4\x06\x24\x34\xaa\x12\x8e\x2a\x98\x44\x00\xe1\x8c\x18\xb8\x67\x36\x72\x58\x75\x7b\x4d\x32\x9b\xb1\x07\xb8\x67\x9c\x03\xe1\x46\xc2\x14\x81\x84\x21\x86\xad\x12\x4e\x4a\x78\x82\x01\x78\x59\x8c\xf8\x1a\xe7\xcc\x58\xbd\x6c\x49\x85\xc2\x44\x6c\x66\xfd\x1a\xc1\xa4\xd4\x6b\x4c\x62\x25\xd7\xb5\xa7\x4c\xb4\xa7\xc4\x44\xe5\x22\x40\x4b\x7f\x3c\x95\x8d\xf8\xa1\xc9\x0e\xd9\x1b\xf9\x89\x04\xc5\x14\xba\x2e\xb5\x57\xee\x77\x9a\x28\x38\xfc\xb7\x9c\x1a\xf0\x15\x3c\xc1\x83\xab\xf4\xb0\x70\x26\x3e\x3d\x65\x31\xf6\x01\xee\x09\xb3\x1f\x00\x1f\x98\x85\xce\x21\x8c\xfb\x37\x83\x32\xc2\xf5\xb0\x7f\x35\xba\xb8\x3c\x1f\x4f\x06\xdd\x9b\xdf\xfb\x37\xa7\xde\xc6\xd6\x39\x0a\xcc\x5e\xb3\x9a\x6a\x5e\x49\xfc\xe2\x7a\x34\x1e\x4d\xce\x2f\x3f\xf5\x4f\xbd\x4d\x1c\x96\x39\xc6\xfd\xc1\xb0\xc1\xd0\xb2\xb1\xf2\xca\x6a\x5c\x9e\x8f\x4e\x0f\x8f\xe0\x30\xcb\x7a\xf0\x35\xf8\x64\x1d\x3a\xf0\xf1\xe3\x47\xf0\x0e\x1e\x8b\x00\x7c\xae\x48\xee\xc3\x80\x2c\x10\x48\xb6\x13\x48\x4d\xf4\x12\x5c\xaa\x6c\xc2\x40\xf2\x30\x4f\xa1\xec\xfc\xd0\x00\xb1\x56\xb3\x69\x62\xd1\x94\x5f\x9e\x2a\xf0\x67\xe0\xfb\x1b\xaa\x2f\x05\x5f\xba\x8b\x37\x46\x3e\x7b\xee\xef\xb5\x49\x55\x4d\xee\x23\x77\x6f\xee\xf4\x50\x56\x4a\x67\x88\x94\xbb\xc0\xf6\xbb\x60\x52\x3a\x61\xca\x54\xc8\x2e\xbe\x4d\x4a\x81\x09\x07\x5f\xd8\x7d\xfb\xcb\xdd\xb3\xd7\x80\x72\x16\x9f\xa3\xa5\x51\xe1\x1f\xb8\x1c\xc2\x4c\xcb\x18\x28\x4f\x8c\x45\xed\x6a\x23\xb0\x19\xa8\xbc\xa0\xb5\xe0\x0b\x42\xec\x5c\x64\x30\x45\x4d\x38\x58\xcd\xd0\x34\x30\xad\x84\x50\x02\xb3\x01\x5c\x0e\xd3\xb7\x47\xee\xf3\x5d\xf6\xf9\x16\x64\x8a\xda\x8d\xc2\x59\x15\x71\xe7\xeb\x93\x16\x8c\x23\x04\x7b\x2f\x81\x13\x97\xef\x62\x0b\xb0\xb3\xdb\x19\x18\xa2\xe2\x72\x19\xa3\xb0\xab\x1c\xfd\x3d\xd1\x4b\x0d\x52\xb8\x17\x42\x0d\xd7\x0a\xc5\xc8\x12\xba\x80\x97\xd7\xa3\xe1\xf1\x9b\x57\xe0\x83\x8d\xa4\x41\xa7\x97\x90\xb6\x01\x6c\x12\xe5\xfa\xa2\x1b\xf9\x81\x4b\x12\x4e\x09\x27\x82\xa2\x36\x99\x9e\xae\xb1\xb1\xac\x96\x10\x1a\x31\x31\x87\xb3\xab\x11\xd8\x48\xcb\x64\x1e\x65\xaa\xd7\xf0\x68\x1c\x9a\xd3\x97\x87\x21\x9b\x83\x6f\xa1\x0b\xbf\x78\x07\x8f\x9b\x02\xfa\xec\xc1\x8f\x26\x72\xb7\xb9\x07\x4a\xe9\x73\xeb\xe0\xb1\x5a\x5f\x9e\xbd\xc3\x1a\x62\xfe\x6f\x8d\xd8\xed\xfe\x0d\xa0\xf0\xa3\xa5\xea\xef\xd1\xf5\xbf\x45\x7e\x55\x83\x76\x6f\xcf\x5c\x68\x1f\x3c\xfe\xe0\x9c\x7c\xfb\x7f\x77\xcf\x35\x96\x46\x88\x03\x30\x65\x4e\x5f\x1e\xbc\xc4\x94\x70\x77\x59\x26\xc8\xee\x9e\xbd\x57\x75\x78\x70\xb1\x7e\x7b\x0b\xde\xc1\xbf\x3c\xf0\xf1\x4f\xe8\xc0\x8b\x17\x4e\x64\x9f\xa9\x3c\x85\xc0\x17\x08\x1d\xb8\xbb\xfb\xe0\xea\x81\xd8\x62\xf9\x2a\x27\x6f\x57\x56\x79\x77\xa7\xde\xc1\x63\x21\xbe\x85\x7f\xaa\x91\x2c\x1a\xe7\x33\xd6\x30\x4b\xe0\x5e\xe3\xa0\x72\xb2\x0f\x9f\x55\x48\x2c\x96\x9a\x38\x64\x65\x87\xcd\xe0\x1e\x61\x8e\xd6\xb5\x24\x16\x96\x92\xdd\xd4\x00\xbe\x60\xde\xd3\x84\xb4\x90\x34\xc0\xee\x23\x14\xce\x6c\x9d\x4d\x44\xab\x9d\x7c\x8d\x26\x13\xeb\x66\x25\xa9\x81\x28\x06\x89\x20\x29\x61\x9c\x4c\x19\x67\x76\x59\xbb\x66\x64\x09\x47\x40\x91\x55\x0f\xa0\x32\xe1\xa1\x6b\x2a\xc6\xba\xa7\x2d\x5d\xc8\x66\x59\xd5\x2d\x6e\x60\x06\x42\xe4\x68\x31\xdc\xdb\xf6\x66\x8f\xfb\x85\xef\xbf\xfd\x52\xfb\xf0\x6b\xc2\x78\x08\x04\x04\xde\x97\x4a\x7a\x5e\xfd\xca\x36\xbb\xea\x22\x13\x0d\x34\x31\x56\xc6\x6b\xa5\x67\x8c\x5b\xd4\x18\x3a\xb3\x6b\xd8\x73\x8d\x0a\xfc\x14\xbc\x7d\x38\x78\xac\xf7\xc4\xbc\xea\x57\xba\xc0\xcf\x3b\xfa\x40\xae\x6b\x57\x29\xcc\xca\x50\xde\x34\x37\x4a\xb8\x5a\xdf\x1c\x8a\xa0\xd1\x06\x7e\x28\x7b\x66\x4b\x1b\x58\x65\x96\xca\x53\xab\x60\xce\x23\xf8\xee\x79\xab\x00\x00\xd2\x48\x42\x16\xdc\xcf\xb9\x50\xf1\x5f\x33\x93\xe1\x2b\xae\xf8\xb9\x61\x7b\xfd\x92\x46\xdc\x6f\x8b\x7c\xe7\xa3\xf1\xf5\xd9\x75\xb0\x25\x03\x88\x95\x31\xa3\x84\xf3\xa5\x6b\x4b\x24\x95\x2c\x04\x22\x96\xc0\x04\x95\xc2\x64\xbb\xa9\x85\x29\x46\x24\x65\xa5\xc9\xbb\x40\xbd\x41\xc5\xdd\x30\xba\x2d\x22\x62\x19\xb2\x19\xc3\x10\xd2\xfc\xa7\x48\x17\x88\x02\x31\xac\x85\xa7\x6b\x07\xaa\x66\x66\x23\x06\x9e\x9e\x56\x43\xc3\x6e\xbe\xa6\xd5\x05\xaf\x4b\x0e\x97\xb5\x1a\x63\x99\x62\xb8\xb1\x35\x8b\x6a\xaa\xd1\xad\x82\x79\xf6\x64\x2d\x6d\x33\x9a\x00\x95\x6a\x09\x34\x4a\x74\x35\x49\x6a\x25\xc8\x70\x44\x05\xef\x3a\xf0\x22\x9b\x02\x2b\xb4\x44\xb8\xc1\xb2\x39\x8d\x54\x1e\xef\x7b\x57\xc6\x93\x62\x63\x0c\x85\x29\xd6\xa5\x33\x9c\x91\x84\x17\x97\xbb\x49\x72\x84\x1c\xa9\x95\x7a\x03\xb0\x48\xa6\xa8\x05\xba\x91\x8c\xc9\xb6\x34\x01\x70\x26\x92\x87\x9c\xb8\xe2\xca\x97\xa4\xc6\x4f\xb1\xdb\x7f\x8e\xcc\x4f\x07\x44\x05\xa5\x9d\xe8\x8a\xc4\xbb\xf6\x42\x00\x66\x31\xae\x98\xe5\xc3\x02\x97\x01\x14\x3f\x92\x6e\xf9\x55\xab\x46\xda\xb1\xb3\xb9\xa3\x6c\x61\xdb\xab\x63\x6c\x59\xe0\x00\xec\x52\x61\x00\xe7\x4d\xe8\x6d\xdb\xf2\xbe\x5b\x3b\x35\xda\x9d\x16\x5a\xc9\xdd\x38\xcf\xa4\x58\xdb\xb8\x9f\x4d\x45\x2e\x01\x8c\x8b\x3e\x9d\x08\x70\x43\xe2\xf2\xde\x35\x8c\x16\x8c\x73\x09\x04\xc2\x39\x58\xc2\xc4\x5a\x43\x1f\xa4\x72\x24\xa9\x03\xe8\xbb\x2e\x60\xf6\xfe\x13\x00\x00\xff\xff\x6c\xee\x06\x32\xf0\x17\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 6128, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x3a, 0x10, 0x64, 0xe4, 0x12, 0x1e, 0x52, 0xa5, 0xeb, 0x20, 0xbe, 0x53, 0xbd, 0xad, 0x9b, 0xaa, 0xce, 0x29, 0x63, 0xe4, 0x2, 0xed, 0x4b, 0x75, 0xb2, 0xe8, 0x60, 0x30, 0xac, 0x25, 0xce, 0xd2}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x91\x31\x6f\xe2\x40\x10\x85\x7b\xff\x8a\x27\xe8\x4e\xc0\x09\xdd\x51\x9c\xdb\xa3\x89\x52\x80\x14\x48\x3f\x5e\x4f\xcc\x8a\xf5\x8c\xb5\x33\x06\xf1\xef\x23\x4c\x42\x80\x14\x69\x56\xda\x7d\x9f\x3e\x3d\xbd\xdd\x47\xa9\x4b\xbc\x70\x3e\xc4\xc0\x05\x75\xf1\x95\xb3\x45\x95\x12\x87\x79\x31\x86\x50\xcb\x93\xe1\xb4\x8e\x02\x4f\x12\x55\x9c\x0c\x24\x35\x48\x44\x9d\x3c\xaa\x18\x28\x33\x8c\x1d\xe4\xc8\xbd\x78\x6c\xb9\xb0\x8e\x43\x59\x00\x63\x84\xd4\x9b\x73\x7e\x5a\xe3\x18\x53\x42\xc5\xa0\xde\xb5\x25\x8f\x81\x52\x3a\xa1\x25\xa1\x86\xeb\xd9\x00\x1b\x27\x0e\xae\x19\xd1\x1e\x8d\x40\xa7\xd9\xed\x2c\x9d\x0e\x95\x4a\xd4\x62\x05\x70\x09\x4a\x2c\xfe\x0c\x17\xa7\xdc\xb0\xaf\x87\xa7\x2b\x90\xd5\x35\x68\x2a\xb1\x5d\xae\xef\x05\x53\x0f\xdd\x8f\x92\x2f\xe8\x2a\xda\xfc\xbf\x15\xb5\xec\x39\x86\xdb\x36\xff\xe6\x8b\xbf\xdf\x54\x77\xd8\x83\x6a\x8c\xcd\x6a\xb9\x2a\xb1\x95\xa0\x6d\xcb\xe2\x38\xee\x58\x60\x97\xbf\x81\x6b\xa7\x49\x9b\x13\xde\x98\xbc\xcf\x8c\x86\x9c\xcf\x33\xb1\x50\x95\x3e\xf6\xfb\x84\x9e\xf9\x64\x97\xf5\x31\xc5\x68\xdf\x57\x9c\x85\x9d\x6d\x16\xf5\xf7\x4e\xcd\xcf\xa5\x47\xd7\xfc\xd7\xa8\x78\x0f\x00\x00\xff\xff\x82\x42\x75\xa4\x08\x02\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 520, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x18, 0x69, 0xc5, 0xf1, 0xe, 0xc, 0x77, 0xe5, 0x78, 0xce, 0xfc, 0xc2, 0x41, 0xf8, 0x21, 0x87, 0x8a, 0xb7, 0x67, 0xdd, 0x48, 0x94, 0x63, 0x79, 0x69, 0x4e, 0x38, 0x53, 0x3c, 0xdb, 0xc7, 0x13}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
