/*
© 2021 Red Hat, Inc. and others

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// +build !ignore_autogenerated

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1alpha1

import (
	spec "github.com/go-openapi/spec"
	common "k8s.io/kube-openapi/pkg/common"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscovery":       schema_pkg_apis_submariner_v1alpha1_ServiceDiscovery(ref),
		"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscoverySpec":   schema_pkg_apis_submariner_v1alpha1_ServiceDiscoverySpec(ref),
		"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscoveryStatus": schema_pkg_apis_submariner_v1alpha1_ServiceDiscoveryStatus(ref),
		"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.Submariner":             schema_pkg_apis_submariner_v1alpha1_Submariner(ref),
		"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.SubmarinerSpec":         schema_pkg_apis_submariner_v1alpha1_SubmarinerSpec(ref),
		"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.SubmarinerStatus":       schema_pkg_apis_submariner_v1alpha1_SubmarinerStatus(ref),
	}
}

func schema_pkg_apis_submariner_v1alpha1_ServiceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceDiscovery is the Schema for the servicediscoveries API",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscoveryStatus"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscoverySpec"),
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscoverySpec", "github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.ServiceDiscoveryStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_submariner_v1alpha1_ServiceDiscoverySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceDiscoverySpec defines the desired state of ServiceDiscovery",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"brokerK8sApiServer": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sApiServerToken": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sCA": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sRemoteNamespace": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"clusterID": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"repository": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"debug": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"globalnetEnabled": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"customDomains": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"brokerK8sApiServer", "brokerK8sApiServerToken", "brokerK8sCA", "brokerK8sRemoteNamespace", "clusterID", "namespace", "debug"},
			},
		},
	}
}

func schema_pkg_apis_submariner_v1alpha1_ServiceDiscoveryStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceDiscoveryStatus defines the observed state of ServiceDiscovery",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_submariner_v1alpha1_Submariner(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Submariner is the Schema for the submariners API",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.SubmarinerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.SubmarinerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.SubmarinerSpec", "github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.SubmarinerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_submariner_v1alpha1_SubmarinerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubmarinerSpec defines the desired state of Submariner",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"broker": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sApiServer": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sApiServerToken": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sCA": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"brokerK8sRemoteNamespace": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"cableDriver": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"ceIPSecPSK": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"clusterCIDR": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"clusterID": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"colorCodes": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"repository": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"serviceCIDR": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"globalCIDR": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"ceIPSecIKEPort": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
					"ceIPSecNATTPort": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
					"ceIPSecDebug": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"debug": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"natEnabled": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"serviceDiscoveryEnabled": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"customDomains": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set`",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"broker", "brokerK8sApiServer", "brokerK8sApiServerToken", "brokerK8sCA", "brokerK8sRemoteNamespace", "ceIPSecPSK", "clusterCIDR", "clusterID", "serviceCIDR", "namespace", "ceIPSecDebug", "debug", "natEnabled"},
			},
		},
	}
}

func schema_pkg_apis_submariner_v1alpha1_SubmarinerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubmarinerStatus defines the observed state of Submariner",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"natEnabled": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"colorCodes": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"clusterID": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"serviceCIDR": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"clusterCIDR": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"globalCIDR": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"gatewayDaemonSetStatus": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.DaemonSetStatus"),
						},
					},
					"routeAgentDaemonSetStatus": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.DaemonSetStatus"),
						},
					},
					"globalnetDaemonSetStatus": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.DaemonSetStatus"),
						},
					},
					"gateways": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/submariner-io/submariner/pkg/apis/submariner.io/v1.GatewayStatus"),
									},
								},
							},
						},
					},
				},
				Required: []string{"natEnabled", "clusterID"},
			},
		},
		Dependencies: []string{
			"github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1.DaemonSetStatus", "github.com/submariner-io/submariner/pkg/apis/submariner.io/v1.GatewayStatus"},
	}
}
