// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateServiceQuotaTemplate = "AssociateServiceQuotaTemplate"

// AssociateServiceQuotaTemplateRequest generates a "aws/request.Request" representing the
// client's request for the AssociateServiceQuotaTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateServiceQuotaTemplate for more information on using the AssociateServiceQuotaTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateServiceQuotaTemplateRequest method.
//    req, resp := client.AssociateServiceQuotaTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate
func (c *ServiceQuotas) AssociateServiceQuotaTemplateRequest(input *AssociateServiceQuotaTemplateInput) (req *request.Request, output *AssociateServiceQuotaTemplateOutput) {
	op := &request.Operation{
		Name:       opAssociateServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateServiceQuotaTemplateInput{}
	}

	output = &AssociateServiceQuotaTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateServiceQuotaTemplate API operation for Service Quotas.
//
// Associates your quota request template with your organization. When a new
// account is created in your organization, the quota increase requests in the
// template are automatically applied to the account. You can add a quota increase
// request for any adjustable quota to your template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation AssociateServiceQuotaTemplate for usage and error information.
//
// Returned Error Types:
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * OrganizationNotInAllFeaturesModeException
//   The organization that your account belongs to is not in All Features mode.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate
func (c *ServiceQuotas) AssociateServiceQuotaTemplate(input *AssociateServiceQuotaTemplateInput) (*AssociateServiceQuotaTemplateOutput, error) {
	req, out := c.AssociateServiceQuotaTemplateRequest(input)
	return out, req.Send()
}

// AssociateServiceQuotaTemplateWithContext is the same as AssociateServiceQuotaTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateServiceQuotaTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) AssociateServiceQuotaTemplateWithContext(ctx aws.Context, input *AssociateServiceQuotaTemplateInput, opts ...request.Option) (*AssociateServiceQuotaTemplateOutput, error) {
	req, out := c.AssociateServiceQuotaTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceQuotaIncreaseRequestFromTemplate = "DeleteServiceQuotaIncreaseRequestFromTemplate"

// DeleteServiceQuotaIncreaseRequestFromTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceQuotaIncreaseRequestFromTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceQuotaIncreaseRequestFromTemplate for more information on using the DeleteServiceQuotaIncreaseRequestFromTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceQuotaIncreaseRequestFromTemplateRequest method.
//    req, resp := client.DeleteServiceQuotaIncreaseRequestFromTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) DeleteServiceQuotaIncreaseRequestFromTemplateRequest(input *DeleteServiceQuotaIncreaseRequestFromTemplateInput) (req *request.Request, output *DeleteServiceQuotaIncreaseRequestFromTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceQuotaIncreaseRequestFromTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceQuotaIncreaseRequestFromTemplateInput{}
	}

	output = &DeleteServiceQuotaIncreaseRequestFromTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServiceQuotaIncreaseRequestFromTemplate API operation for Service Quotas.
//
// Deletes the quota increase request for the specified quota from your quota
// request template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation DeleteServiceQuotaIncreaseRequestFromTemplate for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) DeleteServiceQuotaIncreaseRequestFromTemplate(input *DeleteServiceQuotaIncreaseRequestFromTemplateInput) (*DeleteServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.DeleteServiceQuotaIncreaseRequestFromTemplateRequest(input)
	return out, req.Send()
}

// DeleteServiceQuotaIncreaseRequestFromTemplateWithContext is the same as DeleteServiceQuotaIncreaseRequestFromTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceQuotaIncreaseRequestFromTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) DeleteServiceQuotaIncreaseRequestFromTemplateWithContext(ctx aws.Context, input *DeleteServiceQuotaIncreaseRequestFromTemplateInput, opts ...request.Option) (*DeleteServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.DeleteServiceQuotaIncreaseRequestFromTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateServiceQuotaTemplate = "DisassociateServiceQuotaTemplate"

// DisassociateServiceQuotaTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateServiceQuotaTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateServiceQuotaTemplate for more information on using the DisassociateServiceQuotaTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateServiceQuotaTemplateRequest method.
//    req, resp := client.DisassociateServiceQuotaTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate
func (c *ServiceQuotas) DisassociateServiceQuotaTemplateRequest(input *DisassociateServiceQuotaTemplateInput) (req *request.Request, output *DisassociateServiceQuotaTemplateOutput) {
	op := &request.Operation{
		Name:       opDisassociateServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateServiceQuotaTemplateInput{}
	}

	output = &DisassociateServiceQuotaTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateServiceQuotaTemplate API operation for Service Quotas.
//
// Disables your quota request template. After a template is disabled, the quota
// increase requests in the template are not applied to new accounts in your
// organization. Disabling a quota request template does not apply its quota
// increase requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation DisassociateServiceQuotaTemplate for usage and error information.
//
// Returned Error Types:
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * ServiceQuotaTemplateNotInUseException
//   The quota request template is not associated with your organization.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate
func (c *ServiceQuotas) DisassociateServiceQuotaTemplate(input *DisassociateServiceQuotaTemplateInput) (*DisassociateServiceQuotaTemplateOutput, error) {
	req, out := c.DisassociateServiceQuotaTemplateRequest(input)
	return out, req.Send()
}

// DisassociateServiceQuotaTemplateWithContext is the same as DisassociateServiceQuotaTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateServiceQuotaTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) DisassociateServiceQuotaTemplateWithContext(ctx aws.Context, input *DisassociateServiceQuotaTemplateInput, opts ...request.Option) (*DisassociateServiceQuotaTemplateOutput, error) {
	req, out := c.DisassociateServiceQuotaTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAWSDefaultServiceQuota = "GetAWSDefaultServiceQuota"

// GetAWSDefaultServiceQuotaRequest generates a "aws/request.Request" representing the
// client's request for the GetAWSDefaultServiceQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAWSDefaultServiceQuota for more information on using the GetAWSDefaultServiceQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAWSDefaultServiceQuotaRequest method.
//    req, resp := client.GetAWSDefaultServiceQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota
func (c *ServiceQuotas) GetAWSDefaultServiceQuotaRequest(input *GetAWSDefaultServiceQuotaInput) (req *request.Request, output *GetAWSDefaultServiceQuotaOutput) {
	op := &request.Operation{
		Name:       opGetAWSDefaultServiceQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAWSDefaultServiceQuotaInput{}
	}

	output = &GetAWSDefaultServiceQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAWSDefaultServiceQuota API operation for Service Quotas.
//
// Retrieves the default value for the specified quota. The default value does
// not reflect any quota increases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetAWSDefaultServiceQuota for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota
func (c *ServiceQuotas) GetAWSDefaultServiceQuota(input *GetAWSDefaultServiceQuotaInput) (*GetAWSDefaultServiceQuotaOutput, error) {
	req, out := c.GetAWSDefaultServiceQuotaRequest(input)
	return out, req.Send()
}

// GetAWSDefaultServiceQuotaWithContext is the same as GetAWSDefaultServiceQuota with the addition of
// the ability to pass a context and additional request options.
//
// See GetAWSDefaultServiceQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetAWSDefaultServiceQuotaWithContext(ctx aws.Context, input *GetAWSDefaultServiceQuotaInput, opts ...request.Option) (*GetAWSDefaultServiceQuotaOutput, error) {
	req, out := c.GetAWSDefaultServiceQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssociationForServiceQuotaTemplate = "GetAssociationForServiceQuotaTemplate"

// GetAssociationForServiceQuotaTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetAssociationForServiceQuotaTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssociationForServiceQuotaTemplate for more information on using the GetAssociationForServiceQuotaTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssociationForServiceQuotaTemplateRequest method.
//    req, resp := client.GetAssociationForServiceQuotaTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate
func (c *ServiceQuotas) GetAssociationForServiceQuotaTemplateRequest(input *GetAssociationForServiceQuotaTemplateInput) (req *request.Request, output *GetAssociationForServiceQuotaTemplateOutput) {
	op := &request.Operation{
		Name:       opGetAssociationForServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAssociationForServiceQuotaTemplateInput{}
	}

	output = &GetAssociationForServiceQuotaTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssociationForServiceQuotaTemplate API operation for Service Quotas.
//
// Retrieves the status of the association for the quota request template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetAssociationForServiceQuotaTemplate for usage and error information.
//
// Returned Error Types:
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * ServiceQuotaTemplateNotInUseException
//   The quota request template is not associated with your organization.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate
func (c *ServiceQuotas) GetAssociationForServiceQuotaTemplate(input *GetAssociationForServiceQuotaTemplateInput) (*GetAssociationForServiceQuotaTemplateOutput, error) {
	req, out := c.GetAssociationForServiceQuotaTemplateRequest(input)
	return out, req.Send()
}

// GetAssociationForServiceQuotaTemplateWithContext is the same as GetAssociationForServiceQuotaTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssociationForServiceQuotaTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetAssociationForServiceQuotaTemplateWithContext(ctx aws.Context, input *GetAssociationForServiceQuotaTemplateInput, opts ...request.Option) (*GetAssociationForServiceQuotaTemplateOutput, error) {
	req, out := c.GetAssociationForServiceQuotaTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRequestedServiceQuotaChange = "GetRequestedServiceQuotaChange"

// GetRequestedServiceQuotaChangeRequest generates a "aws/request.Request" representing the
// client's request for the GetRequestedServiceQuotaChange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRequestedServiceQuotaChange for more information on using the GetRequestedServiceQuotaChange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRequestedServiceQuotaChangeRequest method.
//    req, resp := client.GetRequestedServiceQuotaChangeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange
func (c *ServiceQuotas) GetRequestedServiceQuotaChangeRequest(input *GetRequestedServiceQuotaChangeInput) (req *request.Request, output *GetRequestedServiceQuotaChangeOutput) {
	op := &request.Operation{
		Name:       opGetRequestedServiceQuotaChange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRequestedServiceQuotaChangeInput{}
	}

	output = &GetRequestedServiceQuotaChangeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRequestedServiceQuotaChange API operation for Service Quotas.
//
// Retrieves information about the specified quota increase request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetRequestedServiceQuotaChange for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange
func (c *ServiceQuotas) GetRequestedServiceQuotaChange(input *GetRequestedServiceQuotaChangeInput) (*GetRequestedServiceQuotaChangeOutput, error) {
	req, out := c.GetRequestedServiceQuotaChangeRequest(input)
	return out, req.Send()
}

// GetRequestedServiceQuotaChangeWithContext is the same as GetRequestedServiceQuotaChange with the addition of
// the ability to pass a context and additional request options.
//
// See GetRequestedServiceQuotaChange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetRequestedServiceQuotaChangeWithContext(ctx aws.Context, input *GetRequestedServiceQuotaChangeInput, opts ...request.Option) (*GetRequestedServiceQuotaChangeOutput, error) {
	req, out := c.GetRequestedServiceQuotaChangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceQuota = "GetServiceQuota"

// GetServiceQuotaRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceQuota for more information on using the GetServiceQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceQuotaRequest method.
//    req, resp := client.GetServiceQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota
func (c *ServiceQuotas) GetServiceQuotaRequest(input *GetServiceQuotaInput) (req *request.Request, output *GetServiceQuotaOutput) {
	op := &request.Operation{
		Name:       opGetServiceQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceQuotaInput{}
	}

	output = &GetServiceQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceQuota API operation for Service Quotas.
//
// Retrieves the applied quota value for the specified quota. For some quotas,
// only the default values are available. If the applied quota value is not
// available for a quota, the quota is not retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetServiceQuota for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota
func (c *ServiceQuotas) GetServiceQuota(input *GetServiceQuotaInput) (*GetServiceQuotaOutput, error) {
	req, out := c.GetServiceQuotaRequest(input)
	return out, req.Send()
}

// GetServiceQuotaWithContext is the same as GetServiceQuota with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetServiceQuotaWithContext(ctx aws.Context, input *GetServiceQuotaInput, opts ...request.Option) (*GetServiceQuotaOutput, error) {
	req, out := c.GetServiceQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceQuotaIncreaseRequestFromTemplate = "GetServiceQuotaIncreaseRequestFromTemplate"

// GetServiceQuotaIncreaseRequestFromTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceQuotaIncreaseRequestFromTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceQuotaIncreaseRequestFromTemplate for more information on using the GetServiceQuotaIncreaseRequestFromTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceQuotaIncreaseRequestFromTemplateRequest method.
//    req, resp := client.GetServiceQuotaIncreaseRequestFromTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) GetServiceQuotaIncreaseRequestFromTemplateRequest(input *GetServiceQuotaIncreaseRequestFromTemplateInput) (req *request.Request, output *GetServiceQuotaIncreaseRequestFromTemplateOutput) {
	op := &request.Operation{
		Name:       opGetServiceQuotaIncreaseRequestFromTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceQuotaIncreaseRequestFromTemplateInput{}
	}

	output = &GetServiceQuotaIncreaseRequestFromTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceQuotaIncreaseRequestFromTemplate API operation for Service Quotas.
//
// Retrieves information about the specified quota increase request in your
// quota request template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetServiceQuotaIncreaseRequestFromTemplate for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) GetServiceQuotaIncreaseRequestFromTemplate(input *GetServiceQuotaIncreaseRequestFromTemplateInput) (*GetServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.GetServiceQuotaIncreaseRequestFromTemplateRequest(input)
	return out, req.Send()
}

// GetServiceQuotaIncreaseRequestFromTemplateWithContext is the same as GetServiceQuotaIncreaseRequestFromTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceQuotaIncreaseRequestFromTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetServiceQuotaIncreaseRequestFromTemplateWithContext(ctx aws.Context, input *GetServiceQuotaIncreaseRequestFromTemplateInput, opts ...request.Option) (*GetServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.GetServiceQuotaIncreaseRequestFromTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAWSDefaultServiceQuotas = "ListAWSDefaultServiceQuotas"

// ListAWSDefaultServiceQuotasRequest generates a "aws/request.Request" representing the
// client's request for the ListAWSDefaultServiceQuotas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAWSDefaultServiceQuotas for more information on using the ListAWSDefaultServiceQuotas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAWSDefaultServiceQuotasRequest method.
//    req, resp := client.ListAWSDefaultServiceQuotasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasRequest(input *ListAWSDefaultServiceQuotasInput) (req *request.Request, output *ListAWSDefaultServiceQuotasOutput) {
	op := &request.Operation{
		Name:       opListAWSDefaultServiceQuotas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAWSDefaultServiceQuotasInput{}
	}

	output = &ListAWSDefaultServiceQuotasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAWSDefaultServiceQuotas API operation for Service Quotas.
//
// Lists the default values for the quotas for the specified AWS service. A
// default value does not reflect any quota increases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListAWSDefaultServiceQuotas for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * InvalidPaginationTokenException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas
func (c *ServiceQuotas) ListAWSDefaultServiceQuotas(input *ListAWSDefaultServiceQuotasInput) (*ListAWSDefaultServiceQuotasOutput, error) {
	req, out := c.ListAWSDefaultServiceQuotasRequest(input)
	return out, req.Send()
}

// ListAWSDefaultServiceQuotasWithContext is the same as ListAWSDefaultServiceQuotas with the addition of
// the ability to pass a context and additional request options.
//
// See ListAWSDefaultServiceQuotas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasWithContext(ctx aws.Context, input *ListAWSDefaultServiceQuotasInput, opts ...request.Option) (*ListAWSDefaultServiceQuotasOutput, error) {
	req, out := c.ListAWSDefaultServiceQuotasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAWSDefaultServiceQuotasPages iterates over the pages of a ListAWSDefaultServiceQuotas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAWSDefaultServiceQuotas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAWSDefaultServiceQuotas operation.
//    pageNum := 0
//    err := client.ListAWSDefaultServiceQuotasPages(params,
//        func(page *servicequotas.ListAWSDefaultServiceQuotasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasPages(input *ListAWSDefaultServiceQuotasInput, fn func(*ListAWSDefaultServiceQuotasOutput, bool) bool) error {
	return c.ListAWSDefaultServiceQuotasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAWSDefaultServiceQuotasPagesWithContext same as ListAWSDefaultServiceQuotasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasPagesWithContext(ctx aws.Context, input *ListAWSDefaultServiceQuotasInput, fn func(*ListAWSDefaultServiceQuotasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAWSDefaultServiceQuotasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAWSDefaultServiceQuotasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAWSDefaultServiceQuotasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRequestedServiceQuotaChangeHistory = "ListRequestedServiceQuotaChangeHistory"

// ListRequestedServiceQuotaChangeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListRequestedServiceQuotaChangeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRequestedServiceQuotaChangeHistory for more information on using the ListRequestedServiceQuotaChangeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRequestedServiceQuotaChangeHistoryRequest method.
//    req, resp := client.ListRequestedServiceQuotaChangeHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryRequest(input *ListRequestedServiceQuotaChangeHistoryInput) (req *request.Request, output *ListRequestedServiceQuotaChangeHistoryOutput) {
	op := &request.Operation{
		Name:       opListRequestedServiceQuotaChangeHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRequestedServiceQuotaChangeHistoryInput{}
	}

	output = &ListRequestedServiceQuotaChangeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRequestedServiceQuotaChangeHistory API operation for Service Quotas.
//
// Retrieves the quota increase requests for the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListRequestedServiceQuotaChangeHistory for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * InvalidPaginationTokenException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistory(input *ListRequestedServiceQuotaChangeHistoryInput) (*ListRequestedServiceQuotaChangeHistoryOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryRequest(input)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryWithContext is the same as ListRequestedServiceQuotaChangeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListRequestedServiceQuotaChangeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryInput, opts ...request.Option) (*ListRequestedServiceQuotaChangeHistoryOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryPages iterates over the pages of a ListRequestedServiceQuotaChangeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRequestedServiceQuotaChangeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRequestedServiceQuotaChangeHistory operation.
//    pageNum := 0
//    err := client.ListRequestedServiceQuotaChangeHistoryPages(params,
//        func(page *servicequotas.ListRequestedServiceQuotaChangeHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryPages(input *ListRequestedServiceQuotaChangeHistoryInput, fn func(*ListRequestedServiceQuotaChangeHistoryOutput, bool) bool) error {
	return c.ListRequestedServiceQuotaChangeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRequestedServiceQuotaChangeHistoryPagesWithContext same as ListRequestedServiceQuotaChangeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryPagesWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryInput, fn func(*ListRequestedServiceQuotaChangeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRequestedServiceQuotaChangeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRequestedServiceQuotaChangeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRequestedServiceQuotaChangeHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRequestedServiceQuotaChangeHistoryByQuota = "ListRequestedServiceQuotaChangeHistoryByQuota"

// ListRequestedServiceQuotaChangeHistoryByQuotaRequest generates a "aws/request.Request" representing the
// client's request for the ListRequestedServiceQuotaChangeHistoryByQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRequestedServiceQuotaChangeHistoryByQuota for more information on using the ListRequestedServiceQuotaChangeHistoryByQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRequestedServiceQuotaChangeHistoryByQuotaRequest method.
//    req, resp := client.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput) (req *request.Request, output *ListRequestedServiceQuotaChangeHistoryByQuotaOutput) {
	op := &request.Operation{
		Name:       opListRequestedServiceQuotaChangeHistoryByQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRequestedServiceQuotaChangeHistoryByQuotaInput{}
	}

	output = &ListRequestedServiceQuotaChangeHistoryByQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRequestedServiceQuotaChangeHistoryByQuota API operation for Service Quotas.
//
// Retrieves the quota increase requests for the specified quota.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListRequestedServiceQuotaChangeHistoryByQuota for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * InvalidPaginationTokenException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuota(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput) (*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryByQuotaWithContext is the same as ListRequestedServiceQuotaChangeHistoryByQuota with the addition of
// the ability to pass a context and additional request options.
//
// See ListRequestedServiceQuotaChangeHistoryByQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryByQuotaInput, opts ...request.Option) (*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryByQuotaPages iterates over the pages of a ListRequestedServiceQuotaChangeHistoryByQuota operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRequestedServiceQuotaChangeHistoryByQuota method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRequestedServiceQuotaChangeHistoryByQuota operation.
//    pageNum := 0
//    err := client.ListRequestedServiceQuotaChangeHistoryByQuotaPages(params,
//        func(page *servicequotas.ListRequestedServiceQuotaChangeHistoryByQuotaOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaPages(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput, fn func(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, bool) bool) error {
	return c.ListRequestedServiceQuotaChangeHistoryByQuotaPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRequestedServiceQuotaChangeHistoryByQuotaPagesWithContext same as ListRequestedServiceQuotaChangeHistoryByQuotaPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaPagesWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryByQuotaInput, fn func(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRequestedServiceQuotaChangeHistoryByQuotaInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceQuotaIncreaseRequestsInTemplate = "ListServiceQuotaIncreaseRequestsInTemplate"

// ListServiceQuotaIncreaseRequestsInTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceQuotaIncreaseRequestsInTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceQuotaIncreaseRequestsInTemplate for more information on using the ListServiceQuotaIncreaseRequestsInTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServiceQuotaIncreaseRequestsInTemplateRequest method.
//    req, resp := client.ListServiceQuotaIncreaseRequestsInTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplateRequest(input *ListServiceQuotaIncreaseRequestsInTemplateInput) (req *request.Request, output *ListServiceQuotaIncreaseRequestsInTemplateOutput) {
	op := &request.Operation{
		Name:       opListServiceQuotaIncreaseRequestsInTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceQuotaIncreaseRequestsInTemplateInput{}
	}

	output = &ListServiceQuotaIncreaseRequestsInTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceQuotaIncreaseRequestsInTemplate API operation for Service Quotas.
//
// Lists the quota increase requests in the specified quota request template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListServiceQuotaIncreaseRequestsInTemplate for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplate(input *ListServiceQuotaIncreaseRequestsInTemplateInput) (*ListServiceQuotaIncreaseRequestsInTemplateOutput, error) {
	req, out := c.ListServiceQuotaIncreaseRequestsInTemplateRequest(input)
	return out, req.Send()
}

// ListServiceQuotaIncreaseRequestsInTemplateWithContext is the same as ListServiceQuotaIncreaseRequestsInTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceQuotaIncreaseRequestsInTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplateWithContext(ctx aws.Context, input *ListServiceQuotaIncreaseRequestsInTemplateInput, opts ...request.Option) (*ListServiceQuotaIncreaseRequestsInTemplateOutput, error) {
	req, out := c.ListServiceQuotaIncreaseRequestsInTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceQuotaIncreaseRequestsInTemplatePages iterates over the pages of a ListServiceQuotaIncreaseRequestsInTemplate operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceQuotaIncreaseRequestsInTemplate method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServiceQuotaIncreaseRequestsInTemplate operation.
//    pageNum := 0
//    err := client.ListServiceQuotaIncreaseRequestsInTemplatePages(params,
//        func(page *servicequotas.ListServiceQuotaIncreaseRequestsInTemplateOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplatePages(input *ListServiceQuotaIncreaseRequestsInTemplateInput, fn func(*ListServiceQuotaIncreaseRequestsInTemplateOutput, bool) bool) error {
	return c.ListServiceQuotaIncreaseRequestsInTemplatePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceQuotaIncreaseRequestsInTemplatePagesWithContext same as ListServiceQuotaIncreaseRequestsInTemplatePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplatePagesWithContext(ctx aws.Context, input *ListServiceQuotaIncreaseRequestsInTemplateInput, fn func(*ListServiceQuotaIncreaseRequestsInTemplateOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceQuotaIncreaseRequestsInTemplateInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceQuotaIncreaseRequestsInTemplateRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceQuotaIncreaseRequestsInTemplateOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceQuotas = "ListServiceQuotas"

// ListServiceQuotasRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceQuotas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceQuotas for more information on using the ListServiceQuotas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServiceQuotasRequest method.
//    req, resp := client.ListServiceQuotasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas
func (c *ServiceQuotas) ListServiceQuotasRequest(input *ListServiceQuotasInput) (req *request.Request, output *ListServiceQuotasOutput) {
	op := &request.Operation{
		Name:       opListServiceQuotas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceQuotasInput{}
	}

	output = &ListServiceQuotasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceQuotas API operation for Service Quotas.
//
// Lists the applied quota values for the specified AWS service. For some quotas,
// only the default values are available. If the applied quota value is not
// available for a quota, the quota is not retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListServiceQuotas for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * InvalidPaginationTokenException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas
func (c *ServiceQuotas) ListServiceQuotas(input *ListServiceQuotasInput) (*ListServiceQuotasOutput, error) {
	req, out := c.ListServiceQuotasRequest(input)
	return out, req.Send()
}

// ListServiceQuotasWithContext is the same as ListServiceQuotas with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceQuotas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotasWithContext(ctx aws.Context, input *ListServiceQuotasInput, opts ...request.Option) (*ListServiceQuotasOutput, error) {
	req, out := c.ListServiceQuotasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceQuotasPages iterates over the pages of a ListServiceQuotas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceQuotas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServiceQuotas operation.
//    pageNum := 0
//    err := client.ListServiceQuotasPages(params,
//        func(page *servicequotas.ListServiceQuotasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListServiceQuotasPages(input *ListServiceQuotasInput, fn func(*ListServiceQuotasOutput, bool) bool) error {
	return c.ListServiceQuotasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceQuotasPagesWithContext same as ListServiceQuotasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotasPagesWithContext(ctx aws.Context, input *ListServiceQuotasInput, fn func(*ListServiceQuotasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceQuotasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceQuotasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceQuotasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServicesRequest method.
//    req, resp := client.ListServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices
func (c *ServiceQuotas) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for Service Quotas.
//
// Lists the names and codes for the services integrated with Service Quotas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * InvalidPaginationTokenException
//   Invalid input was provided.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices
func (c *ServiceQuotas) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServices operation.
//    pageNum := 0
//    err := client.ListServicesPages(params,
//        func(page *servicequotas.ListServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListTagsForResource
func (c *ServiceQuotas) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Service Quotas.
//
// Returns a list of the tags assigned to the specified applied quota.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListTagsForResource
func (c *ServiceQuotas) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutServiceQuotaIncreaseRequestIntoTemplate = "PutServiceQuotaIncreaseRequestIntoTemplate"

// PutServiceQuotaIncreaseRequestIntoTemplateRequest generates a "aws/request.Request" representing the
// client's request for the PutServiceQuotaIncreaseRequestIntoTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutServiceQuotaIncreaseRequestIntoTemplate for more information on using the PutServiceQuotaIncreaseRequestIntoTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutServiceQuotaIncreaseRequestIntoTemplateRequest method.
//    req, resp := client.PutServiceQuotaIncreaseRequestIntoTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate
func (c *ServiceQuotas) PutServiceQuotaIncreaseRequestIntoTemplateRequest(input *PutServiceQuotaIncreaseRequestIntoTemplateInput) (req *request.Request, output *PutServiceQuotaIncreaseRequestIntoTemplateOutput) {
	op := &request.Operation{
		Name:       opPutServiceQuotaIncreaseRequestIntoTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutServiceQuotaIncreaseRequestIntoTemplateInput{}
	}

	output = &PutServiceQuotaIncreaseRequestIntoTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutServiceQuotaIncreaseRequestIntoTemplate API operation for Service Quotas.
//
// Adds a quota increase request to your quota request template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation PutServiceQuotaIncreaseRequestIntoTemplate for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * QuotaExceededException
//   You have exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use Service Quotas to request a service
//   quota increase.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * AWSServiceAccessNotEnabledException
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization.
//
//   * TemplatesNotAvailableInRegionException
//   The Service Quotas template is not available in this AWS Region.
//
//   * NoAvailableOrganizationException
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate
func (c *ServiceQuotas) PutServiceQuotaIncreaseRequestIntoTemplate(input *PutServiceQuotaIncreaseRequestIntoTemplateInput) (*PutServiceQuotaIncreaseRequestIntoTemplateOutput, error) {
	req, out := c.PutServiceQuotaIncreaseRequestIntoTemplateRequest(input)
	return out, req.Send()
}

// PutServiceQuotaIncreaseRequestIntoTemplateWithContext is the same as PutServiceQuotaIncreaseRequestIntoTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See PutServiceQuotaIncreaseRequestIntoTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) PutServiceQuotaIncreaseRequestIntoTemplateWithContext(ctx aws.Context, input *PutServiceQuotaIncreaseRequestIntoTemplateInput, opts ...request.Option) (*PutServiceQuotaIncreaseRequestIntoTemplateOutput, error) {
	req, out := c.PutServiceQuotaIncreaseRequestIntoTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestServiceQuotaIncrease = "RequestServiceQuotaIncrease"

// RequestServiceQuotaIncreaseRequest generates a "aws/request.Request" representing the
// client's request for the RequestServiceQuotaIncrease operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestServiceQuotaIncrease for more information on using the RequestServiceQuotaIncrease
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestServiceQuotaIncreaseRequest method.
//    req, resp := client.RequestServiceQuotaIncreaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease
func (c *ServiceQuotas) RequestServiceQuotaIncreaseRequest(input *RequestServiceQuotaIncreaseInput) (req *request.Request, output *RequestServiceQuotaIncreaseOutput) {
	op := &request.Operation{
		Name:       opRequestServiceQuotaIncrease,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestServiceQuotaIncreaseInput{}
	}

	output = &RequestServiceQuotaIncreaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestServiceQuotaIncrease API operation for Service Quotas.
//
// Submits a quota increase request for the specified quota.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation RequestServiceQuotaIncrease for usage and error information.
//
// Returned Error Types:
//   * DependencyAccessDeniedException
//   You can't perform this action because a dependency does not have access.
//
//   * QuotaExceededException
//   You have exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use Service Quotas to request a service
//   quota increase.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * InvalidResourceStateException
//   The resource is in an invalid state.
//
//   * ServiceException
//   Something went wrong.
//
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease
func (c *ServiceQuotas) RequestServiceQuotaIncrease(input *RequestServiceQuotaIncreaseInput) (*RequestServiceQuotaIncreaseOutput, error) {
	req, out := c.RequestServiceQuotaIncreaseRequest(input)
	return out, req.Send()
}

// RequestServiceQuotaIncreaseWithContext is the same as RequestServiceQuotaIncrease with the addition of
// the ability to pass a context and additional request options.
//
// See RequestServiceQuotaIncrease for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) RequestServiceQuotaIncreaseWithContext(ctx aws.Context, input *RequestServiceQuotaIncreaseInput, opts ...request.Option) (*RequestServiceQuotaIncreaseOutput, error) {
	req, out := c.RequestServiceQuotaIncreaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/TagResource
func (c *ServiceQuotas) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Service Quotas.
//
// Adds tags to the specified applied quota. You can include one or more tags
// to add to the quota.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * TooManyTagsException
//   You've exceeded the number of tags allowed for a resource. For more information,
//   see Tag restrictions (https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions)
//   in the Service Quotas User Guide.
//
//   * TagPolicyViolationException
//   The specified tag is a reserved word and cannot be used.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/TagResource
func (c *ServiceQuotas) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/UntagResource
func (c *ServiceQuotas) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Service Quotas.
//
// Removes tags from the specified applied quota. You can specify one or more
// tags to remove.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * NoSuchResourceException
//   The specified resource does not exist.
//
//   * IllegalArgumentException
//   Invalid input was provided.
//
//   * AccessDeniedException
//   You do not have sufficient permission to perform this action.
//
//   * ServiceException
//   Something went wrong.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/UntagResource
func (c *ServiceQuotas) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The action you attempted is not allowed unless Service Access with Service
// Quotas is enabled in your organization.
type AWSServiceAccessNotEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AWSServiceAccessNotEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AWSServiceAccessNotEnabledException) GoString() string {
	return s.String()
}

func newErrorAWSServiceAccessNotEnabledException(v protocol.ResponseMetadata) error {
	return &AWSServiceAccessNotEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AWSServiceAccessNotEnabledException) Code() string {
	return "AWSServiceAccessNotEnabledException"
}

// Message returns the exception's message.
func (s *AWSServiceAccessNotEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AWSServiceAccessNotEnabledException) OrigErr() error {
	return nil
}

func (s *AWSServiceAccessNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AWSServiceAccessNotEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AWSServiceAccessNotEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You do not have sufficient permission to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceQuotaTemplateInput) GoString() string {
	return s.String()
}

type AssociateServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceQuotaTemplateOutput) GoString() string {
	return s.String()
}

type DeleteServiceQuotaIncreaseRequestFromTemplateInput struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceQuotaIncreaseRequestFromTemplateInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) SetAwsRegion(v string) *DeleteServiceQuotaIncreaseRequestFromTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) SetQuotaCode(v string) *DeleteServiceQuotaIncreaseRequestFromTemplateInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) SetServiceCode(v string) *DeleteServiceQuotaIncreaseRequestFromTemplateInput {
	s.ServiceCode = &v
	return s
}

type DeleteServiceQuotaIncreaseRequestFromTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateOutput) GoString() string {
	return s.String()
}

// You can't perform this action because a dependency does not have access.
type DependencyAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DependencyAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DependencyAccessDeniedException) GoString() string {
	return s.String()
}

func newErrorDependencyAccessDeniedException(v protocol.ResponseMetadata) error {
	return &DependencyAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyAccessDeniedException) Code() string {
	return "DependencyAccessDeniedException"
}

// Message returns the exception's message.
func (s *DependencyAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyAccessDeniedException) OrigErr() error {
	return nil
}

func (s *DependencyAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DisassociateServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceQuotaTemplateInput) GoString() string {
	return s.String()
}

type DisassociateServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceQuotaTemplateOutput) GoString() string {
	return s.String()
}

// An error that explains why an action did not succeed.
type ErrorReason struct {
	_ struct{} `type:"structure"`

	// Service Quotas returns the following error values:
	//
	//    * DEPENDENCY_ACCESS_DENIED_ERROR - The caller does not have the required
	//    permissions to complete the action. To resolve the error, you must have
	//    permission to access the service or quota.
	//
	//    * DEPENDENCY_THROTTLING_ERROR - The service is throttling Service Quotas.
	//
	//    * DEPENDENCY_SERVICE_ERROR - The service is not available.
	//
	//    * SERVICE_QUOTA_NOT_AVAILABLE_ERROR - There was an error in Service Quotas.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorReason) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorReason) SetErrorCode(v string) *ErrorReason {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorReason) SetErrorMessage(v string) *ErrorReason {
	s.ErrorMessage = &v
	return s
}

type GetAWSDefaultServiceQuotaInput struct {
	_ struct{} `type:"structure"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAWSDefaultServiceQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAWSDefaultServiceQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAWSDefaultServiceQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAWSDefaultServiceQuotaInput"}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *GetAWSDefaultServiceQuotaInput) SetQuotaCode(v string) *GetAWSDefaultServiceQuotaInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *GetAWSDefaultServiceQuotaInput) SetServiceCode(v string) *GetAWSDefaultServiceQuotaInput {
	s.ServiceCode = &v
	return s
}

type GetAWSDefaultServiceQuotaOutput struct {
	_ struct{} `type:"structure"`

	// Information about the quota.
	Quota *ServiceQuota `type:"structure"`
}

// String returns the string representation
func (s GetAWSDefaultServiceQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAWSDefaultServiceQuotaOutput) GoString() string {
	return s.String()
}

// SetQuota sets the Quota field's value.
func (s *GetAWSDefaultServiceQuotaOutput) SetQuota(v *ServiceQuota) *GetAWSDefaultServiceQuotaOutput {
	s.Quota = v
	return s
}

type GetAssociationForServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAssociationForServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociationForServiceQuotaTemplateInput) GoString() string {
	return s.String()
}

type GetAssociationForServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The association status. If the status is ASSOCIATED, the quota increase requests
	// in the template are automatically applied to new accounts in your organization.
	ServiceQuotaTemplateAssociationStatus *string `type:"string" enum:"ServiceQuotaTemplateAssociationStatus"`
}

// String returns the string representation
func (s GetAssociationForServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociationForServiceQuotaTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceQuotaTemplateAssociationStatus sets the ServiceQuotaTemplateAssociationStatus field's value.
func (s *GetAssociationForServiceQuotaTemplateOutput) SetServiceQuotaTemplateAssociationStatus(v string) *GetAssociationForServiceQuotaTemplateOutput {
	s.ServiceQuotaTemplateAssociationStatus = &v
	return s
}

type GetRequestedServiceQuotaChangeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the quota increase request.
	//
	// RequestId is a required field
	RequestId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRequestedServiceQuotaChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRequestedServiceQuotaChangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRequestedServiceQuotaChangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRequestedServiceQuotaChangeInput"}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestId sets the RequestId field's value.
func (s *GetRequestedServiceQuotaChangeInput) SetRequestId(v string) *GetRequestedServiceQuotaChangeInput {
	s.RequestId = &v
	return s
}

type GetRequestedServiceQuotaChangeOutput struct {
	_ struct{} `type:"structure"`

	// Information about the quota increase request.
	RequestedQuota *RequestedServiceQuotaChange `type:"structure"`
}

// String returns the string representation
func (s GetRequestedServiceQuotaChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRequestedServiceQuotaChangeOutput) GoString() string {
	return s.String()
}

// SetRequestedQuota sets the RequestedQuota field's value.
func (s *GetRequestedServiceQuotaChangeOutput) SetRequestedQuota(v *RequestedServiceQuotaChange) *GetRequestedServiceQuotaChangeOutput {
	s.RequestedQuota = v
	return s
}

type GetServiceQuotaIncreaseRequestFromTemplateInput struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceQuotaIncreaseRequestFromTemplateInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) SetAwsRegion(v string) *GetServiceQuotaIncreaseRequestFromTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) SetQuotaCode(v string) *GetServiceQuotaIncreaseRequestFromTemplateInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) SetServiceCode(v string) *GetServiceQuotaIncreaseRequestFromTemplateInput {
	s.ServiceCode = &v
	return s
}

type GetServiceQuotaIncreaseRequestFromTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the quota increase request.
	ServiceQuotaIncreaseRequestInTemplate *ServiceQuotaIncreaseRequestInTemplate `type:"structure"`
}

// String returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceQuotaIncreaseRequestInTemplate sets the ServiceQuotaIncreaseRequestInTemplate field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateOutput) SetServiceQuotaIncreaseRequestInTemplate(v *ServiceQuotaIncreaseRequestInTemplate) *GetServiceQuotaIncreaseRequestFromTemplateOutput {
	s.ServiceQuotaIncreaseRequestInTemplate = v
	return s
}

type GetServiceQuotaInput struct {
	_ struct{} `type:"structure"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceQuotaInput"}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *GetServiceQuotaInput) SetQuotaCode(v string) *GetServiceQuotaInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *GetServiceQuotaInput) SetServiceCode(v string) *GetServiceQuotaInput {
	s.ServiceCode = &v
	return s
}

type GetServiceQuotaOutput struct {
	_ struct{} `type:"structure"`

	// Information about the quota.
	Quota *ServiceQuota `type:"structure"`
}

// String returns the string representation
func (s GetServiceQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaOutput) GoString() string {
	return s.String()
}

// SetQuota sets the Quota field's value.
func (s *GetServiceQuotaOutput) SetQuota(v *ServiceQuota) *GetServiceQuotaOutput {
	s.Quota = v
	return s
}

// Invalid input was provided.
type IllegalArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s IllegalArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IllegalArgumentException) GoString() string {
	return s.String()
}

func newErrorIllegalArgumentException(v protocol.ResponseMetadata) error {
	return &IllegalArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IllegalArgumentException) Code() string {
	return "IllegalArgumentException"
}

// Message returns the exception's message.
func (s *IllegalArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IllegalArgumentException) OrigErr() error {
	return nil
}

func (s *IllegalArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IllegalArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IllegalArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Invalid input was provided.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is in an invalid state.
type InvalidResourceStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidResourceStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidResourceStateException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateException(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateException) Code() string {
	return "InvalidResourceStateException"
}

// Message returns the exception's message.
func (s *InvalidResourceStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateException) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAWSDefaultServiceQuotasInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from
	// this call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAWSDefaultServiceQuotasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAWSDefaultServiceQuotasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAWSDefaultServiceQuotasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAWSDefaultServiceQuotasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAWSDefaultServiceQuotasInput) SetMaxResults(v int64) *ListAWSDefaultServiceQuotasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAWSDefaultServiceQuotasInput) SetNextToken(v string) *ListAWSDefaultServiceQuotasInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListAWSDefaultServiceQuotasInput) SetServiceCode(v string) *ListAWSDefaultServiceQuotasInput {
	s.ServiceCode = &v
	return s
}

type ListAWSDefaultServiceQuotasOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the quotas.
	Quotas []*ServiceQuota `type:"list"`
}

// String returns the string representation
func (s ListAWSDefaultServiceQuotasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAWSDefaultServiceQuotasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAWSDefaultServiceQuotasOutput) SetNextToken(v string) *ListAWSDefaultServiceQuotasOutput {
	s.NextToken = &v
	return s
}

// SetQuotas sets the Quotas field's value.
func (s *ListAWSDefaultServiceQuotasOutput) SetQuotas(v []*ServiceQuota) *ListAWSDefaultServiceQuotasOutput {
	s.Quotas = v
	return s
}

type ListRequestedServiceQuotaChangeHistoryByQuotaInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from
	// this call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`

	// The status value of the quota increase request.
	Status *string `type:"string" enum:"RequestStatus"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRequestedServiceQuotaChangeHistoryByQuotaInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetMaxResults(v int64) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.NextToken = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetQuotaCode(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetServiceCode(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.ServiceCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetStatus(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.Status = &v
	return s
}

type ListRequestedServiceQuotaChangeHistoryByQuotaOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the quota increase requests.
	RequestedQuotas []*RequestedServiceQuotaChange `type:"list"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaOutput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaOutput {
	s.NextToken = &v
	return s
}

// SetRequestedQuotas sets the RequestedQuotas field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaOutput) SetRequestedQuotas(v []*RequestedServiceQuotaChange) *ListRequestedServiceQuotaChangeHistoryByQuotaOutput {
	s.RequestedQuotas = v
	return s
}

type ListRequestedServiceQuotaChangeHistoryInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from
	// this call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The service identifier.
	ServiceCode *string `min:"1" type:"string"`

	// The status of the quota increase request.
	Status *string `type:"string" enum:"RequestStatus"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRequestedServiceQuotaChangeHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRequestedServiceQuotaChangeHistoryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetMaxResults(v int64) *ListRequestedServiceQuotaChangeHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetServiceCode(v string) *ListRequestedServiceQuotaChangeHistoryInput {
	s.ServiceCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetStatus(v string) *ListRequestedServiceQuotaChangeHistoryInput {
	s.Status = &v
	return s
}

type ListRequestedServiceQuotaChangeHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the quota increase requests.
	RequestedQuotas []*RequestedServiceQuotaChange `type:"list"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryOutput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryOutput {
	s.NextToken = &v
	return s
}

// SetRequestedQuotas sets the RequestedQuotas field's value.
func (s *ListRequestedServiceQuotaChangeHistoryOutput) SetRequestedQuotas(v []*RequestedServiceQuotaChange) *ListRequestedServiceQuotaChangeHistoryOutput {
	s.RequestedQuotas = v
	return s
}

type ListServiceQuotaIncreaseRequestsInTemplateInput struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	AwsRegion *string `min:"1" type:"string"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from
	// this call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The service identifier.
	ServiceCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceQuotaIncreaseRequestsInTemplateInput"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetAwsRegion(v string) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetMaxResults(v int64) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetNextToken(v string) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetServiceCode(v string) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.ServiceCode = &v
	return s
}

type ListServiceQuotaIncreaseRequestsInTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the quota increase requests.
	ServiceQuotaIncreaseRequestInTemplateList []*ServiceQuotaIncreaseRequestInTemplate `type:"list"`
}

// String returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateOutput) SetNextToken(v string) *ListServiceQuotaIncreaseRequestsInTemplateOutput {
	s.NextToken = &v
	return s
}

// SetServiceQuotaIncreaseRequestInTemplateList sets the ServiceQuotaIncreaseRequestInTemplateList field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateOutput) SetServiceQuotaIncreaseRequestInTemplateList(v []*ServiceQuotaIncreaseRequestInTemplate) *ListServiceQuotaIncreaseRequestsInTemplateOutput {
	s.ServiceQuotaIncreaseRequestInTemplateList = v
	return s
}

type ListServiceQuotasInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from
	// this call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListServiceQuotasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceQuotasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceQuotasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceQuotasInput) SetMaxResults(v int64) *ListServiceQuotasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotasInput) SetNextToken(v string) *ListServiceQuotasInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListServiceQuotasInput) SetServiceCode(v string) *ListServiceQuotasInput {
	s.ServiceCode = &v
	return s
}

type ListServiceQuotasOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the quotas.
	Quotas []*ServiceQuota `type:"list"`
}

// String returns the string representation
func (s ListServiceQuotasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotasOutput) SetNextToken(v string) *ListServiceQuotasOutput {
	s.NextToken = &v
	return s
}

// SetQuotas sets the Quotas field's value.
func (s *ListServiceQuotasOutput) SetQuotas(v []*ServiceQuota) *ListServiceQuotasOutput {
	s.Quotas = v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, if any, make another call with the token returned from
	// this call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the services.
	Services []*ServiceInfo `type:"list"`
}

// String returns the string representation
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ListServicesOutput) SetServices(v []*ServiceInfo) *ListServicesOutput {
	s.Services = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the applied quota for which you want to
	// list tags. You can get this information by using the Service Quotas console,
	// or by listing the quotas using the list-service-quotas (https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
	// AWS CLI command or the ListServiceQuotas (https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html)
	// AWS API operation.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A complex data type that contains zero or more tag elements.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about the CloudWatch metric that reflects quota usage.
type MetricInfo struct {
	_ struct{} `type:"structure"`

	// The metric dimension. This is a name/value pair that is part of the identity
	// of a metric.
	MetricDimensions map[string]*string `type:"map"`

	// The name of the metric.
	MetricName *string `type:"string"`

	// The namespace of the metric.
	MetricNamespace *string `type:"string"`

	// The metric statistic that we recommend you use when determining quota usage.
	MetricStatisticRecommendation *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricInfo) GoString() string {
	return s.String()
}

// SetMetricDimensions sets the MetricDimensions field's value.
func (s *MetricInfo) SetMetricDimensions(v map[string]*string) *MetricInfo {
	s.MetricDimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricInfo) SetMetricName(v string) *MetricInfo {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *MetricInfo) SetMetricNamespace(v string) *MetricInfo {
	s.MetricNamespace = &v
	return s
}

// SetMetricStatisticRecommendation sets the MetricStatisticRecommendation field's value.
func (s *MetricInfo) SetMetricStatisticRecommendation(v string) *MetricInfo {
	s.MetricStatisticRecommendation = &v
	return s
}

// The account making this call is not a member of an organization.
type NoAvailableOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NoAvailableOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoAvailableOrganizationException) GoString() string {
	return s.String()
}

func newErrorNoAvailableOrganizationException(v protocol.ResponseMetadata) error {
	return &NoAvailableOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableOrganizationException) Code() string {
	return "NoAvailableOrganizationException"
}

// Message returns the exception's message.
func (s *NoAvailableOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableOrganizationException) OrigErr() error {
	return nil
}

func (s *NoAvailableOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource does not exist.
type NoSuchResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NoSuchResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchResourceException) GoString() string {
	return s.String()
}

func newErrorNoSuchResourceException(v protocol.ResponseMetadata) error {
	return &NoSuchResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchResourceException) Code() string {
	return "NoSuchResourceException"
}

// Message returns the exception's message.
func (s *NoSuchResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchResourceException) OrigErr() error {
	return nil
}

func (s *NoSuchResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The organization that your account belongs to is not in All Features mode.
type OrganizationNotInAllFeaturesModeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OrganizationNotInAllFeaturesModeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationNotInAllFeaturesModeException) GoString() string {
	return s.String()
}

func newErrorOrganizationNotInAllFeaturesModeException(v protocol.ResponseMetadata) error {
	return &OrganizationNotInAllFeaturesModeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationNotInAllFeaturesModeException) Code() string {
	return "OrganizationNotInAllFeaturesModeException"
}

// Message returns the exception's message.
func (s *OrganizationNotInAllFeaturesModeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationNotInAllFeaturesModeException) OrigErr() error {
	return nil
}

func (s *OrganizationNotInAllFeaturesModeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationNotInAllFeaturesModeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationNotInAllFeaturesModeException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutServiceQuotaIncreaseRequestIntoTemplateInput struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// The new, increased value for the quota.
	//
	// DesiredValue is a required field
	DesiredValue *float64 `type:"double" required:"true"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutServiceQuotaIncreaseRequestIntoTemplateInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.DesiredValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredValue"))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetAwsRegion(v string) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetDesiredValue(v float64) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.DesiredValue = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetQuotaCode(v string) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetServiceCode(v string) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.ServiceCode = &v
	return s
}

type PutServiceQuotaIncreaseRequestIntoTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the quota increase request.
	ServiceQuotaIncreaseRequestInTemplate *ServiceQuotaIncreaseRequestInTemplate `type:"structure"`
}

// String returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceQuotaIncreaseRequestInTemplate sets the ServiceQuotaIncreaseRequestInTemplate field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateOutput) SetServiceQuotaIncreaseRequestInTemplate(v *ServiceQuotaIncreaseRequestInTemplate) *PutServiceQuotaIncreaseRequestIntoTemplateOutput {
	s.ServiceQuotaIncreaseRequestInTemplate = v
	return s
}

// You have exceeded your service quota. To perform the requested action, remove
// some of the relevant resources, or use Service Quotas to request a service
// quota increase.
type QuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s QuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaExceededException) GoString() string {
	return s.String()
}

func newErrorQuotaExceededException(v protocol.ResponseMetadata) error {
	return &QuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QuotaExceededException) Code() string {
	return "QuotaExceededException"
}

// Message returns the exception's message.
func (s *QuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QuotaExceededException) OrigErr() error {
	return nil
}

func (s *QuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the quota period.
type QuotaPeriod struct {
	_ struct{} `type:"structure"`

	// The time unit.
	PeriodUnit *string `type:"string" enum:"PeriodUnit"`

	// The value.
	PeriodValue *int64 `type:"integer"`
}

// String returns the string representation
func (s QuotaPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaPeriod) GoString() string {
	return s.String()
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *QuotaPeriod) SetPeriodUnit(v string) *QuotaPeriod {
	s.PeriodUnit = &v
	return s
}

// SetPeriodValue sets the PeriodValue field's value.
func (s *QuotaPeriod) SetPeriodValue(v int64) *QuotaPeriod {
	s.PeriodValue = &v
	return s
}

type RequestServiceQuotaIncreaseInput struct {
	_ struct{} `type:"structure"`

	// The new, increased value for the quota.
	//
	// DesiredValue is a required field
	DesiredValue *float64 `type:"double" required:"true"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// The service identifier.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestServiceQuotaIncreaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestServiceQuotaIncreaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestServiceQuotaIncreaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestServiceQuotaIncreaseInput"}
	if s.DesiredValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredValue"))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *RequestServiceQuotaIncreaseInput) SetDesiredValue(v float64) *RequestServiceQuotaIncreaseInput {
	s.DesiredValue = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *RequestServiceQuotaIncreaseInput) SetQuotaCode(v string) *RequestServiceQuotaIncreaseInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *RequestServiceQuotaIncreaseInput) SetServiceCode(v string) *RequestServiceQuotaIncreaseInput {
	s.ServiceCode = &v
	return s
}

type RequestServiceQuotaIncreaseOutput struct {
	_ struct{} `type:"structure"`

	// Information about the quota increase request.
	RequestedQuota *RequestedServiceQuotaChange `type:"structure"`
}

// String returns the string representation
func (s RequestServiceQuotaIncreaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestServiceQuotaIncreaseOutput) GoString() string {
	return s.String()
}

// SetRequestedQuota sets the RequestedQuota field's value.
func (s *RequestServiceQuotaIncreaseOutput) SetRequestedQuota(v *RequestedServiceQuotaChange) *RequestServiceQuotaIncreaseOutput {
	s.RequestedQuota = v
	return s
}

// Information about a quota increase request.
type RequestedServiceQuotaChange struct {
	_ struct{} `type:"structure"`

	// The case ID.
	CaseId *string `type:"string"`

	// The date and time when the quota increase request was received and the case
	// ID was created.
	Created *time.Time `type:"timestamp"`

	// The new, increased value for the quota.
	DesiredValue *float64 `type:"double"`

	// Indicates whether the quota is global.
	GlobalQuota *bool `type:"boolean"`

	// The unique identifier.
	Id *string `min:"1" type:"string"`

	// The date and time of the most recent change.
	LastUpdated *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the quota.
	QuotaArn *string `type:"string"`

	// The quota identifier.
	QuotaCode *string `min:"1" type:"string"`

	// The quota name.
	QuotaName *string `type:"string"`

	// The IAM identity of the requester.
	Requester *string `type:"string"`

	// The service identifier.
	ServiceCode *string `min:"1" type:"string"`

	// The service name.
	ServiceName *string `type:"string"`

	// The state of the quota increase request.
	Status *string `type:"string" enum:"RequestStatus"`

	// The unit of measurement.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s RequestedServiceQuotaChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestedServiceQuotaChange) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *RequestedServiceQuotaChange) SetCaseId(v string) *RequestedServiceQuotaChange {
	s.CaseId = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *RequestedServiceQuotaChange) SetCreated(v time.Time) *RequestedServiceQuotaChange {
	s.Created = &v
	return s
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *RequestedServiceQuotaChange) SetDesiredValue(v float64) *RequestedServiceQuotaChange {
	s.DesiredValue = &v
	return s
}

// SetGlobalQuota sets the GlobalQuota field's value.
func (s *RequestedServiceQuotaChange) SetGlobalQuota(v bool) *RequestedServiceQuotaChange {
	s.GlobalQuota = &v
	return s
}

// SetId sets the Id field's value.
func (s *RequestedServiceQuotaChange) SetId(v string) *RequestedServiceQuotaChange {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *RequestedServiceQuotaChange) SetLastUpdated(v time.Time) *RequestedServiceQuotaChange {
	s.LastUpdated = &v
	return s
}

// SetQuotaArn sets the QuotaArn field's value.
func (s *RequestedServiceQuotaChange) SetQuotaArn(v string) *RequestedServiceQuotaChange {
	s.QuotaArn = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *RequestedServiceQuotaChange) SetQuotaCode(v string) *RequestedServiceQuotaChange {
	s.QuotaCode = &v
	return s
}

// SetQuotaName sets the QuotaName field's value.
func (s *RequestedServiceQuotaChange) SetQuotaName(v string) *RequestedServiceQuotaChange {
	s.QuotaName = &v
	return s
}

// SetRequester sets the Requester field's value.
func (s *RequestedServiceQuotaChange) SetRequester(v string) *RequestedServiceQuotaChange {
	s.Requester = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *RequestedServiceQuotaChange) SetServiceCode(v string) *RequestedServiceQuotaChange {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *RequestedServiceQuotaChange) SetServiceName(v string) *RequestedServiceQuotaChange {
	s.ServiceName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RequestedServiceQuotaChange) SetStatus(v string) *RequestedServiceQuotaChange {
	s.Status = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *RequestedServiceQuotaChange) SetUnit(v string) *RequestedServiceQuotaChange {
	s.Unit = &v
	return s
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Something went wrong.
type ServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceException) GoString() string {
	return s.String()
}

func newErrorServiceException(v protocol.ResponseMetadata) error {
	return &ServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceException) Code() string {
	return "ServiceException"
}

// Message returns the exception's message.
func (s *ServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceException) OrigErr() error {
	return nil
}

func (s *ServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a service.
type ServiceInfo struct {
	_ struct{} `type:"structure"`

	// The service identifier.
	ServiceCode *string `min:"1" type:"string"`

	// The service name.
	ServiceName *string `type:"string"`
}

// String returns the string representation
func (s ServiceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceInfo) GoString() string {
	return s.String()
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ServiceInfo) SetServiceCode(v string) *ServiceInfo {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceInfo) SetServiceName(v string) *ServiceInfo {
	s.ServiceName = &v
	return s
}

// Information about a quota.
type ServiceQuota struct {
	_ struct{} `type:"structure"`

	// Indicates whether the quota value can be increased.
	Adjustable *bool `type:"boolean"`

	// The error code and error reason.
	ErrorReason *ErrorReason `type:"structure"`

	// Indicates whether the quota is global.
	GlobalQuota *bool `type:"boolean"`

	// The period of time.
	Period *QuotaPeriod `type:"structure"`

	// The Amazon Resource Name (ARN) of the quota.
	QuotaArn *string `type:"string"`

	// The quota identifier.
	QuotaCode *string `min:"1" type:"string"`

	// The quota name.
	QuotaName *string `type:"string"`

	// The service identifier.
	ServiceCode *string `min:"1" type:"string"`

	// The service name.
	ServiceName *string `type:"string"`

	// The unit of measurement.
	Unit *string `type:"string"`

	// Information about the measurement.
	UsageMetric *MetricInfo `type:"structure"`

	// The quota value.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s ServiceQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuota) GoString() string {
	return s.String()
}

// SetAdjustable sets the Adjustable field's value.
func (s *ServiceQuota) SetAdjustable(v bool) *ServiceQuota {
	s.Adjustable = &v
	return s
}

// SetErrorReason sets the ErrorReason field's value.
func (s *ServiceQuota) SetErrorReason(v *ErrorReason) *ServiceQuota {
	s.ErrorReason = v
	return s
}

// SetGlobalQuota sets the GlobalQuota field's value.
func (s *ServiceQuota) SetGlobalQuota(v bool) *ServiceQuota {
	s.GlobalQuota = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ServiceQuota) SetPeriod(v *QuotaPeriod) *ServiceQuota {
	s.Period = v
	return s
}

// SetQuotaArn sets the QuotaArn field's value.
func (s *ServiceQuota) SetQuotaArn(v string) *ServiceQuota {
	s.QuotaArn = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *ServiceQuota) SetQuotaCode(v string) *ServiceQuota {
	s.QuotaCode = &v
	return s
}

// SetQuotaName sets the QuotaName field's value.
func (s *ServiceQuota) SetQuotaName(v string) *ServiceQuota {
	s.QuotaName = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ServiceQuota) SetServiceCode(v string) *ServiceQuota {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceQuota) SetServiceName(v string) *ServiceQuota {
	s.ServiceName = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *ServiceQuota) SetUnit(v string) *ServiceQuota {
	s.Unit = &v
	return s
}

// SetUsageMetric sets the UsageMetric field's value.
func (s *ServiceQuota) SetUsageMetric(v *MetricInfo) *ServiceQuota {
	s.UsageMetric = v
	return s
}

// SetValue sets the Value field's value.
func (s *ServiceQuota) SetValue(v float64) *ServiceQuota {
	s.Value = &v
	return s
}

// Information about a quota increase request.
type ServiceQuotaIncreaseRequestInTemplate struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	AwsRegion *string `min:"1" type:"string"`

	// The new, increased value of the quota.
	DesiredValue *float64 `type:"double"`

	// Indicates whether the quota is global.
	GlobalQuota *bool `type:"boolean"`

	// The quota identifier.
	QuotaCode *string `min:"1" type:"string"`

	// The quota name.
	QuotaName *string `type:"string"`

	// The service identifier.
	ServiceCode *string `min:"1" type:"string"`

	// The service name.
	ServiceName *string `type:"string"`

	// The unit of measurement.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s ServiceQuotaIncreaseRequestInTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaIncreaseRequestInTemplate) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetAwsRegion(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.AwsRegion = &v
	return s
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetDesiredValue(v float64) *ServiceQuotaIncreaseRequestInTemplate {
	s.DesiredValue = &v
	return s
}

// SetGlobalQuota sets the GlobalQuota field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetGlobalQuota(v bool) *ServiceQuotaIncreaseRequestInTemplate {
	s.GlobalQuota = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetQuotaCode(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.QuotaCode = &v
	return s
}

// SetQuotaName sets the QuotaName field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetQuotaName(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.QuotaName = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetServiceCode(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetServiceName(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.ServiceName = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetUnit(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.Unit = &v
	return s
}

// The quota request template is not associated with your organization.
type ServiceQuotaTemplateNotInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaTemplateNotInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaTemplateNotInUseException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaTemplateNotInUseException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaTemplateNotInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaTemplateNotInUseException) Code() string {
	return "ServiceQuotaTemplateNotInUseException"
}

// Message returns the exception's message.
func (s *ServiceQuotaTemplateNotInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaTemplateNotInUseException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaTemplateNotInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaTemplateNotInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaTemplateNotInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex data type that contains a tag key and tag value.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that contains a tag key. The string length should be between 1 and
	// 128 characters. Valid characters include a-z, A-Z, 0-9, space, and the special
	// characters _ - . : / = + @.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that contains an optional tag value. The string length should be
	// between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space,
	// and the special characters _ - . : / = + @.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The specified tag is a reserved word and cannot be used.
type TagPolicyViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TagPolicyViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagPolicyViolationException) GoString() string {
	return s.String()
}

func newErrorTagPolicyViolationException(v protocol.ResponseMetadata) error {
	return &TagPolicyViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagPolicyViolationException) Code() string {
	return "TagPolicyViolationException"
}

// Message returns the exception's message.
func (s *TagPolicyViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagPolicyViolationException) OrigErr() error {
	return nil
}

func (s *TagPolicyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagPolicyViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagPolicyViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the applied quota. You can get this information
	// by using the Service Quotas console, or by listing the quotas using the list-service-quotas
	// (https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
	// AWS CLI command or the ListServiceQuotas (https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html)
	// AWS API operation.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags that you want to add to the resource.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The Service Quotas template is not available in this AWS Region.
type TemplatesNotAvailableInRegionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TemplatesNotAvailableInRegionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplatesNotAvailableInRegionException) GoString() string {
	return s.String()
}

func newErrorTemplatesNotAvailableInRegionException(v protocol.ResponseMetadata) error {
	return &TemplatesNotAvailableInRegionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TemplatesNotAvailableInRegionException) Code() string {
	return "TemplatesNotAvailableInRegionException"
}

// Message returns the exception's message.
func (s *TemplatesNotAvailableInRegionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TemplatesNotAvailableInRegionException) OrigErr() error {
	return nil
}

func (s *TemplatesNotAvailableInRegionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TemplatesNotAvailableInRegionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TemplatesNotAvailableInRegionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Due to throttling, the request was denied. Slow down the rate of request
// calls, or request an increase for this quota.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You've exceeded the number of tags allowed for a resource. For more information,
// see Tag restrictions (https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions)
// in the Service Quotas User Guide.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the applied quota that you want to untag.
	// You can get this information by using the Service Quotas console, or by listing
	// the quotas using the list-service-quotas (https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
	// AWS CLI command or the ListServiceQuotas (https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html)
	// AWS API operation.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The keys of the tags that you want to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// ErrorCodeDependencyAccessDeniedError is a ErrorCode enum value
	ErrorCodeDependencyAccessDeniedError = "DEPENDENCY_ACCESS_DENIED_ERROR"

	// ErrorCodeDependencyThrottlingError is a ErrorCode enum value
	ErrorCodeDependencyThrottlingError = "DEPENDENCY_THROTTLING_ERROR"

	// ErrorCodeDependencyServiceError is a ErrorCode enum value
	ErrorCodeDependencyServiceError = "DEPENDENCY_SERVICE_ERROR"

	// ErrorCodeServiceQuotaNotAvailableError is a ErrorCode enum value
	ErrorCodeServiceQuotaNotAvailableError = "SERVICE_QUOTA_NOT_AVAILABLE_ERROR"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeDependencyAccessDeniedError,
		ErrorCodeDependencyThrottlingError,
		ErrorCodeDependencyServiceError,
		ErrorCodeServiceQuotaNotAvailableError,
	}
}

const (
	// PeriodUnitMicrosecond is a PeriodUnit enum value
	PeriodUnitMicrosecond = "MICROSECOND"

	// PeriodUnitMillisecond is a PeriodUnit enum value
	PeriodUnitMillisecond = "MILLISECOND"

	// PeriodUnitSecond is a PeriodUnit enum value
	PeriodUnitSecond = "SECOND"

	// PeriodUnitMinute is a PeriodUnit enum value
	PeriodUnitMinute = "MINUTE"

	// PeriodUnitHour is a PeriodUnit enum value
	PeriodUnitHour = "HOUR"

	// PeriodUnitDay is a PeriodUnit enum value
	PeriodUnitDay = "DAY"

	// PeriodUnitWeek is a PeriodUnit enum value
	PeriodUnitWeek = "WEEK"
)

// PeriodUnit_Values returns all elements of the PeriodUnit enum
func PeriodUnit_Values() []string {
	return []string{
		PeriodUnitMicrosecond,
		PeriodUnitMillisecond,
		PeriodUnitSecond,
		PeriodUnitMinute,
		PeriodUnitHour,
		PeriodUnitDay,
		PeriodUnitWeek,
	}
}

const (
	// RequestStatusPending is a RequestStatus enum value
	RequestStatusPending = "PENDING"

	// RequestStatusCaseOpened is a RequestStatus enum value
	RequestStatusCaseOpened = "CASE_OPENED"

	// RequestStatusApproved is a RequestStatus enum value
	RequestStatusApproved = "APPROVED"

	// RequestStatusDenied is a RequestStatus enum value
	RequestStatusDenied = "DENIED"

	// RequestStatusCaseClosed is a RequestStatus enum value
	RequestStatusCaseClosed = "CASE_CLOSED"
)

// RequestStatus_Values returns all elements of the RequestStatus enum
func RequestStatus_Values() []string {
	return []string{
		RequestStatusPending,
		RequestStatusCaseOpened,
		RequestStatusApproved,
		RequestStatusDenied,
		RequestStatusCaseClosed,
	}
}

const (
	// ServiceQuotaTemplateAssociationStatusAssociated is a ServiceQuotaTemplateAssociationStatus enum value
	ServiceQuotaTemplateAssociationStatusAssociated = "ASSOCIATED"

	// ServiceQuotaTemplateAssociationStatusDisassociated is a ServiceQuotaTemplateAssociationStatus enum value
	ServiceQuotaTemplateAssociationStatusDisassociated = "DISASSOCIATED"
)

// ServiceQuotaTemplateAssociationStatus_Values returns all elements of the ServiceQuotaTemplateAssociationStatus enum
func ServiceQuotaTemplateAssociationStatus_Values() []string {
	return []string{
		ServiceQuotaTemplateAssociationStatusAssociated,
		ServiceQuotaTemplateAssociationStatusDisassociated,
	}
}
