// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opCreateCachePolicy = "CreateCachePolicy2020_05_31"

// CreateCachePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateCachePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCachePolicy for more information on using the CreateCachePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCachePolicyRequest method.
//    req, resp := client.CreateCachePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy
func (c *CloudFront) CreateCachePolicyRequest(input *CreateCachePolicyInput) (req *request.Request, output *CreateCachePolicyOutput) {
	op := &request.Operation{
		Name:       opCreateCachePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/cache-policy",
	}

	if input == nil {
		input = &CreateCachePolicyInput{}
	}

	output = &CreateCachePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCachePolicy API operation for Amazon CloudFront.
//
// Creates a cache policy.
//
// After you create a cache policy, you can attach it to one or more cache behaviors.
// When it’s attached to a cache behavior, the cache policy determines the
// following:
//
//    * The values that CloudFront includes in the cache key. These values can
//    include HTTP headers, cookies, and URL query strings. CloudFront uses
//    the cache key to find an object in its cache that it can return to the
//    viewer.
//
//    * The default, minimum, and maximum time to live (TTL) values that you
//    want objects to stay in the CloudFront cache.
//
// The headers, cookies, and query strings that are included in the cache key
// are automatically included in requests that CloudFront sends to the origin.
// CloudFront sends a request when it can’t find an object in its cache that
// matches the request’s cache key. If you want to send values to the origin
// but not include them in the cache key, use OriginRequestPolicy.
//
// For more information about cache policies, see Controlling the cache key
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateCachePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeCachePolicyAlreadyExists "CachePolicyAlreadyExists"
//   A cache policy with this name already exists. You must provide a unique name.
//   To modify an existing cache policy, use UpdateCachePolicy.
//
//   * ErrCodeTooManyCachePolicies "TooManyCachePolicies"
//   You have reached the maximum number of cache policies for this AWS account.
//   For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyHeadersInCachePolicy "TooManyHeadersInCachePolicy"
//   The number of headers in the cache policy exceeds the maximum. For more information,
//   see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyCookiesInCachePolicy "TooManyCookiesInCachePolicy"
//   The number of cookies in the cache policy exceeds the maximum. For more information,
//   see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyQueryStringsInCachePolicy "TooManyQueryStringsInCachePolicy"
//   The number of query strings in the cache policy exceeds the maximum. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy
func (c *CloudFront) CreateCachePolicy(input *CreateCachePolicyInput) (*CreateCachePolicyOutput, error) {
	req, out := c.CreateCachePolicyRequest(input)
	return out, req.Send()
}

// CreateCachePolicyWithContext is the same as CreateCachePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCachePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateCachePolicyWithContext(ctx aws.Context, input *CreateCachePolicyInput, opts ...request.Option) (*CreateCachePolicyOutput, error) {
	req, out := c.CreateCachePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCloudFrontOriginAccessIdentity = "CreateCloudFrontOriginAccessIdentity2020_05_31"

// CreateCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudFrontOriginAccessIdentity for more information on using the CreateCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.CreateCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity
func (c *CloudFront) CreateCloudFrontOriginAccessIdentityRequest(input *CreateCloudFrontOriginAccessIdentityInput) (req *request.Request, output *CreateCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opCreateCloudFrontOriginAccessIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront",
	}

	if input == nil {
		input = &CreateCloudFrontOriginAccessIdentityInput{}
	}

	output = &CreateCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Creates a new origin access identity. If you're using Amazon S3 for your
// origin, you can use an origin access identity to require users to access
// your content using a CloudFront URL instead of the Amazon S3 URL. For more
// information about how to use origin access identities, see Serving Private
// Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOriginAccessIdentityAlreadyExists "CloudFrontOriginAccessIdentityAlreadyExists"
//   If the CallerReference is a value you already sent in a previous request
//   to create an identity but the content of the CloudFrontOriginAccessIdentityConfig
//   is different from the original request, CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists
//   error.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyCloudFrontOriginAccessIdentities "TooManyCloudFrontOriginAccessIdentities"
//   Processing your request would cause you to exceed the maximum number of origin
//   access identities allowed.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity
func (c *CloudFront) CreateCloudFrontOriginAccessIdentity(input *CreateCloudFrontOriginAccessIdentityInput) (*CreateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.CreateCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// CreateCloudFrontOriginAccessIdentityWithContext is the same as CreateCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *CreateCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*CreateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.CreateCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDistribution = "CreateDistribution2020_05_31"

// CreateDistributionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDistribution for more information on using the CreateDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDistributionRequest method.
//    req, resp := client.CreateDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution
func (c *CloudFront) CreateDistributionRequest(input *CreateDistributionInput) (req *request.Request, output *CreateDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/distribution",
	}

	if input == nil {
		input = &CreateDistributionInput{}
	}

	output = &CreateDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDistribution API operation for Amazon CloudFront.
//
// Creates a new web distribution. You create a CloudFront distribution to tell
// CloudFront where you want content to be delivered from, and the details about
// how to track and manage content delivery. Send a POST request to the /CloudFront
// API version/distribution/distribution ID resource.
//
// When you update a distribution, there are more required fields than when
// you create a distribution. When you update your distribution by using UpdateDistribution
// (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html),
// follow the steps included in the documentation to get the current configuration
// and then make your updates. This helps to make sure that you include all
// of the required fields. To view a summary, see Required Fields for Create
// Distribution and Update Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeDistributionAlreadyExists "DistributionAlreadyExists"
//   The caller reference you attempted to create the distribution with is associated
//   with another distribution.
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInvalidViewerCertificate "InvalidViewerCertificate"
//   A viewer certificate specified is not valid.
//
//   * ErrCodeInvalidMinimumProtocolVersion "InvalidMinimumProtocolVersion"
//   The minimum protocol version specified is not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyDistributionCNAMEs "TooManyDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyDistributions "TooManyDistributions"
//   Processing your request would cause you to exceed the maximum number of distributions
//   allowed.
//
//   * ErrCodeInvalidDefaultRootObject "InvalidDefaultRootObject"
//   The default root object file name is too big or contains an invalid character.
//
//   * ErrCodeInvalidRelativePath "InvalidRelativePath"
//   The relative path is too big, is not URL-encoded, or does not begin with
//   a slash (/).
//
//   * ErrCodeInvalidErrorCode "InvalidErrorCode"
//   An invalid error code was specified.
//
//   * ErrCodeInvalidResponseCode "InvalidResponseCode"
//   A response code is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidRequiredProtocol "InvalidRequiredProtocol"
//   This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
//   protocol in your request, or omit the RequiredProtocols element from your
//   distribution configuration.
//
//   * ErrCodeNoSuchOrigin "NoSuchOrigin"
//   No origin exists with the specified Origin Id.
//
//   * ErrCodeTooManyOrigins "TooManyOrigins"
//   You cannot create more origins for the distribution.
//
//   * ErrCodeTooManyOriginGroupsPerDistribution "TooManyOriginGroupsPerDistribution"
//   Processing your request would cause you to exceed the maximum number of origin
//   groups allowed.
//
//   * ErrCodeTooManyCacheBehaviors "TooManyCacheBehaviors"
//   You cannot create more cache behaviors for the distribution.
//
//   * ErrCodeTooManyCookieNamesInWhiteList "TooManyCookieNamesInWhiteList"
//   Your request contains more cookie names in the whitelist than are allowed
//   per cache behavior.
//
//   * ErrCodeInvalidForwardCookies "InvalidForwardCookies"
//   Your request contains forward cookies option which doesn't match with the
//   expectation for the whitelisted list of cookie names. Either list of cookie
//   names has been specified when not allowed or list of cookie names is missing
//   when expected.
//
//   * ErrCodeTooManyHeadersInForwardedValues "TooManyHeadersInForwardedValues"
//   Your request contains too many headers in forwarded values.
//
//   * ErrCodeInvalidHeadersForS3Origin "InvalidHeadersForS3Origin"
//   The headers specified are not valid for an Amazon S3 origin.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeTooManyCertificates "TooManyCertificates"
//   You cannot create anymore custom SSL/TLS certificates.
//
//   * ErrCodeInvalidLocationCode "InvalidLocationCode"
//   The location code specified is not valid.
//
//   * ErrCodeInvalidGeoRestrictionParameter "InvalidGeoRestrictionParameter"
//   The specified geo restriction parameter is not valid.
//
//   * ErrCodeInvalidProtocolSettings "InvalidProtocolSettings"
//   You cannot specify SSLv3 as the minimum protocol version if you only want
//   to support only clients that support Server Name Indication (SNI).
//
//   * ErrCodeInvalidTTLOrder "InvalidTTLOrder"
//   The TTL order specified is not valid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
//   * ErrCodeTooManyOriginCustomHeaders "TooManyOriginCustomHeaders"
//   Your request contains too many origin custom headers.
//
//   * ErrCodeTooManyQueryStringParameters "TooManyQueryStringParameters"
//   Your request contains too many query string parameters.
//
//   * ErrCodeInvalidQueryStringParameters "InvalidQueryStringParameters"
//   The query string parameters specified are not valid.
//
//   * ErrCodeTooManyDistributionsWithLambdaAssociations "TooManyDistributionsWithLambdaAssociations"
//   Processing your request would cause the maximum number of distributions with
//   Lambda function associations per owner to be exceeded.
//
//   * ErrCodeTooManyDistributionsWithSingleFunctionARN "TooManyDistributionsWithSingleFunctionARN"
//   The maximum number of distributions have been associated with the specified
//   Lambda function.
//
//   * ErrCodeTooManyLambdaFunctionAssociations "TooManyLambdaFunctionAssociations"
//   Your request contains more Lambda function associations than are allowed
//   per distribution.
//
//   * ErrCodeInvalidLambdaFunctionAssociation "InvalidLambdaFunctionAssociation"
//   The specified Lambda function association is invalid.
//
//   * ErrCodeInvalidOriginReadTimeout "InvalidOriginReadTimeout"
//   The read timeout specified for the origin is not valid.
//
//   * ErrCodeInvalidOriginKeepaliveTimeout "InvalidOriginKeepaliveTimeout"
//   The keep alive timeout specified for the origin is not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodeIllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
//   The specified configuration for field-level encryption can't be associated
//   with the specified cache behavior.
//
//   * ErrCodeTooManyDistributionsAssociatedToFieldLevelEncryptionConfig "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
//   The maximum number of distributions have been associated with the specified
//   configuration for field-level encryption.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodeTooManyDistributionsAssociatedToCachePolicy "TooManyDistributionsAssociatedToCachePolicy"
//   The maximum number of distributions have been associated with the specified
//   cache policy. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodeTooManyDistributionsAssociatedToOriginRequestPolicy "TooManyDistributionsAssociatedToOriginRequestPolicy"
//   The maximum number of distributions have been associated with the specified
//   origin request policy. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyDistributionsAssociatedToKeyGroup "TooManyDistributionsAssociatedToKeyGroup"
//   The number of distributions that reference this key group is more than the
//   maximum allowed. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyKeyGroupsAssociatedToDistribution "TooManyKeyGroupsAssociatedToDistribution"
//   The number of key groups referenced by this distribution is more than the
//   maximum allowed. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTrustedKeyGroupDoesNotExist "TrustedKeyGroupDoesNotExist"
//   The specified key group does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution
func (c *CloudFront) CreateDistribution(input *CreateDistributionInput) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	return out, req.Send()
}

// CreateDistributionWithContext is the same as CreateDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateDistributionWithContext(ctx aws.Context, input *CreateDistributionInput, opts ...request.Option) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDistributionWithTags = "CreateDistributionWithTags2020_05_31"

// CreateDistributionWithTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateDistributionWithTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDistributionWithTags for more information on using the CreateDistributionWithTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDistributionWithTagsRequest method.
//    req, resp := client.CreateDistributionWithTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags
func (c *CloudFront) CreateDistributionWithTagsRequest(input *CreateDistributionWithTagsInput) (req *request.Request, output *CreateDistributionWithTagsOutput) {
	op := &request.Operation{
		Name:       opCreateDistributionWithTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/distribution?WithTags",
	}

	if input == nil {
		input = &CreateDistributionWithTagsInput{}
	}

	output = &CreateDistributionWithTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDistributionWithTags API operation for Amazon CloudFront.
//
// Create a new distribution with tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateDistributionWithTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeDistributionAlreadyExists "DistributionAlreadyExists"
//   The caller reference you attempted to create the distribution with is associated
//   with another distribution.
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInvalidViewerCertificate "InvalidViewerCertificate"
//   A viewer certificate specified is not valid.
//
//   * ErrCodeInvalidMinimumProtocolVersion "InvalidMinimumProtocolVersion"
//   The minimum protocol version specified is not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyDistributionCNAMEs "TooManyDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyDistributions "TooManyDistributions"
//   Processing your request would cause you to exceed the maximum number of distributions
//   allowed.
//
//   * ErrCodeInvalidDefaultRootObject "InvalidDefaultRootObject"
//   The default root object file name is too big or contains an invalid character.
//
//   * ErrCodeInvalidRelativePath "InvalidRelativePath"
//   The relative path is too big, is not URL-encoded, or does not begin with
//   a slash (/).
//
//   * ErrCodeInvalidErrorCode "InvalidErrorCode"
//   An invalid error code was specified.
//
//   * ErrCodeInvalidResponseCode "InvalidResponseCode"
//   A response code is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidRequiredProtocol "InvalidRequiredProtocol"
//   This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
//   protocol in your request, or omit the RequiredProtocols element from your
//   distribution configuration.
//
//   * ErrCodeNoSuchOrigin "NoSuchOrigin"
//   No origin exists with the specified Origin Id.
//
//   * ErrCodeTooManyOrigins "TooManyOrigins"
//   You cannot create more origins for the distribution.
//
//   * ErrCodeTooManyOriginGroupsPerDistribution "TooManyOriginGroupsPerDistribution"
//   Processing your request would cause you to exceed the maximum number of origin
//   groups allowed.
//
//   * ErrCodeTooManyCacheBehaviors "TooManyCacheBehaviors"
//   You cannot create more cache behaviors for the distribution.
//
//   * ErrCodeTooManyCookieNamesInWhiteList "TooManyCookieNamesInWhiteList"
//   Your request contains more cookie names in the whitelist than are allowed
//   per cache behavior.
//
//   * ErrCodeInvalidForwardCookies "InvalidForwardCookies"
//   Your request contains forward cookies option which doesn't match with the
//   expectation for the whitelisted list of cookie names. Either list of cookie
//   names has been specified when not allowed or list of cookie names is missing
//   when expected.
//
//   * ErrCodeTooManyHeadersInForwardedValues "TooManyHeadersInForwardedValues"
//   Your request contains too many headers in forwarded values.
//
//   * ErrCodeInvalidHeadersForS3Origin "InvalidHeadersForS3Origin"
//   The headers specified are not valid for an Amazon S3 origin.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeTooManyCertificates "TooManyCertificates"
//   You cannot create anymore custom SSL/TLS certificates.
//
//   * ErrCodeInvalidLocationCode "InvalidLocationCode"
//   The location code specified is not valid.
//
//   * ErrCodeInvalidGeoRestrictionParameter "InvalidGeoRestrictionParameter"
//   The specified geo restriction parameter is not valid.
//
//   * ErrCodeInvalidProtocolSettings "InvalidProtocolSettings"
//   You cannot specify SSLv3 as the minimum protocol version if you only want
//   to support only clients that support Server Name Indication (SNI).
//
//   * ErrCodeInvalidTTLOrder "InvalidTTLOrder"
//   The TTL order specified is not valid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
//   * ErrCodeTooManyOriginCustomHeaders "TooManyOriginCustomHeaders"
//   Your request contains too many origin custom headers.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeTooManyQueryStringParameters "TooManyQueryStringParameters"
//   Your request contains too many query string parameters.
//
//   * ErrCodeInvalidQueryStringParameters "InvalidQueryStringParameters"
//   The query string parameters specified are not valid.
//
//   * ErrCodeTooManyDistributionsWithLambdaAssociations "TooManyDistributionsWithLambdaAssociations"
//   Processing your request would cause the maximum number of distributions with
//   Lambda function associations per owner to be exceeded.
//
//   * ErrCodeTooManyDistributionsWithSingleFunctionARN "TooManyDistributionsWithSingleFunctionARN"
//   The maximum number of distributions have been associated with the specified
//   Lambda function.
//
//   * ErrCodeTooManyLambdaFunctionAssociations "TooManyLambdaFunctionAssociations"
//   Your request contains more Lambda function associations than are allowed
//   per distribution.
//
//   * ErrCodeInvalidLambdaFunctionAssociation "InvalidLambdaFunctionAssociation"
//   The specified Lambda function association is invalid.
//
//   * ErrCodeInvalidOriginReadTimeout "InvalidOriginReadTimeout"
//   The read timeout specified for the origin is not valid.
//
//   * ErrCodeInvalidOriginKeepaliveTimeout "InvalidOriginKeepaliveTimeout"
//   The keep alive timeout specified for the origin is not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodeIllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
//   The specified configuration for field-level encryption can't be associated
//   with the specified cache behavior.
//
//   * ErrCodeTooManyDistributionsAssociatedToFieldLevelEncryptionConfig "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
//   The maximum number of distributions have been associated with the specified
//   configuration for field-level encryption.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodeTooManyDistributionsAssociatedToCachePolicy "TooManyDistributionsAssociatedToCachePolicy"
//   The maximum number of distributions have been associated with the specified
//   cache policy. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodeTooManyDistributionsAssociatedToOriginRequestPolicy "TooManyDistributionsAssociatedToOriginRequestPolicy"
//   The maximum number of distributions have been associated with the specified
//   origin request policy. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyDistributionsAssociatedToKeyGroup "TooManyDistributionsAssociatedToKeyGroup"
//   The number of distributions that reference this key group is more than the
//   maximum allowed. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyKeyGroupsAssociatedToDistribution "TooManyKeyGroupsAssociatedToDistribution"
//   The number of key groups referenced by this distribution is more than the
//   maximum allowed. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTrustedKeyGroupDoesNotExist "TrustedKeyGroupDoesNotExist"
//   The specified key group does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags
func (c *CloudFront) CreateDistributionWithTags(input *CreateDistributionWithTagsInput) (*CreateDistributionWithTagsOutput, error) {
	req, out := c.CreateDistributionWithTagsRequest(input)
	return out, req.Send()
}

// CreateDistributionWithTagsWithContext is the same as CreateDistributionWithTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDistributionWithTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateDistributionWithTagsWithContext(ctx aws.Context, input *CreateDistributionWithTagsInput, opts ...request.Option) (*CreateDistributionWithTagsOutput, error) {
	req, out := c.CreateDistributionWithTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFieldLevelEncryptionConfig = "CreateFieldLevelEncryptionConfig2020_05_31"

// CreateFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFieldLevelEncryptionConfig for more information on using the CreateFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFieldLevelEncryptionConfigRequest method.
//    req, resp := client.CreateFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig
func (c *CloudFront) CreateFieldLevelEncryptionConfigRequest(input *CreateFieldLevelEncryptionConfigInput) (req *request.Request, output *CreateFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opCreateFieldLevelEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/field-level-encryption",
	}

	if input == nil {
		input = &CreateFieldLevelEncryptionConfigInput{}
	}

	output = &CreateFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Create a new field-level encryption configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodeFieldLevelEncryptionConfigAlreadyExists "FieldLevelEncryptionConfigAlreadyExists"
//   The specified configuration for field-level encryption already exists.
//
//   * ErrCodeTooManyFieldLevelEncryptionConfigs "TooManyFieldLevelEncryptionConfigs"
//   The maximum number of configurations for field-level encryption have been
//   created.
//
//   * ErrCodeTooManyFieldLevelEncryptionQueryArgProfiles "TooManyFieldLevelEncryptionQueryArgProfiles"
//   The maximum number of query arg profiles for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionContentTypeProfiles "TooManyFieldLevelEncryptionContentTypeProfiles"
//   The maximum number of content type profiles for field-level encryption have
//   been created.
//
//   * ErrCodeQueryArgProfileEmpty "QueryArgProfileEmpty"
//   No profile specified for the field-level encryption query argument.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig
func (c *CloudFront) CreateFieldLevelEncryptionConfig(input *CreateFieldLevelEncryptionConfigInput) (*CreateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.CreateFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// CreateFieldLevelEncryptionConfigWithContext is the same as CreateFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *CreateFieldLevelEncryptionConfigInput, opts ...request.Option) (*CreateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.CreateFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFieldLevelEncryptionProfile = "CreateFieldLevelEncryptionProfile2020_05_31"

// CreateFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFieldLevelEncryptionProfile for more information on using the CreateFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFieldLevelEncryptionProfileRequest method.
//    req, resp := client.CreateFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile
func (c *CloudFront) CreateFieldLevelEncryptionProfileRequest(input *CreateFieldLevelEncryptionProfileInput) (req *request.Request, output *CreateFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opCreateFieldLevelEncryptionProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/field-level-encryption-profile",
	}

	if input == nil {
		input = &CreateFieldLevelEncryptionProfileInput{}
	}

	output = &CreateFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Create a field-level encryption profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodeFieldLevelEncryptionProfileAlreadyExists "FieldLevelEncryptionProfileAlreadyExists"
//   The specified profile for field-level encryption already exists.
//
//   * ErrCodeFieldLevelEncryptionProfileSizeExceeded "FieldLevelEncryptionProfileSizeExceeded"
//   The maximum size of a profile for field-level encryption was exceeded.
//
//   * ErrCodeTooManyFieldLevelEncryptionProfiles "TooManyFieldLevelEncryptionProfiles"
//   The maximum number of profiles for field-level encryption have been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionEncryptionEntities "TooManyFieldLevelEncryptionEncryptionEntities"
//   The maximum number of encryption entities for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionFieldPatterns "TooManyFieldLevelEncryptionFieldPatterns"
//   The maximum number of field patterns for field-level encryption have been
//   created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile
func (c *CloudFront) CreateFieldLevelEncryptionProfile(input *CreateFieldLevelEncryptionProfileInput) (*CreateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.CreateFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// CreateFieldLevelEncryptionProfileWithContext is the same as CreateFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *CreateFieldLevelEncryptionProfileInput, opts ...request.Option) (*CreateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.CreateFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInvalidation = "CreateInvalidation2020_05_31"

// CreateInvalidationRequest generates a "aws/request.Request" representing the
// client's request for the CreateInvalidation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInvalidation for more information on using the CreateInvalidation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInvalidationRequest method.
//    req, resp := client.CreateInvalidationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation
func (c *CloudFront) CreateInvalidationRequest(input *CreateInvalidationInput) (req *request.Request, output *CreateInvalidationOutput) {
	op := &request.Operation{
		Name:       opCreateInvalidation,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/distribution/{DistributionId}/invalidation",
	}

	if input == nil {
		input = &CreateInvalidationInput{}
	}

	output = &CreateInvalidationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInvalidation API operation for Amazon CloudFront.
//
// Create a new invalidation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateInvalidation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeBatchTooLarge "BatchTooLarge"
//   Invalidation batch specified is too large.
//
//   * ErrCodeTooManyInvalidationsInProgress "TooManyInvalidationsInProgress"
//   You have exceeded the maximum number of allowable InProgress invalidation
//   batch requests, or invalidation objects.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation
func (c *CloudFront) CreateInvalidation(input *CreateInvalidationInput) (*CreateInvalidationOutput, error) {
	req, out := c.CreateInvalidationRequest(input)
	return out, req.Send()
}

// CreateInvalidationWithContext is the same as CreateInvalidation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInvalidation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateInvalidationWithContext(ctx aws.Context, input *CreateInvalidationInput, opts ...request.Option) (*CreateInvalidationOutput, error) {
	req, out := c.CreateInvalidationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyGroup = "CreateKeyGroup2020_05_31"

// CreateKeyGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyGroup for more information on using the CreateKeyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeyGroupRequest method.
//    req, resp := client.CreateKeyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup
func (c *CloudFront) CreateKeyGroupRequest(input *CreateKeyGroupInput) (req *request.Request, output *CreateKeyGroupOutput) {
	op := &request.Operation{
		Name:       opCreateKeyGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/key-group",
	}

	if input == nil {
		input = &CreateKeyGroupInput{}
	}

	output = &CreateKeyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyGroup API operation for Amazon CloudFront.
//
// Creates a key group that you can use with CloudFront signed URLs and signed
// cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
//
// To create a key group, you must specify at least one public key for the key
// group. After you create a key group, you can reference it from one or more
// cache behaviors. When you reference a key group in a cache behavior, CloudFront
// requires signed URLs or signed cookies for all requests that match the cache
// behavior. The URLs or cookies must be signed with a private key whose corresponding
// public key is in the key group. The signed URL or cookie contains information
// about which public key CloudFront should use to verify the signature. For
// more information, see Serving private content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateKeyGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeKeyGroupAlreadyExists "KeyGroupAlreadyExists"
//   A key group with this name already exists. You must provide a unique name.
//   To modify an existing key group, use UpdateKeyGroup.
//
//   * ErrCodeTooManyKeyGroups "TooManyKeyGroups"
//   You have reached the maximum number of key groups for this AWS account. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyPublicKeysInKeyGroup "TooManyPublicKeysInKeyGroup"
//   The number of public keys in this key group is more than the maximum allowed.
//   For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup
func (c *CloudFront) CreateKeyGroup(input *CreateKeyGroupInput) (*CreateKeyGroupOutput, error) {
	req, out := c.CreateKeyGroupRequest(input)
	return out, req.Send()
}

// CreateKeyGroupWithContext is the same as CreateKeyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateKeyGroupWithContext(ctx aws.Context, input *CreateKeyGroupInput, opts ...request.Option) (*CreateKeyGroupOutput, error) {
	req, out := c.CreateKeyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMonitoringSubscription = "CreateMonitoringSubscription2020_05_31"

// CreateMonitoringSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateMonitoringSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMonitoringSubscription for more information on using the CreateMonitoringSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMonitoringSubscriptionRequest method.
//    req, resp := client.CreateMonitoringSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription
func (c *CloudFront) CreateMonitoringSubscriptionRequest(input *CreateMonitoringSubscriptionInput) (req *request.Request, output *CreateMonitoringSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateMonitoringSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
	}

	if input == nil {
		input = &CreateMonitoringSubscriptionInput{}
	}

	output = &CreateMonitoringSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMonitoringSubscription API operation for Amazon CloudFront.
//
// Enables additional CloudWatch metrics for the specified CloudFront distribution.
// The additional metrics incur an additional cost.
//
// For more information, see Viewing additional CloudFront distribution metrics
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateMonitoringSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription
func (c *CloudFront) CreateMonitoringSubscription(input *CreateMonitoringSubscriptionInput) (*CreateMonitoringSubscriptionOutput, error) {
	req, out := c.CreateMonitoringSubscriptionRequest(input)
	return out, req.Send()
}

// CreateMonitoringSubscriptionWithContext is the same as CreateMonitoringSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMonitoringSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateMonitoringSubscriptionWithContext(ctx aws.Context, input *CreateMonitoringSubscriptionInput, opts ...request.Option) (*CreateMonitoringSubscriptionOutput, error) {
	req, out := c.CreateMonitoringSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOriginRequestPolicy = "CreateOriginRequestPolicy2020_05_31"

// CreateOriginRequestPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateOriginRequestPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOriginRequestPolicy for more information on using the CreateOriginRequestPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOriginRequestPolicyRequest method.
//    req, resp := client.CreateOriginRequestPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy
func (c *CloudFront) CreateOriginRequestPolicyRequest(input *CreateOriginRequestPolicyInput) (req *request.Request, output *CreateOriginRequestPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateOriginRequestPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/origin-request-policy",
	}

	if input == nil {
		input = &CreateOriginRequestPolicyInput{}
	}

	output = &CreateOriginRequestPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOriginRequestPolicy API operation for Amazon CloudFront.
//
// Creates an origin request policy.
//
// After you create an origin request policy, you can attach it to one or more
// cache behaviors. When it’s attached to a cache behavior, the origin request
// policy determines the values that CloudFront includes in requests that it
// sends to the origin. Each request that CloudFront sends to the origin includes
// the following:
//
//    * The request body and the URL path (without the domain name) from the
//    viewer request.
//
//    * The headers that CloudFront automatically includes in every origin request,
//    including Host, User-Agent, and X-Amz-Cf-Id.
//
//    * All HTTP headers, cookies, and URL query strings that are specified
//    in the cache policy or the origin request policy. These can include items
//    from the viewer request and, in the case of headers, additional ones that
//    are added by CloudFront.
//
// CloudFront sends a request when it can’t find a valid object in its cache
// that matches the request. If you want to send values to the origin and also
// include them in the cache key, use CachePolicy.
//
// For more information about origin request policies, see Controlling origin
// requests (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateOriginRequestPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeOriginRequestPolicyAlreadyExists "OriginRequestPolicyAlreadyExists"
//   An origin request policy with this name already exists. You must provide
//   a unique name. To modify an existing origin request policy, use UpdateOriginRequestPolicy.
//
//   * ErrCodeTooManyOriginRequestPolicies "TooManyOriginRequestPolicies"
//   You have reached the maximum number of origin request policies for this AWS
//   account. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyHeadersInOriginRequestPolicy "TooManyHeadersInOriginRequestPolicy"
//   The number of headers in the origin request policy exceeds the maximum. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyCookiesInOriginRequestPolicy "TooManyCookiesInOriginRequestPolicy"
//   The number of cookies in the origin request policy exceeds the maximum. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyQueryStringsInOriginRequestPolicy "TooManyQueryStringsInOriginRequestPolicy"
//   The number of query strings in the origin request policy exceeds the maximum.
//   For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy
func (c *CloudFront) CreateOriginRequestPolicy(input *CreateOriginRequestPolicyInput) (*CreateOriginRequestPolicyOutput, error) {
	req, out := c.CreateOriginRequestPolicyRequest(input)
	return out, req.Send()
}

// CreateOriginRequestPolicyWithContext is the same as CreateOriginRequestPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOriginRequestPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateOriginRequestPolicyWithContext(ctx aws.Context, input *CreateOriginRequestPolicyInput, opts ...request.Option) (*CreateOriginRequestPolicyOutput, error) {
	req, out := c.CreateOriginRequestPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicKey = "CreatePublicKey2020_05_31"

// CreatePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicKey for more information on using the CreatePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublicKeyRequest method.
//    req, resp := client.CreatePublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey
func (c *CloudFront) CreatePublicKeyRequest(input *CreatePublicKeyInput) (req *request.Request, output *CreatePublicKeyOutput) {
	op := &request.Operation{
		Name:       opCreatePublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/public-key",
	}

	if input == nil {
		input = &CreatePublicKeyInput{}
	}

	output = &CreatePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicKey API operation for Amazon CloudFront.
//
// Uploads a public key to CloudFront that you can use with signed URLs and
// signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
// or with field-level encryption (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreatePublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePublicKeyAlreadyExists "PublicKeyAlreadyExists"
//   The specified public key already exists.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeTooManyPublicKeys "TooManyPublicKeys"
//   The maximum number of public keys for field-level encryption have been created.
//   To create a new public key, delete one of the existing keys.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey
func (c *CloudFront) CreatePublicKey(input *CreatePublicKeyInput) (*CreatePublicKeyOutput, error) {
	req, out := c.CreatePublicKeyRequest(input)
	return out, req.Send()
}

// CreatePublicKeyWithContext is the same as CreatePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreatePublicKeyWithContext(ctx aws.Context, input *CreatePublicKeyInput, opts ...request.Option) (*CreatePublicKeyOutput, error) {
	req, out := c.CreatePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRealtimeLogConfig = "CreateRealtimeLogConfig2020_05_31"

// CreateRealtimeLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateRealtimeLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRealtimeLogConfig for more information on using the CreateRealtimeLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRealtimeLogConfigRequest method.
//    req, resp := client.CreateRealtimeLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig
func (c *CloudFront) CreateRealtimeLogConfigRequest(input *CreateRealtimeLogConfigInput) (req *request.Request, output *CreateRealtimeLogConfigOutput) {
	op := &request.Operation{
		Name:       opCreateRealtimeLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/realtime-log-config",
	}

	if input == nil {
		input = &CreateRealtimeLogConfigInput{}
	}

	output = &CreateRealtimeLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRealtimeLogConfig API operation for Amazon CloudFront.
//
// Creates a real-time log configuration.
//
// After you create a real-time log configuration, you can attach it to one
// or more cache behaviors to send real-time log data to the specified Amazon
// Kinesis data stream.
//
// For more information about real-time log configurations, see Real-time logs
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateRealtimeLogConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRealtimeLogConfigAlreadyExists "RealtimeLogConfigAlreadyExists"
//   A real-time log configuration with this name already exists. You must provide
//   a unique name. To modify an existing real-time log configuration, use UpdateRealtimeLogConfig.
//
//   * ErrCodeTooManyRealtimeLogConfigs "TooManyRealtimeLogConfigs"
//   You have reached the maximum number of real-time log configurations for this
//   AWS account. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig
func (c *CloudFront) CreateRealtimeLogConfig(input *CreateRealtimeLogConfigInput) (*CreateRealtimeLogConfigOutput, error) {
	req, out := c.CreateRealtimeLogConfigRequest(input)
	return out, req.Send()
}

// CreateRealtimeLogConfigWithContext is the same as CreateRealtimeLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRealtimeLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateRealtimeLogConfigWithContext(ctx aws.Context, input *CreateRealtimeLogConfigInput, opts ...request.Option) (*CreateRealtimeLogConfigOutput, error) {
	req, out := c.CreateRealtimeLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingDistribution = "CreateStreamingDistribution2020_05_31"

// CreateStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingDistribution for more information on using the CreateStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamingDistributionRequest method.
//    req, resp := client.CreateStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution
func (c *CloudFront) CreateStreamingDistributionRequest(input *CreateStreamingDistributionInput) (req *request.Request, output *CreateStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/streaming-distribution",
	}

	if input == nil {
		input = &CreateStreamingDistributionInput{}
	}

	output = &CreateStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingDistribution API operation for Amazon CloudFront.
//
// This API is deprecated. Amazon CloudFront is deprecating real-time messaging
// protocol (RTMP) distributions on December 31, 2020. For more information,
// read the announcement (http://forums.aws.amazon.com/ann.jspa?annID=7356)
// on the Amazon CloudFront discussion forum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeStreamingDistributionAlreadyExists "StreamingDistributionAlreadyExists"
//   The caller reference you attempted to create the streaming distribution with
//   is associated with another distribution
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyStreamingDistributionCNAMEs "TooManyStreamingDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyStreamingDistributions "TooManyStreamingDistributions"
//   Processing your request would cause you to exceed the maximum number of streaming
//   distributions allowed.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution
func (c *CloudFront) CreateStreamingDistribution(input *CreateStreamingDistributionInput) (*CreateStreamingDistributionOutput, error) {
	req, out := c.CreateStreamingDistributionRequest(input)
	return out, req.Send()
}

// CreateStreamingDistributionWithContext is the same as CreateStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateStreamingDistributionWithContext(ctx aws.Context, input *CreateStreamingDistributionInput, opts ...request.Option) (*CreateStreamingDistributionOutput, error) {
	req, out := c.CreateStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingDistributionWithTags = "CreateStreamingDistributionWithTags2020_05_31"

// CreateStreamingDistributionWithTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingDistributionWithTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingDistributionWithTags for more information on using the CreateStreamingDistributionWithTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamingDistributionWithTagsRequest method.
//    req, resp := client.CreateStreamingDistributionWithTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags
func (c *CloudFront) CreateStreamingDistributionWithTagsRequest(input *CreateStreamingDistributionWithTagsInput) (req *request.Request, output *CreateStreamingDistributionWithTagsOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingDistributionWithTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/streaming-distribution?WithTags",
	}

	if input == nil {
		input = &CreateStreamingDistributionWithTagsInput{}
	}

	output = &CreateStreamingDistributionWithTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingDistributionWithTags API operation for Amazon CloudFront.
//
// This API is deprecated. Amazon CloudFront is deprecating real-time messaging
// protocol (RTMP) distributions on December 31, 2020. For more information,
// read the announcement (http://forums.aws.amazon.com/ann.jspa?annID=7356)
// on the Amazon CloudFront discussion forum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateStreamingDistributionWithTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeStreamingDistributionAlreadyExists "StreamingDistributionAlreadyExists"
//   The caller reference you attempted to create the streaming distribution with
//   is associated with another distribution
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyStreamingDistributionCNAMEs "TooManyStreamingDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyStreamingDistributions "TooManyStreamingDistributions"
//   Processing your request would cause you to exceed the maximum number of streaming
//   distributions allowed.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags
func (c *CloudFront) CreateStreamingDistributionWithTags(input *CreateStreamingDistributionWithTagsInput) (*CreateStreamingDistributionWithTagsOutput, error) {
	req, out := c.CreateStreamingDistributionWithTagsRequest(input)
	return out, req.Send()
}

// CreateStreamingDistributionWithTagsWithContext is the same as CreateStreamingDistributionWithTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingDistributionWithTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateStreamingDistributionWithTagsWithContext(ctx aws.Context, input *CreateStreamingDistributionWithTagsInput, opts ...request.Option) (*CreateStreamingDistributionWithTagsOutput, error) {
	req, out := c.CreateStreamingDistributionWithTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCachePolicy = "DeleteCachePolicy2020_05_31"

// DeleteCachePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCachePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCachePolicy for more information on using the DeleteCachePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCachePolicyRequest method.
//    req, resp := client.DeleteCachePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy
func (c *CloudFront) DeleteCachePolicyRequest(input *DeleteCachePolicyInput) (req *request.Request, output *DeleteCachePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteCachePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}",
	}

	if input == nil {
		input = &DeleteCachePolicyInput{}
	}

	output = &DeleteCachePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCachePolicy API operation for Amazon CloudFront.
//
// Deletes a cache policy.
//
// You cannot delete a cache policy if it’s attached to a cache behavior.
// First update your distributions to remove the cache policy from all cache
// behaviors, then delete the cache policy.
//
// To delete a cache policy, you must provide the policy’s identifier and
// version. To get these values, you can use ListCachePolicies or GetCachePolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteCachePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeIllegalDelete "IllegalDelete"
//   You cannot delete a managed policy.
//
//   * ErrCodeCachePolicyInUse "CachePolicyInUse"
//   Cannot delete the cache policy because it is attached to one or more cache
//   behaviors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy
func (c *CloudFront) DeleteCachePolicy(input *DeleteCachePolicyInput) (*DeleteCachePolicyOutput, error) {
	req, out := c.DeleteCachePolicyRequest(input)
	return out, req.Send()
}

// DeleteCachePolicyWithContext is the same as DeleteCachePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCachePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteCachePolicyWithContext(ctx aws.Context, input *DeleteCachePolicyInput, opts ...request.Option) (*DeleteCachePolicyOutput, error) {
	req, out := c.DeleteCachePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCloudFrontOriginAccessIdentity = "DeleteCloudFrontOriginAccessIdentity2020_05_31"

// DeleteCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCloudFrontOriginAccessIdentity for more information on using the DeleteCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.DeleteCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentityRequest(input *DeleteCloudFrontOriginAccessIdentityInput) (req *request.Request, output *DeleteCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteCloudFrontOriginAccessIdentity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &DeleteCloudFrontOriginAccessIdentityInput{}
	}

	output = &DeleteCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Delete an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeOriginAccessIdentityInUse "CloudFrontOriginAccessIdentityInUse"
//   The Origin Access Identity specified is already in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentity(input *DeleteCloudFrontOriginAccessIdentityInput) (*DeleteCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.DeleteCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// DeleteCloudFrontOriginAccessIdentityWithContext is the same as DeleteCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *DeleteCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*DeleteCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.DeleteCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDistribution = "DeleteDistribution2020_05_31"

// DeleteDistributionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDistribution for more information on using the DeleteDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDistributionRequest method.
//    req, resp := client.DeleteDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution
func (c *CloudFront) DeleteDistributionRequest(input *DeleteDistributionInput) (req *request.Request, output *DeleteDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/distribution/{Id}",
	}

	if input == nil {
		input = &DeleteDistributionInput{}
	}

	output = &DeleteDistributionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDistribution API operation for Amazon CloudFront.
//
// Delete a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeDistributionNotDisabled "DistributionNotDisabled"
//   The specified CloudFront distribution is not disabled. You must disable the
//   distribution before you can delete it.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution
func (c *CloudFront) DeleteDistribution(input *DeleteDistributionInput) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	return out, req.Send()
}

// DeleteDistributionWithContext is the same as DeleteDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteDistributionWithContext(ctx aws.Context, input *DeleteDistributionInput, opts ...request.Option) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFieldLevelEncryptionConfig = "DeleteFieldLevelEncryptionConfig2020_05_31"

// DeleteFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFieldLevelEncryptionConfig for more information on using the DeleteFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFieldLevelEncryptionConfigRequest method.
//    req, resp := client.DeleteFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig
func (c *CloudFront) DeleteFieldLevelEncryptionConfigRequest(input *DeleteFieldLevelEncryptionConfigInput) (req *request.Request, output *DeleteFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteFieldLevelEncryptionConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/field-level-encryption/{Id}",
	}

	if input == nil {
		input = &DeleteFieldLevelEncryptionConfigInput{}
	}

	output = &DeleteFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Remove a field-level encryption configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeFieldLevelEncryptionConfigInUse "FieldLevelEncryptionConfigInUse"
//   The specified configuration for field-level encryption is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig
func (c *CloudFront) DeleteFieldLevelEncryptionConfig(input *DeleteFieldLevelEncryptionConfigInput) (*DeleteFieldLevelEncryptionConfigOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// DeleteFieldLevelEncryptionConfigWithContext is the same as DeleteFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *DeleteFieldLevelEncryptionConfigInput, opts ...request.Option) (*DeleteFieldLevelEncryptionConfigOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFieldLevelEncryptionProfile = "DeleteFieldLevelEncryptionProfile2020_05_31"

// DeleteFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFieldLevelEncryptionProfile for more information on using the DeleteFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFieldLevelEncryptionProfileRequest method.
//    req, resp := client.DeleteFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile
func (c *CloudFront) DeleteFieldLevelEncryptionProfileRequest(input *DeleteFieldLevelEncryptionProfileInput) (req *request.Request, output *DeleteFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteFieldLevelEncryptionProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/field-level-encryption-profile/{Id}",
	}

	if input == nil {
		input = &DeleteFieldLevelEncryptionProfileInput{}
	}

	output = &DeleteFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Remove a field-level encryption profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeFieldLevelEncryptionProfileInUse "FieldLevelEncryptionProfileInUse"
//   The specified profile for field-level encryption is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile
func (c *CloudFront) DeleteFieldLevelEncryptionProfile(input *DeleteFieldLevelEncryptionProfileInput) (*DeleteFieldLevelEncryptionProfileOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// DeleteFieldLevelEncryptionProfileWithContext is the same as DeleteFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *DeleteFieldLevelEncryptionProfileInput, opts ...request.Option) (*DeleteFieldLevelEncryptionProfileOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyGroup = "DeleteKeyGroup2020_05_31"

// DeleteKeyGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyGroup for more information on using the DeleteKeyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeyGroupRequest method.
//    req, resp := client.DeleteKeyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup
func (c *CloudFront) DeleteKeyGroupRequest(input *DeleteKeyGroupInput) (req *request.Request, output *DeleteKeyGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/key-group/{Id}",
	}

	if input == nil {
		input = &DeleteKeyGroupInput{}
	}

	output = &DeleteKeyGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKeyGroup API operation for Amazon CloudFront.
//
// Deletes a key group.
//
// You cannot delete a key group that is referenced in a cache behavior. First
// update your distributions to remove the key group from all cache behaviors,
// then delete the key group.
//
// To delete a key group, you must provide the key group’s identifier and
// version. To get these values, use ListKeyGroups followed by GetKeyGroup or
// GetKeyGroupConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteKeyGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeResourceInUse "ResourceInUse"
//   Cannot delete this resource because it is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup
func (c *CloudFront) DeleteKeyGroup(input *DeleteKeyGroupInput) (*DeleteKeyGroupOutput, error) {
	req, out := c.DeleteKeyGroupRequest(input)
	return out, req.Send()
}

// DeleteKeyGroupWithContext is the same as DeleteKeyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteKeyGroupWithContext(ctx aws.Context, input *DeleteKeyGroupInput, opts ...request.Option) (*DeleteKeyGroupOutput, error) {
	req, out := c.DeleteKeyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMonitoringSubscription = "DeleteMonitoringSubscription2020_05_31"

// DeleteMonitoringSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMonitoringSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMonitoringSubscription for more information on using the DeleteMonitoringSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMonitoringSubscriptionRequest method.
//    req, resp := client.DeleteMonitoringSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription
func (c *CloudFront) DeleteMonitoringSubscriptionRequest(input *DeleteMonitoringSubscriptionInput) (req *request.Request, output *DeleteMonitoringSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteMonitoringSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
	}

	if input == nil {
		input = &DeleteMonitoringSubscriptionInput{}
	}

	output = &DeleteMonitoringSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMonitoringSubscription API operation for Amazon CloudFront.
//
// Disables additional CloudWatch metrics for the specified CloudFront distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteMonitoringSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription
func (c *CloudFront) DeleteMonitoringSubscription(input *DeleteMonitoringSubscriptionInput) (*DeleteMonitoringSubscriptionOutput, error) {
	req, out := c.DeleteMonitoringSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteMonitoringSubscriptionWithContext is the same as DeleteMonitoringSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMonitoringSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteMonitoringSubscriptionWithContext(ctx aws.Context, input *DeleteMonitoringSubscriptionInput, opts ...request.Option) (*DeleteMonitoringSubscriptionOutput, error) {
	req, out := c.DeleteMonitoringSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOriginRequestPolicy = "DeleteOriginRequestPolicy2020_05_31"

// DeleteOriginRequestPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOriginRequestPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOriginRequestPolicy for more information on using the DeleteOriginRequestPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOriginRequestPolicyRequest method.
//    req, resp := client.DeleteOriginRequestPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy
func (c *CloudFront) DeleteOriginRequestPolicyRequest(input *DeleteOriginRequestPolicyInput) (req *request.Request, output *DeleteOriginRequestPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteOriginRequestPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}",
	}

	if input == nil {
		input = &DeleteOriginRequestPolicyInput{}
	}

	output = &DeleteOriginRequestPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOriginRequestPolicy API operation for Amazon CloudFront.
//
// Deletes an origin request policy.
//
// You cannot delete an origin request policy if it’s attached to any cache
// behaviors. First update your distributions to remove the origin request policy
// from all cache behaviors, then delete the origin request policy.
//
// To delete an origin request policy, you must provide the policy’s identifier
// and version. To get the identifier, you can use ListOriginRequestPolicies
// or GetOriginRequestPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteOriginRequestPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeIllegalDelete "IllegalDelete"
//   You cannot delete a managed policy.
//
//   * ErrCodeOriginRequestPolicyInUse "OriginRequestPolicyInUse"
//   Cannot delete the origin request policy because it is attached to one or
//   more cache behaviors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy
func (c *CloudFront) DeleteOriginRequestPolicy(input *DeleteOriginRequestPolicyInput) (*DeleteOriginRequestPolicyOutput, error) {
	req, out := c.DeleteOriginRequestPolicyRequest(input)
	return out, req.Send()
}

// DeleteOriginRequestPolicyWithContext is the same as DeleteOriginRequestPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOriginRequestPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteOriginRequestPolicyWithContext(ctx aws.Context, input *DeleteOriginRequestPolicyInput, opts ...request.Option) (*DeleteOriginRequestPolicyOutput, error) {
	req, out := c.DeleteOriginRequestPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicKey = "DeletePublicKey2020_05_31"

// DeletePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicKey for more information on using the DeletePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePublicKeyRequest method.
//    req, resp := client.DeletePublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey
func (c *CloudFront) DeletePublicKeyRequest(input *DeletePublicKeyInput) (req *request.Request, output *DeletePublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeletePublicKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/public-key/{Id}",
	}

	if input == nil {
		input = &DeletePublicKeyInput{}
	}

	output = &DeletePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePublicKey API operation for Amazon CloudFront.
//
// Remove a public key you previously added to CloudFront.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeletePublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodePublicKeyInUse "PublicKeyInUse"
//   The specified public key is in use.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey
func (c *CloudFront) DeletePublicKey(input *DeletePublicKeyInput) (*DeletePublicKeyOutput, error) {
	req, out := c.DeletePublicKeyRequest(input)
	return out, req.Send()
}

// DeletePublicKeyWithContext is the same as DeletePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeletePublicKeyWithContext(ctx aws.Context, input *DeletePublicKeyInput, opts ...request.Option) (*DeletePublicKeyOutput, error) {
	req, out := c.DeletePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRealtimeLogConfig = "DeleteRealtimeLogConfig2020_05_31"

// DeleteRealtimeLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRealtimeLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRealtimeLogConfig for more information on using the DeleteRealtimeLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRealtimeLogConfigRequest method.
//    req, resp := client.DeleteRealtimeLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig
func (c *CloudFront) DeleteRealtimeLogConfigRequest(input *DeleteRealtimeLogConfigInput) (req *request.Request, output *DeleteRealtimeLogConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteRealtimeLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/delete-realtime-log-config/",
	}

	if input == nil {
		input = &DeleteRealtimeLogConfigInput{}
	}

	output = &DeleteRealtimeLogConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRealtimeLogConfig API operation for Amazon CloudFront.
//
// Deletes a real-time log configuration.
//
// You cannot delete a real-time log configuration if it’s attached to a cache
// behavior. First update your distributions to remove the real-time log configuration
// from all cache behaviors, then delete the real-time log configuration.
//
// To delete a real-time log configuration, you can provide the configuration’s
// name or its Amazon Resource Name (ARN). You must provide at least one. If
// you provide both, CloudFront uses the name to identify the real-time log
// configuration to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteRealtimeLogConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchRealtimeLogConfig "NoSuchRealtimeLogConfig"
//   The real-time log configuration does not exist.
//
//   * ErrCodeRealtimeLogConfigInUse "RealtimeLogConfigInUse"
//   Cannot delete the real-time log configuration because it is attached to one
//   or more cache behaviors.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig
func (c *CloudFront) DeleteRealtimeLogConfig(input *DeleteRealtimeLogConfigInput) (*DeleteRealtimeLogConfigOutput, error) {
	req, out := c.DeleteRealtimeLogConfigRequest(input)
	return out, req.Send()
}

// DeleteRealtimeLogConfigWithContext is the same as DeleteRealtimeLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRealtimeLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteRealtimeLogConfigWithContext(ctx aws.Context, input *DeleteRealtimeLogConfigInput, opts ...request.Option) (*DeleteRealtimeLogConfigOutput, error) {
	req, out := c.DeleteRealtimeLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamingDistribution = "DeleteStreamingDistribution2020_05_31"

// DeleteStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamingDistribution for more information on using the DeleteStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamingDistributionRequest method.
//    req, resp := client.DeleteStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution
func (c *CloudFront) DeleteStreamingDistributionRequest(input *DeleteStreamingDistributionInput) (req *request.Request, output *DeleteStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamingDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &DeleteStreamingDistributionInput{}
	}

	output = &DeleteStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStreamingDistribution API operation for Amazon CloudFront.
//
// Delete a streaming distribution. To delete an RTMP distribution using the
// CloudFront API, perform the following steps.
//
// To delete an RTMP distribution using the CloudFront API:
//
// Disable the RTMP distribution.
//
// Submit a GET Streaming Distribution Config request to get the current configuration
// and the Etag header for the distribution.
//
// Update the XML document that was returned in the response to your GET Streaming
// Distribution Config request to change the value of Enabled to false.
//
// Submit a PUT Streaming Distribution Config request to update the configuration
// for your distribution. In the request body, include the XML document that
// you updated in Step 3. Then set the value of the HTTP If-Match header to
// the value of the ETag header that CloudFront returned when you submitted
// the GET Streaming Distribution Config request in Step 2.
//
// Review the response to the PUT Streaming Distribution Config request to confirm
// that the distribution was successfully disabled.
//
// Submit a GET Streaming Distribution Config request to confirm that your changes
// have propagated. When propagation is complete, the value of Status is Deployed.
//
// Submit a DELETE Streaming Distribution request. Set the value of the HTTP
// If-Match header to the value of the ETag header that CloudFront returned
// when you submitted the GET Streaming Distribution Config request in Step
// 2.
//
// Review the response to your DELETE Streaming Distribution request to confirm
// that the distribution was successfully deleted.
//
// For information about deleting a distribution using the CloudFront console,
// see Deleting a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeStreamingDistributionNotDisabled "StreamingDistributionNotDisabled"
//   The specified CloudFront distribution is not disabled. You must disable the
//   distribution before you can delete it.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution
func (c *CloudFront) DeleteStreamingDistribution(input *DeleteStreamingDistributionInput) (*DeleteStreamingDistributionOutput, error) {
	req, out := c.DeleteStreamingDistributionRequest(input)
	return out, req.Send()
}

// DeleteStreamingDistributionWithContext is the same as DeleteStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteStreamingDistributionWithContext(ctx aws.Context, input *DeleteStreamingDistributionInput, opts ...request.Option) (*DeleteStreamingDistributionOutput, error) {
	req, out := c.DeleteStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCachePolicy = "GetCachePolicy2020_05_31"

// GetCachePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetCachePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCachePolicy for more information on using the GetCachePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCachePolicyRequest method.
//    req, resp := client.GetCachePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy
func (c *CloudFront) GetCachePolicyRequest(input *GetCachePolicyInput) (req *request.Request, output *GetCachePolicyOutput) {
	op := &request.Operation{
		Name:       opGetCachePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}",
	}

	if input == nil {
		input = &GetCachePolicyInput{}
	}

	output = &GetCachePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCachePolicy API operation for Amazon CloudFront.
//
// Gets a cache policy, including the following metadata:
//
//    * The policy’s identifier.
//
//    * The date and time when the policy was last modified.
//
// To get a cache policy, you must provide the policy’s identifier. If the
// cache policy is attached to a distribution’s cache behavior, you can get
// the policy’s identifier using ListDistributions or GetDistribution. If
// the cache policy is not attached to a cache behavior, you can get the identifier
// using ListCachePolicies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetCachePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy
func (c *CloudFront) GetCachePolicy(input *GetCachePolicyInput) (*GetCachePolicyOutput, error) {
	req, out := c.GetCachePolicyRequest(input)
	return out, req.Send()
}

// GetCachePolicyWithContext is the same as GetCachePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetCachePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetCachePolicyWithContext(ctx aws.Context, input *GetCachePolicyInput, opts ...request.Option) (*GetCachePolicyOutput, error) {
	req, out := c.GetCachePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCachePolicyConfig = "GetCachePolicyConfig2020_05_31"

// GetCachePolicyConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetCachePolicyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCachePolicyConfig for more information on using the GetCachePolicyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCachePolicyConfigRequest method.
//    req, resp := client.GetCachePolicyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig
func (c *CloudFront) GetCachePolicyConfigRequest(input *GetCachePolicyConfigInput) (req *request.Request, output *GetCachePolicyConfigOutput) {
	op := &request.Operation{
		Name:       opGetCachePolicyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}/config",
	}

	if input == nil {
		input = &GetCachePolicyConfigInput{}
	}

	output = &GetCachePolicyConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCachePolicyConfig API operation for Amazon CloudFront.
//
// Gets a cache policy configuration.
//
// To get a cache policy configuration, you must provide the policy’s identifier.
// If the cache policy is attached to a distribution’s cache behavior, you
// can get the policy’s identifier using ListDistributions or GetDistribution.
// If the cache policy is not attached to a cache behavior, you can get the
// identifier using ListCachePolicies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetCachePolicyConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig
func (c *CloudFront) GetCachePolicyConfig(input *GetCachePolicyConfigInput) (*GetCachePolicyConfigOutput, error) {
	req, out := c.GetCachePolicyConfigRequest(input)
	return out, req.Send()
}

// GetCachePolicyConfigWithContext is the same as GetCachePolicyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetCachePolicyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetCachePolicyConfigWithContext(ctx aws.Context, input *GetCachePolicyConfigInput, opts ...request.Option) (*GetCachePolicyConfigOutput, error) {
	req, out := c.GetCachePolicyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudFrontOriginAccessIdentity = "GetCloudFrontOriginAccessIdentity2020_05_31"

// GetCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudFrontOriginAccessIdentity for more information on using the GetCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.GetCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity
func (c *CloudFront) GetCloudFrontOriginAccessIdentityRequest(input *GetCloudFrontOriginAccessIdentityInput) (req *request.Request, output *GetCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opGetCloudFrontOriginAccessIdentity,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityInput{}
	}

	output = &GetCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Get the information about an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity
func (c *CloudFront) GetCloudFrontOriginAccessIdentity(input *GetCloudFrontOriginAccessIdentityInput) (*GetCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// GetCloudFrontOriginAccessIdentityWithContext is the same as GetCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *GetCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*GetCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudFrontOriginAccessIdentityConfig = "GetCloudFrontOriginAccessIdentityConfig2020_05_31"

// GetCloudFrontOriginAccessIdentityConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudFrontOriginAccessIdentityConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudFrontOriginAccessIdentityConfig for more information on using the GetCloudFrontOriginAccessIdentityConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCloudFrontOriginAccessIdentityConfigRequest method.
//    req, resp := client.GetCloudFrontOriginAccessIdentityConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfigRequest(input *GetCloudFrontOriginAccessIdentityConfigInput) (req *request.Request, output *GetCloudFrontOriginAccessIdentityConfigOutput) {
	op := &request.Operation{
		Name:       opGetCloudFrontOriginAccessIdentityConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityConfigInput{}
	}

	output = &GetCloudFrontOriginAccessIdentityConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudFrontOriginAccessIdentityConfig API operation for Amazon CloudFront.
//
// Get the configuration information about an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetCloudFrontOriginAccessIdentityConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfig(input *GetCloudFrontOriginAccessIdentityConfigInput) (*GetCloudFrontOriginAccessIdentityConfigOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityConfigRequest(input)
	return out, req.Send()
}

// GetCloudFrontOriginAccessIdentityConfigWithContext is the same as GetCloudFrontOriginAccessIdentityConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudFrontOriginAccessIdentityConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfigWithContext(ctx aws.Context, input *GetCloudFrontOriginAccessIdentityConfigInput, opts ...request.Option) (*GetCloudFrontOriginAccessIdentityConfigOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistribution = "GetDistribution2020_05_31"

// GetDistributionRequest generates a "aws/request.Request" representing the
// client's request for the GetDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistribution for more information on using the GetDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionRequest method.
//    req, resp := client.GetDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution
func (c *CloudFront) GetDistributionRequest(input *GetDistributionInput) (req *request.Request, output *GetDistributionOutput) {
	op := &request.Operation{
		Name:       opGetDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distribution/{Id}",
	}

	if input == nil {
		input = &GetDistributionInput{}
	}

	output = &GetDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistribution API operation for Amazon CloudFront.
//
// Get the information about a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution
func (c *CloudFront) GetDistribution(input *GetDistributionInput) (*GetDistributionOutput, error) {
	req, out := c.GetDistributionRequest(input)
	return out, req.Send()
}

// GetDistributionWithContext is the same as GetDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetDistributionWithContext(ctx aws.Context, input *GetDistributionInput, opts ...request.Option) (*GetDistributionOutput, error) {
	req, out := c.GetDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributionConfig = "GetDistributionConfig2020_05_31"

// GetDistributionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributionConfig for more information on using the GetDistributionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionConfigRequest method.
//    req, resp := client.GetDistributionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig
func (c *CloudFront) GetDistributionConfigRequest(input *GetDistributionConfigInput) (req *request.Request, output *GetDistributionConfigOutput) {
	op := &request.Operation{
		Name:       opGetDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distribution/{Id}/config",
	}

	if input == nil {
		input = &GetDistributionConfigInput{}
	}

	output = &GetDistributionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributionConfig API operation for Amazon CloudFront.
//
// Get the configuration information about a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetDistributionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig
func (c *CloudFront) GetDistributionConfig(input *GetDistributionConfigInput) (*GetDistributionConfigOutput, error) {
	req, out := c.GetDistributionConfigRequest(input)
	return out, req.Send()
}

// GetDistributionConfigWithContext is the same as GetDistributionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetDistributionConfigWithContext(ctx aws.Context, input *GetDistributionConfigInput, opts ...request.Option) (*GetDistributionConfigOutput, error) {
	req, out := c.GetDistributionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryption = "GetFieldLevelEncryption2020_05_31"

// GetFieldLevelEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryption for more information on using the GetFieldLevelEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionRequest method.
//    req, resp := client.GetFieldLevelEncryptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption
func (c *CloudFront) GetFieldLevelEncryptionRequest(input *GetFieldLevelEncryptionInput) (req *request.Request, output *GetFieldLevelEncryptionOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryption,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/field-level-encryption/{Id}",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionInput{}
	}

	output = &GetFieldLevelEncryptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryption API operation for Amazon CloudFront.
//
// Get the field-level encryption configuration information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryption for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption
func (c *CloudFront) GetFieldLevelEncryption(input *GetFieldLevelEncryptionInput) (*GetFieldLevelEncryptionOutput, error) {
	req, out := c.GetFieldLevelEncryptionRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionWithContext is the same as GetFieldLevelEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionWithContext(ctx aws.Context, input *GetFieldLevelEncryptionInput, opts ...request.Option) (*GetFieldLevelEncryptionOutput, error) {
	req, out := c.GetFieldLevelEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryptionConfig = "GetFieldLevelEncryptionConfig2020_05_31"

// GetFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryptionConfig for more information on using the GetFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionConfigRequest method.
//    req, resp := client.GetFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig
func (c *CloudFront) GetFieldLevelEncryptionConfigRequest(input *GetFieldLevelEncryptionConfigInput) (req *request.Request, output *GetFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryptionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/field-level-encryption/{Id}/config",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionConfigInput{}
	}

	output = &GetFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Get the field-level encryption configuration information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig
func (c *CloudFront) GetFieldLevelEncryptionConfig(input *GetFieldLevelEncryptionConfigInput) (*GetFieldLevelEncryptionConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionConfigWithContext is the same as GetFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *GetFieldLevelEncryptionConfigInput, opts ...request.Option) (*GetFieldLevelEncryptionConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryptionProfile = "GetFieldLevelEncryptionProfile2020_05_31"

// GetFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryptionProfile for more information on using the GetFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionProfileRequest method.
//    req, resp := client.GetFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile
func (c *CloudFront) GetFieldLevelEncryptionProfileRequest(input *GetFieldLevelEncryptionProfileInput) (req *request.Request, output *GetFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryptionProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/field-level-encryption-profile/{Id}",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionProfileInput{}
	}

	output = &GetFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Get the field-level encryption profile information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile
func (c *CloudFront) GetFieldLevelEncryptionProfile(input *GetFieldLevelEncryptionProfileInput) (*GetFieldLevelEncryptionProfileOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionProfileWithContext is the same as GetFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *GetFieldLevelEncryptionProfileInput, opts ...request.Option) (*GetFieldLevelEncryptionProfileOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryptionProfileConfig = "GetFieldLevelEncryptionProfileConfig2020_05_31"

// GetFieldLevelEncryptionProfileConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryptionProfileConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryptionProfileConfig for more information on using the GetFieldLevelEncryptionProfileConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionProfileConfigRequest method.
//    req, resp := client.GetFieldLevelEncryptionProfileConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig
func (c *CloudFront) GetFieldLevelEncryptionProfileConfigRequest(input *GetFieldLevelEncryptionProfileConfigInput) (req *request.Request, output *GetFieldLevelEncryptionProfileConfigOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryptionProfileConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/field-level-encryption-profile/{Id}/config",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionProfileConfigInput{}
	}

	output = &GetFieldLevelEncryptionProfileConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryptionProfileConfig API operation for Amazon CloudFront.
//
// Get the field-level encryption profile configuration information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryptionProfileConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig
func (c *CloudFront) GetFieldLevelEncryptionProfileConfig(input *GetFieldLevelEncryptionProfileConfigInput) (*GetFieldLevelEncryptionProfileConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileConfigRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionProfileConfigWithContext is the same as GetFieldLevelEncryptionProfileConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryptionProfileConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionProfileConfigWithContext(ctx aws.Context, input *GetFieldLevelEncryptionProfileConfigInput, opts ...request.Option) (*GetFieldLevelEncryptionProfileConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvalidation = "GetInvalidation2020_05_31"

// GetInvalidationRequest generates a "aws/request.Request" representing the
// client's request for the GetInvalidation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvalidation for more information on using the GetInvalidation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvalidationRequest method.
//    req, resp := client.GetInvalidationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation
func (c *CloudFront) GetInvalidationRequest(input *GetInvalidationInput) (req *request.Request, output *GetInvalidationOutput) {
	op := &request.Operation{
		Name:       opGetInvalidation,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distribution/{DistributionId}/invalidation/{Id}",
	}

	if input == nil {
		input = &GetInvalidationInput{}
	}

	output = &GetInvalidationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvalidation API operation for Amazon CloudFront.
//
// Get the information about an invalidation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetInvalidation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchInvalidation "NoSuchInvalidation"
//   The specified invalidation does not exist.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation
func (c *CloudFront) GetInvalidation(input *GetInvalidationInput) (*GetInvalidationOutput, error) {
	req, out := c.GetInvalidationRequest(input)
	return out, req.Send()
}

// GetInvalidationWithContext is the same as GetInvalidation with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvalidation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetInvalidationWithContext(ctx aws.Context, input *GetInvalidationInput, opts ...request.Option) (*GetInvalidationOutput, error) {
	req, out := c.GetInvalidationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyGroup = "GetKeyGroup2020_05_31"

// GetKeyGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyGroup for more information on using the GetKeyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyGroupRequest method.
//    req, resp := client.GetKeyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup
func (c *CloudFront) GetKeyGroupRequest(input *GetKeyGroupInput) (req *request.Request, output *GetKeyGroupOutput) {
	op := &request.Operation{
		Name:       opGetKeyGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/key-group/{Id}",
	}

	if input == nil {
		input = &GetKeyGroupInput{}
	}

	output = &GetKeyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyGroup API operation for Amazon CloudFront.
//
// Gets a key group, including the date and time when the key group was last
// modified.
//
// To get a key group, you must provide the key group’s identifier. If the
// key group is referenced in a distribution’s cache behavior, you can get
// the key group’s identifier using ListDistributions or GetDistribution.
// If the key group is not referenced in a cache behavior, you can get the identifier
// using ListKeyGroups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetKeyGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup
func (c *CloudFront) GetKeyGroup(input *GetKeyGroupInput) (*GetKeyGroupOutput, error) {
	req, out := c.GetKeyGroupRequest(input)
	return out, req.Send()
}

// GetKeyGroupWithContext is the same as GetKeyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetKeyGroupWithContext(ctx aws.Context, input *GetKeyGroupInput, opts ...request.Option) (*GetKeyGroupOutput, error) {
	req, out := c.GetKeyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyGroupConfig = "GetKeyGroupConfig2020_05_31"

// GetKeyGroupConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyGroupConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyGroupConfig for more information on using the GetKeyGroupConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyGroupConfigRequest method.
//    req, resp := client.GetKeyGroupConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig
func (c *CloudFront) GetKeyGroupConfigRequest(input *GetKeyGroupConfigInput) (req *request.Request, output *GetKeyGroupConfigOutput) {
	op := &request.Operation{
		Name:       opGetKeyGroupConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/key-group/{Id}/config",
	}

	if input == nil {
		input = &GetKeyGroupConfigInput{}
	}

	output = &GetKeyGroupConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyGroupConfig API operation for Amazon CloudFront.
//
// Gets a key group configuration.
//
// To get a key group configuration, you must provide the key group’s identifier.
// If the key group is referenced in a distribution’s cache behavior, you
// can get the key group’s identifier using ListDistributions or GetDistribution.
// If the key group is not referenced in a cache behavior, you can get the identifier
// using ListKeyGroups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetKeyGroupConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig
func (c *CloudFront) GetKeyGroupConfig(input *GetKeyGroupConfigInput) (*GetKeyGroupConfigOutput, error) {
	req, out := c.GetKeyGroupConfigRequest(input)
	return out, req.Send()
}

// GetKeyGroupConfigWithContext is the same as GetKeyGroupConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyGroupConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetKeyGroupConfigWithContext(ctx aws.Context, input *GetKeyGroupConfigInput, opts ...request.Option) (*GetKeyGroupConfigOutput, error) {
	req, out := c.GetKeyGroupConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMonitoringSubscription = "GetMonitoringSubscription2020_05_31"

// GetMonitoringSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the GetMonitoringSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMonitoringSubscription for more information on using the GetMonitoringSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMonitoringSubscriptionRequest method.
//    req, resp := client.GetMonitoringSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription
func (c *CloudFront) GetMonitoringSubscriptionRequest(input *GetMonitoringSubscriptionInput) (req *request.Request, output *GetMonitoringSubscriptionOutput) {
	op := &request.Operation{
		Name:       opGetMonitoringSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
	}

	if input == nil {
		input = &GetMonitoringSubscriptionInput{}
	}

	output = &GetMonitoringSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMonitoringSubscription API operation for Amazon CloudFront.
//
// Gets information about whether additional CloudWatch metrics are enabled
// for the specified CloudFront distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetMonitoringSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription
func (c *CloudFront) GetMonitoringSubscription(input *GetMonitoringSubscriptionInput) (*GetMonitoringSubscriptionOutput, error) {
	req, out := c.GetMonitoringSubscriptionRequest(input)
	return out, req.Send()
}

// GetMonitoringSubscriptionWithContext is the same as GetMonitoringSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See GetMonitoringSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetMonitoringSubscriptionWithContext(ctx aws.Context, input *GetMonitoringSubscriptionInput, opts ...request.Option) (*GetMonitoringSubscriptionOutput, error) {
	req, out := c.GetMonitoringSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOriginRequestPolicy = "GetOriginRequestPolicy2020_05_31"

// GetOriginRequestPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetOriginRequestPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOriginRequestPolicy for more information on using the GetOriginRequestPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOriginRequestPolicyRequest method.
//    req, resp := client.GetOriginRequestPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy
func (c *CloudFront) GetOriginRequestPolicyRequest(input *GetOriginRequestPolicyInput) (req *request.Request, output *GetOriginRequestPolicyOutput) {
	op := &request.Operation{
		Name:       opGetOriginRequestPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}",
	}

	if input == nil {
		input = &GetOriginRequestPolicyInput{}
	}

	output = &GetOriginRequestPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOriginRequestPolicy API operation for Amazon CloudFront.
//
// Gets an origin request policy, including the following metadata:
//
//    * The policy’s identifier.
//
//    * The date and time when the policy was last modified.
//
// To get an origin request policy, you must provide the policy’s identifier.
// If the origin request policy is attached to a distribution’s cache behavior,
// you can get the policy’s identifier using ListDistributions or GetDistribution.
// If the origin request policy is not attached to a cache behavior, you can
// get the identifier using ListOriginRequestPolicies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetOriginRequestPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy
func (c *CloudFront) GetOriginRequestPolicy(input *GetOriginRequestPolicyInput) (*GetOriginRequestPolicyOutput, error) {
	req, out := c.GetOriginRequestPolicyRequest(input)
	return out, req.Send()
}

// GetOriginRequestPolicyWithContext is the same as GetOriginRequestPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetOriginRequestPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetOriginRequestPolicyWithContext(ctx aws.Context, input *GetOriginRequestPolicyInput, opts ...request.Option) (*GetOriginRequestPolicyOutput, error) {
	req, out := c.GetOriginRequestPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOriginRequestPolicyConfig = "GetOriginRequestPolicyConfig2020_05_31"

// GetOriginRequestPolicyConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetOriginRequestPolicyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOriginRequestPolicyConfig for more information on using the GetOriginRequestPolicyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOriginRequestPolicyConfigRequest method.
//    req, resp := client.GetOriginRequestPolicyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig
func (c *CloudFront) GetOriginRequestPolicyConfigRequest(input *GetOriginRequestPolicyConfigInput) (req *request.Request, output *GetOriginRequestPolicyConfigOutput) {
	op := &request.Operation{
		Name:       opGetOriginRequestPolicyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}/config",
	}

	if input == nil {
		input = &GetOriginRequestPolicyConfigInput{}
	}

	output = &GetOriginRequestPolicyConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOriginRequestPolicyConfig API operation for Amazon CloudFront.
//
// Gets an origin request policy configuration.
//
// To get an origin request policy configuration, you must provide the policy’s
// identifier. If the origin request policy is attached to a distribution’s
// cache behavior, you can get the policy’s identifier using ListDistributions
// or GetDistribution. If the origin request policy is not attached to a cache
// behavior, you can get the identifier using ListOriginRequestPolicies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetOriginRequestPolicyConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig
func (c *CloudFront) GetOriginRequestPolicyConfig(input *GetOriginRequestPolicyConfigInput) (*GetOriginRequestPolicyConfigOutput, error) {
	req, out := c.GetOriginRequestPolicyConfigRequest(input)
	return out, req.Send()
}

// GetOriginRequestPolicyConfigWithContext is the same as GetOriginRequestPolicyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetOriginRequestPolicyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetOriginRequestPolicyConfigWithContext(ctx aws.Context, input *GetOriginRequestPolicyConfigInput, opts ...request.Option) (*GetOriginRequestPolicyConfigOutput, error) {
	req, out := c.GetOriginRequestPolicyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKey = "GetPublicKey2020_05_31"

// GetPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKey for more information on using the GetPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicKeyRequest method.
//    req, resp := client.GetPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey
func (c *CloudFront) GetPublicKeyRequest(input *GetPublicKeyInput) (req *request.Request, output *GetPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetPublicKey,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/public-key/{Id}",
	}

	if input == nil {
		input = &GetPublicKeyInput{}
	}

	output = &GetPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKey API operation for Amazon CloudFront.
//
// Gets a public key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey
func (c *CloudFront) GetPublicKey(input *GetPublicKeyInput) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	return out, req.Send()
}

// GetPublicKeyWithContext is the same as GetPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetPublicKeyWithContext(ctx aws.Context, input *GetPublicKeyInput, opts ...request.Option) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKeyConfig = "GetPublicKeyConfig2020_05_31"

// GetPublicKeyConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKeyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKeyConfig for more information on using the GetPublicKeyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicKeyConfigRequest method.
//    req, resp := client.GetPublicKeyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig
func (c *CloudFront) GetPublicKeyConfigRequest(input *GetPublicKeyConfigInput) (req *request.Request, output *GetPublicKeyConfigOutput) {
	op := &request.Operation{
		Name:       opGetPublicKeyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/public-key/{Id}/config",
	}

	if input == nil {
		input = &GetPublicKeyConfigInput{}
	}

	output = &GetPublicKeyConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKeyConfig API operation for Amazon CloudFront.
//
// Gets a public key configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetPublicKeyConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig
func (c *CloudFront) GetPublicKeyConfig(input *GetPublicKeyConfigInput) (*GetPublicKeyConfigOutput, error) {
	req, out := c.GetPublicKeyConfigRequest(input)
	return out, req.Send()
}

// GetPublicKeyConfigWithContext is the same as GetPublicKeyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKeyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetPublicKeyConfigWithContext(ctx aws.Context, input *GetPublicKeyConfigInput, opts ...request.Option) (*GetPublicKeyConfigOutput, error) {
	req, out := c.GetPublicKeyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRealtimeLogConfig = "GetRealtimeLogConfig2020_05_31"

// GetRealtimeLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetRealtimeLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRealtimeLogConfig for more information on using the GetRealtimeLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRealtimeLogConfigRequest method.
//    req, resp := client.GetRealtimeLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig
func (c *CloudFront) GetRealtimeLogConfigRequest(input *GetRealtimeLogConfigInput) (req *request.Request, output *GetRealtimeLogConfigOutput) {
	op := &request.Operation{
		Name:       opGetRealtimeLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/get-realtime-log-config/",
	}

	if input == nil {
		input = &GetRealtimeLogConfigInput{}
	}

	output = &GetRealtimeLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRealtimeLogConfig API operation for Amazon CloudFront.
//
// Gets a real-time log configuration.
//
// To get a real-time log configuration, you can provide the configuration’s
// name or its Amazon Resource Name (ARN). You must provide at least one. If
// you provide both, CloudFront uses the name to identify the real-time log
// configuration to get.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetRealtimeLogConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchRealtimeLogConfig "NoSuchRealtimeLogConfig"
//   The real-time log configuration does not exist.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig
func (c *CloudFront) GetRealtimeLogConfig(input *GetRealtimeLogConfigInput) (*GetRealtimeLogConfigOutput, error) {
	req, out := c.GetRealtimeLogConfigRequest(input)
	return out, req.Send()
}

// GetRealtimeLogConfigWithContext is the same as GetRealtimeLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetRealtimeLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetRealtimeLogConfigWithContext(ctx aws.Context, input *GetRealtimeLogConfigInput, opts ...request.Option) (*GetRealtimeLogConfigOutput, error) {
	req, out := c.GetRealtimeLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingDistribution = "GetStreamingDistribution2020_05_31"

// GetStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingDistribution for more information on using the GetStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStreamingDistributionRequest method.
//    req, resp := client.GetStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution
func (c *CloudFront) GetStreamingDistributionRequest(input *GetStreamingDistributionInput) (req *request.Request, output *GetStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opGetStreamingDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &GetStreamingDistributionInput{}
	}

	output = &GetStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingDistribution API operation for Amazon CloudFront.
//
// Gets information about a specified RTMP distribution, including the distribution
// configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution
func (c *CloudFront) GetStreamingDistribution(input *GetStreamingDistributionInput) (*GetStreamingDistributionOutput, error) {
	req, out := c.GetStreamingDistributionRequest(input)
	return out, req.Send()
}

// GetStreamingDistributionWithContext is the same as GetStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetStreamingDistributionWithContext(ctx aws.Context, input *GetStreamingDistributionInput, opts ...request.Option) (*GetStreamingDistributionOutput, error) {
	req, out := c.GetStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingDistributionConfig = "GetStreamingDistributionConfig2020_05_31"

// GetStreamingDistributionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingDistributionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingDistributionConfig for more information on using the GetStreamingDistributionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStreamingDistributionConfigRequest method.
//    req, resp := client.GetStreamingDistributionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig
func (c *CloudFront) GetStreamingDistributionConfigRequest(input *GetStreamingDistributionConfigInput) (req *request.Request, output *GetStreamingDistributionConfigOutput) {
	op := &request.Operation{
		Name:       opGetStreamingDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &GetStreamingDistributionConfigInput{}
	}

	output = &GetStreamingDistributionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingDistributionConfig API operation for Amazon CloudFront.
//
// Get the configuration information about a streaming distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetStreamingDistributionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig
func (c *CloudFront) GetStreamingDistributionConfig(input *GetStreamingDistributionConfigInput) (*GetStreamingDistributionConfigOutput, error) {
	req, out := c.GetStreamingDistributionConfigRequest(input)
	return out, req.Send()
}

// GetStreamingDistributionConfigWithContext is the same as GetStreamingDistributionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingDistributionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetStreamingDistributionConfigWithContext(ctx aws.Context, input *GetStreamingDistributionConfigInput, opts ...request.Option) (*GetStreamingDistributionConfigOutput, error) {
	req, out := c.GetStreamingDistributionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCachePolicies = "ListCachePolicies2020_05_31"

// ListCachePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListCachePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCachePolicies for more information on using the ListCachePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCachePoliciesRequest method.
//    req, resp := client.ListCachePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies
func (c *CloudFront) ListCachePoliciesRequest(input *ListCachePoliciesInput) (req *request.Request, output *ListCachePoliciesOutput) {
	op := &request.Operation{
		Name:       opListCachePolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/cache-policy",
	}

	if input == nil {
		input = &ListCachePoliciesInput{}
	}

	output = &ListCachePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCachePolicies API operation for Amazon CloudFront.
//
// Gets a list of cache policies.
//
// You can optionally apply a filter to return only the managed policies created
// by AWS, or only the custom policies created in your AWS account.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListCachePolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies
func (c *CloudFront) ListCachePolicies(input *ListCachePoliciesInput) (*ListCachePoliciesOutput, error) {
	req, out := c.ListCachePoliciesRequest(input)
	return out, req.Send()
}

// ListCachePoliciesWithContext is the same as ListCachePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListCachePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListCachePoliciesWithContext(ctx aws.Context, input *ListCachePoliciesInput, opts ...request.Option) (*ListCachePoliciesOutput, error) {
	req, out := c.ListCachePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCloudFrontOriginAccessIdentities = "ListCloudFrontOriginAccessIdentities2020_05_31"

// ListCloudFrontOriginAccessIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListCloudFrontOriginAccessIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCloudFrontOriginAccessIdentities for more information on using the ListCloudFrontOriginAccessIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCloudFrontOriginAccessIdentitiesRequest method.
//    req, resp := client.ListCloudFrontOriginAccessIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesRequest(input *ListCloudFrontOriginAccessIdentitiesInput) (req *request.Request, output *ListCloudFrontOriginAccessIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListCloudFrontOriginAccessIdentities,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"CloudFrontOriginAccessIdentityList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "CloudFrontOriginAccessIdentityList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListCloudFrontOriginAccessIdentitiesInput{}
	}

	output = &ListCloudFrontOriginAccessIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCloudFrontOriginAccessIdentities API operation for Amazon CloudFront.
//
// Lists origin access identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListCloudFrontOriginAccessIdentities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities
func (c *CloudFront) ListCloudFrontOriginAccessIdentities(input *ListCloudFrontOriginAccessIdentitiesInput) (*ListCloudFrontOriginAccessIdentitiesOutput, error) {
	req, out := c.ListCloudFrontOriginAccessIdentitiesRequest(input)
	return out, req.Send()
}

// ListCloudFrontOriginAccessIdentitiesWithContext is the same as ListCloudFrontOriginAccessIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListCloudFrontOriginAccessIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesWithContext(ctx aws.Context, input *ListCloudFrontOriginAccessIdentitiesInput, opts ...request.Option) (*ListCloudFrontOriginAccessIdentitiesOutput, error) {
	req, out := c.ListCloudFrontOriginAccessIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCloudFrontOriginAccessIdentitiesPages iterates over the pages of a ListCloudFrontOriginAccessIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCloudFrontOriginAccessIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCloudFrontOriginAccessIdentities operation.
//    pageNum := 0
//    err := client.ListCloudFrontOriginAccessIdentitiesPages(params,
//        func(page *cloudfront.ListCloudFrontOriginAccessIdentitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesPages(input *ListCloudFrontOriginAccessIdentitiesInput, fn func(*ListCloudFrontOriginAccessIdentitiesOutput, bool) bool) error {
	return c.ListCloudFrontOriginAccessIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCloudFrontOriginAccessIdentitiesPagesWithContext same as ListCloudFrontOriginAccessIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesPagesWithContext(ctx aws.Context, input *ListCloudFrontOriginAccessIdentitiesInput, fn func(*ListCloudFrontOriginAccessIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCloudFrontOriginAccessIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCloudFrontOriginAccessIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCloudFrontOriginAccessIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDistributions = "ListDistributions2020_05_31"

// ListDistributionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributions for more information on using the ListDistributions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsRequest method.
//    req, resp := client.ListDistributionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions
func (c *CloudFront) ListDistributionsRequest(input *ListDistributionsInput) (req *request.Request, output *ListDistributionsOutput) {
	op := &request.Operation{
		Name:       opListDistributions,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distribution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"DistributionList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "DistributionList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListDistributionsInput{}
	}

	output = &ListDistributionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributions API operation for Amazon CloudFront.
//
// List CloudFront distributions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions
func (c *CloudFront) ListDistributions(input *ListDistributionsInput) (*ListDistributionsOutput, error) {
	req, out := c.ListDistributionsRequest(input)
	return out, req.Send()
}

// ListDistributionsWithContext is the same as ListDistributions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsWithContext(ctx aws.Context, input *ListDistributionsInput, opts ...request.Option) (*ListDistributionsOutput, error) {
	req, out := c.ListDistributionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDistributionsPages iterates over the pages of a ListDistributions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDistributions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDistributions operation.
//    pageNum := 0
//    err := client.ListDistributionsPages(params,
//        func(page *cloudfront.ListDistributionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListDistributionsPages(input *ListDistributionsInput, fn func(*ListDistributionsOutput, bool) bool) error {
	return c.ListDistributionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDistributionsPagesWithContext same as ListDistributionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsPagesWithContext(ctx aws.Context, input *ListDistributionsInput, fn func(*ListDistributionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDistributionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDistributionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDistributionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDistributionsByCachePolicyId = "ListDistributionsByCachePolicyId2020_05_31"

// ListDistributionsByCachePolicyIdRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionsByCachePolicyId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionsByCachePolicyId for more information on using the ListDistributionsByCachePolicyId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsByCachePolicyIdRequest method.
//    req, resp := client.ListDistributionsByCachePolicyIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId
func (c *CloudFront) ListDistributionsByCachePolicyIdRequest(input *ListDistributionsByCachePolicyIdInput) (req *request.Request, output *ListDistributionsByCachePolicyIdOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByCachePolicyId,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}",
	}

	if input == nil {
		input = &ListDistributionsByCachePolicyIdInput{}
	}

	output = &ListDistributionsByCachePolicyIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionsByCachePolicyId API operation for Amazon CloudFront.
//
// Gets a list of distribution IDs for distributions that have a cache behavior
// that’s associated with the specified cache policy.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributionsByCachePolicyId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId
func (c *CloudFront) ListDistributionsByCachePolicyId(input *ListDistributionsByCachePolicyIdInput) (*ListDistributionsByCachePolicyIdOutput, error) {
	req, out := c.ListDistributionsByCachePolicyIdRequest(input)
	return out, req.Send()
}

// ListDistributionsByCachePolicyIdWithContext is the same as ListDistributionsByCachePolicyId with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionsByCachePolicyId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsByCachePolicyIdWithContext(ctx aws.Context, input *ListDistributionsByCachePolicyIdInput, opts ...request.Option) (*ListDistributionsByCachePolicyIdOutput, error) {
	req, out := c.ListDistributionsByCachePolicyIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDistributionsByKeyGroup = "ListDistributionsByKeyGroup2020_05_31"

// ListDistributionsByKeyGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionsByKeyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionsByKeyGroup for more information on using the ListDistributionsByKeyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsByKeyGroupRequest method.
//    req, resp := client.ListDistributionsByKeyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup
func (c *CloudFront) ListDistributionsByKeyGroupRequest(input *ListDistributionsByKeyGroupInput) (req *request.Request, output *ListDistributionsByKeyGroupOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByKeyGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}",
	}

	if input == nil {
		input = &ListDistributionsByKeyGroupInput{}
	}

	output = &ListDistributionsByKeyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionsByKeyGroup API operation for Amazon CloudFront.
//
// Gets a list of distribution IDs for distributions that have a cache behavior
// that references the specified key group.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributionsByKeyGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup
func (c *CloudFront) ListDistributionsByKeyGroup(input *ListDistributionsByKeyGroupInput) (*ListDistributionsByKeyGroupOutput, error) {
	req, out := c.ListDistributionsByKeyGroupRequest(input)
	return out, req.Send()
}

// ListDistributionsByKeyGroupWithContext is the same as ListDistributionsByKeyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionsByKeyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsByKeyGroupWithContext(ctx aws.Context, input *ListDistributionsByKeyGroupInput, opts ...request.Option) (*ListDistributionsByKeyGroupOutput, error) {
	req, out := c.ListDistributionsByKeyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDistributionsByOriginRequestPolicyId = "ListDistributionsByOriginRequestPolicyId2020_05_31"

// ListDistributionsByOriginRequestPolicyIdRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionsByOriginRequestPolicyId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionsByOriginRequestPolicyId for more information on using the ListDistributionsByOriginRequestPolicyId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsByOriginRequestPolicyIdRequest method.
//    req, resp := client.ListDistributionsByOriginRequestPolicyIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId
func (c *CloudFront) ListDistributionsByOriginRequestPolicyIdRequest(input *ListDistributionsByOriginRequestPolicyIdInput) (req *request.Request, output *ListDistributionsByOriginRequestPolicyIdOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByOriginRequestPolicyId,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}",
	}

	if input == nil {
		input = &ListDistributionsByOriginRequestPolicyIdInput{}
	}

	output = &ListDistributionsByOriginRequestPolicyIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionsByOriginRequestPolicyId API operation for Amazon CloudFront.
//
// Gets a list of distribution IDs for distributions that have a cache behavior
// that’s associated with the specified origin request policy.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributionsByOriginRequestPolicyId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId
func (c *CloudFront) ListDistributionsByOriginRequestPolicyId(input *ListDistributionsByOriginRequestPolicyIdInput) (*ListDistributionsByOriginRequestPolicyIdOutput, error) {
	req, out := c.ListDistributionsByOriginRequestPolicyIdRequest(input)
	return out, req.Send()
}

// ListDistributionsByOriginRequestPolicyIdWithContext is the same as ListDistributionsByOriginRequestPolicyId with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionsByOriginRequestPolicyId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsByOriginRequestPolicyIdWithContext(ctx aws.Context, input *ListDistributionsByOriginRequestPolicyIdInput, opts ...request.Option) (*ListDistributionsByOriginRequestPolicyIdOutput, error) {
	req, out := c.ListDistributionsByOriginRequestPolicyIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDistributionsByRealtimeLogConfig = "ListDistributionsByRealtimeLogConfig2020_05_31"

// ListDistributionsByRealtimeLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionsByRealtimeLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionsByRealtimeLogConfig for more information on using the ListDistributionsByRealtimeLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsByRealtimeLogConfigRequest method.
//    req, resp := client.ListDistributionsByRealtimeLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig
func (c *CloudFront) ListDistributionsByRealtimeLogConfigRequest(input *ListDistributionsByRealtimeLogConfigInput) (req *request.Request, output *ListDistributionsByRealtimeLogConfigOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByRealtimeLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/distributionsByRealtimeLogConfig/",
	}

	if input == nil {
		input = &ListDistributionsByRealtimeLogConfigInput{}
	}

	output = &ListDistributionsByRealtimeLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionsByRealtimeLogConfig API operation for Amazon CloudFront.
//
// Gets a list of distributions that have a cache behavior that’s associated
// with the specified real-time log configuration.
//
// You can specify the real-time log configuration by its name or its Amazon
// Resource Name (ARN). You must provide at least one. If you provide both,
// CloudFront uses the name to identify the real-time log configuration to list
// distributions for.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributionsByRealtimeLogConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig
func (c *CloudFront) ListDistributionsByRealtimeLogConfig(input *ListDistributionsByRealtimeLogConfigInput) (*ListDistributionsByRealtimeLogConfigOutput, error) {
	req, out := c.ListDistributionsByRealtimeLogConfigRequest(input)
	return out, req.Send()
}

// ListDistributionsByRealtimeLogConfigWithContext is the same as ListDistributionsByRealtimeLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionsByRealtimeLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsByRealtimeLogConfigWithContext(ctx aws.Context, input *ListDistributionsByRealtimeLogConfigInput, opts ...request.Option) (*ListDistributionsByRealtimeLogConfigOutput, error) {
	req, out := c.ListDistributionsByRealtimeLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDistributionsByWebACLId = "ListDistributionsByWebACLId2020_05_31"

// ListDistributionsByWebACLIdRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionsByWebACLId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionsByWebACLId for more information on using the ListDistributionsByWebACLId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsByWebACLIdRequest method.
//    req, resp := client.ListDistributionsByWebACLIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId
func (c *CloudFront) ListDistributionsByWebACLIdRequest(input *ListDistributionsByWebACLIdInput) (req *request.Request, output *ListDistributionsByWebACLIdOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByWebACLId,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distributionsByWebACLId/{WebACLId}",
	}

	if input == nil {
		input = &ListDistributionsByWebACLIdInput{}
	}

	output = &ListDistributionsByWebACLIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionsByWebACLId API operation for Amazon CloudFront.
//
// List the distributions that are associated with a specified AWS WAF web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributionsByWebACLId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId
func (c *CloudFront) ListDistributionsByWebACLId(input *ListDistributionsByWebACLIdInput) (*ListDistributionsByWebACLIdOutput, error) {
	req, out := c.ListDistributionsByWebACLIdRequest(input)
	return out, req.Send()
}

// ListDistributionsByWebACLIdWithContext is the same as ListDistributionsByWebACLId with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionsByWebACLId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsByWebACLIdWithContext(ctx aws.Context, input *ListDistributionsByWebACLIdInput, opts ...request.Option) (*ListDistributionsByWebACLIdOutput, error) {
	req, out := c.ListDistributionsByWebACLIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFieldLevelEncryptionConfigs = "ListFieldLevelEncryptionConfigs2020_05_31"

// ListFieldLevelEncryptionConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListFieldLevelEncryptionConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFieldLevelEncryptionConfigs for more information on using the ListFieldLevelEncryptionConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFieldLevelEncryptionConfigsRequest method.
//    req, resp := client.ListFieldLevelEncryptionConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs
func (c *CloudFront) ListFieldLevelEncryptionConfigsRequest(input *ListFieldLevelEncryptionConfigsInput) (req *request.Request, output *ListFieldLevelEncryptionConfigsOutput) {
	op := &request.Operation{
		Name:       opListFieldLevelEncryptionConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/field-level-encryption",
	}

	if input == nil {
		input = &ListFieldLevelEncryptionConfigsInput{}
	}

	output = &ListFieldLevelEncryptionConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFieldLevelEncryptionConfigs API operation for Amazon CloudFront.
//
// List all field-level encryption configurations that have been created in
// CloudFront for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListFieldLevelEncryptionConfigs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs
func (c *CloudFront) ListFieldLevelEncryptionConfigs(input *ListFieldLevelEncryptionConfigsInput) (*ListFieldLevelEncryptionConfigsOutput, error) {
	req, out := c.ListFieldLevelEncryptionConfigsRequest(input)
	return out, req.Send()
}

// ListFieldLevelEncryptionConfigsWithContext is the same as ListFieldLevelEncryptionConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFieldLevelEncryptionConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListFieldLevelEncryptionConfigsWithContext(ctx aws.Context, input *ListFieldLevelEncryptionConfigsInput, opts ...request.Option) (*ListFieldLevelEncryptionConfigsOutput, error) {
	req, out := c.ListFieldLevelEncryptionConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFieldLevelEncryptionProfiles = "ListFieldLevelEncryptionProfiles2020_05_31"

// ListFieldLevelEncryptionProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListFieldLevelEncryptionProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFieldLevelEncryptionProfiles for more information on using the ListFieldLevelEncryptionProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFieldLevelEncryptionProfilesRequest method.
//    req, resp := client.ListFieldLevelEncryptionProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles
func (c *CloudFront) ListFieldLevelEncryptionProfilesRequest(input *ListFieldLevelEncryptionProfilesInput) (req *request.Request, output *ListFieldLevelEncryptionProfilesOutput) {
	op := &request.Operation{
		Name:       opListFieldLevelEncryptionProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/field-level-encryption-profile",
	}

	if input == nil {
		input = &ListFieldLevelEncryptionProfilesInput{}
	}

	output = &ListFieldLevelEncryptionProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFieldLevelEncryptionProfiles API operation for Amazon CloudFront.
//
// Request a list of field-level encryption profiles that have been created
// in CloudFront for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListFieldLevelEncryptionProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles
func (c *CloudFront) ListFieldLevelEncryptionProfiles(input *ListFieldLevelEncryptionProfilesInput) (*ListFieldLevelEncryptionProfilesOutput, error) {
	req, out := c.ListFieldLevelEncryptionProfilesRequest(input)
	return out, req.Send()
}

// ListFieldLevelEncryptionProfilesWithContext is the same as ListFieldLevelEncryptionProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListFieldLevelEncryptionProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListFieldLevelEncryptionProfilesWithContext(ctx aws.Context, input *ListFieldLevelEncryptionProfilesInput, opts ...request.Option) (*ListFieldLevelEncryptionProfilesOutput, error) {
	req, out := c.ListFieldLevelEncryptionProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInvalidations = "ListInvalidations2020_05_31"

// ListInvalidationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvalidations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvalidations for more information on using the ListInvalidations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvalidationsRequest method.
//    req, resp := client.ListInvalidationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations
func (c *CloudFront) ListInvalidationsRequest(input *ListInvalidationsInput) (req *request.Request, output *ListInvalidationsOutput) {
	op := &request.Operation{
		Name:       opListInvalidations,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/distribution/{DistributionId}/invalidation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"InvalidationList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "InvalidationList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListInvalidationsInput{}
	}

	output = &ListInvalidationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvalidations API operation for Amazon CloudFront.
//
// Lists invalidation batches.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListInvalidations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations
func (c *CloudFront) ListInvalidations(input *ListInvalidationsInput) (*ListInvalidationsOutput, error) {
	req, out := c.ListInvalidationsRequest(input)
	return out, req.Send()
}

// ListInvalidationsWithContext is the same as ListInvalidations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvalidations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListInvalidationsWithContext(ctx aws.Context, input *ListInvalidationsInput, opts ...request.Option) (*ListInvalidationsOutput, error) {
	req, out := c.ListInvalidationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvalidationsPages iterates over the pages of a ListInvalidations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvalidations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvalidations operation.
//    pageNum := 0
//    err := client.ListInvalidationsPages(params,
//        func(page *cloudfront.ListInvalidationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListInvalidationsPages(input *ListInvalidationsInput, fn func(*ListInvalidationsOutput, bool) bool) error {
	return c.ListInvalidationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvalidationsPagesWithContext same as ListInvalidationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListInvalidationsPagesWithContext(ctx aws.Context, input *ListInvalidationsInput, fn func(*ListInvalidationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvalidationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvalidationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvalidationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeyGroups = "ListKeyGroups2020_05_31"

// ListKeyGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeyGroups for more information on using the ListKeyGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListKeyGroupsRequest method.
//    req, resp := client.ListKeyGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups
func (c *CloudFront) ListKeyGroupsRequest(input *ListKeyGroupsInput) (req *request.Request, output *ListKeyGroupsOutput) {
	op := &request.Operation{
		Name:       opListKeyGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/key-group",
	}

	if input == nil {
		input = &ListKeyGroupsInput{}
	}

	output = &ListKeyGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeyGroups API operation for Amazon CloudFront.
//
// Gets a list of key groups.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListKeyGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups
func (c *CloudFront) ListKeyGroups(input *ListKeyGroupsInput) (*ListKeyGroupsOutput, error) {
	req, out := c.ListKeyGroupsRequest(input)
	return out, req.Send()
}

// ListKeyGroupsWithContext is the same as ListKeyGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeyGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListKeyGroupsWithContext(ctx aws.Context, input *ListKeyGroupsInput, opts ...request.Option) (*ListKeyGroupsOutput, error) {
	req, out := c.ListKeyGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOriginRequestPolicies = "ListOriginRequestPolicies2020_05_31"

// ListOriginRequestPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListOriginRequestPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOriginRequestPolicies for more information on using the ListOriginRequestPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOriginRequestPoliciesRequest method.
//    req, resp := client.ListOriginRequestPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies
func (c *CloudFront) ListOriginRequestPoliciesRequest(input *ListOriginRequestPoliciesInput) (req *request.Request, output *ListOriginRequestPoliciesOutput) {
	op := &request.Operation{
		Name:       opListOriginRequestPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-request-policy",
	}

	if input == nil {
		input = &ListOriginRequestPoliciesInput{}
	}

	output = &ListOriginRequestPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOriginRequestPolicies API operation for Amazon CloudFront.
//
// Gets a list of origin request policies.
//
// You can optionally apply a filter to return only the managed policies created
// by AWS, or only the custom policies created in your AWS account.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListOriginRequestPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies
func (c *CloudFront) ListOriginRequestPolicies(input *ListOriginRequestPoliciesInput) (*ListOriginRequestPoliciesOutput, error) {
	req, out := c.ListOriginRequestPoliciesRequest(input)
	return out, req.Send()
}

// ListOriginRequestPoliciesWithContext is the same as ListOriginRequestPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListOriginRequestPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListOriginRequestPoliciesWithContext(ctx aws.Context, input *ListOriginRequestPoliciesInput, opts ...request.Option) (*ListOriginRequestPoliciesOutput, error) {
	req, out := c.ListOriginRequestPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPublicKeys = "ListPublicKeys2020_05_31"

// ListPublicKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListPublicKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublicKeys for more information on using the ListPublicKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPublicKeysRequest method.
//    req, resp := client.ListPublicKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys
func (c *CloudFront) ListPublicKeysRequest(input *ListPublicKeysInput) (req *request.Request, output *ListPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListPublicKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/public-key",
	}

	if input == nil {
		input = &ListPublicKeysInput{}
	}

	output = &ListPublicKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublicKeys API operation for Amazon CloudFront.
//
// List all public keys that have been added to CloudFront for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListPublicKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys
func (c *CloudFront) ListPublicKeys(input *ListPublicKeysInput) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	return out, req.Send()
}

// ListPublicKeysWithContext is the same as ListPublicKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublicKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListPublicKeysWithContext(ctx aws.Context, input *ListPublicKeysInput, opts ...request.Option) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRealtimeLogConfigs = "ListRealtimeLogConfigs2020_05_31"

// ListRealtimeLogConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListRealtimeLogConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRealtimeLogConfigs for more information on using the ListRealtimeLogConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRealtimeLogConfigsRequest method.
//    req, resp := client.ListRealtimeLogConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs
func (c *CloudFront) ListRealtimeLogConfigsRequest(input *ListRealtimeLogConfigsInput) (req *request.Request, output *ListRealtimeLogConfigsOutput) {
	op := &request.Operation{
		Name:       opListRealtimeLogConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/realtime-log-config",
	}

	if input == nil {
		input = &ListRealtimeLogConfigsInput{}
	}

	output = &ListRealtimeLogConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRealtimeLogConfigs API operation for Amazon CloudFront.
//
// Gets a list of real-time log configurations.
//
// You can optionally specify the maximum number of items to receive in the
// response. If the total number of items in the list exceeds the maximum that
// you specify, or the default maximum, the response is paginated. To get the
// next page of items, send a subsequent request that specifies the NextMarker
// value from the current response as the Marker value in the subsequent request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListRealtimeLogConfigs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchRealtimeLogConfig "NoSuchRealtimeLogConfig"
//   The real-time log configuration does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs
func (c *CloudFront) ListRealtimeLogConfigs(input *ListRealtimeLogConfigsInput) (*ListRealtimeLogConfigsOutput, error) {
	req, out := c.ListRealtimeLogConfigsRequest(input)
	return out, req.Send()
}

// ListRealtimeLogConfigsWithContext is the same as ListRealtimeLogConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListRealtimeLogConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListRealtimeLogConfigsWithContext(ctx aws.Context, input *ListRealtimeLogConfigsInput, opts ...request.Option) (*ListRealtimeLogConfigsOutput, error) {
	req, out := c.ListRealtimeLogConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreamingDistributions = "ListStreamingDistributions2020_05_31"

// ListStreamingDistributionsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamingDistributions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamingDistributions for more information on using the ListStreamingDistributions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamingDistributionsRequest method.
//    req, resp := client.ListStreamingDistributionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions
func (c *CloudFront) ListStreamingDistributionsRequest(input *ListStreamingDistributionsInput) (req *request.Request, output *ListStreamingDistributionsOutput) {
	op := &request.Operation{
		Name:       opListStreamingDistributions,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/streaming-distribution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"StreamingDistributionList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "StreamingDistributionList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListStreamingDistributionsInput{}
	}

	output = &ListStreamingDistributionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamingDistributions API operation for Amazon CloudFront.
//
// List streaming distributions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListStreamingDistributions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions
func (c *CloudFront) ListStreamingDistributions(input *ListStreamingDistributionsInput) (*ListStreamingDistributionsOutput, error) {
	req, out := c.ListStreamingDistributionsRequest(input)
	return out, req.Send()
}

// ListStreamingDistributionsWithContext is the same as ListStreamingDistributions with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamingDistributions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListStreamingDistributionsWithContext(ctx aws.Context, input *ListStreamingDistributionsInput, opts ...request.Option) (*ListStreamingDistributionsOutput, error) {
	req, out := c.ListStreamingDistributionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamingDistributionsPages iterates over the pages of a ListStreamingDistributions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamingDistributions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStreamingDistributions operation.
//    pageNum := 0
//    err := client.ListStreamingDistributionsPages(params,
//        func(page *cloudfront.ListStreamingDistributionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListStreamingDistributionsPages(input *ListStreamingDistributionsInput, fn func(*ListStreamingDistributionsOutput, bool) bool) error {
	return c.ListStreamingDistributionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamingDistributionsPagesWithContext same as ListStreamingDistributionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListStreamingDistributionsPagesWithContext(ctx aws.Context, input *ListStreamingDistributionsInput, fn func(*ListStreamingDistributionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamingDistributionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamingDistributionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamingDistributionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource2020_05_31"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource
func (c *CloudFront) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/tagging",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudFront.
//
// List tags for a CloudFront resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource
func (c *CloudFront) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource2020_05_31"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource
func (c *CloudFront) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/tagging?Operation=Tag",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudFront.
//
// Add tags to a CloudFront resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource
func (c *CloudFront) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource2020_05_31"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource
func (c *CloudFront) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/tagging?Operation=Untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudFront.
//
// Remove tags from a CloudFront resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource
func (c *CloudFront) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCachePolicy = "UpdateCachePolicy2020_05_31"

// UpdateCachePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCachePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCachePolicy for more information on using the UpdateCachePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCachePolicyRequest method.
//    req, resp := client.UpdateCachePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy
func (c *CloudFront) UpdateCachePolicyRequest(input *UpdateCachePolicyInput) (req *request.Request, output *UpdateCachePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateCachePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}",
	}

	if input == nil {
		input = &UpdateCachePolicyInput{}
	}

	output = &UpdateCachePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCachePolicy API operation for Amazon CloudFront.
//
// Updates a cache policy configuration.
//
// When you update a cache policy configuration, all the fields are updated
// with the values provided in the request. You cannot update some fields independent
// of others. To update a cache policy configuration:
//
// Use GetCachePolicyConfig to get the current configuration.
//
// Locally modify the fields in the cache policy configuration that you want
// to update.
//
// Call UpdateCachePolicy by providing the entire cache policy configuration,
// including the fields that you modified and those that you didn’t.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateCachePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeCachePolicyAlreadyExists "CachePolicyAlreadyExists"
//   A cache policy with this name already exists. You must provide a unique name.
//   To modify an existing cache policy, use UpdateCachePolicy.
//
//   * ErrCodeTooManyHeadersInCachePolicy "TooManyHeadersInCachePolicy"
//   The number of headers in the cache policy exceeds the maximum. For more information,
//   see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyCookiesInCachePolicy "TooManyCookiesInCachePolicy"
//   The number of cookies in the cache policy exceeds the maximum. For more information,
//   see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyQueryStringsInCachePolicy "TooManyQueryStringsInCachePolicy"
//   The number of query strings in the cache policy exceeds the maximum. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy
func (c *CloudFront) UpdateCachePolicy(input *UpdateCachePolicyInput) (*UpdateCachePolicyOutput, error) {
	req, out := c.UpdateCachePolicyRequest(input)
	return out, req.Send()
}

// UpdateCachePolicyWithContext is the same as UpdateCachePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCachePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateCachePolicyWithContext(ctx aws.Context, input *UpdateCachePolicyInput, opts ...request.Option) (*UpdateCachePolicyOutput, error) {
	req, out := c.UpdateCachePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCloudFrontOriginAccessIdentity = "UpdateCloudFrontOriginAccessIdentity2020_05_31"

// UpdateCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCloudFrontOriginAccessIdentity for more information on using the UpdateCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.UpdateCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentityRequest(input *UpdateCloudFrontOriginAccessIdentityInput) (req *request.Request, output *UpdateCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opUpdateCloudFrontOriginAccessIdentity,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &UpdateCloudFrontOriginAccessIdentityInput{}
	}

	output = &UpdateCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Update an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentity(input *UpdateCloudFrontOriginAccessIdentityInput) (*UpdateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.UpdateCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// UpdateCloudFrontOriginAccessIdentityWithContext is the same as UpdateCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *UpdateCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*UpdateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.UpdateCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDistribution = "UpdateDistribution2020_05_31"

// UpdateDistributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDistribution for more information on using the UpdateDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDistributionRequest method.
//    req, resp := client.UpdateDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution
func (c *CloudFront) UpdateDistributionRequest(input *UpdateDistributionInput) (req *request.Request, output *UpdateDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateDistributionInput{}
	}

	output = &UpdateDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDistribution API operation for Amazon CloudFront.
//
// Updates the configuration for a web distribution.
//
// When you update a distribution, there are more required fields than when
// you create a distribution. When you update your distribution by using this
// API action, follow the steps here to get the current configuration and then
// make your updates, to make sure that you include all of the required fields.
// To view a summary, see Required Fields for Create Distribution and Update
// Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
// in the Amazon CloudFront Developer Guide.
//
// The update process includes getting the current distribution configuration,
// updating the XML document that is returned to make your changes, and then
// submitting an UpdateDistribution request to make the updates.
//
// For information about updating a distribution using the CloudFront console
// instead, see Creating a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html)
// in the Amazon CloudFront Developer Guide.
//
// To update a web distribution using the CloudFront API
//
// Submit a GetDistributionConfig (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html)
// request to get the current configuration and an Etag header for the distribution.
//
// If you update the distribution again, you must get a new Etag header.
//
// Update the XML document that was returned in the response to your GetDistributionConfig
// request to include your changes.
//
// When you edit the XML file, be aware of the following:
//
//    * You must strip out the ETag parameter that is returned.
//
//    * Additional fields are required when you update a distribution. There
//    may be fields included in the XML file for features that you haven't configured
//    for your distribution. This is expected and required to successfully update
//    the distribution.
//
//    * You can't change the value of CallerReference. If you try to change
//    this value, CloudFront returns an IllegalUpdate error.
//
//    * The new configuration replaces the existing configuration; the values
//    that you specify in an UpdateDistribution request are not merged into
//    your existing configuration. When you add, delete, or replace values in
//    an element that allows multiple values (for example, CNAME), you must
//    specify all of the values that you want to appear in the updated distribution.
//    In addition, you must update the corresponding Quantity element.
//
// Submit an UpdateDistribution request to update the configuration for your
// distribution:
//
//    * In the request body, include the XML document that you updated in Step
//    2. The request body must include an XML document with a DistributionConfig
//    element.
//
//    * Set the value of the HTTP If-Match header to the value of the ETag header
//    that CloudFront returned when you submitted the GetDistributionConfig
//    request in Step 1.
//
// Review the response to the UpdateDistribution request to confirm that the
// configuration was successfully updated.
//
// Optional: Submit a GetDistribution (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
// request to confirm that your changes have propagated. When propagation is
// complete, the value of Status is Deployed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeTooManyDistributionCNAMEs "TooManyDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeInvalidDefaultRootObject "InvalidDefaultRootObject"
//   The default root object file name is too big or contains an invalid character.
//
//   * ErrCodeInvalidRelativePath "InvalidRelativePath"
//   The relative path is too big, is not URL-encoded, or does not begin with
//   a slash (/).
//
//   * ErrCodeInvalidErrorCode "InvalidErrorCode"
//   An invalid error code was specified.
//
//   * ErrCodeInvalidResponseCode "InvalidResponseCode"
//   A response code is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInvalidViewerCertificate "InvalidViewerCertificate"
//   A viewer certificate specified is not valid.
//
//   * ErrCodeInvalidMinimumProtocolVersion "InvalidMinimumProtocolVersion"
//   The minimum protocol version specified is not valid.
//
//   * ErrCodeInvalidRequiredProtocol "InvalidRequiredProtocol"
//   This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
//   protocol in your request, or omit the RequiredProtocols element from your
//   distribution configuration.
//
//   * ErrCodeNoSuchOrigin "NoSuchOrigin"
//   No origin exists with the specified Origin Id.
//
//   * ErrCodeTooManyOrigins "TooManyOrigins"
//   You cannot create more origins for the distribution.
//
//   * ErrCodeTooManyOriginGroupsPerDistribution "TooManyOriginGroupsPerDistribution"
//   Processing your request would cause you to exceed the maximum number of origin
//   groups allowed.
//
//   * ErrCodeTooManyCacheBehaviors "TooManyCacheBehaviors"
//   You cannot create more cache behaviors for the distribution.
//
//   * ErrCodeTooManyCookieNamesInWhiteList "TooManyCookieNamesInWhiteList"
//   Your request contains more cookie names in the whitelist than are allowed
//   per cache behavior.
//
//   * ErrCodeInvalidForwardCookies "InvalidForwardCookies"
//   Your request contains forward cookies option which doesn't match with the
//   expectation for the whitelisted list of cookie names. Either list of cookie
//   names has been specified when not allowed or list of cookie names is missing
//   when expected.
//
//   * ErrCodeTooManyHeadersInForwardedValues "TooManyHeadersInForwardedValues"
//   Your request contains too many headers in forwarded values.
//
//   * ErrCodeInvalidHeadersForS3Origin "InvalidHeadersForS3Origin"
//   The headers specified are not valid for an Amazon S3 origin.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeTooManyCertificates "TooManyCertificates"
//   You cannot create anymore custom SSL/TLS certificates.
//
//   * ErrCodeInvalidLocationCode "InvalidLocationCode"
//   The location code specified is not valid.
//
//   * ErrCodeInvalidGeoRestrictionParameter "InvalidGeoRestrictionParameter"
//   The specified geo restriction parameter is not valid.
//
//   * ErrCodeInvalidTTLOrder "InvalidTTLOrder"
//   The TTL order specified is not valid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
//   * ErrCodeTooManyOriginCustomHeaders "TooManyOriginCustomHeaders"
//   Your request contains too many origin custom headers.
//
//   * ErrCodeTooManyQueryStringParameters "TooManyQueryStringParameters"
//   Your request contains too many query string parameters.
//
//   * ErrCodeInvalidQueryStringParameters "InvalidQueryStringParameters"
//   The query string parameters specified are not valid.
//
//   * ErrCodeTooManyDistributionsWithLambdaAssociations "TooManyDistributionsWithLambdaAssociations"
//   Processing your request would cause the maximum number of distributions with
//   Lambda function associations per owner to be exceeded.
//
//   * ErrCodeTooManyDistributionsWithSingleFunctionARN "TooManyDistributionsWithSingleFunctionARN"
//   The maximum number of distributions have been associated with the specified
//   Lambda function.
//
//   * ErrCodeTooManyLambdaFunctionAssociations "TooManyLambdaFunctionAssociations"
//   Your request contains more Lambda function associations than are allowed
//   per distribution.
//
//   * ErrCodeInvalidLambdaFunctionAssociation "InvalidLambdaFunctionAssociation"
//   The specified Lambda function association is invalid.
//
//   * ErrCodeInvalidOriginReadTimeout "InvalidOriginReadTimeout"
//   The read timeout specified for the origin is not valid.
//
//   * ErrCodeInvalidOriginKeepaliveTimeout "InvalidOriginKeepaliveTimeout"
//   The keep alive timeout specified for the origin is not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodeIllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
//   The specified configuration for field-level encryption can't be associated
//   with the specified cache behavior.
//
//   * ErrCodeTooManyDistributionsAssociatedToFieldLevelEncryptionConfig "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
//   The maximum number of distributions have been associated with the specified
//   configuration for field-level encryption.
//
//   * ErrCodeNoSuchCachePolicy "NoSuchCachePolicy"
//   The cache policy does not exist.
//
//   * ErrCodeTooManyDistributionsAssociatedToCachePolicy "TooManyDistributionsAssociatedToCachePolicy"
//   The maximum number of distributions have been associated with the specified
//   cache policy. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodeTooManyDistributionsAssociatedToOriginRequestPolicy "TooManyDistributionsAssociatedToOriginRequestPolicy"
//   The maximum number of distributions have been associated with the specified
//   origin request policy. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyDistributionsAssociatedToKeyGroup "TooManyDistributionsAssociatedToKeyGroup"
//   The number of distributions that reference this key group is more than the
//   maximum allowed. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyKeyGroupsAssociatedToDistribution "TooManyKeyGroupsAssociatedToDistribution"
//   The number of key groups referenced by this distribution is more than the
//   maximum allowed. For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTrustedKeyGroupDoesNotExist "TrustedKeyGroupDoesNotExist"
//   The specified key group does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution
func (c *CloudFront) UpdateDistribution(input *UpdateDistributionInput) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	return out, req.Send()
}

// UpdateDistributionWithContext is the same as UpdateDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateDistributionWithContext(ctx aws.Context, input *UpdateDistributionInput, opts ...request.Option) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFieldLevelEncryptionConfig = "UpdateFieldLevelEncryptionConfig2020_05_31"

// UpdateFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFieldLevelEncryptionConfig for more information on using the UpdateFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFieldLevelEncryptionConfigRequest method.
//    req, resp := client.UpdateFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig
func (c *CloudFront) UpdateFieldLevelEncryptionConfigRequest(input *UpdateFieldLevelEncryptionConfigInput) (req *request.Request, output *UpdateFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateFieldLevelEncryptionConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/field-level-encryption/{Id}/config",
	}

	if input == nil {
		input = &UpdateFieldLevelEncryptionConfigInput{}
	}

	output = &UpdateFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Update a field-level encryption configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeTooManyFieldLevelEncryptionQueryArgProfiles "TooManyFieldLevelEncryptionQueryArgProfiles"
//   The maximum number of query arg profiles for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionContentTypeProfiles "TooManyFieldLevelEncryptionContentTypeProfiles"
//   The maximum number of content type profiles for field-level encryption have
//   been created.
//
//   * ErrCodeQueryArgProfileEmpty "QueryArgProfileEmpty"
//   No profile specified for the field-level encryption query argument.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig
func (c *CloudFront) UpdateFieldLevelEncryptionConfig(input *UpdateFieldLevelEncryptionConfigInput) (*UpdateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// UpdateFieldLevelEncryptionConfigWithContext is the same as UpdateFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *UpdateFieldLevelEncryptionConfigInput, opts ...request.Option) (*UpdateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFieldLevelEncryptionProfile = "UpdateFieldLevelEncryptionProfile2020_05_31"

// UpdateFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFieldLevelEncryptionProfile for more information on using the UpdateFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFieldLevelEncryptionProfileRequest method.
//    req, resp := client.UpdateFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile
func (c *CloudFront) UpdateFieldLevelEncryptionProfileRequest(input *UpdateFieldLevelEncryptionProfileInput) (req *request.Request, output *UpdateFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateFieldLevelEncryptionProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/field-level-encryption-profile/{Id}/config",
	}

	if input == nil {
		input = &UpdateFieldLevelEncryptionProfileInput{}
	}

	output = &UpdateFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Update a field-level encryption profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeFieldLevelEncryptionProfileAlreadyExists "FieldLevelEncryptionProfileAlreadyExists"
//   The specified profile for field-level encryption already exists.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeFieldLevelEncryptionProfileSizeExceeded "FieldLevelEncryptionProfileSizeExceeded"
//   The maximum size of a profile for field-level encryption was exceeded.
//
//   * ErrCodeTooManyFieldLevelEncryptionEncryptionEntities "TooManyFieldLevelEncryptionEncryptionEntities"
//   The maximum number of encryption entities for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionFieldPatterns "TooManyFieldLevelEncryptionFieldPatterns"
//   The maximum number of field patterns for field-level encryption have been
//   created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile
func (c *CloudFront) UpdateFieldLevelEncryptionProfile(input *UpdateFieldLevelEncryptionProfileInput) (*UpdateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// UpdateFieldLevelEncryptionProfileWithContext is the same as UpdateFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *UpdateFieldLevelEncryptionProfileInput, opts ...request.Option) (*UpdateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKeyGroup = "UpdateKeyGroup2020_05_31"

// UpdateKeyGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKeyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKeyGroup for more information on using the UpdateKeyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateKeyGroupRequest method.
//    req, resp := client.UpdateKeyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup
func (c *CloudFront) UpdateKeyGroupRequest(input *UpdateKeyGroupInput) (req *request.Request, output *UpdateKeyGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateKeyGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/key-group/{Id}",
	}

	if input == nil {
		input = &UpdateKeyGroupInput{}
	}

	output = &UpdateKeyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKeyGroup API operation for Amazon CloudFront.
//
// Updates a key group.
//
// When you update a key group, all the fields are updated with the values provided
// in the request. You cannot update some fields independent of others. To update
// a key group:
//
// Get the current key group with GetKeyGroup or GetKeyGroupConfig.
//
// Locally modify the fields in the key group that you want to update. For example,
// add or remove public key IDs.
//
// Call UpdateKeyGroup with the entire key group object, including the fields
// that you modified and those that you didn’t.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateKeyGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeKeyGroupAlreadyExists "KeyGroupAlreadyExists"
//   A key group with this name already exists. You must provide a unique name.
//   To modify an existing key group, use UpdateKeyGroup.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeTooManyPublicKeysInKeyGroup "TooManyPublicKeysInKeyGroup"
//   The number of public keys in this key group is more than the maximum allowed.
//   For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup
func (c *CloudFront) UpdateKeyGroup(input *UpdateKeyGroupInput) (*UpdateKeyGroupOutput, error) {
	req, out := c.UpdateKeyGroupRequest(input)
	return out, req.Send()
}

// UpdateKeyGroupWithContext is the same as UpdateKeyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKeyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateKeyGroupWithContext(ctx aws.Context, input *UpdateKeyGroupInput, opts ...request.Option) (*UpdateKeyGroupOutput, error) {
	req, out := c.UpdateKeyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOriginRequestPolicy = "UpdateOriginRequestPolicy2020_05_31"

// UpdateOriginRequestPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOriginRequestPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOriginRequestPolicy for more information on using the UpdateOriginRequestPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOriginRequestPolicyRequest method.
//    req, resp := client.UpdateOriginRequestPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy
func (c *CloudFront) UpdateOriginRequestPolicyRequest(input *UpdateOriginRequestPolicyInput) (req *request.Request, output *UpdateOriginRequestPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateOriginRequestPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}",
	}

	if input == nil {
		input = &UpdateOriginRequestPolicyInput{}
	}

	output = &UpdateOriginRequestPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOriginRequestPolicy API operation for Amazon CloudFront.
//
// Updates an origin request policy configuration.
//
// When you update an origin request policy configuration, all the fields are
// updated with the values provided in the request. You cannot update some fields
// independent of others. To update an origin request policy configuration:
//
// Use GetOriginRequestPolicyConfig to get the current configuration.
//
// Locally modify the fields in the origin request policy configuration that
// you want to update.
//
// Call UpdateOriginRequestPolicy by providing the entire origin request policy
// configuration, including the fields that you modified and those that you
// didn’t.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateOriginRequestPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeNoSuchOriginRequestPolicy "NoSuchOriginRequestPolicy"
//   The origin request policy does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeOriginRequestPolicyAlreadyExists "OriginRequestPolicyAlreadyExists"
//   An origin request policy with this name already exists. You must provide
//   a unique name. To modify an existing origin request policy, use UpdateOriginRequestPolicy.
//
//   * ErrCodeTooManyHeadersInOriginRequestPolicy "TooManyHeadersInOriginRequestPolicy"
//   The number of headers in the origin request policy exceeds the maximum. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyCookiesInOriginRequestPolicy "TooManyCookiesInOriginRequestPolicy"
//   The number of cookies in the origin request policy exceeds the maximum. For
//   more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
//   * ErrCodeTooManyQueryStringsInOriginRequestPolicy "TooManyQueryStringsInOriginRequestPolicy"
//   The number of query strings in the origin request policy exceeds the maximum.
//   For more information, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
//   (formerly known as limits) in the Amazon CloudFront Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy
func (c *CloudFront) UpdateOriginRequestPolicy(input *UpdateOriginRequestPolicyInput) (*UpdateOriginRequestPolicyOutput, error) {
	req, out := c.UpdateOriginRequestPolicyRequest(input)
	return out, req.Send()
}

// UpdateOriginRequestPolicyWithContext is the same as UpdateOriginRequestPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOriginRequestPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateOriginRequestPolicyWithContext(ctx aws.Context, input *UpdateOriginRequestPolicyInput, opts ...request.Option) (*UpdateOriginRequestPolicyOutput, error) {
	req, out := c.UpdateOriginRequestPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePublicKey = "UpdatePublicKey2020_05_31"

// UpdatePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePublicKey for more information on using the UpdatePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePublicKeyRequest method.
//    req, resp := client.UpdatePublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey
func (c *CloudFront) UpdatePublicKeyRequest(input *UpdatePublicKeyInput) (req *request.Request, output *UpdatePublicKeyOutput) {
	op := &request.Operation{
		Name:       opUpdatePublicKey,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/public-key/{Id}/config",
	}

	if input == nil {
		input = &UpdatePublicKeyInput{}
	}

	output = &UpdatePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePublicKey API operation for Amazon CloudFront.
//
// Update public key information. Note that the only value you can change is
// the comment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdatePublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeCannotChangeImmutablePublicKeyFields "CannotChangeImmutablePublicKeyFields"
//   You can't change the value of a public key.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey
func (c *CloudFront) UpdatePublicKey(input *UpdatePublicKeyInput) (*UpdatePublicKeyOutput, error) {
	req, out := c.UpdatePublicKeyRequest(input)
	return out, req.Send()
}

// UpdatePublicKeyWithContext is the same as UpdatePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdatePublicKeyWithContext(ctx aws.Context, input *UpdatePublicKeyInput, opts ...request.Option) (*UpdatePublicKeyOutput, error) {
	req, out := c.UpdatePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRealtimeLogConfig = "UpdateRealtimeLogConfig2020_05_31"

// UpdateRealtimeLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRealtimeLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRealtimeLogConfig for more information on using the UpdateRealtimeLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRealtimeLogConfigRequest method.
//    req, resp := client.UpdateRealtimeLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig
func (c *CloudFront) UpdateRealtimeLogConfigRequest(input *UpdateRealtimeLogConfigInput) (req *request.Request, output *UpdateRealtimeLogConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateRealtimeLogConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/realtime-log-config/",
	}

	if input == nil {
		input = &UpdateRealtimeLogConfigInput{}
	}

	output = &UpdateRealtimeLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRealtimeLogConfig API operation for Amazon CloudFront.
//
// Updates a real-time log configuration.
//
// When you update a real-time log configuration, all the parameters are updated
// with the values provided in the request. You cannot update some parameters
// independent of others. To update a real-time log configuration:
//
// Call GetRealtimeLogConfig to get the current real-time log configuration.
//
// Locally modify the parameters in the real-time log configuration that you
// want to update.
//
// Call this API (UpdateRealtimeLogConfig) by providing the entire real-time
// log configuration, including the parameters that you modified and those that
// you didn’t.
//
// You cannot update a real-time log configuration’s Name or ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateRealtimeLogConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchRealtimeLogConfig "NoSuchRealtimeLogConfig"
//   The real-time log configuration does not exist.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig
func (c *CloudFront) UpdateRealtimeLogConfig(input *UpdateRealtimeLogConfigInput) (*UpdateRealtimeLogConfigOutput, error) {
	req, out := c.UpdateRealtimeLogConfigRequest(input)
	return out, req.Send()
}

// UpdateRealtimeLogConfigWithContext is the same as UpdateRealtimeLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRealtimeLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateRealtimeLogConfigWithContext(ctx aws.Context, input *UpdateRealtimeLogConfigInput, opts ...request.Option) (*UpdateRealtimeLogConfigOutput, error) {
	req, out := c.UpdateRealtimeLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStreamingDistribution = "UpdateStreamingDistribution2020_05_31"

// UpdateStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStreamingDistribution for more information on using the UpdateStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStreamingDistributionRequest method.
//    req, resp := client.UpdateStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution
func (c *CloudFront) UpdateStreamingDistributionRequest(input *UpdateStreamingDistributionInput) (req *request.Request, output *UpdateStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateStreamingDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2020-05-31/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateStreamingDistributionInput{}
	}

	output = &UpdateStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStreamingDistribution API operation for Amazon CloudFront.
//
// Update a streaming distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   The update contains modifications that are not allowed.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeTooManyStreamingDistributionCNAMEs "TooManyStreamingDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution
func (c *CloudFront) UpdateStreamingDistribution(input *UpdateStreamingDistributionInput) (*UpdateStreamingDistributionOutput, error) {
	req, out := c.UpdateStreamingDistributionRequest(input)
	return out, req.Send()
}

// UpdateStreamingDistributionWithContext is the same as UpdateStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateStreamingDistributionWithContext(ctx aws.Context, input *UpdateStreamingDistributionInput, opts ...request.Option) (*UpdateStreamingDistributionOutput, error) {
	req, out := c.UpdateStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A list of key groups, and the public keys in each key group, that CloudFront
// can use to verify the signatures of signed URLs and signed cookies.
type ActiveTrustedKeyGroups struct {
	_ struct{} `type:"structure"`

	// This field is true if any of the key groups have public keys that CloudFront
	// can use to verify the signatures of signed URLs and signed cookies. If not,
	// this field is false.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A list of key groups, including the identifiers of the public keys in each
	// key group that CloudFront can use to verify the signatures of signed URLs
	// and signed cookies.
	Items []*KGKeyPairIds `locationNameList:"KeyGroup" type:"list"`

	// The number of key groups in the list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ActiveTrustedKeyGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveTrustedKeyGroups) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ActiveTrustedKeyGroups) SetEnabled(v bool) *ActiveTrustedKeyGroups {
	s.Enabled = &v
	return s
}

// SetItems sets the Items field's value.
func (s *ActiveTrustedKeyGroups) SetItems(v []*KGKeyPairIds) *ActiveTrustedKeyGroups {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *ActiveTrustedKeyGroups) SetQuantity(v int64) *ActiveTrustedKeyGroups {
	s.Quantity = &v
	return s
}

// A list of AWS accounts and the active CloudFront key pairs in each account
// that CloudFront can use to verify the signatures of signed URLs and signed
// cookies.
type ActiveTrustedSigners struct {
	_ struct{} `type:"structure"`

	// This field is true if any of the AWS accounts in the list have active CloudFront
	// key pairs that CloudFront can use to verify the signatures of signed URLs
	// and signed cookies. If not, this field is false.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A list of AWS accounts and the identifiers of active CloudFront key pairs
	// in each account that CloudFront can use to verify the signatures of signed
	// URLs and signed cookies.
	Items []*Signer `locationNameList:"Signer" type:"list"`

	// The number of AWS accounts in the list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ActiveTrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveTrustedSigners) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ActiveTrustedSigners) SetEnabled(v bool) *ActiveTrustedSigners {
	s.Enabled = &v
	return s
}

// SetItems sets the Items field's value.
func (s *ActiveTrustedSigners) SetItems(v []*Signer) *ActiveTrustedSigners {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *ActiveTrustedSigners) SetQuantity(v int64) *ActiveTrustedSigners {
	s.Quantity = &v
	return s
}

// AWS services in China customers must file for an Internet Content Provider
// (ICP) recordal if they want to serve content publicly on an alternate domain
// name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal
// provides the ICP recordal status for CNAMEs associated with distributions.
// The status is returned in the CloudFront response; you can't configure it
// yourself.
//
// For more information about ICP recordals, see Signup, Accounts, and Credentials
// (https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
// in Getting Started with AWS services in China.
type AliasICPRecordal struct {
	_ struct{} `type:"structure"`

	// A domain name associated with a distribution.
	CNAME *string `type:"string"`

	// The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus
	// is set to APPROVED for all CNAMEs (aliases) in regions outside of China.
	//
	// The status values returned are the following:
	//
	//    * APPROVED indicates that the associated CNAME has a valid ICP recordal
	//    number. Multiple CNAMEs can be associated with a distribution, and CNAMEs
	//    can correspond to different ICP recordals. To be marked as APPROVED, that
	//    is, valid to use with China region, a CNAME must have one ICP recordal
	//    number associated with it.
	//
	//    * SUSPENDED indicates that the associated CNAME does not have a valid
	//    ICP recordal number.
	//
	//    * PENDING indicates that CloudFront can't determine the ICP recordal status
	//    of the CNAME associated with the distribution because there was an error
	//    in trying to determine the status. You can try again to see if the error
	//    is resolved in which case CloudFront returns an APPROVED or SUSPENDED
	//    status.
	ICPRecordalStatus *string `type:"string" enum:"ICPRecordalStatus"`
}

// String returns the string representation
func (s AliasICPRecordal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasICPRecordal) GoString() string {
	return s.String()
}

// SetCNAME sets the CNAME field's value.
func (s *AliasICPRecordal) SetCNAME(v string) *AliasICPRecordal {
	s.CNAME = &v
	return s
}

// SetICPRecordalStatus sets the ICPRecordalStatus field's value.
func (s *AliasICPRecordal) SetICPRecordalStatus(v string) *AliasICPRecordal {
	s.ICPRecordalStatus = &v
	return s
}

// A complex type that contains information about CNAMEs (alternate domain names),
// if any, for this distribution.
type Aliases struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the CNAME aliases, if any, that you want to
	// associate with this distribution.
	Items []*string `locationNameList:"CNAME" type:"list"`

	// The number of CNAME aliases, if any, that you want to associate with this
	// distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Aliases) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Aliases) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Aliases) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Aliases"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Aliases) SetItems(v []*string) *Aliases {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Aliases) SetQuantity(v int64) *Aliases {
	s.Quantity = &v
	return s
}

// A complex type that controls which HTTP methods CloudFront processes and
// forwards to your Amazon S3 bucket or your custom origin. There are three
// choices:
//
//    * CloudFront forwards only GET and HEAD requests.
//
//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
//
//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
//    requests.
//
// If you pick the third choice, you may need to restrict access to your Amazon
// S3 bucket or to your custom origin so users can't perform operations that
// you don't want them to. For example, you might not want users to have permissions
// to delete objects from your origin.
type AllowedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that controls whether CloudFront caches the response to requests
	// using the specified HTTP methods. There are two choices:
	//
	//    * CloudFront caches responses to GET and HEAD requests.
	//
	//    * CloudFront caches responses to GET, HEAD, and OPTIONS requests.
	//
	// If you pick the second choice for your Amazon S3 Origin, you may need to
	// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
	// Origin headers for the responses to be cached correctly.
	CachedMethods *CachedMethods `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// process and forward to your origin.
	//
	// Items is a required field
	Items []*string `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods that you want CloudFront to forward to your origin.
	// Valid values are 2 (for GET and HEAD requests), 3 (for GET, HEAD, and OPTIONS
	// requests) and 7 (for GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE requests).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s AllowedMethods) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllowedMethods) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowedMethods) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowedMethods"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.CachedMethods != nil {
		if err := s.CachedMethods.Validate(); err != nil {
			invalidParams.AddNested("CachedMethods", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCachedMethods sets the CachedMethods field's value.
func (s *AllowedMethods) SetCachedMethods(v *CachedMethods) *AllowedMethods {
	s.CachedMethods = v
	return s
}

// SetItems sets the Items field's value.
func (s *AllowedMethods) SetItems(v []*string) *AllowedMethods {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AllowedMethods) SetQuantity(v int64) *AllowedMethods {
	s.Quantity = &v
	return s
}

// A complex type that describes how CloudFront processes requests.
//
// You must create at least as many cache behaviors (including the default cache
// behavior) as you have origins if you want CloudFront to serve objects from
// all of the origins. Each cache behavior specifies the one origin from which
// you want CloudFront to get objects. If you have two origins and only the
// default cache behavior, the default cache behavior will cause CloudFront
// to get objects from one of the origins, but the other origin is never used.
//
// For the current quota (formerly known as limit) on the number of cache behaviors
// that you can add to a distribution, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// in the Amazon CloudFront Developer Guide.
//
// If you don’t want to specify any cache behaviors, include only an empty
// CacheBehaviors element. Don’t include an empty CacheBehavior element because
// this is invalid.
//
// To delete all cache behaviors in an existing distribution, update the distribution
// configuration and include only an empty CacheBehaviors element.
//
// To add, change, or remove one or more cache behaviors, update the distribution
// configuration and specify all of the cache behaviors that you want to include
// in the updated distribution.
//
// For more information about cache behaviors, see Cache Behavior Settings (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior)
// in the Amazon CloudFront Developer Guide.
type CacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//    * CloudFront forwards only GET and HEAD requests.
	//
	//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
	//
	//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	//    requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon
	// S3 bucket or to your custom origin so users can't perform operations that
	// you don't want them to. For example, you might not want users to have permissions
	// to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// The unique identifier of the cache policy that is attached to this cache
	// behavior. For more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	CachePolicyId *string `type:"string"`

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more information,
	// see Serving Compressed Files (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html)
	// in the Amazon CloudFront Developer Guide.
	Compress *bool `type:"boolean"`

	// This field is deprecated. We recommend that you use the DefaultTTL field
	// in a cache policy instead of this field. For more information, see Creating
	// cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin does not add HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Deprecated: DefaultTTL has been deprecated
	DefaultTTL *int64 `deprecated:"true" type:"long"`

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for this cache behavior.
	FieldLevelEncryptionId *string `type:"string"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field. For more information, see Working
	// with policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to include values in the cache key, use a cache policy. For more
	// information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send values to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see Creating origin
	// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// or Using the managed origin request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// A complex type that specifies how CloudFront handles query strings, cookies,
	// and HTTP headers.
	//
	// Deprecated: ForwardedValues has been deprecated
	ForwardedValues *ForwardedValues `deprecated:"true" type:"structure"`

	// A complex type that contains zero or more Lambda function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations `type:"structure"`

	// This field is deprecated. We recommend that you use the MaxTTL field in a
	// cache policy instead of this field. For more information, see Creating cache
	// policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Deprecated: MaxTTL has been deprecated
	MaxTTL *int64 `deprecated:"true" type:"long"`

	// This field is deprecated. We recommend that you use the MinTTL field in a
	// cache policy instead of this field. For more information, see Creating cache
	// policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see Managing How Long
	// Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers, if you specify 1 for Quantity and
	// * for Name).
	//
	// Deprecated: MinTTL has been deprecated
	MinTTL *int64 `deprecated:"true" type:"long"`

	// The unique identifier of the origin request policy that is attached to this
	// cache behavior. For more information, see Creating origin request policies
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// or Using the managed origin request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html)
	// in the Amazon CloudFront Developer Guide.
	OriginRequestPolicyId *string `type:"string"`

	// The pattern (for example, images/*.jpg) that specifies which requests to
	// apply the behavior to. When CloudFront receives a viewer request, the requested
	// path is compared with path patterns in the order in which cache behaviors
	// are listed in the distribution.
	//
	// You can optionally include a slash (/) at the beginning of the path pattern.
	// For example, /images/*.jpg. CloudFront behavior is the same with or without
	// the leading /.
	//
	// The path pattern for the default cache behavior is * and cannot be changed.
	// If the request for an object does not match the path pattern for any cache
	// behaviors, CloudFront applies the behavior in the default cache behavior.
	//
	// For more information, see Path Pattern (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern)
	// in the Amazon CloudFront Developer Guide.
	//
	// PathPattern is a required field
	PathPattern *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the real-time log configuration that is
	// attached to this cache behavior. For more information, see Real-time logs
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html)
	// in the Amazon CloudFront Developer Guide.
	RealtimeLogConfigArn *string `type:"string"`

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false. If you specify true for SmoothStreaming,
	// you can still distribute other content using this cache behavior if the content
	// matches the value of PathPattern.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when they match this cache behavior.
	//
	// TargetOriginId is a required field
	TargetOriginId *string `type:"string" required:"true"`

	// A list of key groups that CloudFront can use to validate signed URLs or signed
	// cookies.
	//
	// When a cache behavior contains trusted key groups, CloudFront requires signed
	// URLs or signed cookies for all requests that match the cache behavior. The
	// URLs or cookies must be signed with a private key whose corresponding public
	// key is in the key group. The signed URL or cookie contains information about
	// which public key CloudFront should use to verify the signature. For more
	// information, see Serving private content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	TrustedKeyGroups *TrustedKeyGroups `type:"structure"`

	//
	// We recommend using TrustedKeyGroups instead of TrustedSigners.
	//
	// A list of AWS account IDs whose public keys CloudFront can use to validate
	// signed URLs or signed cookies.
	//
	// When a cache behavior contains trusted signers, CloudFront requires signed
	// URLs or signed cookies for all requests that match the cache behavior. The
	// URLs or cookies must be signed with the private key of a CloudFront key pair
	// in the trusted signer’s AWS account. The signed URL or cookie contains
	// information about which public key CloudFront should use to verify the signature.
	// For more information, see Serving private content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	TrustedSigners *TrustedSigners `type:"structure"`

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern.
	// You can specify the following options:
	//
	//    * allow-all: Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
	//    an HTTP status code of 301 (Moved Permanently) to the viewer along with
	//    the HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//    * https-only: If a viewer sends an HTTP request, CloudFront returns an
	//    HTTP status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see Requiring HTTPS
	// Between Viewers and CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched
	// from the origin using HTTPS is never to use any other protocol to fetch the
	// object. If you have recently changed from HTTP to HTTPS, we recommend that
	// you clear your objects’ cache because cached objects are protocol agnostic.
	// That means that an edge location will return an object from the cache regardless
	// of whether the current request protocol matches the protocol used previously.
	// For more information, see Managing Cache Expiration (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerProtocolPolicy is a required field
	ViewerProtocolPolicy *string `type:"string" required:"true" enum:"ViewerProtocolPolicy"`
}

// String returns the string representation
func (s CacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CacheBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CacheBehavior"}
	if s.PathPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("PathPattern"))
	}
	if s.TargetOriginId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOriginId"))
	}
	if s.ViewerProtocolPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerProtocolPolicy"))
	}
	if s.AllowedMethods != nil {
		if err := s.AllowedMethods.Validate(); err != nil {
			invalidParams.AddNested("AllowedMethods", err.(request.ErrInvalidParams))
		}
	}
	if s.ForwardedValues != nil {
		if err := s.ForwardedValues.Validate(); err != nil {
			invalidParams.AddNested("ForwardedValues", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAssociations != nil {
		if err := s.LambdaFunctionAssociations.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAssociations", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedKeyGroups != nil {
		if err := s.TrustedKeyGroups.Validate(); err != nil {
			invalidParams.AddNested("TrustedKeyGroups", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CacheBehavior) SetAllowedMethods(v *AllowedMethods) *CacheBehavior {
	s.AllowedMethods = v
	return s
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *CacheBehavior) SetCachePolicyId(v string) *CacheBehavior {
	s.CachePolicyId = &v
	return s
}

// SetCompress sets the Compress field's value.
func (s *CacheBehavior) SetCompress(v bool) *CacheBehavior {
	s.Compress = &v
	return s
}

// SetDefaultTTL sets the DefaultTTL field's value.
func (s *CacheBehavior) SetDefaultTTL(v int64) *CacheBehavior {
	s.DefaultTTL = &v
	return s
}

// SetFieldLevelEncryptionId sets the FieldLevelEncryptionId field's value.
func (s *CacheBehavior) SetFieldLevelEncryptionId(v string) *CacheBehavior {
	s.FieldLevelEncryptionId = &v
	return s
}

// SetForwardedValues sets the ForwardedValues field's value.
func (s *CacheBehavior) SetForwardedValues(v *ForwardedValues) *CacheBehavior {
	s.ForwardedValues = v
	return s
}

// SetLambdaFunctionAssociations sets the LambdaFunctionAssociations field's value.
func (s *CacheBehavior) SetLambdaFunctionAssociations(v *LambdaFunctionAssociations) *CacheBehavior {
	s.LambdaFunctionAssociations = v
	return s
}

// SetMaxTTL sets the MaxTTL field's value.
func (s *CacheBehavior) SetMaxTTL(v int64) *CacheBehavior {
	s.MaxTTL = &v
	return s
}

// SetMinTTL sets the MinTTL field's value.
func (s *CacheBehavior) SetMinTTL(v int64) *CacheBehavior {
	s.MinTTL = &v
	return s
}

// SetOriginRequestPolicyId sets the OriginRequestPolicyId field's value.
func (s *CacheBehavior) SetOriginRequestPolicyId(v string) *CacheBehavior {
	s.OriginRequestPolicyId = &v
	return s
}

// SetPathPattern sets the PathPattern field's value.
func (s *CacheBehavior) SetPathPattern(v string) *CacheBehavior {
	s.PathPattern = &v
	return s
}

// SetRealtimeLogConfigArn sets the RealtimeLogConfigArn field's value.
func (s *CacheBehavior) SetRealtimeLogConfigArn(v string) *CacheBehavior {
	s.RealtimeLogConfigArn = &v
	return s
}

// SetSmoothStreaming sets the SmoothStreaming field's value.
func (s *CacheBehavior) SetSmoothStreaming(v bool) *CacheBehavior {
	s.SmoothStreaming = &v
	return s
}

// SetTargetOriginId sets the TargetOriginId field's value.
func (s *CacheBehavior) SetTargetOriginId(v string) *CacheBehavior {
	s.TargetOriginId = &v
	return s
}

// SetTrustedKeyGroups sets the TrustedKeyGroups field's value.
func (s *CacheBehavior) SetTrustedKeyGroups(v *TrustedKeyGroups) *CacheBehavior {
	s.TrustedKeyGroups = v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *CacheBehavior) SetTrustedSigners(v *TrustedSigners) *CacheBehavior {
	s.TrustedSigners = v
	return s
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *CacheBehavior) SetViewerProtocolPolicy(v string) *CacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// A complex type that contains zero or more CacheBehavior elements.
type CacheBehaviors struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains cache behaviors for this distribution.
	// If Quantity is 0, you can omit Items.
	Items []*CacheBehavior `locationNameList:"CacheBehavior" type:"list"`

	// The number of cache behaviors for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehaviors) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CacheBehaviors) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CacheBehaviors"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CacheBehaviors) SetItems(v []*CacheBehavior) *CacheBehaviors {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CacheBehaviors) SetQuantity(v int64) *CacheBehaviors {
	s.Quantity = &v
	return s
}

// A cache policy.
//
// When it’s attached to a cache behavior, the cache policy determines the
// following:
//
//    * The values that CloudFront includes in the cache key. These values can
//    include HTTP headers, cookies, and URL query strings. CloudFront uses
//    the cache key to find an object in its cache that it can return to the
//    viewer.
//
//    * The default, minimum, and maximum time to live (TTL) values that you
//    want objects to stay in the CloudFront cache.
//
// The headers, cookies, and query strings that are included in the cache key
// are automatically included in requests that CloudFront sends to the origin.
// CloudFront sends a request when it can’t find a valid object in its cache
// that matches the request’s cache key. If you want to send values to the
// origin but not include them in the cache key, use OriginRequestPolicy.
type CachePolicy struct {
	_ struct{} `type:"structure"`

	// The cache policy configuration.
	//
	// CachePolicyConfig is a required field
	CachePolicyConfig *CachePolicyConfig `type:"structure" required:"true"`

	// The unique identifier for the cache policy.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time when the cache policy was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s CachePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicy) GoString() string {
	return s.String()
}

// SetCachePolicyConfig sets the CachePolicyConfig field's value.
func (s *CachePolicy) SetCachePolicyConfig(v *CachePolicyConfig) *CachePolicy {
	s.CachePolicyConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *CachePolicy) SetId(v string) *CachePolicy {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CachePolicy) SetLastModifiedTime(v time.Time) *CachePolicy {
	s.LastModifiedTime = &v
	return s
}

// A cache policy configuration.
//
// This configuration determines the following:
//
//    * The values that CloudFront includes in the cache key. These values can
//    include HTTP headers, cookies, and URL query strings. CloudFront uses
//    the cache key to find an object in its cache that it can return to the
//    viewer.
//
//    * The default, minimum, and maximum time to live (TTL) values that you
//    want objects to stay in the CloudFront cache.
//
// The headers, cookies, and query strings that are included in the cache key
// are automatically included in requests that CloudFront sends to the origin.
// CloudFront sends a request when it can’t find a valid object in its cache
// that matches the request’s cache key. If you want to send values to the
// origin but not include them in the cache key, use OriginRequestPolicy.
type CachePolicyConfig struct {
	_ struct{} `type:"structure"`

	// A comment to describe the cache policy.
	Comment *string `type:"string"`

	// The default amount of time, in seconds, that you want objects to stay in
	// the CloudFront cache before CloudFront sends another request to the origin
	// to see if the object has been updated. CloudFront uses this value as the
	// object’s time to live (TTL) only when the origin does not send Cache-Control
	// or Expires headers with the object. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The default value for this field is 86400 seconds (one day). If the value
	// of MinTTL is more than 86400 seconds, then the default value for this field
	// is the same as the value of MinTTL.
	DefaultTTL *int64 `type:"long"`

	// The maximum amount of time, in seconds, that objects stay in the CloudFront
	// cache before CloudFront sends another request to the origin to see if the
	// object has been updated. CloudFront uses this value only when the origin
	// sends Cache-Control or Expires headers with the object. For more information,
	// see Managing How Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The default value for this field is 31536000 seconds (one year). If the value
	// of MinTTL or DefaultTTL is more than 31536000 seconds, then the default value
	// for this field is the same as the value of DefaultTTL.
	MaxTTL *int64 `type:"long"`

	// The minimum amount of time, in seconds, that you want objects to stay in
	// the CloudFront cache before CloudFront sends another request to the origin
	// to see if the object has been updated. For more information, see Managing
	// How Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// MinTTL is a required field
	MinTTL *int64 `type:"long" required:"true"`

	// A unique name to identify the cache policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The HTTP headers, cookies, and URL query strings to include in the cache
	// key. The values included in the cache key are automatically included in requests
	// that CloudFront sends to the origin.
	ParametersInCacheKeyAndForwardedToOrigin *ParametersInCacheKeyAndForwardedToOrigin `type:"structure"`
}

// String returns the string representation
func (s CachePolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachePolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CachePolicyConfig"}
	if s.MinTTL == nil {
		invalidParams.Add(request.NewErrParamRequired("MinTTL"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ParametersInCacheKeyAndForwardedToOrigin != nil {
		if err := s.ParametersInCacheKeyAndForwardedToOrigin.Validate(); err != nil {
			invalidParams.AddNested("ParametersInCacheKeyAndForwardedToOrigin", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CachePolicyConfig) SetComment(v string) *CachePolicyConfig {
	s.Comment = &v
	return s
}

// SetDefaultTTL sets the DefaultTTL field's value.
func (s *CachePolicyConfig) SetDefaultTTL(v int64) *CachePolicyConfig {
	s.DefaultTTL = &v
	return s
}

// SetMaxTTL sets the MaxTTL field's value.
func (s *CachePolicyConfig) SetMaxTTL(v int64) *CachePolicyConfig {
	s.MaxTTL = &v
	return s
}

// SetMinTTL sets the MinTTL field's value.
func (s *CachePolicyConfig) SetMinTTL(v int64) *CachePolicyConfig {
	s.MinTTL = &v
	return s
}

// SetName sets the Name field's value.
func (s *CachePolicyConfig) SetName(v string) *CachePolicyConfig {
	s.Name = &v
	return s
}

// SetParametersInCacheKeyAndForwardedToOrigin sets the ParametersInCacheKeyAndForwardedToOrigin field's value.
func (s *CachePolicyConfig) SetParametersInCacheKeyAndForwardedToOrigin(v *ParametersInCacheKeyAndForwardedToOrigin) *CachePolicyConfig {
	s.ParametersInCacheKeyAndForwardedToOrigin = v
	return s
}

// An object that determines whether any cookies in viewer requests (and if
// so, which cookies) are included in the cache key and automatically included
// in requests that CloudFront sends to the origin.
type CachePolicyCookiesConfig struct {
	_ struct{} `type:"structure"`

	// Determines whether any cookies in viewer requests are included in the cache
	// key and automatically included in requests that CloudFront sends to the origin.
	// Valid values are:
	//
	//    * none – Cookies in viewer requests are not included in the cache key
	//    and are not automatically included in requests that CloudFront sends to
	//    the origin. Even when this field is set to none, any cookies that are
	//    listed in an OriginRequestPolicy are included in origin requests.
	//
	//    * whitelist – The cookies in viewer requests that are listed in the
	//    CookieNames type are included in the cache key and automatically included
	//    in requests that CloudFront sends to the origin.
	//
	//    * allExcept – All cookies in viewer requests that are not listed in
	//    the CookieNames type are included in the cache key and automatically included
	//    in requests that CloudFront sends to the origin.
	//
	//    * all – All cookies in viewer requests are included in the cache key
	//    and are automatically included in requests that CloudFront sends to the
	//    origin.
	//
	// CookieBehavior is a required field
	CookieBehavior *string `type:"string" required:"true" enum:"CachePolicyCookieBehavior"`

	// Contains a list of cookie names.
	Cookies *CookieNames `type:"structure"`
}

// String returns the string representation
func (s CachePolicyCookiesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicyCookiesConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachePolicyCookiesConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CachePolicyCookiesConfig"}
	if s.CookieBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("CookieBehavior"))
	}
	if s.Cookies != nil {
		if err := s.Cookies.Validate(); err != nil {
			invalidParams.AddNested("Cookies", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCookieBehavior sets the CookieBehavior field's value.
func (s *CachePolicyCookiesConfig) SetCookieBehavior(v string) *CachePolicyCookiesConfig {
	s.CookieBehavior = &v
	return s
}

// SetCookies sets the Cookies field's value.
func (s *CachePolicyCookiesConfig) SetCookies(v *CookieNames) *CachePolicyCookiesConfig {
	s.Cookies = v
	return s
}

// An object that determines whether any HTTP headers (and if so, which headers)
// are included in the cache key and automatically included in requests that
// CloudFront sends to the origin.
type CachePolicyHeadersConfig struct {
	_ struct{} `type:"structure"`

	// Determines whether any HTTP headers are included in the cache key and automatically
	// included in requests that CloudFront sends to the origin. Valid values are:
	//
	//    * none – HTTP headers are not included in the cache key and are not
	//    automatically included in requests that CloudFront sends to the origin.
	//    Even when this field is set to none, any headers that are listed in an
	//    OriginRequestPolicy are included in origin requests.
	//
	//    * whitelist – The HTTP headers that are listed in the Headers type are
	//    included in the cache key and are automatically included in requests that
	//    CloudFront sends to the origin.
	//
	// HeaderBehavior is a required field
	HeaderBehavior *string `type:"string" required:"true" enum:"CachePolicyHeaderBehavior"`

	// Contains a list of HTTP header names.
	Headers *Headers `type:"structure"`
}

// String returns the string representation
func (s CachePolicyHeadersConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicyHeadersConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachePolicyHeadersConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CachePolicyHeadersConfig"}
	if s.HeaderBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderBehavior"))
	}
	if s.Headers != nil {
		if err := s.Headers.Validate(); err != nil {
			invalidParams.AddNested("Headers", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderBehavior sets the HeaderBehavior field's value.
func (s *CachePolicyHeadersConfig) SetHeaderBehavior(v string) *CachePolicyHeadersConfig {
	s.HeaderBehavior = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *CachePolicyHeadersConfig) SetHeaders(v *Headers) *CachePolicyHeadersConfig {
	s.Headers = v
	return s
}

// A list of cache policies.
type CachePolicyList struct {
	_ struct{} `type:"structure"`

	// Contains the cache policies in the list.
	Items []*CachePolicySummary `locationNameList:"CachePolicySummary" type:"list"`

	// The maximum number of cache policies requested.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more items in the list than are in this response, this element
	// is present. It contains the value that you should use in the Marker field
	// of a subsequent request to continue listing cache policies where you left
	// off.
	NextMarker *string `type:"string"`

	// The total number of cache policies returned in the response.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CachePolicyList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicyList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *CachePolicyList) SetItems(v []*CachePolicySummary) *CachePolicyList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *CachePolicyList) SetMaxItems(v int64) *CachePolicyList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *CachePolicyList) SetNextMarker(v string) *CachePolicyList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CachePolicyList) SetQuantity(v int64) *CachePolicyList {
	s.Quantity = &v
	return s
}

// An object that determines whether any URL query strings in viewer requests
// (and if so, which query strings) are included in the cache key and automatically
// included in requests that CloudFront sends to the origin.
type CachePolicyQueryStringsConfig struct {
	_ struct{} `type:"structure"`

	// Determines whether any URL query strings in viewer requests are included
	// in the cache key and automatically included in requests that CloudFront sends
	// to the origin. Valid values are:
	//
	//    * none – Query strings in viewer requests are not included in the cache
	//    key and are not automatically included in requests that CloudFront sends
	//    to the origin. Even when this field is set to none, any query strings
	//    that are listed in an OriginRequestPolicy are included in origin requests.
	//
	//    * whitelist – The query strings in viewer requests that are listed in
	//    the QueryStringNames type are included in the cache key and automatically
	//    included in requests that CloudFront sends to the origin.
	//
	//    * allExcept – All query strings in viewer requests that are not listed
	//    in the QueryStringNames type are included in the cache key and automatically
	//    included in requests that CloudFront sends to the origin.
	//
	//    * all – All query strings in viewer requests are included in the cache
	//    key and are automatically included in requests that CloudFront sends to
	//    the origin.
	//
	// QueryStringBehavior is a required field
	QueryStringBehavior *string `type:"string" required:"true" enum:"CachePolicyQueryStringBehavior"`

	// Contains the specific query strings in viewer requests that either are or
	// are not included in the cache key and automatically included in requests
	// that CloudFront sends to the origin. The behavior depends on whether the
	// QueryStringBehavior field in the CachePolicyQueryStringsConfig type is set
	// to whitelist (the listed query strings are included) or allExcept (the listed
	// query strings are not included, but all other query strings are).
	QueryStrings *QueryStringNames `type:"structure"`
}

// String returns the string representation
func (s CachePolicyQueryStringsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicyQueryStringsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachePolicyQueryStringsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CachePolicyQueryStringsConfig"}
	if s.QueryStringBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryStringBehavior"))
	}
	if s.QueryStrings != nil {
		if err := s.QueryStrings.Validate(); err != nil {
			invalidParams.AddNested("QueryStrings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryStringBehavior sets the QueryStringBehavior field's value.
func (s *CachePolicyQueryStringsConfig) SetQueryStringBehavior(v string) *CachePolicyQueryStringsConfig {
	s.QueryStringBehavior = &v
	return s
}

// SetQueryStrings sets the QueryStrings field's value.
func (s *CachePolicyQueryStringsConfig) SetQueryStrings(v *QueryStringNames) *CachePolicyQueryStringsConfig {
	s.QueryStrings = v
	return s
}

// Contains a cache policy.
type CachePolicySummary struct {
	_ struct{} `type:"structure"`

	// The cache policy.
	//
	// CachePolicy is a required field
	CachePolicy *CachePolicy `type:"structure" required:"true"`

	// The type of cache policy, either managed (created by AWS) or custom (created
	// in this AWS account).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"CachePolicyType"`
}

// String returns the string representation
func (s CachePolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachePolicySummary) GoString() string {
	return s.String()
}

// SetCachePolicy sets the CachePolicy field's value.
func (s *CachePolicySummary) SetCachePolicy(v *CachePolicy) *CachePolicySummary {
	s.CachePolicy = v
	return s
}

// SetType sets the Type field's value.
func (s *CachePolicySummary) SetType(v string) *CachePolicySummary {
	s.Type = &v
	return s
}

// A complex type that controls whether CloudFront caches the response to requests
// using the specified HTTP methods. There are two choices:
//
//    * CloudFront caches responses to GET and HEAD requests.
//
//    * CloudFront caches responses to GET, HEAD, and OPTIONS requests.
//
// If you pick the second choice for your Amazon S3 Origin, you may need to
// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
// Origin headers for the responses to be cached correctly.
type CachedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// cache responses to.
	//
	// Items is a required field
	Items []*string `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods for which you want CloudFront to cache responses.
	// Valid values are 2 (for caching responses to GET and HEAD requests) and 3
	// (for caching responses to GET, HEAD, and OPTIONS requests).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CachedMethods) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachedMethods) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachedMethods) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CachedMethods"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CachedMethods) SetItems(v []*string) *CachedMethods {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CachedMethods) SetQuantity(v int64) *CachedMethods {
	s.Quantity = &v
	return s
}

// A field-level encryption content type profile.
type ContentTypeProfile struct {
	_ struct{} `type:"structure"`

	// The content type for a field-level encryption content type-profile mapping.
	//
	// ContentType is a required field
	ContentType *string `type:"string" required:"true"`

	// The format for a field-level encryption content type-profile mapping.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// The profile ID for a field-level encryption content type-profile mapping.
	ProfileId *string `type:"string"`
}

// String returns the string representation
func (s ContentTypeProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentTypeProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentTypeProfile"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ContentTypeProfile) SetContentType(v string) *ContentTypeProfile {
	s.ContentType = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ContentTypeProfile) SetFormat(v string) *ContentTypeProfile {
	s.Format = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ContentTypeProfile) SetProfileId(v string) *ContentTypeProfile {
	s.ProfileId = &v
	return s
}

// The configuration for a field-level encryption content type-profile mapping.
type ContentTypeProfileConfig struct {
	_ struct{} `type:"structure"`

	// The configuration for a field-level encryption content type-profile.
	ContentTypeProfiles *ContentTypeProfiles `type:"structure"`

	// The setting in a field-level encryption content type-profile mapping that
	// specifies what to do when an unknown content type is provided for the profile.
	// If true, content is forwarded without being encrypted when the content type
	// is unknown. If false (the default), an error is returned when the content
	// type is unknown.
	//
	// ForwardWhenContentTypeIsUnknown is a required field
	ForwardWhenContentTypeIsUnknown *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ContentTypeProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentTypeProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentTypeProfileConfig"}
	if s.ForwardWhenContentTypeIsUnknown == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardWhenContentTypeIsUnknown"))
	}
	if s.ContentTypeProfiles != nil {
		if err := s.ContentTypeProfiles.Validate(); err != nil {
			invalidParams.AddNested("ContentTypeProfiles", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentTypeProfiles sets the ContentTypeProfiles field's value.
func (s *ContentTypeProfileConfig) SetContentTypeProfiles(v *ContentTypeProfiles) *ContentTypeProfileConfig {
	s.ContentTypeProfiles = v
	return s
}

// SetForwardWhenContentTypeIsUnknown sets the ForwardWhenContentTypeIsUnknown field's value.
func (s *ContentTypeProfileConfig) SetForwardWhenContentTypeIsUnknown(v bool) *ContentTypeProfileConfig {
	s.ForwardWhenContentTypeIsUnknown = &v
	return s
}

// Field-level encryption content type-profile.
type ContentTypeProfiles struct {
	_ struct{} `type:"structure"`

	// Items in a field-level encryption content type-profile mapping.
	Items []*ContentTypeProfile `locationNameList:"ContentTypeProfile" type:"list"`

	// The number of field-level encryption content type-profile mappings.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ContentTypeProfiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentTypeProfiles) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfiles) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentTypeProfiles"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *ContentTypeProfiles) SetItems(v []*ContentTypeProfile) *ContentTypeProfiles {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *ContentTypeProfiles) SetQuantity(v int64) *ContentTypeProfiles {
	s.Quantity = &v
	return s
}

// Contains a list of cookie names.
type CookieNames struct {
	_ struct{} `type:"structure"`

	// A list of cookie names.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of cookie names in the Items list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CookieNames) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookieNames) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CookieNames) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CookieNames"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CookieNames) SetItems(v []*string) *CookieNames {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CookieNames) SetQuantity(v int64) *CookieNames {
	s.Quantity = &v
	return s
}

// This field is deprecated. We recommend that you use a cache policy or an
// origin request policy instead of this field.
//
// If you want to include cookies in the cache key, use CookiesConfig in a cache
// policy. See CachePolicy.
//
// If you want to send cookies to the origin but not include them in the cache
// key, use CookiesConfig in an origin request policy. See OriginRequestPolicy.
//
// A complex type that specifies whether you want CloudFront to forward cookies
// to the origin and, if so, which ones. For more information about forwarding
// cookies to the origin, see Caching Content Based on Cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
// in the Amazon CloudFront Developer Guide.
type CookiePreference struct {
	_ struct{} `type:"structure"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field.
	//
	// If you want to include cookies in the cache key, use a cache policy. For
	// more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send cookies to the origin but not include them in the cache
	// key, use origin request policy. For more information, see Creating origin
	// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// Specifies which cookies to forward to the origin for this cache behavior:
	// all, none, or the list of cookies specified in the WhitelistedNames complex
	// type.
	//
	// Amazon S3 doesn't process cookies. When the cache behavior is forwarding
	// requests to an Amazon S3 origin, specify none for the Forward element.
	//
	// Forward is a required field
	Forward *string `type:"string" required:"true" enum:"ItemSelection"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field.
	//
	// If you want to include cookies in the cache key, use a cache policy. For
	// more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send cookies to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see Creating origin
	// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// Required if you specify whitelist for the value of Forward. A complex type
	// that specifies how many different cookies you want CloudFront to forward
	// to the origin for this cache behavior and, if you want to forward selected
	// cookies, the names of those cookies.
	//
	// If you specify all or none for the value of Forward, omit WhitelistedNames.
	// If you change the value of Forward from whitelist to all or none and you
	// don't delete the WhitelistedNames element and its child elements, CloudFront
	// deletes them automatically.
	//
	// For the current limit on the number of cookie names that you can whitelist
	// for each cache behavior, see CloudFront Limits (https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront)
	// in the AWS General Reference.
	WhitelistedNames *CookieNames `type:"structure"`
}

// String returns the string representation
func (s CookiePreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookiePreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CookiePreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CookiePreference"}
	if s.Forward == nil {
		invalidParams.Add(request.NewErrParamRequired("Forward"))
	}
	if s.WhitelistedNames != nil {
		if err := s.WhitelistedNames.Validate(); err != nil {
			invalidParams.AddNested("WhitelistedNames", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForward sets the Forward field's value.
func (s *CookiePreference) SetForward(v string) *CookiePreference {
	s.Forward = &v
	return s
}

// SetWhitelistedNames sets the WhitelistedNames field's value.
func (s *CookiePreference) SetWhitelistedNames(v *CookieNames) *CookiePreference {
	s.WhitelistedNames = v
	return s
}

type CreateCachePolicyInput struct {
	_ struct{} `locationName:"CreateCachePolicyRequest" type:"structure" payload:"CachePolicyConfig"`

	// A cache policy configuration.
	//
	// CachePolicyConfig is a required field
	CachePolicyConfig *CachePolicyConfig `locationName:"CachePolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCachePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCachePolicyInput"}
	if s.CachePolicyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CachePolicyConfig"))
	}
	if s.CachePolicyConfig != nil {
		if err := s.CachePolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("CachePolicyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCachePolicyConfig sets the CachePolicyConfig field's value.
func (s *CreateCachePolicyInput) SetCachePolicyConfig(v *CachePolicyConfig) *CreateCachePolicyInput {
	s.CachePolicyConfig = v
	return s
}

type CreateCachePolicyOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicy"`

	// A cache policy.
	CachePolicy *CachePolicy `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the cache policy just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachePolicyOutput) GoString() string {
	return s.String()
}

// SetCachePolicy sets the CachePolicy field's value.
func (s *CreateCachePolicyOutput) SetCachePolicy(v *CachePolicy) *CreateCachePolicyOutput {
	s.CachePolicy = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateCachePolicyOutput) SetETag(v string) *CreateCachePolicyOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateCachePolicyOutput) SetLocation(v string) *CreateCachePolicyOutput {
	s.Location = &v
	return s
}

// The request to create a new origin access identity (OAI). An origin access
// identity is a special CloudFront user that you can associate with Amazon
// S3 origins, so that you can secure all or just some of your Amazon S3 content.
// For more information, see Restricting Access to Amazon S3 Content by Using
// an Origin Access Identity (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html)
// in the Amazon CloudFront Developer Guide.
type CreateCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"CreateCloudFrontOriginAccessIdentityRequest" type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The current configuration information for the identity.
	//
	// CloudFrontOriginAccessIdentityConfig is a required field
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `locationName:"CloudFrontOriginAccessIdentityConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudFrontOriginAccessIdentityInput"}
	if s.CloudFrontOriginAccessIdentityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudFrontOriginAccessIdentityConfig"))
	}
	if s.CloudFrontOriginAccessIdentityConfig != nil {
		if err := s.CloudFrontOriginAccessIdentityConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudFrontOriginAccessIdentityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *CreateCloudFrontOriginAccessIdentityInput) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *CreateCloudFrontOriginAccessIdentityInput {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// The returned result of the corresponding request.
type CreateCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the origin access identity created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new origin access identity just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentity sets the CloudFrontOriginAccessIdentity field's value.
func (s *CreateCloudFrontOriginAccessIdentityOutput) SetCloudFrontOriginAccessIdentity(v *OriginAccessIdentity) *CreateCloudFrontOriginAccessIdentityOutput {
	s.CloudFrontOriginAccessIdentity = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateCloudFrontOriginAccessIdentityOutput) SetETag(v string) *CreateCloudFrontOriginAccessIdentityOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateCloudFrontOriginAccessIdentityOutput) SetLocation(v string) *CreateCloudFrontOriginAccessIdentityOutput {
	s.Location = &v
	return s
}

// The request to create a new distribution.
type CreateDistributionInput struct {
	_ struct{} `locationName:"CreateDistributionRequest" type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `locationName:"DistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDistributionInput"}
	if s.DistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfig"))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *CreateDistributionInput) SetDistributionConfig(v *DistributionConfig) *CreateDistributionInput {
	s.DistributionConfig = v
	return s
}

// The returned result of the corresponding request.
type CreateDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new distribution resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *CreateDistributionOutput) SetDistribution(v *Distribution) *CreateDistributionOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateDistributionOutput) SetETag(v string) *CreateDistributionOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateDistributionOutput) SetLocation(v string) *CreateDistributionOutput {
	s.Location = &v
	return s
}

// The request to create a new distribution with tags.
type CreateDistributionWithTagsInput struct {
	_ struct{} `locationName:"CreateDistributionWithTagsRequest" type:"structure" payload:"DistributionConfigWithTags"`

	// The distribution's configuration information.
	//
	// DistributionConfigWithTags is a required field
	DistributionConfigWithTags *DistributionConfigWithTags `locationName:"DistributionConfigWithTags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateDistributionWithTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionWithTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionWithTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDistributionWithTagsInput"}
	if s.DistributionConfigWithTags == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfigWithTags"))
	}
	if s.DistributionConfigWithTags != nil {
		if err := s.DistributionConfigWithTags.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfigWithTags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfigWithTags sets the DistributionConfigWithTags field's value.
func (s *CreateDistributionWithTagsInput) SetDistributionConfigWithTags(v *DistributionConfigWithTags) *CreateDistributionWithTagsInput {
	s.DistributionConfigWithTags = v
	return s
}

// The returned result of the corresponding request.
type CreateDistributionWithTagsOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new distribution resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateDistributionWithTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionWithTagsOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *CreateDistributionWithTagsOutput) SetDistribution(v *Distribution) *CreateDistributionWithTagsOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateDistributionWithTagsOutput) SetETag(v string) *CreateDistributionWithTagsOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateDistributionWithTagsOutput) SetLocation(v string) *CreateDistributionWithTagsOutput {
	s.Location = &v
	return s
}

type CreateFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"CreateFieldLevelEncryptionConfigRequest" type:"structure" payload:"FieldLevelEncryptionConfig"`

	// The request to create a new field-level encryption configuration.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `locationName:"FieldLevelEncryptionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFieldLevelEncryptionConfigInput"}
	if s.FieldLevelEncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionConfig"))
	}
	if s.FieldLevelEncryptionConfig != nil {
		if err := s.FieldLevelEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *CreateFieldLevelEncryptionConfigInput) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *CreateFieldLevelEncryptionConfigInput {
	s.FieldLevelEncryptionConfig = v
	return s
}

type CreateFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Returned when you create a new field-level encryption configuration.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`

	// The fully qualified URI of the new configuration resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateFieldLevelEncryptionConfigOutput) SetETag(v string) *CreateFieldLevelEncryptionConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryption sets the FieldLevelEncryption field's value.
func (s *CreateFieldLevelEncryptionConfigOutput) SetFieldLevelEncryption(v *FieldLevelEncryption) *CreateFieldLevelEncryptionConfigOutput {
	s.FieldLevelEncryption = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateFieldLevelEncryptionConfigOutput) SetLocation(v string) *CreateFieldLevelEncryptionConfigOutput {
	s.Location = &v
	return s
}

type CreateFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"CreateFieldLevelEncryptionProfileRequest" type:"structure" payload:"FieldLevelEncryptionProfileConfig"`

	// The request to create a field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `locationName:"FieldLevelEncryptionProfileConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFieldLevelEncryptionProfileInput"}
	if s.FieldLevelEncryptionProfileConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionProfileConfig"))
	}
	if s.FieldLevelEncryptionProfileConfig != nil {
		if err := s.FieldLevelEncryptionProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *CreateFieldLevelEncryptionProfileInput) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *CreateFieldLevelEncryptionProfileInput {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

type CreateFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfile"`

	// The current version of the field level encryption profile. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Returned when you create a new field-level encryption profile.
	FieldLevelEncryptionProfile *FieldLevelEncryptionProfile `type:"structure"`

	// The fully qualified URI of the new profile resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateFieldLevelEncryptionProfileOutput) SetETag(v string) *CreateFieldLevelEncryptionProfileOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfile sets the FieldLevelEncryptionProfile field's value.
func (s *CreateFieldLevelEncryptionProfileOutput) SetFieldLevelEncryptionProfile(v *FieldLevelEncryptionProfile) *CreateFieldLevelEncryptionProfileOutput {
	s.FieldLevelEncryptionProfile = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateFieldLevelEncryptionProfileOutput) SetLocation(v string) *CreateFieldLevelEncryptionProfileOutput {
	s.Location = &v
	return s
}

// The request to create an invalidation.
type CreateInvalidationInput struct {
	_ struct{} `locationName:"CreateInvalidationRequest" type:"structure" payload:"InvalidationBatch"`

	// The distribution's id.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// The batch information for the invalidation.
	//
	// InvalidationBatch is a required field
	InvalidationBatch *InvalidationBatch `locationName:"InvalidationBatch" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateInvalidationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvalidationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInvalidationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInvalidationInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}
	if s.InvalidationBatch == nil {
		invalidParams.Add(request.NewErrParamRequired("InvalidationBatch"))
	}
	if s.InvalidationBatch != nil {
		if err := s.InvalidationBatch.Validate(); err != nil {
			invalidParams.AddNested("InvalidationBatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *CreateInvalidationInput) SetDistributionId(v string) *CreateInvalidationInput {
	s.DistributionId = &v
	return s
}

// SetInvalidationBatch sets the InvalidationBatch field's value.
func (s *CreateInvalidationInput) SetInvalidationBatch(v *InvalidationBatch) *CreateInvalidationInput {
	s.InvalidationBatch = v
	return s
}

// The returned result of the corresponding request.
type CreateInvalidationOutput struct {
	_ struct{} `type:"structure" payload:"Invalidation"`

	// The invalidation's information.
	Invalidation *Invalidation `type:"structure"`

	// The fully qualified URI of the distribution and invalidation batch request,
	// including the Invalidation ID.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateInvalidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvalidationOutput) GoString() string {
	return s.String()
}

// SetInvalidation sets the Invalidation field's value.
func (s *CreateInvalidationOutput) SetInvalidation(v *Invalidation) *CreateInvalidationOutput {
	s.Invalidation = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateInvalidationOutput) SetLocation(v string) *CreateInvalidationOutput {
	s.Location = &v
	return s
}

type CreateKeyGroupInput struct {
	_ struct{} `locationName:"CreateKeyGroupRequest" type:"structure" payload:"KeyGroupConfig"`

	// A key group configuration.
	//
	// KeyGroupConfig is a required field
	KeyGroupConfig *KeyGroupConfig `locationName:"KeyGroupConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateKeyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyGroupInput"}
	if s.KeyGroupConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyGroupConfig"))
	}
	if s.KeyGroupConfig != nil {
		if err := s.KeyGroupConfig.Validate(); err != nil {
			invalidParams.AddNested("KeyGroupConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyGroupConfig sets the KeyGroupConfig field's value.
func (s *CreateKeyGroupInput) SetKeyGroupConfig(v *KeyGroupConfig) *CreateKeyGroupInput {
	s.KeyGroupConfig = v
	return s
}

type CreateKeyGroupOutput struct {
	_ struct{} `type:"structure" payload:"KeyGroup"`

	// The identifier for this version of the key group.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The key group that was just created.
	KeyGroup *KeyGroup `type:"structure"`

	// The URL of the key group.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateKeyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyGroupOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateKeyGroupOutput) SetETag(v string) *CreateKeyGroupOutput {
	s.ETag = &v
	return s
}

// SetKeyGroup sets the KeyGroup field's value.
func (s *CreateKeyGroupOutput) SetKeyGroup(v *KeyGroup) *CreateKeyGroupOutput {
	s.KeyGroup = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateKeyGroupOutput) SetLocation(v string) *CreateKeyGroupOutput {
	s.Location = &v
	return s
}

type CreateMonitoringSubscriptionInput struct {
	_ struct{} `locationName:"CreateMonitoringSubscriptionRequest" type:"structure" payload:"MonitoringSubscription"`

	// The ID of the distribution that you are enabling metrics for.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// A monitoring subscription. This structure contains information about whether
	// additional CloudWatch metrics are enabled for a given CloudFront distribution.
	//
	// MonitoringSubscription is a required field
	MonitoringSubscription *MonitoringSubscription `locationName:"MonitoringSubscription" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateMonitoringSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMonitoringSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitoringSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMonitoringSubscriptionInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}
	if s.MonitoringSubscription == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitoringSubscription"))
	}
	if s.MonitoringSubscription != nil {
		if err := s.MonitoringSubscription.Validate(); err != nil {
			invalidParams.AddNested("MonitoringSubscription", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *CreateMonitoringSubscriptionInput) SetDistributionId(v string) *CreateMonitoringSubscriptionInput {
	s.DistributionId = &v
	return s
}

// SetMonitoringSubscription sets the MonitoringSubscription field's value.
func (s *CreateMonitoringSubscriptionInput) SetMonitoringSubscription(v *MonitoringSubscription) *CreateMonitoringSubscriptionInput {
	s.MonitoringSubscription = v
	return s
}

type CreateMonitoringSubscriptionOutput struct {
	_ struct{} `type:"structure" payload:"MonitoringSubscription"`

	// A monitoring subscription. This structure contains information about whether
	// additional CloudWatch metrics are enabled for a given CloudFront distribution.
	MonitoringSubscription *MonitoringSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateMonitoringSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMonitoringSubscriptionOutput) GoString() string {
	return s.String()
}

// SetMonitoringSubscription sets the MonitoringSubscription field's value.
func (s *CreateMonitoringSubscriptionOutput) SetMonitoringSubscription(v *MonitoringSubscription) *CreateMonitoringSubscriptionOutput {
	s.MonitoringSubscription = v
	return s
}

type CreateOriginRequestPolicyInput struct {
	_ struct{} `locationName:"CreateOriginRequestPolicyRequest" type:"structure" payload:"OriginRequestPolicyConfig"`

	// An origin request policy configuration.
	//
	// OriginRequestPolicyConfig is a required field
	OriginRequestPolicyConfig *OriginRequestPolicyConfig `locationName:"OriginRequestPolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOriginRequestPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOriginRequestPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOriginRequestPolicyInput"}
	if s.OriginRequestPolicyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginRequestPolicyConfig"))
	}
	if s.OriginRequestPolicyConfig != nil {
		if err := s.OriginRequestPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("OriginRequestPolicyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginRequestPolicyConfig sets the OriginRequestPolicyConfig field's value.
func (s *CreateOriginRequestPolicyInput) SetOriginRequestPolicyConfig(v *OriginRequestPolicyConfig) *CreateOriginRequestPolicyInput {
	s.OriginRequestPolicyConfig = v
	return s
}

type CreateOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicy"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the origin request policy just created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// An origin request policy.
	OriginRequestPolicy *OriginRequestPolicy `type:"structure"`
}

// String returns the string representation
func (s CreateOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOriginRequestPolicyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateOriginRequestPolicyOutput) SetETag(v string) *CreateOriginRequestPolicyOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateOriginRequestPolicyOutput) SetLocation(v string) *CreateOriginRequestPolicyOutput {
	s.Location = &v
	return s
}

// SetOriginRequestPolicy sets the OriginRequestPolicy field's value.
func (s *CreateOriginRequestPolicyOutput) SetOriginRequestPolicy(v *OriginRequestPolicy) *CreateOriginRequestPolicyOutput {
	s.OriginRequestPolicy = v
	return s
}

type CreatePublicKeyInput struct {
	_ struct{} `locationName:"CreatePublicKeyRequest" type:"structure" payload:"PublicKeyConfig"`

	// A CloudFront public key configuration.
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `locationName:"PublicKeyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreatePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicKeyInput"}
	if s.PublicKeyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyConfig"))
	}
	if s.PublicKeyConfig != nil {
		if err := s.PublicKeyConfig.Validate(); err != nil {
			invalidParams.AddNested("PublicKeyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *CreatePublicKeyInput) SetPublicKeyConfig(v *PublicKeyConfig) *CreatePublicKeyInput {
	s.PublicKeyConfig = v
	return s
}

type CreatePublicKeyOutput struct {
	_ struct{} `type:"structure" payload:"PublicKey"`

	// The identifier for this version of the public key.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The URL of the public key.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The public key.
	PublicKey *PublicKey `type:"structure"`
}

// String returns the string representation
func (s CreatePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreatePublicKeyOutput) SetETag(v string) *CreatePublicKeyOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreatePublicKeyOutput) SetLocation(v string) *CreatePublicKeyOutput {
	s.Location = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *CreatePublicKeyOutput) SetPublicKey(v *PublicKey) *CreatePublicKeyOutput {
	s.PublicKey = v
	return s
}

type CreateRealtimeLogConfigInput struct {
	_ struct{} `locationName:"CreateRealtimeLogConfigRequest" type:"structure" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// Contains information about the Amazon Kinesis data stream where you are sending
	// real-time log data.
	//
	// EndPoints is a required field
	EndPoints []*EndPoint `type:"list" required:"true"`

	// A list of fields to include in each real-time log record.
	//
	// For more information about fields, see Real-time log configuration fields
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
	// in the Amazon CloudFront Developer Guide.
	//
	// Fields is a required field
	Fields []*string `locationNameList:"Field" type:"list" required:"true"`

	// A unique name to identify this real-time log configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The sampling rate for this real-time log configuration. The sampling rate
	// determines the percentage of viewer requests that are represented in the
	// real-time log data. You must provide an integer between 1 and 100, inclusive.
	//
	// SamplingRate is a required field
	SamplingRate *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateRealtimeLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRealtimeLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRealtimeLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRealtimeLogConfigInput"}
	if s.EndPoints == nil {
		invalidParams.Add(request.NewErrParamRequired("EndPoints"))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SamplingRate == nil {
		invalidParams.Add(request.NewErrParamRequired("SamplingRate"))
	}
	if s.EndPoints != nil {
		for i, v := range s.EndPoints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EndPoints", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndPoints sets the EndPoints field's value.
func (s *CreateRealtimeLogConfigInput) SetEndPoints(v []*EndPoint) *CreateRealtimeLogConfigInput {
	s.EndPoints = v
	return s
}

// SetFields sets the Fields field's value.
func (s *CreateRealtimeLogConfigInput) SetFields(v []*string) *CreateRealtimeLogConfigInput {
	s.Fields = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRealtimeLogConfigInput) SetName(v string) *CreateRealtimeLogConfigInput {
	s.Name = &v
	return s
}

// SetSamplingRate sets the SamplingRate field's value.
func (s *CreateRealtimeLogConfigInput) SetSamplingRate(v int64) *CreateRealtimeLogConfigInput {
	s.SamplingRate = &v
	return s
}

type CreateRealtimeLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A real-time log configuration.
	RealtimeLogConfig *RealtimeLogConfig `type:"structure"`
}

// String returns the string representation
func (s CreateRealtimeLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRealtimeLogConfigOutput) GoString() string {
	return s.String()
}

// SetRealtimeLogConfig sets the RealtimeLogConfig field's value.
func (s *CreateRealtimeLogConfigOutput) SetRealtimeLogConfig(v *RealtimeLogConfig) *CreateRealtimeLogConfigOutput {
	s.RealtimeLogConfig = v
	return s
}

// The request to create a new streaming distribution.
type CreateStreamingDistributionInput struct {
	_ struct{} `locationName:"CreateStreamingDistributionRequest" type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingDistributionInput"}
	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *CreateStreamingDistributionInput) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *CreateStreamingDistributionInput {
	s.StreamingDistributionConfig = v
	return s
}

// The returned result of the corresponding request.
type CreateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new streaming distribution resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s CreateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateStreamingDistributionOutput) SetETag(v string) *CreateStreamingDistributionOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateStreamingDistributionOutput) SetLocation(v string) *CreateStreamingDistributionOutput {
	s.Location = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *CreateStreamingDistributionOutput) SetStreamingDistribution(v *StreamingDistribution) *CreateStreamingDistributionOutput {
	s.StreamingDistribution = v
	return s
}

// The request to create a new streaming distribution with tags.
type CreateStreamingDistributionWithTagsInput struct {
	_ struct{} `locationName:"CreateStreamingDistributionWithTagsRequest" type:"structure" payload:"StreamingDistributionConfigWithTags"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfigWithTags is a required field
	StreamingDistributionConfigWithTags *StreamingDistributionConfigWithTags `locationName:"StreamingDistributionConfigWithTags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateStreamingDistributionWithTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionWithTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingDistributionWithTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingDistributionWithTagsInput"}
	if s.StreamingDistributionConfigWithTags == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfigWithTags"))
	}
	if s.StreamingDistributionConfigWithTags != nil {
		if err := s.StreamingDistributionConfigWithTags.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfigWithTags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingDistributionConfigWithTags sets the StreamingDistributionConfigWithTags field's value.
func (s *CreateStreamingDistributionWithTagsInput) SetStreamingDistributionConfigWithTags(v *StreamingDistributionConfigWithTags) *CreateStreamingDistributionWithTagsInput {
	s.StreamingDistributionConfigWithTags = v
	return s
}

// The returned result of the corresponding request.
type CreateStreamingDistributionWithTagsOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new streaming distribution resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s CreateStreamingDistributionWithTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionWithTagsOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateStreamingDistributionWithTagsOutput) SetETag(v string) *CreateStreamingDistributionWithTagsOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateStreamingDistributionWithTagsOutput) SetLocation(v string) *CreateStreamingDistributionWithTagsOutput {
	s.Location = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *CreateStreamingDistributionWithTagsOutput) SetStreamingDistribution(v *StreamingDistribution) *CreateStreamingDistributionWithTagsOutput {
	s.StreamingDistribution = v
	return s
}

// A complex type that controls:
//
//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
//    with custom error messages before returning the response to the viewer.
//
//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see Customizing Error Responses
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
// in the Amazon CloudFront Developer Guide.
type CustomErrorResponse struct {
	_ struct{} `type:"structure"`

	// The minimum amount of time, in seconds, that you want CloudFront to cache
	// the HTTP status code specified in ErrorCode. When this time period has elapsed,
	// CloudFront queries your origin to see whether the problem that caused the
	// error has been resolved and the requested object is now available.
	//
	// For more information, see Customizing Error Responses (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
	// in the Amazon CloudFront Developer Guide.
	ErrorCachingMinTTL *int64 `type:"long"`

	// The HTTP status code for which you want to specify a custom error page and/or
	// a caching duration.
	//
	// ErrorCode is a required field
	ErrorCode *int64 `type:"integer" required:"true"`

	// The HTTP status code that you want CloudFront to return to the viewer along
	// with the custom error page. There are a variety of reasons that you might
	// want CloudFront to return a status code different from the status code that
	// your origin returned to CloudFront, for example:
	//
	//    * Some Internet devices (some firewalls and corporate proxies, for example)
	//    intercept HTTP 4xx and 5xx and prevent the response from being returned
	//    to the viewer. If you substitute 200, the response typically won't be
	//    intercepted.
	//
	//    * If you don't care about distinguishing among different client errors
	//    or server errors, you can specify 400 or 500 as the ResponseCode for all
	//    4xx or 5xx errors.
	//
	//    * You might want to return a 200 status code (OK) and static website so
	//    your customers don't know that your website is down.
	//
	// If you specify a value for ResponseCode, you must also specify a value for
	// ResponsePagePath.
	ResponseCode *string `type:"string"`

	// The path to the custom error page that you want CloudFront to return to a
	// viewer when your origin returns the HTTP status code specified by ErrorCode,
	// for example, /4xx-errors/403-forbidden.html. If you want to store your objects
	// and your custom error pages in different locations, your distribution must
	// include a cache behavior for which the following is true:
	//
	//    * The value of PathPattern matches the path to your custom error messages.
	//    For example, suppose you saved custom error pages for 4xx errors in an
	//    Amazon S3 bucket in a directory named /4xx-errors. Your distribution must
	//    include a cache behavior for which the path pattern routes requests for
	//    your custom error pages to that location, for example, /4xx-errors/*.
	//
	//    * The value of TargetOriginId specifies the value of the ID element for
	//    the origin that contains your custom error pages.
	//
	// If you specify a value for ResponsePagePath, you must also specify a value
	// for ResponseCode.
	//
	// We recommend that you store custom error pages in an Amazon S3 bucket. If
	// you store custom error pages on an HTTP server and the server starts to return
	// 5xx errors, CloudFront can't get the files that you want to return to viewers
	// because the origin server is unavailable.
	ResponsePagePath *string `type:"string"`
}

// String returns the string representation
func (s CustomErrorResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorResponse) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomErrorResponse) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomErrorResponse"}
	if s.ErrorCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ErrorCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorCachingMinTTL sets the ErrorCachingMinTTL field's value.
func (s *CustomErrorResponse) SetErrorCachingMinTTL(v int64) *CustomErrorResponse {
	s.ErrorCachingMinTTL = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CustomErrorResponse) SetErrorCode(v int64) *CustomErrorResponse {
	s.ErrorCode = &v
	return s
}

// SetResponseCode sets the ResponseCode field's value.
func (s *CustomErrorResponse) SetResponseCode(v string) *CustomErrorResponse {
	s.ResponseCode = &v
	return s
}

// SetResponsePagePath sets the ResponsePagePath field's value.
func (s *CustomErrorResponse) SetResponsePagePath(v string) *CustomErrorResponse {
	s.ResponsePagePath = &v
	return s
}

// A complex type that controls:
//
//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
//    with custom error messages before returning the response to the viewer.
//
//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see Customizing Error Responses
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
// in the Amazon CloudFront Developer Guide.
type CustomErrorResponses struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a CustomErrorResponse element for each HTTP
	// status code for which you want to specify a custom error page and/or a caching
	// duration.
	Items []*CustomErrorResponse `locationNameList:"CustomErrorResponse" type:"list"`

	// The number of HTTP status codes for which you want to specify a custom error
	// page and/or a caching duration. If Quantity is 0, you can omit Items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomErrorResponses) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorResponses) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomErrorResponses) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomErrorResponses"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CustomErrorResponses) SetItems(v []*CustomErrorResponse) *CustomErrorResponses {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CustomErrorResponses) SetQuantity(v int64) *CustomErrorResponses {
	s.Quantity = &v
	return s
}

// A complex type that contains the list of Custom Headers for each origin.
type CustomHeaders struct {
	_ struct{} `type:"structure"`

	// Optional: A list that contains one OriginCustomHeader element for each custom
	// header that you want CloudFront to forward to the origin. If Quantity is
	// 0, omit Items.
	Items []*OriginCustomHeader `locationNameList:"OriginCustomHeader" type:"list"`

	// The number of custom headers, if any, for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomHeaders) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHeaders) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomHeaders) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomHeaders"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CustomHeaders) SetItems(v []*OriginCustomHeader) *CustomHeaders {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CustomHeaders) SetQuantity(v int64) *CustomHeaders {
	s.Quantity = &v
	return s
}

// A custom origin. A custom origin is any origin that is not an Amazon S3 bucket,
// with one exception. An Amazon S3 bucket that is configured with static website
// hosting (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)
// is a custom origin.
type CustomOriginConfig struct {
	_ struct{} `type:"structure"`

	// The HTTP port that CloudFront uses to connect to the origin. Specify the
	// HTTP port that the origin listens on.
	//
	// HTTPPort is a required field
	HTTPPort *int64 `type:"integer" required:"true"`

	// The HTTPS port that CloudFront uses to connect to the origin. Specify the
	// HTTPS port that the origin listens on.
	//
	// HTTPSPort is a required field
	HTTPSPort *int64 `type:"integer" required:"true"`

	// Specifies how long, in seconds, CloudFront persists its connection to the
	// origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the
	// default (if you don’t specify otherwise) is 5 seconds.
	//
	// For more information, see Origin Keep-alive Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout)
	// in the Amazon CloudFront Developer Guide.
	OriginKeepaliveTimeout *int64 `type:"integer"`

	// Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to
	// the origin. Valid values are:
	//
	//    * http-only – CloudFront always uses HTTP to connect to the origin.
	//
	//    * match-viewer – CloudFront connects to the origin using the same protocol
	//    that the viewer used to connect to CloudFront.
	//
	//    * https-only – CloudFront always uses HTTPS to connect to the origin.
	//
	// OriginProtocolPolicy is a required field
	OriginProtocolPolicy *string `type:"string" required:"true" enum:"OriginProtocolPolicy"`

	// Specifies how long, in seconds, CloudFront waits for a response from the
	// origin. This is also known as the origin response timeout. The minimum timeout
	// is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
	// otherwise) is 30 seconds.
	//
	// For more information, see Origin Response Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout)
	// in the Amazon CloudFront Developer Guide.
	OriginReadTimeout *int64 `type:"integer"`

	// Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting
	// to your origin over HTTPS. Valid values include SSLv3, TLSv1, TLSv1.1, and
	// TLSv1.2.
	//
	// For more information, see Minimum Origin SSL Protocol (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols)
	// in the Amazon CloudFront Developer Guide.
	OriginSslProtocols *OriginSslProtocols `type:"structure"`
}

// String returns the string representation
func (s CustomOriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomOriginConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomOriginConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomOriginConfig"}
	if s.HTTPPort == nil {
		invalidParams.Add(request.NewErrParamRequired("HTTPPort"))
	}
	if s.HTTPSPort == nil {
		invalidParams.Add(request.NewErrParamRequired("HTTPSPort"))
	}
	if s.OriginProtocolPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginProtocolPolicy"))
	}
	if s.OriginSslProtocols != nil {
		if err := s.OriginSslProtocols.Validate(); err != nil {
			invalidParams.AddNested("OriginSslProtocols", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHTTPPort sets the HTTPPort field's value.
func (s *CustomOriginConfig) SetHTTPPort(v int64) *CustomOriginConfig {
	s.HTTPPort = &v
	return s
}

// SetHTTPSPort sets the HTTPSPort field's value.
func (s *CustomOriginConfig) SetHTTPSPort(v int64) *CustomOriginConfig {
	s.HTTPSPort = &v
	return s
}

// SetOriginKeepaliveTimeout sets the OriginKeepaliveTimeout field's value.
func (s *CustomOriginConfig) SetOriginKeepaliveTimeout(v int64) *CustomOriginConfig {
	s.OriginKeepaliveTimeout = &v
	return s
}

// SetOriginProtocolPolicy sets the OriginProtocolPolicy field's value.
func (s *CustomOriginConfig) SetOriginProtocolPolicy(v string) *CustomOriginConfig {
	s.OriginProtocolPolicy = &v
	return s
}

// SetOriginReadTimeout sets the OriginReadTimeout field's value.
func (s *CustomOriginConfig) SetOriginReadTimeout(v int64) *CustomOriginConfig {
	s.OriginReadTimeout = &v
	return s
}

// SetOriginSslProtocols sets the OriginSslProtocols field's value.
func (s *CustomOriginConfig) SetOriginSslProtocols(v *OriginSslProtocols) *CustomOriginConfig {
	s.OriginSslProtocols = v
	return s
}

// A complex type that describes the default cache behavior if you don’t specify
// a CacheBehavior element or if request URLs don’t match any of the values
// of PathPattern in CacheBehavior elements. You must create exactly one default
// cache behavior.
type DefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//    * CloudFront forwards only GET and HEAD requests.
	//
	//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
	//
	//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	//    requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon
	// S3 bucket or to your custom origin so users can't perform operations that
	// you don't want them to. For example, you might not want users to have permissions
	// to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// The unique identifier of the cache policy that is attached to the default
	// cache behavior. For more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	CachePolicyId *string `type:"string"`

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more information,
	// see Serving Compressed Files (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html)
	// in the Amazon CloudFront Developer Guide.
	Compress *bool `type:"boolean"`

	// This field is deprecated. We recommend that you use the DefaultTTL field
	// in a cache policy instead of this field. For more information, see Creating
	// cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin does not add HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Deprecated: DefaultTTL has been deprecated
	DefaultTTL *int64 `deprecated:"true" type:"long"`

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for the default
	// cache behavior.
	FieldLevelEncryptionId *string `type:"string"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field. For more information, see Working
	// with policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to include values in the cache key, use a cache policy. For more
	// information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send values to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see Creating origin
	// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// or Using the managed origin request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// A complex type that specifies how CloudFront handles query strings, cookies,
	// and HTTP headers.
	//
	// Deprecated: ForwardedValues has been deprecated
	ForwardedValues *ForwardedValues `deprecated:"true" type:"structure"`

	// A complex type that contains zero or more Lambda function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations `type:"structure"`

	// This field is deprecated. We recommend that you use the MaxTTL field in a
	// cache policy instead of this field. For more information, see Creating cache
	// policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Deprecated: MaxTTL has been deprecated
	MaxTTL *int64 `deprecated:"true" type:"long"`

	// This field is deprecated. We recommend that you use the MinTTL field in a
	// cache policy instead of this field. For more information, see Creating cache
	// policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// or Using the managed cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see Managing How Long
	// Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers, if you specify 1 for Quantity and
	// * for Name).
	//
	// Deprecated: MinTTL has been deprecated
	MinTTL *int64 `deprecated:"true" type:"long"`

	// The unique identifier of the origin request policy that is attached to the
	// default cache behavior. For more information, see Creating origin request
	// policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// or Using the managed origin request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html)
	// in the Amazon CloudFront Developer Guide.
	OriginRequestPolicyId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the real-time log configuration that is
	// attached to this cache behavior. For more information, see Real-time logs
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html)
	// in the Amazon CloudFront Developer Guide.
	RealtimeLogConfigArn *string `type:"string"`

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false. If you specify true for SmoothStreaming,
	// you can still distribute other content using this cache behavior if the content
	// matches the value of PathPattern.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when they use the default cache behavior.
	//
	// TargetOriginId is a required field
	TargetOriginId *string `type:"string" required:"true"`

	// A list of key groups that CloudFront can use to validate signed URLs or signed
	// cookies.
	//
	// When a cache behavior contains trusted key groups, CloudFront requires signed
	// URLs or signed cookies for all requests that match the cache behavior. The
	// URLs or cookies must be signed with a private key whose corresponding public
	// key is in the key group. The signed URL or cookie contains information about
	// which public key CloudFront should use to verify the signature. For more
	// information, see Serving private content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	TrustedKeyGroups *TrustedKeyGroups `type:"structure"`

	//
	// We recommend using TrustedKeyGroups instead of TrustedSigners.
	//
	// A list of AWS account IDs whose public keys CloudFront can use to validate
	// signed URLs or signed cookies.
	//
	// When a cache behavior contains trusted signers, CloudFront requires signed
	// URLs or signed cookies for all requests that match the cache behavior. The
	// URLs or cookies must be signed with the private key of a CloudFront key pair
	// in a trusted signer’s AWS account. The signed URL or cookie contains information
	// about which public key CloudFront should use to verify the signature. For
	// more information, see Serving private content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	TrustedSigners *TrustedSigners `type:"structure"`

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern.
	// You can specify the following options:
	//
	//    * allow-all: Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
	//    an HTTP status code of 301 (Moved Permanently) to the viewer along with
	//    the HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//    * https-only: If a viewer sends an HTTP request, CloudFront returns an
	//    HTTP status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see Requiring HTTPS
	// Between Viewers and CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched
	// from the origin using HTTPS is never to use any other protocol to fetch the
	// object. If you have recently changed from HTTP to HTTPS, we recommend that
	// you clear your objects’ cache because cached objects are protocol agnostic.
	// That means that an edge location will return an object from the cache regardless
	// of whether the current request protocol matches the protocol used previously.
	// For more information, see Managing Cache Expiration (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerProtocolPolicy is a required field
	ViewerProtocolPolicy *string `type:"string" required:"true" enum:"ViewerProtocolPolicy"`
}

// String returns the string representation
func (s DefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultCacheBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultCacheBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefaultCacheBehavior"}
	if s.TargetOriginId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOriginId"))
	}
	if s.ViewerProtocolPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerProtocolPolicy"))
	}
	if s.AllowedMethods != nil {
		if err := s.AllowedMethods.Validate(); err != nil {
			invalidParams.AddNested("AllowedMethods", err.(request.ErrInvalidParams))
		}
	}
	if s.ForwardedValues != nil {
		if err := s.ForwardedValues.Validate(); err != nil {
			invalidParams.AddNested("ForwardedValues", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAssociations != nil {
		if err := s.LambdaFunctionAssociations.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAssociations", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedKeyGroups != nil {
		if err := s.TrustedKeyGroups.Validate(); err != nil {
			invalidParams.AddNested("TrustedKeyGroups", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *DefaultCacheBehavior) SetAllowedMethods(v *AllowedMethods) *DefaultCacheBehavior {
	s.AllowedMethods = v
	return s
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *DefaultCacheBehavior) SetCachePolicyId(v string) *DefaultCacheBehavior {
	s.CachePolicyId = &v
	return s
}

// SetCompress sets the Compress field's value.
func (s *DefaultCacheBehavior) SetCompress(v bool) *DefaultCacheBehavior {
	s.Compress = &v
	return s
}

// SetDefaultTTL sets the DefaultTTL field's value.
func (s *DefaultCacheBehavior) SetDefaultTTL(v int64) *DefaultCacheBehavior {
	s.DefaultTTL = &v
	return s
}

// SetFieldLevelEncryptionId sets the FieldLevelEncryptionId field's value.
func (s *DefaultCacheBehavior) SetFieldLevelEncryptionId(v string) *DefaultCacheBehavior {
	s.FieldLevelEncryptionId = &v
	return s
}

// SetForwardedValues sets the ForwardedValues field's value.
func (s *DefaultCacheBehavior) SetForwardedValues(v *ForwardedValues) *DefaultCacheBehavior {
	s.ForwardedValues = v
	return s
}

// SetLambdaFunctionAssociations sets the LambdaFunctionAssociations field's value.
func (s *DefaultCacheBehavior) SetLambdaFunctionAssociations(v *LambdaFunctionAssociations) *DefaultCacheBehavior {
	s.LambdaFunctionAssociations = v
	return s
}

// SetMaxTTL sets the MaxTTL field's value.
func (s *DefaultCacheBehavior) SetMaxTTL(v int64) *DefaultCacheBehavior {
	s.MaxTTL = &v
	return s
}

// SetMinTTL sets the MinTTL field's value.
func (s *DefaultCacheBehavior) SetMinTTL(v int64) *DefaultCacheBehavior {
	s.MinTTL = &v
	return s
}

// SetOriginRequestPolicyId sets the OriginRequestPolicyId field's value.
func (s *DefaultCacheBehavior) SetOriginRequestPolicyId(v string) *DefaultCacheBehavior {
	s.OriginRequestPolicyId = &v
	return s
}

// SetRealtimeLogConfigArn sets the RealtimeLogConfigArn field's value.
func (s *DefaultCacheBehavior) SetRealtimeLogConfigArn(v string) *DefaultCacheBehavior {
	s.RealtimeLogConfigArn = &v
	return s
}

// SetSmoothStreaming sets the SmoothStreaming field's value.
func (s *DefaultCacheBehavior) SetSmoothStreaming(v bool) *DefaultCacheBehavior {
	s.SmoothStreaming = &v
	return s
}

// SetTargetOriginId sets the TargetOriginId field's value.
func (s *DefaultCacheBehavior) SetTargetOriginId(v string) *DefaultCacheBehavior {
	s.TargetOriginId = &v
	return s
}

// SetTrustedKeyGroups sets the TrustedKeyGroups field's value.
func (s *DefaultCacheBehavior) SetTrustedKeyGroups(v *TrustedKeyGroups) *DefaultCacheBehavior {
	s.TrustedKeyGroups = v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *DefaultCacheBehavior) SetTrustedSigners(v *TrustedSigners) *DefaultCacheBehavior {
	s.TrustedSigners = v
	return s
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *DefaultCacheBehavior) SetViewerProtocolPolicy(v string) *DefaultCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

type DeleteCachePolicyInput struct {
	_ struct{} `locationName:"DeleteCachePolicyRequest" type:"structure"`

	// The unique identifier for the cache policy that you are deleting. To get
	// the identifier, you can use ListCachePolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the cache policy that you are deleting. The version is the
	// cache policy’s ETag value, which you can get using ListCachePolicies, GetCachePolicy,
	// or GetCachePolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCachePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCachePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCachePolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteCachePolicyInput) SetId(v string) *DeleteCachePolicyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteCachePolicyInput) SetIfMatch(v string) *DeleteCachePolicyInput {
	s.IfMatch = &v
	return s
}

type DeleteCachePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCachePolicyOutput) GoString() string {
	return s.String()
}

// Deletes a origin access identity.
type DeleteCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"DeleteCloudFrontOriginAccessIdentityRequest" type:"structure"`

	// The origin access identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received from a previous GET or PUT request.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCloudFrontOriginAccessIdentityInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteCloudFrontOriginAccessIdentityInput) SetId(v string) *DeleteCloudFrontOriginAccessIdentityInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteCloudFrontOriginAccessIdentityInput) SetIfMatch(v string) *DeleteCloudFrontOriginAccessIdentityInput {
	s.IfMatch = &v
	return s
}

type DeleteCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// This action deletes a web distribution. To delete a web distribution using
// the CloudFront API, perform the following steps.
//
// To delete a web distribution using the CloudFront API:
//
// Disable the web distribution
//
// Submit a GET Distribution Config request to get the current configuration
// and the Etag header for the distribution.
//
// Update the XML document that was returned in the response to your GET Distribution
// Config request to change the value of Enabled to false.
//
// Submit a PUT Distribution Config request to update the configuration for
// your distribution. In the request body, include the XML document that you
// updated in Step 3. Set the value of the HTTP If-Match header to the value
// of the ETag header that CloudFront returned when you submitted the GET Distribution
// Config request in Step 2.
//
// Review the response to the PUT Distribution Config request to confirm that
// the distribution was successfully disabled.
//
// Submit a GET Distribution request to confirm that your changes have propagated.
// When propagation is complete, the value of Status is Deployed.
//
// Submit a DELETE Distribution request. Set the value of the HTTP If-Match
// header to the value of the ETag header that CloudFront returned when you
// submitted the GET Distribution Config request in Step 6.
//
// Review the response to your DELETE Distribution request to confirm that the
// distribution was successfully deleted.
//
// For information about deleting a distribution using the CloudFront console,
// see Deleting a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
// in the Amazon CloudFront Developer Guide.
type DeleteDistributionInput struct {
	_ struct{} `locationName:"DeleteDistributionRequest" type:"structure"`

	// The distribution ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when you disabled the distribution.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteDistributionInput) SetId(v string) *DeleteDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteDistributionInput) SetIfMatch(v string) *DeleteDistributionInput {
	s.IfMatch = &v
	return s
}

type DeleteDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionOutput) GoString() string {
	return s.String()
}

type DeleteFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"DeleteFieldLevelEncryptionConfigRequest" type:"structure"`

	// The ID of the configuration you want to delete from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the configuration
	// identity to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFieldLevelEncryptionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFieldLevelEncryptionConfigInput) SetId(v string) *DeleteFieldLevelEncryptionConfigInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteFieldLevelEncryptionConfigInput) SetIfMatch(v string) *DeleteFieldLevelEncryptionConfigInput {
	s.IfMatch = &v
	return s
}

type DeleteFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

type DeleteFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"DeleteFieldLevelEncryptionProfileRequest" type:"structure"`

	// Request the ID of the profile you want to delete from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the profile
	// to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFieldLevelEncryptionProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFieldLevelEncryptionProfileInput) SetId(v string) *DeleteFieldLevelEncryptionProfileInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteFieldLevelEncryptionProfileInput) SetIfMatch(v string) *DeleteFieldLevelEncryptionProfileInput {
	s.IfMatch = &v
	return s
}

type DeleteFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

type DeleteKeyGroupInput struct {
	_ struct{} `locationName:"DeleteKeyGroupRequest" type:"structure"`

	// The identifier of the key group that you are deleting. To get the identifier,
	// use ListKeyGroups.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the key group that you are deleting. The version is the key
	// group’s ETag value. To get the ETag, use GetKeyGroup or GetKeyGroupConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteKeyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteKeyGroupInput) SetId(v string) *DeleteKeyGroupInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteKeyGroupInput) SetIfMatch(v string) *DeleteKeyGroupInput {
	s.IfMatch = &v
	return s
}

type DeleteKeyGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteKeyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyGroupOutput) GoString() string {
	return s.String()
}

type DeleteMonitoringSubscriptionInput struct {
	_ struct{} `locationName:"DeleteMonitoringSubscriptionRequest" type:"structure"`

	// The ID of the distribution that you are disabling metrics for.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMonitoringSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMonitoringSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMonitoringSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMonitoringSubscriptionInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *DeleteMonitoringSubscriptionInput) SetDistributionId(v string) *DeleteMonitoringSubscriptionInput {
	s.DistributionId = &v
	return s
}

type DeleteMonitoringSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMonitoringSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMonitoringSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteOriginRequestPolicyInput struct {
	_ struct{} `locationName:"DeleteOriginRequestPolicyRequest" type:"structure"`

	// The unique identifier for the origin request policy that you are deleting.
	// To get the identifier, you can use ListOriginRequestPolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the origin request policy that you are deleting. The version
	// is the origin request policy’s ETag value, which you can get using ListOriginRequestPolicies,
	// GetOriginRequestPolicy, or GetOriginRequestPolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOriginRequestPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOriginRequestPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOriginRequestPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteOriginRequestPolicyInput) SetId(v string) *DeleteOriginRequestPolicyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteOriginRequestPolicyInput) SetIfMatch(v string) *DeleteOriginRequestPolicyInput {
	s.IfMatch = &v
	return s
}

type DeleteOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOriginRequestPolicyOutput) GoString() string {
	return s.String()
}

type DeletePublicKeyInput struct {
	_ struct{} `locationName:"DeletePublicKeyRequest" type:"structure"`

	// The ID of the public key you want to remove from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the public
	// key identity to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeletePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicKeyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeletePublicKeyInput) SetId(v string) *DeletePublicKeyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeletePublicKeyInput) SetIfMatch(v string) *DeletePublicKeyInput {
	s.IfMatch = &v
	return s
}

type DeletePublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicKeyOutput) GoString() string {
	return s.String()
}

type DeleteRealtimeLogConfigInput struct {
	_ struct{} `locationName:"DeleteRealtimeLogConfigRequest" type:"structure" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The Amazon Resource Name (ARN) of the real-time log configuration to delete.
	ARN *string `type:"string"`

	// The name of the real-time log configuration to delete.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DeleteRealtimeLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRealtimeLogConfigInput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DeleteRealtimeLogConfigInput) SetARN(v string) *DeleteRealtimeLogConfigInput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteRealtimeLogConfigInput) SetName(v string) *DeleteRealtimeLogConfigInput {
	s.Name = &v
	return s
}

type DeleteRealtimeLogConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRealtimeLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRealtimeLogConfigOutput) GoString() string {
	return s.String()
}

// The request to delete a streaming distribution.
type DeleteStreamingDistributionInput struct {
	_ struct{} `locationName:"DeleteStreamingDistributionRequest" type:"structure"`

	// The distribution ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when you disabled the streaming
	// distribution. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamingDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteStreamingDistributionInput) SetId(v string) *DeleteStreamingDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteStreamingDistributionInput) SetIfMatch(v string) *DeleteStreamingDistributionInput {
	s.IfMatch = &v
	return s
}

type DeleteStreamingDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamingDistributionOutput) GoString() string {
	return s.String()
}

// A distribution tells CloudFront where you want content to be delivered from,
// and the details about how to track and manage content delivery.
type Distribution struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// CloudFront automatically adds this field to the response if you’ve configured
	// a cache behavior in this distribution to serve private content using key
	// groups. This field contains a list of key groups and the public keys in each
	// key group that CloudFront can use to verify the signatures of signed URLs
	// or signed cookies.
	ActiveTrustedKeyGroups *ActiveTrustedKeyGroups `type:"structure"`

	//
	// We recommend using TrustedKeyGroups instead of TrustedSigners.
	//
	// CloudFront automatically adds this field to the response if you’ve configured
	// a cache behavior in this distribution to serve private content using trusted
	// signers. This field contains a list of AWS account IDs and the active CloudFront
	// key pairs in each account that CloudFront can use to verify the signatures
	// of signed URLs or signed cookies.
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure"`

	// AWS services in China customers must file for an Internet Content Provider
	// (ICP) recordal if they want to serve content publicly on an alternate domain
	// name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal
	// provides the ICP recordal status for CNAMEs associated with distributions.
	//
	// For more information about ICP recordals, see Signup, Accounts, and Credentials
	// (https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
	// in Getting Started with AWS services in China.
	AliasICPRecordals []*AliasICPRecordal `locationNameList:"AliasICPRecordal" type:"list"`

	// The current configuration information for the distribution. Send a GET request
	// to the /CloudFront API version/distribution ID/config resource.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The number of invalidation batches currently in progress.
	//
	// InProgressInvalidationBatches is a required field
	InProgressInvalidationBatches *int64 `type:"integer" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// This response element indicates the current status of the distribution. When
	// the status is Deployed, the distribution's information is fully propagated
	// to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Distribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Distribution) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Distribution) SetARN(v string) *Distribution {
	s.ARN = &v
	return s
}

// SetActiveTrustedKeyGroups sets the ActiveTrustedKeyGroups field's value.
func (s *Distribution) SetActiveTrustedKeyGroups(v *ActiveTrustedKeyGroups) *Distribution {
	s.ActiveTrustedKeyGroups = v
	return s
}

// SetActiveTrustedSigners sets the ActiveTrustedSigners field's value.
func (s *Distribution) SetActiveTrustedSigners(v *ActiveTrustedSigners) *Distribution {
	s.ActiveTrustedSigners = v
	return s
}

// SetAliasICPRecordals sets the AliasICPRecordals field's value.
func (s *Distribution) SetAliasICPRecordals(v []*AliasICPRecordal) *Distribution {
	s.AliasICPRecordals = v
	return s
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *Distribution) SetDistributionConfig(v *DistributionConfig) *Distribution {
	s.DistributionConfig = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *Distribution) SetDomainName(v string) *Distribution {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Distribution) SetId(v string) *Distribution {
	s.Id = &v
	return s
}

// SetInProgressInvalidationBatches sets the InProgressInvalidationBatches field's value.
func (s *Distribution) SetInProgressInvalidationBatches(v int64) *Distribution {
	s.InProgressInvalidationBatches = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Distribution) SetLastModifiedTime(v time.Time) *Distribution {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Distribution) SetStatus(v string) *Distribution {
	s.Status = &v
	return s
}

// A distribution configuration.
type DistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	Aliases *Aliases `type:"structure"`

	// A complex type that contains zero or more CacheBehavior elements.
	CacheBehaviors *CacheBehaviors `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// DistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request
	// to create a distribution, CloudFront returns a DistributionAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the distribution.
	//
	// If you don't want to specify a comment, include an empty Comment element.
	//
	// To delete an existing comment, update the distribution configuration and
	// include an empty Comment element.
	//
	// To add or change a comment, update the distribution configuration and specify
	// the new comment.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true" sensitive:"true"`

	// A complex type that controls the following:
	//
	//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
	//    with custom error messages before returning the response to the viewer.
	//
	//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
	//
	// For more information about custom error pages, see Customizing Error Responses
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
	// in the Amazon CloudFront Developer Guide.
	CustomErrorResponses *CustomErrorResponses `type:"structure"`

	// A complex type that describes the default cache behavior if you don't specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The object that you want CloudFront to request from your origin (for example,
	// index.html) when a viewer requests the root URL for your distribution (http://www.example.com)
	// instead of an object in your distribution (http://www.example.com/product-description.html).
	// Specifying a default root object avoids exposing the contents of your distribution.
	//
	// Specify only the object name, for example, index.html. Don't add a / before
	// the object name.
	//
	// If you don't want to specify a default root object when you create a distribution,
	// include an empty DefaultRootObject element.
	//
	// To delete the default root object from an existing distribution, update the
	// distribution configuration and include an empty DefaultRootObject element.
	//
	// To replace the default root object, update the distribution configuration
	// and specify the new object.
	//
	// For more information about the default root object, see Creating a Default
	// Root Object (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultRootObject *string `type:"string"`

	// From this field, you can enable or disable the selected distribution.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// (Optional) Specify the maximum HTTP version that you want viewers to use
	// to communicate with CloudFront. The default value for new web distributions
	// is http2. Viewers that don't support HTTP/2 automatically use an earlier
	// HTTP version.
	//
	// For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or
	// later, and must support Server Name Identification (SNI).
	//
	// In general, configuring CloudFront to communicate with viewers using HTTP/2
	// reduces latency. You can improve performance by optimizing for HTTP/2. For
	// more information, do an Internet search for "http/2 optimization."
	HttpVersion *string `type:"string" enum:"HttpVersion"`

	// If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address
	// for your distribution, specify true. If you specify false, CloudFront responds
	// to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
	// This allows viewers to submit a second request, for an IPv4 address for your
	// distribution.
	//
	// In general, you should enable IPv6 if you have users on IPv6 networks who
	// want to access your content. However, if you're using signed URLs or signed
	// cookies to restrict access to your content, and if you're using a custom
	// policy that includes the IpAddress parameter to restrict the IP addresses
	// that can access your content, don't enable IPv6. If you want to restrict
	// access to some content by IP address and not restrict access to other content
	// (or restrict access but not by IP address), you can create two distributions.
	// For more information, see Creating a Signed URL Using a Custom Policy (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you're using an Amazon Route 53 alias resource record set to route traffic
	// to your CloudFront distribution, you need to create a second alias resource
	// record set when both of the following are true:
	//
	//    * You enable IPv6 for the distribution
	//
	//    * You're using alternate domain names in the URLs for your objects
	//
	// For more information, see Routing Traffic to an Amazon CloudFront Web Distribution
	// by Using Your Domain Name (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// If you created a CNAME resource record set, either with Amazon Route 53 or
	// with another DNS service, you don't need to make any changes. A CNAME record
	// will route traffic to your distribution regardless of the IP address format
	// of the viewer request.
	IsIPV6Enabled *bool `type:"boolean"`

	// A complex type that controls whether access logs are written for the distribution.
	//
	// For more information about logging, see Access Logs (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html)
	// in the Amazon CloudFront Developer Guide.
	Logging *LoggingConfig `type:"structure"`

	// A complex type that contains information about origin groups for this distribution.
	OriginGroups *OriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	//
	// Origins is a required field
	Origins *Origins `type:"structure" required:"true"`

	// The price class that corresponds with the maximum price that you want to
	// pay for CloudFront service. If you specify PriceClass_All, CloudFront responds
	// to requests for your objects from all CloudFront edge locations.
	//
	// If you specify a price class other than PriceClass_All, CloudFront serves
	// your objects from the CloudFront edge location that has the lowest latency
	// among the edge locations in your price class. Viewers who are in or near
	// regions that are excluded from your specified price class may encounter slower
	// performance.
	//
	// For more information about price classes, see Choosing the Price Class for
	// a CloudFront Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html)
	// in the Amazon CloudFront Developer Guide. For information about CloudFront
	// pricing, including how price classes (such as Price Class 100) map to CloudFront
	// regions, see Amazon CloudFront Pricing (http://aws.amazon.com/cloudfront/pricing/).
	PriceClass *string `type:"string" enum:"PriceClass"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	Restrictions *Restrictions `type:"structure"`

	// A complex type that determines the distribution’s SSL/TLS configuration
	// for communicating with viewers.
	ViewerCertificate *ViewerCertificate `type:"structure"`

	// A unique identifier that specifies the AWS WAF web ACL, if any, to associate
	// with this distribution. To specify a web ACL created using the latest version
	// of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
	// To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
	// 473e64fd-f30b-4765-81a0-62ad96dd167a.
	//
	// AWS WAF is a web application firewall that lets you monitor the HTTP and
	// HTTPS requests that are forwarded to CloudFront, and lets you control access
	// to your content. Based on conditions that you specify, such as the IP addresses
	// that requests originate from or the values of query strings, CloudFront responds
	// to requests either with the requested content or with an HTTP 403 status
	// code (Forbidden). You can also configure CloudFront to return a custom error
	// page when a request is blocked. For more information about AWS WAF, see the
	// AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
	WebACLId *string `type:"string"`
}

// String returns the string representation
func (s DistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DistributionConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.DefaultCacheBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultCacheBehavior"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Origins == nil {
		invalidParams.Add(request.NewErrParamRequired("Origins"))
	}
	if s.Aliases != nil {
		if err := s.Aliases.Validate(); err != nil {
			invalidParams.AddNested("Aliases", err.(request.ErrInvalidParams))
		}
	}
	if s.CacheBehaviors != nil {
		if err := s.CacheBehaviors.Validate(); err != nil {
			invalidParams.AddNested("CacheBehaviors", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomErrorResponses != nil {
		if err := s.CustomErrorResponses.Validate(); err != nil {
			invalidParams.AddNested("CustomErrorResponses", err.(request.ErrInvalidParams))
		}
	}
	if s.DefaultCacheBehavior != nil {
		if err := s.DefaultCacheBehavior.Validate(); err != nil {
			invalidParams.AddNested("DefaultCacheBehavior", err.(request.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}
	if s.OriginGroups != nil {
		if err := s.OriginGroups.Validate(); err != nil {
			invalidParams.AddNested("OriginGroups", err.(request.ErrInvalidParams))
		}
	}
	if s.Origins != nil {
		if err := s.Origins.Validate(); err != nil {
			invalidParams.AddNested("Origins", err.(request.ErrInvalidParams))
		}
	}
	if s.Restrictions != nil {
		if err := s.Restrictions.Validate(); err != nil {
			invalidParams.AddNested("Restrictions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliases sets the Aliases field's value.
func (s *DistributionConfig) SetAliases(v *Aliases) *DistributionConfig {
	s.Aliases = v
	return s
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *DistributionConfig) SetCacheBehaviors(v *CacheBehaviors) *DistributionConfig {
	s.CacheBehaviors = v
	return s
}

// SetCallerReference sets the CallerReference field's value.
func (s *DistributionConfig) SetCallerReference(v string) *DistributionConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *DistributionConfig) SetComment(v string) *DistributionConfig {
	s.Comment = &v
	return s
}

// SetCustomErrorResponses sets the CustomErrorResponses field's value.
func (s *DistributionConfig) SetCustomErrorResponses(v *CustomErrorResponses) *DistributionConfig {
	s.CustomErrorResponses = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *DistributionConfig) SetDefaultCacheBehavior(v *DefaultCacheBehavior) *DistributionConfig {
	s.DefaultCacheBehavior = v
	return s
}

// SetDefaultRootObject sets the DefaultRootObject field's value.
func (s *DistributionConfig) SetDefaultRootObject(v string) *DistributionConfig {
	s.DefaultRootObject = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *DistributionConfig) SetEnabled(v bool) *DistributionConfig {
	s.Enabled = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *DistributionConfig) SetHttpVersion(v string) *DistributionConfig {
	s.HttpVersion = &v
	return s
}

// SetIsIPV6Enabled sets the IsIPV6Enabled field's value.
func (s *DistributionConfig) SetIsIPV6Enabled(v bool) *DistributionConfig {
	s.IsIPV6Enabled = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *DistributionConfig) SetLogging(v *LoggingConfig) *DistributionConfig {
	s.Logging = v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *DistributionConfig) SetOriginGroups(v *OriginGroups) *DistributionConfig {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *DistributionConfig) SetOrigins(v *Origins) *DistributionConfig {
	s.Origins = v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *DistributionConfig) SetPriceClass(v string) *DistributionConfig {
	s.PriceClass = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *DistributionConfig) SetRestrictions(v *Restrictions) *DistributionConfig {
	s.Restrictions = v
	return s
}

// SetViewerCertificate sets the ViewerCertificate field's value.
func (s *DistributionConfig) SetViewerCertificate(v *ViewerCertificate) *DistributionConfig {
	s.ViewerCertificate = v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *DistributionConfig) SetWebACLId(v string) *DistributionConfig {
	s.WebACLId = &v
	return s
}

// A distribution Configuration and a list of tags to be associated with the
// distribution.
type DistributionConfigWithTags struct {
	_ struct{} `type:"structure"`

	// A distribution configuration.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s DistributionConfigWithTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionConfigWithTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributionConfigWithTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DistributionConfigWithTags"}
	if s.DistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfig"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *DistributionConfigWithTags) SetDistributionConfig(v *DistributionConfig) *DistributionConfigWithTags {
	s.DistributionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DistributionConfigWithTags) SetTags(v *Tags) *DistributionConfigWithTags {
	s.Tags = v
	return s
}

// A list of distribution IDs.
type DistributionIdList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more distribution IDs remain to be listed.
	// If your results were truncated, you can make a subsequent request using the
	// Marker request field to retrieve more distribution IDs in the list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// Contains the distribution IDs in the list.
	Items []*string `locationNameList:"DistributionId" type:"list"`

	// The value provided in the Marker request field.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The maximum number of distribution IDs requested.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// Contains the value that you should use in the Marker field of a subsequent
	// request to continue listing distribution IDs where you left off.
	NextMarker *string `type:"string"`

	// The total number of distribution IDs returned in the response.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DistributionIdList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionIdList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *DistributionIdList) SetIsTruncated(v bool) *DistributionIdList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *DistributionIdList) SetItems(v []*string) *DistributionIdList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DistributionIdList) SetMarker(v string) *DistributionIdList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DistributionIdList) SetMaxItems(v int64) *DistributionIdList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DistributionIdList) SetNextMarker(v string) *DistributionIdList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *DistributionIdList) SetQuantity(v int64) *DistributionIdList {
	s.Quantity = &v
	return s
}

// A distribution list.
type DistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more distributions remain to be listed. If
	// your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one DistributionSummary element for each distribution
	// that was created by the current AWS account.
	Items []*DistributionSummary `locationNameList:"DistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of distributions that were created by the current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DistributionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *DistributionList) SetIsTruncated(v bool) *DistributionList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *DistributionList) SetItems(v []*DistributionSummary) *DistributionList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DistributionList) SetMarker(v string) *DistributionList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DistributionList) SetMaxItems(v int64) *DistributionList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DistributionList) SetNextMarker(v string) *DistributionList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *DistributionList) SetQuantity(v int64) *DistributionList {
	s.Quantity = &v
	return s
}

// A summary of the information about a CloudFront distribution.
type DistributionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// AWS services in China customers must file for an Internet Content Provider
	// (ICP) recordal if they want to serve content publicly on an alternate domain
	// name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal
	// provides the ICP recordal status for CNAMEs associated with distributions.
	//
	// For more information about ICP recordals, see Signup, Accounts, and Credentials
	// (https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
	// in Getting Started with AWS services in China.
	AliasICPRecordals []*AliasICPRecordal `locationNameList:"AliasICPRecordal" type:"list"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	//
	// Aliases is a required field
	Aliases *Aliases `type:"structure" required:"true"`

	// A complex type that contains zero or more CacheBehavior elements.
	//
	// CacheBehaviors is a required field
	CacheBehaviors *CacheBehaviors `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// A complex type that contains zero or more CustomErrorResponses elements.
	//
	// CustomErrorResponses is a required field
	CustomErrorResponses *CustomErrorResponses `type:"structure" required:"true"`

	// A complex type that describes the default cache behavior if you don't specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The domain name that corresponds to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept user requests for content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the maximum HTTP version that you want viewers to use to communicate
	// with CloudFront. The default value for new web distributions is http2. Viewers
	// that don't support HTTP/2 will automatically use an earlier version.
	//
	// HttpVersion is a required field
	HttpVersion *string `type:"string" required:"true" enum:"HttpVersion"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for
	// your distribution.
	//
	// IsIPV6Enabled is a required field
	IsIPV6Enabled *bool `type:"boolean" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// A complex type that contains information about origin groups for this distribution.
	OriginGroups *OriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	//
	// Origins is a required field
	Origins *Origins `type:"structure" required:"true"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// PriceClass is a required field
	PriceClass *string `type:"string" required:"true" enum:"PriceClass"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	//
	// Restrictions is a required field
	Restrictions *Restrictions `type:"structure" required:"true"`

	// The current status of the distribution. When the status is Deployed, the
	// distribution's information is propagated to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// A complex type that determines the distribution’s SSL/TLS configuration
	// for communicating with viewers.
	//
	// ViewerCertificate is a required field
	ViewerCertificate *ViewerCertificate `type:"structure" required:"true"`

	// The Web ACL Id (if any) associated with the distribution.
	//
	// WebACLId is a required field
	WebACLId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DistributionSummary) SetARN(v string) *DistributionSummary {
	s.ARN = &v
	return s
}

// SetAliasICPRecordals sets the AliasICPRecordals field's value.
func (s *DistributionSummary) SetAliasICPRecordals(v []*AliasICPRecordal) *DistributionSummary {
	s.AliasICPRecordals = v
	return s
}

// SetAliases sets the Aliases field's value.
func (s *DistributionSummary) SetAliases(v *Aliases) *DistributionSummary {
	s.Aliases = v
	return s
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *DistributionSummary) SetCacheBehaviors(v *CacheBehaviors) *DistributionSummary {
	s.CacheBehaviors = v
	return s
}

// SetComment sets the Comment field's value.
func (s *DistributionSummary) SetComment(v string) *DistributionSummary {
	s.Comment = &v
	return s
}

// SetCustomErrorResponses sets the CustomErrorResponses field's value.
func (s *DistributionSummary) SetCustomErrorResponses(v *CustomErrorResponses) *DistributionSummary {
	s.CustomErrorResponses = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *DistributionSummary) SetDefaultCacheBehavior(v *DefaultCacheBehavior) *DistributionSummary {
	s.DefaultCacheBehavior = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DistributionSummary) SetDomainName(v string) *DistributionSummary {
	s.DomainName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *DistributionSummary) SetEnabled(v bool) *DistributionSummary {
	s.Enabled = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *DistributionSummary) SetHttpVersion(v string) *DistributionSummary {
	s.HttpVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *DistributionSummary) SetId(v string) *DistributionSummary {
	s.Id = &v
	return s
}

// SetIsIPV6Enabled sets the IsIPV6Enabled field's value.
func (s *DistributionSummary) SetIsIPV6Enabled(v bool) *DistributionSummary {
	s.IsIPV6Enabled = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DistributionSummary) SetLastModifiedTime(v time.Time) *DistributionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *DistributionSummary) SetOriginGroups(v *OriginGroups) *DistributionSummary {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *DistributionSummary) SetOrigins(v *Origins) *DistributionSummary {
	s.Origins = v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *DistributionSummary) SetPriceClass(v string) *DistributionSummary {
	s.PriceClass = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *DistributionSummary) SetRestrictions(v *Restrictions) *DistributionSummary {
	s.Restrictions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DistributionSummary) SetStatus(v string) *DistributionSummary {
	s.Status = &v
	return s
}

// SetViewerCertificate sets the ViewerCertificate field's value.
func (s *DistributionSummary) SetViewerCertificate(v *ViewerCertificate) *DistributionSummary {
	s.ViewerCertificate = v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *DistributionSummary) SetWebACLId(v string) *DistributionSummary {
	s.WebACLId = &v
	return s
}

// Complex data type for field-level encryption profiles that includes all of
// the encryption entities.
type EncryptionEntities struct {
	_ struct{} `type:"structure"`

	// An array of field patterns in a field-level encryption content type-profile
	// mapping.
	Items []*EncryptionEntity `locationNameList:"EncryptionEntity" type:"list"`

	// Number of field pattern items in a field-level encryption content type-profile
	// mapping.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s EncryptionEntities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionEntities) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionEntities) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionEntities"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *EncryptionEntities) SetItems(v []*EncryptionEntity) *EncryptionEntities {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *EncryptionEntities) SetQuantity(v int64) *EncryptionEntities {
	s.Quantity = &v
	return s
}

// Complex data type for field-level encryption profiles that includes the encryption
// key and field pattern specifications.
type EncryptionEntity struct {
	_ struct{} `type:"structure"`

	// Field patterns in a field-level encryption content type profile specify the
	// fields that you want to be encrypted. You can provide the full field name,
	// or any beginning characters followed by a wildcard (*). You can't overlap
	// field patterns. For example, you can't have both ABC* and AB*. Note that
	// field patterns are case-sensitive.
	//
	// FieldPatterns is a required field
	FieldPatterns *FieldPatterns `type:"structure" required:"true"`

	// The provider associated with the public key being used for encryption. This
	// value must also be provided with the private key for applications to be able
	// to decrypt data.
	//
	// ProviderId is a required field
	ProviderId *string `type:"string" required:"true"`

	// The public key associated with a set of field-level encryption patterns,
	// to be used when encrypting the fields that match the patterns.
	//
	// PublicKeyId is a required field
	PublicKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionEntity"}
	if s.FieldPatterns == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldPatterns"))
	}
	if s.ProviderId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderId"))
	}
	if s.PublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyId"))
	}
	if s.FieldPatterns != nil {
		if err := s.FieldPatterns.Validate(); err != nil {
			invalidParams.AddNested("FieldPatterns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldPatterns sets the FieldPatterns field's value.
func (s *EncryptionEntity) SetFieldPatterns(v *FieldPatterns) *EncryptionEntity {
	s.FieldPatterns = v
	return s
}

// SetProviderId sets the ProviderId field's value.
func (s *EncryptionEntity) SetProviderId(v string) *EncryptionEntity {
	s.ProviderId = &v
	return s
}

// SetPublicKeyId sets the PublicKeyId field's value.
func (s *EncryptionEntity) SetPublicKeyId(v string) *EncryptionEntity {
	s.PublicKeyId = &v
	return s
}

// Contains information about the Amazon Kinesis data stream where you are sending
// real-time log data in a real-time log configuration.
type EndPoint struct {
	_ struct{} `type:"structure"`

	// Contains information about the Amazon Kinesis data stream where you are sending
	// real-time log data.
	KinesisStreamConfig *KinesisStreamConfig `type:"structure"`

	// The type of data stream where you are sending real-time log data. The only
	// valid value is Kinesis.
	//
	// StreamType is a required field
	StreamType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EndPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndPoint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndPoint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndPoint"}
	if s.StreamType == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamType"))
	}
	if s.KinesisStreamConfig != nil {
		if err := s.KinesisStreamConfig.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKinesisStreamConfig sets the KinesisStreamConfig field's value.
func (s *EndPoint) SetKinesisStreamConfig(v *KinesisStreamConfig) *EndPoint {
	s.KinesisStreamConfig = v
	return s
}

// SetStreamType sets the StreamType field's value.
func (s *EndPoint) SetStreamType(v string) *EndPoint {
	s.StreamType = &v
	return s
}

// A complex data type that includes the profile configurations and other options
// specified for field-level encryption.
type FieldLevelEncryption struct {
	_ struct{} `type:"structure"`

	// A complex data type that includes the profile configurations specified for
	// field-level encryption.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `type:"structure" required:"true"`

	// The configuration ID for a field-level encryption configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted
	// by specific public keys.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time the field-level encryption configuration was changed.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryption) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *FieldLevelEncryption) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *FieldLevelEncryption {
	s.FieldLevelEncryptionConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryption) SetId(v string) *FieldLevelEncryption {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryption) SetLastModifiedTime(v time.Time) *FieldLevelEncryption {
	s.LastModifiedTime = &v
	return s
}

// A complex data type that includes the profile configurations specified for
// field-level encryption.
type FieldLevelEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment about the configuration.
	Comment *string `type:"string"`

	// A complex data type that specifies when to forward content if a content type
	// isn't recognized and profiles to use as by default in a request if a query
	// argument doesn't specify a profile to use.
	ContentTypeProfileConfig *ContentTypeProfileConfig `type:"structure"`

	// A complex data type that specifies when to forward content if a profile isn't
	// found and the profile that can be provided as a query argument in a request.
	QueryArgProfileConfig *QueryArgProfileConfig `type:"structure"`
}

// String returns the string representation
func (s FieldLevelEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldLevelEncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldLevelEncryptionConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.ContentTypeProfileConfig != nil {
		if err := s.ContentTypeProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentTypeProfileConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryArgProfileConfig != nil {
		if err := s.QueryArgProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("QueryArgProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *FieldLevelEncryptionConfig) SetCallerReference(v string) *FieldLevelEncryptionConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionConfig) SetComment(v string) *FieldLevelEncryptionConfig {
	s.Comment = &v
	return s
}

// SetContentTypeProfileConfig sets the ContentTypeProfileConfig field's value.
func (s *FieldLevelEncryptionConfig) SetContentTypeProfileConfig(v *ContentTypeProfileConfig) *FieldLevelEncryptionConfig {
	s.ContentTypeProfileConfig = v
	return s
}

// SetQueryArgProfileConfig sets the QueryArgProfileConfig field's value.
func (s *FieldLevelEncryptionConfig) SetQueryArgProfileConfig(v *QueryArgProfileConfig) *FieldLevelEncryptionConfig {
	s.QueryArgProfileConfig = v
	return s
}

// List of field-level encrpytion configurations.
type FieldLevelEncryptionList struct {
	_ struct{} `type:"structure"`

	// An array of field-level encryption items.
	Items []*FieldLevelEncryptionSummary `locationNameList:"FieldLevelEncryptionSummary" type:"list"`

	// The maximum number of elements you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your configurations where you left off.
	NextMarker *string `type:"string"`

	// The number of field-level encryption items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *FieldLevelEncryptionList) SetItems(v []*FieldLevelEncryptionSummary) *FieldLevelEncryptionList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *FieldLevelEncryptionList) SetMaxItems(v int64) *FieldLevelEncryptionList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *FieldLevelEncryptionList) SetNextMarker(v string) *FieldLevelEncryptionList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *FieldLevelEncryptionList) SetQuantity(v int64) *FieldLevelEncryptionList {
	s.Quantity = &v
	return s
}

// A complex data type for field-level encryption profiles.
type FieldLevelEncryptionProfile struct {
	_ struct{} `type:"structure"`

	// A complex data type that includes the profile name and the encryption entities
	// for the field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `type:"structure" required:"true"`

	// The ID for a field-level encryption profile configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted
	// by specific public keys.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time the field-level encryption profile was updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfile) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *FieldLevelEncryptionProfile) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *FieldLevelEncryptionProfile {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryptionProfile) SetId(v string) *FieldLevelEncryptionProfile {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryptionProfile) SetLastModifiedTime(v time.Time) *FieldLevelEncryptionProfile {
	s.LastModifiedTime = &v
	return s
}

// A complex data type of profiles for the field-level encryption.
type FieldLevelEncryptionProfileConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures that the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment for the field-level encryption profile.
	Comment *string `type:"string"`

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// EncryptionEntities is a required field
	EncryptionEntities *EncryptionEntities `type:"structure" required:"true"`

	// Profile name for the field-level encryption profile.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldLevelEncryptionProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldLevelEncryptionProfileConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.EncryptionEntities == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionEntities"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.EncryptionEntities != nil {
		if err := s.EncryptionEntities.Validate(); err != nil {
			invalidParams.AddNested("EncryptionEntities", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *FieldLevelEncryptionProfileConfig) SetCallerReference(v string) *FieldLevelEncryptionProfileConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionProfileConfig) SetComment(v string) *FieldLevelEncryptionProfileConfig {
	s.Comment = &v
	return s
}

// SetEncryptionEntities sets the EncryptionEntities field's value.
func (s *FieldLevelEncryptionProfileConfig) SetEncryptionEntities(v *EncryptionEntities) *FieldLevelEncryptionProfileConfig {
	s.EncryptionEntities = v
	return s
}

// SetName sets the Name field's value.
func (s *FieldLevelEncryptionProfileConfig) SetName(v string) *FieldLevelEncryptionProfileConfig {
	s.Name = &v
	return s
}

// List of field-level encryption profiles.
type FieldLevelEncryptionProfileList struct {
	_ struct{} `type:"structure"`

	// The field-level encryption profile items.
	Items []*FieldLevelEncryptionProfileSummary `locationNameList:"FieldLevelEncryptionProfileSummary" type:"list"`

	// The maximum number of field-level encryption profiles you want in the response
	// body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your profiles where you left off.
	NextMarker *string `type:"string"`

	// The number of field-level encryption profiles.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfileList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *FieldLevelEncryptionProfileList) SetItems(v []*FieldLevelEncryptionProfileSummary) *FieldLevelEncryptionProfileList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *FieldLevelEncryptionProfileList) SetMaxItems(v int64) *FieldLevelEncryptionProfileList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *FieldLevelEncryptionProfileList) SetNextMarker(v string) *FieldLevelEncryptionProfileList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *FieldLevelEncryptionProfileList) SetQuantity(v int64) *FieldLevelEncryptionProfileList {
	s.Quantity = &v
	return s
}

// The field-level encryption profile summary.
type FieldLevelEncryptionProfileSummary struct {
	_ struct{} `type:"structure"`

	// An optional comment for the field-level encryption profile summary.
	Comment *string `type:"string"`

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// EncryptionEntities is a required field
	EncryptionEntities *EncryptionEntities `type:"structure" required:"true"`

	// ID for the field-level encryption profile summary.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The time when the the field-level encryption profile summary was last updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Name for the field-level encryption profile summary.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfileSummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionProfileSummary) SetComment(v string) *FieldLevelEncryptionProfileSummary {
	s.Comment = &v
	return s
}

// SetEncryptionEntities sets the EncryptionEntities field's value.
func (s *FieldLevelEncryptionProfileSummary) SetEncryptionEntities(v *EncryptionEntities) *FieldLevelEncryptionProfileSummary {
	s.EncryptionEntities = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryptionProfileSummary) SetId(v string) *FieldLevelEncryptionProfileSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryptionProfileSummary) SetLastModifiedTime(v time.Time) *FieldLevelEncryptionProfileSummary {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FieldLevelEncryptionProfileSummary) SetName(v string) *FieldLevelEncryptionProfileSummary {
	s.Name = &v
	return s
}

// A summary of a field-level encryption item.
type FieldLevelEncryptionSummary struct {
	_ struct{} `type:"structure"`

	// An optional comment about the field-level encryption item.
	Comment *string `type:"string"`

	// A summary of a content type-profile mapping.
	ContentTypeProfileConfig *ContentTypeProfileConfig `type:"structure"`

	// The unique ID of a field-level encryption item.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time that the summary of field-level encryption items was modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// A summary of a query argument-profile mapping.
	QueryArgProfileConfig *QueryArgProfileConfig `type:"structure"`
}

// String returns the string representation
func (s FieldLevelEncryptionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionSummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionSummary) SetComment(v string) *FieldLevelEncryptionSummary {
	s.Comment = &v
	return s
}

// SetContentTypeProfileConfig sets the ContentTypeProfileConfig field's value.
func (s *FieldLevelEncryptionSummary) SetContentTypeProfileConfig(v *ContentTypeProfileConfig) *FieldLevelEncryptionSummary {
	s.ContentTypeProfileConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryptionSummary) SetId(v string) *FieldLevelEncryptionSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryptionSummary) SetLastModifiedTime(v time.Time) *FieldLevelEncryptionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetQueryArgProfileConfig sets the QueryArgProfileConfig field's value.
func (s *FieldLevelEncryptionSummary) SetQueryArgProfileConfig(v *QueryArgProfileConfig) *FieldLevelEncryptionSummary {
	s.QueryArgProfileConfig = v
	return s
}

// A complex data type that includes the field patterns to match for field-level
// encryption.
type FieldPatterns struct {
	_ struct{} `type:"structure"`

	// An array of the field-level encryption field patterns.
	Items []*string `locationNameList:"FieldPattern" type:"list"`

	// The number of field-level encryption field patterns.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldPatterns) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldPatterns) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldPatterns) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldPatterns"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *FieldPatterns) SetItems(v []*string) *FieldPatterns {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *FieldPatterns) SetQuantity(v int64) *FieldPatterns {
	s.Quantity = &v
	return s
}

// This field is deprecated. We recommend that you use a cache policy or an
// origin request policy instead of this field.
//
// If you want to include values in the cache key, use a cache policy. For more
// information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
// in the Amazon CloudFront Developer Guide.
//
// If you want to send values to the origin but not include them in the cache
// key, use an origin request policy. For more information, see Creating origin
// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
// in the Amazon CloudFront Developer Guide.
//
// A complex type that specifies how CloudFront handles query strings, cookies,
// and HTTP headers.
type ForwardedValues struct {
	_ struct{} `type:"structure"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field.
	//
	// If you want to include cookies in the cache key, use a cache policy. For
	// more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send cookies to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see Creating origin
	// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// A complex type that specifies whether you want CloudFront to forward cookies
	// to the origin and, if so, which ones. For more information about forwarding
	// cookies to the origin, see How CloudFront Forwards, Caches, and Logs Cookies
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Cookies is a required field
	Cookies *CookiePreference `type:"structure" required:"true"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field.
	//
	// If you want to include headers in the cache key, use a cache policy. For
	// more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send headers to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see Creating origin
	// request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// A complex type that specifies the Headers, if any, that you want CloudFront
	// to forward to the origin for this cache behavior (whitelisted headers). For
	// the headers that you specify, CloudFront also caches separate versions of
	// a specified object that is based on the header values in viewer requests.
	//
	// For more information, see Caching Content Based on Request Headers (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html)
	// in the Amazon CloudFront Developer Guide.
	Headers *Headers `type:"structure"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field.
	//
	// If you want to include query strings in the cache key, use a cache policy.
	// For more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send query strings to the origin but not include them in the
	// cache key, use an origin request policy. For more information, see Creating
	// origin request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// Indicates whether you want CloudFront to forward query strings to the origin
	// that is associated with this cache behavior and cache based on the query
	// string parameters. CloudFront behavior depends on the value of QueryString
	// and on the values that you specify for QueryStringCacheKeys, if any:
	//
	// If you specify true for QueryString and you don't specify any values for
	// QueryStringCacheKeys, CloudFront forwards all query string parameters to
	// the origin and caches based on all query string parameters. Depending on
	// how many query string parameters and values you have, this can adversely
	// affect performance because CloudFront must forward more requests to the origin.
	//
	// If you specify true for QueryString and you specify one or more values for
	// QueryStringCacheKeys, CloudFront forwards all query string parameters to
	// the origin, but it only caches based on the query string parameters that
	// you specify.
	//
	// If you specify false for QueryString, CloudFront doesn't forward any query
	// string parameters to the origin, and doesn't cache based on query string
	// parameters.
	//
	// For more information, see Configuring CloudFront to Cache Based on Query
	// String Parameters (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// QueryString is a required field
	QueryString *bool `type:"boolean" required:"true"`

	// This field is deprecated. We recommend that you use a cache policy or an
	// origin request policy instead of this field.
	//
	// If you want to include query strings in the cache key, use a cache policy.
	// For more information, see Creating cache policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you want to send query strings to the origin but not include them in the
	// cache key, use an origin request policy. For more information, see Creating
	// origin request policies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy)
	// in the Amazon CloudFront Developer Guide.
	//
	// A complex type that contains information about the query string parameters
	// that you want CloudFront to use for caching for this cache behavior.
	QueryStringCacheKeys *QueryStringCacheKeys `type:"structure"`
}

// String returns the string representation
func (s ForwardedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardedValues) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardedValues) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForwardedValues"}
	if s.Cookies == nil {
		invalidParams.Add(request.NewErrParamRequired("Cookies"))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.Cookies != nil {
		if err := s.Cookies.Validate(); err != nil {
			invalidParams.AddNested("Cookies", err.(request.ErrInvalidParams))
		}
	}
	if s.Headers != nil {
		if err := s.Headers.Validate(); err != nil {
			invalidParams.AddNested("Headers", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryStringCacheKeys != nil {
		if err := s.QueryStringCacheKeys.Validate(); err != nil {
			invalidParams.AddNested("QueryStringCacheKeys", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCookies sets the Cookies field's value.
func (s *ForwardedValues) SetCookies(v *CookiePreference) *ForwardedValues {
	s.Cookies = v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *ForwardedValues) SetHeaders(v *Headers) *ForwardedValues {
	s.Headers = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ForwardedValues) SetQueryString(v bool) *ForwardedValues {
	s.QueryString = &v
	return s
}

// SetQueryStringCacheKeys sets the QueryStringCacheKeys field's value.
func (s *ForwardedValues) SetQueryStringCacheKeys(v *QueryStringCacheKeys) *ForwardedValues {
	s.QueryStringCacheKeys = v
	return s
}

// A complex type that controls the countries in which your content is distributed.
// CloudFront determines the location of your users using MaxMind GeoIP databases.
type GeoRestriction struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a Location element for each country in which
	// you want CloudFront either to distribute your content (whitelist) or not
	// distribute your content (blacklist).
	//
	// The Location element is a two-letter, uppercase country code for a country
	// that you want to include in your blacklist or whitelist. Include one Location
	// element for each country.
	//
	// CloudFront and MaxMind both use ISO 3166 country codes. For the current list
	// of countries and the corresponding codes, see ISO 3166-1-alpha-2 code on
	// the International Organization for Standardization website. You can also
	// refer to the country list on the CloudFront console, which includes both
	// country names and codes.
	Items []*string `locationNameList:"Location" type:"list"`

	// When geo restriction is enabled, this is the number of countries in your
	// whitelist or blacklist. Otherwise, when it is not enabled, Quantity is 0,
	// and you can omit Items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`

	// The method that you want to use to restrict distribution of your content
	// by country:
	//
	//    * none: No geo restriction is enabled, meaning access to content is not
	//    restricted by client geo location.
	//
	//    * blacklist: The Location elements specify the countries in which you
	//    don't want CloudFront to distribute your content.
	//
	//    * whitelist: The Location elements specify the countries in which you
	//    want CloudFront to distribute your content.
	//
	// RestrictionType is a required field
	RestrictionType *string `type:"string" required:"true" enum:"GeoRestrictionType"`
}

// String returns the string representation
func (s GeoRestriction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoRestriction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoRestriction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoRestriction"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.RestrictionType == nil {
		invalidParams.Add(request.NewErrParamRequired("RestrictionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *GeoRestriction) SetItems(v []*string) *GeoRestriction {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *GeoRestriction) SetQuantity(v int64) *GeoRestriction {
	s.Quantity = &v
	return s
}

// SetRestrictionType sets the RestrictionType field's value.
func (s *GeoRestriction) SetRestrictionType(v string) *GeoRestriction {
	s.RestrictionType = &v
	return s
}

type GetCachePolicyConfigInput struct {
	_ struct{} `locationName:"GetCachePolicyConfigRequest" type:"structure"`

	// The unique identifier for the cache policy. If the cache policy is attached
	// to a distribution’s cache behavior, you can get the policy’s identifier
	// using ListDistributions or GetDistribution. If the cache policy is not attached
	// to a cache behavior, you can get the identifier using ListCachePolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCachePolicyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCachePolicyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCachePolicyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCachePolicyConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCachePolicyConfigInput) SetId(v string) *GetCachePolicyConfigInput {
	s.Id = &v
	return s
}

type GetCachePolicyConfigOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicyConfig"`

	// The cache policy configuration.
	CachePolicyConfig *CachePolicyConfig `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCachePolicyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCachePolicyConfigOutput) GoString() string {
	return s.String()
}

// SetCachePolicyConfig sets the CachePolicyConfig field's value.
func (s *GetCachePolicyConfigOutput) SetCachePolicyConfig(v *CachePolicyConfig) *GetCachePolicyConfigOutput {
	s.CachePolicyConfig = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetCachePolicyConfigOutput) SetETag(v string) *GetCachePolicyConfigOutput {
	s.ETag = &v
	return s
}

type GetCachePolicyInput struct {
	_ struct{} `locationName:"GetCachePolicyRequest" type:"structure"`

	// The unique identifier for the cache policy. If the cache policy is attached
	// to a distribution’s cache behavior, you can get the policy’s identifier
	// using ListDistributions or GetDistribution. If the cache policy is not attached
	// to a cache behavior, you can get the identifier using ListCachePolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCachePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCachePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCachePolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCachePolicyInput) SetId(v string) *GetCachePolicyInput {
	s.Id = &v
	return s
}

type GetCachePolicyOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicy"`

	// The cache policy.
	CachePolicy *CachePolicy `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCachePolicyOutput) GoString() string {
	return s.String()
}

// SetCachePolicy sets the CachePolicy field's value.
func (s *GetCachePolicyOutput) SetCachePolicy(v *CachePolicy) *GetCachePolicyOutput {
	s.CachePolicy = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetCachePolicyOutput) SetETag(v string) *GetCachePolicyOutput {
	s.ETag = &v
	return s
}

// The origin access identity's configuration information. For more information,
// see CloudFrontOriginAccessIdentityConfig (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html).
type GetCloudFrontOriginAccessIdentityConfigInput struct {
	_ struct{} `locationName:"GetCloudFrontOriginAccessIdentityConfigRequest" type:"structure"`

	// The identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudFrontOriginAccessIdentityConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudFrontOriginAccessIdentityConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCloudFrontOriginAccessIdentityConfigInput) SetId(v string) *GetCloudFrontOriginAccessIdentityConfigInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityConfigOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The origin access identity's configuration information.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *GetCloudFrontOriginAccessIdentityConfigOutput) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *GetCloudFrontOriginAccessIdentityConfigOutput {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetCloudFrontOriginAccessIdentityConfigOutput) SetETag(v string) *GetCloudFrontOriginAccessIdentityConfigOutput {
	s.ETag = &v
	return s
}

// The request to get an origin access identity's information.
type GetCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"GetCloudFrontOriginAccessIdentityRequest" type:"structure"`

	// The identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudFrontOriginAccessIdentityInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCloudFrontOriginAccessIdentityInput) SetId(v string) *GetCloudFrontOriginAccessIdentityInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the origin access identity's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentity sets the CloudFrontOriginAccessIdentity field's value.
func (s *GetCloudFrontOriginAccessIdentityOutput) SetCloudFrontOriginAccessIdentity(v *OriginAccessIdentity) *GetCloudFrontOriginAccessIdentityOutput {
	s.CloudFrontOriginAccessIdentity = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetCloudFrontOriginAccessIdentityOutput) SetETag(v string) *GetCloudFrontOriginAccessIdentityOutput {
	s.ETag = &v
	return s
}

// The request to get a distribution configuration.
type GetDistributionConfigInput struct {
	_ struct{} `locationName:"GetDistributionConfigRequest" type:"structure"`

	// The distribution's ID. If the ID is empty, an empty distribution configuration
	// is returned.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDistributionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDistributionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDistributionConfigInput) SetId(v string) *GetDistributionConfigInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	DistributionConfig *DistributionConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionConfigOutput) GoString() string {
	return s.String()
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *GetDistributionConfigOutput) SetDistributionConfig(v *DistributionConfig) *GetDistributionConfigOutput {
	s.DistributionConfig = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetDistributionConfigOutput) SetETag(v string) *GetDistributionConfigOutput {
	s.ETag = &v
	return s
}

// The request to get a distribution's information.
type GetDistributionInput struct {
	_ struct{} `locationName:"GetDistributionRequest" type:"structure"`

	// The distribution's ID. If the ID is empty, an empty distribution configuration
	// is returned.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDistributionInput) SetId(v string) *GetDistributionInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution's information. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *GetDistributionOutput) SetDistribution(v *Distribution) *GetDistributionOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetDistributionOutput) SetETag(v string) *GetDistributionOutput {
	s.ETag = &v
	return s
}

type GetFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionConfigRequest" type:"structure"`

	// Request the ID for the field-level encryption configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionConfigInput) SetId(v string) *GetFieldLevelEncryptionConfigInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionConfig"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption configuration information.
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionConfigOutput) SetETag(v string) *GetFieldLevelEncryptionConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *GetFieldLevelEncryptionConfigOutput) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *GetFieldLevelEncryptionConfigOutput {
	s.FieldLevelEncryptionConfig = v
	return s
}

type GetFieldLevelEncryptionInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionRequest" type:"structure"`

	// Request the ID for the field-level encryption configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionInput) SetId(v string) *GetFieldLevelEncryptionInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption configuration information.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionOutput) SetETag(v string) *GetFieldLevelEncryptionOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryption sets the FieldLevelEncryption field's value.
func (s *GetFieldLevelEncryptionOutput) SetFieldLevelEncryption(v *FieldLevelEncryption) *GetFieldLevelEncryptionOutput {
	s.FieldLevelEncryption = v
	return s
}

type GetFieldLevelEncryptionProfileConfigInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionProfileConfigRequest" type:"structure"`

	// Get the ID for the field-level encryption profile configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionProfileConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionProfileConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionProfileConfigInput) SetId(v string) *GetFieldLevelEncryptionProfileConfigInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionProfileConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfileConfig"`

	// The current version of the field-level encryption profile configuration result.
	// For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption profile configuration information.
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionProfileConfigOutput) SetETag(v string) *GetFieldLevelEncryptionProfileConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *GetFieldLevelEncryptionProfileConfigOutput) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *GetFieldLevelEncryptionProfileConfigOutput {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

type GetFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionProfileRequest" type:"structure"`

	// Get the ID for the field-level encryption profile information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionProfileInput) SetId(v string) *GetFieldLevelEncryptionProfileInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfile"`

	// The current version of the field level encryption profile. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption profile information.
	FieldLevelEncryptionProfile *FieldLevelEncryptionProfile `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionProfileOutput) SetETag(v string) *GetFieldLevelEncryptionProfileOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfile sets the FieldLevelEncryptionProfile field's value.
func (s *GetFieldLevelEncryptionProfileOutput) SetFieldLevelEncryptionProfile(v *FieldLevelEncryptionProfile) *GetFieldLevelEncryptionProfileOutput {
	s.FieldLevelEncryptionProfile = v
	return s
}

// The request to get an invalidation's information.
type GetInvalidationInput struct {
	_ struct{} `locationName:"GetInvalidationRequest" type:"structure"`

	// The distribution's ID.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// The identifier for the invalidation request, for example, IDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInvalidationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvalidationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInvalidationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInvalidationInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *GetInvalidationInput) SetDistributionId(v string) *GetInvalidationInput {
	s.DistributionId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetInvalidationInput) SetId(v string) *GetInvalidationInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetInvalidationOutput struct {
	_ struct{} `type:"structure" payload:"Invalidation"`

	// The invalidation's information. For more information, see Invalidation Complex
	// Type (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html).
	Invalidation *Invalidation `type:"structure"`
}

// String returns the string representation
func (s GetInvalidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvalidationOutput) GoString() string {
	return s.String()
}

// SetInvalidation sets the Invalidation field's value.
func (s *GetInvalidationOutput) SetInvalidation(v *Invalidation) *GetInvalidationOutput {
	s.Invalidation = v
	return s
}

type GetKeyGroupConfigInput struct {
	_ struct{} `locationName:"GetKeyGroupConfigRequest" type:"structure"`

	// The identifier of the key group whose configuration you are getting. To get
	// the identifier, use ListKeyGroups.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyGroupConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyGroupConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyGroupConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyGroupConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetKeyGroupConfigInput) SetId(v string) *GetKeyGroupConfigInput {
	s.Id = &v
	return s
}

type GetKeyGroupConfigOutput struct {
	_ struct{} `type:"structure" payload:"KeyGroupConfig"`

	// The identifier for this version of the key group.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The key group configuration.
	KeyGroupConfig *KeyGroupConfig `type:"structure"`
}

// String returns the string representation
func (s GetKeyGroupConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyGroupConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetKeyGroupConfigOutput) SetETag(v string) *GetKeyGroupConfigOutput {
	s.ETag = &v
	return s
}

// SetKeyGroupConfig sets the KeyGroupConfig field's value.
func (s *GetKeyGroupConfigOutput) SetKeyGroupConfig(v *KeyGroupConfig) *GetKeyGroupConfigOutput {
	s.KeyGroupConfig = v
	return s
}

type GetKeyGroupInput struct {
	_ struct{} `locationName:"GetKeyGroupRequest" type:"structure"`

	// The identifier of the key group that you are getting. To get the identifier,
	// use ListKeyGroups.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetKeyGroupInput) SetId(v string) *GetKeyGroupInput {
	s.Id = &v
	return s
}

type GetKeyGroupOutput struct {
	_ struct{} `type:"structure" payload:"KeyGroup"`

	// The identifier for this version of the key group.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The key group.
	KeyGroup *KeyGroup `type:"structure"`
}

// String returns the string representation
func (s GetKeyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyGroupOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetKeyGroupOutput) SetETag(v string) *GetKeyGroupOutput {
	s.ETag = &v
	return s
}

// SetKeyGroup sets the KeyGroup field's value.
func (s *GetKeyGroupOutput) SetKeyGroup(v *KeyGroup) *GetKeyGroupOutput {
	s.KeyGroup = v
	return s
}

type GetMonitoringSubscriptionInput struct {
	_ struct{} `locationName:"GetMonitoringSubscriptionRequest" type:"structure"`

	// The ID of the distribution that you are getting metrics information for.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMonitoringSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMonitoringSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMonitoringSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMonitoringSubscriptionInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *GetMonitoringSubscriptionInput) SetDistributionId(v string) *GetMonitoringSubscriptionInput {
	s.DistributionId = &v
	return s
}

type GetMonitoringSubscriptionOutput struct {
	_ struct{} `type:"structure" payload:"MonitoringSubscription"`

	// A monitoring subscription. This structure contains information about whether
	// additional CloudWatch metrics are enabled for a given CloudFront distribution.
	MonitoringSubscription *MonitoringSubscription `type:"structure"`
}

// String returns the string representation
func (s GetMonitoringSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMonitoringSubscriptionOutput) GoString() string {
	return s.String()
}

// SetMonitoringSubscription sets the MonitoringSubscription field's value.
func (s *GetMonitoringSubscriptionOutput) SetMonitoringSubscription(v *MonitoringSubscription) *GetMonitoringSubscriptionOutput {
	s.MonitoringSubscription = v
	return s
}

type GetOriginRequestPolicyConfigInput struct {
	_ struct{} `locationName:"GetOriginRequestPolicyConfigRequest" type:"structure"`

	// The unique identifier for the origin request policy. If the origin request
	// policy is attached to a distribution’s cache behavior, you can get the
	// policy’s identifier using ListDistributions or GetDistribution. If the
	// origin request policy is not attached to a cache behavior, you can get the
	// identifier using ListOriginRequestPolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOriginRequestPolicyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOriginRequestPolicyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOriginRequestPolicyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOriginRequestPolicyConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetOriginRequestPolicyConfigInput) SetId(v string) *GetOriginRequestPolicyConfigInput {
	s.Id = &v
	return s
}

type GetOriginRequestPolicyConfigOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicyConfig"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The origin request policy configuration.
	OriginRequestPolicyConfig *OriginRequestPolicyConfig `type:"structure"`
}

// String returns the string representation
func (s GetOriginRequestPolicyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOriginRequestPolicyConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetOriginRequestPolicyConfigOutput) SetETag(v string) *GetOriginRequestPolicyConfigOutput {
	s.ETag = &v
	return s
}

// SetOriginRequestPolicyConfig sets the OriginRequestPolicyConfig field's value.
func (s *GetOriginRequestPolicyConfigOutput) SetOriginRequestPolicyConfig(v *OriginRequestPolicyConfig) *GetOriginRequestPolicyConfigOutput {
	s.OriginRequestPolicyConfig = v
	return s
}

type GetOriginRequestPolicyInput struct {
	_ struct{} `locationName:"GetOriginRequestPolicyRequest" type:"structure"`

	// The unique identifier for the origin request policy. If the origin request
	// policy is attached to a distribution’s cache behavior, you can get the
	// policy’s identifier using ListDistributions or GetDistribution. If the
	// origin request policy is not attached to a cache behavior, you can get the
	// identifier using ListOriginRequestPolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOriginRequestPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOriginRequestPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOriginRequestPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetOriginRequestPolicyInput) SetId(v string) *GetOriginRequestPolicyInput {
	s.Id = &v
	return s
}

type GetOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicy"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The origin request policy.
	OriginRequestPolicy *OriginRequestPolicy `type:"structure"`
}

// String returns the string representation
func (s GetOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOriginRequestPolicyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetOriginRequestPolicyOutput) SetETag(v string) *GetOriginRequestPolicyOutput {
	s.ETag = &v
	return s
}

// SetOriginRequestPolicy sets the OriginRequestPolicy field's value.
func (s *GetOriginRequestPolicyOutput) SetOriginRequestPolicy(v *OriginRequestPolicy) *GetOriginRequestPolicyOutput {
	s.OriginRequestPolicy = v
	return s
}

type GetPublicKeyConfigInput struct {
	_ struct{} `locationName:"GetPublicKeyConfigRequest" type:"structure"`

	// The identifier of the public key whose configuration you are getting.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicKeyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetPublicKeyConfigInput) SetId(v string) *GetPublicKeyConfigInput {
	s.Id = &v
	return s
}

type GetPublicKeyConfigOutput struct {
	_ struct{} `type:"structure" payload:"PublicKeyConfig"`

	// The identifier for this version of the public key configuration.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// A public key configuration.
	PublicKeyConfig *PublicKeyConfig `type:"structure"`
}

// String returns the string representation
func (s GetPublicKeyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetPublicKeyConfigOutput) SetETag(v string) *GetPublicKeyConfigOutput {
	s.ETag = &v
	return s
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *GetPublicKeyConfigOutput) SetPublicKeyConfig(v *PublicKeyConfig) *GetPublicKeyConfigOutput {
	s.PublicKeyConfig = v
	return s
}

type GetPublicKeyInput struct {
	_ struct{} `locationName:"GetPublicKeyRequest" type:"structure"`

	// The identifier of the public key you are getting.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetPublicKeyInput) SetId(v string) *GetPublicKeyInput {
	s.Id = &v
	return s
}

type GetPublicKeyOutput struct {
	_ struct{} `type:"structure" payload:"PublicKey"`

	// The identifier for this version of the public key.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The public key.
	PublicKey *PublicKey `type:"structure"`
}

// String returns the string representation
func (s GetPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetPublicKeyOutput) SetETag(v string) *GetPublicKeyOutput {
	s.ETag = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GetPublicKeyOutput) SetPublicKey(v *PublicKey) *GetPublicKeyOutput {
	s.PublicKey = v
	return s
}

type GetRealtimeLogConfigInput struct {
	_ struct{} `locationName:"GetRealtimeLogConfigRequest" type:"structure" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The Amazon Resource Name (ARN) of the real-time log configuration to get.
	ARN *string `type:"string"`

	// The name of the real-time log configuration to get.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GetRealtimeLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRealtimeLogConfigInput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *GetRealtimeLogConfigInput) SetARN(v string) *GetRealtimeLogConfigInput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRealtimeLogConfigInput) SetName(v string) *GetRealtimeLogConfigInput {
	s.Name = &v
	return s
}

type GetRealtimeLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A real-time log configuration.
	RealtimeLogConfig *RealtimeLogConfig `type:"structure"`
}

// String returns the string representation
func (s GetRealtimeLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRealtimeLogConfigOutput) GoString() string {
	return s.String()
}

// SetRealtimeLogConfig sets the RealtimeLogConfig field's value.
func (s *GetRealtimeLogConfigOutput) SetRealtimeLogConfig(v *RealtimeLogConfig) *GetRealtimeLogConfigOutput {
	s.RealtimeLogConfig = v
	return s
}

// To request to get a streaming distribution configuration.
type GetStreamingDistributionConfigInput struct {
	_ struct{} `locationName:"GetStreamingDistributionConfigRequest" type:"structure"`

	// The streaming distribution's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingDistributionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingDistributionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetStreamingDistributionConfigInput) SetId(v string) *GetStreamingDistributionConfigInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetStreamingDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfig"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's configuration information.
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetStreamingDistributionConfigOutput) SetETag(v string) *GetStreamingDistributionConfigOutput {
	s.ETag = &v
	return s
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *GetStreamingDistributionConfigOutput) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *GetStreamingDistributionConfigOutput {
	s.StreamingDistributionConfig = v
	return s
}

// The request to get a streaming distribution's information.
type GetStreamingDistributionInput struct {
	_ struct{} `locationName:"GetStreamingDistributionRequest" type:"structure"`

	// The streaming distribution's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetStreamingDistributionInput) SetId(v string) *GetStreamingDistributionInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetStreamingDistributionOutput) SetETag(v string) *GetStreamingDistributionOutput {
	s.ETag = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *GetStreamingDistributionOutput) SetStreamingDistribution(v *StreamingDistribution) *GetStreamingDistributionOutput {
	s.StreamingDistribution = v
	return s
}

// Contains a list of HTTP header names.
type Headers struct {
	_ struct{} `type:"structure"`

	// A list of HTTP header names.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of header names in the Items list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Headers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Headers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Headers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Headers"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Headers) SetItems(v []*string) *Headers {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Headers) SetQuantity(v int64) *Headers {
	s.Quantity = &v
	return s
}

// An invalidation.
type Invalidation struct {
	_ struct{} `type:"structure"`

	// The date and time the invalidation request was first made.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The identifier for the invalidation request. For example: IDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current invalidation information for the batch request.
	//
	// InvalidationBatch is a required field
	InvalidationBatch *InvalidationBatch `type:"structure" required:"true"`

	// The status of the invalidation request. When the invalidation batch is finished,
	// the status is Completed.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Invalidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invalidation) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *Invalidation) SetCreateTime(v time.Time) *Invalidation {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Invalidation) SetId(v string) *Invalidation {
	s.Id = &v
	return s
}

// SetInvalidationBatch sets the InvalidationBatch field's value.
func (s *Invalidation) SetInvalidationBatch(v *InvalidationBatch) *Invalidation {
	s.InvalidationBatch = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Invalidation) SetStatus(v string) *Invalidation {
	s.Status = &v
	return s
}

// An invalidation batch.
type InvalidationBatch struct {
	_ struct{} `type:"structure"`

	// A value that you specify to uniquely identify an invalidation request. CloudFront
	// uses the value to prevent you from accidentally resubmitting an identical
	// request. Whenever you create a new invalidation request, you must specify
	// a new value for CallerReference and change other values in the request as
	// applicable. One way to ensure that the value of CallerReference is unique
	// is to use a timestamp, for example, 20120301090000.
	//
	// If you make a second invalidation request with the same value for CallerReference,
	// and if the rest of the request is the same, CloudFront doesn't create a new
	// invalidation request. Instead, CloudFront returns information about the invalidation
	// request that you previously created with the same CallerReference.
	//
	// If CallerReference is a value you already sent in a previous invalidation
	// batch request but the content of any Path is different from the original
	// request, CloudFront returns an InvalidationBatchAlreadyExists error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// A complex type that contains information about the objects that you want
	// to invalidate. For more information, see Specifying the Objects to Invalidate
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects)
	// in the Amazon CloudFront Developer Guide.
	//
	// Paths is a required field
	Paths *Paths `type:"structure" required:"true"`
}

// String returns the string representation
func (s InvalidationBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationBatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvalidationBatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvalidationBatch"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Paths == nil {
		invalidParams.Add(request.NewErrParamRequired("Paths"))
	}
	if s.Paths != nil {
		if err := s.Paths.Validate(); err != nil {
			invalidParams.AddNested("Paths", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *InvalidationBatch) SetCallerReference(v string) *InvalidationBatch {
	s.CallerReference = &v
	return s
}

// SetPaths sets the Paths field's value.
func (s *InvalidationBatch) SetPaths(v *Paths) *InvalidationBatch {
	s.Paths = v
	return s
}

// The InvalidationList complex type describes the list of invalidation objects.
// For more information about invalidation, see Invalidating Objects (Web Distributions
// Only) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html)
// in the Amazon CloudFront Developer Guide.
type InvalidationList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more invalidation batch requests remain to
	// be listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more invalidation
	// batches in the list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one InvalidationSummary element for each invalidation
	// batch created by the current AWS account.
	Items []*InvalidationSummary `locationNameList:"InvalidationSummary" type:"list"`

	// The value that you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value that
	// you can use for the Marker request parameter to continue listing your invalidation
	// batches where they left off.
	NextMarker *string `type:"string"`

	// The number of invalidation batches that were created by the current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s InvalidationList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *InvalidationList) SetIsTruncated(v bool) *InvalidationList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *InvalidationList) SetItems(v []*InvalidationSummary) *InvalidationList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *InvalidationList) SetMarker(v string) *InvalidationList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *InvalidationList) SetMaxItems(v int64) *InvalidationList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *InvalidationList) SetNextMarker(v string) *InvalidationList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *InvalidationList) SetQuantity(v int64) *InvalidationList {
	s.Quantity = &v
	return s
}

// A summary of an invalidation request.
type InvalidationSummary struct {
	_ struct{} `type:"structure"`

	// The time that an invalidation request was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The unique ID for an invalidation request.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of an invalidation request.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InvalidationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationSummary) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *InvalidationSummary) SetCreateTime(v time.Time) *InvalidationSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *InvalidationSummary) SetId(v string) *InvalidationSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InvalidationSummary) SetStatus(v string) *InvalidationSummary {
	s.Status = &v
	return s
}

// A list of identifiers for the public keys that CloudFront can use to verify
// the signatures of signed URLs and signed cookies.
type KGKeyPairIds struct {
	_ struct{} `type:"structure"`

	// The identifier of the key group that contains the public keys.
	KeyGroupId *string `type:"string"`

	// A list of CloudFront key pair identifiers.
	KeyPairIds *KeyPairIds `type:"structure"`
}

// String returns the string representation
func (s KGKeyPairIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KGKeyPairIds) GoString() string {
	return s.String()
}

// SetKeyGroupId sets the KeyGroupId field's value.
func (s *KGKeyPairIds) SetKeyGroupId(v string) *KGKeyPairIds {
	s.KeyGroupId = &v
	return s
}

// SetKeyPairIds sets the KeyPairIds field's value.
func (s *KGKeyPairIds) SetKeyPairIds(v *KeyPairIds) *KGKeyPairIds {
	s.KeyPairIds = v
	return s
}

// A key group.
//
// A key group contains a list of public keys that you can use with CloudFront
// signed URLs and signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
type KeyGroup struct {
	_ struct{} `type:"structure"`

	// The identifier for the key group.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The key group configuration.
	//
	// KeyGroupConfig is a required field
	KeyGroupConfig *KeyGroupConfig `type:"structure" required:"true"`

	// The date and time when the key group was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s KeyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyGroup) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *KeyGroup) SetId(v string) *KeyGroup {
	s.Id = &v
	return s
}

// SetKeyGroupConfig sets the KeyGroupConfig field's value.
func (s *KeyGroup) SetKeyGroupConfig(v *KeyGroupConfig) *KeyGroup {
	s.KeyGroupConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *KeyGroup) SetLastModifiedTime(v time.Time) *KeyGroup {
	s.LastModifiedTime = &v
	return s
}

// A key group configuration.
//
// A key group contains a list of public keys that you can use with CloudFront
// signed URLs and signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
type KeyGroupConfig struct {
	_ struct{} `type:"structure"`

	// A comment to describe the key group.
	Comment *string `type:"string"`

	// A list of the identifiers of the public keys in the key group.
	//
	// Items is a required field
	Items []*string `locationNameList:"PublicKey" type:"list" required:"true"`

	// A name to identify the key group.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KeyGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyGroupConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyGroupConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyGroupConfig"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *KeyGroupConfig) SetComment(v string) *KeyGroupConfig {
	s.Comment = &v
	return s
}

// SetItems sets the Items field's value.
func (s *KeyGroupConfig) SetItems(v []*string) *KeyGroupConfig {
	s.Items = v
	return s
}

// SetName sets the Name field's value.
func (s *KeyGroupConfig) SetName(v string) *KeyGroupConfig {
	s.Name = &v
	return s
}

// A list of key groups.
type KeyGroupList struct {
	_ struct{} `type:"structure"`

	// A list of key groups.
	Items []*KeyGroupSummary `locationNameList:"KeyGroupSummary" type:"list"`

	// The maximum number of key groups requested.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more items in the list than are in this response, this element
	// is present. It contains the value that you should use in the Marker field
	// of a subsequent request to continue listing key groups.
	NextMarker *string `type:"string"`

	// The number of key groups returned in the response.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s KeyGroupList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyGroupList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *KeyGroupList) SetItems(v []*KeyGroupSummary) *KeyGroupList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *KeyGroupList) SetMaxItems(v int64) *KeyGroupList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *KeyGroupList) SetNextMarker(v string) *KeyGroupList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *KeyGroupList) SetQuantity(v int64) *KeyGroupList {
	s.Quantity = &v
	return s
}

// Contains information about a key group.
type KeyGroupSummary struct {
	_ struct{} `type:"structure"`

	// A key group.
	//
	// KeyGroup is a required field
	KeyGroup *KeyGroup `type:"structure" required:"true"`
}

// String returns the string representation
func (s KeyGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyGroupSummary) GoString() string {
	return s.String()
}

// SetKeyGroup sets the KeyGroup field's value.
func (s *KeyGroupSummary) SetKeyGroup(v *KeyGroup) *KeyGroupSummary {
	s.KeyGroup = v
	return s
}

// A list of CloudFront key pair identifiers.
type KeyPairIds struct {
	_ struct{} `type:"structure"`

	// A list of CloudFront key pair identifiers.
	Items []*string `locationNameList:"KeyPairId" type:"list"`

	// The number of key pair identifiers in the list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s KeyPairIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPairIds) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *KeyPairIds) SetItems(v []*string) *KeyPairIds {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *KeyPairIds) SetQuantity(v int64) *KeyPairIds {
	s.Quantity = &v
	return s
}

// Contains information about the Amazon Kinesis data stream where you are sending
// real-time log data.
type KinesisStreamConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that CloudFront can use to send real-time log data to your Kinesis data
	// stream.
	//
	// For more information the IAM role, see Real-time log configuration IAM role
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role)
	// in the Amazon CloudFront Developer Guide.
	//
	// RoleARN is a required field
	RoleARN *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending
	// real-time log data.
	//
	// StreamARN is a required field
	StreamARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamConfig"}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.StreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamConfig) SetRoleARN(v string) *KinesisStreamConfig {
	s.RoleARN = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *KinesisStreamConfig) SetStreamARN(v string) *KinesisStreamConfig {
	s.StreamARN = &v
	return s
}

// A complex type that contains a Lambda function association.
type LambdaFunctionAssociation struct {
	_ struct{} `type:"structure"`

	// Specifies the event type that triggers a Lambda function invocation. You
	// can specify the following values:
	//
	//    * viewer-request: The function executes when CloudFront receives a request
	//    from a viewer and before it checks to see whether the requested object
	//    is in the edge cache.
	//
	//    * origin-request: The function executes only when CloudFront sends a request
	//    to your origin. When the requested object is in the edge cache, the function
	//    doesn't execute.
	//
	//    * origin-response: The function executes after CloudFront receives a response
	//    from the origin and before it caches the object in the response. When
	//    the requested object is in the edge cache, the function doesn't execute.
	//
	//    * viewer-response: The function executes before CloudFront returns the
	//    requested object to the viewer. The function executes regardless of whether
	//    the object was already in the edge cache. If the origin returns an HTTP
	//    status code other than HTTP 200 (OK), the function doesn't execute.
	//
	// EventType is a required field
	EventType *string `type:"string" required:"true" enum:"EventType"`

	// A flag that allows a Lambda function to have read access to the body content.
	// For more information, see Accessing the Request Body by Choosing the Include
	// Body Option (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html)
	// in the Amazon CloudFront Developer Guide.
	IncludeBody *bool `type:"boolean"`

	// The ARN of the Lambda function. You must specify the ARN of a function version;
	// you can't specify a Lambda alias or $LATEST.
	//
	// LambdaFunctionARN is a required field
	LambdaFunctionARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionAssociation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAssociation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionAssociation"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.LambdaFunctionARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventType sets the EventType field's value.
func (s *LambdaFunctionAssociation) SetEventType(v string) *LambdaFunctionAssociation {
	s.EventType = &v
	return s
}

// SetIncludeBody sets the IncludeBody field's value.
func (s *LambdaFunctionAssociation) SetIncludeBody(v bool) *LambdaFunctionAssociation {
	s.IncludeBody = &v
	return s
}

// SetLambdaFunctionARN sets the LambdaFunctionARN field's value.
func (s *LambdaFunctionAssociation) SetLambdaFunctionARN(v string) *LambdaFunctionAssociation {
	s.LambdaFunctionARN = &v
	return s
}

// A complex type that specifies a list of Lambda functions associations for
// a cache behavior.
//
// If you want to invoke one or more Lambda functions triggered by requests
// that match the PathPattern of the cache behavior, specify the applicable
// values for Quantity and Items. Note that there can be up to 4 LambdaFunctionAssociation
// items in this list (one for each possible value of EventType) and each EventType
// can be associated with the Lambda function only once.
//
// If you don't want to invoke any Lambda functions for the requests that match
// PathPattern, specify 0 for Quantity and omit Items.
type LambdaFunctionAssociations struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains LambdaFunctionAssociation items for
	// this cache behavior. If Quantity is 0, you can omit Items.
	Items []*LambdaFunctionAssociation `locationNameList:"LambdaFunctionAssociation" type:"list"`

	// The number of Lambda function associations for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionAssociations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionAssociations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAssociations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionAssociations"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *LambdaFunctionAssociations) SetItems(v []*LambdaFunctionAssociation) *LambdaFunctionAssociations {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *LambdaFunctionAssociations) SetQuantity(v int64) *LambdaFunctionAssociations {
	s.Quantity = &v
	return s
}

type ListCachePoliciesInput struct {
	_ struct{} `locationName:"ListCachePoliciesRequest" type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of cache policies. The response includes cache policies in the list
	// that occur after the marker. To get the next page of the list, set this field’s
	// value to the value of NextMarker from the current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of cache policies that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// A filter to return only the specified kinds of cache policies. Valid values
	// are:
	//
	//    * managed – Returns only the managed policies created by AWS.
	//
	//    * custom – Returns only the custom policies created in your AWS account.
	Type *string `location:"querystring" locationName:"Type" type:"string" enum:"CachePolicyType"`
}

// String returns the string representation
func (s ListCachePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCachePoliciesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListCachePoliciesInput) SetMarker(v string) *ListCachePoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListCachePoliciesInput) SetMaxItems(v int64) *ListCachePoliciesInput {
	s.MaxItems = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListCachePoliciesInput) SetType(v string) *ListCachePoliciesInput {
	s.Type = &v
	return s
}

type ListCachePoliciesOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicyList"`

	// A list of cache policies.
	CachePolicyList *CachePolicyList `type:"structure"`
}

// String returns the string representation
func (s ListCachePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCachePoliciesOutput) GoString() string {
	return s.String()
}

// SetCachePolicyList sets the CachePolicyList field's value.
func (s *ListCachePoliciesOutput) SetCachePolicyList(v *CachePolicyList) *ListCachePoliciesOutput {
	s.CachePolicyList = v
	return s
}

// The request to list origin access identities.
type ListCloudFrontOriginAccessIdentitiesInput struct {
	_ struct{} `locationName:"ListCloudFrontOriginAccessIdentitiesRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of origin access identities. The results include identities in the list that
	// occur after the marker. To get the next page of results, set the Marker to
	// the value of the NextMarker from the current page's response (which is also
	// the ID of the last identity on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of origin access identities you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListCloudFrontOriginAccessIdentitiesInput) SetMarker(v string) *ListCloudFrontOriginAccessIdentitiesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListCloudFrontOriginAccessIdentitiesInput) SetMaxItems(v int64) *ListCloudFrontOriginAccessIdentitiesInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListCloudFrontOriginAccessIdentitiesOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityList"`

	// The CloudFrontOriginAccessIdentityList type.
	CloudFrontOriginAccessIdentityList *OriginAccessIdentityList `type:"structure"`
}

// String returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentityList sets the CloudFrontOriginAccessIdentityList field's value.
func (s *ListCloudFrontOriginAccessIdentitiesOutput) SetCloudFrontOriginAccessIdentityList(v *OriginAccessIdentityList) *ListCloudFrontOriginAccessIdentitiesOutput {
	s.CloudFrontOriginAccessIdentityList = v
	return s
}

type ListDistributionsByCachePolicyIdInput struct {
	_ struct{} `locationName:"ListDistributionsByCachePolicyIdRequest" type:"structure"`

	// The ID of the cache policy whose associated distribution IDs you want to
	// list.
	//
	// CachePolicyId is a required field
	CachePolicyId *string `location:"uri" locationName:"CachePolicyId" type:"string" required:"true"`

	// Use this field when paginating results to indicate where to begin in your
	// list of distribution IDs. The response includes distribution IDs in the list
	// that occur after the marker. To get the next page of the list, set this field’s
	// value to the value of NextMarker from the current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distribution IDs that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListDistributionsByCachePolicyIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByCachePolicyIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDistributionsByCachePolicyIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDistributionsByCachePolicyIdInput"}
	if s.CachePolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("CachePolicyId"))
	}
	if s.CachePolicyId != nil && len(*s.CachePolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CachePolicyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *ListDistributionsByCachePolicyIdInput) SetCachePolicyId(v string) *ListDistributionsByCachePolicyIdInput {
	s.CachePolicyId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsByCachePolicyIdInput) SetMarker(v string) *ListDistributionsByCachePolicyIdInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsByCachePolicyIdInput) SetMaxItems(v int64) *ListDistributionsByCachePolicyIdInput {
	s.MaxItems = &v
	return s
}

type ListDistributionsByCachePolicyIdOutput struct {
	_ struct{} `type:"structure" payload:"DistributionIdList"`

	// A list of distribution IDs.
	DistributionIdList *DistributionIdList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByCachePolicyIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByCachePolicyIdOutput) GoString() string {
	return s.String()
}

// SetDistributionIdList sets the DistributionIdList field's value.
func (s *ListDistributionsByCachePolicyIdOutput) SetDistributionIdList(v *DistributionIdList) *ListDistributionsByCachePolicyIdOutput {
	s.DistributionIdList = v
	return s
}

type ListDistributionsByKeyGroupInput struct {
	_ struct{} `locationName:"ListDistributionsByKeyGroupRequest" type:"structure"`

	// The ID of the key group whose associated distribution IDs you are listing.
	//
	// KeyGroupId is a required field
	KeyGroupId *string `location:"uri" locationName:"KeyGroupId" type:"string" required:"true"`

	// Use this field when paginating results to indicate where to begin in your
	// list of distribution IDs. The response includes distribution IDs in the list
	// that occur after the marker. To get the next page of the list, set this field’s
	// value to the value of NextMarker from the current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distribution IDs that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListDistributionsByKeyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByKeyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDistributionsByKeyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDistributionsByKeyGroupInput"}
	if s.KeyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyGroupId"))
	}
	if s.KeyGroupId != nil && len(*s.KeyGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyGroupId sets the KeyGroupId field's value.
func (s *ListDistributionsByKeyGroupInput) SetKeyGroupId(v string) *ListDistributionsByKeyGroupInput {
	s.KeyGroupId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsByKeyGroupInput) SetMarker(v string) *ListDistributionsByKeyGroupInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsByKeyGroupInput) SetMaxItems(v int64) *ListDistributionsByKeyGroupInput {
	s.MaxItems = &v
	return s
}

type ListDistributionsByKeyGroupOutput struct {
	_ struct{} `type:"structure" payload:"DistributionIdList"`

	// A list of distribution IDs.
	DistributionIdList *DistributionIdList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByKeyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByKeyGroupOutput) GoString() string {
	return s.String()
}

// SetDistributionIdList sets the DistributionIdList field's value.
func (s *ListDistributionsByKeyGroupOutput) SetDistributionIdList(v *DistributionIdList) *ListDistributionsByKeyGroupOutput {
	s.DistributionIdList = v
	return s
}

type ListDistributionsByOriginRequestPolicyIdInput struct {
	_ struct{} `locationName:"ListDistributionsByOriginRequestPolicyIdRequest" type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of distribution IDs. The response includes distribution IDs in the list
	// that occur after the marker. To get the next page of the list, set this field’s
	// value to the value of NextMarker from the current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distribution IDs that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// The ID of the origin request policy whose associated distribution IDs you
	// want to list.
	//
	// OriginRequestPolicyId is a required field
	OriginRequestPolicyId *string `location:"uri" locationName:"OriginRequestPolicyId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDistributionsByOriginRequestPolicyIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByOriginRequestPolicyIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDistributionsByOriginRequestPolicyIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDistributionsByOriginRequestPolicyIdInput"}
	if s.OriginRequestPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginRequestPolicyId"))
	}
	if s.OriginRequestPolicyId != nil && len(*s.OriginRequestPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginRequestPolicyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsByOriginRequestPolicyIdInput) SetMarker(v string) *ListDistributionsByOriginRequestPolicyIdInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsByOriginRequestPolicyIdInput) SetMaxItems(v int64) *ListDistributionsByOriginRequestPolicyIdInput {
	s.MaxItems = &v
	return s
}

// SetOriginRequestPolicyId sets the OriginRequestPolicyId field's value.
func (s *ListDistributionsByOriginRequestPolicyIdInput) SetOriginRequestPolicyId(v string) *ListDistributionsByOriginRequestPolicyIdInput {
	s.OriginRequestPolicyId = &v
	return s
}

type ListDistributionsByOriginRequestPolicyIdOutput struct {
	_ struct{} `type:"structure" payload:"DistributionIdList"`

	// A list of distribution IDs.
	DistributionIdList *DistributionIdList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByOriginRequestPolicyIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByOriginRequestPolicyIdOutput) GoString() string {
	return s.String()
}

// SetDistributionIdList sets the DistributionIdList field's value.
func (s *ListDistributionsByOriginRequestPolicyIdOutput) SetDistributionIdList(v *DistributionIdList) *ListDistributionsByOriginRequestPolicyIdOutput {
	s.DistributionIdList = v
	return s
}

type ListDistributionsByRealtimeLogConfigInput struct {
	_ struct{} `locationName:"ListDistributionsByRealtimeLogConfigRequest" type:"structure" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// Use this field when paginating results to indicate where to begin in your
	// list of distributions. The response includes distributions in the list that
	// occur after the marker. To get the next page of the list, set this field’s
	// value to the value of NextMarker from the current page’s response.
	Marker *string `type:"string"`

	// The maximum number of distributions that you want in the response.
	MaxItems *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the real-time log configuration whose associated
	// distributions you want to list.
	RealtimeLogConfigArn *string `type:"string"`

	// The name of the real-time log configuration whose associated distributions
	// you want to list.
	RealtimeLogConfigName *string `type:"string"`
}

// String returns the string representation
func (s ListDistributionsByRealtimeLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByRealtimeLogConfigInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsByRealtimeLogConfigInput) SetMarker(v string) *ListDistributionsByRealtimeLogConfigInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsByRealtimeLogConfigInput) SetMaxItems(v int64) *ListDistributionsByRealtimeLogConfigInput {
	s.MaxItems = &v
	return s
}

// SetRealtimeLogConfigArn sets the RealtimeLogConfigArn field's value.
func (s *ListDistributionsByRealtimeLogConfigInput) SetRealtimeLogConfigArn(v string) *ListDistributionsByRealtimeLogConfigInput {
	s.RealtimeLogConfigArn = &v
	return s
}

// SetRealtimeLogConfigName sets the RealtimeLogConfigName field's value.
func (s *ListDistributionsByRealtimeLogConfigInput) SetRealtimeLogConfigName(v string) *ListDistributionsByRealtimeLogConfigInput {
	s.RealtimeLogConfigName = &v
	return s
}

type ListDistributionsByRealtimeLogConfigOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// A distribution list.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByRealtimeLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByRealtimeLogConfigOutput) GoString() string {
	return s.String()
}

// SetDistributionList sets the DistributionList field's value.
func (s *ListDistributionsByRealtimeLogConfigOutput) SetDistributionList(v *DistributionList) *ListDistributionsByRealtimeLogConfigOutput {
	s.DistributionList = v
	return s
}

// The request to list distributions that are associated with a specified AWS
// WAF web ACL.
type ListDistributionsByWebACLIdInput struct {
	_ struct{} `locationName:"ListDistributionsByWebACLIdRequest" type:"structure"`

	// Use Marker and MaxItems to control pagination of results. If you have more
	// than MaxItems distributions that satisfy the request, the response includes
	// a NextMarker element. To get the next page of results, submit another request.
	// For the value of Marker, specify the value of NextMarker from the last response.
	// (For the first request, omit Marker.)
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distributions that you want CloudFront to return in
	// the response body. The maximum and default values are both 100.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// The ID of the AWS WAF web ACL that you want to list the associated distributions.
	// If you specify "null" for the ID, the request returns a list of the distributions
	// that aren't associated with a web ACL.
	//
	// WebACLId is a required field
	WebACLId *string `location:"uri" locationName:"WebACLId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDistributionsByWebACLIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByWebACLIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDistributionsByWebACLIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDistributionsByWebACLIdInput"}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsByWebACLIdInput) SetMarker(v string) *ListDistributionsByWebACLIdInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsByWebACLIdInput) SetMaxItems(v int64) *ListDistributionsByWebACLIdInput {
	s.MaxItems = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *ListDistributionsByWebACLIdInput) SetWebACLId(v string) *ListDistributionsByWebACLIdInput {
	s.WebACLId = &v
	return s
}

// The response to a request to list the distributions that are associated with
// a specified AWS WAF web ACL.
type ListDistributionsByWebACLIdOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// The DistributionList type.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByWebACLIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByWebACLIdOutput) GoString() string {
	return s.String()
}

// SetDistributionList sets the DistributionList field's value.
func (s *ListDistributionsByWebACLIdOutput) SetDistributionList(v *DistributionList) *ListDistributionsByWebACLIdOutput {
	s.DistributionList = v
	return s
}

// The request to list your distributions.
type ListDistributionsInput struct {
	_ struct{} `locationName:"ListDistributionsRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of distributions. The results include distributions in the list that occur
	// after the marker. To get the next page of results, set the Marker to the
	// value of the NextMarker from the current page's response (which is also the
	// ID of the last distribution on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distributions you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListDistributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsInput) SetMarker(v string) *ListDistributionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsInput) SetMaxItems(v int64) *ListDistributionsInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListDistributionsOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// The DistributionList type.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsOutput) GoString() string {
	return s.String()
}

// SetDistributionList sets the DistributionList field's value.
func (s *ListDistributionsOutput) SetDistributionList(v *DistributionList) *ListDistributionsOutput {
	s.DistributionList = v
	return s
}

type ListFieldLevelEncryptionConfigsInput struct {
	_ struct{} `locationName:"ListFieldLevelEncryptionConfigsRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of configurations. The results include configurations in the list that occur
	// after the marker. To get the next page of results, set the Marker to the
	// value of the NextMarker from the current page's response (which is also the
	// ID of the last configuration on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of field-level encryption configurations you want in the
	// response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionConfigsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListFieldLevelEncryptionConfigsInput) SetMarker(v string) *ListFieldLevelEncryptionConfigsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFieldLevelEncryptionConfigsInput) SetMaxItems(v int64) *ListFieldLevelEncryptionConfigsInput {
	s.MaxItems = &v
	return s
}

type ListFieldLevelEncryptionConfigsOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionList"`

	// Returns a list of all field-level encryption configurations that have been
	// created in CloudFront for this account.
	FieldLevelEncryptionList *FieldLevelEncryptionList `type:"structure"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionConfigsOutput) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionList sets the FieldLevelEncryptionList field's value.
func (s *ListFieldLevelEncryptionConfigsOutput) SetFieldLevelEncryptionList(v *FieldLevelEncryptionList) *ListFieldLevelEncryptionConfigsOutput {
	s.FieldLevelEncryptionList = v
	return s
}

type ListFieldLevelEncryptionProfilesInput struct {
	_ struct{} `locationName:"ListFieldLevelEncryptionProfilesRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of profiles. The results include profiles in the list that occur after the
	// marker. To get the next page of results, set the Marker to the value of the
	// NextMarker from the current page's response (which is also the ID of the
	// last profile on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of field-level encryption profiles you want in the response
	// body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionProfilesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListFieldLevelEncryptionProfilesInput) SetMarker(v string) *ListFieldLevelEncryptionProfilesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFieldLevelEncryptionProfilesInput) SetMaxItems(v int64) *ListFieldLevelEncryptionProfilesInput {
	s.MaxItems = &v
	return s
}

type ListFieldLevelEncryptionProfilesOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfileList"`

	// Returns a list of the field-level encryption profiles that have been created
	// in CloudFront for this account.
	FieldLevelEncryptionProfileList *FieldLevelEncryptionProfileList `type:"structure"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionProfilesOutput) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionProfileList sets the FieldLevelEncryptionProfileList field's value.
func (s *ListFieldLevelEncryptionProfilesOutput) SetFieldLevelEncryptionProfileList(v *FieldLevelEncryptionProfileList) *ListFieldLevelEncryptionProfilesOutput {
	s.FieldLevelEncryptionProfileList = v
	return s
}

// The request to list invalidations.
type ListInvalidationsInput struct {
	_ struct{} `locationName:"ListInvalidationsRequest" type:"structure"`

	// The distribution's ID.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// Use this parameter when paginating results to indicate where to begin in
	// your list of invalidation batches. Because the results are returned in decreasing
	// order from most recent to oldest, the most recent results are on the first
	// page, the second page will contain earlier results, and so on. To get the
	// next page of results, set Marker to the value of the NextMarker from the
	// current page's response. This value is the same as the ID of the last invalidation
	// batch on that page.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of invalidation batches that you want in the response
	// body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListInvalidationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvalidationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvalidationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvalidationsInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *ListInvalidationsInput) SetDistributionId(v string) *ListInvalidationsInput {
	s.DistributionId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInvalidationsInput) SetMarker(v string) *ListInvalidationsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListInvalidationsInput) SetMaxItems(v int64) *ListInvalidationsInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListInvalidationsOutput struct {
	_ struct{} `type:"structure" payload:"InvalidationList"`

	// Information about invalidation batches.
	InvalidationList *InvalidationList `type:"structure"`
}

// String returns the string representation
func (s ListInvalidationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvalidationsOutput) GoString() string {
	return s.String()
}

// SetInvalidationList sets the InvalidationList field's value.
func (s *ListInvalidationsOutput) SetInvalidationList(v *InvalidationList) *ListInvalidationsOutput {
	s.InvalidationList = v
	return s
}

type ListKeyGroupsInput struct {
	_ struct{} `locationName:"ListKeyGroupsRequest" type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of key groups. The response includes key groups in the list that occur
	// after the marker. To get the next page of the list, set this field’s value
	// to the value of NextMarker from the current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of key groups that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListKeyGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyGroupsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListKeyGroupsInput) SetMarker(v string) *ListKeyGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListKeyGroupsInput) SetMaxItems(v int64) *ListKeyGroupsInput {
	s.MaxItems = &v
	return s
}

type ListKeyGroupsOutput struct {
	_ struct{} `type:"structure" payload:"KeyGroupList"`

	// A list of key groups.
	KeyGroupList *KeyGroupList `type:"structure"`
}

// String returns the string representation
func (s ListKeyGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyGroupsOutput) GoString() string {
	return s.String()
}

// SetKeyGroupList sets the KeyGroupList field's value.
func (s *ListKeyGroupsOutput) SetKeyGroupList(v *KeyGroupList) *ListKeyGroupsOutput {
	s.KeyGroupList = v
	return s
}

type ListOriginRequestPoliciesInput struct {
	_ struct{} `locationName:"ListOriginRequestPoliciesRequest" type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of origin request policies. The response includes origin request policies
	// in the list that occur after the marker. To get the next page of the list,
	// set this field’s value to the value of NextMarker from the current page’s
	// response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of origin request policies that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// A filter to return only the specified kinds of origin request policies. Valid
	// values are:
	//
	//    * managed – Returns only the managed policies created by AWS.
	//
	//    * custom – Returns only the custom policies created in your AWS account.
	Type *string `location:"querystring" locationName:"Type" type:"string" enum:"OriginRequestPolicyType"`
}

// String returns the string representation
func (s ListOriginRequestPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOriginRequestPoliciesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListOriginRequestPoliciesInput) SetMarker(v string) *ListOriginRequestPoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListOriginRequestPoliciesInput) SetMaxItems(v int64) *ListOriginRequestPoliciesInput {
	s.MaxItems = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListOriginRequestPoliciesInput) SetType(v string) *ListOriginRequestPoliciesInput {
	s.Type = &v
	return s
}

type ListOriginRequestPoliciesOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicyList"`

	// A list of origin request policies.
	OriginRequestPolicyList *OriginRequestPolicyList `type:"structure"`
}

// String returns the string representation
func (s ListOriginRequestPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOriginRequestPoliciesOutput) GoString() string {
	return s.String()
}

// SetOriginRequestPolicyList sets the OriginRequestPolicyList field's value.
func (s *ListOriginRequestPoliciesOutput) SetOriginRequestPolicyList(v *OriginRequestPolicyList) *ListOriginRequestPoliciesOutput {
	s.OriginRequestPolicyList = v
	return s
}

type ListPublicKeysInput struct {
	_ struct{} `locationName:"ListPublicKeysRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of public keys. The results include public keys in the list that occur after
	// the marker. To get the next page of results, set the Marker to the value
	// of the NextMarker from the current page's response (which is also the ID
	// of the last public key on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of public keys you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListPublicKeysInput) SetMarker(v string) *ListPublicKeysInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListPublicKeysInput) SetMaxItems(v int64) *ListPublicKeysInput {
	s.MaxItems = &v
	return s
}

type ListPublicKeysOutput struct {
	_ struct{} `type:"structure" payload:"PublicKeyList"`

	// Returns a list of all public keys that have been added to CloudFront for
	// this account.
	PublicKeyList *PublicKeyList `type:"structure"`
}

// String returns the string representation
func (s ListPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysOutput) GoString() string {
	return s.String()
}

// SetPublicKeyList sets the PublicKeyList field's value.
func (s *ListPublicKeysOutput) SetPublicKeyList(v *PublicKeyList) *ListPublicKeysOutput {
	s.PublicKeyList = v
	return s
}

type ListRealtimeLogConfigsInput struct {
	_ struct{} `locationName:"ListRealtimeLogConfigsRequest" type:"structure"`

	// Use this field when paginating results to indicate where to begin in your
	// list of real-time log configurations. The response includes real-time log
	// configurations in the list that occur after the marker. To get the next page
	// of the list, set this field’s value to the value of NextMarker from the
	// current page’s response.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of real-time log configurations that you want in the response.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListRealtimeLogConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRealtimeLogConfigsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListRealtimeLogConfigsInput) SetMarker(v string) *ListRealtimeLogConfigsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListRealtimeLogConfigsInput) SetMaxItems(v int64) *ListRealtimeLogConfigsInput {
	s.MaxItems = &v
	return s
}

type ListRealtimeLogConfigsOutput struct {
	_ struct{} `type:"structure" payload:"RealtimeLogConfigs"`

	// A list of real-time log configurations.
	RealtimeLogConfigs *RealtimeLogConfigs `type:"structure"`
}

// String returns the string representation
func (s ListRealtimeLogConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRealtimeLogConfigsOutput) GoString() string {
	return s.String()
}

// SetRealtimeLogConfigs sets the RealtimeLogConfigs field's value.
func (s *ListRealtimeLogConfigsOutput) SetRealtimeLogConfigs(v *RealtimeLogConfigs) *ListRealtimeLogConfigsOutput {
	s.RealtimeLogConfigs = v
	return s
}

// The request to list your streaming distributions.
type ListStreamingDistributionsInput struct {
	_ struct{} `locationName:"ListStreamingDistributionsRequest" type:"structure"`

	// The value that you provided for the Marker request parameter.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The value that you provided for the MaxItems request parameter.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListStreamingDistributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamingDistributionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListStreamingDistributionsInput) SetMarker(v string) *ListStreamingDistributionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListStreamingDistributionsInput) SetMaxItems(v int64) *ListStreamingDistributionsInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListStreamingDistributionsOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionList"`

	// The StreamingDistributionList type.
	StreamingDistributionList *StreamingDistributionList `type:"structure"`
}

// String returns the string representation
func (s ListStreamingDistributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamingDistributionsOutput) GoString() string {
	return s.String()
}

// SetStreamingDistributionList sets the StreamingDistributionList field's value.
func (s *ListStreamingDistributionsOutput) SetStreamingDistributionList(v *StreamingDistributionList) *ListStreamingDistributionsOutput {
	s.StreamingDistributionList = v
	return s
}

// The request to list tags for a CloudFront resource.
type ListTagsForResourceInput struct {
	_ struct{} `locationName:"ListTagsForResourceRequest" type:"structure"`

	// An ARN of a CloudFront resource.
	//
	// Resource is a required field
	Resource *string `location:"querystring" locationName:"Resource" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *ListTagsForResourceInput) SetResource(v string) *ListTagsForResourceInput {
	s.Resource = &v
	return s
}

// The returned result of the corresponding request.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure" payload:"Tags"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v *Tags) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A complex type that controls whether access logs are written for the distribution.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a distribution
	// or if you want to disable logging for an existing distribution, specify false
	// for Enabled, and specify empty Bucket and Prefix elements. If you specify
	// false for Enabled but you specify values for Bucket, prefix, and IncludeCookies,
	// the values are automatically deleted.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specifies whether you want CloudFront to include cookies in access logs,
	// specify true for IncludeCookies. If you choose to include cookies in logs,
	// CloudFront logs all cookies regardless of how you configure the cache behaviors
	// for this distribution. If you don't want to include cookies when you create
	// a distribution or if you want to disable include cookies for an existing
	// distribution, specify false for IncludeCookies.
	//
	// IncludeCookies is a required field
	IncludeCookies *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this distribution, for example, myprefix/. If you want to enable logging,
	// but you don't want to specify a prefix, you still must include an empty Prefix
	// element in the Logging element.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfig"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.IncludeCookies == nil {
		invalidParams.Add(request.NewErrParamRequired("IncludeCookies"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *LoggingConfig) SetBucket(v string) *LoggingConfig {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LoggingConfig) SetEnabled(v bool) *LoggingConfig {
	s.Enabled = &v
	return s
}

// SetIncludeCookies sets the IncludeCookies field's value.
func (s *LoggingConfig) SetIncludeCookies(v bool) *LoggingConfig {
	s.IncludeCookies = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LoggingConfig) SetPrefix(v string) *LoggingConfig {
	s.Prefix = &v
	return s
}

// A monitoring subscription. This structure contains information about whether
// additional CloudWatch metrics are enabled for a given CloudFront distribution.
type MonitoringSubscription struct {
	_ struct{} `type:"structure"`

	// A subscription configuration for additional CloudWatch metrics.
	RealtimeMetricsSubscriptionConfig *RealtimeMetricsSubscriptionConfig `type:"structure"`
}

// String returns the string representation
func (s MonitoringSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonitoringSubscription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringSubscription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MonitoringSubscription"}
	if s.RealtimeMetricsSubscriptionConfig != nil {
		if err := s.RealtimeMetricsSubscriptionConfig.Validate(); err != nil {
			invalidParams.AddNested("RealtimeMetricsSubscriptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRealtimeMetricsSubscriptionConfig sets the RealtimeMetricsSubscriptionConfig field's value.
func (s *MonitoringSubscription) SetRealtimeMetricsSubscriptionConfig(v *RealtimeMetricsSubscriptionConfig) *MonitoringSubscription {
	s.RealtimeMetricsSubscriptionConfig = v
	return s
}

// An origin.
//
// An origin is the location where content is stored, and from which CloudFront
// gets content to serve to viewers. To specify an origin:
//
//    * Use S3OriginConfig to specify an Amazon S3 bucket that is not configured
//    with static website hosting.
//
//    * Use CustomOriginConfig to specify all other kinds of origins, including:
//    An Amazon S3 bucket that is configured with static website hosting An
//    Elastic Load Balancing load balancer An AWS Elemental MediaPackage endpoint
//    An AWS Elemental MediaStore container Any other HTTP server, running on
//    an Amazon EC2 instance or any other kind of host
//
// For the current maximum number of origins that you can specify per distribution,
// see General Quotas on Web Distributions (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions)
// in the Amazon CloudFront Developer Guide (quotas were formerly referred to
// as limits).
type Origin struct {
	_ struct{} `type:"structure"`

	// The number of times that CloudFront attempts to connect to the origin. The
	// minimum number is 1, the maximum is 3, and the default (if you don’t specify
	// otherwise) is 3.
	//
	// For a custom origin (including an Amazon S3 bucket that’s configured with
	// static website hosting), this value also specifies the number of times that
	// CloudFront attempts to get a response from the origin, in the case of an
	// Origin Response Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
	//
	// For more information, see Origin Connection Attempts (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts)
	// in the Amazon CloudFront Developer Guide.
	ConnectionAttempts *int64 `type:"integer"`

	// The number of seconds that CloudFront waits when trying to establish a connection
	// to the origin. The minimum timeout is 1 second, the maximum is 10 seconds,
	// and the default (if you don’t specify otherwise) is 10 seconds.
	//
	// For more information, see Origin Connection Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout)
	// in the Amazon CloudFront Developer Guide.
	ConnectionTimeout *int64 `type:"integer"`

	// A list of HTTP header names and values that CloudFront adds to the requests
	// that it sends to the origin.
	//
	// For more information, see Adding Custom Headers to Origin Requests (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html)
	// in the Amazon CloudFront Developer Guide.
	CustomHeaders *CustomHeaders `type:"structure"`

	// Use this type to specify an origin that is not an Amazon S3 bucket, with
	// one exception. If the Amazon S3 bucket is configured with static website
	// hosting, use this type. If the Amazon S3 bucket is not configured with static
	// website hosting, use the S3OriginConfig type instead.
	CustomOriginConfig *CustomOriginConfig `type:"structure"`

	// The domain name for the origin.
	//
	// For more information, see Origin Domain Name (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName)
	// in the Amazon CloudFront Developer Guide.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A unique identifier for the origin. This value must be unique within the
	// distribution.
	//
	// Use this value to specify the TargetOriginId in a CacheBehavior or DefaultCacheBehavior.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An optional path that CloudFront appends to the origin domain name when CloudFront
	// requests content from the origin.
	//
	// For more information, see Origin Path (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath)
	// in the Amazon CloudFront Developer Guide.
	OriginPath *string `type:"string"`

	// CloudFront Origin Shield. Using Origin Shield can help reduce the load on
	// your origin.
	//
	// For more information, see Using Origin Shield (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html)
	// in the Amazon CloudFront Developer Guide.
	OriginShield *OriginShield `type:"structure"`

	// Use this type to specify an origin that is an Amazon S3 bucket that is not
	// configured with static website hosting. To specify any other type of origin,
	// including an Amazon S3 bucket that is configured with static website hosting,
	// use the CustomOriginConfig type instead.
	S3OriginConfig *S3OriginConfig `type:"structure"`
}

// String returns the string representation
func (s Origin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Origin"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.CustomHeaders != nil {
		if err := s.CustomHeaders.Validate(); err != nil {
			invalidParams.AddNested("CustomHeaders", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomOriginConfig != nil {
		if err := s.CustomOriginConfig.Validate(); err != nil {
			invalidParams.AddNested("CustomOriginConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OriginShield != nil {
		if err := s.OriginShield.Validate(); err != nil {
			invalidParams.AddNested("OriginShield", err.(request.ErrInvalidParams))
		}
	}
	if s.S3OriginConfig != nil {
		if err := s.S3OriginConfig.Validate(); err != nil {
			invalidParams.AddNested("S3OriginConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionAttempts sets the ConnectionAttempts field's value.
func (s *Origin) SetConnectionAttempts(v int64) *Origin {
	s.ConnectionAttempts = &v
	return s
}

// SetConnectionTimeout sets the ConnectionTimeout field's value.
func (s *Origin) SetConnectionTimeout(v int64) *Origin {
	s.ConnectionTimeout = &v
	return s
}

// SetCustomHeaders sets the CustomHeaders field's value.
func (s *Origin) SetCustomHeaders(v *CustomHeaders) *Origin {
	s.CustomHeaders = v
	return s
}

// SetCustomOriginConfig sets the CustomOriginConfig field's value.
func (s *Origin) SetCustomOriginConfig(v *CustomOriginConfig) *Origin {
	s.CustomOriginConfig = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *Origin) SetDomainName(v string) *Origin {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Origin) SetId(v string) *Origin {
	s.Id = &v
	return s
}

// SetOriginPath sets the OriginPath field's value.
func (s *Origin) SetOriginPath(v string) *Origin {
	s.OriginPath = &v
	return s
}

// SetOriginShield sets the OriginShield field's value.
func (s *Origin) SetOriginShield(v *OriginShield) *Origin {
	s.OriginShield = v
	return s
}

// SetS3OriginConfig sets the S3OriginConfig field's value.
func (s *Origin) SetS3OriginConfig(v *S3OriginConfig) *Origin {
	s.S3OriginConfig = v
	return s
}

// CloudFront origin access identity.
type OriginAccessIdentity struct {
	_ struct{} `type:"structure"`

	// The current configuration information for the identity.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `type:"structure"`

	// The ID for the origin access identity, for example, E74FTE3AJFJ256A.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, used when
	// giving the origin access identity read permission to an object in Amazon
	// S3.
	//
	// S3CanonicalUserId is a required field
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentity) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *OriginAccessIdentity) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *OriginAccessIdentity {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *OriginAccessIdentity) SetId(v string) *OriginAccessIdentity {
	s.Id = &v
	return s
}

// SetS3CanonicalUserId sets the S3CanonicalUserId field's value.
func (s *OriginAccessIdentity) SetS3CanonicalUserId(v string) *OriginAccessIdentity {
	s.S3CanonicalUserId = &v
	return s
}

// Origin access identity configuration. Send a GET request to the /CloudFront
// API version/CloudFront/identity ID/config resource.
type OriginAccessIdentityConfig struct {
	_ struct{} `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// CloudFrontOriginAccessIdentityConfig object), a new origin access identity
	// is created.
	//
	// If the CallerReference is a value already sent in a previous identity request,
	// and the content of the CloudFrontOriginAccessIdentityConfig is identical
	// to the original request (ignoring white space), the response includes the
	// same information returned to the original request.
	//
	// If the CallerReference is a value you already sent in a previous request
	// to create an identity, but the content of the CloudFrontOriginAccessIdentityConfig
	// is different from the original request, CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the origin access identity.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginAccessIdentityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginAccessIdentityConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *OriginAccessIdentityConfig) SetCallerReference(v string) *OriginAccessIdentityConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *OriginAccessIdentityConfig) SetComment(v string) *OriginAccessIdentityConfig {
	s.Comment = &v
	return s
}

// Lists the origin access identities for CloudFront.Send a GET request to the
// /CloudFront API version/origin-access-identity/cloudfront resource. The response
// includes a CloudFrontOriginAccessIdentityList element with zero or more CloudFrontOriginAccessIdentitySummary
// child elements. By default, your entire list of origin access identities
// is returned in one single page. If the list is long, you can paginate it
// using the MaxItems and Marker parameters.
type OriginAccessIdentityList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more origin access identities remain to be
	// listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more items in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one CloudFrontOriginAccessIdentitySummary element
	// for each origin access identity that was created by the current AWS account.
	Items []*OriginAccessIdentitySummary `locationNameList:"CloudFrontOriginAccessIdentitySummary" type:"list"`

	// Use this when paginating results to indicate where to begin in your list
	// of origin access identities. The results include identities in the list that
	// occur after the marker. To get the next page of results, set the Marker to
	// the value of the NextMarker from the current page's response (which is also
	// the ID of the last identity on that page).
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The maximum number of origin access identities you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your origin
	// access identities where they left off.
	NextMarker *string `type:"string"`

	// The number of CloudFront origin access identities that were created by the
	// current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentityList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentityList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *OriginAccessIdentityList) SetIsTruncated(v bool) *OriginAccessIdentityList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *OriginAccessIdentityList) SetItems(v []*OriginAccessIdentitySummary) *OriginAccessIdentityList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *OriginAccessIdentityList) SetMarker(v string) *OriginAccessIdentityList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *OriginAccessIdentityList) SetMaxItems(v int64) *OriginAccessIdentityList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *OriginAccessIdentityList) SetNextMarker(v string) *OriginAccessIdentityList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginAccessIdentityList) SetQuantity(v int64) *OriginAccessIdentityList {
	s.Quantity = &v
	return s
}

// Summary of the information about a CloudFront origin access identity.
type OriginAccessIdentitySummary struct {
	_ struct{} `type:"structure"`

	// The comment for this origin access identity, as originally specified when
	// created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The ID for the origin access identity. For example: E74FTE3AJFJ256A.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, which you
	// use when giving the origin access identity read permission to an object in
	// Amazon S3.
	//
	// S3CanonicalUserId is a required field
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentitySummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *OriginAccessIdentitySummary) SetComment(v string) *OriginAccessIdentitySummary {
	s.Comment = &v
	return s
}

// SetId sets the Id field's value.
func (s *OriginAccessIdentitySummary) SetId(v string) *OriginAccessIdentitySummary {
	s.Id = &v
	return s
}

// SetS3CanonicalUserId sets the S3CanonicalUserId field's value.
func (s *OriginAccessIdentitySummary) SetS3CanonicalUserId(v string) *OriginAccessIdentitySummary {
	s.S3CanonicalUserId = &v
	return s
}

// A complex type that contains HeaderName and HeaderValue elements, if any,
// for this distribution.
type OriginCustomHeader struct {
	_ struct{} `type:"structure"`

	// The name of a header that you want CloudFront to send to your origin. For
	// more information, see Adding Custom Headers to Origin Requests (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// HeaderName is a required field
	HeaderName *string `type:"string" required:"true"`

	// The value for the header that you specified in the HeaderName field.
	//
	// HeaderValue is a required field
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginCustomHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCustomHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginCustomHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginCustomHeader"}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderName sets the HeaderName field's value.
func (s *OriginCustomHeader) SetHeaderName(v string) *OriginCustomHeader {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *OriginCustomHeader) SetHeaderValue(v string) *OriginCustomHeader {
	s.HeaderValue = &v
	return s
}

// An origin group includes two origins (a primary origin and a second origin
// to failover to) and a failover criteria that you specify. You create an origin
// group to support origin failover in CloudFront. When you create or update
// a distribution, you can specifiy the origin group instead of a single origin,
// and CloudFront will failover from the primary origin to the second origin
// under the failover conditions that you've chosen.
type OriginGroup struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the failover criteria for
	// an origin group.
	//
	// FailoverCriteria is a required field
	FailoverCriteria *OriginGroupFailoverCriteria `type:"structure" required:"true"`

	// The origin group's ID.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex type that contains information about the origins in an origin group.
	//
	// Members is a required field
	Members *OriginGroupMembers `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroup"}
	if s.FailoverCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("FailoverCriteria"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Members == nil {
		invalidParams.Add(request.NewErrParamRequired("Members"))
	}
	if s.FailoverCriteria != nil {
		if err := s.FailoverCriteria.Validate(); err != nil {
			invalidParams.AddNested("FailoverCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.Members != nil {
		if err := s.Members.Validate(); err != nil {
			invalidParams.AddNested("Members", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailoverCriteria sets the FailoverCriteria field's value.
func (s *OriginGroup) SetFailoverCriteria(v *OriginGroupFailoverCriteria) *OriginGroup {
	s.FailoverCriteria = v
	return s
}

// SetId sets the Id field's value.
func (s *OriginGroup) SetId(v string) *OriginGroup {
	s.Id = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *OriginGroup) SetMembers(v *OriginGroupMembers) *OriginGroup {
	s.Members = v
	return s
}

// A complex data type that includes information about the failover criteria
// for an origin group, including the status codes for which CloudFront will
// failover from the primary origin to the second origin.
type OriginGroupFailoverCriteria struct {
	_ struct{} `type:"structure"`

	// The status codes that, when returned from the primary origin, will trigger
	// CloudFront to failover to the second origin.
	//
	// StatusCodes is a required field
	StatusCodes *StatusCodes `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginGroupFailoverCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroupFailoverCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupFailoverCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroupFailoverCriteria"}
	if s.StatusCodes == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCodes"))
	}
	if s.StatusCodes != nil {
		if err := s.StatusCodes.Validate(); err != nil {
			invalidParams.AddNested("StatusCodes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *OriginGroupFailoverCriteria) SetStatusCodes(v *StatusCodes) *OriginGroupFailoverCriteria {
	s.StatusCodes = v
	return s
}

// An origin in an origin group.
type OriginGroupMember struct {
	_ struct{} `type:"structure"`

	// The ID for an origin in an origin group.
	//
	// OriginId is a required field
	OriginId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginGroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroupMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroupMember"}
	if s.OriginId == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginId sets the OriginId field's value.
func (s *OriginGroupMember) SetOriginId(v string) *OriginGroupMember {
	s.OriginId = &v
	return s
}

// A complex data type for the origins included in an origin group.
type OriginGroupMembers struct {
	_ struct{} `type:"structure"`

	// Items (origins) in an origin group.
	//
	// Items is a required field
	Items []*OriginGroupMember `locationNameList:"OriginGroupMember" min:"2" type:"list" required:"true"`

	// The number of origins in an origin group.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginGroupMembers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroupMembers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupMembers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroupMembers"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 2))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *OriginGroupMembers) SetItems(v []*OriginGroupMember) *OriginGroupMembers {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginGroupMembers) SetQuantity(v int64) *OriginGroupMembers {
	s.Quantity = &v
	return s
}

// A complex data type for the origin groups specified for a distribution.
type OriginGroups struct {
	_ struct{} `type:"structure"`

	// The items (origin groups) in a distribution.
	Items []*OriginGroup `locationNameList:"OriginGroup" type:"list"`

	// The number of origin groups.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroups) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroups) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroups"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *OriginGroups) SetItems(v []*OriginGroup) *OriginGroups {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginGroups) SetQuantity(v int64) *OriginGroups {
	s.Quantity = &v
	return s
}

// An origin request policy.
//
// When it’s attached to a cache behavior, the origin request policy determines
// the values that CloudFront includes in requests that it sends to the origin.
// Each request that CloudFront sends to the origin includes the following:
//
//    * The request body and the URL path (without the domain name) from the
//    viewer request.
//
//    * The headers that CloudFront automatically includes in every origin request,
//    including Host, User-Agent, and X-Amz-Cf-Id.
//
//    * All HTTP headers, cookies, and URL query strings that are specified
//    in the cache policy or the origin request policy. These can include items
//    from the viewer request and, in the case of headers, additional ones that
//    are added by CloudFront.
//
// CloudFront sends a request when it can’t find an object in its cache that
// matches the request. If you want to send values to the origin and also include
// them in the cache key, use CachePolicy.
type OriginRequestPolicy struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the origin request policy.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time when the origin request policy was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The origin request policy configuration.
	//
	// OriginRequestPolicyConfig is a required field
	OriginRequestPolicyConfig *OriginRequestPolicyConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginRequestPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicy) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *OriginRequestPolicy) SetId(v string) *OriginRequestPolicy {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *OriginRequestPolicy) SetLastModifiedTime(v time.Time) *OriginRequestPolicy {
	s.LastModifiedTime = &v
	return s
}

// SetOriginRequestPolicyConfig sets the OriginRequestPolicyConfig field's value.
func (s *OriginRequestPolicy) SetOriginRequestPolicyConfig(v *OriginRequestPolicyConfig) *OriginRequestPolicy {
	s.OriginRequestPolicyConfig = v
	return s
}

// An origin request policy configuration.
//
// This configuration determines the values that CloudFront includes in requests
// that it sends to the origin. Each request that CloudFront sends to the origin
// includes the following:
//
//    * The request body and the URL path (without the domain name) from the
//    viewer request.
//
//    * The headers that CloudFront automatically includes in every origin request,
//    including Host, User-Agent, and X-Amz-Cf-Id.
//
//    * All HTTP headers, cookies, and URL query strings that are specified
//    in the cache policy or the origin request policy. These can include items
//    from the viewer request and, in the case of headers, additional ones that
//    are added by CloudFront.
//
// CloudFront sends a request when it can’t find an object in its cache that
// matches the request. If you want to send values to the origin and also include
// them in the cache key, use CachePolicy.
type OriginRequestPolicyConfig struct {
	_ struct{} `type:"structure"`

	// A comment to describe the origin request policy.
	Comment *string `type:"string"`

	// The cookies from viewer requests to include in origin requests.
	//
	// CookiesConfig is a required field
	CookiesConfig *OriginRequestPolicyCookiesConfig `type:"structure" required:"true"`

	// The HTTP headers to include in origin requests. These can include headers
	// from viewer requests and additional headers added by CloudFront.
	//
	// HeadersConfig is a required field
	HeadersConfig *OriginRequestPolicyHeadersConfig `type:"structure" required:"true"`

	// A unique name to identify the origin request policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The URL query strings from viewer requests to include in origin requests.
	//
	// QueryStringsConfig is a required field
	QueryStringsConfig *OriginRequestPolicyQueryStringsConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginRequestPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginRequestPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginRequestPolicyConfig"}
	if s.CookiesConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CookiesConfig"))
	}
	if s.HeadersConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HeadersConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.QueryStringsConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryStringsConfig"))
	}
	if s.CookiesConfig != nil {
		if err := s.CookiesConfig.Validate(); err != nil {
			invalidParams.AddNested("CookiesConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HeadersConfig != nil {
		if err := s.HeadersConfig.Validate(); err != nil {
			invalidParams.AddNested("HeadersConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryStringsConfig != nil {
		if err := s.QueryStringsConfig.Validate(); err != nil {
			invalidParams.AddNested("QueryStringsConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *OriginRequestPolicyConfig) SetComment(v string) *OriginRequestPolicyConfig {
	s.Comment = &v
	return s
}

// SetCookiesConfig sets the CookiesConfig field's value.
func (s *OriginRequestPolicyConfig) SetCookiesConfig(v *OriginRequestPolicyCookiesConfig) *OriginRequestPolicyConfig {
	s.CookiesConfig = v
	return s
}

// SetHeadersConfig sets the HeadersConfig field's value.
func (s *OriginRequestPolicyConfig) SetHeadersConfig(v *OriginRequestPolicyHeadersConfig) *OriginRequestPolicyConfig {
	s.HeadersConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *OriginRequestPolicyConfig) SetName(v string) *OriginRequestPolicyConfig {
	s.Name = &v
	return s
}

// SetQueryStringsConfig sets the QueryStringsConfig field's value.
func (s *OriginRequestPolicyConfig) SetQueryStringsConfig(v *OriginRequestPolicyQueryStringsConfig) *OriginRequestPolicyConfig {
	s.QueryStringsConfig = v
	return s
}

// An object that determines whether any cookies in viewer requests (and if
// so, which cookies) are included in requests that CloudFront sends to the
// origin.
type OriginRequestPolicyCookiesConfig struct {
	_ struct{} `type:"structure"`

	// Determines whether cookies in viewer requests are included in requests that
	// CloudFront sends to the origin. Valid values are:
	//
	//    * none – Cookies in viewer requests are not included in requests that
	//    CloudFront sends to the origin. Even when this field is set to none, any
	//    cookies that are listed in a CachePolicy are included in origin requests.
	//
	//    * whitelist – The cookies in viewer requests that are listed in the
	//    CookieNames type are included in requests that CloudFront sends to the
	//    origin.
	//
	//    * all – All cookies in viewer requests are included in requests that
	//    CloudFront sends to the origin.
	//
	// CookieBehavior is a required field
	CookieBehavior *string `type:"string" required:"true" enum:"OriginRequestPolicyCookieBehavior"`

	// Contains a list of cookie names.
	Cookies *CookieNames `type:"structure"`
}

// String returns the string representation
func (s OriginRequestPolicyCookiesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicyCookiesConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginRequestPolicyCookiesConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginRequestPolicyCookiesConfig"}
	if s.CookieBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("CookieBehavior"))
	}
	if s.Cookies != nil {
		if err := s.Cookies.Validate(); err != nil {
			invalidParams.AddNested("Cookies", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCookieBehavior sets the CookieBehavior field's value.
func (s *OriginRequestPolicyCookiesConfig) SetCookieBehavior(v string) *OriginRequestPolicyCookiesConfig {
	s.CookieBehavior = &v
	return s
}

// SetCookies sets the Cookies field's value.
func (s *OriginRequestPolicyCookiesConfig) SetCookies(v *CookieNames) *OriginRequestPolicyCookiesConfig {
	s.Cookies = v
	return s
}

// An object that determines whether any HTTP headers (and if so, which headers)
// are included in requests that CloudFront sends to the origin.
type OriginRequestPolicyHeadersConfig struct {
	_ struct{} `type:"structure"`

	// Determines whether any HTTP headers are included in requests that CloudFront
	// sends to the origin. Valid values are:
	//
	//    * none – HTTP headers are not included in requests that CloudFront sends
	//    to the origin. Even when this field is set to none, any headers that are
	//    listed in a CachePolicy are included in origin requests.
	//
	//    * whitelist – The HTTP headers that are listed in the Headers type are
	//    included in requests that CloudFront sends to the origin.
	//
	//    * allViewer – All HTTP headers in viewer requests are included in requests
	//    that CloudFront sends to the origin.
	//
	//    * allViewerAndWhitelistCloudFront – All HTTP headers in viewer requests
	//    and the additional CloudFront headers that are listed in the Headers type
	//    are included in requests that CloudFront sends to the origin. The additional
	//    headers are added by CloudFront.
	//
	// HeaderBehavior is a required field
	HeaderBehavior *string `type:"string" required:"true" enum:"OriginRequestPolicyHeaderBehavior"`

	// Contains a list of HTTP header names.
	Headers *Headers `type:"structure"`
}

// String returns the string representation
func (s OriginRequestPolicyHeadersConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicyHeadersConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginRequestPolicyHeadersConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginRequestPolicyHeadersConfig"}
	if s.HeaderBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderBehavior"))
	}
	if s.Headers != nil {
		if err := s.Headers.Validate(); err != nil {
			invalidParams.AddNested("Headers", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderBehavior sets the HeaderBehavior field's value.
func (s *OriginRequestPolicyHeadersConfig) SetHeaderBehavior(v string) *OriginRequestPolicyHeadersConfig {
	s.HeaderBehavior = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *OriginRequestPolicyHeadersConfig) SetHeaders(v *Headers) *OriginRequestPolicyHeadersConfig {
	s.Headers = v
	return s
}

// A list of origin request policies.
type OriginRequestPolicyList struct {
	_ struct{} `type:"structure"`

	// Contains the origin request policies in the list.
	Items []*OriginRequestPolicySummary `locationNameList:"OriginRequestPolicySummary" type:"list"`

	// The maximum number of origin request policies requested.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more items in the list than are in this response, this element
	// is present. It contains the value that you should use in the Marker field
	// of a subsequent request to continue listing origin request policies where
	// you left off.
	NextMarker *string `type:"string"`

	// The total number of origin request policies returned in the response.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginRequestPolicyList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicyList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *OriginRequestPolicyList) SetItems(v []*OriginRequestPolicySummary) *OriginRequestPolicyList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *OriginRequestPolicyList) SetMaxItems(v int64) *OriginRequestPolicyList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *OriginRequestPolicyList) SetNextMarker(v string) *OriginRequestPolicyList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginRequestPolicyList) SetQuantity(v int64) *OriginRequestPolicyList {
	s.Quantity = &v
	return s
}

// An object that determines whether any URL query strings in viewer requests
// (and if so, which query strings) are included in requests that CloudFront
// sends to the origin.
type OriginRequestPolicyQueryStringsConfig struct {
	_ struct{} `type:"structure"`

	// Determines whether any URL query strings in viewer requests are included
	// in requests that CloudFront sends to the origin. Valid values are:
	//
	//    * none – Query strings in viewer requests are not included in requests
	//    that CloudFront sends to the origin. Even when this field is set to none,
	//    any query strings that are listed in a CachePolicy are included in origin
	//    requests.
	//
	//    * whitelist – The query strings in viewer requests that are listed in
	//    the QueryStringNames type are included in requests that CloudFront sends
	//    to the origin.
	//
	//    * all – All query strings in viewer requests are included in requests
	//    that CloudFront sends to the origin.
	//
	// QueryStringBehavior is a required field
	QueryStringBehavior *string `type:"string" required:"true" enum:"OriginRequestPolicyQueryStringBehavior"`

	// Contains a list of the query strings in viewer requests that are included
	// in requests that CloudFront sends to the origin.
	QueryStrings *QueryStringNames `type:"structure"`
}

// String returns the string representation
func (s OriginRequestPolicyQueryStringsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicyQueryStringsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginRequestPolicyQueryStringsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginRequestPolicyQueryStringsConfig"}
	if s.QueryStringBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryStringBehavior"))
	}
	if s.QueryStrings != nil {
		if err := s.QueryStrings.Validate(); err != nil {
			invalidParams.AddNested("QueryStrings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryStringBehavior sets the QueryStringBehavior field's value.
func (s *OriginRequestPolicyQueryStringsConfig) SetQueryStringBehavior(v string) *OriginRequestPolicyQueryStringsConfig {
	s.QueryStringBehavior = &v
	return s
}

// SetQueryStrings sets the QueryStrings field's value.
func (s *OriginRequestPolicyQueryStringsConfig) SetQueryStrings(v *QueryStringNames) *OriginRequestPolicyQueryStringsConfig {
	s.QueryStrings = v
	return s
}

// Contains an origin request policy.
type OriginRequestPolicySummary struct {
	_ struct{} `type:"structure"`

	// The origin request policy.
	//
	// OriginRequestPolicy is a required field
	OriginRequestPolicy *OriginRequestPolicy `type:"structure" required:"true"`

	// The type of origin request policy, either managed (created by AWS) or custom
	// (created in this AWS account).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"OriginRequestPolicyType"`
}

// String returns the string representation
func (s OriginRequestPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRequestPolicySummary) GoString() string {
	return s.String()
}

// SetOriginRequestPolicy sets the OriginRequestPolicy field's value.
func (s *OriginRequestPolicySummary) SetOriginRequestPolicy(v *OriginRequestPolicy) *OriginRequestPolicySummary {
	s.OriginRequestPolicy = v
	return s
}

// SetType sets the Type field's value.
func (s *OriginRequestPolicySummary) SetType(v string) *OriginRequestPolicySummary {
	s.Type = &v
	return s
}

// CloudFront Origin Shield.
//
// Using Origin Shield can help reduce the load on your origin. For more information,
// see Using Origin Shield (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html)
// in the Amazon CloudFront Developer Guide.
type OriginShield struct {
	_ struct{} `type:"structure"`

	// A flag that specifies whether Origin Shield is enabled.
	//
	// When it’s enabled, CloudFront routes all requests through Origin Shield,
	// which can help protect your origin. When it’s disabled, CloudFront might
	// send requests directly to your origin from multiple edge locations or regional
	// edge caches.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The AWS Region for Origin Shield.
	//
	// Specify the AWS Region that has the lowest latency to your origin. To specify
	// a region, use the region code, not the region name. For example, specify
	// the US East (Ohio) region as us-east-2.
	//
	// When you enable CloudFront Origin Shield, you must specify the AWS Region
	// for Origin Shield. For the list of AWS Regions that you can specify, and
	// for help choosing the best Region for your origin, see Choosing the AWS Region
	// for Origin Shield (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region)
	// in the Amazon CloudFront Developer Guide.
	OriginShieldRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OriginShield) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginShield) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginShield) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginShield"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.OriginShieldRegion != nil && len(*s.OriginShieldRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginShieldRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *OriginShield) SetEnabled(v bool) *OriginShield {
	s.Enabled = &v
	return s
}

// SetOriginShieldRegion sets the OriginShieldRegion field's value.
func (s *OriginShield) SetOriginShieldRegion(v string) *OriginShield {
	s.OriginShieldRegion = &v
	return s
}

// A complex type that contains information about the SSL/TLS protocols that
// CloudFront can use when establishing an HTTPS connection with your origin.
type OriginSslProtocols struct {
	_ struct{} `type:"structure"`

	// A list that contains allowed SSL/TLS protocols for this distribution.
	//
	// Items is a required field
	Items []*string `locationNameList:"SslProtocol" type:"list" required:"true"`

	// The number of SSL/TLS protocols that you want to allow CloudFront to use
	// when establishing an HTTPS connection with this origin.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginSslProtocols) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSslProtocols) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginSslProtocols) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginSslProtocols"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *OriginSslProtocols) SetItems(v []*string) *OriginSslProtocols {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginSslProtocols) SetQuantity(v int64) *OriginSslProtocols {
	s.Quantity = &v
	return s
}

// Contains information about the origins for this distribution.
type Origins struct {
	_ struct{} `type:"structure"`

	// A list of origins.
	//
	// Items is a required field
	Items []*Origin `locationNameList:"Origin" min:"1" type:"list" required:"true"`

	// The number of origins for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Origins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origins) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origins) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Origins"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 1))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Origins) SetItems(v []*Origin) *Origins {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Origins) SetQuantity(v int64) *Origins {
	s.Quantity = &v
	return s
}

// This object determines the values that CloudFront includes in the cache key.
// These values can include HTTP headers, cookies, and URL query strings. CloudFront
// uses the cache key to find an object in its cache that it can return to the
// viewer.
//
// The headers, cookies, and query strings that are included in the cache key
// are automatically included in requests that CloudFront sends to the origin.
// CloudFront sends a request when it can’t find an object in its cache that
// matches the request’s cache key. If you want to send values to the origin
// but not include them in the cache key, use OriginRequestPolicy.
type ParametersInCacheKeyAndForwardedToOrigin struct {
	_ struct{} `type:"structure"`

	// An object that determines whether any cookies in viewer requests (and if
	// so, which cookies) are included in the cache key and automatically included
	// in requests that CloudFront sends to the origin.
	//
	// CookiesConfig is a required field
	CookiesConfig *CachePolicyCookiesConfig `type:"structure" required:"true"`

	// A flag that can affect whether the Accept-Encoding HTTP header is included
	// in the cache key and included in requests that CloudFront sends to the origin.
	//
	// This field is related to the EnableAcceptEncodingGzip field. If one or both
	// of these fields is true and the viewer request includes the Accept-Encoding
	// header, then CloudFront does the following:
	//
	//    * Normalizes the value of the viewer’s Accept-Encoding header
	//
	//    * Includes the normalized header in the cache key
	//
	//    * Includes the normalized header in the request to the origin, if a request
	//    is necessary
	//
	// For more information, see Compression support (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you set this value to true, and this cache behavior also has an origin
	// request policy attached, do not include the Accept-Encoding header in the
	// origin request policy. CloudFront always includes the Accept-Encoding header
	// in origin requests when the value of this field is true, so including this
	// header in an origin request policy has no effect.
	//
	// If both of these fields are false, then CloudFront treats the Accept-Encoding
	// header the same as any other HTTP header in the viewer request. By default,
	// it’s not included in the cache key and it’s not included in origin requests.
	// In this case, you can manually add Accept-Encoding to the headers whitelist
	// like any other HTTP header.
	EnableAcceptEncodingBrotli *bool `type:"boolean"`

	// A flag that can affect whether the Accept-Encoding HTTP header is included
	// in the cache key and included in requests that CloudFront sends to the origin.
	//
	// This field is related to the EnableAcceptEncodingBrotli field. If one or
	// both of these fields is true and the viewer request includes the Accept-Encoding
	// header, then CloudFront does the following:
	//
	//    * Normalizes the value of the viewer’s Accept-Encoding header
	//
	//    * Includes the normalized header in the cache key
	//
	//    * Includes the normalized header in the request to the origin, if a request
	//    is necessary
	//
	// For more information, see Compression support (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you set this value to true, and this cache behavior also has an origin
	// request policy attached, do not include the Accept-Encoding header in the
	// origin request policy. CloudFront always includes the Accept-Encoding header
	// in origin requests when the value of this field is true, so including this
	// header in an origin request policy has no effect.
	//
	// If both of these fields are false, then CloudFront treats the Accept-Encoding
	// header the same as any other HTTP header in the viewer request. By default,
	// it’s not included in the cache key and it’s not included in origin requests.
	// In this case, you can manually add Accept-Encoding to the headers whitelist
	// like any other HTTP header.
	//
	// EnableAcceptEncodingGzip is a required field
	EnableAcceptEncodingGzip *bool `type:"boolean" required:"true"`

	// An object that determines whether any HTTP headers (and if so, which headers)
	// are included in the cache key and automatically included in requests that
	// CloudFront sends to the origin.
	//
	// HeadersConfig is a required field
	HeadersConfig *CachePolicyHeadersConfig `type:"structure" required:"true"`

	// An object that determines whether any URL query strings in viewer requests
	// (and if so, which query strings) are included in the cache key and automatically
	// included in requests that CloudFront sends to the origin.
	//
	// QueryStringsConfig is a required field
	QueryStringsConfig *CachePolicyQueryStringsConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s ParametersInCacheKeyAndForwardedToOrigin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParametersInCacheKeyAndForwardedToOrigin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParametersInCacheKeyAndForwardedToOrigin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParametersInCacheKeyAndForwardedToOrigin"}
	if s.CookiesConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CookiesConfig"))
	}
	if s.EnableAcceptEncodingGzip == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableAcceptEncodingGzip"))
	}
	if s.HeadersConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HeadersConfig"))
	}
	if s.QueryStringsConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryStringsConfig"))
	}
	if s.CookiesConfig != nil {
		if err := s.CookiesConfig.Validate(); err != nil {
			invalidParams.AddNested("CookiesConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HeadersConfig != nil {
		if err := s.HeadersConfig.Validate(); err != nil {
			invalidParams.AddNested("HeadersConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryStringsConfig != nil {
		if err := s.QueryStringsConfig.Validate(); err != nil {
			invalidParams.AddNested("QueryStringsConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCookiesConfig sets the CookiesConfig field's value.
func (s *ParametersInCacheKeyAndForwardedToOrigin) SetCookiesConfig(v *CachePolicyCookiesConfig) *ParametersInCacheKeyAndForwardedToOrigin {
	s.CookiesConfig = v
	return s
}

// SetEnableAcceptEncodingBrotli sets the EnableAcceptEncodingBrotli field's value.
func (s *ParametersInCacheKeyAndForwardedToOrigin) SetEnableAcceptEncodingBrotli(v bool) *ParametersInCacheKeyAndForwardedToOrigin {
	s.EnableAcceptEncodingBrotli = &v
	return s
}

// SetEnableAcceptEncodingGzip sets the EnableAcceptEncodingGzip field's value.
func (s *ParametersInCacheKeyAndForwardedToOrigin) SetEnableAcceptEncodingGzip(v bool) *ParametersInCacheKeyAndForwardedToOrigin {
	s.EnableAcceptEncodingGzip = &v
	return s
}

// SetHeadersConfig sets the HeadersConfig field's value.
func (s *ParametersInCacheKeyAndForwardedToOrigin) SetHeadersConfig(v *CachePolicyHeadersConfig) *ParametersInCacheKeyAndForwardedToOrigin {
	s.HeadersConfig = v
	return s
}

// SetQueryStringsConfig sets the QueryStringsConfig field's value.
func (s *ParametersInCacheKeyAndForwardedToOrigin) SetQueryStringsConfig(v *CachePolicyQueryStringsConfig) *ParametersInCacheKeyAndForwardedToOrigin {
	s.QueryStringsConfig = v
	return s
}

// A complex type that contains information about the objects that you want
// to invalidate. For more information, see Specifying the Objects to Invalidate
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects)
// in the Amazon CloudFront Developer Guide.
type Paths struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a list of the paths that you want to invalidate.
	Items []*string `locationNameList:"Path" type:"list"`

	// The number of invalidation paths specified for the objects that you want
	// to invalidate.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Paths) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Paths) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Paths) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Paths"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Paths) SetItems(v []*string) *Paths {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Paths) SetQuantity(v int64) *Paths {
	s.Quantity = &v
	return s
}

// A public key that you can use with signed URLs and signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
// or with field-level encryption (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
type PublicKey struct {
	_ struct{} `type:"structure"`

	// The date and time when the public key was uploaded.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The identifier of the public key.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Configuration information about a public key that you can use with signed
	// URLs and signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
	// or with field-level encryption (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKey) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PublicKey) SetCreatedTime(v time.Time) *PublicKey {
	s.CreatedTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *PublicKey) SetId(v string) *PublicKey {
	s.Id = &v
	return s
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *PublicKey) SetPublicKeyConfig(v *PublicKeyConfig) *PublicKey {
	s.PublicKeyConfig = v
	return s
}

// Configuration information about a public key that you can use with signed
// URLs and signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
// or with field-level encryption (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
type PublicKeyConfig struct {
	_ struct{} `type:"structure"`

	// A string included in the request to help make sure that the request can’t
	// be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// A comment to describe the public key.
	Comment *string `type:"string"`

	// The public key that you can use with signed URLs and signed cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
	// or with field-level encryption (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
	//
	// EncodedKey is a required field
	EncodedKey *string `type:"string" required:"true"`

	// A name to help identify the public key.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PublicKeyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKeyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublicKeyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublicKeyConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.EncodedKey == nil {
		invalidParams.Add(request.NewErrParamRequired("EncodedKey"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *PublicKeyConfig) SetCallerReference(v string) *PublicKeyConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *PublicKeyConfig) SetComment(v string) *PublicKeyConfig {
	s.Comment = &v
	return s
}

// SetEncodedKey sets the EncodedKey field's value.
func (s *PublicKeyConfig) SetEncodedKey(v string) *PublicKeyConfig {
	s.EncodedKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublicKeyConfig) SetName(v string) *PublicKeyConfig {
	s.Name = &v
	return s
}

// A list of public keys that you can use with signed URLs and signed cookies
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html),
// or with field-level encryption (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
type PublicKeyList struct {
	_ struct{} `type:"structure"`

	// A list of public keys.
	Items []*PublicKeySummary `locationNameList:"PublicKeySummary" type:"list"`

	// The maximum number of public keys you want in the response.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your public keys where you left off.
	NextMarker *string `type:"string"`

	// The number of public keys in the list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PublicKeyList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKeyList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *PublicKeyList) SetItems(v []*PublicKeySummary) *PublicKeyList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *PublicKeyList) SetMaxItems(v int64) *PublicKeyList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *PublicKeyList) SetNextMarker(v string) *PublicKeyList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *PublicKeyList) SetQuantity(v int64) *PublicKeyList {
	s.Quantity = &v
	return s
}

// Contains information about a public key.
type PublicKeySummary struct {
	_ struct{} `type:"structure"`

	// A comment to describe the public key.
	Comment *string `type:"string"`

	// The date and time when the public key was uploaded.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The public key.
	//
	// EncodedKey is a required field
	EncodedKey *string `type:"string" required:"true"`

	// The identifier of the public key.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A name to help identify the public key.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PublicKeySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKeySummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *PublicKeySummary) SetComment(v string) *PublicKeySummary {
	s.Comment = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PublicKeySummary) SetCreatedTime(v time.Time) *PublicKeySummary {
	s.CreatedTime = &v
	return s
}

// SetEncodedKey sets the EncodedKey field's value.
func (s *PublicKeySummary) SetEncodedKey(v string) *PublicKeySummary {
	s.EncodedKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *PublicKeySummary) SetId(v string) *PublicKeySummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublicKeySummary) SetName(v string) *PublicKeySummary {
	s.Name = &v
	return s
}

// Query argument-profile mapping for field-level encryption.
type QueryArgProfile struct {
	_ struct{} `type:"structure"`

	// ID of profile to use for field-level encryption query argument-profile mapping
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// Query argument for field-level encryption query argument-profile mapping.
	//
	// QueryArg is a required field
	QueryArg *string `type:"string" required:"true"`
}

// String returns the string representation
func (s QueryArgProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryArgProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryArgProfile"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.QueryArg == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryArg"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *QueryArgProfile) SetProfileId(v string) *QueryArgProfile {
	s.ProfileId = &v
	return s
}

// SetQueryArg sets the QueryArg field's value.
func (s *QueryArgProfile) SetQueryArg(v string) *QueryArgProfile {
	s.QueryArg = &v
	return s
}

// Configuration for query argument-profile mapping for field-level encryption.
type QueryArgProfileConfig struct {
	_ struct{} `type:"structure"`

	// Flag to set if you want a request to be forwarded to the origin even if the
	// profile specified by the field-level encryption query argument, fle-profile,
	// is unknown.
	//
	// ForwardWhenQueryArgProfileIsUnknown is a required field
	ForwardWhenQueryArgProfileIsUnknown *bool `type:"boolean" required:"true"`

	// Profiles specified for query argument-profile mapping for field-level encryption.
	QueryArgProfiles *QueryArgProfiles `type:"structure"`
}

// String returns the string representation
func (s QueryArgProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryArgProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryArgProfileConfig"}
	if s.ForwardWhenQueryArgProfileIsUnknown == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardWhenQueryArgProfileIsUnknown"))
	}
	if s.QueryArgProfiles != nil {
		if err := s.QueryArgProfiles.Validate(); err != nil {
			invalidParams.AddNested("QueryArgProfiles", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForwardWhenQueryArgProfileIsUnknown sets the ForwardWhenQueryArgProfileIsUnknown field's value.
func (s *QueryArgProfileConfig) SetForwardWhenQueryArgProfileIsUnknown(v bool) *QueryArgProfileConfig {
	s.ForwardWhenQueryArgProfileIsUnknown = &v
	return s
}

// SetQueryArgProfiles sets the QueryArgProfiles field's value.
func (s *QueryArgProfileConfig) SetQueryArgProfiles(v *QueryArgProfiles) *QueryArgProfileConfig {
	s.QueryArgProfiles = v
	return s
}

// Query argument-profile mapping for field-level encryption.
type QueryArgProfiles struct {
	_ struct{} `type:"structure"`

	// Number of items for query argument-profile mapping for field-level encryption.
	Items []*QueryArgProfile `locationNameList:"QueryArgProfile" type:"list"`

	// Number of profiles for query argument-profile mapping for field-level encryption.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryArgProfiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryArgProfiles) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfiles) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryArgProfiles"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *QueryArgProfiles) SetItems(v []*QueryArgProfile) *QueryArgProfiles {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *QueryArgProfiles) SetQuantity(v int64) *QueryArgProfiles {
	s.Quantity = &v
	return s
}

// This field is deprecated. We recommend that you use a cache policy or an
// origin request policy instead of this field.
//
// If you want to include query strings in the cache key, use QueryStringsConfig
// in a cache policy. See CachePolicy.
//
// If you want to send query strings to the origin but not include them in the
// cache key, use QueryStringsConfig in an origin request policy. See OriginRequestPolicy.
//
// A complex type that contains information about the query string parameters
// that you want CloudFront to use for caching for a cache behavior.
type QueryStringCacheKeys struct {
	_ struct{} `type:"structure"`

	// A list that contains the query string parameters that you want CloudFront
	// to use as a basis for caching for a cache behavior. If Quantity is 0, you
	// can omit Items.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of whitelisted query string parameters for a cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryStringCacheKeys) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringCacheKeys) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryStringCacheKeys) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryStringCacheKeys"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *QueryStringCacheKeys) SetItems(v []*string) *QueryStringCacheKeys {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *QueryStringCacheKeys) SetQuantity(v int64) *QueryStringCacheKeys {
	s.Quantity = &v
	return s
}

// Contains a list of query string names.
type QueryStringNames struct {
	_ struct{} `type:"structure"`

	// A list of query string names.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of query string names in the Items list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryStringNames) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringNames) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryStringNames) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryStringNames"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *QueryStringNames) SetItems(v []*string) *QueryStringNames {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *QueryStringNames) SetQuantity(v int64) *QueryStringNames {
	s.Quantity = &v
	return s
}

// A real-time log configuration.
type RealtimeLogConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this real-time log configuration.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// Contains information about the Amazon Kinesis data stream where you are sending
	// real-time log data for this real-time log configuration.
	//
	// EndPoints is a required field
	EndPoints []*EndPoint `type:"list" required:"true"`

	// A list of fields that are included in each real-time log record. In an API
	// response, the fields are provided in the same order in which they are sent
	// to the Amazon Kinesis data stream.
	//
	// For more information about fields, see Real-time log configuration fields
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
	// in the Amazon CloudFront Developer Guide.
	//
	// Fields is a required field
	Fields []*string `locationNameList:"Field" type:"list" required:"true"`

	// The unique name of this real-time log configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The sampling rate for this real-time log configuration. The sampling rate
	// determines the percentage of viewer requests that are represented in the
	// real-time log data. The sampling rate is an integer between 1 and 100, inclusive.
	//
	// SamplingRate is a required field
	SamplingRate *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s RealtimeLogConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RealtimeLogConfig) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RealtimeLogConfig) SetARN(v string) *RealtimeLogConfig {
	s.ARN = &v
	return s
}

// SetEndPoints sets the EndPoints field's value.
func (s *RealtimeLogConfig) SetEndPoints(v []*EndPoint) *RealtimeLogConfig {
	s.EndPoints = v
	return s
}

// SetFields sets the Fields field's value.
func (s *RealtimeLogConfig) SetFields(v []*string) *RealtimeLogConfig {
	s.Fields = v
	return s
}

// SetName sets the Name field's value.
func (s *RealtimeLogConfig) SetName(v string) *RealtimeLogConfig {
	s.Name = &v
	return s
}

// SetSamplingRate sets the SamplingRate field's value.
func (s *RealtimeLogConfig) SetSamplingRate(v int64) *RealtimeLogConfig {
	s.SamplingRate = &v
	return s
}

// A list of real-time log configurations.
type RealtimeLogConfigs struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more real-time log configurations
	// than are contained in this list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// Contains the list of real-time log configurations.
	Items []*RealtimeLogConfig `type:"list"`

	// This parameter indicates where this list of real-time log configurations
	// begins. This list includes real-time log configurations that occur after
	// the marker.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The maximum number of real-time log configurations requested.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more items in the list than are in this response, this element
	// is present. It contains the value that you should use in the Marker field
	// of a subsequent request to continue listing real-time log configurations
	// where you left off.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s RealtimeLogConfigs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RealtimeLogConfigs) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *RealtimeLogConfigs) SetIsTruncated(v bool) *RealtimeLogConfigs {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *RealtimeLogConfigs) SetItems(v []*RealtimeLogConfig) *RealtimeLogConfigs {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *RealtimeLogConfigs) SetMarker(v string) *RealtimeLogConfigs {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *RealtimeLogConfigs) SetMaxItems(v int64) *RealtimeLogConfigs {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *RealtimeLogConfigs) SetNextMarker(v string) *RealtimeLogConfigs {
	s.NextMarker = &v
	return s
}

// A subscription configuration for additional CloudWatch metrics.
type RealtimeMetricsSubscriptionConfig struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether additional CloudWatch metrics are enabled for
	// a given CloudFront distribution.
	//
	// RealtimeMetricsSubscriptionStatus is a required field
	RealtimeMetricsSubscriptionStatus *string `type:"string" required:"true" enum:"RealtimeMetricsSubscriptionStatus"`
}

// String returns the string representation
func (s RealtimeMetricsSubscriptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RealtimeMetricsSubscriptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RealtimeMetricsSubscriptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RealtimeMetricsSubscriptionConfig"}
	if s.RealtimeMetricsSubscriptionStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("RealtimeMetricsSubscriptionStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRealtimeMetricsSubscriptionStatus sets the RealtimeMetricsSubscriptionStatus field's value.
func (s *RealtimeMetricsSubscriptionConfig) SetRealtimeMetricsSubscriptionStatus(v string) *RealtimeMetricsSubscriptionConfig {
	s.RealtimeMetricsSubscriptionStatus = &v
	return s
}

// A complex type that identifies ways in which you want to restrict distribution
// of your content.
type Restrictions struct {
	_ struct{} `type:"structure"`

	// A complex type that controls the countries in which your content is distributed.
	// CloudFront determines the location of your users using MaxMind GeoIP databases.
	//
	// GeoRestriction is a required field
	GeoRestriction *GeoRestriction `type:"structure" required:"true"`
}

// String returns the string representation
func (s Restrictions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Restrictions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Restrictions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Restrictions"}
	if s.GeoRestriction == nil {
		invalidParams.Add(request.NewErrParamRequired("GeoRestriction"))
	}
	if s.GeoRestriction != nil {
		if err := s.GeoRestriction.Validate(); err != nil {
			invalidParams.AddNested("GeoRestriction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeoRestriction sets the GeoRestriction field's value.
func (s *Restrictions) SetGeoRestriction(v *GeoRestriction) *Restrictions {
	s.GeoRestriction = v
	return s
}

// A complex type that contains information about the Amazon S3 bucket from
// which you want CloudFront to get your media files for distribution.
type S3Origin struct {
	_ struct{} `type:"structure"`

	// The DNS name of the Amazon S3 origin.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The CloudFront origin access identity to associate with the distribution.
	// Use an origin access identity to configure the distribution so that end users
	// can only access objects in an Amazon S3 bucket through CloudFront.
	//
	// If you want end users to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update
	// the distribution configuration and include an empty OriginAccessIdentity
	// element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information, see Using an Origin Access Identity to Restrict Access
	// to Your Amazon S3 Content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// OriginAccessIdentity is a required field
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Origin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Origin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Origin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Origin"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.OriginAccessIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginAccessIdentity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *S3Origin) SetDomainName(v string) *S3Origin {
	s.DomainName = &v
	return s
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *S3Origin) SetOriginAccessIdentity(v string) *S3Origin {
	s.OriginAccessIdentity = &v
	return s
}

// A complex type that contains information about the Amazon S3 origin. If the
// origin is a custom origin or an S3 bucket that is configured as a website
// endpoint, use the CustomOriginConfig element instead.
type S3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin. Use an
	// origin access identity to configure the origin so that viewers can only access
	// objects in an Amazon S3 bucket through CloudFront. The format of the value
	// is:
	//
	// origin-access-identity/cloudfront/ID-of-origin-access-identity
	//
	// where ID-of-origin-access-identity is the value that CloudFront returned
	// in the ID element when you created the origin access identity.
	//
	// If you want viewers to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update
	// the distribution configuration and include an empty OriginAccessIdentity
	// element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information about the origin access identity, see Serving Private
	// Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// OriginAccessIdentity is a required field
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3OriginConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3OriginConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3OriginConfig"}
	if s.OriginAccessIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginAccessIdentity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *S3OriginConfig) SetOriginAccessIdentity(v string) *S3OriginConfig {
	s.OriginAccessIdentity = &v
	return s
}

// A list of AWS accounts and the active CloudFront key pairs in each account
// that CloudFront can use to verify the signatures of signed URLs and signed
// cookies.
type Signer struct {
	_ struct{} `type:"structure"`

	// An AWS account number that contains active CloudFront key pairs that CloudFront
	// can use to verify the signatures of signed URLs and signed cookies. If the
	// AWS account that owns the key pairs is the same account that owns the CloudFront
	// distribution, the value of this field is self.
	AwsAccountNumber *string `type:"string"`

	// A list of CloudFront key pair identifiers.
	KeyPairIds *KeyPairIds `type:"structure"`
}

// String returns the string representation
func (s Signer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Signer) GoString() string {
	return s.String()
}

// SetAwsAccountNumber sets the AwsAccountNumber field's value.
func (s *Signer) SetAwsAccountNumber(v string) *Signer {
	s.AwsAccountNumber = &v
	return s
}

// SetKeyPairIds sets the KeyPairIds field's value.
func (s *Signer) SetKeyPairIds(v *KeyPairIds) *Signer {
	s.KeyPairIds = v
	return s
}

// A complex data type for the status codes that you specify that, when returned
// by a primary origin, trigger CloudFront to failover to a second origin.
type StatusCodes struct {
	_ struct{} `type:"structure"`

	// The items (status codes) for an origin group.
	//
	// Items is a required field
	Items []*int64 `locationNameList:"StatusCode" min:"1" type:"list" required:"true"`

	// The number of status codes.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatusCodes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatusCodes"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 1))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *StatusCodes) SetItems(v []*int64) *StatusCodes {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *StatusCodes) SetQuantity(v int64) *StatusCodes {
	s.Quantity = &v
	return s
}

// A streaming distribution tells CloudFront where you want RTMP content to
// be delivered from, and the details about how to track and manage content
// delivery.
type StreamingDistribution struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that lists the AWS accounts, if any, that you included in
	// the TrustedSigners complex type for this distribution. These are the accounts
	// that you want to allow to create signed URLs for private content.
	//
	// The Signer complex type lists the AWS account number of the trusted signer
	// or self if the signer is the AWS account that created the distribution. The
	// Signer element also includes the IDs of any active CloudFront key pairs that
	// are associated with the trusted signer's AWS account. If no KeyPairId element
	// appears for a Signer, that signer can't create signed URLs.
	//
	// For more information, see Serving Private Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ActiveTrustedSigners is a required field
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// The domain name that corresponds to the streaming distribution, for example,
	// s5c39gqb8ow64r.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The identifier for the RTMP distribution. For example: EGTXBD79EXAMPLE.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time that the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The current status of the RTMP distribution. When the status is Deployed,
	// the distribution's information is propagated to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The current configuration information for the RTMP distribution.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistribution) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *StreamingDistribution) SetARN(v string) *StreamingDistribution {
	s.ARN = &v
	return s
}

// SetActiveTrustedSigners sets the ActiveTrustedSigners field's value.
func (s *StreamingDistribution) SetActiveTrustedSigners(v *ActiveTrustedSigners) *StreamingDistribution {
	s.ActiveTrustedSigners = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *StreamingDistribution) SetDomainName(v string) *StreamingDistribution {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *StreamingDistribution) SetId(v string) *StreamingDistribution {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *StreamingDistribution) SetLastModifiedTime(v time.Time) *StreamingDistribution {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StreamingDistribution) SetStatus(v string) *StreamingDistribution {
	s.Status = &v
	return s
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *StreamingDistribution) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *StreamingDistribution {
	s.StreamingDistributionConfig = v
	return s
}

// The RTMP distribution's configuration information.
type StreamingDistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	Aliases *Aliases `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// StreamingDistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request
	// to create a distribution, CloudFront returns a DistributionAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the streaming distribution.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// Whether the streaming distribution is enabled to accept user requests for
	// content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that controls whether access logs are written for the streaming
	// distribution.
	Logging *StreamingLoggingConfig `type:"structure"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	PriceClass *string `type:"string" enum:"PriceClass"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	//
	// S3Origin is a required field
	S3Origin *S3Origin `type:"structure" required:"true"`

	// A complex type that specifies any AWS accounts that you want to permit to
	// create signed URLs for private content. If you want the distribution to use
	// signed URLs, include this element; if you want the distribution to use public
	// URLs, remove this element. For more information, see Serving Private Content
	// through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingDistributionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingDistributionConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.S3Origin == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Origin"))
	}
	if s.TrustedSigners == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedSigners"))
	}
	if s.Aliases != nil {
		if err := s.Aliases.Validate(); err != nil {
			invalidParams.AddNested("Aliases", err.(request.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Origin != nil {
		if err := s.S3Origin.Validate(); err != nil {
			invalidParams.AddNested("S3Origin", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliases sets the Aliases field's value.
func (s *StreamingDistributionConfig) SetAliases(v *Aliases) *StreamingDistributionConfig {
	s.Aliases = v
	return s
}

// SetCallerReference sets the CallerReference field's value.
func (s *StreamingDistributionConfig) SetCallerReference(v string) *StreamingDistributionConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *StreamingDistributionConfig) SetComment(v string) *StreamingDistributionConfig {
	s.Comment = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *StreamingDistributionConfig) SetEnabled(v bool) *StreamingDistributionConfig {
	s.Enabled = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *StreamingDistributionConfig) SetLogging(v *StreamingLoggingConfig) *StreamingDistributionConfig {
	s.Logging = v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *StreamingDistributionConfig) SetPriceClass(v string) *StreamingDistributionConfig {
	s.PriceClass = &v
	return s
}

// SetS3Origin sets the S3Origin field's value.
func (s *StreamingDistributionConfig) SetS3Origin(v *S3Origin) *StreamingDistributionConfig {
	s.S3Origin = v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *StreamingDistributionConfig) SetTrustedSigners(v *TrustedSigners) *StreamingDistributionConfig {
	s.TrustedSigners = v
	return s
}

// A streaming distribution Configuration and a list of tags to be associated
// with the streaming distribution.
type StreamingDistributionConfigWithTags struct {
	_ struct{} `type:"structure"`

	// A streaming distribution Configuration.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfigWithTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionConfigWithTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingDistributionConfigWithTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingDistributionConfigWithTags"}
	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *StreamingDistributionConfigWithTags) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *StreamingDistributionConfigWithTags {
	s.StreamingDistributionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamingDistributionConfigWithTags) SetTags(v *Tags) *StreamingDistributionConfigWithTags {
	s.Tags = v
	return s
}

// A streaming distribution list.
type StreamingDistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more streaming distributions remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one StreamingDistributionSummary element for
	// each distribution that was created by the current AWS account.
	Items []*StreamingDistributionSummary `locationNameList:"StreamingDistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your RTMP distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of streaming distributions that were created by the current AWS
	// account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *StreamingDistributionList) SetIsTruncated(v bool) *StreamingDistributionList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *StreamingDistributionList) SetItems(v []*StreamingDistributionSummary) *StreamingDistributionList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *StreamingDistributionList) SetMarker(v string) *StreamingDistributionList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *StreamingDistributionList) SetMaxItems(v int64) *StreamingDistributionList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *StreamingDistributionList) SetNextMarker(v string) *StreamingDistributionList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *StreamingDistributionList) SetQuantity(v int64) *StreamingDistributionList {
	s.Quantity = &v
	return s
}

// A summary of the information for a CloudFront streaming distribution.
type StreamingDistributionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the streaming distribution. For example:
	// arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	//
	// Aliases is a required field
	Aliases *Aliases `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept end user requests for content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The identifier for the distribution, for example, EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// PriceClass is a required field
	PriceClass *string `type:"string" required:"true" enum:"PriceClass"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	//
	// S3Origin is a required field
	S3Origin *S3Origin `type:"structure" required:"true"`

	// Indicates the current status of the distribution. When the status is Deployed,
	// the distribution's information is fully propagated throughout the Amazon
	// CloudFront system.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items.If you don't want to require signed URLs in
	// requests for objects that match PathPattern, specify false for Enabled and
	// 0 for Quantity. Omit Items. To add, change, or remove one or more trusted
	// signers, change Enabled to true (if it's currently false), change Quantity
	// as applicable, and specify all of the trusted signers that you want to include
	// in the updated distribution.
	//
	// For more information, see Serving Private Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *StreamingDistributionSummary) SetARN(v string) *StreamingDistributionSummary {
	s.ARN = &v
	return s
}

// SetAliases sets the Aliases field's value.
func (s *StreamingDistributionSummary) SetAliases(v *Aliases) *StreamingDistributionSummary {
	s.Aliases = v
	return s
}

// SetComment sets the Comment field's value.
func (s *StreamingDistributionSummary) SetComment(v string) *StreamingDistributionSummary {
	s.Comment = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *StreamingDistributionSummary) SetDomainName(v string) *StreamingDistributionSummary {
	s.DomainName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *StreamingDistributionSummary) SetEnabled(v bool) *StreamingDistributionSummary {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *StreamingDistributionSummary) SetId(v string) *StreamingDistributionSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *StreamingDistributionSummary) SetLastModifiedTime(v time.Time) *StreamingDistributionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *StreamingDistributionSummary) SetPriceClass(v string) *StreamingDistributionSummary {
	s.PriceClass = &v
	return s
}

// SetS3Origin sets the S3Origin field's value.
func (s *StreamingDistributionSummary) SetS3Origin(v *S3Origin) *StreamingDistributionSummary {
	s.S3Origin = v
	return s
}

// SetStatus sets the Status field's value.
func (s *StreamingDistributionSummary) SetStatus(v string) *StreamingDistributionSummary {
	s.Status = &v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *StreamingDistributionSummary) SetTrustedSigners(v *TrustedSigners) *StreamingDistributionSummary {
	s.TrustedSigners = v
	return s
}

// A complex type that controls whether access logs are written for this streaming
// distribution.
type StreamingLoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a streaming distribution
	// or if you want to disable logging for an existing streaming distribution,
	// specify false for Enabled, and specify empty Bucket and Prefix elements.
	// If you specify false for Enabled but you specify values for Bucket and Prefix,
	// the values are automatically deleted.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this streaming distribution, for example, myprefix/. If you want to enable
	// logging, but you don't want to specify a prefix, you still must include an
	// empty Prefix element in the Logging element.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StreamingLoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingLoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingLoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingLoggingConfig"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *StreamingLoggingConfig) SetBucket(v string) *StreamingLoggingConfig {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *StreamingLoggingConfig) SetEnabled(v bool) *StreamingLoggingConfig {
	s.Enabled = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *StreamingLoggingConfig) SetPrefix(v string) *StreamingLoggingConfig {
	s.Prefix = &v
	return s
}

// A complex type that contains Tag key and Tag value.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that contains Tag key.
	//
	// The string length should be between 1 and 128 characters. Valid characters
	// include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that contains an optional Tag value.
	//
	// The string length should be between 0 and 256 characters. Valid characters
	// include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A complex type that contains zero or more Tag elements.
type TagKeys struct {
	_ struct{} `type:"structure"`

	// A complex type that contains Tag key elements.
	Items []*string `locationNameList:"Key" type:"list"`
}

// String returns the string representation
func (s TagKeys) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagKeys) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *TagKeys) SetItems(v []*string) *TagKeys {
	s.Items = v
	return s
}

// The request to add tags to a CloudFront resource.
type TagResourceInput struct {
	_ struct{} `locationName:"TagResourceRequest" type:"structure" payload:"Tags"`

	// An ARN of a CloudFront resource.
	//
	// Resource is a required field
	Resource *string `location:"querystring" locationName:"Resource" type:"string" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `locationName:"Tags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *TagResourceInput) SetResource(v string) *TagResourceInput {
	s.Resource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v *Tags) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A complex type that contains zero or more Tag elements.
type Tags struct {
	_ struct{} `type:"structure"`

	// A complex type that contains Tag elements.
	Items []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s Tags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tags"}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Tags) SetItems(v []*Tag) *Tags {
	s.Items = v
	return s
}

// A list of key groups whose public keys CloudFront can use to verify the signatures
// of signed URLs and signed cookies.
type TrustedKeyGroups struct {
	_ struct{} `type:"structure"`

	// This field is true if any of the key groups in the list have public keys
	// that CloudFront can use to verify the signatures of signed URLs and signed
	// cookies. If not, this field is false.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A list of key groups identifiers.
	Items []*string `locationNameList:"KeyGroup" type:"list"`

	// The number of key groups in the list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TrustedKeyGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedKeyGroups) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedKeyGroups) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrustedKeyGroups"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *TrustedKeyGroups) SetEnabled(v bool) *TrustedKeyGroups {
	s.Enabled = &v
	return s
}

// SetItems sets the Items field's value.
func (s *TrustedKeyGroups) SetItems(v []*string) *TrustedKeyGroups {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *TrustedKeyGroups) SetQuantity(v int64) *TrustedKeyGroups {
	s.Quantity = &v
	return s
}

// A list of AWS accounts whose public keys CloudFront can use to verify the
// signatures of signed URLs and signed cookies.
type TrustedSigners struct {
	_ struct{} `type:"structure"`

	// This field is true if any of the AWS accounts have public keys that CloudFront
	// can use to verify the signatures of signed URLs and signed cookies. If not,
	// this field is false.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A list of AWS account identifiers.
	Items []*string `locationNameList:"AwsAccountNumber" type:"list"`

	// The number of AWS accounts in the list.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedSigners) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedSigners) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrustedSigners"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *TrustedSigners) SetEnabled(v bool) *TrustedSigners {
	s.Enabled = &v
	return s
}

// SetItems sets the Items field's value.
func (s *TrustedSigners) SetItems(v []*string) *TrustedSigners {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *TrustedSigners) SetQuantity(v int64) *TrustedSigners {
	s.Quantity = &v
	return s
}

// The request to remove tags from a CloudFront resource.
type UntagResourceInput struct {
	_ struct{} `locationName:"UntagResourceRequest" type:"structure" payload:"TagKeys"`

	// An ARN of a CloudFront resource.
	//
	// Resource is a required field
	Resource *string `location:"querystring" locationName:"Resource" type:"string" required:"true"`

	// A complex type that contains zero or more Tag key elements.
	//
	// TagKeys is a required field
	TagKeys *TagKeys `locationName:"TagKeys" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *UntagResourceInput) SetResource(v string) *UntagResourceInput {
	s.Resource = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v *TagKeys) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCachePolicyInput struct {
	_ struct{} `locationName:"UpdateCachePolicyRequest" type:"structure" payload:"CachePolicyConfig"`

	// A cache policy configuration.
	//
	// CachePolicyConfig is a required field
	CachePolicyConfig *CachePolicyConfig `locationName:"CachePolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The unique identifier for the cache policy that you are updating. The identifier
	// is returned in a cache behavior’s CachePolicyId field in the response to
	// GetDistributionConfig.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the cache policy that you are updating. The version is returned
	// in the cache policy’s ETag field in the response to GetCachePolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCachePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCachePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCachePolicyInput"}
	if s.CachePolicyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CachePolicyConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.CachePolicyConfig != nil {
		if err := s.CachePolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("CachePolicyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCachePolicyConfig sets the CachePolicyConfig field's value.
func (s *UpdateCachePolicyInput) SetCachePolicyConfig(v *CachePolicyConfig) *UpdateCachePolicyInput {
	s.CachePolicyConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCachePolicyInput) SetId(v string) *UpdateCachePolicyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateCachePolicyInput) SetIfMatch(v string) *UpdateCachePolicyInput {
	s.IfMatch = &v
	return s
}

type UpdateCachePolicyOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicy"`

	// A cache policy.
	CachePolicy *CachePolicy `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCachePolicyOutput) GoString() string {
	return s.String()
}

// SetCachePolicy sets the CachePolicy field's value.
func (s *UpdateCachePolicyOutput) SetCachePolicy(v *CachePolicy) *UpdateCachePolicyOutput {
	s.CachePolicy = v
	return s
}

// SetETag sets the ETag field's value.
func (s *UpdateCachePolicyOutput) SetETag(v string) *UpdateCachePolicyOutput {
	s.ETag = &v
	return s
}

// The request to update an origin access identity.
type UpdateCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"UpdateCloudFrontOriginAccessIdentityRequest" type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The identity's configuration information.
	//
	// CloudFrontOriginAccessIdentityConfig is a required field
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `locationName:"CloudFrontOriginAccessIdentityConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The identity's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the identity's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCloudFrontOriginAccessIdentityInput"}
	if s.CloudFrontOriginAccessIdentityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudFrontOriginAccessIdentityConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.CloudFrontOriginAccessIdentityConfig != nil {
		if err := s.CloudFrontOriginAccessIdentityConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudFrontOriginAccessIdentityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *UpdateCloudFrontOriginAccessIdentityInput) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *UpdateCloudFrontOriginAccessIdentityInput {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCloudFrontOriginAccessIdentityInput) SetId(v string) *UpdateCloudFrontOriginAccessIdentityInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateCloudFrontOriginAccessIdentityInput) SetIfMatch(v string) *UpdateCloudFrontOriginAccessIdentityInput {
	s.IfMatch = &v
	return s
}

// The returned result of the corresponding request.
type UpdateCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentity sets the CloudFrontOriginAccessIdentity field's value.
func (s *UpdateCloudFrontOriginAccessIdentityOutput) SetCloudFrontOriginAccessIdentity(v *OriginAccessIdentity) *UpdateCloudFrontOriginAccessIdentityOutput {
	s.CloudFrontOriginAccessIdentity = v
	return s
}

// SetETag sets the ETag field's value.
func (s *UpdateCloudFrontOriginAccessIdentityOutput) SetETag(v string) *UpdateCloudFrontOriginAccessIdentityOutput {
	s.ETag = &v
	return s
}

// The request to update a distribution.
type UpdateDistributionInput struct {
	_ struct{} `locationName:"UpdateDistributionRequest" type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `locationName:"DistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The distribution's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the distribution's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDistributionInput"}
	if s.DistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *UpdateDistributionInput) SetDistributionConfig(v *DistributionConfig) *UpdateDistributionInput {
	s.DistributionConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDistributionInput) SetId(v string) *UpdateDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateDistributionInput) SetIfMatch(v string) *UpdateDistributionInput {
	s.IfMatch = &v
	return s
}

// The returned result of the corresponding request.
type UpdateDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *UpdateDistributionOutput) SetDistribution(v *Distribution) *UpdateDistributionOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *UpdateDistributionOutput) SetETag(v string) *UpdateDistributionOutput {
	s.ETag = &v
	return s
}

type UpdateFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"UpdateFieldLevelEncryptionConfigRequest" type:"structure" payload:"FieldLevelEncryptionConfig"`

	// Request to update a field-level encryption configuration.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `locationName:"FieldLevelEncryptionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The ID of the configuration you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the configuration
	// identity to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFieldLevelEncryptionConfigInput"}
	if s.FieldLevelEncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.FieldLevelEncryptionConfig != nil {
		if err := s.FieldLevelEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *UpdateFieldLevelEncryptionConfigInput) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *UpdateFieldLevelEncryptionConfigInput {
	s.FieldLevelEncryptionConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFieldLevelEncryptionConfigInput) SetId(v string) *UpdateFieldLevelEncryptionConfigInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateFieldLevelEncryptionConfigInput) SetIfMatch(v string) *UpdateFieldLevelEncryptionConfigInput {
	s.IfMatch = &v
	return s
}

type UpdateFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The value of the ETag header that you received when updating the configuration.
	// For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the results of updating the configuration.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateFieldLevelEncryptionConfigOutput) SetETag(v string) *UpdateFieldLevelEncryptionConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryption sets the FieldLevelEncryption field's value.
func (s *UpdateFieldLevelEncryptionConfigOutput) SetFieldLevelEncryption(v *FieldLevelEncryption) *UpdateFieldLevelEncryptionConfigOutput {
	s.FieldLevelEncryption = v
	return s
}

type UpdateFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"UpdateFieldLevelEncryptionProfileRequest" type:"structure" payload:"FieldLevelEncryptionProfileConfig"`

	// Request to update a field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `locationName:"FieldLevelEncryptionProfileConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The ID of the field-level encryption profile request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the profile
	// identity to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFieldLevelEncryptionProfileInput"}
	if s.FieldLevelEncryptionProfileConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionProfileConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.FieldLevelEncryptionProfileConfig != nil {
		if err := s.FieldLevelEncryptionProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *UpdateFieldLevelEncryptionProfileInput) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *UpdateFieldLevelEncryptionProfileInput {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFieldLevelEncryptionProfileInput) SetId(v string) *UpdateFieldLevelEncryptionProfileInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateFieldLevelEncryptionProfileInput) SetIfMatch(v string) *UpdateFieldLevelEncryptionProfileInput {
	s.IfMatch = &v
	return s
}

type UpdateFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfile"`

	// The result of the field-level encryption profile request.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the results of updating the profile.
	FieldLevelEncryptionProfile *FieldLevelEncryptionProfile `type:"structure"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateFieldLevelEncryptionProfileOutput) SetETag(v string) *UpdateFieldLevelEncryptionProfileOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfile sets the FieldLevelEncryptionProfile field's value.
func (s *UpdateFieldLevelEncryptionProfileOutput) SetFieldLevelEncryptionProfile(v *FieldLevelEncryptionProfile) *UpdateFieldLevelEncryptionProfileOutput {
	s.FieldLevelEncryptionProfile = v
	return s
}

type UpdateKeyGroupInput struct {
	_ struct{} `locationName:"UpdateKeyGroupRequest" type:"structure" payload:"KeyGroupConfig"`

	// The identifier of the key group that you are updating.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the key group that you are updating. The version is the key
	// group’s ETag value.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// The key group configuration.
	//
	// KeyGroupConfig is a required field
	KeyGroupConfig *KeyGroupConfig `locationName:"KeyGroupConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s UpdateKeyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKeyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKeyGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.KeyGroupConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyGroupConfig"))
	}
	if s.KeyGroupConfig != nil {
		if err := s.KeyGroupConfig.Validate(); err != nil {
			invalidParams.AddNested("KeyGroupConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateKeyGroupInput) SetId(v string) *UpdateKeyGroupInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateKeyGroupInput) SetIfMatch(v string) *UpdateKeyGroupInput {
	s.IfMatch = &v
	return s
}

// SetKeyGroupConfig sets the KeyGroupConfig field's value.
func (s *UpdateKeyGroupInput) SetKeyGroupConfig(v *KeyGroupConfig) *UpdateKeyGroupInput {
	s.KeyGroupConfig = v
	return s
}

type UpdateKeyGroupOutput struct {
	_ struct{} `type:"structure" payload:"KeyGroup"`

	// The identifier for this version of the key group.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The key group that was just updated.
	KeyGroup *KeyGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateKeyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyGroupOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateKeyGroupOutput) SetETag(v string) *UpdateKeyGroupOutput {
	s.ETag = &v
	return s
}

// SetKeyGroup sets the KeyGroup field's value.
func (s *UpdateKeyGroupOutput) SetKeyGroup(v *KeyGroup) *UpdateKeyGroupOutput {
	s.KeyGroup = v
	return s
}

type UpdateOriginRequestPolicyInput struct {
	_ struct{} `locationName:"UpdateOriginRequestPolicyRequest" type:"structure" payload:"OriginRequestPolicyConfig"`

	// The unique identifier for the origin request policy that you are updating.
	// The identifier is returned in a cache behavior’s OriginRequestPolicyId
	// field in the response to GetDistributionConfig.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the origin request policy that you are updating. The version
	// is returned in the origin request policy’s ETag field in the response to
	// GetOriginRequestPolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// An origin request policy configuration.
	//
	// OriginRequestPolicyConfig is a required field
	OriginRequestPolicyConfig *OriginRequestPolicyConfig `locationName:"OriginRequestPolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s UpdateOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOriginRequestPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOriginRequestPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOriginRequestPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.OriginRequestPolicyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginRequestPolicyConfig"))
	}
	if s.OriginRequestPolicyConfig != nil {
		if err := s.OriginRequestPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("OriginRequestPolicyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateOriginRequestPolicyInput) SetId(v string) *UpdateOriginRequestPolicyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateOriginRequestPolicyInput) SetIfMatch(v string) *UpdateOriginRequestPolicyInput {
	s.IfMatch = &v
	return s
}

// SetOriginRequestPolicyConfig sets the OriginRequestPolicyConfig field's value.
func (s *UpdateOriginRequestPolicyInput) SetOriginRequestPolicyConfig(v *OriginRequestPolicyConfig) *UpdateOriginRequestPolicyInput {
	s.OriginRequestPolicyConfig = v
	return s
}

type UpdateOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicy"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// An origin request policy.
	OriginRequestPolicy *OriginRequestPolicy `type:"structure"`
}

// String returns the string representation
func (s UpdateOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOriginRequestPolicyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateOriginRequestPolicyOutput) SetETag(v string) *UpdateOriginRequestPolicyOutput {
	s.ETag = &v
	return s
}

// SetOriginRequestPolicy sets the OriginRequestPolicy field's value.
func (s *UpdateOriginRequestPolicyOutput) SetOriginRequestPolicy(v *OriginRequestPolicy) *UpdateOriginRequestPolicyOutput {
	s.OriginRequestPolicy = v
	return s
}

type UpdatePublicKeyInput struct {
	_ struct{} `locationName:"UpdatePublicKeyRequest" type:"structure" payload:"PublicKeyConfig"`

	// The identifier of the public key that you are updating.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the public
	// key to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// A public key configuration.
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `locationName:"PublicKeyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s UpdatePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePublicKeyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.PublicKeyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyConfig"))
	}
	if s.PublicKeyConfig != nil {
		if err := s.PublicKeyConfig.Validate(); err != nil {
			invalidParams.AddNested("PublicKeyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdatePublicKeyInput) SetId(v string) *UpdatePublicKeyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdatePublicKeyInput) SetIfMatch(v string) *UpdatePublicKeyInput {
	s.IfMatch = &v
	return s
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *UpdatePublicKeyInput) SetPublicKeyConfig(v *PublicKeyConfig) *UpdatePublicKeyInput {
	s.PublicKeyConfig = v
	return s
}

type UpdatePublicKeyOutput struct {
	_ struct{} `type:"structure" payload:"PublicKey"`

	// The identifier of the current version of the public key.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The public key.
	PublicKey *PublicKey `type:"structure"`
}

// String returns the string representation
func (s UpdatePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePublicKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdatePublicKeyOutput) SetETag(v string) *UpdatePublicKeyOutput {
	s.ETag = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *UpdatePublicKeyOutput) SetPublicKey(v *PublicKey) *UpdatePublicKeyOutput {
	s.PublicKey = v
	return s
}

type UpdateRealtimeLogConfigInput struct {
	_ struct{} `locationName:"UpdateRealtimeLogConfigRequest" type:"structure" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`

	// The Amazon Resource Name (ARN) for this real-time log configuration.
	ARN *string `type:"string"`

	// Contains information about the Amazon Kinesis data stream where you are sending
	// real-time log data.
	EndPoints []*EndPoint `type:"list"`

	// A list of fields to include in each real-time log record.
	//
	// For more information about fields, see Real-time log configuration fields
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
	// in the Amazon CloudFront Developer Guide.
	Fields []*string `locationNameList:"Field" type:"list"`

	// The name for this real-time log configuration.
	Name *string `type:"string"`

	// The sampling rate for this real-time log configuration. The sampling rate
	// determines the percentage of viewer requests that are represented in the
	// real-time log data. You must provide an integer between 1 and 100, inclusive.
	SamplingRate *int64 `type:"long"`
}

// String returns the string representation
func (s UpdateRealtimeLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRealtimeLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRealtimeLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRealtimeLogConfigInput"}
	if s.EndPoints != nil {
		for i, v := range s.EndPoints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EndPoints", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *UpdateRealtimeLogConfigInput) SetARN(v string) *UpdateRealtimeLogConfigInput {
	s.ARN = &v
	return s
}

// SetEndPoints sets the EndPoints field's value.
func (s *UpdateRealtimeLogConfigInput) SetEndPoints(v []*EndPoint) *UpdateRealtimeLogConfigInput {
	s.EndPoints = v
	return s
}

// SetFields sets the Fields field's value.
func (s *UpdateRealtimeLogConfigInput) SetFields(v []*string) *UpdateRealtimeLogConfigInput {
	s.Fields = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRealtimeLogConfigInput) SetName(v string) *UpdateRealtimeLogConfigInput {
	s.Name = &v
	return s
}

// SetSamplingRate sets the SamplingRate field's value.
func (s *UpdateRealtimeLogConfigInput) SetSamplingRate(v int64) *UpdateRealtimeLogConfigInput {
	s.SamplingRate = &v
	return s
}

type UpdateRealtimeLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A real-time log configuration.
	RealtimeLogConfig *RealtimeLogConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateRealtimeLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRealtimeLogConfigOutput) GoString() string {
	return s.String()
}

// SetRealtimeLogConfig sets the RealtimeLogConfig field's value.
func (s *UpdateRealtimeLogConfigOutput) SetRealtimeLogConfig(v *RealtimeLogConfig) *UpdateRealtimeLogConfigOutput {
	s.RealtimeLogConfig = v
	return s
}

// The request to update a streaming distribution.
type UpdateStreamingDistributionInput struct {
	_ struct{} `locationName:"UpdateStreamingDistributionRequest" type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the streaming
	// distribution's configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s UpdateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStreamingDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateStreamingDistributionInput) SetId(v string) *UpdateStreamingDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateStreamingDistributionInput) SetIfMatch(v string) *UpdateStreamingDistributionInput {
	s.IfMatch = &v
	return s
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *UpdateStreamingDistributionInput) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *UpdateStreamingDistributionInput {
	s.StreamingDistributionConfig = v
	return s
}

// The returned result of the corresponding request.
type UpdateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s UpdateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamingDistributionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateStreamingDistributionOutput) SetETag(v string) *UpdateStreamingDistributionOutput {
	s.ETag = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *UpdateStreamingDistributionOutput) SetStreamingDistribution(v *StreamingDistribution) *UpdateStreamingDistributionOutput {
	s.StreamingDistribution = v
	return s
}

// A complex type that determines the distribution’s SSL/TLS configuration
// for communicating with viewers.
//
// If the distribution doesn’t use Aliases (also known as alternate domain
// names or CNAMEs)—that is, if the distribution uses the CloudFront domain
// name such as d111111abcdef8.cloudfront.net—set CloudFrontDefaultCertificate
// to true and leave all other fields empty.
//
// If the distribution uses Aliases (alternate domain names or CNAMEs), use
// the fields in this type to specify the following settings:
//
//    * Which viewers the distribution accepts HTTPS connections from: only
//    viewers that support server name indication (SNI) (https://en.wikipedia.org/wiki/Server_Name_Indication)
//    (recommended), or all viewers including those that don’t support SNI.
//    To accept HTTPS connections from only viewers that support SNI, set SSLSupportMethod
//    to sni-only. This is recommended. Most browsers and clients support SNI.
//    To accept HTTPS connections from all viewers, including those that don’t
//    support SNI, set SSLSupportMethod to vip. This is not recommended, and
//    results in additional monthly charges from CloudFront.
//
//    * The minimum SSL/TLS protocol version that the distribution can use to
//    communicate with viewers. To specify a minimum version, choose a value
//    for MinimumProtocolVersion. For more information, see Security Policy
//    (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy)
//    in the Amazon CloudFront Developer Guide.
//
//    * The location of the SSL/TLS certificate, AWS Certificate Manager (ACM)
//    (https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended)
//    or AWS Identity and Access Management (AWS IAM) (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html).
//    You specify the location by setting a value in one of the following fields
//    (not both): ACMCertificateArn IAMCertificateId
//
// All distributions support HTTPS connections from viewers. To require viewers
// to use HTTPS only, or to redirect them from HTTP to HTTPS, use ViewerProtocolPolicy
// in the CacheBehavior or DefaultCacheBehavior. To specify how CloudFront should
// use SSL/TLS to communicate with your custom origin, use CustomOriginConfig.
//
// For more information, see Using HTTPS with CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html)
// and Using Alternate Domain Names and HTTPS (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html)
// in the Amazon CloudFront Developer Guide.
type ViewerCertificate struct {
	_ struct{} `type:"structure"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs) and the
	// SSL/TLS certificate is stored in AWS Certificate Manager (ACM) (https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html),
	// provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront
	// only supports ACM certificates in the US East (N. Virginia) Region (us-east-1).
	//
	// If you specify an ACM certificate ARN, you must also specify values for MinimumProtocolVersion
	// and SSLSupportMethod.
	ACMCertificateArn *string `type:"string"`

	// This field is deprecated. Use one of the following fields instead:
	//
	//    * ACMCertificateArn
	//
	//    * IAMCertificateId
	//
	//    * CloudFrontDefaultCertificate
	//
	// Deprecated: Certificate has been deprecated
	Certificate *string `deprecated:"true" type:"string"`

	// This field is deprecated. Use one of the following fields instead:
	//
	//    * ACMCertificateArn
	//
	//    * IAMCertificateId
	//
	//    * CloudFrontDefaultCertificate
	//
	// Deprecated: CertificateSource has been deprecated
	CertificateSource *string `deprecated:"true" type:"string" enum:"CertificateSource"`

	// If the distribution uses the CloudFront domain name such as d111111abcdef8.cloudfront.net,
	// set this field to true.
	//
	// If the distribution uses Aliases (alternate domain names or CNAMEs), set
	// this field to false and specify values for the following fields:
	//
	//    * ACMCertificateArn or IAMCertificateId (specify a value for one, not
	//    both)
	//
	//    * MinimumProtocolVersion
	//
	//    * SSLSupportMethod
	CloudFrontDefaultCertificate *bool `type:"boolean"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs) and the
	// SSL/TLS certificate is stored in AWS Identity and Access Management (AWS
	// IAM) (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html),
	// provide the ID of the IAM certificate.
	//
	// If you specify an IAM certificate ID, you must also specify values for MinimumProtocolVersion
	// and SSLSupportMethod.
	IAMCertificateId *string `type:"string"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs), specify
	// the security policy that you want CloudFront to use for HTTPS connections
	// with viewers. The security policy determines two settings:
	//
	//    * The minimum SSL/TLS protocol that CloudFront can use to communicate
	//    with viewers.
	//
	//    * The ciphers that CloudFront can use to encrypt the content that it returns
	//    to viewers.
	//
	// For more information, see Security Policy (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy)
	// and Supported Protocols and Ciphers Between Viewers and CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers)
	// in the Amazon CloudFront Developer Guide.
	//
	// On the CloudFront console, this setting is called Security Policy.
	//
	// When you’re using SNI only (you set SSLSupportMethod to sni-only), you
	// must specify TLSv1 or higher.
	//
	// If the distribution uses the CloudFront domain name such as d111111abcdef8.cloudfront.net
	// (you set CloudFrontDefaultCertificate to true), CloudFront automatically
	// sets the security policy to TLSv1 regardless of the value that you set here.
	MinimumProtocolVersion *string `type:"string" enum:"MinimumProtocolVersion"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs), specify
	// which viewers the distribution accepts HTTPS connections from.
	//
	//    * sni-only – The distribution accepts HTTPS connections from only viewers
	//    that support server name indication (SNI) (https://en.wikipedia.org/wiki/Server_Name_Indication).
	//    This is recommended. Most browsers and clients support SNI.
	//
	//    * vip – The distribution accepts HTTPS connections from all viewers
	//    including those that don’t support SNI. This is not recommended, and
	//    results in additional monthly charges from CloudFront.
	//
	//    * static-ip - Do not specify this value unless your distribution has been
	//    enabled for this feature by the CloudFront team. If you have a use case
	//    that requires static IP addresses for a distribution, contact CloudFront
	//    through the AWS Support Center (https://console.aws.amazon.com/support/home).
	//
	// If the distribution uses the CloudFront domain name such as d111111abcdef8.cloudfront.net,
	// don’t set a value for this field.
	SSLSupportMethod *string `type:"string" enum:"SSLSupportMethod"`
}

// String returns the string representation
func (s ViewerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ViewerCertificate) GoString() string {
	return s.String()
}

// SetACMCertificateArn sets the ACMCertificateArn field's value.
func (s *ViewerCertificate) SetACMCertificateArn(v string) *ViewerCertificate {
	s.ACMCertificateArn = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *ViewerCertificate) SetCertificate(v string) *ViewerCertificate {
	s.Certificate = &v
	return s
}

// SetCertificateSource sets the CertificateSource field's value.
func (s *ViewerCertificate) SetCertificateSource(v string) *ViewerCertificate {
	s.CertificateSource = &v
	return s
}

// SetCloudFrontDefaultCertificate sets the CloudFrontDefaultCertificate field's value.
func (s *ViewerCertificate) SetCloudFrontDefaultCertificate(v bool) *ViewerCertificate {
	s.CloudFrontDefaultCertificate = &v
	return s
}

// SetIAMCertificateId sets the IAMCertificateId field's value.
func (s *ViewerCertificate) SetIAMCertificateId(v string) *ViewerCertificate {
	s.IAMCertificateId = &v
	return s
}

// SetMinimumProtocolVersion sets the MinimumProtocolVersion field's value.
func (s *ViewerCertificate) SetMinimumProtocolVersion(v string) *ViewerCertificate {
	s.MinimumProtocolVersion = &v
	return s
}

// SetSSLSupportMethod sets the SSLSupportMethod field's value.
func (s *ViewerCertificate) SetSSLSupportMethod(v string) *ViewerCertificate {
	s.SSLSupportMethod = &v
	return s
}

const (
	// CachePolicyCookieBehaviorNone is a CachePolicyCookieBehavior enum value
	CachePolicyCookieBehaviorNone = "none"

	// CachePolicyCookieBehaviorWhitelist is a CachePolicyCookieBehavior enum value
	CachePolicyCookieBehaviorWhitelist = "whitelist"

	// CachePolicyCookieBehaviorAllExcept is a CachePolicyCookieBehavior enum value
	CachePolicyCookieBehaviorAllExcept = "allExcept"

	// CachePolicyCookieBehaviorAll is a CachePolicyCookieBehavior enum value
	CachePolicyCookieBehaviorAll = "all"
)

// CachePolicyCookieBehavior_Values returns all elements of the CachePolicyCookieBehavior enum
func CachePolicyCookieBehavior_Values() []string {
	return []string{
		CachePolicyCookieBehaviorNone,
		CachePolicyCookieBehaviorWhitelist,
		CachePolicyCookieBehaviorAllExcept,
		CachePolicyCookieBehaviorAll,
	}
}

const (
	// CachePolicyHeaderBehaviorNone is a CachePolicyHeaderBehavior enum value
	CachePolicyHeaderBehaviorNone = "none"

	// CachePolicyHeaderBehaviorWhitelist is a CachePolicyHeaderBehavior enum value
	CachePolicyHeaderBehaviorWhitelist = "whitelist"
)

// CachePolicyHeaderBehavior_Values returns all elements of the CachePolicyHeaderBehavior enum
func CachePolicyHeaderBehavior_Values() []string {
	return []string{
		CachePolicyHeaderBehaviorNone,
		CachePolicyHeaderBehaviorWhitelist,
	}
}

const (
	// CachePolicyQueryStringBehaviorNone is a CachePolicyQueryStringBehavior enum value
	CachePolicyQueryStringBehaviorNone = "none"

	// CachePolicyQueryStringBehaviorWhitelist is a CachePolicyQueryStringBehavior enum value
	CachePolicyQueryStringBehaviorWhitelist = "whitelist"

	// CachePolicyQueryStringBehaviorAllExcept is a CachePolicyQueryStringBehavior enum value
	CachePolicyQueryStringBehaviorAllExcept = "allExcept"

	// CachePolicyQueryStringBehaviorAll is a CachePolicyQueryStringBehavior enum value
	CachePolicyQueryStringBehaviorAll = "all"
)

// CachePolicyQueryStringBehavior_Values returns all elements of the CachePolicyQueryStringBehavior enum
func CachePolicyQueryStringBehavior_Values() []string {
	return []string{
		CachePolicyQueryStringBehaviorNone,
		CachePolicyQueryStringBehaviorWhitelist,
		CachePolicyQueryStringBehaviorAllExcept,
		CachePolicyQueryStringBehaviorAll,
	}
}

const (
	// CachePolicyTypeManaged is a CachePolicyType enum value
	CachePolicyTypeManaged = "managed"

	// CachePolicyTypeCustom is a CachePolicyType enum value
	CachePolicyTypeCustom = "custom"
)

// CachePolicyType_Values returns all elements of the CachePolicyType enum
func CachePolicyType_Values() []string {
	return []string{
		CachePolicyTypeManaged,
		CachePolicyTypeCustom,
	}
}

const (
	// CertificateSourceCloudfront is a CertificateSource enum value
	CertificateSourceCloudfront = "cloudfront"

	// CertificateSourceIam is a CertificateSource enum value
	CertificateSourceIam = "iam"

	// CertificateSourceAcm is a CertificateSource enum value
	CertificateSourceAcm = "acm"
)

// CertificateSource_Values returns all elements of the CertificateSource enum
func CertificateSource_Values() []string {
	return []string{
		CertificateSourceCloudfront,
		CertificateSourceIam,
		CertificateSourceAcm,
	}
}

const (
	// EventTypeViewerRequest is a EventType enum value
	EventTypeViewerRequest = "viewer-request"

	// EventTypeViewerResponse is a EventType enum value
	EventTypeViewerResponse = "viewer-response"

	// EventTypeOriginRequest is a EventType enum value
	EventTypeOriginRequest = "origin-request"

	// EventTypeOriginResponse is a EventType enum value
	EventTypeOriginResponse = "origin-response"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeViewerRequest,
		EventTypeViewerResponse,
		EventTypeOriginRequest,
		EventTypeOriginResponse,
	}
}

const (
	// FormatUrlencoded is a Format enum value
	FormatUrlencoded = "URLEncoded"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatUrlencoded,
	}
}

const (
	// GeoRestrictionTypeBlacklist is a GeoRestrictionType enum value
	GeoRestrictionTypeBlacklist = "blacklist"

	// GeoRestrictionTypeWhitelist is a GeoRestrictionType enum value
	GeoRestrictionTypeWhitelist = "whitelist"

	// GeoRestrictionTypeNone is a GeoRestrictionType enum value
	GeoRestrictionTypeNone = "none"
)

// GeoRestrictionType_Values returns all elements of the GeoRestrictionType enum
func GeoRestrictionType_Values() []string {
	return []string{
		GeoRestrictionTypeBlacklist,
		GeoRestrictionTypeWhitelist,
		GeoRestrictionTypeNone,
	}
}

const (
	// HttpVersionHttp11 is a HttpVersion enum value
	HttpVersionHttp11 = "http1.1"

	// HttpVersionHttp2 is a HttpVersion enum value
	HttpVersionHttp2 = "http2"
)

// HttpVersion_Values returns all elements of the HttpVersion enum
func HttpVersion_Values() []string {
	return []string{
		HttpVersionHttp11,
		HttpVersionHttp2,
	}
}

const (
	// ICPRecordalStatusApproved is a ICPRecordalStatus enum value
	ICPRecordalStatusApproved = "APPROVED"

	// ICPRecordalStatusSuspended is a ICPRecordalStatus enum value
	ICPRecordalStatusSuspended = "SUSPENDED"

	// ICPRecordalStatusPending is a ICPRecordalStatus enum value
	ICPRecordalStatusPending = "PENDING"
)

// ICPRecordalStatus_Values returns all elements of the ICPRecordalStatus enum
func ICPRecordalStatus_Values() []string {
	return []string{
		ICPRecordalStatusApproved,
		ICPRecordalStatusSuspended,
		ICPRecordalStatusPending,
	}
}

const (
	// ItemSelectionNone is a ItemSelection enum value
	ItemSelectionNone = "none"

	// ItemSelectionWhitelist is a ItemSelection enum value
	ItemSelectionWhitelist = "whitelist"

	// ItemSelectionAll is a ItemSelection enum value
	ItemSelectionAll = "all"
)

// ItemSelection_Values returns all elements of the ItemSelection enum
func ItemSelection_Values() []string {
	return []string{
		ItemSelectionNone,
		ItemSelectionWhitelist,
		ItemSelectionAll,
	}
}

const (
	// MethodGet is a Method enum value
	MethodGet = "GET"

	// MethodHead is a Method enum value
	MethodHead = "HEAD"

	// MethodPost is a Method enum value
	MethodPost = "POST"

	// MethodPut is a Method enum value
	MethodPut = "PUT"

	// MethodPatch is a Method enum value
	MethodPatch = "PATCH"

	// MethodOptions is a Method enum value
	MethodOptions = "OPTIONS"

	// MethodDelete is a Method enum value
	MethodDelete = "DELETE"
)

// Method_Values returns all elements of the Method enum
func Method_Values() []string {
	return []string{
		MethodGet,
		MethodHead,
		MethodPost,
		MethodPut,
		MethodPatch,
		MethodOptions,
		MethodDelete,
	}
}

const (
	// MinimumProtocolVersionSslv3 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionSslv3 = "SSLv3"

	// MinimumProtocolVersionTlsv1 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv1 = "TLSv1"

	// MinimumProtocolVersionTlsv12016 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv12016 = "TLSv1_2016"

	// MinimumProtocolVersionTlsv112016 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv112016 = "TLSv1.1_2016"

	// MinimumProtocolVersionTlsv122018 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv122018 = "TLSv1.2_2018"

	// MinimumProtocolVersionTlsv122019 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv122019 = "TLSv1.2_2019"
)

// MinimumProtocolVersion_Values returns all elements of the MinimumProtocolVersion enum
func MinimumProtocolVersion_Values() []string {
	return []string{
		MinimumProtocolVersionSslv3,
		MinimumProtocolVersionTlsv1,
		MinimumProtocolVersionTlsv12016,
		MinimumProtocolVersionTlsv112016,
		MinimumProtocolVersionTlsv122018,
		MinimumProtocolVersionTlsv122019,
	}
}

const (
	// OriginProtocolPolicyHttpOnly is a OriginProtocolPolicy enum value
	OriginProtocolPolicyHttpOnly = "http-only"

	// OriginProtocolPolicyMatchViewer is a OriginProtocolPolicy enum value
	OriginProtocolPolicyMatchViewer = "match-viewer"

	// OriginProtocolPolicyHttpsOnly is a OriginProtocolPolicy enum value
	OriginProtocolPolicyHttpsOnly = "https-only"
)

// OriginProtocolPolicy_Values returns all elements of the OriginProtocolPolicy enum
func OriginProtocolPolicy_Values() []string {
	return []string{
		OriginProtocolPolicyHttpOnly,
		OriginProtocolPolicyMatchViewer,
		OriginProtocolPolicyHttpsOnly,
	}
}

const (
	// OriginRequestPolicyCookieBehaviorNone is a OriginRequestPolicyCookieBehavior enum value
	OriginRequestPolicyCookieBehaviorNone = "none"

	// OriginRequestPolicyCookieBehaviorWhitelist is a OriginRequestPolicyCookieBehavior enum value
	OriginRequestPolicyCookieBehaviorWhitelist = "whitelist"

	// OriginRequestPolicyCookieBehaviorAll is a OriginRequestPolicyCookieBehavior enum value
	OriginRequestPolicyCookieBehaviorAll = "all"
)

// OriginRequestPolicyCookieBehavior_Values returns all elements of the OriginRequestPolicyCookieBehavior enum
func OriginRequestPolicyCookieBehavior_Values() []string {
	return []string{
		OriginRequestPolicyCookieBehaviorNone,
		OriginRequestPolicyCookieBehaviorWhitelist,
		OriginRequestPolicyCookieBehaviorAll,
	}
}

const (
	// OriginRequestPolicyHeaderBehaviorNone is a OriginRequestPolicyHeaderBehavior enum value
	OriginRequestPolicyHeaderBehaviorNone = "none"

	// OriginRequestPolicyHeaderBehaviorWhitelist is a OriginRequestPolicyHeaderBehavior enum value
	OriginRequestPolicyHeaderBehaviorWhitelist = "whitelist"

	// OriginRequestPolicyHeaderBehaviorAllViewer is a OriginRequestPolicyHeaderBehavior enum value
	OriginRequestPolicyHeaderBehaviorAllViewer = "allViewer"

	// OriginRequestPolicyHeaderBehaviorAllViewerAndWhitelistCloudFront is a OriginRequestPolicyHeaderBehavior enum value
	OriginRequestPolicyHeaderBehaviorAllViewerAndWhitelistCloudFront = "allViewerAndWhitelistCloudFront"
)

// OriginRequestPolicyHeaderBehavior_Values returns all elements of the OriginRequestPolicyHeaderBehavior enum
func OriginRequestPolicyHeaderBehavior_Values() []string {
	return []string{
		OriginRequestPolicyHeaderBehaviorNone,
		OriginRequestPolicyHeaderBehaviorWhitelist,
		OriginRequestPolicyHeaderBehaviorAllViewer,
		OriginRequestPolicyHeaderBehaviorAllViewerAndWhitelistCloudFront,
	}
}

const (
	// OriginRequestPolicyQueryStringBehaviorNone is a OriginRequestPolicyQueryStringBehavior enum value
	OriginRequestPolicyQueryStringBehaviorNone = "none"

	// OriginRequestPolicyQueryStringBehaviorWhitelist is a OriginRequestPolicyQueryStringBehavior enum value
	OriginRequestPolicyQueryStringBehaviorWhitelist = "whitelist"

	// OriginRequestPolicyQueryStringBehaviorAll is a OriginRequestPolicyQueryStringBehavior enum value
	OriginRequestPolicyQueryStringBehaviorAll = "all"
)

// OriginRequestPolicyQueryStringBehavior_Values returns all elements of the OriginRequestPolicyQueryStringBehavior enum
func OriginRequestPolicyQueryStringBehavior_Values() []string {
	return []string{
		OriginRequestPolicyQueryStringBehaviorNone,
		OriginRequestPolicyQueryStringBehaviorWhitelist,
		OriginRequestPolicyQueryStringBehaviorAll,
	}
}

const (
	// OriginRequestPolicyTypeManaged is a OriginRequestPolicyType enum value
	OriginRequestPolicyTypeManaged = "managed"

	// OriginRequestPolicyTypeCustom is a OriginRequestPolicyType enum value
	OriginRequestPolicyTypeCustom = "custom"
)

// OriginRequestPolicyType_Values returns all elements of the OriginRequestPolicyType enum
func OriginRequestPolicyType_Values() []string {
	return []string{
		OriginRequestPolicyTypeManaged,
		OriginRequestPolicyTypeCustom,
	}
}

const (
	// PriceClassPriceClass100 is a PriceClass enum value
	PriceClassPriceClass100 = "PriceClass_100"

	// PriceClassPriceClass200 is a PriceClass enum value
	PriceClassPriceClass200 = "PriceClass_200"

	// PriceClassPriceClassAll is a PriceClass enum value
	PriceClassPriceClassAll = "PriceClass_All"
)

// PriceClass_Values returns all elements of the PriceClass enum
func PriceClass_Values() []string {
	return []string{
		PriceClassPriceClass100,
		PriceClassPriceClass200,
		PriceClassPriceClassAll,
	}
}

const (
	// RealtimeMetricsSubscriptionStatusEnabled is a RealtimeMetricsSubscriptionStatus enum value
	RealtimeMetricsSubscriptionStatusEnabled = "Enabled"

	// RealtimeMetricsSubscriptionStatusDisabled is a RealtimeMetricsSubscriptionStatus enum value
	RealtimeMetricsSubscriptionStatusDisabled = "Disabled"
)

// RealtimeMetricsSubscriptionStatus_Values returns all elements of the RealtimeMetricsSubscriptionStatus enum
func RealtimeMetricsSubscriptionStatus_Values() []string {
	return []string{
		RealtimeMetricsSubscriptionStatusEnabled,
		RealtimeMetricsSubscriptionStatusDisabled,
	}
}

const (
	// SSLSupportMethodSniOnly is a SSLSupportMethod enum value
	SSLSupportMethodSniOnly = "sni-only"

	// SSLSupportMethodVip is a SSLSupportMethod enum value
	SSLSupportMethodVip = "vip"

	// SSLSupportMethodStaticIp is a SSLSupportMethod enum value
	SSLSupportMethodStaticIp = "static-ip"
)

// SSLSupportMethod_Values returns all elements of the SSLSupportMethod enum
func SSLSupportMethod_Values() []string {
	return []string{
		SSLSupportMethodSniOnly,
		SSLSupportMethodVip,
		SSLSupportMethodStaticIp,
	}
}

const (
	// SslProtocolSslv3 is a SslProtocol enum value
	SslProtocolSslv3 = "SSLv3"

	// SslProtocolTlsv1 is a SslProtocol enum value
	SslProtocolTlsv1 = "TLSv1"

	// SslProtocolTlsv11 is a SslProtocol enum value
	SslProtocolTlsv11 = "TLSv1.1"

	// SslProtocolTlsv12 is a SslProtocol enum value
	SslProtocolTlsv12 = "TLSv1.2"
)

// SslProtocol_Values returns all elements of the SslProtocol enum
func SslProtocol_Values() []string {
	return []string{
		SslProtocolSslv3,
		SslProtocolTlsv1,
		SslProtocolTlsv11,
		SslProtocolTlsv12,
	}
}

const (
	// ViewerProtocolPolicyAllowAll is a ViewerProtocolPolicy enum value
	ViewerProtocolPolicyAllowAll = "allow-all"

	// ViewerProtocolPolicyHttpsOnly is a ViewerProtocolPolicy enum value
	ViewerProtocolPolicyHttpsOnly = "https-only"

	// ViewerProtocolPolicyRedirectToHttps is a ViewerProtocolPolicy enum value
	ViewerProtocolPolicyRedirectToHttps = "redirect-to-https"
)

// ViewerProtocolPolicy_Values returns all elements of the ViewerProtocolPolicy enum
func ViewerProtocolPolicy_Values() []string {
	return []string{
		ViewerProtocolPolicyAllowAll,
		ViewerProtocolPolicyHttpsOnly,
		ViewerProtocolPolicyRedirectToHttps,
	}
}
