// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apprunner

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateCustomDomain = "AssociateCustomDomain"

// AssociateCustomDomainRequest generates a "aws/request.Request" representing the
// client's request for the AssociateCustomDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateCustomDomain for more information on using the AssociateCustomDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateCustomDomainRequest method.
//    req, resp := client.AssociateCustomDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/AssociateCustomDomain
func (c *AppRunner) AssociateCustomDomainRequest(input *AssociateCustomDomainInput) (req *request.Request, output *AssociateCustomDomainOutput) {
	op := &request.Operation{
		Name:       opAssociateCustomDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateCustomDomainInput{}
	}

	output = &AssociateCustomDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateCustomDomain API operation for AWS App Runner.
//
// Associate your own domain name with the AWS App Runner subdomain URL of your
// App Runner service.
//
// After you call AssociateCustomDomain and receive a successful response, use
// the information in the CustomDomain record that's returned to add CNAME records
// to your Domain Name System (DNS). For each mapped domain name, add a mapping
// to the target App Runner subdomain and one or more certificate validation
// records. App Runner then performs DNS validation to verify that you own or
// control the domain name that you associated. App Runner tracks domain validity
// in a certificate stored in AWS Certificate Manager (ACM) (https://docs.aws.amazon.com/acm/latest/userguide).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation AssociateCustomDomain for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/AssociateCustomDomain
func (c *AppRunner) AssociateCustomDomain(input *AssociateCustomDomainInput) (*AssociateCustomDomainOutput, error) {
	req, out := c.AssociateCustomDomainRequest(input)
	return out, req.Send()
}

// AssociateCustomDomainWithContext is the same as AssociateCustomDomain with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateCustomDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) AssociateCustomDomainWithContext(ctx aws.Context, input *AssociateCustomDomainInput, opts ...request.Option) (*AssociateCustomDomainOutput, error) {
	req, out := c.AssociateCustomDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAutoScalingConfiguration = "CreateAutoScalingConfiguration"

// CreateAutoScalingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAutoScalingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAutoScalingConfiguration for more information on using the CreateAutoScalingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAutoScalingConfigurationRequest method.
//    req, resp := client.CreateAutoScalingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/CreateAutoScalingConfiguration
func (c *AppRunner) CreateAutoScalingConfigurationRequest(input *CreateAutoScalingConfigurationInput) (req *request.Request, output *CreateAutoScalingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateAutoScalingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoScalingConfigurationInput{}
	}

	output = &CreateAutoScalingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAutoScalingConfiguration API operation for AWS App Runner.
//
// Create an AWS App Runner automatic scaling configuration resource. App Runner
// requires this resource when you create App Runner services that require non-default
// auto scaling settings. You can share an auto scaling configuration across
// multiple services.
//
// Create multiple revisions of a configuration by using the same AutoScalingConfigurationName
// and different AutoScalingConfigurationRevision values. When you create a
// service, you can set it to use the latest active revision of an auto scaling
// configuration or a specific revision.
//
// Configure a higher MinSize to increase the spread of your App Runner service
// over more Availability Zones in the AWS Region. The tradeoff is a higher
// minimal cost.
//
// Configure a lower MaxSize to control your cost. The tradeoff is lower responsiveness
// during peak demand.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation CreateAutoScalingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ServiceQuotaExceededException
//   App Runner can't create this resource. You've reached your account quota
//   for this resource type.
//
//   For App Runner per-resource quotas, see AWS App Runner endpoints and quotas
//   (https://docs.aws.amazon.com/general/latest/gr/apprunner.html) in the AWS
//   General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/CreateAutoScalingConfiguration
func (c *AppRunner) CreateAutoScalingConfiguration(input *CreateAutoScalingConfigurationInput) (*CreateAutoScalingConfigurationOutput, error) {
	req, out := c.CreateAutoScalingConfigurationRequest(input)
	return out, req.Send()
}

// CreateAutoScalingConfigurationWithContext is the same as CreateAutoScalingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutoScalingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) CreateAutoScalingConfigurationWithContext(ctx aws.Context, input *CreateAutoScalingConfigurationInput, opts ...request.Option) (*CreateAutoScalingConfigurationOutput, error) {
	req, out := c.CreateAutoScalingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectionRequest method.
//    req, resp := client.CreateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/CreateConnection
func (c *AppRunner) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *CreateConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &CreateConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for AWS App Runner.
//
// Create an AWS App Runner connection resource. App Runner requires a connection
// resource when you create App Runner services that access private repositories
// from certain third-party providers. You can share a connection across multiple
// services.
//
// A connection resource is needed to access GitHub repositories. GitHub requires
// a user interface approval process through the App Runner console before you
// can use the connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation CreateConnection for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ServiceQuotaExceededException
//   App Runner can't create this resource. You've reached your account quota
//   for this resource type.
//
//   For App Runner per-resource quotas, see AWS App Runner endpoints and quotas
//   (https://docs.aws.amazon.com/general/latest/gr/apprunner.html) in the AWS
//   General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/CreateConnection
func (c *AppRunner) CreateConnection(input *CreateConnectionInput) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServiceRequest method.
//    req, resp := client.CreateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/CreateService
func (c *AppRunner) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for AWS App Runner.
//
// Create an AWS App Runner service. After the service is created, the action
// also automatically starts a deployment.
//
// This is an asynchronous operation. On a successful call, you can use the
// returned OperationId and the ListOperations (https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html)
// call to track the operation's progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation CreateService for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ServiceQuotaExceededException
//   App Runner can't create this resource. You've reached your account quota
//   for this resource type.
//
//   For App Runner per-resource quotas, see AWS App Runner endpoints and quotas
//   (https://docs.aws.amazon.com/general/latest/gr/apprunner.html) in the AWS
//   General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/CreateService
func (c *AppRunner) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAutoScalingConfiguration = "DeleteAutoScalingConfiguration"

// DeleteAutoScalingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAutoScalingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAutoScalingConfiguration for more information on using the DeleteAutoScalingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAutoScalingConfigurationRequest method.
//    req, resp := client.DeleteAutoScalingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DeleteAutoScalingConfiguration
func (c *AppRunner) DeleteAutoScalingConfigurationRequest(input *DeleteAutoScalingConfigurationInput) (req *request.Request, output *DeleteAutoScalingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteAutoScalingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoScalingConfigurationInput{}
	}

	output = &DeleteAutoScalingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAutoScalingConfiguration API operation for AWS App Runner.
//
// Delete an AWS App Runner automatic scaling configuration resource. You can
// delete a specific revision or the latest active revision. You can't delete
// a configuration that's used by one or more App Runner services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DeleteAutoScalingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DeleteAutoScalingConfiguration
func (c *AppRunner) DeleteAutoScalingConfiguration(input *DeleteAutoScalingConfigurationInput) (*DeleteAutoScalingConfigurationOutput, error) {
	req, out := c.DeleteAutoScalingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteAutoScalingConfigurationWithContext is the same as DeleteAutoScalingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAutoScalingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DeleteAutoScalingConfigurationWithContext(ctx aws.Context, input *DeleteAutoScalingConfigurationInput, opts ...request.Option) (*DeleteAutoScalingConfigurationOutput, error) {
	req, out := c.DeleteAutoScalingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DeleteConnection
func (c *AppRunner) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS App Runner.
//
// Delete an AWS App Runner connection. You must first ensure that there are
// no running App Runner services that use this connection. If there are any,
// the DeleteConnection action fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DeleteConnection
func (c *AppRunner) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceRequest method.
//    req, resp := client.DeleteServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DeleteService
func (c *AppRunner) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteService API operation for AWS App Runner.
//
// Delete an AWS App Runner service.
//
// This is an asynchronous operation. On a successful call, you can use the
// returned OperationId and the ListOperations call to track the operation's
// progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DeleteService for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DeleteService
func (c *AppRunner) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutoScalingConfiguration = "DescribeAutoScalingConfiguration"

// DescribeAutoScalingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutoScalingConfiguration for more information on using the DescribeAutoScalingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutoScalingConfigurationRequest method.
//    req, resp := client.DescribeAutoScalingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeAutoScalingConfiguration
func (c *AppRunner) DescribeAutoScalingConfigurationRequest(input *DescribeAutoScalingConfigurationInput) (req *request.Request, output *DescribeAutoScalingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoScalingConfigurationInput{}
	}

	output = &DescribeAutoScalingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutoScalingConfiguration API operation for AWS App Runner.
//
// Return a full description of an AWS App Runner automatic scaling configuration
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DescribeAutoScalingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeAutoScalingConfiguration
func (c *AppRunner) DescribeAutoScalingConfiguration(input *DescribeAutoScalingConfigurationInput) (*DescribeAutoScalingConfigurationOutput, error) {
	req, out := c.DescribeAutoScalingConfigurationRequest(input)
	return out, req.Send()
}

// DescribeAutoScalingConfigurationWithContext is the same as DescribeAutoScalingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoScalingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DescribeAutoScalingConfigurationWithContext(ctx aws.Context, input *DescribeAutoScalingConfigurationInput, opts ...request.Option) (*DescribeAutoScalingConfigurationOutput, error) {
	req, out := c.DescribeAutoScalingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomDomains = "DescribeCustomDomains"

// DescribeCustomDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomDomains for more information on using the DescribeCustomDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCustomDomainsRequest method.
//    req, resp := client.DescribeCustomDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeCustomDomains
func (c *AppRunner) DescribeCustomDomainsRequest(input *DescribeCustomDomainsInput) (req *request.Request, output *DescribeCustomDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCustomDomainsInput{}
	}

	output = &DescribeCustomDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomDomains API operation for AWS App Runner.
//
// Return a description of custom domain names that are associated with an AWS
// App Runner service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DescribeCustomDomains for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeCustomDomains
func (c *AppRunner) DescribeCustomDomains(input *DescribeCustomDomainsInput) (*DescribeCustomDomainsOutput, error) {
	req, out := c.DescribeCustomDomainsRequest(input)
	return out, req.Send()
}

// DescribeCustomDomainsWithContext is the same as DescribeCustomDomains with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DescribeCustomDomainsWithContext(ctx aws.Context, input *DescribeCustomDomainsInput, opts ...request.Option) (*DescribeCustomDomainsOutput, error) {
	req, out := c.DescribeCustomDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCustomDomainsPages iterates over the pages of a DescribeCustomDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCustomDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCustomDomains operation.
//    pageNum := 0
//    err := client.DescribeCustomDomainsPages(params,
//        func(page *apprunner.DescribeCustomDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRunner) DescribeCustomDomainsPages(input *DescribeCustomDomainsInput, fn func(*DescribeCustomDomainsOutput, bool) bool) error {
	return c.DescribeCustomDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCustomDomainsPagesWithContext same as DescribeCustomDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DescribeCustomDomainsPagesWithContext(ctx aws.Context, input *DescribeCustomDomainsInput, fn func(*DescribeCustomDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCustomDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCustomDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCustomDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeService = "DescribeService"

// DescribeServiceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeService for more information on using the DescribeService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServiceRequest method.
//    req, resp := client.DescribeServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeService
func (c *AppRunner) DescribeServiceRequest(input *DescribeServiceInput) (req *request.Request, output *DescribeServiceOutput) {
	op := &request.Operation{
		Name:       opDescribeService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceInput{}
	}

	output = &DescribeServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeService API operation for AWS App Runner.
//
// Return a full description of an AWS App Runner service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DescribeService for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DescribeService
func (c *AppRunner) DescribeService(input *DescribeServiceInput) (*DescribeServiceOutput, error) {
	req, out := c.DescribeServiceRequest(input)
	return out, req.Send()
}

// DescribeServiceWithContext is the same as DescribeService with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DescribeServiceWithContext(ctx aws.Context, input *DescribeServiceInput, opts ...request.Option) (*DescribeServiceOutput, error) {
	req, out := c.DescribeServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateCustomDomain = "DisassociateCustomDomain"

// DisassociateCustomDomainRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateCustomDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateCustomDomain for more information on using the DisassociateCustomDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateCustomDomainRequest method.
//    req, resp := client.DisassociateCustomDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DisassociateCustomDomain
func (c *AppRunner) DisassociateCustomDomainRequest(input *DisassociateCustomDomainInput) (req *request.Request, output *DisassociateCustomDomainOutput) {
	op := &request.Operation{
		Name:       opDisassociateCustomDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateCustomDomainInput{}
	}

	output = &DisassociateCustomDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateCustomDomain API operation for AWS App Runner.
//
// Disassociate a custom domain name from an AWS App Runner service.
//
// Certificates tracking domain validity are associated with a custom domain
// and are stored in AWS Certificate Manager (ACM) (https://docs.aws.amazon.com/acm/latest/userguide).
// These certificates aren't deleted as part of this action. App Runner delays
// certificate deletion for 30 days after a domain is disassociated from your
// service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation DisassociateCustomDomain for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/DisassociateCustomDomain
func (c *AppRunner) DisassociateCustomDomain(input *DisassociateCustomDomainInput) (*DisassociateCustomDomainOutput, error) {
	req, out := c.DisassociateCustomDomainRequest(input)
	return out, req.Send()
}

// DisassociateCustomDomainWithContext is the same as DisassociateCustomDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateCustomDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) DisassociateCustomDomainWithContext(ctx aws.Context, input *DisassociateCustomDomainInput, opts ...request.Option) (*DisassociateCustomDomainOutput, error) {
	req, out := c.DisassociateCustomDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAutoScalingConfigurations = "ListAutoScalingConfigurations"

// ListAutoScalingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAutoScalingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAutoScalingConfigurations for more information on using the ListAutoScalingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAutoScalingConfigurationsRequest method.
//    req, resp := client.ListAutoScalingConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListAutoScalingConfigurations
func (c *AppRunner) ListAutoScalingConfigurationsRequest(input *ListAutoScalingConfigurationsInput) (req *request.Request, output *ListAutoScalingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListAutoScalingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAutoScalingConfigurationsInput{}
	}

	output = &ListAutoScalingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAutoScalingConfigurations API operation for AWS App Runner.
//
// Returns a list of AWS App Runner automatic scaling configurations in your
// AWS account. You can query the revisions for a specific configuration name
// or the revisions for all configurations in your account. You can optionally
// query only the latest revision of each requested name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation ListAutoScalingConfigurations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListAutoScalingConfigurations
func (c *AppRunner) ListAutoScalingConfigurations(input *ListAutoScalingConfigurationsInput) (*ListAutoScalingConfigurationsOutput, error) {
	req, out := c.ListAutoScalingConfigurationsRequest(input)
	return out, req.Send()
}

// ListAutoScalingConfigurationsWithContext is the same as ListAutoScalingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAutoScalingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListAutoScalingConfigurationsWithContext(ctx aws.Context, input *ListAutoScalingConfigurationsInput, opts ...request.Option) (*ListAutoScalingConfigurationsOutput, error) {
	req, out := c.ListAutoScalingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAutoScalingConfigurationsPages iterates over the pages of a ListAutoScalingConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAutoScalingConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAutoScalingConfigurations operation.
//    pageNum := 0
//    err := client.ListAutoScalingConfigurationsPages(params,
//        func(page *apprunner.ListAutoScalingConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRunner) ListAutoScalingConfigurationsPages(input *ListAutoScalingConfigurationsInput, fn func(*ListAutoScalingConfigurationsOutput, bool) bool) error {
	return c.ListAutoScalingConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAutoScalingConfigurationsPagesWithContext same as ListAutoScalingConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListAutoScalingConfigurationsPagesWithContext(ctx aws.Context, input *ListAutoScalingConfigurationsInput, fn func(*ListAutoScalingConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAutoScalingConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAutoScalingConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAutoScalingConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConnections = "ListConnections"

// ListConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnections for more information on using the ListConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConnectionsRequest method.
//    req, resp := client.ListConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListConnections
func (c *AppRunner) ListConnectionsRequest(input *ListConnectionsInput) (req *request.Request, output *ListConnectionsOutput) {
	op := &request.Operation{
		Name:       opListConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConnectionsInput{}
	}

	output = &ListConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnections API operation for AWS App Runner.
//
// Returns a list of AWS App Runner connections that are associated with your
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation ListConnections for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListConnections
func (c *AppRunner) ListConnections(input *ListConnectionsInput) (*ListConnectionsOutput, error) {
	req, out := c.ListConnectionsRequest(input)
	return out, req.Send()
}

// ListConnectionsWithContext is the same as ListConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListConnectionsWithContext(ctx aws.Context, input *ListConnectionsInput, opts ...request.Option) (*ListConnectionsOutput, error) {
	req, out := c.ListConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConnectionsPages iterates over the pages of a ListConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConnections operation.
//    pageNum := 0
//    err := client.ListConnectionsPages(params,
//        func(page *apprunner.ListConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRunner) ListConnectionsPages(input *ListConnectionsInput, fn func(*ListConnectionsOutput, bool) bool) error {
	return c.ListConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConnectionsPagesWithContext same as ListConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListConnectionsPagesWithContext(ctx aws.Context, input *ListConnectionsInput, fn func(*ListConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOperations = "ListOperations"

// ListOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOperations for more information on using the ListOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOperationsRequest method.
//    req, resp := client.ListOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListOperations
func (c *AppRunner) ListOperationsRequest(input *ListOperationsInput) (req *request.Request, output *ListOperationsOutput) {
	op := &request.Operation{
		Name:       opListOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOperationsInput{}
	}

	output = &ListOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOperations API operation for AWS App Runner.
//
// Return a list of operations that occurred on an AWS App Runner service.
//
// The resulting list of OperationSummary objects is sorted in reverse chronological
// order. The first object on the list represents the last started operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation ListOperations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListOperations
func (c *AppRunner) ListOperations(input *ListOperationsInput) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	return out, req.Send()
}

// ListOperationsWithContext is the same as ListOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListOperationsWithContext(ctx aws.Context, input *ListOperationsInput, opts ...request.Option) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOperationsPages iterates over the pages of a ListOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOperations operation.
//    pageNum := 0
//    err := client.ListOperationsPages(params,
//        func(page *apprunner.ListOperationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRunner) ListOperationsPages(input *ListOperationsInput, fn func(*ListOperationsOutput, bool) bool) error {
	return c.ListOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOperationsPagesWithContext same as ListOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListOperationsPagesWithContext(ctx aws.Context, input *ListOperationsInput, fn func(*ListOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServicesRequest method.
//    req, resp := client.ListServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListServices
func (c *AppRunner) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for AWS App Runner.
//
// Returns a list of running AWS App Runner services in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListServices
func (c *AppRunner) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServices operation.
//    pageNum := 0
//    err := client.ListServicesPages(params,
//        func(page *apprunner.ListServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRunner) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListTagsForResource
func (c *AppRunner) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS App Runner.
//
// List tags that are associated with for an AWS App Runner resource. The response
// contains a list of tag key-value pairs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ListTagsForResource
func (c *AppRunner) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPauseService = "PauseService"

// PauseServiceRequest generates a "aws/request.Request" representing the
// client's request for the PauseService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PauseService for more information on using the PauseService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PauseServiceRequest method.
//    req, resp := client.PauseServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/PauseService
func (c *AppRunner) PauseServiceRequest(input *PauseServiceInput) (req *request.Request, output *PauseServiceOutput) {
	op := &request.Operation{
		Name:       opPauseService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PauseServiceInput{}
	}

	output = &PauseServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PauseService API operation for AWS App Runner.
//
// Pause an active AWS App Runner service. App Runner reduces compute capacity
// for the service to zero and loses state (for example, ephemeral storage is
// removed).
//
// This is an asynchronous operation. On a successful call, you can use the
// returned OperationId and the ListOperations call to track the operation's
// progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation PauseService for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/PauseService
func (c *AppRunner) PauseService(input *PauseServiceInput) (*PauseServiceOutput, error) {
	req, out := c.PauseServiceRequest(input)
	return out, req.Send()
}

// PauseServiceWithContext is the same as PauseService with the addition of
// the ability to pass a context and additional request options.
//
// See PauseService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) PauseServiceWithContext(ctx aws.Context, input *PauseServiceInput, opts ...request.Option) (*PauseServiceOutput, error) {
	req, out := c.PauseServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeService = "ResumeService"

// ResumeServiceRequest generates a "aws/request.Request" representing the
// client's request for the ResumeService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeService for more information on using the ResumeService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResumeServiceRequest method.
//    req, resp := client.ResumeServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ResumeService
func (c *AppRunner) ResumeServiceRequest(input *ResumeServiceInput) (req *request.Request, output *ResumeServiceOutput) {
	op := &request.Operation{
		Name:       opResumeService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeServiceInput{}
	}

	output = &ResumeServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResumeService API operation for AWS App Runner.
//
// Resume an active AWS App Runner service. App Runner provisions compute capacity
// for the service.
//
// This is an asynchronous operation. On a successful call, you can use the
// returned OperationId and the ListOperations call to track the operation's
// progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation ResumeService for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/ResumeService
func (c *AppRunner) ResumeService(input *ResumeServiceInput) (*ResumeServiceOutput, error) {
	req, out := c.ResumeServiceRequest(input)
	return out, req.Send()
}

// ResumeServiceWithContext is the same as ResumeService with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) ResumeServiceWithContext(ctx aws.Context, input *ResumeServiceInput, opts ...request.Option) (*ResumeServiceOutput, error) {
	req, out := c.ResumeServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDeployment = "StartDeployment"

// StartDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StartDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDeployment for more information on using the StartDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDeploymentRequest method.
//    req, resp := client.StartDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/StartDeployment
func (c *AppRunner) StartDeploymentRequest(input *StartDeploymentInput) (req *request.Request, output *StartDeploymentOutput) {
	op := &request.Operation{
		Name:       opStartDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDeploymentInput{}
	}

	output = &StartDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDeployment API operation for AWS App Runner.
//
// Initiate a manual deployment of the latest commit in a source code repository
// or the latest image in a source image repository to an AWS App Runner service.
//
// For a source code repository, App Runner retrieves the commit and builds
// a Docker image. For a source image repository, App Runner retrieves the latest
// Docker image. In both cases, App Runner then deploys the new image to your
// service and starts a new container instance.
//
// This is an asynchronous operation. On a successful call, you can use the
// returned OperationId and the ListOperations call to track the operation's
// progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation StartDeployment for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/StartDeployment
func (c *AppRunner) StartDeployment(input *StartDeploymentInput) (*StartDeploymentOutput, error) {
	req, out := c.StartDeploymentRequest(input)
	return out, req.Send()
}

// StartDeploymentWithContext is the same as StartDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StartDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) StartDeploymentWithContext(ctx aws.Context, input *StartDeploymentInput, opts ...request.Option) (*StartDeploymentOutput, error) {
	req, out := c.StartDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/TagResource
func (c *AppRunner) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS App Runner.
//
// Add tags to, or update the tag values of, an App Runner resource. A tag is
// a key-value pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/TagResource
func (c *AppRunner) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/UntagResource
func (c *AppRunner) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS App Runner.
//
// Remove tags from an App Runner resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/UntagResource
func (c *AppRunner) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServiceRequest method.
//    req, resp := client.UpdateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/UpdateService
func (c *AppRunner) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateService API operation for AWS App Runner.
//
// Update an AWS App Runner service. You can update the source configuration
// and instance configuration of the service. You can also update the ARN of
// the auto scaling configuration resource that's associated with the service.
// However, you can't change the name or the encryption configuration of the
// service. These can be set only when you create the service.
//
// To update the tags applied to your service, use the separate actions TagResource
// and UntagResource.
//
// This is an asynchronous operation. On a successful call, you can use the
// returned OperationId and the ListOperations call to track the operation's
// progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Runner's
// API operation UpdateService for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   One or more input parameters aren't valid. Refer to the API action's document
//   page, correct the input parameters, and try the action again.
//
//   * ResourceNotFoundException
//   A resource doesn't exist for the specified Amazon Resource Name (ARN) in
//   your AWS account.
//
//   * InvalidStateException
//   You can't perform this action when the resource is in its current state.
//
//   * InternalServiceErrorException
//   An unexpected service exception occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apprunner-2020-05-15/UpdateService
func (c *AppRunner) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRunner) UpdateServiceWithContext(ctx aws.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateCustomDomainInput struct {
	_ struct{} `type:"structure"`

	// A custom domain endpoint to associate. Specify a root domain (for example,
	// example.com), a subdomain (for example, login.example.com or admin.login.example.com),
	// or a wildcard (for example, *.example.com).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// Set to true to associate the subdomain www.DomainName with the App Runner
	// service in addition to the base domain.
	//
	// Default: true
	EnableWWWSubdomain *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// associate a custom domain name with.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateCustomDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateCustomDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateCustomDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateCustomDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AssociateCustomDomainInput) SetDomainName(v string) *AssociateCustomDomainInput {
	s.DomainName = &v
	return s
}

// SetEnableWWWSubdomain sets the EnableWWWSubdomain field's value.
func (s *AssociateCustomDomainInput) SetEnableWWWSubdomain(v bool) *AssociateCustomDomainInput {
	s.EnableWWWSubdomain = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *AssociateCustomDomainInput) SetServiceArn(v string) *AssociateCustomDomainInput {
	s.ServiceArn = &v
	return s
}

type AssociateCustomDomainOutput struct {
	_ struct{} `type:"structure"`

	// A description of the domain name that's being associated.
	//
	// CustomDomain is a required field
	CustomDomain *CustomDomain `type:"structure" required:"true"`

	// The App Runner subdomain of the App Runner service. The custom domain name
	// is mapped to this target name.
	//
	// DNSTarget is a required field
	DNSTarget *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the App Runner service with which a custom
	// domain name is associated.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateCustomDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateCustomDomainOutput) GoString() string {
	return s.String()
}

// SetCustomDomain sets the CustomDomain field's value.
func (s *AssociateCustomDomainOutput) SetCustomDomain(v *CustomDomain) *AssociateCustomDomainOutput {
	s.CustomDomain = v
	return s
}

// SetDNSTarget sets the DNSTarget field's value.
func (s *AssociateCustomDomainOutput) SetDNSTarget(v string) *AssociateCustomDomainOutput {
	s.DNSTarget = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *AssociateCustomDomainOutput) SetServiceArn(v string) *AssociateCustomDomainOutput {
	s.ServiceArn = &v
	return s
}

// Describes resources needed to authenticate access to some source repositories.
// The specific resource depends on the repository provider.
type AuthenticationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants the App Runner
	// service access to a source repository. It's required for ECR image repositories
	// (but not for ECR Public repositories).
	AccessRoleArn *string `min:"29" type:"string"`

	// The Amazon Resource Name (ARN) of the App Runner connection that enables
	// the App Runner service to connect to a source repository. It's required for
	// GitHub code repositories.
	ConnectionArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthenticationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthenticationConfiguration"}
	if s.AccessRoleArn != nil && len(*s.AccessRoleArn) < 29 {
		invalidParams.Add(request.NewErrParamMinLen("AccessRoleArn", 29))
	}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessRoleArn sets the AccessRoleArn field's value.
func (s *AuthenticationConfiguration) SetAccessRoleArn(v string) *AuthenticationConfiguration {
	s.AccessRoleArn = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *AuthenticationConfiguration) SetConnectionArn(v string) *AuthenticationConfiguration {
	s.ConnectionArn = &v
	return s
}

// Describes an AWS App Runner automatic scaling configuration resource. Multiple
// revisions of a configuration have the same AutoScalingConfigurationName and
// different AutoScalingConfigurationRevision values.
//
// A higher MinSize increases the spread of your App Runner service over more
// Availability Zones in the AWS Region. The tradeoff is a higher minimal cost.
//
// A lower MaxSize controls your cost. The tradeoff is lower responsiveness
// during peak demand.
type AutoScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this auto scaling configuration.
	AutoScalingConfigurationArn *string `min:"1" type:"string"`

	// The customer-provided auto scaling configuration name. It can be used in
	// multiple revisions of a configuration.
	AutoScalingConfigurationName *string `min:"4" type:"string"`

	// The revision of this auto scaling configuration. It's unique among all the
	// active configurations ("Status": "ACTIVE") that share the same AutoScalingConfigurationName.
	AutoScalingConfigurationRevision *int64 `type:"integer"`

	// The time when the auto scaling configuration was created. It's in Unix time
	// stamp format.
	CreatedAt *time.Time `type:"timestamp"`

	// The time when the auto scaling configuration was deleted. It's in Unix time
	// stamp format.
	DeletedAt *time.Time `type:"timestamp"`

	// It's set to true for the configuration with the highest Revision among all
	// configurations that share the same Name. It's set to false otherwise.
	Latest *bool `type:"boolean"`

	// The maximum number of concurrent requests that an instance processes. If
	// the number of concurrent requests exceeds this limit, App Runner scales the
	// service up.
	MaxConcurrency *int64 `type:"integer"`

	// The maximum number of instances that a service scales up to. At most MaxSize
	// instances actively serve traffic for your service.
	MaxSize *int64 `type:"integer"`

	// The minimum number of instances that App Runner provisions for a service.
	// The service always has at least MinSize provisioned instances. Some of them
	// actively serve traffic. The rest of them (provisioned and inactive instances)
	// are a cost-effective compute capacity reserve and are ready to be quickly
	// activated. You pay for memory usage of all the provisioned instances. You
	// pay for CPU usage of only the active subset.
	//
	// App Runner temporarily doubles the number of provisioned instances during
	// deployments, to maintain the same capacity for both old and new code.
	MinSize *int64 `type:"integer"`

	// The current state of the auto scaling configuration. If the status of a configuration
	// revision is INACTIVE, it was deleted and can't be used. Inactive configuration
	// revisions are permanently removed some time after they are deleted.
	Status *string `type:"string" enum:"AutoScalingConfigurationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingConfiguration) GoString() string {
	return s.String()
}

// SetAutoScalingConfigurationArn sets the AutoScalingConfigurationArn field's value.
func (s *AutoScalingConfiguration) SetAutoScalingConfigurationArn(v string) *AutoScalingConfiguration {
	s.AutoScalingConfigurationArn = &v
	return s
}

// SetAutoScalingConfigurationName sets the AutoScalingConfigurationName field's value.
func (s *AutoScalingConfiguration) SetAutoScalingConfigurationName(v string) *AutoScalingConfiguration {
	s.AutoScalingConfigurationName = &v
	return s
}

// SetAutoScalingConfigurationRevision sets the AutoScalingConfigurationRevision field's value.
func (s *AutoScalingConfiguration) SetAutoScalingConfigurationRevision(v int64) *AutoScalingConfiguration {
	s.AutoScalingConfigurationRevision = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AutoScalingConfiguration) SetCreatedAt(v time.Time) *AutoScalingConfiguration {
	s.CreatedAt = &v
	return s
}

// SetDeletedAt sets the DeletedAt field's value.
func (s *AutoScalingConfiguration) SetDeletedAt(v time.Time) *AutoScalingConfiguration {
	s.DeletedAt = &v
	return s
}

// SetLatest sets the Latest field's value.
func (s *AutoScalingConfiguration) SetLatest(v bool) *AutoScalingConfiguration {
	s.Latest = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AutoScalingConfiguration) SetMaxConcurrency(v int64) *AutoScalingConfiguration {
	s.MaxConcurrency = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *AutoScalingConfiguration) SetMaxSize(v int64) *AutoScalingConfiguration {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *AutoScalingConfiguration) SetMinSize(v int64) *AutoScalingConfiguration {
	s.MinSize = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoScalingConfiguration) SetStatus(v string) *AutoScalingConfiguration {
	s.Status = &v
	return s
}

// Provides summary information about an AWS App Runner automatic scaling configuration
// resource.
//
// This type contains limited information about an auto scaling configuration.
// It includes only identification information, without configuration details.
// It's returned by the ListAutoScalingConfigurations action. Complete configuration
// information is returned by the CreateAutoScalingConfiguration, DescribeAutoScalingConfiguration,
// and DeleteAutoScalingConfiguration actions using the AutoScalingConfiguration
// type.
type AutoScalingConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this auto scaling configuration.
	AutoScalingConfigurationArn *string `min:"1" type:"string"`

	// The customer-provided auto scaling configuration name. It can be used in
	// multiple revisions of a configuration.
	AutoScalingConfigurationName *string `min:"4" type:"string"`

	// The revision of this auto scaling configuration. It's unique among all the
	// active configurations ("Status": "ACTIVE") with the same AutoScalingConfigurationName.
	AutoScalingConfigurationRevision *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingConfigurationSummary) GoString() string {
	return s.String()
}

// SetAutoScalingConfigurationArn sets the AutoScalingConfigurationArn field's value.
func (s *AutoScalingConfigurationSummary) SetAutoScalingConfigurationArn(v string) *AutoScalingConfigurationSummary {
	s.AutoScalingConfigurationArn = &v
	return s
}

// SetAutoScalingConfigurationName sets the AutoScalingConfigurationName field's value.
func (s *AutoScalingConfigurationSummary) SetAutoScalingConfigurationName(v string) *AutoScalingConfigurationSummary {
	s.AutoScalingConfigurationName = &v
	return s
}

// SetAutoScalingConfigurationRevision sets the AutoScalingConfigurationRevision field's value.
func (s *AutoScalingConfigurationSummary) SetAutoScalingConfigurationRevision(v int64) *AutoScalingConfigurationSummary {
	s.AutoScalingConfigurationRevision = &v
	return s
}

// Describes a certificate CNAME record to add to your DNS. For more information,
// see AssociateCustomDomain (https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html).
type CertificateValidationRecord struct {
	_ struct{} `type:"structure"`

	// The certificate CNAME record name.
	Name *string `type:"string"`

	// The current state of the certificate CNAME record validation. It should change
	// to SUCCESS after App Runner completes validation with your DNS.
	Status *string `type:"string" enum:"CertificateValidationRecordStatus"`

	// The record type, always CNAME.
	Type *string `type:"string"`

	// The certificate CNAME record value.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateValidationRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateValidationRecord) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CertificateValidationRecord) SetName(v string) *CertificateValidationRecord {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateValidationRecord) SetStatus(v string) *CertificateValidationRecord {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CertificateValidationRecord) SetType(v string) *CertificateValidationRecord {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CertificateValidationRecord) SetValue(v string) *CertificateValidationRecord {
	s.Value = &v
	return s
}

// Describes the configuration that AWS App Runner uses to build and run an
// App Runner service from a source code repository.
type CodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The basic configuration for building and running the App Runner service.
	// Use it to quickly launch an App Runner service without providing a apprunner.yaml
	// file in the source code repository (or ignoring the file if it exists).
	CodeConfigurationValues *CodeConfigurationValues `type:"structure"`

	// The source of the App Runner configuration. Values are interpreted as follows:
	//
	//    * REPOSITORY – App Runner reads configuration values from the apprunner.yaml
	//    file in the source code repository and ignores CodeConfigurationValues.
	//
	//    * API – App Runner uses configuration values provided in CodeConfigurationValues
	//    and ignores the apprunner.yaml file in the source code repository.
	//
	// ConfigurationSource is a required field
	ConfigurationSource *string `type:"string" required:"true" enum:"ConfigurationSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeConfiguration"}
	if s.ConfigurationSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSource"))
	}
	if s.CodeConfigurationValues != nil {
		if err := s.CodeConfigurationValues.Validate(); err != nil {
			invalidParams.AddNested("CodeConfigurationValues", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeConfigurationValues sets the CodeConfigurationValues field's value.
func (s *CodeConfiguration) SetCodeConfigurationValues(v *CodeConfigurationValues) *CodeConfiguration {
	s.CodeConfigurationValues = v
	return s
}

// SetConfigurationSource sets the ConfigurationSource field's value.
func (s *CodeConfiguration) SetConfigurationSource(v string) *CodeConfiguration {
	s.ConfigurationSource = &v
	return s
}

// Describes the basic configuration needed for building and running an AWS
// App Runner service. This type doesn't support the full set of possible configuration
// options. Fur full configuration capabilities, use a apprunner.yaml file in
// the source code repository.
type CodeConfigurationValues struct {
	_ struct{} `type:"structure"`

	// The command App Runner runs to build your application.
	//
	// BuildCommand is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CodeConfigurationValues's
	// String and GoString methods.
	BuildCommand *string `type:"string" sensitive:"true"`

	// The port that your application listens to in the container.
	//
	// Default: 8080
	Port *string `type:"string"`

	// A runtime environment type for building and running an App Runner service.
	// It represents a programming language runtime.
	//
	// Runtime is a required field
	Runtime *string `type:"string" required:"true" enum:"Runtime"`

	// The environment variables that are available to your running App Runner service.
	// An array of key-value pairs. Keys with a prefix of AWSAPPRUNNER are reserved
	// for system use and aren't valid.
	RuntimeEnvironmentVariables map[string]*string `type:"map"`

	// The command App Runner runs to start your application.
	//
	// StartCommand is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CodeConfigurationValues's
	// String and GoString methods.
	StartCommand *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeConfigurationValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeConfigurationValues) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeConfigurationValues) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeConfigurationValues"}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildCommand sets the BuildCommand field's value.
func (s *CodeConfigurationValues) SetBuildCommand(v string) *CodeConfigurationValues {
	s.BuildCommand = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CodeConfigurationValues) SetPort(v string) *CodeConfigurationValues {
	s.Port = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *CodeConfigurationValues) SetRuntime(v string) *CodeConfigurationValues {
	s.Runtime = &v
	return s
}

// SetRuntimeEnvironmentVariables sets the RuntimeEnvironmentVariables field's value.
func (s *CodeConfigurationValues) SetRuntimeEnvironmentVariables(v map[string]*string) *CodeConfigurationValues {
	s.RuntimeEnvironmentVariables = v
	return s
}

// SetStartCommand sets the StartCommand field's value.
func (s *CodeConfigurationValues) SetStartCommand(v string) *CodeConfigurationValues {
	s.StartCommand = &v
	return s
}

// Describes a source code repository.
type CodeRepository struct {
	_ struct{} `type:"structure"`

	// Configuration for building and running the service from a source code repository.
	CodeConfiguration *CodeConfiguration `type:"structure"`

	// The location of the repository that contains the source code.
	//
	// RepositoryUrl is a required field
	RepositoryUrl *string `type:"string" required:"true"`

	// The version that should be used within the source code repository.
	//
	// SourceCodeVersion is a required field
	SourceCodeVersion *SourceCodeVersion `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeRepository"}
	if s.RepositoryUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryUrl"))
	}
	if s.SourceCodeVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceCodeVersion"))
	}
	if s.CodeConfiguration != nil {
		if err := s.CodeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CodeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceCodeVersion != nil {
		if err := s.SourceCodeVersion.Validate(); err != nil {
			invalidParams.AddNested("SourceCodeVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeConfiguration sets the CodeConfiguration field's value.
func (s *CodeRepository) SetCodeConfiguration(v *CodeConfiguration) *CodeRepository {
	s.CodeConfiguration = v
	return s
}

// SetRepositoryUrl sets the RepositoryUrl field's value.
func (s *CodeRepository) SetRepositoryUrl(v string) *CodeRepository {
	s.RepositoryUrl = &v
	return s
}

// SetSourceCodeVersion sets the SourceCodeVersion field's value.
func (s *CodeRepository) SetSourceCodeVersion(v *SourceCodeVersion) *CodeRepository {
	s.SourceCodeVersion = v
	return s
}

// Describes an AWS App Runner connection resource.
type Connection struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this connection.
	ConnectionArn *string `min:"1" type:"string"`

	// The customer-provided connection name.
	ConnectionName *string `min:"4" type:"string"`

	// The App Runner connection creation time, expressed as a Unix time stamp.
	CreatedAt *time.Time `type:"timestamp"`

	// The source repository provider.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The current state of the App Runner connection. When the state is AVAILABLE,
	// you can use the connection to create an App Runner service.
	Status *string `type:"string" enum:"ConnectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *Connection) SetConnectionArn(v string) *Connection {
	s.ConnectionArn = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *Connection) SetConnectionName(v string) *Connection {
	s.ConnectionName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Connection) SetCreatedAt(v time.Time) *Connection {
	s.CreatedAt = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *Connection) SetProviderType(v string) *Connection {
	s.ProviderType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connection) SetStatus(v string) *Connection {
	s.Status = &v
	return s
}

// Provides summary information about an AWS App Runner connection resource.
type ConnectionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this connection.
	ConnectionArn *string `min:"1" type:"string"`

	// The customer-provided connection name.
	ConnectionName *string `min:"4" type:"string"`

	// The App Runner connection creation time, expressed as a Unix time stamp.
	CreatedAt *time.Time `type:"timestamp"`

	// The source repository provider.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The current state of the App Runner connection. When the state is AVAILABLE,
	// you can use the connection to create an App Runner service.
	Status *string `type:"string" enum:"ConnectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionSummary) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *ConnectionSummary) SetConnectionArn(v string) *ConnectionSummary {
	s.ConnectionArn = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *ConnectionSummary) SetConnectionName(v string) *ConnectionSummary {
	s.ConnectionName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ConnectionSummary) SetCreatedAt(v time.Time) *ConnectionSummary {
	s.CreatedAt = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *ConnectionSummary) SetProviderType(v string) *ConnectionSummary {
	s.ProviderType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ConnectionSummary) SetStatus(v string) *ConnectionSummary {
	s.Status = &v
	return s
}

type CreateAutoScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A name for the auto scaling configuration. When you use it for the first
	// time in an AWS Region, App Runner creates revision number 1 of this name.
	// When you use the same name in subsequent calls, App Runner creates incremental
	// revisions of the configuration.
	//
	// AutoScalingConfigurationName is a required field
	AutoScalingConfigurationName *string `min:"4" type:"string" required:"true"`

	// The maximum number of concurrent requests that you want an instance to process.
	// If the number of concurrent requests exceeds this limit, App Runner scales
	// up your service.
	//
	// Default: 100
	MaxConcurrency *int64 `min:"1" type:"integer"`

	// The maximum number of instances that your service scales up to. At most MaxSize
	// instances actively serve traffic for your service.
	//
	// Default: 25
	MaxSize *int64 `min:"1" type:"integer"`

	// The minimum number of instances that App Runner provisions for your service.
	// The service always has at least MinSize provisioned instances. Some of them
	// actively serve traffic. The rest of them (provisioned and inactive instances)
	// are a cost-effective compute capacity reserve and are ready to be quickly
	// activated. You pay for memory usage of all the provisioned instances. You
	// pay for CPU usage of only the active subset.
	//
	// App Runner temporarily doubles the number of provisioned instances during
	// deployments, to maintain the same capacity for both old and new code.
	//
	// Default: 1
	MinSize *int64 `min:"1" type:"integer"`

	// A list of metadata items that you can associate with your auto scaling configuration
	// resource. A tag is a key-value pair.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoScalingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAutoScalingConfigurationInput"}
	if s.AutoScalingConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingConfigurationName"))
	}
	if s.AutoScalingConfigurationName != nil && len(*s.AutoScalingConfigurationName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingConfigurationName", 4))
	}
	if s.MaxConcurrency != nil && *s.MaxConcurrency < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrency", 1))
	}
	if s.MaxSize != nil && *s.MaxSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSize", 1))
	}
	if s.MinSize != nil && *s.MinSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinSize", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfigurationName sets the AutoScalingConfigurationName field's value.
func (s *CreateAutoScalingConfigurationInput) SetAutoScalingConfigurationName(v string) *CreateAutoScalingConfigurationInput {
	s.AutoScalingConfigurationName = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *CreateAutoScalingConfigurationInput) SetMaxConcurrency(v int64) *CreateAutoScalingConfigurationInput {
	s.MaxConcurrency = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *CreateAutoScalingConfigurationInput) SetMaxSize(v int64) *CreateAutoScalingConfigurationInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *CreateAutoScalingConfigurationInput) SetMinSize(v int64) *CreateAutoScalingConfigurationInput {
	s.MinSize = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAutoScalingConfigurationInput) SetTags(v []*Tag) *CreateAutoScalingConfigurationInput {
	s.Tags = v
	return s
}

type CreateAutoScalingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// A description of the App Runner auto scaling configuration that's created
	// by this request.
	//
	// AutoScalingConfiguration is a required field
	AutoScalingConfiguration *AutoScalingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoScalingConfiguration sets the AutoScalingConfiguration field's value.
func (s *CreateAutoScalingConfigurationOutput) SetAutoScalingConfiguration(v *AutoScalingConfiguration) *CreateAutoScalingConfigurationOutput {
	s.AutoScalingConfiguration = v
	return s
}

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// A name for the new connection. It must be unique across all App Runner connections
	// for the AWS account in the AWS Region.
	//
	// ConnectionName is a required field
	ConnectionName *string `min:"4" type:"string" required:"true"`

	// The source repository provider.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"ProviderType"`

	// A list of metadata items that you can associate with your connection resource.
	// A tag is a key-value pair.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.ConnectionName != nil && len(*s.ConnectionName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionName", 4))
	}
	if s.ProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionName sets the ConnectionName field's value.
func (s *CreateConnectionInput) SetConnectionName(v string) *CreateConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CreateConnectionInput) SetProviderType(v string) *CreateConnectionInput {
	s.ProviderType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionInput) SetTags(v []*Tag) *CreateConnectionInput {
	s.Tags = v
	return s
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`

	// A description of the App Runner connection that's created by this request.
	//
	// Connection is a required field
	Connection *Connection `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *CreateConnectionOutput) SetConnection(v *Connection) *CreateConnectionOutput {
	s.Connection = v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration
	// resource that you want to associate with your service. If not provided, App
	// Runner associates the latest revision of a default auto scaling configuration.
	AutoScalingConfigurationArn *string `min:"1" type:"string"`

	// An optional custom encryption key that App Runner uses to encrypt the copy
	// of your source repository that it maintains and your service logs. By default,
	// App Runner uses an AWS managed CMK.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The settings for the health check that AWS App Runner performs to monitor
	// the health of your service.
	HealthCheckConfiguration *HealthCheckConfiguration `type:"structure"`

	// The runtime configuration of instances (scaling units) of the App Runner
	// service.
	InstanceConfiguration *InstanceConfiguration `type:"structure"`

	// A name for the new service. It must be unique across all the running App
	// Runner services in your AWS account in the AWS Region.
	//
	// ServiceName is a required field
	ServiceName *string `min:"4" type:"string" required:"true"`

	// The source to deploy to the App Runner service. It can be a code or an image
	// repository.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *SourceConfiguration `type:"structure" required:"true"`

	// An optional list of metadata items that you can associate with your service
	// resource. A tag is a key-value pair.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.AutoScalingConfigurationArn != nil && len(*s.AutoScalingConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingConfigurationArn", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 4))
	}
	if s.SourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConfiguration"))
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheckConfiguration != nil {
		if err := s.HealthCheckConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.InstanceConfiguration != nil {
		if err := s.InstanceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfigurationArn sets the AutoScalingConfigurationArn field's value.
func (s *CreateServiceInput) SetAutoScalingConfigurationArn(v string) *CreateServiceInput {
	s.AutoScalingConfigurationArn = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *CreateServiceInput) SetEncryptionConfiguration(v *EncryptionConfiguration) *CreateServiceInput {
	s.EncryptionConfiguration = v
	return s
}

// SetHealthCheckConfiguration sets the HealthCheckConfiguration field's value.
func (s *CreateServiceInput) SetHealthCheckConfiguration(v *HealthCheckConfiguration) *CreateServiceInput {
	s.HealthCheckConfiguration = v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *CreateServiceInput) SetInstanceConfiguration(v *InstanceConfiguration) *CreateServiceInput {
	s.InstanceConfiguration = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateServiceInput) SetServiceName(v string) *CreateServiceInput {
	s.ServiceName = &v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *CreateServiceInput) SetSourceConfiguration(v *SourceConfiguration) *CreateServiceInput {
	s.SourceConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInput) SetTags(v []*Tag) *CreateServiceInput {
	s.Tags = v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the asynchronous operation that this request started. You
	// can use it combined with the ListOperations (https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html)
	// call to track the operation's progress.
	//
	// OperationId is a required field
	OperationId *string `min:"36" type:"string" required:"true"`

	// A description of the App Runner service that's created by this request.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreateServiceOutput) SetOperationId(v string) *CreateServiceOutput {
	s.OperationId = &v
	return s
}

// SetService sets the Service field's value.
func (s *CreateServiceOutput) SetService(v *Service) *CreateServiceOutput {
	s.Service = v
	return s
}

// Describes a custom domain that's associated with an AWS App Runner service.
type CustomDomain struct {
	_ struct{} `type:"structure"`

	// A list of certificate CNAME records that's used for this domain name.
	CertificateValidationRecords []*CertificateValidationRecord `type:"list"`

	// An associated custom domain endpoint. It can be a root domain (for example,
	// example.com), a subdomain (for example, login.example.com or admin.login.example.com),
	// or a wildcard (for example, *.example.com).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// When true, the subdomain www.DomainName is associated with the App Runner
	// service in addition to the base domain.
	//
	// EnableWWWSubdomain is a required field
	EnableWWWSubdomain *bool `type:"boolean" required:"true"`

	// The current state of the domain name association.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"CustomDomainAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomDomain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomDomain) GoString() string {
	return s.String()
}

// SetCertificateValidationRecords sets the CertificateValidationRecords field's value.
func (s *CustomDomain) SetCertificateValidationRecords(v []*CertificateValidationRecord) *CustomDomain {
	s.CertificateValidationRecords = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CustomDomain) SetDomainName(v string) *CustomDomain {
	s.DomainName = &v
	return s
}

// SetEnableWWWSubdomain sets the EnableWWWSubdomain field's value.
func (s *CustomDomain) SetEnableWWWSubdomain(v bool) *CustomDomain {
	s.EnableWWWSubdomain = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CustomDomain) SetStatus(v string) *CustomDomain {
	s.Status = &v
	return s
}

type DeleteAutoScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner auto scaling configuration
	// that you want to delete.
	//
	// The ARN can be a full auto scaling configuration ARN, or a partial ARN ending
	// with either .../name or .../name/revision . If a revision isn't specified,
	// the latest active revision is deleted.
	//
	// AutoScalingConfigurationArn is a required field
	AutoScalingConfigurationArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutoScalingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAutoScalingConfigurationInput"}
	if s.AutoScalingConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingConfigurationArn"))
	}
	if s.AutoScalingConfigurationArn != nil && len(*s.AutoScalingConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingConfigurationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfigurationArn sets the AutoScalingConfigurationArn field's value.
func (s *DeleteAutoScalingConfigurationInput) SetAutoScalingConfigurationArn(v string) *DeleteAutoScalingConfigurationInput {
	s.AutoScalingConfigurationArn = &v
	return s
}

type DeleteAutoScalingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// A description of the App Runner auto scaling configuration that this request
	// just deleted.
	//
	// AutoScalingConfiguration is a required field
	AutoScalingConfiguration *AutoScalingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoScalingConfiguration sets the AutoScalingConfiguration field's value.
func (s *DeleteAutoScalingConfigurationOutput) SetAutoScalingConfiguration(v *AutoScalingConfiguration) *DeleteAutoScalingConfigurationOutput {
	s.AutoScalingConfiguration = v
	return s
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner connection that you want
	// to delete.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *DeleteConnectionInput) SetConnectionArn(v string) *DeleteConnectionInput {
	s.ConnectionArn = &v
	return s
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// A description of the App Runner connection that this request just deleted.
	Connection *Connection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteConnectionOutput) SetConnection(v *Connection) *DeleteConnectionOutput {
	s.Connection = v
	return s
}

type DeleteServiceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// delete.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceArn sets the ServiceArn field's value.
func (s *DeleteServiceInput) SetServiceArn(v string) *DeleteServiceInput {
	s.ServiceArn = &v
	return s
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the asynchronous operation that this request started. You
	// can use it combined with the ListOperations call to track the operation's
	// progress.
	//
	// OperationId is a required field
	OperationId *string `min:"36" type:"string" required:"true"`

	// A description of the App Runner service that this request just deleted.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteServiceOutput) SetOperationId(v string) *DeleteServiceOutput {
	s.OperationId = &v
	return s
}

// SetService sets the Service field's value.
func (s *DeleteServiceOutput) SetService(v *Service) *DeleteServiceOutput {
	s.Service = v
	return s
}

type DescribeAutoScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner auto scaling configuration
	// that you want a description for.
	//
	// The ARN can be a full auto scaling configuration ARN, or a partial ARN ending
	// with either .../name or .../name/revision . If a revision isn't specified,
	// the latest active revision is described.
	//
	// AutoScalingConfigurationArn is a required field
	AutoScalingConfigurationArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAutoScalingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAutoScalingConfigurationInput"}
	if s.AutoScalingConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingConfigurationArn"))
	}
	if s.AutoScalingConfigurationArn != nil && len(*s.AutoScalingConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingConfigurationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfigurationArn sets the AutoScalingConfigurationArn field's value.
func (s *DescribeAutoScalingConfigurationInput) SetAutoScalingConfigurationArn(v string) *DescribeAutoScalingConfigurationInput {
	s.AutoScalingConfigurationArn = &v
	return s
}

type DescribeAutoScalingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the App Runner auto scaling configuration that you
	// specified in this request.
	//
	// AutoScalingConfiguration is a required field
	AutoScalingConfiguration *AutoScalingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoScalingConfiguration sets the AutoScalingConfiguration field's value.
func (s *DescribeAutoScalingConfigurationOutput) SetAutoScalingConfiguration(v *AutoScalingConfiguration) *DescribeAutoScalingConfigurationOutput {
	s.AutoScalingConfiguration = v
	return s
}

type DescribeCustomDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that each response (result page) can include.
	// It's used for a paginated request.
	//
	// If you don't specify MaxResults, the request retrieves all available results
	// in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token from a previous result page. It's used for a paginated request. The
	// request retrieves the next result page. All other parameter values must be
	// identical to the ones that are specified in the initial request.
	//
	// If you don't specify NextToken, the request retrieves the first result page.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want associated
	// custom domain names to be described for.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeCustomDomainsInput) SetMaxResults(v int64) *DescribeCustomDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCustomDomainsInput) SetNextToken(v string) *DescribeCustomDomainsInput {
	s.NextToken = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *DescribeCustomDomainsInput) SetServiceArn(v string) *DescribeCustomDomainsInput {
	s.ServiceArn = &v
	return s
}

type DescribeCustomDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list of descriptions of custom domain names that are associated with the
	// service. In a paginated request, the request returns up to MaxResults records
	// per call.
	//
	// CustomDomains is a required field
	CustomDomains []*CustomDomain `type:"list" required:"true"`

	// The App Runner subdomain of the App Runner service. The associated custom
	// domain names are mapped to this target name.
	//
	// DNSTarget is a required field
	DNSTarget *string `type:"string" required:"true"`

	// The token that you can pass in a subsequent request to get the next result
	// page. It's returned in a paginated request.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the App Runner service whose associated
	// custom domain names you want to describe.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomDomainsOutput) GoString() string {
	return s.String()
}

// SetCustomDomains sets the CustomDomains field's value.
func (s *DescribeCustomDomainsOutput) SetCustomDomains(v []*CustomDomain) *DescribeCustomDomainsOutput {
	s.CustomDomains = v
	return s
}

// SetDNSTarget sets the DNSTarget field's value.
func (s *DescribeCustomDomainsOutput) SetDNSTarget(v string) *DescribeCustomDomainsOutput {
	s.DNSTarget = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCustomDomainsOutput) SetNextToken(v string) *DescribeCustomDomainsOutput {
	s.NextToken = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *DescribeCustomDomainsOutput) SetServiceArn(v string) *DescribeCustomDomainsOutput {
	s.ServiceArn = &v
	return s
}

type DescribeServiceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want a
	// description for.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServiceInput"}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceArn sets the ServiceArn field's value.
func (s *DescribeServiceInput) SetServiceArn(v string) *DescribeServiceInput {
	s.ServiceArn = &v
	return s
}

type DescribeServiceOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the App Runner service that you specified in this request.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *DescribeServiceOutput) SetService(v *Service) *DescribeServiceOutput {
	s.Service = v
	return s
}

type DisassociateCustomDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name that you want to disassociate from the App Runner service.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// disassociate a custom domain name from.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateCustomDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateCustomDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateCustomDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateCustomDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DisassociateCustomDomainInput) SetDomainName(v string) *DisassociateCustomDomainInput {
	s.DomainName = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *DisassociateCustomDomainInput) SetServiceArn(v string) *DisassociateCustomDomainInput {
	s.ServiceArn = &v
	return s
}

type DisassociateCustomDomainOutput struct {
	_ struct{} `type:"structure"`

	// A description of the domain name that's being disassociated.
	//
	// CustomDomain is a required field
	CustomDomain *CustomDomain `type:"structure" required:"true"`

	// The App Runner subdomain of the App Runner service. The disassociated custom
	// domain name was mapped to this target name.
	//
	// DNSTarget is a required field
	DNSTarget *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the App Runner service that a custom domain
	// name is disassociated from.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateCustomDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateCustomDomainOutput) GoString() string {
	return s.String()
}

// SetCustomDomain sets the CustomDomain field's value.
func (s *DisassociateCustomDomainOutput) SetCustomDomain(v *CustomDomain) *DisassociateCustomDomainOutput {
	s.CustomDomain = v
	return s
}

// SetDNSTarget sets the DNSTarget field's value.
func (s *DisassociateCustomDomainOutput) SetDNSTarget(v string) *DisassociateCustomDomainOutput {
	s.DNSTarget = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *DisassociateCustomDomainOutput) SetServiceArn(v string) *DisassociateCustomDomainOutput {
	s.ServiceArn = &v
	return s
}

// Describes a custom encryption key that AWS App Runner uses to encrypt copies
// of the source repository and service logs.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the KMS key that's used for encryption.
	//
	// KmsKey is a required field
	KmsKey *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.KmsKey == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKey sets the KmsKey field's value.
func (s *EncryptionConfiguration) SetKmsKey(v string) *EncryptionConfiguration {
	s.KmsKey = &v
	return s
}

// Describes the settings for the health check that AWS App Runner performs
// to monitor the health of a service.
type HealthCheckConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of consecutive checks that must succeed before App Runner decides
	// that the service is healthy.
	//
	// Default: 3
	HealthyThreshold *int64 `min:"1" type:"integer"`

	// The time interval, in seconds, between health checks.
	//
	// Default: 5
	Interval *int64 `min:"1" type:"integer"`

	// The URL that health check requests are sent to.
	//
	// Path is only applicable when you set Protocol to HTTP.
	//
	// Default: "/"
	Path *string `type:"string"`

	// The IP protocol that App Runner uses to perform health checks for your service.
	//
	// If you set Protocol to HTTP, App Runner sends health check requests to the
	// HTTP path specified by Path.
	//
	// Default: TCP
	Protocol *string `type:"string" enum:"HealthCheckProtocol"`

	// The time, in seconds, to wait for a health check response before deciding
	// it failed.
	//
	// Default: 2
	Timeout *int64 `min:"1" type:"integer"`

	// The number of consecutive checks that must fail before App Runner decides
	// that the service is unhealthy.
	//
	// Default: 3
	UnhealthyThreshold *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheckConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HealthCheckConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckConfiguration"}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThreshold", 1))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckConfiguration) SetHealthyThreshold(v int64) *HealthCheckConfiguration {
	s.HealthyThreshold = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *HealthCheckConfiguration) SetInterval(v int64) *HealthCheckConfiguration {
	s.Interval = &v
	return s
}

// SetPath sets the Path field's value.
func (s *HealthCheckConfiguration) SetPath(v string) *HealthCheckConfiguration {
	s.Path = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckConfiguration) SetProtocol(v string) *HealthCheckConfiguration {
	s.Protocol = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HealthCheckConfiguration) SetTimeout(v int64) *HealthCheckConfiguration {
	s.Timeout = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckConfiguration) SetUnhealthyThreshold(v int64) *HealthCheckConfiguration {
	s.UnhealthyThreshold = &v
	return s
}

// Describes the configuration that AWS App Runner uses to run an App Runner
// service using an image pulled from a source image repository.
type ImageConfiguration struct {
	_ struct{} `type:"structure"`

	// The port that your application listens to in the container.
	//
	// Default: 8080
	Port *string `type:"string"`

	// Environment variables that are available to your running App Runner service.
	// An array of key-value pairs. Keys with a prefix of AWSAPPRUNNER are reserved
	// for system use and aren't valid.
	RuntimeEnvironmentVariables map[string]*string `type:"map"`

	// An optional command that App Runner runs to start the application in the
	// source image. If specified, this command overrides the Docker image’s default
	// start command.
	StartCommand *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageConfiguration) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *ImageConfiguration) SetPort(v string) *ImageConfiguration {
	s.Port = &v
	return s
}

// SetRuntimeEnvironmentVariables sets the RuntimeEnvironmentVariables field's value.
func (s *ImageConfiguration) SetRuntimeEnvironmentVariables(v map[string]*string) *ImageConfiguration {
	s.RuntimeEnvironmentVariables = v
	return s
}

// SetStartCommand sets the StartCommand field's value.
func (s *ImageConfiguration) SetStartCommand(v string) *ImageConfiguration {
	s.StartCommand = &v
	return s
}

// Describes a source image repository.
type ImageRepository struct {
	_ struct{} `type:"structure"`

	// Configuration for running the identified image.
	ImageConfiguration *ImageConfiguration `type:"structure"`

	// The identifier of an image.
	//
	// For an image in Amazon Elastic Container Registry (Amazon ECR), this is an
	// image name. For the image name format, see Pulling an image (https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html)
	// in the Amazon ECR User Guide.
	//
	// ImageIdentifier is a required field
	ImageIdentifier *string `min:"1" type:"string" required:"true"`

	// The type of the image repository. This reflects the repository provider and
	// whether the repository is private or public.
	//
	// ImageRepositoryType is a required field
	ImageRepositoryType *string `type:"string" required:"true" enum:"ImageRepositoryType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageRepository"}
	if s.ImageIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageIdentifier"))
	}
	if s.ImageIdentifier != nil && len(*s.ImageIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIdentifier", 1))
	}
	if s.ImageRepositoryType == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageRepositoryType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageConfiguration sets the ImageConfiguration field's value.
func (s *ImageRepository) SetImageConfiguration(v *ImageConfiguration) *ImageRepository {
	s.ImageConfiguration = v
	return s
}

// SetImageIdentifier sets the ImageIdentifier field's value.
func (s *ImageRepository) SetImageIdentifier(v string) *ImageRepository {
	s.ImageIdentifier = &v
	return s
}

// SetImageRepositoryType sets the ImageRepositoryType field's value.
func (s *ImageRepository) SetImageRepositoryType(v string) *ImageRepository {
	s.ImageRepositoryType = &v
	return s
}

// Describes the runtime configuration of an AWS App Runner service instance
// (scaling unit).
type InstanceConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of CPU units reserved for each instance of your App Runner service.
	//
	// Default: 1 vCPU
	Cpu *string `min:"4" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that provides permissions to
	// your App Runner service. These are permissions that your code needs when
	// it calls any AWS APIs.
	InstanceRoleArn *string `min:"29" type:"string"`

	// The amount of memory, in MB or GB, reserved for each instance of your App
	// Runner service.
	//
	// Default: 2 GB
	Memory *string `min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceConfiguration"}
	if s.Cpu != nil && len(*s.Cpu) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("Cpu", 4))
	}
	if s.InstanceRoleArn != nil && len(*s.InstanceRoleArn) < 29 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceRoleArn", 29))
	}
	if s.Memory != nil && len(*s.Memory) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("Memory", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpu sets the Cpu field's value.
func (s *InstanceConfiguration) SetCpu(v string) *InstanceConfiguration {
	s.Cpu = &v
	return s
}

// SetInstanceRoleArn sets the InstanceRoleArn field's value.
func (s *InstanceConfiguration) SetInstanceRoleArn(v string) *InstanceConfiguration {
	s.InstanceRoleArn = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *InstanceConfiguration) SetMemory(v string) *InstanceConfiguration {
	s.Memory = &v
	return s
}

// An unexpected service exception occurred.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more input parameters aren't valid. Refer to the API action's document
// page, correct the input parameters, and try the action again.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't perform this action when the resource is in its current state.
type InvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) GoString() string {
	return s.String()
}

func newErrorInvalidStateException(v protocol.ResponseMetadata) error {
	return &InvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateException) Code() string {
	return "InvalidStateException"
}

// Message returns the exception's message.
func (s *InvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateException) OrigErr() error {
	return nil
}

func (s *InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAutoScalingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the App Runner auto scaling configuration that you want to list.
	// If specified, App Runner lists revisions that share this name. If not specified,
	// App Runner returns revisions of all configurations.
	AutoScalingConfigurationName *string `min:"4" type:"string"`

	// Set to true to list only the latest revision for each requested configuration
	// name.
	//
	// Keep as false to list all revisions for each requested configuration name.
	//
	// Default: false
	LatestOnly *bool `type:"boolean"`

	// The maximum number of results to include in each response (result page).
	// It's used for a paginated request.
	//
	// If you don't specify MaxResults, the request retrieves all available results
	// in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token from a previous result page. It's used for a paginated request. The
	// request retrieves the next result page. All other parameter values must be
	// identical to the ones that are specified in the initial request.
	//
	// If you don't specify NextToken, the request retrieves the first result page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoScalingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoScalingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAutoScalingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAutoScalingConfigurationsInput"}
	if s.AutoScalingConfigurationName != nil && len(*s.AutoScalingConfigurationName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingConfigurationName", 4))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfigurationName sets the AutoScalingConfigurationName field's value.
func (s *ListAutoScalingConfigurationsInput) SetAutoScalingConfigurationName(v string) *ListAutoScalingConfigurationsInput {
	s.AutoScalingConfigurationName = &v
	return s
}

// SetLatestOnly sets the LatestOnly field's value.
func (s *ListAutoScalingConfigurationsInput) SetLatestOnly(v bool) *ListAutoScalingConfigurationsInput {
	s.LatestOnly = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAutoScalingConfigurationsInput) SetMaxResults(v int64) *ListAutoScalingConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAutoScalingConfigurationsInput) SetNextToken(v string) *ListAutoScalingConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListAutoScalingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of summary information records for auto scaling configurations. In
	// a paginated request, the request returns up to MaxResults records for each
	// call.
	//
	// AutoScalingConfigurationSummaryList is a required field
	AutoScalingConfigurationSummaryList []*AutoScalingConfigurationSummary `type:"list" required:"true"`

	// The token that you can pass in a subsequent request to get the next result
	// page. It's returned in a paginated request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoScalingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoScalingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetAutoScalingConfigurationSummaryList sets the AutoScalingConfigurationSummaryList field's value.
func (s *ListAutoScalingConfigurationsOutput) SetAutoScalingConfigurationSummaryList(v []*AutoScalingConfigurationSummary) *ListAutoScalingConfigurationsOutput {
	s.AutoScalingConfigurationSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAutoScalingConfigurationsOutput) SetNextToken(v string) *ListAutoScalingConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListConnectionsInput struct {
	_ struct{} `type:"structure"`

	// If specified, only this connection is returned. If not specified, the result
	// isn't filtered by name.
	ConnectionName *string `min:"4" type:"string"`

	// The maximum number of results to include in each response (result page).
	// Used for a paginated request.
	//
	// If you don't specify MaxResults, the request retrieves all available results
	// in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token from a previous result page. Used for a paginated request. The request
	// retrieves the next result page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If you don't specify NextToken, the request retrieves the first result page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectionsInput"}
	if s.ConnectionName != nil && len(*s.ConnectionName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionName", 4))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionName sets the ConnectionName field's value.
func (s *ListConnectionsInput) SetConnectionName(v string) *ListConnectionsInput {
	s.ConnectionName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectionsInput) SetMaxResults(v int64) *ListConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectionsInput) SetNextToken(v string) *ListConnectionsInput {
	s.NextToken = &v
	return s
}

type ListConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of summary information records for connections. In a paginated request,
	// the request returns up to MaxResults records for each call.
	//
	// ConnectionSummaryList is a required field
	ConnectionSummaryList []*ConnectionSummary `type:"list" required:"true"`

	// The token that you can pass in a subsequent request to get the next result
	// page. Returned in a paginated request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnectionSummaryList sets the ConnectionSummaryList field's value.
func (s *ListConnectionsOutput) SetConnectionSummaryList(v []*ConnectionSummary) *ListConnectionsOutput {
	s.ConnectionSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectionsOutput) SetNextToken(v string) *ListConnectionsOutput {
	s.NextToken = &v
	return s
}

type ListOperationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in each response (result page).
	// It's used for a paginated request.
	//
	// If you don't specify MaxResults, the request retrieves all available results
	// in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token from a previous result page. It's used for a paginated request. The
	// request retrieves the next result page. All other parameter values must be
	// identical to the ones specified in the initial request.
	//
	// If you don't specify NextToken, the request retrieves the first result page.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want a
	// list of operations for.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOperationsInput) SetMaxResults(v int64) *ListOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOperationsInput) SetNextToken(v string) *ListOperationsInput {
	s.NextToken = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *ListOperationsInput) SetServiceArn(v string) *ListOperationsInput {
	s.ServiceArn = &v
	return s
}

type ListOperationsOutput struct {
	_ struct{} `type:"structure"`

	// The token that you can pass in a subsequent request to get the next result
	// page. It's returned in a paginated request.
	NextToken *string `type:"string"`

	// A list of operation summary information records. In a paginated request,
	// the request returns up to MaxResults records for each call.
	OperationSummaryList []*OperationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOperationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOperationsOutput) SetNextToken(v string) *ListOperationsOutput {
	s.NextToken = &v
	return s
}

// SetOperationSummaryList sets the OperationSummaryList field's value.
func (s *ListOperationsOutput) SetOperationSummaryList(v []*OperationSummary) *ListOperationsOutput {
	s.OperationSummaryList = v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in each response (result page).
	// It's used for a paginated request.
	//
	// If you don't specify MaxResults, the request retrieves all available results
	// in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token from a previous result page. Used for a paginated request. The request
	// retrieves the next result page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If you don't specify NextToken, the request retrieves the first result page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// The token that you can pass in a subsequent request to get the next result
	// page. It's returned in a paginated request.
	NextToken *string `type:"string"`

	// A list of service summary information records. In a paginated request, the
	// request returns up to MaxResults records for each call.
	//
	// ServiceSummaryList is a required field
	ServiceSummaryList []*ServiceSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServiceSummaryList sets the ServiceSummaryList field's value.
func (s *ListServicesOutput) SetServiceSummaryList(v []*ServiceSummary) *ListServicesOutput {
	s.ServiceSummaryList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that a tag list is requested
	// for.
	//
	// It must be the ARN of an App Runner resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of the tag key-value pairs that are associated with the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Provides summary information for an operation that occurred on an AWS App
// Runner service.
type OperationSummary struct {
	_ struct{} `type:"structure"`

	// The time when the operation ended. It's in the Unix time stamp format.
	EndedAt *time.Time `type:"timestamp"`

	// A unique ID of this operation. It's unique in the scope of the App Runner
	// service.
	Id *string `min:"36" type:"string"`

	// The time when the operation started. It's in the Unix time stamp format.
	StartedAt *time.Time `type:"timestamp"`

	// The current state of the operation.
	Status *string `type:"string" enum:"OperationStatus"`

	// The Amazon Resource Name (ARN) of the resource that the operation acted on
	// (for example, an App Runner service).
	TargetArn *string `min:"1" type:"string"`

	// The type of operation. It indicates a specific action that occured.
	Type *string `type:"string" enum:"OperationType"`

	// The time when the operation was last updated. It's in the Unix time stamp
	// format.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationSummary) GoString() string {
	return s.String()
}

// SetEndedAt sets the EndedAt field's value.
func (s *OperationSummary) SetEndedAt(v time.Time) *OperationSummary {
	s.EndedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *OperationSummary) SetId(v string) *OperationSummary {
	s.Id = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *OperationSummary) SetStartedAt(v time.Time) *OperationSummary {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OperationSummary) SetStatus(v string) *OperationSummary {
	s.Status = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *OperationSummary) SetTargetArn(v string) *OperationSummary {
	s.TargetArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *OperationSummary) SetType(v string) *OperationSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *OperationSummary) SetUpdatedAt(v time.Time) *OperationSummary {
	s.UpdatedAt = &v
	return s
}

type PauseServiceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// pause.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PauseServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PauseServiceInput"}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceArn sets the ServiceArn field's value.
func (s *PauseServiceInput) SetServiceArn(v string) *PauseServiceInput {
	s.ServiceArn = &v
	return s
}

type PauseServiceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the asynchronous operation that this request started. You
	// can use it combined with the ListOperations call to track the operation's
	// progress.
	OperationId *string `min:"36" type:"string"`

	// A description of the App Runner service that this request just paused.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PauseServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *PauseServiceOutput) SetOperationId(v string) *PauseServiceOutput {
	s.OperationId = &v
	return s
}

// SetService sets the Service field's value.
func (s *PauseServiceOutput) SetService(v *Service) *PauseServiceOutput {
	s.Service = v
	return s
}

// A resource doesn't exist for the specified Amazon Resource Name (ARN) in
// your AWS account.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResumeServiceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// resume.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResumeServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResumeServiceInput"}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceArn sets the ServiceArn field's value.
func (s *ResumeServiceInput) SetServiceArn(v string) *ResumeServiceInput {
	s.ServiceArn = &v
	return s
}

type ResumeServiceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the asynchronous operation that this request started. You
	// can use it combined with the ListOperations call to track the operation's
	// progress.
	OperationId *string `min:"36" type:"string"`

	// A description of the App Runner service that this request just resumed.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *ResumeServiceOutput) SetOperationId(v string) *ResumeServiceOutput {
	s.OperationId = &v
	return s
}

// SetService sets the Service field's value.
func (s *ResumeServiceOutput) SetService(v *Service) *ResumeServiceOutput {
	s.Service = v
	return s
}

// Describes an AWS App Runner service. It can describe a service in any state,
// including deleted services.
//
// This type contains the full information about a service, including configuration
// details. It's returned by the CreateService (https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html),
// DescribeService (https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html),
// and DeleteService (https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html)
// actions. A subset of this information is returned by the ListServices (https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html)
// action using the ServiceSummary (https://docs.aws.amazon.com/apprunner/latest/api/API_ServiceSummary.html)
// type.
type Service struct {
	_ struct{} `type:"structure"`

	// Summary information for the App Runner automatic scaling configuration resource
	// that's associated with this service.
	//
	// AutoScalingConfigurationSummary is a required field
	AutoScalingConfigurationSummary *AutoScalingConfigurationSummary `type:"structure" required:"true"`

	// The time when the App Runner service was created. It's in the Unix time stamp
	// format.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The time when the App Runner service was deleted. It's in the Unix time stamp
	// format.
	DeletedAt *time.Time `type:"timestamp"`

	// The encryption key that App Runner uses to encrypt the service logs and the
	// copy of the source repository that App Runner maintains for the service.
	// It can be either a customer-provided encryption key or an AWS managed CMK.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The settings for the health check that App Runner performs to monitor the
	// health of this service.
	HealthCheckConfiguration *HealthCheckConfiguration `type:"structure"`

	// The runtime configuration of instances (scaling units) of this service.
	//
	// InstanceConfiguration is a required field
	InstanceConfiguration *InstanceConfiguration `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of this service.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`

	// An ID that App Runner generated for this service. It's unique within the
	// AWS Region.
	//
	// ServiceId is a required field
	ServiceId *string `min:"32" type:"string" required:"true"`

	// The customer-provided service name.
	//
	// ServiceName is a required field
	ServiceName *string `min:"4" type:"string" required:"true"`

	// A subdomain URL that App Runner generated for this service. You can use this
	// URL to access your service web application.
	//
	// ServiceUrl is a required field
	ServiceUrl *string `type:"string" required:"true"`

	// The source deployed to the App Runner service. It can be a code or an image
	// repository.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *SourceConfiguration `type:"structure" required:"true"`

	// The current state of the App Runner service. These particular values mean
	// the following.
	//
	//    * CREATE_FAILED – The service failed to create. To troubleshoot this
	//    failure, read the failure events and logs, change any parameters that
	//    need to be fixed, and retry the call to create the service. The failed
	//    service isn't usable, and still counts towards your service quota. When
	//    you're done analyzing the failure, delete the service.
	//
	//    * DELETE_FAILED – The service failed to delete and can't be successfully
	//    recovered. Retry the service deletion call to ensure that all related
	//    resources are removed.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ServiceStatus"`

	// The time when the App Runner service was last updated at. It's in the Unix
	// time stamp format.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) GoString() string {
	return s.String()
}

// SetAutoScalingConfigurationSummary sets the AutoScalingConfigurationSummary field's value.
func (s *Service) SetAutoScalingConfigurationSummary(v *AutoScalingConfigurationSummary) *Service {
	s.AutoScalingConfigurationSummary = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Service) SetCreatedAt(v time.Time) *Service {
	s.CreatedAt = &v
	return s
}

// SetDeletedAt sets the DeletedAt field's value.
func (s *Service) SetDeletedAt(v time.Time) *Service {
	s.DeletedAt = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *Service) SetEncryptionConfiguration(v *EncryptionConfiguration) *Service {
	s.EncryptionConfiguration = v
	return s
}

// SetHealthCheckConfiguration sets the HealthCheckConfiguration field's value.
func (s *Service) SetHealthCheckConfiguration(v *HealthCheckConfiguration) *Service {
	s.HealthCheckConfiguration = v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *Service) SetInstanceConfiguration(v *InstanceConfiguration) *Service {
	s.InstanceConfiguration = v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *Service) SetServiceArn(v string) *Service {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *Service) SetServiceId(v string) *Service {
	s.ServiceId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *Service) SetServiceName(v string) *Service {
	s.ServiceName = &v
	return s
}

// SetServiceUrl sets the ServiceUrl field's value.
func (s *Service) SetServiceUrl(v string) *Service {
	s.ServiceUrl = &v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *Service) SetSourceConfiguration(v *SourceConfiguration) *Service {
	s.SourceConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Service) SetStatus(v string) *Service {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Service) SetUpdatedAt(v time.Time) *Service {
	s.UpdatedAt = &v
	return s
}

// App Runner can't create this resource. You've reached your account quota
// for this resource type.
//
// For App Runner per-resource quotas, see AWS App Runner endpoints and quotas
// (https://docs.aws.amazon.com/general/latest/gr/apprunner.html) in the AWS
// General Reference.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides summary information for an AWS App Runner service.
//
// This type contains limited information about a service. It doesn't include
// configuration details. It's returned by the ListServices (https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html)
// action. Complete service information is returned by the CreateService (https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html),
// DescribeService (https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html),
// and DeleteService (https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html)
// actions using the Service (https://docs.aws.amazon.com/apprunner/latest/api/API_Service.html)
// type.
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The time when the App Runner service was created. It's in the Unix time stamp
	// format.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of this service.
	ServiceArn *string `min:"1" type:"string"`

	// An ID that App Runner generated for this service. It's unique within the
	// AWS Region.
	ServiceId *string `min:"32" type:"string"`

	// The customer-provided service name.
	ServiceName *string `min:"4" type:"string"`

	// A subdomain URL that App Runner generated for this service. You can use this
	// URL to access your service web application.
	ServiceUrl *string `type:"string"`

	// The current state of the App Runner service. These particular values mean
	// the following.
	//
	//    * CREATE_FAILED – The service failed to create. Read the failure events
	//    and logs, change any parameters that need to be fixed, and retry the call
	//    to create the service. The failed service isn't usable, and still counts
	//    towards your service quota. When you're done analyzing the failure, delete
	//    the service.
	//
	//    * DELETE_FAILED – The service failed to delete and can't be successfully
	//    recovered. Retry the service deletion call to ensure that all related
	//    resources are removed.
	Status *string `type:"string" enum:"ServiceStatus"`

	// The time when the App Runner service was last updated. It's in theUnix time
	// stamp format.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceSummary) SetCreatedAt(v time.Time) *ServiceSummary {
	s.CreatedAt = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *ServiceSummary) SetServiceArn(v string) *ServiceSummary {
	s.ServiceArn = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *ServiceSummary) SetServiceId(v string) *ServiceSummary {
	s.ServiceId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceSummary) SetServiceName(v string) *ServiceSummary {
	s.ServiceName = &v
	return s
}

// SetServiceUrl sets the ServiceUrl field's value.
func (s *ServiceSummary) SetServiceUrl(v string) *ServiceSummary {
	s.ServiceUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceSummary) SetStatus(v string) *ServiceSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ServiceSummary) SetUpdatedAt(v time.Time) *ServiceSummary {
	s.UpdatedAt = &v
	return s
}

// Identifies a version of code that AWS App Runner refers to within a source
// code repository.
type SourceCodeVersion struct {
	_ struct{} `type:"structure"`

	// The type of version identifier.
	//
	// For a git-based repository, branches represent versions.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"SourceCodeVersionType"`

	// A source code version.
	//
	// For a git-based repository, a branch name maps to a specific version. App
	// Runner uses the most recent commit to the branch.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCodeVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceCodeVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceCodeVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceCodeVersion"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *SourceCodeVersion) SetType(v string) *SourceCodeVersion {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SourceCodeVersion) SetValue(v string) *SourceCodeVersion {
	s.Value = &v
	return s
}

// Describes the source deployed to an AWS App Runner service. It can be a code
// or an image repository.
type SourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the resources that are needed to authenticate access to some source
	// repositories.
	AuthenticationConfiguration *AuthenticationConfiguration `type:"structure"`

	// If true, continuous integration from the source repository is enabled for
	// the App Runner service. Each repository change (source code commit or new
	// image version) starts a deployment.
	//
	// Default: true
	AutoDeploymentsEnabled *bool `type:"boolean"`

	// The description of a source code repository.
	//
	// You must provide either this member or ImageRepository (but not both).
	CodeRepository *CodeRepository `type:"structure"`

	// The description of a source image repository.
	//
	// You must provide either this member or CodeRepository (but not both).
	ImageRepository *ImageRepository `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConfiguration"}
	if s.AuthenticationConfiguration != nil {
		if err := s.AuthenticationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CodeRepository != nil {
		if err := s.CodeRepository.Validate(); err != nil {
			invalidParams.AddNested("CodeRepository", err.(request.ErrInvalidParams))
		}
	}
	if s.ImageRepository != nil {
		if err := s.ImageRepository.Validate(); err != nil {
			invalidParams.AddNested("ImageRepository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationConfiguration sets the AuthenticationConfiguration field's value.
func (s *SourceConfiguration) SetAuthenticationConfiguration(v *AuthenticationConfiguration) *SourceConfiguration {
	s.AuthenticationConfiguration = v
	return s
}

// SetAutoDeploymentsEnabled sets the AutoDeploymentsEnabled field's value.
func (s *SourceConfiguration) SetAutoDeploymentsEnabled(v bool) *SourceConfiguration {
	s.AutoDeploymentsEnabled = &v
	return s
}

// SetCodeRepository sets the CodeRepository field's value.
func (s *SourceConfiguration) SetCodeRepository(v *CodeRepository) *SourceConfiguration {
	s.CodeRepository = v
	return s
}

// SetImageRepository sets the ImageRepository field's value.
func (s *SourceConfiguration) SetImageRepository(v *ImageRepository) *SourceConfiguration {
	s.ImageRepository = v
	return s
}

type StartDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// manually deploy to.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDeploymentInput"}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceArn sets the ServiceArn field's value.
func (s *StartDeploymentInput) SetServiceArn(v string) *StartDeploymentInput {
	s.ServiceArn = &v
	return s
}

type StartDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the asynchronous operation that this request started. You
	// can use it combined with the ListOperations call to track the operation's
	// progress.
	//
	// OperationId is a required field
	OperationId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *StartDeploymentOutput) SetOperationId(v string) *StartDeploymentOutput {
	s.OperationId = &v
	return s
}

// Describes a tag that is applied to an AWS App Runner resource. A tag is a
// metadata item consisting of a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	Key *string `min:"1" type:"string"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to update tags
	// for.
	//
	// It must be the ARN of an App Runner resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A list of tag key-value pairs to add or update. If a key is new to the resource,
	// the tag is added with the provided value. If a key is already associated
	// with the resource, the value of the tag is updated.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to remove tags
	// from.
	//
	// It must be the ARN of an App Runner resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A list of tag keys that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateServiceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration
	// resource that you want to associate with your service.
	AutoScalingConfigurationArn *string `min:"1" type:"string"`

	// The settings for the health check that AWS App Runner performs to monitor
	// the health of your service.
	HealthCheckConfiguration *HealthCheckConfiguration `type:"structure"`

	// The runtime configuration to apply to instances (scaling units) of the App
	// Runner service.
	InstanceConfiguration *InstanceConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the App Runner service that you want to
	// update.
	//
	// ServiceArn is a required field
	ServiceArn *string `min:"1" type:"string" required:"true"`

	// The source configuration to apply to the App Runner service.
	//
	// You can change the configuration of the code or image repository that the
	// service uses. However, you can't switch from code to image or the other way
	// around. This means that you must provide the same structure member of SourceConfiguration
	// that you originally included when you created the service. Specifically,
	// you can include either CodeRepository or ImageRepository. To update the source
	// configuration, set the values to members of the structure that you include.
	SourceConfiguration *SourceConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.AutoScalingConfigurationArn != nil && len(*s.AutoScalingConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingConfigurationArn", 1))
	}
	if s.ServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceArn"))
	}
	if s.ServiceArn != nil && len(*s.ServiceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceArn", 1))
	}
	if s.HealthCheckConfiguration != nil {
		if err := s.HealthCheckConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.InstanceConfiguration != nil {
		if err := s.InstanceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfigurationArn sets the AutoScalingConfigurationArn field's value.
func (s *UpdateServiceInput) SetAutoScalingConfigurationArn(v string) *UpdateServiceInput {
	s.AutoScalingConfigurationArn = &v
	return s
}

// SetHealthCheckConfiguration sets the HealthCheckConfiguration field's value.
func (s *UpdateServiceInput) SetHealthCheckConfiguration(v *HealthCheckConfiguration) *UpdateServiceInput {
	s.HealthCheckConfiguration = v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *UpdateServiceInput) SetInstanceConfiguration(v *InstanceConfiguration) *UpdateServiceInput {
	s.InstanceConfiguration = v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *UpdateServiceInput) SetServiceArn(v string) *UpdateServiceInput {
	s.ServiceArn = &v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *UpdateServiceInput) SetSourceConfiguration(v *SourceConfiguration) *UpdateServiceInput {
	s.SourceConfiguration = v
	return s
}

type UpdateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the asynchronous operation that this request started. You
	// can use it combined with the ListOperations call to track the operation's
	// progress.
	//
	// OperationId is a required field
	OperationId *string `min:"36" type:"string" required:"true"`

	// A description of the App Runner service updated by this request. All configuration
	// values in the returned Service structure reflect configuration changes that
	// are being applied by this request.
	//
	// Service is a required field
	Service *Service `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateServiceOutput) SetOperationId(v string) *UpdateServiceOutput {
	s.OperationId = &v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateServiceOutput) SetService(v *Service) *UpdateServiceOutput {
	s.Service = v
	return s
}

const (
	// AutoScalingConfigurationStatusActive is a AutoScalingConfigurationStatus enum value
	AutoScalingConfigurationStatusActive = "ACTIVE"

	// AutoScalingConfigurationStatusInactive is a AutoScalingConfigurationStatus enum value
	AutoScalingConfigurationStatusInactive = "INACTIVE"
)

// AutoScalingConfigurationStatus_Values returns all elements of the AutoScalingConfigurationStatus enum
func AutoScalingConfigurationStatus_Values() []string {
	return []string{
		AutoScalingConfigurationStatusActive,
		AutoScalingConfigurationStatusInactive,
	}
}

const (
	// CertificateValidationRecordStatusPendingValidation is a CertificateValidationRecordStatus enum value
	CertificateValidationRecordStatusPendingValidation = "PENDING_VALIDATION"

	// CertificateValidationRecordStatusSuccess is a CertificateValidationRecordStatus enum value
	CertificateValidationRecordStatusSuccess = "SUCCESS"

	// CertificateValidationRecordStatusFailed is a CertificateValidationRecordStatus enum value
	CertificateValidationRecordStatusFailed = "FAILED"
)

// CertificateValidationRecordStatus_Values returns all elements of the CertificateValidationRecordStatus enum
func CertificateValidationRecordStatus_Values() []string {
	return []string{
		CertificateValidationRecordStatusPendingValidation,
		CertificateValidationRecordStatusSuccess,
		CertificateValidationRecordStatusFailed,
	}
}

const (
	// ConfigurationSourceRepository is a ConfigurationSource enum value
	ConfigurationSourceRepository = "REPOSITORY"

	// ConfigurationSourceApi is a ConfigurationSource enum value
	ConfigurationSourceApi = "API"
)

// ConfigurationSource_Values returns all elements of the ConfigurationSource enum
func ConfigurationSource_Values() []string {
	return []string{
		ConfigurationSourceRepository,
		ConfigurationSourceApi,
	}
}

const (
	// ConnectionStatusPendingHandshake is a ConnectionStatus enum value
	ConnectionStatusPendingHandshake = "PENDING_HANDSHAKE"

	// ConnectionStatusAvailable is a ConnectionStatus enum value
	ConnectionStatusAvailable = "AVAILABLE"

	// ConnectionStatusError is a ConnectionStatus enum value
	ConnectionStatusError = "ERROR"

	// ConnectionStatusDeleted is a ConnectionStatus enum value
	ConnectionStatusDeleted = "DELETED"
)

// ConnectionStatus_Values returns all elements of the ConnectionStatus enum
func ConnectionStatus_Values() []string {
	return []string{
		ConnectionStatusPendingHandshake,
		ConnectionStatusAvailable,
		ConnectionStatusError,
		ConnectionStatusDeleted,
	}
}

const (
	// CustomDomainAssociationStatusCreating is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusCreating = "CREATING"

	// CustomDomainAssociationStatusCreateFailed is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusCreateFailed = "CREATE_FAILED"

	// CustomDomainAssociationStatusActive is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusActive = "ACTIVE"

	// CustomDomainAssociationStatusDeleting is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusDeleting = "DELETING"

	// CustomDomainAssociationStatusDeleteFailed is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusDeleteFailed = "DELETE_FAILED"

	// CustomDomainAssociationStatusPendingCertificateDnsValidation is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusPendingCertificateDnsValidation = "PENDING_CERTIFICATE_DNS_VALIDATION"

	// CustomDomainAssociationStatusBindingCertificate is a CustomDomainAssociationStatus enum value
	CustomDomainAssociationStatusBindingCertificate = "BINDING_CERTIFICATE"
)

// CustomDomainAssociationStatus_Values returns all elements of the CustomDomainAssociationStatus enum
func CustomDomainAssociationStatus_Values() []string {
	return []string{
		CustomDomainAssociationStatusCreating,
		CustomDomainAssociationStatusCreateFailed,
		CustomDomainAssociationStatusActive,
		CustomDomainAssociationStatusDeleting,
		CustomDomainAssociationStatusDeleteFailed,
		CustomDomainAssociationStatusPendingCertificateDnsValidation,
		CustomDomainAssociationStatusBindingCertificate,
	}
}

const (
	// HealthCheckProtocolTcp is a HealthCheckProtocol enum value
	HealthCheckProtocolTcp = "TCP"

	// HealthCheckProtocolHttp is a HealthCheckProtocol enum value
	HealthCheckProtocolHttp = "HTTP"
)

// HealthCheckProtocol_Values returns all elements of the HealthCheckProtocol enum
func HealthCheckProtocol_Values() []string {
	return []string{
		HealthCheckProtocolTcp,
		HealthCheckProtocolHttp,
	}
}

const (
	// ImageRepositoryTypeEcr is a ImageRepositoryType enum value
	ImageRepositoryTypeEcr = "ECR"

	// ImageRepositoryTypeEcrPublic is a ImageRepositoryType enum value
	ImageRepositoryTypeEcrPublic = "ECR_PUBLIC"
)

// ImageRepositoryType_Values returns all elements of the ImageRepositoryType enum
func ImageRepositoryType_Values() []string {
	return []string{
		ImageRepositoryTypeEcr,
		ImageRepositoryTypeEcrPublic,
	}
}

const (
	// OperationStatusPending is a OperationStatus enum value
	OperationStatusPending = "PENDING"

	// OperationStatusInProgress is a OperationStatus enum value
	OperationStatusInProgress = "IN_PROGRESS"

	// OperationStatusFailed is a OperationStatus enum value
	OperationStatusFailed = "FAILED"

	// OperationStatusSucceeded is a OperationStatus enum value
	OperationStatusSucceeded = "SUCCEEDED"

	// OperationStatusRollbackInProgress is a OperationStatus enum value
	OperationStatusRollbackInProgress = "ROLLBACK_IN_PROGRESS"

	// OperationStatusRollbackFailed is a OperationStatus enum value
	OperationStatusRollbackFailed = "ROLLBACK_FAILED"

	// OperationStatusRollbackSucceeded is a OperationStatus enum value
	OperationStatusRollbackSucceeded = "ROLLBACK_SUCCEEDED"
)

// OperationStatus_Values returns all elements of the OperationStatus enum
func OperationStatus_Values() []string {
	return []string{
		OperationStatusPending,
		OperationStatusInProgress,
		OperationStatusFailed,
		OperationStatusSucceeded,
		OperationStatusRollbackInProgress,
		OperationStatusRollbackFailed,
		OperationStatusRollbackSucceeded,
	}
}

const (
	// OperationTypeStartDeployment is a OperationType enum value
	OperationTypeStartDeployment = "START_DEPLOYMENT"

	// OperationTypeCreateService is a OperationType enum value
	OperationTypeCreateService = "CREATE_SERVICE"

	// OperationTypePauseService is a OperationType enum value
	OperationTypePauseService = "PAUSE_SERVICE"

	// OperationTypeResumeService is a OperationType enum value
	OperationTypeResumeService = "RESUME_SERVICE"

	// OperationTypeDeleteService is a OperationType enum value
	OperationTypeDeleteService = "DELETE_SERVICE"
)

// OperationType_Values returns all elements of the OperationType enum
func OperationType_Values() []string {
	return []string{
		OperationTypeStartDeployment,
		OperationTypeCreateService,
		OperationTypePauseService,
		OperationTypeResumeService,
		OperationTypeDeleteService,
	}
}

const (
	// ProviderTypeGithub is a ProviderType enum value
	ProviderTypeGithub = "GITHUB"
)

// ProviderType_Values returns all elements of the ProviderType enum
func ProviderType_Values() []string {
	return []string{
		ProviderTypeGithub,
	}
}

const (
	// RuntimePython3 is a Runtime enum value
	RuntimePython3 = "PYTHON_3"

	// RuntimeNodejs12 is a Runtime enum value
	RuntimeNodejs12 = "NODEJS_12"
)

// Runtime_Values returns all elements of the Runtime enum
func Runtime_Values() []string {
	return []string{
		RuntimePython3,
		RuntimeNodejs12,
	}
}

const (
	// ServiceStatusCreateFailed is a ServiceStatus enum value
	ServiceStatusCreateFailed = "CREATE_FAILED"

	// ServiceStatusRunning is a ServiceStatus enum value
	ServiceStatusRunning = "RUNNING"

	// ServiceStatusDeleted is a ServiceStatus enum value
	ServiceStatusDeleted = "DELETED"

	// ServiceStatusDeleteFailed is a ServiceStatus enum value
	ServiceStatusDeleteFailed = "DELETE_FAILED"

	// ServiceStatusPaused is a ServiceStatus enum value
	ServiceStatusPaused = "PAUSED"

	// ServiceStatusOperationInProgress is a ServiceStatus enum value
	ServiceStatusOperationInProgress = "OPERATION_IN_PROGRESS"
)

// ServiceStatus_Values returns all elements of the ServiceStatus enum
func ServiceStatus_Values() []string {
	return []string{
		ServiceStatusCreateFailed,
		ServiceStatusRunning,
		ServiceStatusDeleted,
		ServiceStatusDeleteFailed,
		ServiceStatusPaused,
		ServiceStatusOperationInProgress,
	}
}

const (
	// SourceCodeVersionTypeBranch is a SourceCodeVersionType enum value
	SourceCodeVersionTypeBranch = "BRANCH"
)

// SourceCodeVersionType_Values returns all elements of the SourceCodeVersionType enum
func SourceCodeVersionType_Values() []string {
	return []string{
		SourceCodeVersionTypeBranch,
	}
}
