/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	submarineriov1 "github.com/submariner-io/submariner/pkg/apis/submariner.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeClusterGlobalEgressIPs implements ClusterGlobalEgressIPInterface
type FakeClusterGlobalEgressIPs struct {
	Fake *FakeSubmarinerV1
	ns   string
}

var clusterglobalegressipsResource = schema.GroupVersionResource{Group: "submariner.io", Version: "v1", Resource: "clusterglobalegressips"}

var clusterglobalegressipsKind = schema.GroupVersionKind{Group: "submariner.io", Version: "v1", Kind: "ClusterGlobalEgressIP"}

// Get takes name of the clusterGlobalEgressIP, and returns the corresponding clusterGlobalEgressIP object, and an error if there is any.
func (c *FakeClusterGlobalEgressIPs) Get(ctx context.Context, name string, options v1.GetOptions) (result *submarineriov1.ClusterGlobalEgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(clusterglobalegressipsResource, c.ns, name), &submarineriov1.ClusterGlobalEgressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.ClusterGlobalEgressIP), err
}

// List takes label and field selectors, and returns the list of ClusterGlobalEgressIPs that match those selectors.
func (c *FakeClusterGlobalEgressIPs) List(ctx context.Context, opts v1.ListOptions) (result *submarineriov1.ClusterGlobalEgressIPList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(clusterglobalegressipsResource, clusterglobalegressipsKind, c.ns, opts), &submarineriov1.ClusterGlobalEgressIPList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &submarineriov1.ClusterGlobalEgressIPList{ListMeta: obj.(*submarineriov1.ClusterGlobalEgressIPList).ListMeta}
	for _, item := range obj.(*submarineriov1.ClusterGlobalEgressIPList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested clusterGlobalEgressIPs.
func (c *FakeClusterGlobalEgressIPs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(clusterglobalegressipsResource, c.ns, opts))

}

// Create takes the representation of a clusterGlobalEgressIP and creates it.  Returns the server's representation of the clusterGlobalEgressIP, and an error, if there is any.
func (c *FakeClusterGlobalEgressIPs) Create(ctx context.Context, clusterGlobalEgressIP *submarineriov1.ClusterGlobalEgressIP, opts v1.CreateOptions) (result *submarineriov1.ClusterGlobalEgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(clusterglobalegressipsResource, c.ns, clusterGlobalEgressIP), &submarineriov1.ClusterGlobalEgressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.ClusterGlobalEgressIP), err
}

// Update takes the representation of a clusterGlobalEgressIP and updates it. Returns the server's representation of the clusterGlobalEgressIP, and an error, if there is any.
func (c *FakeClusterGlobalEgressIPs) Update(ctx context.Context, clusterGlobalEgressIP *submarineriov1.ClusterGlobalEgressIP, opts v1.UpdateOptions) (result *submarineriov1.ClusterGlobalEgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(clusterglobalegressipsResource, c.ns, clusterGlobalEgressIP), &submarineriov1.ClusterGlobalEgressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.ClusterGlobalEgressIP), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeClusterGlobalEgressIPs) UpdateStatus(ctx context.Context, clusterGlobalEgressIP *submarineriov1.ClusterGlobalEgressIP, opts v1.UpdateOptions) (*submarineriov1.ClusterGlobalEgressIP, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(clusterglobalegressipsResource, "status", c.ns, clusterGlobalEgressIP), &submarineriov1.ClusterGlobalEgressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.ClusterGlobalEgressIP), err
}

// Delete takes name of the clusterGlobalEgressIP and deletes it. Returns an error if one occurs.
func (c *FakeClusterGlobalEgressIPs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(clusterglobalegressipsResource, c.ns, name), &submarineriov1.ClusterGlobalEgressIP{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeClusterGlobalEgressIPs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(clusterglobalegressipsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &submarineriov1.ClusterGlobalEgressIPList{})
	return err
}

// Patch applies the patch and returns the patched clusterGlobalEgressIP.
func (c *FakeClusterGlobalEgressIPs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *submarineriov1.ClusterGlobalEgressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(clusterglobalegressipsResource, c.ns, name, pt, data, subresources...), &submarineriov1.ClusterGlobalEgressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.ClusterGlobalEgressIP), err
}
