// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateNodeInput struct {
	_ struct{} `type:"structure"`

	// Engine attributes that are used for disassociating the node. No attributes
	// are required for Puppet.
	//
	// Attributes required in a DisassociateNode request for Chef
	//
	//    * CHEF_ORGANIZATION: The Chef organization with which the node was associated.
	//    By default only one organization named default can exist.
	EngineAttributes []EngineAttribute `type:"list"`

	// The name of the client node.
	//
	// NodeName is a required field
	NodeName *string `type:"string" required:"true"`

	// The name of the server from which to disassociate the node.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateNodeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateNodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateNodeInput"}

	if s.NodeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeName"))
	}

	if s.ServerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateNodeOutput struct {
	_ struct{} `type:"structure"`

	// Contains a token which can be passed to the DescribeNodeAssociationStatus
	// API call to get the status of the disassociation request.
	NodeAssociationStatusToken *string `type:"string"`
}

// String returns the string representation
func (s DisassociateNodeOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateNode = "DisassociateNode"

// DisassociateNodeRequest returns a request value for making API operation for
// AWS OpsWorks CM.
//
// Disassociates a node from an AWS OpsWorks CM server, and removes the node
// from the server's managed nodes. After a node is disassociated, the node
// key pair is no longer valid for accessing the configuration manager's API.
// For more information about how to associate a node, see AssociateNode.
//
// A node can can only be disassociated from a server that is in a HEALTHY state.
// Otherwise, an InvalidStateException is thrown. A ResourceNotFoundException
// is thrown when the server does not exist. A ValidationException is raised
// when parameters of the request are not valid.
//
//    // Example sending a request using DisassociateNodeRequest.
//    req := client.DisassociateNodeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DisassociateNode
func (c *Client) DisassociateNodeRequest(input *DisassociateNodeInput) DisassociateNodeRequest {
	op := &aws.Operation{
		Name:       opDisassociateNode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateNodeInput{}
	}

	req := c.newRequest(op, input, &DisassociateNodeOutput{})
	return DisassociateNodeRequest{Request: req, Input: input, Copy: c.DisassociateNodeRequest}
}

// DisassociateNodeRequest is the request type for the
// DisassociateNode API operation.
type DisassociateNodeRequest struct {
	*aws.Request
	Input *DisassociateNodeInput
	Copy  func(*DisassociateNodeInput) DisassociateNodeRequest
}

// Send marshals and sends the DisassociateNode API request.
func (r DisassociateNodeRequest) Send(ctx context.Context) (*DisassociateNodeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateNodeResponse{
		DisassociateNodeOutput: r.Request.Data.(*DisassociateNodeOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateNodeResponse is the response type for the
// DisassociateNode API operation.
type DisassociateNodeResponse struct {
	*DisassociateNodeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateNode request.
func (r *DisassociateNodeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
