/*
© 2020 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package e2e

import (
	"testing"

	. "github.com/onsi/gomega"
	testV1 "github.com/submariner-io/admiral/test/apis/admiral.submariner.io/v1"
	_ "github.com/submariner-io/admiral/test/e2e/syncer"
	_ "github.com/submariner-io/admiral/test/e2e/watcher"
	"github.com/submariner-io/shipyard/test/e2e"
	"github.com/submariner-io/shipyard/test/e2e/framework"
	"k8s.io/client-go/kubernetes/scheme"
)

func init() {
	framework.AddBeforeSuite(func() {
		Expect(testV1.AddToScheme(scheme.Scheme)).To(Succeed())
	})
}

func TestE2E(t *testing.T) {
	e2e.RunE2ETests(t)
}
