// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event tracker to describe.
	//
	// EventTrackerArn is a required field
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventTrackerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEventTrackerInput"}

	if s.EventTrackerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventTrackerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEventTrackerOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the event tracker.
	EventTracker *EventTracker `locationName:"eventTracker" type:"structure"`
}

// String returns the string representation
func (s DescribeEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEventTracker = "DescribeEventTracker"

// DescribeEventTrackerRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Describes an event tracker. The response includes the trackingId and status
// of the event tracker. For more information on event trackers, see CreateEventTracker.
//
//    // Example sending a request using DescribeEventTrackerRequest.
//    req := client.DescribeEventTrackerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker
func (c *Client) DescribeEventTrackerRequest(input *DescribeEventTrackerInput) DescribeEventTrackerRequest {
	op := &aws.Operation{
		Name:       opDescribeEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventTrackerInput{}
	}

	req := c.newRequest(op, input, &DescribeEventTrackerOutput{})
	return DescribeEventTrackerRequest{Request: req, Input: input, Copy: c.DescribeEventTrackerRequest}
}

// DescribeEventTrackerRequest is the request type for the
// DescribeEventTracker API operation.
type DescribeEventTrackerRequest struct {
	*aws.Request
	Input *DescribeEventTrackerInput
	Copy  func(*DescribeEventTrackerInput) DescribeEventTrackerRequest
}

// Send marshals and sends the DescribeEventTracker API request.
func (r DescribeEventTrackerRequest) Send(ctx context.Context) (*DescribeEventTrackerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEventTrackerResponse{
		DescribeEventTrackerOutput: r.Request.Data.(*DescribeEventTrackerOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEventTrackerResponse is the response type for the
// DescribeEventTracker API operation.
type DescribeEventTrackerResponse struct {
	*DescribeEventTrackerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEventTracker request.
func (r *DescribeEventTrackerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
