// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The document version for which you want information. Can be a specific version
	// or the default version.
	DocumentVersion *string `type:"string"`

	// The name of the Systems Manager document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An optional field specifying the version of the artifact associated with
	// the document. For example, "Release 12, Update 6". This value is unique across
	// all versions of a document, and cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDocumentInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Systems Manager document.
	Document *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDocument = "DescribeDocument"

// DescribeDocumentRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Describes the specified Systems Manager document.
//
//    // Example sending a request using DescribeDocumentRequest.
//    req := client.DescribeDocumentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument
func (c *Client) DescribeDocumentRequest(input *DescribeDocumentInput) DescribeDocumentRequest {
	op := &aws.Operation{
		Name:       opDescribeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInput{}
	}

	req := c.newRequest(op, input, &DescribeDocumentOutput{})
	return DescribeDocumentRequest{Request: req, Input: input, Copy: c.DescribeDocumentRequest}
}

// DescribeDocumentRequest is the request type for the
// DescribeDocument API operation.
type DescribeDocumentRequest struct {
	*aws.Request
	Input *DescribeDocumentInput
	Copy  func(*DescribeDocumentInput) DescribeDocumentRequest
}

// Send marshals and sends the DescribeDocument API request.
func (r DescribeDocumentRequest) Send(ctx context.Context) (*DescribeDocumentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDocumentResponse{
		DescribeDocumentOutput: r.Request.Data.(*DescribeDocumentOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDocumentResponse is the response type for the
// DescribeDocument API operation.
type DescribeDocumentResponse struct {
	*DescribeDocumentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDocument request.
func (r *DescribeDocumentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
