# Submariner Governance

## Open Governance Checklist

The opengovernance.dev project [provides the following
checklist](https://github.com/opengovernance/opengovernance.dev/blob/master/README.md#checklist) for defining open governance.

Submariner's answers are provided for each point.

This is not meant to define Submariner's governance, but instead to document it clearly. Authoritative sources are cited inline.

### Ownership

* Who owns the copyright on contributed code?
  * All Submariner code is
    [linted](https://github.com/submariner-io/submariner/blob/ed473895ece6dc9be6f9d925a3cfbe441513cf17/.licenserc.json#L22)
    to verify the copyright notices specify "Contributors to the Submariner project", per the
    [CNCF recommendations](https://github.com/cncf/foundation/blob/master/copyright-notices.md#copyright-notices).
* Who owns the domain(s) for the project?
  * Submariner is a CNCF Sandbox project, so all Submariner domains are owned by the CNCF.
* Who owns the trademark for the project, is it neutrally owned and governed? Are there open trademark guidelines?
  * Submariner is a CNCF Sandbox project, so all Submariner trademarks are owned by the CNCF.
* How can users license the project’s branding? Are there open branding guidelines?
  * Submariner is a CNCF Sandbox project, so please see the CNCF/artwork project's
    [Trademark and Logo Policy](https://github.com/cncf/artwork#trademark-and-logo-policy).
* If the project raises funds, who owns it?
  * Submariner is a CNCF Sandbox project, so funds would be owned by the CNCF.

### Process

* Who makes decisions on how the project performs releases?
  * Project Owners are responsible for defining milestones and releases, per the Submariner
    [Owner Responsibilities and Privileges](https://submariner.io/community/contributor-roles/#owner-responsibilities-and-privileges).
* How can the project contributors become committers?
  * In short, by reviewing pull requests and receiving Committer/Owner approval.
    See the [Committer Requirements](https://submariner.io/community/contributor-roles/#committer-requirements) for details.
* How are project committers removed?
  * Committers can be removed by stepping down or by two thirds vote of Project Owners, per the Submariner [Committer Responsibilities and
    Privileges](https://submariner.io/community/contributor-roles/#committer-responsibilities-and-privileges). Project Owner removals are
    currently frozen except for stepping down or for Code of Conduct violations. See the [Owner Removal and Future Elected
    Governance](https://submariner.io/community/contributor-roles/#owner-removal-and-future-elected-governance) documentation for details.
* If the project raises funds, who decides how this money is spent?
  * Project Owners are responsible for deciding how funds are spent, per the Submariner
    [Owner Responsibilities and Privileges](https://submariner.io/community/contributor-roles/#owner-responsibilities-and-privileges).
* Who decides the project roadmap?
  * The [roadmap planning process](https://submariner.io/community/roadmap/#planning-process) is public and open to everyone.
* Who can participate in security disclosure issues?
  * Project Owners are responsible for receiving [security disclosures](https://submariner.io/security.txt) and ensuring an adequate
    response, per the Submariner
    [Owner Responsibilities and Privileges](https://submariner.io/community/contributor-roles/#owner-responsibilities-and-privileges).
* How transparent are the decision-making processes?
  * Decisions are made in weekly public community meetings or on public GitHub Issues/PRs. All meetings are documented in Submariner's
    [Community Calendar](https://submariner.io/community/getting-help/#community-calendar).
* Who enforces the code of conduct?
  * The Submariner Project Owners enforce the [Code of Conduct](https://submariner.io/community/code-of-conduct), per the Submariner
    [Owner Responsibilities and Privileges](https://submariner.io/community/contributor-roles/#owner-responsibilities-and-privileges).
