// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codebuildiface provides an interface to enable mocking the AWS CodeBuild service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codebuildiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/codebuild"
)

// CodeBuildAPI provides an interface to enable mocking the
// codebuild.CodeBuild service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS CodeBuild.
//    func myFunc(svc codebuildiface.CodeBuildAPI) bool {
//        // Make svc.BatchDeleteBuilds request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := codebuild.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockCodeBuildClient struct {
//        codebuildiface.CodeBuildAPI
//    }
//    func (m *mockCodeBuildClient) BatchDeleteBuilds(input *codebuild.BatchDeleteBuildsInput) (*codebuild.BatchDeleteBuildsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockCodeBuildClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CodeBuildAPI interface {
	BatchDeleteBuilds(*codebuild.BatchDeleteBuildsInput) (*codebuild.BatchDeleteBuildsOutput, error)
	BatchDeleteBuildsWithContext(aws.Context, *codebuild.BatchDeleteBuildsInput, ...request.Option) (*codebuild.BatchDeleteBuildsOutput, error)
	BatchDeleteBuildsRequest(*codebuild.BatchDeleteBuildsInput) (*request.Request, *codebuild.BatchDeleteBuildsOutput)

	BatchGetBuilds(*codebuild.BatchGetBuildsInput) (*codebuild.BatchGetBuildsOutput, error)
	BatchGetBuildsWithContext(aws.Context, *codebuild.BatchGetBuildsInput, ...request.Option) (*codebuild.BatchGetBuildsOutput, error)
	BatchGetBuildsRequest(*codebuild.BatchGetBuildsInput) (*request.Request, *codebuild.BatchGetBuildsOutput)

	BatchGetProjects(*codebuild.BatchGetProjectsInput) (*codebuild.BatchGetProjectsOutput, error)
	BatchGetProjectsWithContext(aws.Context, *codebuild.BatchGetProjectsInput, ...request.Option) (*codebuild.BatchGetProjectsOutput, error)
	BatchGetProjectsRequest(*codebuild.BatchGetProjectsInput) (*request.Request, *codebuild.BatchGetProjectsOutput)

	BatchGetReportGroups(*codebuild.BatchGetReportGroupsInput) (*codebuild.BatchGetReportGroupsOutput, error)
	BatchGetReportGroupsWithContext(aws.Context, *codebuild.BatchGetReportGroupsInput, ...request.Option) (*codebuild.BatchGetReportGroupsOutput, error)
	BatchGetReportGroupsRequest(*codebuild.BatchGetReportGroupsInput) (*request.Request, *codebuild.BatchGetReportGroupsOutput)

	BatchGetReports(*codebuild.BatchGetReportsInput) (*codebuild.BatchGetReportsOutput, error)
	BatchGetReportsWithContext(aws.Context, *codebuild.BatchGetReportsInput, ...request.Option) (*codebuild.BatchGetReportsOutput, error)
	BatchGetReportsRequest(*codebuild.BatchGetReportsInput) (*request.Request, *codebuild.BatchGetReportsOutput)

	CreateProject(*codebuild.CreateProjectInput) (*codebuild.CreateProjectOutput, error)
	CreateProjectWithContext(aws.Context, *codebuild.CreateProjectInput, ...request.Option) (*codebuild.CreateProjectOutput, error)
	CreateProjectRequest(*codebuild.CreateProjectInput) (*request.Request, *codebuild.CreateProjectOutput)

	CreateReportGroup(*codebuild.CreateReportGroupInput) (*codebuild.CreateReportGroupOutput, error)
	CreateReportGroupWithContext(aws.Context, *codebuild.CreateReportGroupInput, ...request.Option) (*codebuild.CreateReportGroupOutput, error)
	CreateReportGroupRequest(*codebuild.CreateReportGroupInput) (*request.Request, *codebuild.CreateReportGroupOutput)

	CreateWebhook(*codebuild.CreateWebhookInput) (*codebuild.CreateWebhookOutput, error)
	CreateWebhookWithContext(aws.Context, *codebuild.CreateWebhookInput, ...request.Option) (*codebuild.CreateWebhookOutput, error)
	CreateWebhookRequest(*codebuild.CreateWebhookInput) (*request.Request, *codebuild.CreateWebhookOutput)

	DeleteProject(*codebuild.DeleteProjectInput) (*codebuild.DeleteProjectOutput, error)
	DeleteProjectWithContext(aws.Context, *codebuild.DeleteProjectInput, ...request.Option) (*codebuild.DeleteProjectOutput, error)
	DeleteProjectRequest(*codebuild.DeleteProjectInput) (*request.Request, *codebuild.DeleteProjectOutput)

	DeleteReport(*codebuild.DeleteReportInput) (*codebuild.DeleteReportOutput, error)
	DeleteReportWithContext(aws.Context, *codebuild.DeleteReportInput, ...request.Option) (*codebuild.DeleteReportOutput, error)
	DeleteReportRequest(*codebuild.DeleteReportInput) (*request.Request, *codebuild.DeleteReportOutput)

	DeleteReportGroup(*codebuild.DeleteReportGroupInput) (*codebuild.DeleteReportGroupOutput, error)
	DeleteReportGroupWithContext(aws.Context, *codebuild.DeleteReportGroupInput, ...request.Option) (*codebuild.DeleteReportGroupOutput, error)
	DeleteReportGroupRequest(*codebuild.DeleteReportGroupInput) (*request.Request, *codebuild.DeleteReportGroupOutput)

	DeleteResourcePolicy(*codebuild.DeleteResourcePolicyInput) (*codebuild.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *codebuild.DeleteResourcePolicyInput, ...request.Option) (*codebuild.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*codebuild.DeleteResourcePolicyInput) (*request.Request, *codebuild.DeleteResourcePolicyOutput)

	DeleteSourceCredentials(*codebuild.DeleteSourceCredentialsInput) (*codebuild.DeleteSourceCredentialsOutput, error)
	DeleteSourceCredentialsWithContext(aws.Context, *codebuild.DeleteSourceCredentialsInput, ...request.Option) (*codebuild.DeleteSourceCredentialsOutput, error)
	DeleteSourceCredentialsRequest(*codebuild.DeleteSourceCredentialsInput) (*request.Request, *codebuild.DeleteSourceCredentialsOutput)

	DeleteWebhook(*codebuild.DeleteWebhookInput) (*codebuild.DeleteWebhookOutput, error)
	DeleteWebhookWithContext(aws.Context, *codebuild.DeleteWebhookInput, ...request.Option) (*codebuild.DeleteWebhookOutput, error)
	DeleteWebhookRequest(*codebuild.DeleteWebhookInput) (*request.Request, *codebuild.DeleteWebhookOutput)

	DescribeTestCases(*codebuild.DescribeTestCasesInput) (*codebuild.DescribeTestCasesOutput, error)
	DescribeTestCasesWithContext(aws.Context, *codebuild.DescribeTestCasesInput, ...request.Option) (*codebuild.DescribeTestCasesOutput, error)
	DescribeTestCasesRequest(*codebuild.DescribeTestCasesInput) (*request.Request, *codebuild.DescribeTestCasesOutput)

	GetResourcePolicy(*codebuild.GetResourcePolicyInput) (*codebuild.GetResourcePolicyOutput, error)
	GetResourcePolicyWithContext(aws.Context, *codebuild.GetResourcePolicyInput, ...request.Option) (*codebuild.GetResourcePolicyOutput, error)
	GetResourcePolicyRequest(*codebuild.GetResourcePolicyInput) (*request.Request, *codebuild.GetResourcePolicyOutput)

	ImportSourceCredentials(*codebuild.ImportSourceCredentialsInput) (*codebuild.ImportSourceCredentialsOutput, error)
	ImportSourceCredentialsWithContext(aws.Context, *codebuild.ImportSourceCredentialsInput, ...request.Option) (*codebuild.ImportSourceCredentialsOutput, error)
	ImportSourceCredentialsRequest(*codebuild.ImportSourceCredentialsInput) (*request.Request, *codebuild.ImportSourceCredentialsOutput)

	InvalidateProjectCache(*codebuild.InvalidateProjectCacheInput) (*codebuild.InvalidateProjectCacheOutput, error)
	InvalidateProjectCacheWithContext(aws.Context, *codebuild.InvalidateProjectCacheInput, ...request.Option) (*codebuild.InvalidateProjectCacheOutput, error)
	InvalidateProjectCacheRequest(*codebuild.InvalidateProjectCacheInput) (*request.Request, *codebuild.InvalidateProjectCacheOutput)

	ListBuilds(*codebuild.ListBuildsInput) (*codebuild.ListBuildsOutput, error)
	ListBuildsWithContext(aws.Context, *codebuild.ListBuildsInput, ...request.Option) (*codebuild.ListBuildsOutput, error)
	ListBuildsRequest(*codebuild.ListBuildsInput) (*request.Request, *codebuild.ListBuildsOutput)

	ListBuildsForProject(*codebuild.ListBuildsForProjectInput) (*codebuild.ListBuildsForProjectOutput, error)
	ListBuildsForProjectWithContext(aws.Context, *codebuild.ListBuildsForProjectInput, ...request.Option) (*codebuild.ListBuildsForProjectOutput, error)
	ListBuildsForProjectRequest(*codebuild.ListBuildsForProjectInput) (*request.Request, *codebuild.ListBuildsForProjectOutput)

	ListCuratedEnvironmentImages(*codebuild.ListCuratedEnvironmentImagesInput) (*codebuild.ListCuratedEnvironmentImagesOutput, error)
	ListCuratedEnvironmentImagesWithContext(aws.Context, *codebuild.ListCuratedEnvironmentImagesInput, ...request.Option) (*codebuild.ListCuratedEnvironmentImagesOutput, error)
	ListCuratedEnvironmentImagesRequest(*codebuild.ListCuratedEnvironmentImagesInput) (*request.Request, *codebuild.ListCuratedEnvironmentImagesOutput)

	ListProjects(*codebuild.ListProjectsInput) (*codebuild.ListProjectsOutput, error)
	ListProjectsWithContext(aws.Context, *codebuild.ListProjectsInput, ...request.Option) (*codebuild.ListProjectsOutput, error)
	ListProjectsRequest(*codebuild.ListProjectsInput) (*request.Request, *codebuild.ListProjectsOutput)

	ListReportGroups(*codebuild.ListReportGroupsInput) (*codebuild.ListReportGroupsOutput, error)
	ListReportGroupsWithContext(aws.Context, *codebuild.ListReportGroupsInput, ...request.Option) (*codebuild.ListReportGroupsOutput, error)
	ListReportGroupsRequest(*codebuild.ListReportGroupsInput) (*request.Request, *codebuild.ListReportGroupsOutput)

	ListReports(*codebuild.ListReportsInput) (*codebuild.ListReportsOutput, error)
	ListReportsWithContext(aws.Context, *codebuild.ListReportsInput, ...request.Option) (*codebuild.ListReportsOutput, error)
	ListReportsRequest(*codebuild.ListReportsInput) (*request.Request, *codebuild.ListReportsOutput)

	ListReportsForReportGroup(*codebuild.ListReportsForReportGroupInput) (*codebuild.ListReportsForReportGroupOutput, error)
	ListReportsForReportGroupWithContext(aws.Context, *codebuild.ListReportsForReportGroupInput, ...request.Option) (*codebuild.ListReportsForReportGroupOutput, error)
	ListReportsForReportGroupRequest(*codebuild.ListReportsForReportGroupInput) (*request.Request, *codebuild.ListReportsForReportGroupOutput)

	ListSharedProjects(*codebuild.ListSharedProjectsInput) (*codebuild.ListSharedProjectsOutput, error)
	ListSharedProjectsWithContext(aws.Context, *codebuild.ListSharedProjectsInput, ...request.Option) (*codebuild.ListSharedProjectsOutput, error)
	ListSharedProjectsRequest(*codebuild.ListSharedProjectsInput) (*request.Request, *codebuild.ListSharedProjectsOutput)

	ListSharedReportGroups(*codebuild.ListSharedReportGroupsInput) (*codebuild.ListSharedReportGroupsOutput, error)
	ListSharedReportGroupsWithContext(aws.Context, *codebuild.ListSharedReportGroupsInput, ...request.Option) (*codebuild.ListSharedReportGroupsOutput, error)
	ListSharedReportGroupsRequest(*codebuild.ListSharedReportGroupsInput) (*request.Request, *codebuild.ListSharedReportGroupsOutput)

	ListSourceCredentials(*codebuild.ListSourceCredentialsInput) (*codebuild.ListSourceCredentialsOutput, error)
	ListSourceCredentialsWithContext(aws.Context, *codebuild.ListSourceCredentialsInput, ...request.Option) (*codebuild.ListSourceCredentialsOutput, error)
	ListSourceCredentialsRequest(*codebuild.ListSourceCredentialsInput) (*request.Request, *codebuild.ListSourceCredentialsOutput)

	PutResourcePolicy(*codebuild.PutResourcePolicyInput) (*codebuild.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *codebuild.PutResourcePolicyInput, ...request.Option) (*codebuild.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*codebuild.PutResourcePolicyInput) (*request.Request, *codebuild.PutResourcePolicyOutput)

	StartBuild(*codebuild.StartBuildInput) (*codebuild.StartBuildOutput, error)
	StartBuildWithContext(aws.Context, *codebuild.StartBuildInput, ...request.Option) (*codebuild.StartBuildOutput, error)
	StartBuildRequest(*codebuild.StartBuildInput) (*request.Request, *codebuild.StartBuildOutput)

	StopBuild(*codebuild.StopBuildInput) (*codebuild.StopBuildOutput, error)
	StopBuildWithContext(aws.Context, *codebuild.StopBuildInput, ...request.Option) (*codebuild.StopBuildOutput, error)
	StopBuildRequest(*codebuild.StopBuildInput) (*request.Request, *codebuild.StopBuildOutput)

	UpdateProject(*codebuild.UpdateProjectInput) (*codebuild.UpdateProjectOutput, error)
	UpdateProjectWithContext(aws.Context, *codebuild.UpdateProjectInput, ...request.Option) (*codebuild.UpdateProjectOutput, error)
	UpdateProjectRequest(*codebuild.UpdateProjectInput) (*request.Request, *codebuild.UpdateProjectOutput)

	UpdateReportGroup(*codebuild.UpdateReportGroupInput) (*codebuild.UpdateReportGroupOutput, error)
	UpdateReportGroupWithContext(aws.Context, *codebuild.UpdateReportGroupInput, ...request.Option) (*codebuild.UpdateReportGroupOutput, error)
	UpdateReportGroupRequest(*codebuild.UpdateReportGroupInput) (*request.Request, *codebuild.UpdateReportGroupOutput)

	UpdateWebhook(*codebuild.UpdateWebhookInput) (*codebuild.UpdateWebhookOutput, error)
	UpdateWebhookWithContext(aws.Context, *codebuild.UpdateWebhookInput, ...request.Option) (*codebuild.UpdateWebhookOutput, error)
	UpdateWebhookRequest(*codebuild.UpdateWebhookInput) (*request.Request, *codebuild.UpdateWebhookOutput)
}

var _ CodeBuildAPI = (*codebuild.CodeBuild)(nil)
