// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateContainer = "CreateContainer"

// CreateContainerRequest generates a "aws/request.Request" representing the
// client's request for the CreateContainer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContainer for more information on using the CreateContainer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContainerRequest method.
//    req, resp := client.CreateContainerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer
func (c *MediaStore) CreateContainerRequest(input *CreateContainerInput) (req *request.Request, output *CreateContainerOutput) {
	op := &request.Operation{
		Name:       opCreateContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContainerInput{}
	}

	output = &CreateContainerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContainer API operation for AWS Elemental MediaStore.
//
// Creates a storage container to hold objects. A container is similar to a
// bucket in the Amazon S3 service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation CreateContainer for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * LimitExceededException
//   A service limit has been exceeded.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer
func (c *MediaStore) CreateContainer(input *CreateContainerInput) (*CreateContainerOutput, error) {
	req, out := c.CreateContainerRequest(input)
	return out, req.Send()
}

// CreateContainerWithContext is the same as CreateContainer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContainer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) CreateContainerWithContext(ctx aws.Context, input *CreateContainerInput, opts ...request.Option) (*CreateContainerOutput, error) {
	req, out := c.CreateContainerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainer = "DeleteContainer"

// DeleteContainerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainer for more information on using the DeleteContainer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContainerRequest method.
//    req, resp := client.DeleteContainerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainer
func (c *MediaStore) DeleteContainerRequest(input *DeleteContainerInput) (req *request.Request, output *DeleteContainerOutput) {
	op := &request.Operation{
		Name:       opDeleteContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContainerInput{}
	}

	output = &DeleteContainerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContainer API operation for AWS Elemental MediaStore.
//
// Deletes the specified container. Before you make a DeleteContainer request,
// delete any objects in the container or in any folders in the container. You
// can delete only empty containers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteContainer for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainer
func (c *MediaStore) DeleteContainer(input *DeleteContainerInput) (*DeleteContainerOutput, error) {
	req, out := c.DeleteContainerRequest(input)
	return out, req.Send()
}

// DeleteContainerWithContext is the same as DeleteContainer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteContainerWithContext(ctx aws.Context, input *DeleteContainerInput, opts ...request.Option) (*DeleteContainerOutput, error) {
	req, out := c.DeleteContainerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainerPolicy = "DeleteContainerPolicy"

// DeleteContainerPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainerPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainerPolicy for more information on using the DeleteContainerPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContainerPolicyRequest method.
//    req, resp := client.DeleteContainerPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicy
func (c *MediaStore) DeleteContainerPolicyRequest(input *DeleteContainerPolicyInput) (req *request.Request, output *DeleteContainerPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContainerPolicyInput{}
	}

	output = &DeleteContainerPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContainerPolicy API operation for AWS Elemental MediaStore.
//
// Deletes the access policy that is associated with the specified container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteContainerPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * PolicyNotFoundException
//   The policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicy
func (c *MediaStore) DeleteContainerPolicy(input *DeleteContainerPolicyInput) (*DeleteContainerPolicyOutput, error) {
	req, out := c.DeleteContainerPolicyRequest(input)
	return out, req.Send()
}

// DeleteContainerPolicyWithContext is the same as DeleteContainerPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainerPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteContainerPolicyWithContext(ctx aws.Context, input *DeleteContainerPolicyInput, opts ...request.Option) (*DeleteContainerPolicyOutput, error) {
	req, out := c.DeleteContainerPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCorsPolicy = "DeleteCorsPolicy"

// DeleteCorsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCorsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCorsPolicy for more information on using the DeleteCorsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCorsPolicyRequest method.
//    req, resp := client.DeleteCorsPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteCorsPolicy
func (c *MediaStore) DeleteCorsPolicyRequest(input *DeleteCorsPolicyInput) (req *request.Request, output *DeleteCorsPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteCorsPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCorsPolicyInput{}
	}

	output = &DeleteCorsPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCorsPolicy API operation for AWS Elemental MediaStore.
//
// Deletes the cross-origin resource sharing (CORS) configuration information
// that is set for the container.
//
// To use this operation, you must have permission to perform the MediaStore:DeleteCorsPolicy
// action. The container owner has this permission by default and can grant
// this permission to others.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteCorsPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * CorsPolicyNotFoundException
//   The CORS policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteCorsPolicy
func (c *MediaStore) DeleteCorsPolicy(input *DeleteCorsPolicyInput) (*DeleteCorsPolicyOutput, error) {
	req, out := c.DeleteCorsPolicyRequest(input)
	return out, req.Send()
}

// DeleteCorsPolicyWithContext is the same as DeleteCorsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCorsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteCorsPolicyWithContext(ctx aws.Context, input *DeleteCorsPolicyInput, opts ...request.Option) (*DeleteCorsPolicyOutput, error) {
	req, out := c.DeleteCorsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLifecyclePolicy = "DeleteLifecyclePolicy"

// DeleteLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLifecyclePolicy for more information on using the DeleteLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLifecyclePolicyRequest method.
//    req, resp := client.DeleteLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteLifecyclePolicy
func (c *MediaStore) DeleteLifecyclePolicyRequest(input *DeleteLifecyclePolicyInput) (req *request.Request, output *DeleteLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteLifecyclePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLifecyclePolicyInput{}
	}

	output = &DeleteLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLifecyclePolicy API operation for AWS Elemental MediaStore.
//
// Removes an object lifecycle policy from a container. It takes up to 20 minutes
// for the change to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * PolicyNotFoundException
//   The policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteLifecyclePolicy
func (c *MediaStore) DeleteLifecyclePolicy(input *DeleteLifecyclePolicyInput) (*DeleteLifecyclePolicyOutput, error) {
	req, out := c.DeleteLifecyclePolicyRequest(input)
	return out, req.Send()
}

// DeleteLifecyclePolicyWithContext is the same as DeleteLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteLifecyclePolicyWithContext(ctx aws.Context, input *DeleteLifecyclePolicyInput, opts ...request.Option) (*DeleteLifecyclePolicyOutput, error) {
	req, out := c.DeleteLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMetricPolicy = "DeleteMetricPolicy"

// DeleteMetricPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMetricPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMetricPolicy for more information on using the DeleteMetricPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMetricPolicyRequest method.
//    req, resp := client.DeleteMetricPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteMetricPolicy
func (c *MediaStore) DeleteMetricPolicyRequest(input *DeleteMetricPolicyInput) (req *request.Request, output *DeleteMetricPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteMetricPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMetricPolicyInput{}
	}

	output = &DeleteMetricPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMetricPolicy API operation for AWS Elemental MediaStore.
//
// Deletes the metric policy that is associated with the specified container.
// If there is no metric policy associated with the container, MediaStore doesn't
// send metrics to CloudWatch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteMetricPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * PolicyNotFoundException
//   The policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteMetricPolicy
func (c *MediaStore) DeleteMetricPolicy(input *DeleteMetricPolicyInput) (*DeleteMetricPolicyOutput, error) {
	req, out := c.DeleteMetricPolicyRequest(input)
	return out, req.Send()
}

// DeleteMetricPolicyWithContext is the same as DeleteMetricPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMetricPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteMetricPolicyWithContext(ctx aws.Context, input *DeleteMetricPolicyInput, opts ...request.Option) (*DeleteMetricPolicyOutput, error) {
	req, out := c.DeleteMetricPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContainer = "DescribeContainer"

// DescribeContainerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContainer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContainer for more information on using the DescribeContainer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContainerRequest method.
//    req, resp := client.DescribeContainerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainer
func (c *MediaStore) DescribeContainerRequest(input *DescribeContainerInput) (req *request.Request, output *DescribeContainerOutput) {
	op := &request.Operation{
		Name:       opDescribeContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContainerInput{}
	}

	output = &DescribeContainerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContainer API operation for AWS Elemental MediaStore.
//
// Retrieves the properties of the requested container. This request is commonly
// used to retrieve the endpoint of a container. An endpoint is a value assigned
// by the service when a new container is created. A container's endpoint does
// not change after it has been assigned. The DescribeContainer request returns
// a single Container object based on ContainerName. To return all Container
// objects that are associated with a specified AWS account, use ListContainers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DescribeContainer for usage and error information.
//
// Returned Error Types:
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainer
func (c *MediaStore) DescribeContainer(input *DescribeContainerInput) (*DescribeContainerOutput, error) {
	req, out := c.DescribeContainerRequest(input)
	return out, req.Send()
}

// DescribeContainerWithContext is the same as DescribeContainer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContainer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DescribeContainerWithContext(ctx aws.Context, input *DescribeContainerInput, opts ...request.Option) (*DescribeContainerOutput, error) {
	req, out := c.DescribeContainerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerPolicy = "GetContainerPolicy"

// GetContainerPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerPolicy for more information on using the GetContainerPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerPolicyRequest method.
//    req, resp := client.GetContainerPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy
func (c *MediaStore) GetContainerPolicyRequest(input *GetContainerPolicyInput) (req *request.Request, output *GetContainerPolicyOutput) {
	op := &request.Operation{
		Name:       opGetContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerPolicyInput{}
	}

	output = &GetContainerPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerPolicy API operation for AWS Elemental MediaStore.
//
// Retrieves the access policy for the specified container. For information
// about the data that is included in an access policy, see the AWS Identity
// and Access Management User Guide (https://aws.amazon.com/documentation/iam/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation GetContainerPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * PolicyNotFoundException
//   The policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy
func (c *MediaStore) GetContainerPolicy(input *GetContainerPolicyInput) (*GetContainerPolicyOutput, error) {
	req, out := c.GetContainerPolicyRequest(input)
	return out, req.Send()
}

// GetContainerPolicyWithContext is the same as GetContainerPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) GetContainerPolicyWithContext(ctx aws.Context, input *GetContainerPolicyInput, opts ...request.Option) (*GetContainerPolicyOutput, error) {
	req, out := c.GetContainerPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCorsPolicy = "GetCorsPolicy"

// GetCorsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetCorsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCorsPolicy for more information on using the GetCorsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCorsPolicyRequest method.
//    req, resp := client.GetCorsPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetCorsPolicy
func (c *MediaStore) GetCorsPolicyRequest(input *GetCorsPolicyInput) (req *request.Request, output *GetCorsPolicyOutput) {
	op := &request.Operation{
		Name:       opGetCorsPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCorsPolicyInput{}
	}

	output = &GetCorsPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCorsPolicy API operation for AWS Elemental MediaStore.
//
// Returns the cross-origin resource sharing (CORS) configuration information
// that is set for the container.
//
// To use this operation, you must have permission to perform the MediaStore:GetCorsPolicy
// action. By default, the container owner has this permission and can grant
// it to others.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation GetCorsPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * CorsPolicyNotFoundException
//   The CORS policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetCorsPolicy
func (c *MediaStore) GetCorsPolicy(input *GetCorsPolicyInput) (*GetCorsPolicyOutput, error) {
	req, out := c.GetCorsPolicyRequest(input)
	return out, req.Send()
}

// GetCorsPolicyWithContext is the same as GetCorsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetCorsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) GetCorsPolicyWithContext(ctx aws.Context, input *GetCorsPolicyInput, opts ...request.Option) (*GetCorsPolicyOutput, error) {
	req, out := c.GetCorsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLifecyclePolicy = "GetLifecyclePolicy"

// GetLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLifecyclePolicy for more information on using the GetLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLifecyclePolicyRequest method.
//    req, resp := client.GetLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetLifecyclePolicy
func (c *MediaStore) GetLifecyclePolicyRequest(input *GetLifecyclePolicyInput) (req *request.Request, output *GetLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opGetLifecyclePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLifecyclePolicyInput{}
	}

	output = &GetLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLifecyclePolicy API operation for AWS Elemental MediaStore.
//
// Retrieves the object lifecycle policy that is assigned to a container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation GetLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * PolicyNotFoundException
//   The policy that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetLifecyclePolicy
func (c *MediaStore) GetLifecyclePolicy(input *GetLifecyclePolicyInput) (*GetLifecyclePolicyOutput, error) {
	req, out := c.GetLifecyclePolicyRequest(input)
	return out, req.Send()
}

// GetLifecyclePolicyWithContext is the same as GetLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) GetLifecyclePolicyWithContext(ctx aws.Context, input *GetLifecyclePolicyInput, opts ...request.Option) (*GetLifecyclePolicyOutput, error) {
	req, out := c.GetLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricPolicy = "GetMetricPolicy"

// GetMetricPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricPolicy for more information on using the GetMetricPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMetricPolicyRequest method.
//    req, resp := client.GetMetricPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetMetricPolicy
func (c *MediaStore) GetMetricPolicyRequest(input *GetMetricPolicyInput) (req *request.Request, output *GetMetricPolicyOutput) {
	op := &request.Operation{
		Name:       opGetMetricPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricPolicyInput{}
	}

	output = &GetMetricPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricPolicy API operation for AWS Elemental MediaStore.
//
// Returns the metric policy for the specified container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation GetMetricPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * PolicyNotFoundException
//   The policy that you specified in the request does not exist.
//
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetMetricPolicy
func (c *MediaStore) GetMetricPolicy(input *GetMetricPolicyInput) (*GetMetricPolicyOutput, error) {
	req, out := c.GetMetricPolicyRequest(input)
	return out, req.Send()
}

// GetMetricPolicyWithContext is the same as GetMetricPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) GetMetricPolicyWithContext(ctx aws.Context, input *GetMetricPolicyInput, opts ...request.Option) (*GetMetricPolicyOutput, error) {
	req, out := c.GetMetricPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListContainers = "ListContainers"

// ListContainersRequest generates a "aws/request.Request" representing the
// client's request for the ListContainers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContainers for more information on using the ListContainers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContainersRequest method.
//    req, resp := client.ListContainersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers
func (c *MediaStore) ListContainersRequest(input *ListContainersInput) (req *request.Request, output *ListContainersOutput) {
	op := &request.Operation{
		Name:       opListContainers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContainersInput{}
	}

	output = &ListContainersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContainers API operation for AWS Elemental MediaStore.
//
// Lists the properties of all containers in AWS Elemental MediaStore.
//
// You can query to receive all the containers in one response. Or you can include
// the MaxResults parameter to receive a limited number of containers in each
// response. In this case, the response includes a token. To get the next set
// of containers, send the command again, this time with the NextToken parameter
// (with the returned token as its value). The next set of responses appears,
// with a token if there are still more containers to receive.
//
// See also DescribeContainer, which gets the properties of one container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation ListContainers for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers
func (c *MediaStore) ListContainers(input *ListContainersInput) (*ListContainersOutput, error) {
	req, out := c.ListContainersRequest(input)
	return out, req.Send()
}

// ListContainersWithContext is the same as ListContainers with the addition of
// the ability to pass a context and additional request options.
//
// See ListContainers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) ListContainersWithContext(ctx aws.Context, input *ListContainersInput, opts ...request.Option) (*ListContainersOutput, error) {
	req, out := c.ListContainersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContainersPages iterates over the pages of a ListContainers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContainers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListContainers operation.
//    pageNum := 0
//    err := client.ListContainersPages(params,
//        func(page *mediastore.ListContainersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaStore) ListContainersPages(input *ListContainersInput, fn func(*ListContainersOutput, bool) bool) error {
	return c.ListContainersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContainersPagesWithContext same as ListContainersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) ListContainersPagesWithContext(ctx aws.Context, input *ListContainersInput, fn func(*ListContainersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContainersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContainersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContainersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListTagsForResource
func (c *MediaStore) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elemental MediaStore.
//
// Returns a list of the tags assigned to the specified container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListTagsForResource
func (c *MediaStore) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutContainerPolicy = "PutContainerPolicy"

// PutContainerPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutContainerPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutContainerPolicy for more information on using the PutContainerPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutContainerPolicyRequest method.
//    req, resp := client.PutContainerPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicy
func (c *MediaStore) PutContainerPolicyRequest(input *PutContainerPolicyInput) (req *request.Request, output *PutContainerPolicyOutput) {
	op := &request.Operation{
		Name:       opPutContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutContainerPolicyInput{}
	}

	output = &PutContainerPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutContainerPolicy API operation for AWS Elemental MediaStore.
//
// Creates an access policy for the specified container to restrict the users
// and clients that can access it. For information about the data that is included
// in an access policy, see the AWS Identity and Access Management User Guide
// (https://aws.amazon.com/documentation/iam/).
//
// For this release of the REST API, you can create only one policy for a container.
// If you enter PutContainerPolicy twice, the second command modifies the existing
// policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation PutContainerPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicy
func (c *MediaStore) PutContainerPolicy(input *PutContainerPolicyInput) (*PutContainerPolicyOutput, error) {
	req, out := c.PutContainerPolicyRequest(input)
	return out, req.Send()
}

// PutContainerPolicyWithContext is the same as PutContainerPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutContainerPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) PutContainerPolicyWithContext(ctx aws.Context, input *PutContainerPolicyInput, opts ...request.Option) (*PutContainerPolicyOutput, error) {
	req, out := c.PutContainerPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutCorsPolicy = "PutCorsPolicy"

// PutCorsPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutCorsPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutCorsPolicy for more information on using the PutCorsPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutCorsPolicyRequest method.
//    req, resp := client.PutCorsPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutCorsPolicy
func (c *MediaStore) PutCorsPolicyRequest(input *PutCorsPolicyInput) (req *request.Request, output *PutCorsPolicyOutput) {
	op := &request.Operation{
		Name:       opPutCorsPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutCorsPolicyInput{}
	}

	output = &PutCorsPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutCorsPolicy API operation for AWS Elemental MediaStore.
//
// Sets the cross-origin resource sharing (CORS) configuration on a container
// so that the container can service cross-origin requests. For example, you
// might want to enable a request whose origin is http://www.example.com to
// access your AWS Elemental MediaStore container at my.example.container.com
// by using the browser's XMLHttpRequest capability.
//
// To enable CORS on a container, you attach a CORS policy to the container.
// In the CORS policy, you configure rules that identify origins and the HTTP
// methods that can be executed on your container. The policy can contain up
// to 398,000 characters. You can add up to 100 rules to a CORS policy. If more
// than one rule applies, the service uses the first applicable rule listed.
//
// To learn more about CORS, see Cross-Origin Resource Sharing (CORS) in AWS
// Elemental MediaStore (https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation PutCorsPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutCorsPolicy
func (c *MediaStore) PutCorsPolicy(input *PutCorsPolicyInput) (*PutCorsPolicyOutput, error) {
	req, out := c.PutCorsPolicyRequest(input)
	return out, req.Send()
}

// PutCorsPolicyWithContext is the same as PutCorsPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutCorsPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) PutCorsPolicyWithContext(ctx aws.Context, input *PutCorsPolicyInput, opts ...request.Option) (*PutCorsPolicyOutput, error) {
	req, out := c.PutCorsPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLifecyclePolicy = "PutLifecyclePolicy"

// PutLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLifecyclePolicy for more information on using the PutLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLifecyclePolicyRequest method.
//    req, resp := client.PutLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicy
func (c *MediaStore) PutLifecyclePolicyRequest(input *PutLifecyclePolicyInput) (req *request.Request, output *PutLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opPutLifecyclePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLifecyclePolicyInput{}
	}

	output = &PutLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLifecyclePolicy API operation for AWS Elemental MediaStore.
//
// Writes an object lifecycle policy to a container. If the container already
// has an object lifecycle policy, the service replaces the existing policy
// with the new policy. It takes up to 20 minutes for the change to take effect.
//
// For information about how to construct an object lifecycle policy, see Components
// of an Object Lifecycle Policy (https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation PutLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicy
func (c *MediaStore) PutLifecyclePolicy(input *PutLifecyclePolicyInput) (*PutLifecyclePolicyOutput, error) {
	req, out := c.PutLifecyclePolicyRequest(input)
	return out, req.Send()
}

// PutLifecyclePolicyWithContext is the same as PutLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) PutLifecyclePolicyWithContext(ctx aws.Context, input *PutLifecyclePolicyInput, opts ...request.Option) (*PutLifecyclePolicyOutput, error) {
	req, out := c.PutLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricPolicy = "PutMetricPolicy"

// PutMetricPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetricPolicy for more information on using the PutMetricPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMetricPolicyRequest method.
//    req, resp := client.PutMetricPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutMetricPolicy
func (c *MediaStore) PutMetricPolicyRequest(input *PutMetricPolicyInput) (req *request.Request, output *PutMetricPolicyOutput) {
	op := &request.Operation{
		Name:       opPutMetricPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricPolicyInput{}
	}

	output = &PutMetricPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricPolicy API operation for AWS Elemental MediaStore.
//
// The metric policy that you want to add to the container. A metric policy
// allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It
// takes up to 20 minutes for the new policy to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation PutMetricPolicy for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutMetricPolicy
func (c *MediaStore) PutMetricPolicy(input *PutMetricPolicyInput) (*PutMetricPolicyOutput, error) {
	req, out := c.PutMetricPolicyRequest(input)
	return out, req.Send()
}

// PutMetricPolicyWithContext is the same as PutMetricPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) PutMetricPolicyWithContext(ctx aws.Context, input *PutMetricPolicyInput, opts ...request.Option) (*PutMetricPolicyOutput, error) {
	req, out := c.PutMetricPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAccessLogging = "StartAccessLogging"

// StartAccessLoggingRequest generates a "aws/request.Request" representing the
// client's request for the StartAccessLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAccessLogging for more information on using the StartAccessLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAccessLoggingRequest method.
//    req, resp := client.StartAccessLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StartAccessLogging
func (c *MediaStore) StartAccessLoggingRequest(input *StartAccessLoggingInput) (req *request.Request, output *StartAccessLoggingOutput) {
	op := &request.Operation{
		Name:       opStartAccessLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAccessLoggingInput{}
	}

	output = &StartAccessLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartAccessLogging API operation for AWS Elemental MediaStore.
//
// Starts access logging on the specified container. When you enable access
// logging on a container, MediaStore delivers access logs for objects stored
// in that container to Amazon CloudWatch Logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation StartAccessLogging for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StartAccessLogging
func (c *MediaStore) StartAccessLogging(input *StartAccessLoggingInput) (*StartAccessLoggingOutput, error) {
	req, out := c.StartAccessLoggingRequest(input)
	return out, req.Send()
}

// StartAccessLoggingWithContext is the same as StartAccessLogging with the addition of
// the ability to pass a context and additional request options.
//
// See StartAccessLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) StartAccessLoggingWithContext(ctx aws.Context, input *StartAccessLoggingInput, opts ...request.Option) (*StartAccessLoggingOutput, error) {
	req, out := c.StartAccessLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAccessLogging = "StopAccessLogging"

// StopAccessLoggingRequest generates a "aws/request.Request" representing the
// client's request for the StopAccessLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAccessLogging for more information on using the StopAccessLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopAccessLoggingRequest method.
//    req, resp := client.StopAccessLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StopAccessLogging
func (c *MediaStore) StopAccessLoggingRequest(input *StopAccessLoggingInput) (req *request.Request, output *StopAccessLoggingOutput) {
	op := &request.Operation{
		Name:       opStopAccessLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAccessLoggingInput{}
	}

	output = &StopAccessLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAccessLogging API operation for AWS Elemental MediaStore.
//
// Stops access logging on the specified container. When you stop access logging
// on a container, MediaStore stops sending access logs to Amazon CloudWatch
// Logs. These access logs are not saved and are not retrievable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation StopAccessLogging for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StopAccessLogging
func (c *MediaStore) StopAccessLogging(input *StopAccessLoggingInput) (*StopAccessLoggingOutput, error) {
	req, out := c.StopAccessLoggingRequest(input)
	return out, req.Send()
}

// StopAccessLoggingWithContext is the same as StopAccessLogging with the addition of
// the ability to pass a context and additional request options.
//
// See StopAccessLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) StopAccessLoggingWithContext(ctx aws.Context, input *StopAccessLoggingInput, opts ...request.Option) (*StopAccessLoggingOutput, error) {
	req, out := c.StopAccessLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/TagResource
func (c *MediaStore) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Elemental MediaStore.
//
// Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value
// pairs that you can associate with AWS resources. For example, the tag key
// might be "customer" and the tag value might be "companyA." You can specify
// one or more tags to add to each container. You can add up to 50 tags to each
// container. For more information about tagging, including naming and usage
// conventions, see Tagging Resources in MediaStore (https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/TagResource
func (c *MediaStore) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/UntagResource
func (c *MediaStore) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Elemental MediaStore.
//
// Removes tags from the specified container. You can specify one or more tags
// to remove.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ContainerInUseException
//   The container that you specified in the request already exists or is being
//   updated.
//
//   * ContainerNotFoundException
//   The container that you specified in the request does not exist.
//
//   * InternalServerError
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/UntagResource
func (c *MediaStore) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This section describes operations that you can perform on an AWS Elemental
// MediaStore container.
type Container struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container. The ARN has the following
	// format:
	//
	// arn:aws:<region>:<account that owns this container>:container/<name of container>
	//
	// For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
	ARN *string `min:"1" type:"string"`

	// The state of access logging on the container. This value is false by default,
	// indicating that AWS Elemental MediaStore does not send access logs to Amazon
	// CloudWatch Logs. When you enable access logging on the container, MediaStore
	// changes this value to true, indicating that the service delivers access logs
	// for objects stored in that container to CloudWatch Logs.
	AccessLoggingEnabled *bool `type:"boolean"`

	// Unix timestamp.
	CreationTime *time.Time `type:"timestamp"`

	// The DNS endpoint of the container. Use the endpoint to identify the specific
	// container when sending requests to the data plane. The service assigns this
	// value when the container is created. Once the value has been assigned, it
	// does not change.
	Endpoint *string `min:"1" type:"string"`

	// The name of the container.
	Name *string `min:"1" type:"string"`

	// The status of container creation or deletion. The status is one of the following:
	// CREATING, ACTIVE, or DELETING. While the service is creating the container,
	// the status is CREATING. When the endpoint is available, the status changes
	// to ACTIVE.
	Status *string `min:"1" type:"string" enum:"ContainerStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Container) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Container) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Container) SetARN(v string) *Container {
	s.ARN = &v
	return s
}

// SetAccessLoggingEnabled sets the AccessLoggingEnabled field's value.
func (s *Container) SetAccessLoggingEnabled(v bool) *Container {
	s.AccessLoggingEnabled = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Container) SetCreationTime(v time.Time) *Container {
	s.CreationTime = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Container) SetEndpoint(v string) *Container {
	s.Endpoint = &v
	return s
}

// SetName sets the Name field's value.
func (s *Container) SetName(v string) *Container {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Container) SetStatus(v string) *Container {
	s.Status = &v
	return s
}

// The container that you specified in the request already exists or is being
// updated.
type ContainerInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInUseException) GoString() string {
	return s.String()
}

func newErrorContainerInUseException(v protocol.ResponseMetadata) error {
	return &ContainerInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ContainerInUseException) Code() string {
	return "ContainerInUseException"
}

// Message returns the exception's message.
func (s *ContainerInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ContainerInUseException) OrigErr() error {
	return nil
}

func (s *ContainerInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ContainerInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ContainerInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The container that you specified in the request does not exist.
type ContainerNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerNotFoundException) GoString() string {
	return s.String()
}

func newErrorContainerNotFoundException(v protocol.ResponseMetadata) error {
	return &ContainerNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ContainerNotFoundException) Code() string {
	return "ContainerNotFoundException"
}

// Message returns the exception's message.
func (s *ContainerNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ContainerNotFoundException) OrigErr() error {
	return nil
}

func (s *ContainerNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ContainerNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ContainerNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The CORS policy that you specified in the request does not exist.
type CorsPolicyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CorsPolicyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CorsPolicyNotFoundException) GoString() string {
	return s.String()
}

func newErrorCorsPolicyNotFoundException(v protocol.ResponseMetadata) error {
	return &CorsPolicyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CorsPolicyNotFoundException) Code() string {
	return "CorsPolicyNotFoundException"
}

// Message returns the exception's message.
func (s *CorsPolicyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CorsPolicyNotFoundException) OrigErr() error {
	return nil
}

func (s *CorsPolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CorsPolicyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CorsPolicyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A rule for a CORS policy. You can add up to 100 rules to a CORS policy. If
// more than one rule applies, the service uses the first applicable rule listed.
type CorsRule struct {
	_ struct{} `type:"structure"`

	// Specifies which headers are allowed in a preflight OPTIONS request through
	// the Access-Control-Request-Headers header. Each header name that is specified
	// in Access-Control-Request-Headers must have a corresponding entry in the
	// rule. Only the headers that were requested are sent back.
	//
	// This element can contain only one wildcard character (*).
	//
	// AllowedHeaders is a required field
	AllowedHeaders []*string `type:"list" required:"true"`

	// Identifies an HTTP method that the origin that is specified in the rule is
	// allowed to execute.
	//
	// Each CORS rule must contain at least one AllowedMethods and one AllowedOrigins
	// element.
	AllowedMethods []*string `min:"1" type:"list"`

	// One or more response headers that you want users to be able to access from
	// their applications (for example, from a JavaScript XMLHttpRequest object).
	//
	// Each CORS rule must have at least one AllowedOrigins element. The string
	// value can include only one wildcard character (*), for example, http://*.example.com.
	// Additionally, you can specify only one wildcard character to allow cross-origin
	// access for all origins.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []*string `min:"1" type:"list" required:"true"`

	// One or more headers in the response that you want users to be able to access
	// from their applications (for example, from a JavaScript XMLHttpRequest object).
	//
	// This element is optional for each rule.
	ExposeHeaders []*string `type:"list"`

	// The time in seconds that your browser caches the preflight response for the
	// specified resource.
	//
	// A CORS rule can have only one MaxAgeSeconds element.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CorsRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CorsRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CorsRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CorsRule"}
	if s.AllowedHeaders == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedHeaders"))
	}
	if s.AllowedMethods != nil && len(s.AllowedMethods) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedMethods", 1))
	}
	if s.AllowedOrigins == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedOrigins"))
	}
	if s.AllowedOrigins != nil && len(s.AllowedOrigins) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedOrigins", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedHeaders sets the AllowedHeaders field's value.
func (s *CorsRule) SetAllowedHeaders(v []*string) *CorsRule {
	s.AllowedHeaders = v
	return s
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CorsRule) SetAllowedMethods(v []*string) *CorsRule {
	s.AllowedMethods = v
	return s
}

// SetAllowedOrigins sets the AllowedOrigins field's value.
func (s *CorsRule) SetAllowedOrigins(v []*string) *CorsRule {
	s.AllowedOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *CorsRule) SetExposeHeaders(v []*string) *CorsRule {
	s.ExposeHeaders = v
	return s
}

// SetMaxAgeSeconds sets the MaxAgeSeconds field's value.
func (s *CorsRule) SetMaxAgeSeconds(v int64) *CorsRule {
	s.MaxAgeSeconds = &v
	return s
}

type CreateContainerInput struct {
	_ struct{} `type:"structure"`

	// The name for the container. The name must be from 1 to 255 characters. Container
	// names must be unique to your AWS account within a specific region. As an
	// example, you could create a container named movies in every region, as long
	// as you don’t have an existing container with that name.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// An array of key:value pairs that you define. These values can be anything
	// that you want. Typically, the tag key represents a category (such as "environment")
	// and the tag value represents a specific value within that category (such
	// as "test," "development," or "production"). You can add up to 50 tags to
	// each container. For more information about tagging, including naming and
	// usage conventions, see Tagging Resources in MediaStore (https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html).
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContainerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContainerInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *CreateContainerInput) SetContainerName(v string) *CreateContainerInput {
	s.ContainerName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContainerInput) SetTags(v []*Tag) *CreateContainerInput {
	s.Tags = v
	return s
}

type CreateContainerOutput struct {
	_ struct{} `type:"structure"`

	// ContainerARN: The Amazon Resource Name (ARN) of the newly created container.
	// The ARN has the following format: arn:aws:<region>:<account that owns this
	// container>:container/<name of container>. For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
	//
	// ContainerName: The container name as specified in the request.
	//
	// CreationTime: Unix time stamp.
	//
	// Status: The status of container creation or deletion. The status is one of
	// the following: CREATING, ACTIVE, or DELETING. While the service is creating
	// the container, the status is CREATING. When an endpoint is available, the
	// status changes to ACTIVE.
	//
	// The return value does not include the container's endpoint. To make downstream
	// requests, you must obtain this value by using DescribeContainer or ListContainers.
	//
	// Container is a required field
	Container *Container `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerOutput) GoString() string {
	return s.String()
}

// SetContainer sets the Container field's value.
func (s *CreateContainerOutput) SetContainer(v *Container) *CreateContainerOutput {
	s.Container = v
	return s
}

type DeleteContainerInput struct {
	_ struct{} `type:"structure"`

	// The name of the container to delete.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteContainerInput) SetContainerName(v string) *DeleteContainerInput {
	s.ContainerName = &v
	return s
}

type DeleteContainerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerOutput) GoString() string {
	return s.String()
}

type DeleteContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that holds the policy.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteContainerPolicyInput) SetContainerName(v string) *DeleteContainerPolicyInput {
	s.ContainerName = &v
	return s
}

type DeleteContainerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerPolicyOutput) GoString() string {
	return s.String()
}

type DeleteCorsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container to remove the policy from.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCorsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCorsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCorsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCorsPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteCorsPolicyInput) SetContainerName(v string) *DeleteCorsPolicyInput {
	s.ContainerName = &v
	return s
}

type DeleteCorsPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCorsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCorsPolicyOutput) GoString() string {
	return s.String()
}

type DeleteLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that holds the object lifecycle policy.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLifecyclePolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteLifecyclePolicyInput) SetContainerName(v string) *DeleteLifecyclePolicyInput {
	s.ContainerName = &v
	return s
}

type DeleteLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyOutput) GoString() string {
	return s.String()
}

type DeleteMetricPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that is associated with the metric policy that
	// you want to delete.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMetricPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMetricPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteMetricPolicyInput) SetContainerName(v string) *DeleteMetricPolicyInput {
	s.ContainerName = &v
	return s
}

type DeleteMetricPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricPolicyOutput) GoString() string {
	return s.String()
}

type DescribeContainerInput struct {
	_ struct{} `type:"structure"`

	// The name of the container to query.
	ContainerName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContainerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContainerInput"}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DescribeContainerInput) SetContainerName(v string) *DescribeContainerInput {
	s.ContainerName = &v
	return s
}

type DescribeContainerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the queried container.
	Container *Container `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeContainerOutput) GoString() string {
	return s.String()
}

// SetContainer sets the Container field's value.
func (s *DescribeContainerOutput) SetContainer(v *Container) *DescribeContainerOutput {
	s.Container = v
	return s
}

type GetContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContainerPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContainerPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *GetContainerPolicyInput) SetContainerName(v string) *GetContainerPolicyInput {
	s.ContainerName = &v
	return s
}

type GetContainerPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the access policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetContainerPolicyOutput) SetPolicy(v string) *GetContainerPolicyOutput {
	s.Policy = &v
	return s
}

type GetCorsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that the policy is assigned to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCorsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCorsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCorsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCorsPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *GetCorsPolicyInput) SetContainerName(v string) *GetCorsPolicyInput {
	s.ContainerName = &v
	return s
}

type GetCorsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CORS policy assigned to the container.
	//
	// CorsPolicy is a required field
	CorsPolicy []*CorsRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCorsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCorsPolicyOutput) GoString() string {
	return s.String()
}

// SetCorsPolicy sets the CorsPolicy field's value.
func (s *GetCorsPolicyOutput) SetCorsPolicy(v []*CorsRule) *GetCorsPolicyOutput {
	s.CorsPolicy = v
	return s
}

type GetLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that the object lifecycle policy is assigned to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLifecyclePolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *GetLifecyclePolicyInput) SetContainerName(v string) *GetLifecyclePolicyInput {
	s.ContainerName = &v
	return s
}

type GetLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The object lifecycle policy that is assigned to the container.
	//
	// LifecyclePolicy is a required field
	LifecyclePolicy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyOutput) GoString() string {
	return s.String()
}

// SetLifecyclePolicy sets the LifecyclePolicy field's value.
func (s *GetLifecyclePolicyOutput) SetLifecyclePolicy(v string) *GetLifecyclePolicyOutput {
	s.LifecyclePolicy = &v
	return s
}

type GetMetricPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that is associated with the metric policy.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *GetMetricPolicyInput) SetContainerName(v string) *GetMetricPolicyInput {
	s.ContainerName = &v
	return s
}

type GetMetricPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The metric policy that is associated with the specific container.
	//
	// MetricPolicy is a required field
	MetricPolicy *MetricPolicy `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricPolicyOutput) GoString() string {
	return s.String()
}

// SetMetricPolicy sets the MetricPolicy field's value.
func (s *GetMetricPolicyOutput) SetMetricPolicy(v *MetricPolicy) *GetMetricPolicyOutput {
	s.MetricPolicy = v
	return s
}

// The service is temporarily unavailable.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// A service limit has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListContainersInput struct {
	_ struct{} `type:"structure"`

	// Enter the maximum number of containers in the response. Use from 1 to 255
	// characters.
	MaxResults *int64 `min:"1" type:"integer"`

	// Only if you used MaxResults in the first command, enter the token (which
	// was included in the previous response) to obtain the next set of containers.
	// This token is included in a response only if there actually are more containers
	// to list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContainersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContainersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContainersInput) SetMaxResults(v int64) *ListContainersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainersInput) SetNextToken(v string) *ListContainersInput {
	s.NextToken = &v
	return s
}

type ListContainersOutput struct {
	_ struct{} `type:"structure"`

	// The names of the containers.
	//
	// Containers is a required field
	Containers []*Container `type:"list" required:"true"`

	// NextToken is the token to use in the next call to ListContainers. This token
	// is returned only if you included the MaxResults tag in the original command,
	// and only if there are still containers to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainersOutput) GoString() string {
	return s.String()
}

// SetContainers sets the Containers field's value.
func (s *ListContainersOutput) SetContainers(v []*Container) *ListContainersOutput {
	s.Containers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainersOutput) SetNextToken(v string) *ListContainersOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the container.
	//
	// Resource is a required field
	Resource *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *ListTagsForResourceInput) SetResource(v string) *ListTagsForResourceInput {
	s.Resource = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key:value pairs that are assigned to the container.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The metric policy that is associated with the container. A metric policy
// allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In
// the policy, you must indicate whether you want MediaStore to send container-level
// metrics. You can also include rules to define groups of objects that you
// want MediaStore to send object-level metrics for.
//
// To view examples of how to construct a metric policy for your use case, see
// Example Metric Policies (https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html).
type MetricPolicy struct {
	_ struct{} `type:"structure"`

	// A setting to enable or disable metrics at the container level.
	//
	// ContainerLevelMetrics is a required field
	ContainerLevelMetrics *string `type:"string" required:"true" enum:"ContainerLevelMetrics"`

	// A parameter that holds an array of rules that enable metrics at the object
	// level. This parameter is optional, but if you choose to include it, you must
	// also include at least one rule. By default, you can include up to five rules.
	// You can also request a quota increase (https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas)
	// to allow up to 300 rules per policy.
	MetricPolicyRules []*MetricPolicyRule `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricPolicy"}
	if s.ContainerLevelMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerLevelMetrics"))
	}
	if s.MetricPolicyRules != nil && len(s.MetricPolicyRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricPolicyRules", 1))
	}
	if s.MetricPolicyRules != nil {
		for i, v := range s.MetricPolicyRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricPolicyRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerLevelMetrics sets the ContainerLevelMetrics field's value.
func (s *MetricPolicy) SetContainerLevelMetrics(v string) *MetricPolicy {
	s.ContainerLevelMetrics = &v
	return s
}

// SetMetricPolicyRules sets the MetricPolicyRules field's value.
func (s *MetricPolicy) SetMetricPolicyRules(v []*MetricPolicyRule) *MetricPolicy {
	s.MetricPolicyRules = v
	return s
}

// A setting that enables metrics at the object level. Each rule contains an
// object group and an object group name. If the policy includes the MetricPolicyRules
// parameter, you must include at least one rule. Each metric policy can include
// up to five rules by default. You can also request a quota increase (https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas)
// to allow up to 300 rules per policy.
type MetricPolicyRule struct {
	_ struct{} `type:"structure"`

	// A path or file name that defines which objects to include in the group. Wildcards
	// (*) are acceptable.
	//
	// ObjectGroup is a required field
	ObjectGroup *string `min:"1" type:"string" required:"true"`

	// A name that allows you to refer to the object group.
	//
	// ObjectGroupName is a required field
	ObjectGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricPolicyRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricPolicyRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricPolicyRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricPolicyRule"}
	if s.ObjectGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectGroup"))
	}
	if s.ObjectGroup != nil && len(*s.ObjectGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectGroup", 1))
	}
	if s.ObjectGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectGroupName"))
	}
	if s.ObjectGroupName != nil && len(*s.ObjectGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectGroup sets the ObjectGroup field's value.
func (s *MetricPolicyRule) SetObjectGroup(v string) *MetricPolicyRule {
	s.ObjectGroup = &v
	return s
}

// SetObjectGroupName sets the ObjectGroupName field's value.
func (s *MetricPolicyRule) SetObjectGroupName(v string) *MetricPolicyRule {
	s.ObjectGroupName = &v
	return s
}

// The policy that you specified in the request does not exist.
type PolicyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyNotFoundException) GoString() string {
	return s.String()
}

func newErrorPolicyNotFoundException(v protocol.ResponseMetadata) error {
	return &PolicyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyNotFoundException) Code() string {
	return "PolicyNotFoundException"
}

// Message returns the exception's message.
func (s *PolicyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyNotFoundException) OrigErr() error {
	return nil
}

func (s *PolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The contents of the policy, which includes the following:
	//
	//    * One Version tag
	//
	//    * One Statement tag that contains the standard tags for the policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutContainerPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutContainerPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *PutContainerPolicyInput) SetContainerName(v string) *PutContainerPolicyInput {
	s.ContainerName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutContainerPolicyInput) SetPolicy(v string) *PutContainerPolicyInput {
	s.Policy = &v
	return s
}

type PutContainerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerPolicyOutput) GoString() string {
	return s.String()
}

type PutCorsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to assign the CORS policy to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The CORS policy to apply to the container.
	//
	// CorsPolicy is a required field
	CorsPolicy []*CorsRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCorsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCorsPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutCorsPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutCorsPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}
	if s.CorsPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("CorsPolicy"))
	}
	if s.CorsPolicy != nil && len(s.CorsPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CorsPolicy", 1))
	}
	if s.CorsPolicy != nil {
		for i, v := range s.CorsPolicy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CorsPolicy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *PutCorsPolicyInput) SetContainerName(v string) *PutCorsPolicyInput {
	s.ContainerName = &v
	return s
}

// SetCorsPolicy sets the CorsPolicy field's value.
func (s *PutCorsPolicyInput) SetCorsPolicy(v []*CorsRule) *PutCorsPolicyInput {
	s.CorsPolicy = v
	return s
}

type PutCorsPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCorsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCorsPolicyOutput) GoString() string {
	return s.String()
}

type PutLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to assign the object lifecycle policy
	// to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The object lifecycle policy to apply to the container.
	//
	// LifecyclePolicy is a required field
	LifecyclePolicy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLifecyclePolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}
	if s.LifecyclePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecyclePolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *PutLifecyclePolicyInput) SetContainerName(v string) *PutLifecyclePolicyInput {
	s.ContainerName = &v
	return s
}

// SetLifecyclePolicy sets the LifecyclePolicy field's value.
func (s *PutLifecyclePolicyInput) SetLifecyclePolicy(v string) *PutLifecyclePolicyInput {
	s.LifecyclePolicy = &v
	return s
}

type PutLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecyclePolicyOutput) GoString() string {
	return s.String()
}

type PutMetricPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to add the metric policy to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The metric policy that you want to associate with the container. In the policy,
	// you must indicate whether you want MediaStore to send container-level metrics.
	// You can also include up to five rules to define groups of objects that you
	// want MediaStore to send object-level metrics for. If you include rules in
	// the policy, construct each rule with both of the following:
	//
	//    * An object group that defines which objects to include in the group.
	//    The definition can be a path or a file name, but it can't have more than
	//    900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), =
	//    (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash),
	//    and * (asterisk). Wildcards (*) are acceptable.
	//
	//    * An object group name that allows you to refer to the object group. The
	//    name can't have more than 30 characters. Valid characters are: a-z, A-Z,
	//    0-9, and _ (underscore).
	//
	// MetricPolicy is a required field
	MetricPolicy *MetricPolicy `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}
	if s.MetricPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricPolicy"))
	}
	if s.MetricPolicy != nil {
		if err := s.MetricPolicy.Validate(); err != nil {
			invalidParams.AddNested("MetricPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *PutMetricPolicyInput) SetContainerName(v string) *PutMetricPolicyInput {
	s.ContainerName = &v
	return s
}

// SetMetricPolicy sets the MetricPolicy field's value.
func (s *PutMetricPolicyInput) SetMetricPolicy(v *MetricPolicy) *PutMetricPolicyInput {
	s.MetricPolicy = v
	return s
}

type PutMetricPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricPolicyOutput) GoString() string {
	return s.String()
}

type StartAccessLoggingInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to start access logging on.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAccessLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAccessLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAccessLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAccessLoggingInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *StartAccessLoggingInput) SetContainerName(v string) *StartAccessLoggingInput {
	s.ContainerName = &v
	return s
}

type StartAccessLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAccessLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAccessLoggingOutput) GoString() string {
	return s.String()
}

type StopAccessLoggingInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to stop access logging on.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAccessLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAccessLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAccessLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopAccessLoggingInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *StopAccessLoggingInput) SetContainerName(v string) *StopAccessLoggingInput {
	s.ContainerName = &v
	return s
}

type StopAccessLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAccessLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAccessLoggingOutput) GoString() string {
	return s.String()
}

// A collection of tags associated with a container. Each tag consists of a
// key:value pair, which can be anything you define. Typically, the tag key
// represents a category (such as "environment") and the tag value represents
// a specific value within that category (such as "test," "development," or
// "production"). You can add up to 50 tags to each container. For more information
// about tagging, including naming and usage conventions, see Tagging Resources
// in MediaStore (https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the container.
	//
	// Resource is a required field
	Resource *string `min:"1" type:"string" required:"true"`

	// An array of key:value pairs that you want to add to the container. You need
	// to specify only the tags that you want to add or update. For example, suppose
	// a container already has two tags (customer:CompanyA and priority:High). You
	// want to change the priority tag and also add a third tag (type:Contract).
	// For TagResource, you specify the following tags: priority:Medium, type:Contract.
	// The result is that your container has three tags: customer:CompanyA, priority:Medium,
	// and type:Contract.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *TagResourceInput) SetResource(v string) *TagResourceInput {
	s.Resource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the container.
	//
	// Resource is a required field
	Resource *string `min:"1" type:"string" required:"true"`

	// A comma-separated list of keys for tags that you want to remove from the
	// container. For example, if your container has two tags (customer:CompanyA
	// and priority:High) and you want to remove one of the tags (priority:High),
	// you specify the key for the tag that you want to remove (priority).
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *UntagResourceInput) SetResource(v string) *UntagResourceInput {
	s.Resource = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// ContainerLevelMetricsEnabled is a ContainerLevelMetrics enum value
	ContainerLevelMetricsEnabled = "ENABLED"

	// ContainerLevelMetricsDisabled is a ContainerLevelMetrics enum value
	ContainerLevelMetricsDisabled = "DISABLED"
)

// ContainerLevelMetrics_Values returns all elements of the ContainerLevelMetrics enum
func ContainerLevelMetrics_Values() []string {
	return []string{
		ContainerLevelMetricsEnabled,
		ContainerLevelMetricsDisabled,
	}
}

const (
	// ContainerStatusActive is a ContainerStatus enum value
	ContainerStatusActive = "ACTIVE"

	// ContainerStatusCreating is a ContainerStatus enum value
	ContainerStatusCreating = "CREATING"

	// ContainerStatusDeleting is a ContainerStatus enum value
	ContainerStatusDeleting = "DELETING"
)

// ContainerStatus_Values returns all elements of the ContainerStatus enum
func ContainerStatus_Values() []string {
	return []string{
		ContainerStatusActive,
		ContainerStatusCreating,
		ContainerStatusDeleting,
	}
}

const (
	// MethodNamePut is a MethodName enum value
	MethodNamePut = "PUT"

	// MethodNameGet is a MethodName enum value
	MethodNameGet = "GET"

	// MethodNameDelete is a MethodName enum value
	MethodNameDelete = "DELETE"

	// MethodNameHead is a MethodName enum value
	MethodNameHead = "HEAD"
)

// MethodName_Values returns all elements of the MethodName enum
func MethodName_Values() []string {
	return []string{
		MethodNamePut,
		MethodNameGet,
		MethodNameDelete,
		MethodNameHead,
	}
}
