/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	submarineriov1 "github.com/submariner-io/submariner/pkg/apis/submariner.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeGlobalIngressIPs implements GlobalIngressIPInterface
type FakeGlobalIngressIPs struct {
	Fake *FakeSubmarinerV1
	ns   string
}

var globalingressipsResource = schema.GroupVersionResource{Group: "submariner.io", Version: "v1", Resource: "globalingressips"}

var globalingressipsKind = schema.GroupVersionKind{Group: "submariner.io", Version: "v1", Kind: "GlobalIngressIP"}

// Get takes name of the globalIngressIP, and returns the corresponding globalIngressIP object, and an error if there is any.
func (c *FakeGlobalIngressIPs) Get(ctx context.Context, name string, options v1.GetOptions) (result *submarineriov1.GlobalIngressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(globalingressipsResource, c.ns, name), &submarineriov1.GlobalIngressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.GlobalIngressIP), err
}

// List takes label and field selectors, and returns the list of GlobalIngressIPs that match those selectors.
func (c *FakeGlobalIngressIPs) List(ctx context.Context, opts v1.ListOptions) (result *submarineriov1.GlobalIngressIPList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(globalingressipsResource, globalingressipsKind, c.ns, opts), &submarineriov1.GlobalIngressIPList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &submarineriov1.GlobalIngressIPList{ListMeta: obj.(*submarineriov1.GlobalIngressIPList).ListMeta}
	for _, item := range obj.(*submarineriov1.GlobalIngressIPList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested globalIngressIPs.
func (c *FakeGlobalIngressIPs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(globalingressipsResource, c.ns, opts))

}

// Create takes the representation of a globalIngressIP and creates it.  Returns the server's representation of the globalIngressIP, and an error, if there is any.
func (c *FakeGlobalIngressIPs) Create(ctx context.Context, globalIngressIP *submarineriov1.GlobalIngressIP, opts v1.CreateOptions) (result *submarineriov1.GlobalIngressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(globalingressipsResource, c.ns, globalIngressIP), &submarineriov1.GlobalIngressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.GlobalIngressIP), err
}

// Update takes the representation of a globalIngressIP and updates it. Returns the server's representation of the globalIngressIP, and an error, if there is any.
func (c *FakeGlobalIngressIPs) Update(ctx context.Context, globalIngressIP *submarineriov1.GlobalIngressIP, opts v1.UpdateOptions) (result *submarineriov1.GlobalIngressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(globalingressipsResource, c.ns, globalIngressIP), &submarineriov1.GlobalIngressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.GlobalIngressIP), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeGlobalIngressIPs) UpdateStatus(ctx context.Context, globalIngressIP *submarineriov1.GlobalIngressIP, opts v1.UpdateOptions) (*submarineriov1.GlobalIngressIP, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(globalingressipsResource, "status", c.ns, globalIngressIP), &submarineriov1.GlobalIngressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.GlobalIngressIP), err
}

// Delete takes name of the globalIngressIP and deletes it. Returns an error if one occurs.
func (c *FakeGlobalIngressIPs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(globalingressipsResource, c.ns, name), &submarineriov1.GlobalIngressIP{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeGlobalIngressIPs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(globalingressipsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &submarineriov1.GlobalIngressIPList{})
	return err
}

// Patch applies the patch and returns the patched globalIngressIP.
func (c *FakeGlobalIngressIPs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *submarineriov1.GlobalIngressIP, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(globalingressipsResource, c.ns, name, pt, data, subresources...), &submarineriov1.GlobalIngressIP{})

	if obj == nil {
		return nil, err
	}
	return obj.(*submarineriov1.GlobalIngressIP), err
}
