package subscriptionapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/subscription/mgmt/2017-11-01-preview/subscription"
	"github.com/satori/go.uuid"
)

// DefinitionsOperationMetadataClientAPI contains the set of methods on the DefinitionsOperationMetadataClient type.
type DefinitionsOperationMetadataClientAPI interface {
	List(ctx context.Context) (result subscription.OperationListResultPage, err error)
}

var _ DefinitionsOperationMetadataClientAPI = (*subscription.DefinitionsOperationMetadataClient)(nil)

// DefinitionsClientAPI contains the set of methods on the DefinitionsClient type.
type DefinitionsClientAPI interface {
	Create(ctx context.Context, subscriptionDefinitionName string, body subscription.Definition) (result subscription.DefinitionsCreateFuture, err error)
	Get(ctx context.Context, subscriptionDefinitionName string) (result subscription.Definition, err error)
	GetOperationStatus(ctx context.Context, operationID uuid.UUID) (result subscription.Definition, err error)
	List(ctx context.Context) (result subscription.DefinitionListPage, err error)
}

var _ DefinitionsClientAPI = (*subscription.DefinitionsClient)(nil)
