// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/irm/v1alpha2/incidents.proto

package irm

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Describes whether the alerting condition is still firing.
type Signal_State int32

const (
	// Unspecified
	Signal_STATE_UNSPECIFIED Signal_State = 0
	// Firing
	Signal_STATE_OPEN Signal_State = 1
	// Non-firing
	Signal_STATE_CLOSED Signal_State = 2
)

var Signal_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "STATE_OPEN",
	2: "STATE_CLOSED",
}

var Signal_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"STATE_OPEN":        1,
	"STATE_CLOSED":      2,
}

func (x Signal_State) String() string {
	return proto.EnumName(Signal_State_name, int32(x))
}

func (Signal_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{1, 0}
}

// Specifies the escalation level of this incident, within the IRM protocol
// for handling incidents.
type Incident_EscalationLevel int32

const (
	// The incident has not been escalated. This is the value used by all new
	// and legacy incidents.
	Incident_ESCALATION_LEVEL_UNSPECIFIED Incident_EscalationLevel = 0
	// The incident has been escalated to the organizational level.
	Incident_ESCALATION_LEVEL_ORGANIZATION Incident_EscalationLevel = 1
)

var Incident_EscalationLevel_name = map[int32]string{
	0: "ESCALATION_LEVEL_UNSPECIFIED",
	1: "ESCALATION_LEVEL_ORGANIZATION",
}

var Incident_EscalationLevel_value = map[string]int32{
	"ESCALATION_LEVEL_UNSPECIFIED":  0,
	"ESCALATION_LEVEL_ORGANIZATION": 1,
}

func (x Incident_EscalationLevel) String() string {
	return proto.EnumName(Incident_EscalationLevel_name, int32(x))
}

func (Incident_EscalationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 0}
}

// Severity of an incident.
type Incident_Severity int32

const (
	// Severity is not specified.
	Incident_SEVERITY_UNSPECIFIED Incident_Severity = 0
	// Huge incident.
	Incident_SEVERITY_HUGE Incident_Severity = 1
	// Major incident.
	Incident_SEVERITY_MAJOR Incident_Severity = 2
	// Medium incident.
	Incident_SEVERITY_MEDIUM Incident_Severity = 3
	// Minor incident.
	Incident_SEVERITY_MINOR Incident_Severity = 4
	// Negligible incident.
	Incident_SEVERITY_NEGLIGIBLE Incident_Severity = 5
)

var Incident_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "SEVERITY_HUGE",
	2: "SEVERITY_MAJOR",
	3: "SEVERITY_MEDIUM",
	4: "SEVERITY_MINOR",
	5: "SEVERITY_NEGLIGIBLE",
}

var Incident_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"SEVERITY_HUGE":        1,
	"SEVERITY_MAJOR":       2,
	"SEVERITY_MEDIUM":      3,
	"SEVERITY_MINOR":       4,
	"SEVERITY_NEGLIGIBLE":  5,
}

func (x Incident_Severity) String() string {
	return proto.EnumName(Incident_Severity_name, int32(x))
}

func (Incident_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 1}
}

// Stage of an incident.
type Incident_Stage int32

const (
	// This is the default value if no stage has been specified.
	// Note: The caller of the API should set the stage to DETECTED.
	Incident_STAGE_UNSPECIFIED Incident_Stage = 0
	// The incident has been detected. This is the initial stage of a new
	// incident.
	// Note: The caller still has to set the stage manually.
	Incident_STAGE_DETECTED Incident_Stage = 4
	// This incident has been formally characterized.
	Incident_STAGE_TRIAGED Incident_Stage = 1
	// This incident has been mitigated, i.e. does not affect the service level
	// anymore.
	Incident_STAGE_MITIGATED Incident_Stage = 2
	// This incident has been fully resolved, i.e. there are no immediate
	// follow-up tasks.
	Incident_STAGE_RESOLVED Incident_Stage = 3
	// Postmortem for the incident was written.
	Incident_STAGE_DOCUMENTED Incident_Stage = 5
	// Stage for an incident with `duplicate_incident`. This incident is not
	// authoritative anymore and the `duplicate_incident` should be used to
	// determine the stage.
	Incident_STAGE_DUPLICATE Incident_Stage = 6
)

var Incident_Stage_name = map[int32]string{
	0: "STAGE_UNSPECIFIED",
	4: "STAGE_DETECTED",
	1: "STAGE_TRIAGED",
	2: "STAGE_MITIGATED",
	3: "STAGE_RESOLVED",
	5: "STAGE_DOCUMENTED",
	6: "STAGE_DUPLICATE",
}

var Incident_Stage_value = map[string]int32{
	"STAGE_UNSPECIFIED": 0,
	"STAGE_DETECTED":    4,
	"STAGE_TRIAGED":     1,
	"STAGE_MITIGATED":   2,
	"STAGE_RESOLVED":    3,
	"STAGE_DOCUMENTED":  5,
	"STAGE_DUPLICATE":   6,
}

func (x Incident_Stage) String() string {
	return proto.EnumName(Incident_Stage_name, int32(x))
}

func (Incident_Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 2}
}

// The type of channel/venue for incident communications.
type Incident_CommunicationVenue_ChannelType int32

const (
	// An unspecified communication channel.
	Incident_CommunicationVenue_CHANNEL_TYPE_UNSPECIFIED Incident_CommunicationVenue_ChannelType = 0
	// A communication channel that is represented by a generic URI.
	Incident_CommunicationVenue_CHANNEL_TYPE_URI Incident_CommunicationVenue_ChannelType = 1
	// A communication channel that represents a Slack channel.
	Incident_CommunicationVenue_CHANNEL_TYPE_SLACK Incident_CommunicationVenue_ChannelType = 5
)

var Incident_CommunicationVenue_ChannelType_name = map[int32]string{
	0: "CHANNEL_TYPE_UNSPECIFIED",
	1: "CHANNEL_TYPE_URI",
	5: "CHANNEL_TYPE_SLACK",
}

var Incident_CommunicationVenue_ChannelType_value = map[string]int32{
	"CHANNEL_TYPE_UNSPECIFIED": 0,
	"CHANNEL_TYPE_URI":         1,
	"CHANNEL_TYPE_SLACK":       5,
}

func (x Incident_CommunicationVenue_ChannelType) String() string {
	return proto.EnumName(Incident_CommunicationVenue_ChannelType_name, int32(x))
}

func (Incident_CommunicationVenue_ChannelType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 0, 0}
}

// List of possible roles.
type IncidentRole_Type int32

const (
	// The role is unspecified.
	IncidentRole_TYPE_UNSPECIFIED IncidentRole_Type = 0
	// Incident Commander: Manages response plan, near-term and long-term
	// objectives, establishes priorities, and delegates tasks as needed.
	IncidentRole_TYPE_INCIDENT_COMMANDER IncidentRole_Type = 1
	// Communications Lead: Keeps everybody outside and within the response team
	// informed.
	IncidentRole_TYPE_COMMUNICATIONS_LEAD IncidentRole_Type = 2
	// Operations Lead: Figures out what to do, and gets it done.
	IncidentRole_TYPE_OPERATIONS_LEAD IncidentRole_Type = 3
	// External Customer Communications Lead: Responsible for communicating
	// incident details to customers/public.
	IncidentRole_TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD IncidentRole_Type = 4
	// Primary Oncall: Responds to the initial page and handles all
	// responsibilities for pre-escalated incidents.
	IncidentRole_TYPE_PRIMARY_ONCALL IncidentRole_Type = 5
	// Secondary Oncall: Helps the primary oncall if necessary; mostly useful
	// for pre-escalated incidents.
	IncidentRole_TYPE_SECONDARY_ONCALL IncidentRole_Type = 6
	// User-specified roles. One example is a Planning Lead, who keeps track of
	// the incident. Another is an assistant Incident Commander.
	IncidentRole_TYPE_OTHER IncidentRole_Type = 7
)

var IncidentRole_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_INCIDENT_COMMANDER",
	2: "TYPE_COMMUNICATIONS_LEAD",
	3: "TYPE_OPERATIONS_LEAD",
	4: "TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD",
	5: "TYPE_PRIMARY_ONCALL",
	6: "TYPE_SECONDARY_ONCALL",
	7: "TYPE_OTHER",
}

var IncidentRole_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":                           0,
	"TYPE_INCIDENT_COMMANDER":                    1,
	"TYPE_COMMUNICATIONS_LEAD":                   2,
	"TYPE_OPERATIONS_LEAD":                       3,
	"TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD": 4,
	"TYPE_PRIMARY_ONCALL":                        5,
	"TYPE_SECONDARY_ONCALL":                      6,
	"TYPE_OTHER":                                 7,
}

func (x IncidentRole_Type) String() string {
	return proto.EnumName(IncidentRole_Type_name, int32(x))
}

func (IncidentRole_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{6, 0}
}

// Possible types of an artifact.
type Artifact_Type int32

const (
	// External type is unspecified.
	Artifact_TYPE_UNSPECIFIED Artifact_Type = 0
	// URL.
	Artifact_TYPE_URL Artifact_Type = 1
	// A JIRA issue.
	Artifact_TYPE_JIRA_ISSUE Artifact_Type = 4
)

var Artifact_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_URL",
	4: "TYPE_JIRA_ISSUE",
}

var Artifact_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"TYPE_URL":         1,
	"TYPE_JIRA_ISSUE":  4,
}

func (x Artifact_Type) String() string {
	return proto.EnumName(Artifact_Type_name, int32(x))
}

func (Artifact_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{8, 0}
}

// Types of changes that users can subscribe to in an incident.
type Subscription_EventType int32

const (
	// An event_type that's not specified is an error.
	Subscription_EVENT_TYPE_UNSPECIFIED Subscription_EventType = 0
	// The incident's title has changed.
	Subscription_EVENT_TYPE_TITLE_CHANGE Subscription_EventType = 1
	// The incident's synopsis has changed.
	Subscription_EVENT_TYPE_SYNOPSIS_CHANGE Subscription_EventType = 2
	// The incident's stage has changed.
	Subscription_EVENT_TYPE_STAGE_CHANGE Subscription_EventType = 3
	// The incident's severity has changed.
	Subscription_EVENT_TYPE_SEVERITY_CHANGE Subscription_EventType = 4
	// A new annotation has been added to the incident.
	Subscription_EVENT_TYPE_ANNOTATION_ADD Subscription_EventType = 5
	// An annotation has been modified.
	Subscription_EVENT_TYPE_ANNOTATION_CHANGE Subscription_EventType = 6
)

var Subscription_EventType_name = map[int32]string{
	0: "EVENT_TYPE_UNSPECIFIED",
	1: "EVENT_TYPE_TITLE_CHANGE",
	2: "EVENT_TYPE_SYNOPSIS_CHANGE",
	3: "EVENT_TYPE_STAGE_CHANGE",
	4: "EVENT_TYPE_SEVERITY_CHANGE",
	5: "EVENT_TYPE_ANNOTATION_ADD",
	6: "EVENT_TYPE_ANNOTATION_CHANGE",
}

var Subscription_EventType_value = map[string]int32{
	"EVENT_TYPE_UNSPECIFIED":       0,
	"EVENT_TYPE_TITLE_CHANGE":      1,
	"EVENT_TYPE_SYNOPSIS_CHANGE":   2,
	"EVENT_TYPE_STAGE_CHANGE":      3,
	"EVENT_TYPE_SEVERITY_CHANGE":   4,
	"EVENT_TYPE_ANNOTATION_ADD":    5,
	"EVENT_TYPE_ANNOTATION_CHANGE": 6,
}

func (x Subscription_EventType) String() string {
	return proto.EnumName(Subscription_EventType_name, int32(x))
}

func (Subscription_EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{10, 0}
}

// A user of the IRM app.
type User struct {
	// One of several ways to uniquely identify a user.
	//
	// Types that are valid to be assigned to User:
	//	*User_UserId
	//	*User_Email
	User                 isUser_User `protobuf_oneof:"user"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{0}
}

func (m *User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_User.Unmarshal(m, b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_User.Marshal(b, m, deterministic)
}
func (m *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(m, src)
}
func (m *User) XXX_Size() int {
	return xxx_messageInfo_User.Size(m)
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

type isUser_User interface {
	isUser_User()
}

type User_UserId struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3,oneof"`
}

type User_Email struct {
	Email string `protobuf:"bytes,2,opt,name=email,proto3,oneof"`
}

func (*User_UserId) isUser_User() {}

func (*User_Email) isUser_User() {}

func (m *User) GetUser() isUser_User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *User) GetUserId() string {
	if x, ok := m.GetUser().(*User_UserId); ok {
		return x.UserId
	}
	return ""
}

func (m *User) GetEmail() string {
	if x, ok := m.GetUser().(*User_Email); ok {
		return x.Email
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*User) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*User_UserId)(nil),
		(*User_Email)(nil),
	}
}

// A signal is a message calling attention to a (potential) incident. An example
// is a page based on a Stackdriver Alerting policy.
type Signal struct {
	// Resource name of the signal, for example,
	// "projects/{project_id}/signals/{signal_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Resource name of the incident this signal is currently assigned to.
	// May be empty if signal is unassigned.
	Incident string `protobuf:"bytes,3,opt,name=incident,proto3" json:"incident,omitempty"`
	// Output only. Time this signal was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time this signal was closed. This field is not populated
	// while the signal is still firing.
	CloseTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=close_time,json=closeTime,proto3" json:"close_time,omitempty"`
	// The time this Signal was first detected. This is identical to create_time
	// for Signals created by Stackdriver Alerting.
	DetectTime *timestamp.Timestamp `protobuf:"bytes,15,opt,name=detect_time,json=detectTime,proto3" json:"detect_time,omitempty"`
	// Output only. The user that created this signal for manually created
	// signals. Empty if this signal was generated by a system (for example,
	// Stackdriver Alerting).
	Creator *User `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// One-line summary of the signal.
	// Immutable.
	Title string `protobuf:"bytes,6,opt,name=title,proto3" json:"title,omitempty"`
	// Content type string. 'text/plain' is currently the only supported content
	// type for Signals created via the API. Signals created by Stackdriver
	// Alerting support 'text/html' as well. Immutable for Signals created by
	// Stackdriver Alerting.
	ContentType string `protobuf:"bytes,7,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Full message of the signal.
	// Immutable for Signals created by Stackdriver Alerting.
	Content string `protobuf:"bytes,8,opt,name=content,proto3" json:"content,omitempty"`
	// The state of this signal.
	// For Signals created by Stackdriver Alerting this field is output only.
	SignalState Signal_State `protobuf:"varint,9,opt,name=signal_state,json=signalState,proto3,enum=google.cloud.irm.v1alpha2.Signal_State" json:"signal_state,omitempty"`
	// A set of artifacts to additional resources for this Signal. For example, a
	// link to Stackdriver logging for the Signal.
	// Immutable for Signals created by Stackdriver Alerting.
	SignalArtifacts      []*Signal_SignalArtifact `protobuf:"bytes,16,rep,name=signal_artifacts,json=signalArtifacts,proto3" json:"signal_artifacts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Signal) Reset()         { *m = Signal{} }
func (m *Signal) String() string { return proto.CompactTextString(m) }
func (*Signal) ProtoMessage()    {}
func (*Signal) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{1}
}

func (m *Signal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Signal.Unmarshal(m, b)
}
func (m *Signal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Signal.Marshal(b, m, deterministic)
}
func (m *Signal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signal.Merge(m, src)
}
func (m *Signal) XXX_Size() int {
	return xxx_messageInfo_Signal.Size(m)
}
func (m *Signal) XXX_DiscardUnknown() {
	xxx_messageInfo_Signal.DiscardUnknown(m)
}

var xxx_messageInfo_Signal proto.InternalMessageInfo

func (m *Signal) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Signal) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Signal) GetIncident() string {
	if m != nil {
		return m.Incident
	}
	return ""
}

func (m *Signal) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Signal) GetCloseTime() *timestamp.Timestamp {
	if m != nil {
		return m.CloseTime
	}
	return nil
}

func (m *Signal) GetDetectTime() *timestamp.Timestamp {
	if m != nil {
		return m.DetectTime
	}
	return nil
}

func (m *Signal) GetCreator() *User {
	if m != nil {
		return m.Creator
	}
	return nil
}

func (m *Signal) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Signal) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Signal) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Signal) GetSignalState() Signal_State {
	if m != nil {
		return m.SignalState
	}
	return Signal_STATE_UNSPECIFIED
}

func (m *Signal) GetSignalArtifacts() []*Signal_SignalArtifact {
	if m != nil {
		return m.SignalArtifacts
	}
	return nil
}

// An artifact associated with the Signal.
type Signal_SignalArtifact struct {
	// The type of resource linked to
	//
	// Types that are valid to be assigned to ArtifactType:
	//	*Signal_SignalArtifact_UserType
	ArtifactType isSignal_SignalArtifact_ArtifactType `protobuf_oneof:"artifact_type"`
	// The URI for the artifact.
	Uri                  string   `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Signal_SignalArtifact) Reset()         { *m = Signal_SignalArtifact{} }
func (m *Signal_SignalArtifact) String() string { return proto.CompactTextString(m) }
func (*Signal_SignalArtifact) ProtoMessage()    {}
func (*Signal_SignalArtifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{1, 0}
}

func (m *Signal_SignalArtifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Signal_SignalArtifact.Unmarshal(m, b)
}
func (m *Signal_SignalArtifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Signal_SignalArtifact.Marshal(b, m, deterministic)
}
func (m *Signal_SignalArtifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signal_SignalArtifact.Merge(m, src)
}
func (m *Signal_SignalArtifact) XXX_Size() int {
	return xxx_messageInfo_Signal_SignalArtifact.Size(m)
}
func (m *Signal_SignalArtifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Signal_SignalArtifact.DiscardUnknown(m)
}

var xxx_messageInfo_Signal_SignalArtifact proto.InternalMessageInfo

type isSignal_SignalArtifact_ArtifactType interface {
	isSignal_SignalArtifact_ArtifactType()
}

type Signal_SignalArtifact_UserType struct {
	UserType string `protobuf:"bytes,2,opt,name=user_type,json=userType,proto3,oneof"`
}

func (*Signal_SignalArtifact_UserType) isSignal_SignalArtifact_ArtifactType() {}

func (m *Signal_SignalArtifact) GetArtifactType() isSignal_SignalArtifact_ArtifactType {
	if m != nil {
		return m.ArtifactType
	}
	return nil
}

func (m *Signal_SignalArtifact) GetUserType() string {
	if x, ok := m.GetArtifactType().(*Signal_SignalArtifact_UserType); ok {
		return x.UserType
	}
	return ""
}

func (m *Signal_SignalArtifact) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Signal_SignalArtifact) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Signal_SignalArtifact_UserType)(nil),
	}
}

// A text annotation by a user.
type Annotation struct {
	// Resource name of the annotation, for example,
	// "projects/{project_id}/incidents/{incident_id}/annotations/{annotation_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Author of the annotation.
	Author *User `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// Output only. Time the annotation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Content of the annotation. Immutable.
	Content string `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	// Content type of the annotation, for example, 'text/plain'
	// or 'text/markdown'. Immutable.
	ContentType          string   `protobuf:"bytes,5,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Annotation) Reset()         { *m = Annotation{} }
func (m *Annotation) String() string { return proto.CompactTextString(m) }
func (*Annotation) ProtoMessage()    {}
func (*Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{2}
}

func (m *Annotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Annotation.Unmarshal(m, b)
}
func (m *Annotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Annotation.Marshal(b, m, deterministic)
}
func (m *Annotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Annotation.Merge(m, src)
}
func (m *Annotation) XXX_Size() int {
	return xxx_messageInfo_Annotation.Size(m)
}
func (m *Annotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Annotation.DiscardUnknown(m)
}

var xxx_messageInfo_Annotation proto.InternalMessageInfo

func (m *Annotation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Annotation) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

func (m *Annotation) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Annotation) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Annotation) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

// A tag by a user.
type Tag struct {
	// Resource name of a tag, for example,
	// "projects/{project_id}/incidents/{incident_id}/tags/{tag_id}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name of the resource (for example, "cause:rollout"). Immutable.
	DisplayName          string   `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{3}
}

func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (m *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(m, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tag) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// Synopsis is a summary of an incident and it contains a textual content,
// an author and a last updated timestamp.
type Synopsis struct {
	// Content type string, for example, 'text/plain' or 'text/markdown'.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Textual content of the synopsis. It can be plain text or markdown as
	// indicated by the content_type.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Last updated timestamp.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Author of the synopsis.
	Author               *User    `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Synopsis) Reset()         { *m = Synopsis{} }
func (m *Synopsis) String() string { return proto.CompactTextString(m) }
func (*Synopsis) ProtoMessage()    {}
func (*Synopsis) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{4}
}

func (m *Synopsis) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Synopsis.Unmarshal(m, b)
}
func (m *Synopsis) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Synopsis.Marshal(b, m, deterministic)
}
func (m *Synopsis) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Synopsis.Merge(m, src)
}
func (m *Synopsis) XXX_Size() int {
	return xxx_messageInfo_Synopsis.Size(m)
}
func (m *Synopsis) XXX_DiscardUnknown() {
	xxx_messageInfo_Synopsis.DiscardUnknown(m)
}

var xxx_messageInfo_Synopsis proto.InternalMessageInfo

func (m *Synopsis) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Synopsis) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Synopsis) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Synopsis) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

// Representation of an incident.
type Incident struct {
	// Output only. Resource name of the incident, for example,
	// "projects/{project_id}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One-line summary of the incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Escalation level of the incident.
	EscalationLevel Incident_EscalationLevel `protobuf:"varint,3,opt,name=escalation_level,json=escalationLevel,proto3,enum=google.cloud.irm.v1alpha2.Incident_EscalationLevel" json:"escalation_level,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Severity of the incident.
	Severity Incident_Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=google.cloud.irm.v1alpha2.Incident_Severity" json:"severity,omitempty"`
	// Stage of the incident.
	Stage Incident_Stage `protobuf:"varint,6,opt,name=stage,proto3,enum=google.cloud.irm.v1alpha2.Incident_Stage" json:"stage,omitempty"`
	// Resource name of the incident this incident is a duplicate of. Empty if
	// this incident is not a duplicate.
	// An incident can only be a duplicate of an incident that is not marked as a
	// duplicate already. Setting this to a non-empty value must also set the
	// stage to `STAGE_DUPLICATE`. Unsetting this value value must also update
	// `stage` to a value other than `STAGE_DUPLICATE`.
	DuplicateIncident string `protobuf:"bytes,9,opt,name=duplicate_incident,json=duplicateIncident,proto3" json:"duplicate_incident,omitempty"`
	// Output only. Time this incident started. Used to measure the 'elapsed
	// time'. Start time of an incident is the earliest creation time of any of
	// its Signals or the create time of the incident if no Signals are assigned.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Synopsis of this incident.
	Synopsis *Synopsis `protobuf:"bytes,8,opt,name=synopsis,proto3" json:"synopsis,omitempty"`
	// Location of communications for this incident. This is informational
	// only; IRM does not use this to send messages.
	CommunicationVenue   *Incident_CommunicationVenue `protobuf:"bytes,10,opt,name=communication_venue,json=communicationVenue,proto3" json:"communication_venue,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Incident) Reset()         { *m = Incident{} }
func (m *Incident) String() string { return proto.CompactTextString(m) }
func (*Incident) ProtoMessage()    {}
func (*Incident) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5}
}

func (m *Incident) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Incident.Unmarshal(m, b)
}
func (m *Incident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Incident.Marshal(b, m, deterministic)
}
func (m *Incident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Incident.Merge(m, src)
}
func (m *Incident) XXX_Size() int {
	return xxx_messageInfo_Incident.Size(m)
}
func (m *Incident) XXX_DiscardUnknown() {
	xxx_messageInfo_Incident.DiscardUnknown(m)
}

var xxx_messageInfo_Incident proto.InternalMessageInfo

func (m *Incident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Incident) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Incident) GetEscalationLevel() Incident_EscalationLevel {
	if m != nil {
		return m.EscalationLevel
	}
	return Incident_ESCALATION_LEVEL_UNSPECIFIED
}

func (m *Incident) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Incident) GetSeverity() Incident_Severity {
	if m != nil {
		return m.Severity
	}
	return Incident_SEVERITY_UNSPECIFIED
}

func (m *Incident) GetStage() Incident_Stage {
	if m != nil {
		return m.Stage
	}
	return Incident_STAGE_UNSPECIFIED
}

func (m *Incident) GetDuplicateIncident() string {
	if m != nil {
		return m.DuplicateIncident
	}
	return ""
}

func (m *Incident) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Incident) GetSynopsis() *Synopsis {
	if m != nil {
		return m.Synopsis
	}
	return nil
}

func (m *Incident) GetCommunicationVenue() *Incident_CommunicationVenue {
	if m != nil {
		return m.CommunicationVenue
	}
	return nil
}

// CommunicationVenue is a record of where conversations about an incident
// are happening.
type Incident_CommunicationVenue struct {
	// A URI to the web interface of the channel.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// A name representing the channel in IRM UI.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of channel/venue for incident communications.
	ChannelType          Incident_CommunicationVenue_ChannelType `protobuf:"varint,3,opt,name=channel_type,json=channelType,proto3,enum=google.cloud.irm.v1alpha2.Incident_CommunicationVenue_ChannelType" json:"channel_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *Incident_CommunicationVenue) Reset()         { *m = Incident_CommunicationVenue{} }
func (m *Incident_CommunicationVenue) String() string { return proto.CompactTextString(m) }
func (*Incident_CommunicationVenue) ProtoMessage()    {}
func (*Incident_CommunicationVenue) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 0}
}

func (m *Incident_CommunicationVenue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Incident_CommunicationVenue.Unmarshal(m, b)
}
func (m *Incident_CommunicationVenue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Incident_CommunicationVenue.Marshal(b, m, deterministic)
}
func (m *Incident_CommunicationVenue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Incident_CommunicationVenue.Merge(m, src)
}
func (m *Incident_CommunicationVenue) XXX_Size() int {
	return xxx_messageInfo_Incident_CommunicationVenue.Size(m)
}
func (m *Incident_CommunicationVenue) XXX_DiscardUnknown() {
	xxx_messageInfo_Incident_CommunicationVenue.DiscardUnknown(m)
}

var xxx_messageInfo_Incident_CommunicationVenue proto.InternalMessageInfo

func (m *Incident_CommunicationVenue) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Incident_CommunicationVenue) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Incident_CommunicationVenue) GetChannelType() Incident_CommunicationVenue_ChannelType {
	if m != nil {
		return m.ChannelType
	}
	return Incident_CommunicationVenue_CHANNEL_TYPE_UNSPECIFIED
}

// Describes a role that can be assigned to an incident.
type IncidentRole struct {
	// The type of role. The role type is immutable in role assignments. Each role
	// type can only be used once per incident, except for TYPE_OTHER.
	Type IncidentRole_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.IncidentRole_Type" json:"type,omitempty"`
	// Output only unless TYPE_OTHER is used. Title of the role. For TYPE_OTHER,
	// must be unique within an incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only unless TYPE_OTHER is used. Description of the role.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncidentRole) Reset()         { *m = IncidentRole{} }
func (m *IncidentRole) String() string { return proto.CompactTextString(m) }
func (*IncidentRole) ProtoMessage()    {}
func (*IncidentRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{6}
}

func (m *IncidentRole) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncidentRole.Unmarshal(m, b)
}
func (m *IncidentRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncidentRole.Marshal(b, m, deterministic)
}
func (m *IncidentRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncidentRole.Merge(m, src)
}
func (m *IncidentRole) XXX_Size() int {
	return xxx_messageInfo_IncidentRole.Size(m)
}
func (m *IncidentRole) XXX_DiscardUnknown() {
	xxx_messageInfo_IncidentRole.DiscardUnknown(m)
}

var xxx_messageInfo_IncidentRole proto.InternalMessageInfo

func (m *IncidentRole) GetType() IncidentRole_Type {
	if m != nil {
		return m.Type
	}
	return IncidentRole_TYPE_UNSPECIFIED
}

func (m *IncidentRole) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *IncidentRole) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Stores the assignee of a role as well as the proposed next assignee.
type IncidentRoleAssignment struct {
	// Output only. Resource name such as
	// "projects/{project_id}/incidents/{incident_id}/role_assignments/{role_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The role that is or will be assigned.
	Role *IncidentRole `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	// The user this role is assigned to. This field can only be directly set
	// during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	Assignee *User `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// The recipient of a requested role handoff. This field can only be directly
	// set during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	//
	// `assignee` is always the current role-holder, and `proposed_assignee` is
	// used to track unfinished assignments and handoffs. Let's say Bob assigns
	// Alice to a role. Then the fields are:
	//   `assignee`: nil, `proposed_assignee`: Alice
	// If Alice accepts, then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If she cancels, then the RoleAssignment is deleted.
	// Let's say Alice has the role. Then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If Alice becomes incapacitated and Bob requests Carol to take over, then
	// the fields are:
	//   `assignee`: Alice, `proposed_assignee`: Carol
	// After Carol accepts the handover, the fields are:
	//   `assignee`: Carol, `proposed_assignee`: nil
	// Or if Carol refuses the handover, the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	ProposedAssignee     *User    `protobuf:"bytes,5,opt,name=proposed_assignee,json=proposedAssignee,proto3" json:"proposed_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncidentRoleAssignment) Reset()         { *m = IncidentRoleAssignment{} }
func (m *IncidentRoleAssignment) String() string { return proto.CompactTextString(m) }
func (*IncidentRoleAssignment) ProtoMessage()    {}
func (*IncidentRoleAssignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{7}
}

func (m *IncidentRoleAssignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncidentRoleAssignment.Unmarshal(m, b)
}
func (m *IncidentRoleAssignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncidentRoleAssignment.Marshal(b, m, deterministic)
}
func (m *IncidentRoleAssignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncidentRoleAssignment.Merge(m, src)
}
func (m *IncidentRoleAssignment) XXX_Size() int {
	return xxx_messageInfo_IncidentRoleAssignment.Size(m)
}
func (m *IncidentRoleAssignment) XXX_DiscardUnknown() {
	xxx_messageInfo_IncidentRoleAssignment.DiscardUnknown(m)
}

var xxx_messageInfo_IncidentRoleAssignment proto.InternalMessageInfo

func (m *IncidentRoleAssignment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IncidentRoleAssignment) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *IncidentRoleAssignment) GetRole() *IncidentRole {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *IncidentRoleAssignment) GetAssignee() *User {
	if m != nil {
		return m.Assignee
	}
	return nil
}

func (m *IncidentRoleAssignment) GetProposedAssignee() *User {
	if m != nil {
		return m.ProposedAssignee
	}
	return nil
}

// External artifact associated to an incident.
type Artifact struct {
	// Output only. Resource name such as
	// "projects/{project_id}/incidents/{incident_id}/artifacts/{artifact_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided name of an artifact.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// URL to access the artifact.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// Type of this artifact.
	Type                 Artifact_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.Artifact_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Artifact) Reset()         { *m = Artifact{} }
func (m *Artifact) String() string { return proto.CompactTextString(m) }
func (*Artifact) ProtoMessage()    {}
func (*Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{8}
}

func (m *Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifact.Unmarshal(m, b)
}
func (m *Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifact.Marshal(b, m, deterministic)
}
func (m *Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifact.Merge(m, src)
}
func (m *Artifact) XXX_Size() int {
	return xxx_messageInfo_Artifact.Size(m)
}
func (m *Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_Artifact proto.InternalMessageInfo

func (m *Artifact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Artifact) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Artifact) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Artifact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Artifact) GetType() Artifact_Type {
	if m != nil {
		return m.Type
	}
	return Artifact_TYPE_UNSPECIFIED
}

// Communication Channels are mechanisms used to receive notifications
// about changes to incidents.
type CommunicationChannel struct {
	// An endpoint describes how messages will be delivered.
	//
	// Types that are valid to be assigned to Endpoint:
	//	*CommunicationChannel_Email_
	//	*CommunicationChannel_NotificationChannel_
	Endpoint             isCommunicationChannel_Endpoint `protobuf_oneof:"endpoint"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *CommunicationChannel) Reset()         { *m = CommunicationChannel{} }
func (m *CommunicationChannel) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel) ProtoMessage()    {}
func (*CommunicationChannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{9}
}

func (m *CommunicationChannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel.Unmarshal(m, b)
}
func (m *CommunicationChannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel.Marshal(b, m, deterministic)
}
func (m *CommunicationChannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel.Merge(m, src)
}
func (m *CommunicationChannel) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel.Size(m)
}
func (m *CommunicationChannel) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel proto.InternalMessageInfo

type isCommunicationChannel_Endpoint interface {
	isCommunicationChannel_Endpoint()
}

type CommunicationChannel_Email_ struct {
	Email *CommunicationChannel_Email `protobuf:"bytes,1,opt,name=email,proto3,oneof"`
}

type CommunicationChannel_NotificationChannel_ struct {
	NotificationChannel *CommunicationChannel_NotificationChannel `protobuf:"bytes,2,opt,name=notification_channel,json=notificationChannel,proto3,oneof"`
}

func (*CommunicationChannel_Email_) isCommunicationChannel_Endpoint() {}

func (*CommunicationChannel_NotificationChannel_) isCommunicationChannel_Endpoint() {}

func (m *CommunicationChannel) GetEndpoint() isCommunicationChannel_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *CommunicationChannel) GetEmail() *CommunicationChannel_Email {
	if x, ok := m.GetEndpoint().(*CommunicationChannel_Email_); ok {
		return x.Email
	}
	return nil
}

func (m *CommunicationChannel) GetNotificationChannel() *CommunicationChannel_NotificationChannel {
	if x, ok := m.GetEndpoint().(*CommunicationChannel_NotificationChannel_); ok {
		return x.NotificationChannel
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CommunicationChannel) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CommunicationChannel_Email_)(nil),
		(*CommunicationChannel_NotificationChannel_)(nil),
	}
}

// A communication channel that delivers messages to an email address.
type CommunicationChannel_Email struct {
	// The email address, for example, "user@example.com".
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommunicationChannel_Email) Reset()         { *m = CommunicationChannel_Email{} }
func (m *CommunicationChannel_Email) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel_Email) ProtoMessage()    {}
func (*CommunicationChannel_Email) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{9, 0}
}

func (m *CommunicationChannel_Email) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel_Email.Unmarshal(m, b)
}
func (m *CommunicationChannel_Email) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel_Email.Marshal(b, m, deterministic)
}
func (m *CommunicationChannel_Email) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel_Email.Merge(m, src)
}
func (m *CommunicationChannel_Email) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel_Email.Size(m)
}
func (m *CommunicationChannel_Email) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel_Email.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel_Email proto.InternalMessageInfo

func (m *CommunicationChannel_Email) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// A communication channel that delivers messages to a Stackdriver
// notification channel.
type CommunicationChannel_NotificationChannel struct {
	// Stackdriver notification channel name.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommunicationChannel_NotificationChannel) Reset() {
	*m = CommunicationChannel_NotificationChannel{}
}
func (m *CommunicationChannel_NotificationChannel) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel_NotificationChannel) ProtoMessage()    {}
func (*CommunicationChannel_NotificationChannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{9, 1}
}

func (m *CommunicationChannel_NotificationChannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Unmarshal(m, b)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Marshal(b, m, deterministic)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel_NotificationChannel.Merge(m, src)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Size(m)
}
func (m *CommunicationChannel_NotificationChannel) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel_NotificationChannel.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel_NotificationChannel proto.InternalMessageInfo

func (m *CommunicationChannel_NotificationChannel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A subscription allows users to get notifications about changes to
// an incident.
type Subscription struct {
	// Output only. Resource name such as
	// "projects/{project_id}/incidents/{incident_id}/subscriptions/{subscription_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// A communications channel to send subscription messages to.
	SubscriptionChannel *CommunicationChannel `protobuf:"bytes,3,opt,name=subscription_channel,json=subscriptionChannel,proto3" json:"subscription_channel,omitempty"`
	// Types of events this subscription receives notifications for.
	EventTypes           []Subscription_EventType `protobuf:"varint,4,rep,packed,name=event_types,json=eventTypes,proto3,enum=google.cloud.irm.v1alpha2.Subscription_EventType" json:"event_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{10}
}

func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (m *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(m, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Subscription) GetSubscriptionChannel() *CommunicationChannel {
	if m != nil {
		return m.SubscriptionChannel
	}
	return nil
}

func (m *Subscription) GetEventTypes() []Subscription_EventType {
	if m != nil {
		return m.EventTypes
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Signal_State", Signal_State_name, Signal_State_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_EscalationLevel", Incident_EscalationLevel_name, Incident_EscalationLevel_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_Severity", Incident_Severity_name, Incident_Severity_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_Stage", Incident_Stage_name, Incident_Stage_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_CommunicationVenue_ChannelType", Incident_CommunicationVenue_ChannelType_name, Incident_CommunicationVenue_ChannelType_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.IncidentRole_Type", IncidentRole_Type_name, IncidentRole_Type_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Artifact_Type", Artifact_Type_name, Artifact_Type_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Subscription_EventType", Subscription_EventType_name, Subscription_EventType_value)
	proto.RegisterType((*User)(nil), "google.cloud.irm.v1alpha2.User")
	proto.RegisterType((*Signal)(nil), "google.cloud.irm.v1alpha2.Signal")
	proto.RegisterType((*Signal_SignalArtifact)(nil), "google.cloud.irm.v1alpha2.Signal.SignalArtifact")
	proto.RegisterType((*Annotation)(nil), "google.cloud.irm.v1alpha2.Annotation")
	proto.RegisterType((*Tag)(nil), "google.cloud.irm.v1alpha2.Tag")
	proto.RegisterType((*Synopsis)(nil), "google.cloud.irm.v1alpha2.Synopsis")
	proto.RegisterType((*Incident)(nil), "google.cloud.irm.v1alpha2.Incident")
	proto.RegisterType((*Incident_CommunicationVenue)(nil), "google.cloud.irm.v1alpha2.Incident.CommunicationVenue")
	proto.RegisterType((*IncidentRole)(nil), "google.cloud.irm.v1alpha2.IncidentRole")
	proto.RegisterType((*IncidentRoleAssignment)(nil), "google.cloud.irm.v1alpha2.IncidentRoleAssignment")
	proto.RegisterType((*Artifact)(nil), "google.cloud.irm.v1alpha2.Artifact")
	proto.RegisterType((*CommunicationChannel)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel")
	proto.RegisterType((*CommunicationChannel_Email)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel.Email")
	proto.RegisterType((*CommunicationChannel_NotificationChannel)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel.NotificationChannel")
	proto.RegisterType((*Subscription)(nil), "google.cloud.irm.v1alpha2.Subscription")
}

func init() {
	proto.RegisterFile("google/cloud/irm/v1alpha2/incidents.proto", fileDescriptor_7ed49c995593d5b8)
}

var fileDescriptor_7ed49c995593d5b8 = []byte{
	// 1638 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0x5f, 0x6f, 0xdb, 0xc8,
	0x11, 0x0f, 0xf5, 0xcf, 0xf2, 0xc8, 0x67, 0x33, 0x6b, 0x5f, 0x4e, 0x51, 0x93, 0x9e, 0xc3, 0x7b,
	0x38, 0xa7, 0x68, 0xa5, 0x9e, 0x0e, 0x6d, 0x71, 0x70, 0x80, 0x1c, 0x2d, 0x6d, 0x6d, 0xa6, 0x14,
	0x65, 0x2c, 0x29, 0xa3, 0xbe, 0x02, 0x25, 0x18, 0x6a, 0xa3, 0x10, 0xa0, 0x48, 0x82, 0xa4, 0x8c,
	0xfa, 0x1b, 0x14, 0x28, 0xfa, 0x01, 0xfa, 0x51, 0xfa, 0xd0, 0xaf, 0xd0, 0x97, 0x7b, 0xea, 0x6b,
	0x81, 0xf6, 0xb9, 0x8f, 0x7d, 0x3c, 0xec, 0x72, 0x49, 0x53, 0xb2, 0xa2, 0xc8, 0xf7, 0x64, 0xce,
	0x9f, 0xdf, 0xec, 0xec, 0xcc, 0xec, 0xcc, 0xc8, 0xf0, 0x72, 0x16, 0x86, 0x33, 0x9f, 0xf6, 0x5c,
	0x3f, 0x5c, 0x4c, 0x7b, 0x5e, 0x3c, 0xef, 0xdd, 0x7c, 0xe5, 0xf8, 0xd1, 0x7b, 0xa7, 0xdf, 0xf3,
	0x02, 0xd7, 0x9b, 0xd2, 0x20, 0x4d, 0xba, 0x51, 0x1c, 0xa6, 0x21, 0x7a, 0x9a, 0xa9, 0x76, 0xb9,
	0x6a, 0xd7, 0x8b, 0xe7, 0xdd, 0x5c, 0xb5, 0xf3, 0x4c, 0x58, 0x71, 0x22, 0xaf, 0xe7, 0x04, 0x41,
	0x98, 0x3a, 0xa9, 0x17, 0x06, 0x02, 0xd8, 0xf9, 0x5c, 0x48, 0x39, 0xf5, 0x76, 0xf1, 0xae, 0x97,
	0x7a, 0x73, 0x9a, 0xa4, 0xce, 0x3c, 0xca, 0x14, 0x14, 0x15, 0x6a, 0x93, 0x84, 0xc6, 0xe8, 0x29,
	0xec, 0x2c, 0x12, 0x1a, 0xdb, 0xde, 0xb4, 0x2d, 0x1d, 0x4b, 0x27, 0xbb, 0x17, 0x8f, 0x48, 0x83,
	0x31, 0xb4, 0x29, 0x7a, 0x02, 0x75, 0x3a, 0x77, 0x3c, 0xbf, 0x5d, 0x11, 0x82, 0x8c, 0x3c, 0x6b,
	0x40, 0x8d, 0x69, 0x28, 0xff, 0xac, 0x43, 0xc3, 0xf4, 0x66, 0x81, 0xe3, 0x23, 0x04, 0xb5, 0xc0,
	0x99, 0xd3, 0xcc, 0x04, 0xe1, 0xdf, 0x8c, 0x47, 0x53, 0x67, 0x96, 0xa1, 0x09, 0xff, 0x46, 0x1d,
	0x68, 0xe6, 0x57, 0x6c, 0x57, 0x39, 0xbf, 0xa0, 0xd1, 0x29, 0xb4, 0xdc, 0x98, 0x3a, 0x29, 0xb5,
	0x99, 0xaf, 0xed, 0xda, 0xb1, 0x74, 0xd2, 0xea, 0x77, 0xba, 0x22, 0x02, 0xf9, 0x45, 0xba, 0x56,
	0x7e, 0x11, 0x02, 0x99, 0x3a, 0x63, 0xa0, 0x6f, 0x00, 0x5c, 0x3f, 0x4c, 0x04, 0x16, 0x3e, 0x8a,
	0xdd, 0xe5, 0xda, 0x1c, 0x7a, 0x0a, 0xad, 0x29, 0x4d, 0xa9, 0x9b, 0x66, 0xd8, 0x83, 0x8f, 0x9f,
	0x9b, 0xa9, 0x8b, 0x73, 0x77, 0xb8, 0x17, 0x61, 0xdc, 0xae, 0x73, 0xe0, 0xe7, 0xdd, 0x0f, 0xa6,
	0xac, 0xcb, 0x02, 0x4e, 0x72, 0x7d, 0x74, 0x04, 0xf5, 0xd4, 0x4b, 0x7d, 0xda, 0x6e, 0xf0, 0x40,
	0x64, 0x04, 0x7a, 0x01, 0x7b, 0x6e, 0x18, 0xa4, 0x34, 0x48, 0xed, 0xf4, 0x36, 0xa2, 0xed, 0x1d,
	0x2e, 0x6c, 0x09, 0x9e, 0x75, 0x1b, 0x51, 0xd4, 0x86, 0x1d, 0x41, 0xb6, 0x9b, 0x5c, 0x9a, 0x93,
	0xe8, 0x0d, 0xec, 0x25, 0x3c, 0x21, 0x76, 0x92, 0x3a, 0x29, 0x6d, 0xef, 0x1e, 0x4b, 0x27, 0xfb,
	0xfd, 0x2f, 0x37, 0xb8, 0x94, 0xe5, 0xaf, 0x6b, 0x32, 0x75, 0xd2, 0xca, 0xc0, 0x9c, 0x40, 0x7f,
	0x00, 0x59, 0xd8, 0x72, 0xe2, 0xd4, 0x7b, 0xe7, 0xb8, 0x69, 0xd2, 0x96, 0x8f, 0xab, 0x27, 0xad,
	0xfe, 0x2f, 0xb7, 0xb0, 0xc7, 0xff, 0xa8, 0x02, 0x48, 0x0e, 0x92, 0x25, 0x3a, 0xe9, 0x10, 0xd8,
	0x5f, 0x56, 0x41, 0xcf, 0x61, 0x97, 0xd7, 0x21, 0xbf, 0x74, 0x5e, 0x70, 0x4d, 0xc6, 0xe2, 0x77,
	0x96, 0xa1, 0xba, 0x88, 0x3d, 0x51, 0x33, 0xec, 0xf3, 0xec, 0x00, 0x3e, 0xc9, 0x1d, 0xe3, 0x20,
	0xe5, 0x5b, 0xa8, 0x67, 0x9e, 0x7f, 0x0a, 0x8f, 0x4d, 0x4b, 0xb5, 0xb0, 0x3d, 0x31, 0xcc, 0x4b,
	0x3c, 0xd0, 0x7e, 0xab, 0xe1, 0xa1, 0xfc, 0x08, 0xed, 0x03, 0x64, 0xec, 0xf1, 0x25, 0x36, 0x64,
	0x09, 0xc9, 0xb0, 0x97, 0xd1, 0x03, 0x7d, 0x6c, 0xe2, 0xa1, 0x5c, 0x51, 0xbe, 0x97, 0x00, 0xd4,
	0xe2, 0x29, 0xad, 0x2d, 0xea, 0xdf, 0x40, 0xc3, 0x59, 0xa4, 0xef, 0xc3, 0x98, 0xfb, 0xb8, 0x45,
	0xba, 0x85, 0xfa, 0x6a, 0x75, 0x57, 0x1f, 0x54, 0xdd, 0xa5, 0x8c, 0xd7, 0x96, 0x33, 0xbe, 0x5a,
	0x2e, 0xf5, 0x7b, 0xe5, 0xa2, 0xbc, 0x82, 0xaa, 0xe5, 0xcc, 0xd6, 0xde, 0xe6, 0x05, 0xec, 0x4d,
	0xbd, 0x24, 0xf2, 0x9d, 0x5b, 0x9b, 0xcb, 0xb2, 0xa7, 0xda, 0x12, 0x3c, 0xc3, 0x99, 0x53, 0xe5,
	0x1f, 0x12, 0x34, 0xcd, 0xdb, 0x20, 0x8c, 0x12, 0x2f, 0xb9, 0x77, 0x9a, 0xb4, 0xb1, 0x38, 0x2b,
	0xcb, 0xae, 0x9e, 0x42, 0x6b, 0x11, 0x4d, 0x1f, 0x12, 0x81, 0x4c, 0x9d, 0x47, 0xe0, 0x2e, 0xee,
	0xb5, 0x07, 0xc5, 0x5d, 0xf9, 0xd7, 0x2e, 0x34, 0xb5, 0xbc, 0xc5, 0xac, 0x8b, 0x41, 0xf1, 0x0c,
	0x2b, 0xe5, 0x67, 0xf8, 0x47, 0x90, 0x69, 0xe2, 0x3a, 0x3e, 0xaf, 0x04, 0xdb, 0xa7, 0x37, 0xd4,
	0xe7, 0x1e, 0xef, 0xf7, 0xbf, 0xde, 0x70, 0x72, 0x7e, 0x50, 0x17, 0x17, 0x58, 0x9d, 0x41, 0xc9,
	0x01, 0x5d, 0x66, 0x14, 0xcd, 0xb1, 0x56, 0x6a, 0x8e, 0x17, 0xd0, 0x4c, 0xe8, 0x0d, 0x8d, 0xbd,
	0xf4, 0x96, 0xe7, 0x71, 0xbf, 0xff, 0xf3, 0x6d, 0xce, 0x32, 0x05, 0x86, 0x14, 0x68, 0xf4, 0x1a,
	0xea, 0x49, 0xea, 0xcc, 0xb2, 0xd6, 0xb2, 0xdf, 0x7f, 0xb9, 0x95, 0x19, 0x06, 0x20, 0x19, 0x0e,
	0xfd, 0x02, 0xd0, 0x74, 0x11, 0xf9, 0x9e, 0xcb, 0xd2, 0x55, 0x74, 0xec, 0x5d, 0xee, 0xec, 0xe3,
	0x42, 0x52, 0xc4, 0xf5, 0x1b, 0x80, 0x24, 0x75, 0x62, 0xd1, 0x41, 0x77, 0x3e, 0xde, 0x7d, 0xb9,
	0x36, 0x4f, 0xec, 0x6b, 0x68, 0x26, 0xa2, 0xbc, 0x78, 0x37, 0x6b, 0xf5, 0xbf, 0xd8, 0xd4, 0x5e,
	0x84, 0x2a, 0x29, 0x40, 0x68, 0x06, 0x87, 0x6e, 0x38, 0x9f, 0x2f, 0x02, 0xe6, 0x12, 0x4b, 0xd6,
	0x0d, 0x0d, 0x16, 0xf9, 0x08, 0xf8, 0xf5, 0x36, 0x37, 0x1f, 0x94, 0xe1, 0x57, 0x0c, 0x4d, 0x90,
	0x7b, 0x8f, 0xd7, 0xf9, 0x4b, 0x05, 0xd0, 0x7d, 0xd5, 0xbc, 0x33, 0x49, 0x45, 0x67, 0xda, 0xe2,
	0x55, 0x21, 0x0a, 0x7b, 0xee, 0x7b, 0x27, 0x08, 0xa8, 0x9f, 0x3d, 0xa4, 0xac, 0xb4, 0xce, 0x7e,
	0x9c, 0xb7, 0xdd, 0x41, 0x66, 0x8a, 0xbd, 0x3f, 0xd2, 0x72, 0xef, 0x08, 0xe5, 0x1a, 0x5a, 0x25,
	0x19, 0x7a, 0x06, 0xed, 0xc1, 0x85, 0x6a, 0x18, 0x58, 0xb7, 0xad, 0xeb, 0xcb, 0xd5, 0xfe, 0x78,
	0x04, 0xf2, 0xb2, 0x94, 0x68, 0xb2, 0x84, 0x9e, 0x00, 0x5a, 0xe2, 0x9a, 0xba, 0x3a, 0xf8, 0x9d,
	0x5c, 0x57, 0xae, 0xe0, 0x60, 0xa5, 0xc8, 0xd1, 0x31, 0x3c, 0xc3, 0xe6, 0x40, 0xd5, 0x55, 0x4b,
	0x1b, 0x1b, 0xb6, 0x8e, 0xaf, 0xb0, 0xbe, 0x72, 0xc4, 0x0b, 0x78, 0x7e, 0x4f, 0x63, 0x4c, 0xce,
	0x55, 0x43, 0xfb, 0x8e, 0xb3, 0x64, 0x49, 0xf9, 0x2b, 0xeb, 0x37, 0x79, 0x1d, 0xb7, 0xe1, 0xc8,
	0xc4, 0x57, 0x98, 0x68, 0xd6, 0xf5, 0x8a, 0xa5, 0xc7, 0xf0, 0x49, 0x21, 0xb9, 0x98, 0x9c, 0x63,
	0x59, 0x42, 0x08, 0xf6, 0x0b, 0xd6, 0x48, 0x7d, 0x33, 0x26, 0x72, 0x05, 0x1d, 0xc2, 0xc1, 0x1d,
	0x0f, 0x0f, 0xb5, 0xc9, 0x48, 0xae, 0x2e, 0x2b, 0x6a, 0xc6, 0x98, 0xc8, 0x35, 0xf4, 0x19, 0x1c,
	0x16, 0x3c, 0x03, 0x9f, 0xeb, 0xda, 0xb9, 0x76, 0xa6, 0x63, 0xb9, 0xae, 0xfc, 0x4d, 0xe2, 0x63,
	0x65, 0x96, 0x8f, 0x95, 0xf3, 0xd5, 0xb0, 0x31, 0x6b, 0x9c, 0x3d, 0xc4, 0x16, 0x1e, 0x58, 0x78,
	0x28, 0xd7, 0xb8, 0x77, 0x9c, 0x67, 0x11, 0x4d, 0x3d, 0xc7, 0x43, 0x59, 0xe2, 0x9e, 0x70, 0xd6,
	0x48, 0xb3, 0xb4, 0x73, 0x95, 0xe9, 0x55, 0xee, 0xb0, 0x04, 0x9b, 0x63, 0xfd, 0x0a, 0x0f, 0xe5,
	0x2a, 0x4b, 0x83, 0xb0, 0x37, 0x1e, 0x4c, 0x46, 0xd8, 0x60, 0x9a, 0xf5, 0x3b, 0xf8, 0x70, 0x72,
	0xa9, 0x6b, 0x03, 0xd5, 0xc2, 0x72, 0x43, 0xf9, 0x5f, 0x05, 0xf6, 0xf2, 0xba, 0x20, 0xa1, 0x4f,
	0xd1, 0xb7, 0x50, 0x2b, 0xfa, 0xf2, 0x76, 0xdd, 0x83, 0xc1, 0xba, 0xbc, 0x70, 0x38, 0xf2, 0x03,
	0xdd, 0xf0, 0x98, 0xad, 0x48, 0x89, 0x1b, 0x7b, 0x11, 0xcb, 0xb6, 0x98, 0xc2, 0x65, 0x96, 0xf2,
	0x1f, 0x09, 0x6a, 0x56, 0x66, 0x40, 0x5e, 0x53, 0x5b, 0x3f, 0x81, 0xcf, 0x38, 0x57, 0x33, 0x06,
	0xda, 0x10, 0x1b, 0x96, 0x3d, 0x18, 0x8f, 0x46, 0xaa, 0x31, 0xc4, 0x44, 0x96, 0x58, 0x59, 0x72,
	0x21, 0xe3, 0x4d, 0x0c, 0x76, 0x39, 0x6d, 0x6c, 0x98, 0xb6, 0x8e, 0x55, 0x16, 0xa3, 0x36, 0x1c,
	0x71, 0xe9, 0xf8, 0x12, 0x93, 0xb2, 0xa4, 0x8a, 0xba, 0xf0, 0x33, 0x2e, 0xc1, 0xbf, 0xb7, 0x30,
	0x31, 0x54, 0xdd, 0x1e, 0x4c, 0x4c, 0x6b, 0x3c, 0xc2, 0x64, 0xad, 0x25, 0x9e, 0x63, 0xae, 0x7f,
	0x49, 0xb4, 0x91, 0x4a, 0xae, 0xed, 0xb1, 0x31, 0x50, 0x75, 0x5d, 0xae, 0xa3, 0xa7, 0xf0, 0x69,
	0x56, 0xdb, 0x78, 0x30, 0x36, 0x86, 0x25, 0x51, 0x83, 0x2d, 0x0d, 0xd9, 0xe9, 0xd6, 0x05, 0x26,
	0xf2, 0x8e, 0xf2, 0xe7, 0x0a, 0x3c, 0x29, 0xc7, 0x4e, 0x4d, 0xd8, 0x6a, 0x33, 0xff, 0xd0, 0x70,
	0x59, 0xb7, 0x03, 0x9f, 0x42, 0x2d, 0x0e, 0xfd, 0x7c, 0x00, 0x7e, 0xb9, 0x65, 0x92, 0x08, 0x07,
	0xa1, 0x53, 0x68, 0x3a, 0xfc, 0x48, 0x4a, 0xb7, 0x9d, 0x84, 0x05, 0x00, 0xe9, 0xf0, 0x38, 0x8a,
	0xc3, 0x28, 0x4c, 0xe8, 0xd4, 0x2e, 0xac, 0x6c, 0xb9, 0xb6, 0xca, 0x39, 0x52, 0x15, 0x40, 0xe5,
	0xbf, 0x12, 0x34, 0x8b, 0xf5, 0xed, 0xc7, 0x6d, 0x17, 0x45, 0x7c, 0xaa, 0xa5, 0xf8, 0xf0, 0x86,
	0xea, 0x8b, 0xc9, 0xc8, 0x3e, 0xd1, 0x2b, 0x51, 0xd6, 0xd9, 0x50, 0x3c, 0xd9, 0xe0, 0x6a, 0xee,
	0x4f, 0xa9, 0xa4, 0x95, 0xd7, 0x1b, 0x2b, 0x73, 0x0f, 0x9a, 0xa2, 0xdb, 0xe9, 0xd9, 0x2b, 0xe5,
	0xd4, 0x1b, 0x8d, 0xa8, 0xb6, 0x66, 0x9a, 0x13, 0x2c, 0xd7, 0x94, 0xbf, 0x57, 0xe0, 0x68, 0xa9,
	0xeb, 0x8a, 0x9e, 0x8a, 0x46, 0xf9, 0x0f, 0x24, 0x89, 0xc7, 0xf0, 0x57, 0x1b, 0x1c, 0x5b, 0x87,
	0xef, 0x62, 0x06, 0x2e, 0x7e, 0x57, 0xa1, 0x3f, 0xc1, 0x51, 0x10, 0xa6, 0xde, 0xbb, 0x7c, 0x90,
	0x89, 0x4e, 0x2e, 0x36, 0xcd, 0xc1, 0x43, 0xad, 0x1b, 0x25, 0x5b, 0x82, 0x77, 0xf1, 0x88, 0x1c,
	0x06, 0xf7, 0xd9, 0x9d, 0x17, 0x50, 0xe7, 0xbe, 0xb0, 0xed, 0xcd, 0x99, 0x4e, 0x63, 0x9a, 0x24,
	0x22, 0x93, 0x39, 0xd9, 0x79, 0x09, 0x87, 0x6b, 0x0c, 0xae, 0xcb, 0xfb, 0x19, 0x40, 0x93, 0x06,
	0xd3, 0x28, 0xf4, 0x82, 0x54, 0xf9, 0xbe, 0x0a, 0x7b, 0xe6, 0xe2, 0x6d, 0xd1, 0x28, 0xb6, 0x7e,
	0x25, 0x6f, 0xe1, 0x28, 0x29, 0xe1, 0x8a, 0x60, 0x64, 0xaf, 0xa6, 0xf7, 0xc0, 0x60, 0x90, 0xc3,
	0xb2, 0xb1, 0xdc, 0x79, 0x02, 0x2d, 0x7a, 0x93, 0x2f, 0xb3, 0x49, 0xbb, 0x76, 0x5c, 0x3d, 0xd9,
	0xef, 0x7f, 0xb5, 0x69, 0xfd, 0x28, 0x19, 0xe9, 0xe2, 0x1b, 0xb1, 0xf3, 0x12, 0xa0, 0xf9, 0x67,
	0xa2, 0xfc, 0x5b, 0x82, 0xdd, 0x42, 0x82, 0x3a, 0xf0, 0x04, 0x5f, 0xb1, 0x7e, 0xb7, 0xbe, 0x27,
	0x96, 0x64, 0x96, 0x66, 0xe9, 0xd8, 0x66, 0xa3, 0x96, 0x0f, 0xb3, 0x9f, 0x42, 0xa7, 0x24, 0x34,
	0xaf, 0x8d, 0xf1, 0xa5, 0xa9, 0x99, 0xb9, 0xbc, 0xb2, 0x02, 0xce, 0x46, 0x83, 0x10, 0x56, 0x57,
	0xc1, 0xf9, 0x5c, 0x13, 0xf2, 0x1a, 0x7a, 0x0e, 0x4f, 0x4b, 0x72, 0xd5, 0x30, 0xc6, 0x56, 0x36,
	0x91, 0xd5, 0x21, 0x9b, 0x35, 0x6c, 0x8e, 0xaf, 0x15, 0x0b, 0x03, 0x8d, 0xb3, 0xf7, 0xf0, 0x85,
	0x1b, 0xce, 0xf3, 0x40, 0xb1, 0x10, 0x25, 0x34, 0xbe, 0xf1, 0x5c, 0x7a, 0x17, 0x2a, 0x27, 0xf2,
	0x2e, 0xa5, 0xef, 0x5e, 0x09, 0x95, 0x59, 0xe8, 0x3b, 0xc1, 0xac, 0x1b, 0xc6, 0xb3, 0xde, 0x8c,
	0x06, 0x7c, 0x23, 0xec, 0x65, 0x22, 0x27, 0xf2, 0x92, 0x35, 0xff, 0x09, 0x39, 0xf5, 0xe2, 0xf9,
	0xff, 0x25, 0xe9, 0x6d, 0x83, 0xeb, 0x7e, 0xfd, 0x43, 0x00, 0x00, 0x00, 0xff, 0xff, 0x62, 0xec,
	0xbb, 0x36, 0x34, 0x11, 0x00, 0x00,
}
