package dtl

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/devtestlabs/mgmt/2018-09-15/dtl"

// CostThresholdStatus enumerates the values for cost threshold status.
type CostThresholdStatus string

const (
	// Disabled ...
	Disabled CostThresholdStatus = "Disabled"
	// Enabled ...
	Enabled CostThresholdStatus = "Enabled"
)

// PossibleCostThresholdStatusValues returns an array of possible values for the CostThresholdStatus const type.
func PossibleCostThresholdStatusValues() []CostThresholdStatus {
	return []CostThresholdStatus{Disabled, Enabled}
}

// CostType enumerates the values for cost type.
type CostType string

const (
	// Projected ...
	Projected CostType = "Projected"
	// Reported ...
	Reported CostType = "Reported"
	// Unavailable ...
	Unavailable CostType = "Unavailable"
)

// PossibleCostTypeValues returns an array of possible values for the CostType const type.
func PossibleCostTypeValues() []CostType {
	return []CostType{Projected, Reported, Unavailable}
}

// CustomImageOsType enumerates the values for custom image os type.
type CustomImageOsType string

const (
	// Linux ...
	Linux CustomImageOsType = "Linux"
	// None ...
	None CustomImageOsType = "None"
	// Windows ...
	Windows CustomImageOsType = "Windows"
)

// PossibleCustomImageOsTypeValues returns an array of possible values for the CustomImageOsType const type.
func PossibleCustomImageOsTypeValues() []CustomImageOsType {
	return []CustomImageOsType{Linux, None, Windows}
}

// EnableStatus enumerates the values for enable status.
type EnableStatus string

const (
	// EnableStatusDisabled ...
	EnableStatusDisabled EnableStatus = "Disabled"
	// EnableStatusEnabled ...
	EnableStatusEnabled EnableStatus = "Enabled"
)

// PossibleEnableStatusValues returns an array of possible values for the EnableStatus const type.
func PossibleEnableStatusValues() []EnableStatus {
	return []EnableStatus{EnableStatusDisabled, EnableStatusEnabled}
}

// EnvironmentPermission enumerates the values for environment permission.
type EnvironmentPermission string

const (
	// Contributor ...
	Contributor EnvironmentPermission = "Contributor"
	// Reader ...
	Reader EnvironmentPermission = "Reader"
)

// PossibleEnvironmentPermissionValues returns an array of possible values for the EnvironmentPermission const type.
func PossibleEnvironmentPermissionValues() []EnvironmentPermission {
	return []EnvironmentPermission{Contributor, Reader}
}

// FileUploadOptions enumerates the values for file upload options.
type FileUploadOptions string

const (
	// FileUploadOptionsNone ...
	FileUploadOptionsNone FileUploadOptions = "None"
	// FileUploadOptionsUploadFilesAndGenerateSasTokens ...
	FileUploadOptionsUploadFilesAndGenerateSasTokens FileUploadOptions = "UploadFilesAndGenerateSasTokens"
)

// PossibleFileUploadOptionsValues returns an array of possible values for the FileUploadOptions const type.
func PossibleFileUploadOptionsValues() []FileUploadOptions {
	return []FileUploadOptions{FileUploadOptionsNone, FileUploadOptionsUploadFilesAndGenerateSasTokens}
}

// HostCachingOptions enumerates the values for host caching options.
type HostCachingOptions string

const (
	// HostCachingOptionsNone ...
	HostCachingOptionsNone HostCachingOptions = "None"
	// HostCachingOptionsReadOnly ...
	HostCachingOptionsReadOnly HostCachingOptions = "ReadOnly"
	// HostCachingOptionsReadWrite ...
	HostCachingOptionsReadWrite HostCachingOptions = "ReadWrite"
)

// PossibleHostCachingOptionsValues returns an array of possible values for the HostCachingOptions const type.
func PossibleHostCachingOptionsValues() []HostCachingOptions {
	return []HostCachingOptions{HostCachingOptionsNone, HostCachingOptionsReadOnly, HostCachingOptionsReadWrite}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// BadGateway ...
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest ...
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// ExpectationFailed ...
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden ...
	Forbidden HTTPStatusCode = "Forbidden"
	// GatewayTimeout ...
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone ...
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported ...
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError ...
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired ...
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed ...
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// MovedPermanently ...
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices ...
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent ...
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation ...
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable ...
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented ...
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified ...
	NotModified HTTPStatusCode = "NotModified"
	// OK ...
	OK HTTPStatusCode = "OK"
	// PartialContent ...
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired ...
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed ...
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired ...
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect ...
	Redirect HTTPStatusCode = "Redirect"
	// RequestedRangeNotSatisfiable ...
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge ...
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout ...
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong ...
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent ...
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther ...
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable ...
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols ...
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect ...
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized ...
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType ...
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused ...
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired ...
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy ...
	UseProxy HTTPStatusCode = "UseProxy"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, BadGateway, BadRequest, Conflict, Continue, Created, ExpectationFailed, Forbidden, GatewayTimeout, Gone, HTTPVersionNotSupported, InternalServerError, LengthRequired, MethodNotAllowed, MovedPermanently, MultipleChoices, NoContent, NonAuthoritativeInformation, NotAcceptable, NotFound, NotImplemented, NotModified, OK, PartialContent, PaymentRequired, PreconditionFailed, ProxyAuthenticationRequired, Redirect, RequestedRangeNotSatisfiable, RequestEntityTooLarge, RequestTimeout, RequestURITooLong, ResetContent, SeeOther, ServiceUnavailable, SwitchingProtocols, TemporaryRedirect, Unauthorized, UnsupportedMediaType, Unused, UpgradeRequired, UseProxy}
}

// LinuxOsState enumerates the values for linux os state.
type LinuxOsState string

const (
	// DeprovisionApplied ...
	DeprovisionApplied LinuxOsState = "DeprovisionApplied"
	// DeprovisionRequested ...
	DeprovisionRequested LinuxOsState = "DeprovisionRequested"
	// NonDeprovisioned ...
	NonDeprovisioned LinuxOsState = "NonDeprovisioned"
)

// PossibleLinuxOsStateValues returns an array of possible values for the LinuxOsState const type.
func PossibleLinuxOsStateValues() []LinuxOsState {
	return []LinuxOsState{DeprovisionApplied, DeprovisionRequested, NonDeprovisioned}
}

// NotificationChannelEventType enumerates the values for notification channel event type.
type NotificationChannelEventType string

const (
	// AutoShutdown ...
	AutoShutdown NotificationChannelEventType = "AutoShutdown"
	// Cost ...
	Cost NotificationChannelEventType = "Cost"
)

// PossibleNotificationChannelEventTypeValues returns an array of possible values for the NotificationChannelEventType const type.
func PossibleNotificationChannelEventTypeValues() []NotificationChannelEventType {
	return []NotificationChannelEventType{AutoShutdown, Cost}
}

// PolicyEvaluatorType enumerates the values for policy evaluator type.
type PolicyEvaluatorType string

const (
	// AllowedValuesPolicy ...
	AllowedValuesPolicy PolicyEvaluatorType = "AllowedValuesPolicy"
	// MaxValuePolicy ...
	MaxValuePolicy PolicyEvaluatorType = "MaxValuePolicy"
)

// PossiblePolicyEvaluatorTypeValues returns an array of possible values for the PolicyEvaluatorType const type.
func PossiblePolicyEvaluatorTypeValues() []PolicyEvaluatorType {
	return []PolicyEvaluatorType{AllowedValuesPolicy, MaxValuePolicy}
}

// PolicyFactName enumerates the values for policy fact name.
type PolicyFactName string

const (
	// PolicyFactNameEnvironmentTemplate ...
	PolicyFactNameEnvironmentTemplate PolicyFactName = "EnvironmentTemplate"
	// PolicyFactNameGalleryImage ...
	PolicyFactNameGalleryImage PolicyFactName = "GalleryImage"
	// PolicyFactNameLabPremiumVMCount ...
	PolicyFactNameLabPremiumVMCount PolicyFactName = "LabPremiumVmCount"
	// PolicyFactNameLabTargetCost ...
	PolicyFactNameLabTargetCost PolicyFactName = "LabTargetCost"
	// PolicyFactNameLabVMCount ...
	PolicyFactNameLabVMCount PolicyFactName = "LabVmCount"
	// PolicyFactNameLabVMSize ...
	PolicyFactNameLabVMSize PolicyFactName = "LabVmSize"
	// PolicyFactNameScheduleEditPermission ...
	PolicyFactNameScheduleEditPermission PolicyFactName = "ScheduleEditPermission"
	// PolicyFactNameUserOwnedLabPremiumVMCount ...
	PolicyFactNameUserOwnedLabPremiumVMCount PolicyFactName = "UserOwnedLabPremiumVmCount"
	// PolicyFactNameUserOwnedLabVMCount ...
	PolicyFactNameUserOwnedLabVMCount PolicyFactName = "UserOwnedLabVmCount"
	// PolicyFactNameUserOwnedLabVMCountInSubnet ...
	PolicyFactNameUserOwnedLabVMCountInSubnet PolicyFactName = "UserOwnedLabVmCountInSubnet"
)

// PossiblePolicyFactNameValues returns an array of possible values for the PolicyFactName const type.
func PossiblePolicyFactNameValues() []PolicyFactName {
	return []PolicyFactName{PolicyFactNameEnvironmentTemplate, PolicyFactNameGalleryImage, PolicyFactNameLabPremiumVMCount, PolicyFactNameLabTargetCost, PolicyFactNameLabVMCount, PolicyFactNameLabVMSize, PolicyFactNameScheduleEditPermission, PolicyFactNameUserOwnedLabPremiumVMCount, PolicyFactNameUserOwnedLabVMCount, PolicyFactNameUserOwnedLabVMCountInSubnet}
}

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled ...
	PolicyStatusDisabled PolicyStatus = "Disabled"
	// PolicyStatusEnabled ...
	PolicyStatusEnabled PolicyStatus = "Enabled"
)

// PossiblePolicyStatusValues returns an array of possible values for the PolicyStatus const type.
func PossiblePolicyStatusValues() []PolicyStatus {
	return []PolicyStatus{PolicyStatusDisabled, PolicyStatusEnabled}
}

// PremiumDataDisk enumerates the values for premium data disk.
type PremiumDataDisk string

const (
	// PremiumDataDiskDisabled ...
	PremiumDataDiskDisabled PremiumDataDisk = "Disabled"
	// PremiumDataDiskEnabled ...
	PremiumDataDiskEnabled PremiumDataDisk = "Enabled"
)

// PossiblePremiumDataDiskValues returns an array of possible values for the PremiumDataDisk const type.
func PossiblePremiumDataDiskValues() []PremiumDataDisk {
	return []PremiumDataDisk{PremiumDataDiskDisabled, PremiumDataDiskEnabled}
}

// ReportingCycleType enumerates the values for reporting cycle type.
type ReportingCycleType string

const (
	// CalendarMonth ...
	CalendarMonth ReportingCycleType = "CalendarMonth"
	// Custom ...
	Custom ReportingCycleType = "Custom"
)

// PossibleReportingCycleTypeValues returns an array of possible values for the ReportingCycleType const type.
func PossibleReportingCycleTypeValues() []ReportingCycleType {
	return []ReportingCycleType{CalendarMonth, Custom}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// GitHub ...
	GitHub SourceControlType = "GitHub"
	// VsoGit ...
	VsoGit SourceControlType = "VsoGit"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{GitHub, VsoGit}
}

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// Premium ...
	Premium StorageType = "Premium"
	// Standard ...
	Standard StorageType = "Standard"
	// StandardSSD ...
	StandardSSD StorageType = "StandardSSD"
)

// PossibleStorageTypeValues returns an array of possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{Premium, Standard, StandardSSD}
}

// TargetCostStatus enumerates the values for target cost status.
type TargetCostStatus string

const (
	// TargetCostStatusDisabled ...
	TargetCostStatusDisabled TargetCostStatus = "Disabled"
	// TargetCostStatusEnabled ...
	TargetCostStatusEnabled TargetCostStatus = "Enabled"
)

// PossibleTargetCostStatusValues returns an array of possible values for the TargetCostStatus const type.
func PossibleTargetCostStatusValues() []TargetCostStatus {
	return []TargetCostStatus{TargetCostStatusDisabled, TargetCostStatusEnabled}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TCP ...
	TCP TransportProtocol = "Tcp"
	// UDP ...
	UDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TCP, UDP}
}

// UsagePermissionType enumerates the values for usage permission type.
type UsagePermissionType string

const (
	// Allow ...
	Allow UsagePermissionType = "Allow"
	// Default ...
	Default UsagePermissionType = "Default"
	// Deny ...
	Deny UsagePermissionType = "Deny"
)

// PossibleUsagePermissionTypeValues returns an array of possible values for the UsagePermissionType const type.
func PossibleUsagePermissionTypeValues() []UsagePermissionType {
	return []UsagePermissionType{Allow, Default, Deny}
}

// VirtualMachineCreationSource enumerates the values for virtual machine creation source.
type VirtualMachineCreationSource string

const (
	// FromCustomImage ...
	FromCustomImage VirtualMachineCreationSource = "FromCustomImage"
	// FromGalleryImage ...
	FromGalleryImage VirtualMachineCreationSource = "FromGalleryImage"
	// FromSharedGalleryImage ...
	FromSharedGalleryImage VirtualMachineCreationSource = "FromSharedGalleryImage"
)

// PossibleVirtualMachineCreationSourceValues returns an array of possible values for the VirtualMachineCreationSource const type.
func PossibleVirtualMachineCreationSourceValues() []VirtualMachineCreationSource {
	return []VirtualMachineCreationSource{FromCustomImage, FromGalleryImage, FromSharedGalleryImage}
}

// WindowsOsState enumerates the values for windows os state.
type WindowsOsState string

const (
	// NonSysprepped ...
	NonSysprepped WindowsOsState = "NonSysprepped"
	// SysprepApplied ...
	SysprepApplied WindowsOsState = "SysprepApplied"
	// SysprepRequested ...
	SysprepRequested WindowsOsState = "SysprepRequested"
)

// PossibleWindowsOsStateValues returns an array of possible values for the WindowsOsState const type.
func PossibleWindowsOsStateValues() []WindowsOsState {
	return []WindowsOsState{NonSysprepped, SysprepApplied, SysprepRequested}
}

// ApplicableSchedule schedules applicable to a virtual machine. The schedules may have been defined on a
// VM or on lab level.
type ApplicableSchedule struct {
	autorest.Response `json:"-"`
	// ApplicableScheduleProperties - The properties of the resource.
	*ApplicableScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicableSchedule.
func (as ApplicableSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.ApplicableScheduleProperties != nil {
		objectMap["properties"] = as.ApplicableScheduleProperties
	}
	if as.Location != nil {
		objectMap["location"] = as.Location
	}
	if as.Tags != nil {
		objectMap["tags"] = as.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicableSchedule struct.
func (as *ApplicableSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicableScheduleProperties ApplicableScheduleProperties
				err = json.Unmarshal(*v, &applicableScheduleProperties)
				if err != nil {
					return err
				}
				as.ApplicableScheduleProperties = &applicableScheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				as.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				as.Tags = tags
			}
		}
	}

	return nil
}

// ApplicableScheduleFragment schedules applicable to a virtual machine. The schedules may have been
// defined on a VM or on lab level.
type ApplicableScheduleFragment struct {
	// ApplicableSchedulePropertiesFragment - The properties of the resource.
	*ApplicableSchedulePropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicableScheduleFragment.
func (asf ApplicableScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asf.ApplicableSchedulePropertiesFragment != nil {
		objectMap["properties"] = asf.ApplicableSchedulePropertiesFragment
	}
	if asf.Tags != nil {
		objectMap["tags"] = asf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicableScheduleFragment struct.
func (asf *ApplicableScheduleFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicableSchedulePropertiesFragment ApplicableSchedulePropertiesFragment
				err = json.Unmarshal(*v, &applicableSchedulePropertiesFragment)
				if err != nil {
					return err
				}
				asf.ApplicableSchedulePropertiesFragment = &applicableSchedulePropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asf.Tags = tags
			}
		}
	}

	return nil
}

// ApplicableScheduleProperties properties of a schedules applicable to a virtual machine.
type ApplicableScheduleProperties struct {
	// LabVmsShutdown - The auto-shutdown schedule, if one has been set at the lab or lab resource level.
	LabVmsShutdown *Schedule `json:"labVmsShutdown,omitempty"`
	// LabVmsStartup - The auto-startup schedule, if one has been set at the lab or lab resource level.
	LabVmsStartup *Schedule `json:"labVmsStartup,omitempty"`
}

// ApplicableSchedulePropertiesFragment properties of a schedules applicable to a virtual machine.
type ApplicableSchedulePropertiesFragment struct {
	// LabVmsShutdown - The auto-shutdown schedule, if one has been set at the lab or lab resource level.
	LabVmsShutdown *ScheduleFragment `json:"labVmsShutdown,omitempty"`
	// LabVmsStartup - The auto-startup schedule, if one has been set at the lab or lab resource level.
	LabVmsStartup *ScheduleFragment `json:"labVmsStartup,omitempty"`
}

// ApplyArtifactsRequest request body for applying artifacts to a virtual machine.
type ApplyArtifactsRequest struct {
	// Artifacts - The list of artifacts to apply.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
}

// ArmTemplate an Azure Resource Manager template.
type ArmTemplate struct {
	autorest.Response `json:"-"`
	// ArmTemplateProperties - The properties of the resource.
	*ArmTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArmTemplate.
func (at ArmTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if at.ArmTemplateProperties != nil {
		objectMap["properties"] = at.ArmTemplateProperties
	}
	if at.Location != nil {
		objectMap["location"] = at.Location
	}
	if at.Tags != nil {
		objectMap["tags"] = at.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArmTemplate struct.
func (at *ArmTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var armTemplateProperties ArmTemplateProperties
				err = json.Unmarshal(*v, &armTemplateProperties)
				if err != nil {
					return err
				}
				at.ArmTemplateProperties = &armTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				at.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				at.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				at.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				at.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				at.Tags = tags
			}
		}
	}

	return nil
}

// ArmTemplateInfo information about a generated ARM template.
type ArmTemplateInfo struct {
	autorest.Response `json:"-"`
	// Template - The template's contents.
	Template interface{} `json:"template,omitempty"`
	// Parameters - The parameters of the ARM template.
	Parameters interface{} `json:"parameters,omitempty"`
}

// ArmTemplateList the response of a list operation.
type ArmTemplateList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ArmTemplate `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ArmTemplateListIterator provides access to a complete listing of ArmTemplate values.
type ArmTemplateListIterator struct {
	i    int
	page ArmTemplateListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArmTemplateListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArmTemplateListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArmTemplateListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArmTemplateListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArmTemplateListIterator) Response() ArmTemplateList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArmTemplateListIterator) Value() ArmTemplate {
	if !iter.page.NotDone() {
		return ArmTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArmTemplateListIterator type.
func NewArmTemplateListIterator(page ArmTemplateListPage) ArmTemplateListIterator {
	return ArmTemplateListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (atl ArmTemplateList) IsEmpty() bool {
	return atl.Value == nil || len(*atl.Value) == 0
}

// armTemplateListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (atl ArmTemplateList) armTemplateListPreparer(ctx context.Context) (*http.Request, error) {
	if atl.NextLink == nil || len(to.String(atl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(atl.NextLink)))
}

// ArmTemplateListPage contains a page of ArmTemplate values.
type ArmTemplateListPage struct {
	fn  func(context.Context, ArmTemplateList) (ArmTemplateList, error)
	atl ArmTemplateList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArmTemplateListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArmTemplateListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.atl)
	if err != nil {
		return err
	}
	page.atl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArmTemplateListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArmTemplateListPage) NotDone() bool {
	return !page.atl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArmTemplateListPage) Response() ArmTemplateList {
	return page.atl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArmTemplateListPage) Values() []ArmTemplate {
	if page.atl.IsEmpty() {
		return nil
	}
	return *page.atl.Value
}

// Creates a new instance of the ArmTemplateListPage type.
func NewArmTemplateListPage(getNextPage func(context.Context, ArmTemplateList) (ArmTemplateList, error)) ArmTemplateListPage {
	return ArmTemplateListPage{fn: getNextPage}
}

// ArmTemplateParameterProperties properties of an Azure Resource Manager template parameter.
type ArmTemplateParameterProperties struct {
	// Name - The name of the template parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the template parameter.
	Value *string `json:"value,omitempty"`
}

// ArmTemplateParameterPropertiesFragment properties of an Azure Resource Manager template parameter.
type ArmTemplateParameterPropertiesFragment struct {
	// Name - The name of the template parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the template parameter.
	Value *string `json:"value,omitempty"`
}

// ArmTemplateProperties properties of an Azure Resource Manager template.
type ArmTemplateProperties struct {
	// DisplayName - READ-ONLY; The display name of the ARM template.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the ARM template.
	Description *string `json:"description,omitempty"`
	// Publisher - READ-ONLY; The publisher of the ARM template.
	Publisher *string `json:"publisher,omitempty"`
	// Icon - READ-ONLY; The URI to the icon of the ARM template.
	Icon *string `json:"icon,omitempty"`
	// Contents - READ-ONLY; The contents of the ARM template.
	Contents interface{} `json:"contents,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the armTemplate.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ParametersValueFilesInfo - READ-ONLY; File name and parameter values information from all azuredeploy.*.parameters.json for the ARM template.
	ParametersValueFilesInfo *[]ParametersValueFileInfo `json:"parametersValueFilesInfo,omitempty"`
	// Enabled - READ-ONLY; Whether or not ARM template is enabled for use by lab user.
	Enabled *bool `json:"enabled,omitempty"`
}

// Artifact an artifact.
type Artifact struct {
	autorest.Response `json:"-"`
	// ArtifactProperties - The properties of the resource.
	*ArtifactProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ArtifactProperties != nil {
		objectMap["properties"] = a.ArtifactProperties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Artifact struct.
func (a *Artifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactProperties ArtifactProperties
				err = json.Unmarshal(*v, &artifactProperties)
				if err != nil {
					return err
				}
				a.ArtifactProperties = &artifactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactDeploymentStatusProperties properties of an artifact deployment.
type ArtifactDeploymentStatusProperties struct {
	// DeploymentStatus - The deployment status of the artifact.
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	// ArtifactsApplied - The total count of the artifacts that were successfully applied.
	ArtifactsApplied *int32 `json:"artifactsApplied,omitempty"`
	// TotalArtifacts - The total count of the artifacts that were tentatively applied.
	TotalArtifacts *int32 `json:"totalArtifacts,omitempty"`
}

// ArtifactDeploymentStatusPropertiesFragment properties of an artifact deployment.
type ArtifactDeploymentStatusPropertiesFragment struct {
	// DeploymentStatus - The deployment status of the artifact.
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	// ArtifactsApplied - The total count of the artifacts that were successfully applied.
	ArtifactsApplied *int32 `json:"artifactsApplied,omitempty"`
	// TotalArtifacts - The total count of the artifacts that were tentatively applied.
	TotalArtifacts *int32 `json:"totalArtifacts,omitempty"`
}

// ArtifactInstallProperties properties of an artifact.
type ArtifactInstallProperties struct {
	// ArtifactID - The artifact's identifier.
	ArtifactID *string `json:"artifactId,omitempty"`
	// ArtifactTitle - The artifact's title.
	ArtifactTitle *string `json:"artifactTitle,omitempty"`
	// Parameters - The parameters of the artifact.
	Parameters *[]ArtifactParameterProperties `json:"parameters,omitempty"`
	// Status - The status of the artifact.
	Status *string `json:"status,omitempty"`
	// DeploymentStatusMessage - The status message from the deployment.
	DeploymentStatusMessage *string `json:"deploymentStatusMessage,omitempty"`
	// VMExtensionStatusMessage - The status message from the virtual machine extension.
	VMExtensionStatusMessage *string `json:"vmExtensionStatusMessage,omitempty"`
	// InstallTime - The time that the artifact starts to install on the virtual machine.
	InstallTime *date.Time `json:"installTime,omitempty"`
}

// ArtifactInstallPropertiesFragment properties of an artifact.
type ArtifactInstallPropertiesFragment struct {
	// ArtifactID - The artifact's identifier.
	ArtifactID *string `json:"artifactId,omitempty"`
	// ArtifactTitle - The artifact's title.
	ArtifactTitle *string `json:"artifactTitle,omitempty"`
	// Parameters - The parameters of the artifact.
	Parameters *[]ArtifactParameterPropertiesFragment `json:"parameters,omitempty"`
	// Status - The status of the artifact.
	Status *string `json:"status,omitempty"`
	// DeploymentStatusMessage - The status message from the deployment.
	DeploymentStatusMessage *string `json:"deploymentStatusMessage,omitempty"`
	// VMExtensionStatusMessage - The status message from the virtual machine extension.
	VMExtensionStatusMessage *string `json:"vmExtensionStatusMessage,omitempty"`
	// InstallTime - The time that the artifact starts to install on the virtual machine.
	InstallTime *date.Time `json:"installTime,omitempty"`
}

// ArtifactList the response of a list operation.
type ArtifactList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Artifact `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ArtifactListIterator provides access to a complete listing of Artifact values.
type ArtifactListIterator struct {
	i    int
	page ArtifactListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArtifactListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArtifactListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArtifactListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArtifactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArtifactListIterator) Response() ArtifactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArtifactListIterator) Value() Artifact {
	if !iter.page.NotDone() {
		return Artifact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArtifactListIterator type.
func NewArtifactListIterator(page ArtifactListPage) ArtifactListIterator {
	return ArtifactListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ArtifactList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// artifactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ArtifactList) artifactListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ArtifactListPage contains a page of Artifact values.
type ArtifactListPage struct {
	fn func(context.Context, ArtifactList) (ArtifactList, error)
	al ArtifactList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArtifactListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArtifactListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArtifactListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArtifactListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArtifactListPage) Response() ArtifactList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArtifactListPage) Values() []Artifact {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ArtifactListPage type.
func NewArtifactListPage(getNextPage func(context.Context, ArtifactList) (ArtifactList, error)) ArtifactListPage {
	return ArtifactListPage{fn: getNextPage}
}

// ArtifactParameterProperties properties of an artifact parameter.
type ArtifactParameterProperties struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ArtifactParameterPropertiesFragment properties of an artifact parameter.
type ArtifactParameterPropertiesFragment struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ArtifactProperties properties of an artifact.
type ArtifactProperties struct {
	// Title - READ-ONLY; The artifact's title.
	Title *string `json:"title,omitempty"`
	// Description - READ-ONLY; The artifact's description.
	Description *string `json:"description,omitempty"`
	// Publisher - READ-ONLY; The artifact's publisher.
	Publisher *string `json:"publisher,omitempty"`
	// FilePath - READ-ONLY; The file path to the artifact.
	FilePath *string `json:"filePath,omitempty"`
	// Icon - READ-ONLY; The URI to the artifact icon.
	Icon *string `json:"icon,omitempty"`
	// TargetOsType - READ-ONLY; The artifact's target OS.
	TargetOsType *string `json:"targetOsType,omitempty"`
	// Parameters - READ-ONLY; The artifact's parameters.
	Parameters interface{} `json:"parameters,omitempty"`
	// CreatedDate - READ-ONLY; The artifact's creation date.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
}

// ArtifactSource properties of an artifact source.
type ArtifactSource struct {
	autorest.Response `json:"-"`
	// ArtifactSourceProperties - The properties of the resource.
	*ArtifactSourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArtifactSource.
func (as ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.ArtifactSourceProperties != nil {
		objectMap["properties"] = as.ArtifactSourceProperties
	}
	if as.Location != nil {
		objectMap["location"] = as.Location
	}
	if as.Tags != nil {
		objectMap["tags"] = as.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArtifactSource struct.
func (as *ArtifactSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactSourceProperties ArtifactSourceProperties
				err = json.Unmarshal(*v, &artifactSourceProperties)
				if err != nil {
					return err
				}
				as.ArtifactSourceProperties = &artifactSourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				as.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				as.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactSourceFragment properties of an artifact source.
type ArtifactSourceFragment struct {
	// ArtifactSourcePropertiesFragment - The properties of the resource.
	*ArtifactSourcePropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArtifactSourceFragment.
func (asf ArtifactSourceFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asf.ArtifactSourcePropertiesFragment != nil {
		objectMap["properties"] = asf.ArtifactSourcePropertiesFragment
	}
	if asf.Tags != nil {
		objectMap["tags"] = asf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArtifactSourceFragment struct.
func (asf *ArtifactSourceFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactSourcePropertiesFragment ArtifactSourcePropertiesFragment
				err = json.Unmarshal(*v, &artifactSourcePropertiesFragment)
				if err != nil {
					return err
				}
				asf.ArtifactSourcePropertiesFragment = &artifactSourcePropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asf.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactSourceList the response of a list operation.
type ArtifactSourceList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ArtifactSource `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ArtifactSourceListIterator provides access to a complete listing of ArtifactSource values.
type ArtifactSourceListIterator struct {
	i    int
	page ArtifactSourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArtifactSourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArtifactSourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArtifactSourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArtifactSourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArtifactSourceListIterator) Response() ArtifactSourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArtifactSourceListIterator) Value() ArtifactSource {
	if !iter.page.NotDone() {
		return ArtifactSource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArtifactSourceListIterator type.
func NewArtifactSourceListIterator(page ArtifactSourceListPage) ArtifactSourceListIterator {
	return ArtifactSourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asl ArtifactSourceList) IsEmpty() bool {
	return asl.Value == nil || len(*asl.Value) == 0
}

// artifactSourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asl ArtifactSourceList) artifactSourceListPreparer(ctx context.Context) (*http.Request, error) {
	if asl.NextLink == nil || len(to.String(asl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asl.NextLink)))
}

// ArtifactSourceListPage contains a page of ArtifactSource values.
type ArtifactSourceListPage struct {
	fn  func(context.Context, ArtifactSourceList) (ArtifactSourceList, error)
	asl ArtifactSourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArtifactSourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArtifactSourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asl)
	if err != nil {
		return err
	}
	page.asl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArtifactSourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArtifactSourceListPage) NotDone() bool {
	return !page.asl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArtifactSourceListPage) Response() ArtifactSourceList {
	return page.asl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArtifactSourceListPage) Values() []ArtifactSource {
	if page.asl.IsEmpty() {
		return nil
	}
	return *page.asl.Value
}

// Creates a new instance of the ArtifactSourceListPage type.
func NewArtifactSourceListPage(getNextPage func(context.Context, ArtifactSourceList) (ArtifactSourceList, error)) ArtifactSourceListPage {
	return ArtifactSourceListPage{fn: getNextPage}
}

// ArtifactSourceProperties properties of an artifact source.
type ArtifactSourceProperties struct {
	// DisplayName - The artifact source's display name.
	DisplayName *string `json:"displayName,omitempty"`
	// URI - The artifact source's URI.
	URI *string `json:"uri,omitempty"`
	// SourceType - The artifact source's type. Possible values include: 'VsoGit', 'GitHub'
	SourceType SourceControlType `json:"sourceType,omitempty"`
	// FolderPath - The folder containing artifacts.
	FolderPath *string `json:"folderPath,omitempty"`
	// ArmTemplateFolderPath - The folder containing Azure Resource Manager templates.
	ArmTemplateFolderPath *string `json:"armTemplateFolderPath,omitempty"`
	// BranchRef - The artifact source's branch reference.
	BranchRef *string `json:"branchRef,omitempty"`
	// SecurityToken - The security token to authenticate to the artifact source.
	SecurityToken *string `json:"securityToken,omitempty"`
	// Status - Indicates if the artifact source is enabled (values: Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// CreatedDate - READ-ONLY; The artifact source's creation date.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// ArtifactSourcePropertiesFragment properties of an artifact source.
type ArtifactSourcePropertiesFragment struct {
	// DisplayName - The artifact source's display name.
	DisplayName *string `json:"displayName,omitempty"`
	// URI - The artifact source's URI.
	URI *string `json:"uri,omitempty"`
	// SourceType - The artifact source's type. Possible values include: 'VsoGit', 'GitHub'
	SourceType SourceControlType `json:"sourceType,omitempty"`
	// FolderPath - The folder containing artifacts.
	FolderPath *string `json:"folderPath,omitempty"`
	// ArmTemplateFolderPath - The folder containing Azure Resource Manager templates.
	ArmTemplateFolderPath *string `json:"armTemplateFolderPath,omitempty"`
	// BranchRef - The artifact source's branch reference.
	BranchRef *string `json:"branchRef,omitempty"`
	// SecurityToken - The security token to authenticate to the artifact source.
	SecurityToken *string `json:"securityToken,omitempty"`
	// Status - Indicates if the artifact source is enabled (values: Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
}

// AttachDiskProperties properties of the disk to attach.
type AttachDiskProperties struct {
	// LeasedByLabVMID - The resource ID of the Lab virtual machine to which the disk is attached.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// AttachNewDataDiskOptions properties to attach new disk to the Virtual Machine.
type AttachNewDataDiskOptions struct {
	// DiskSizeGiB - Size of the disk to be attached in GibiBytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
	// DiskName - The name of the disk to be attached.
	DiskName *string `json:"diskName,omitempty"`
	// DiskType - The storage type for the disk (i.e. Standard, Premium). Possible values include: 'Standard', 'Premium', 'StandardSSD'
	DiskType StorageType `json:"diskType,omitempty"`
}

// AttachNewDataDiskOptionsFragment properties to attach new disk to the Virtual Machine.
type AttachNewDataDiskOptionsFragment struct {
	// DiskSizeGiB - Size of the disk to be attached in GibiBytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
	// DiskName - The name of the disk to be attached.
	DiskName *string `json:"diskName,omitempty"`
	// DiskType - The storage type for the disk (i.e. Standard, Premium). Possible values include: 'Standard', 'Premium', 'StandardSSD'
	DiskType StorageType `json:"diskType,omitempty"`
}

// BulkCreationParameters parameters for creating multiple virtual machines as a single action.
type BulkCreationParameters struct {
	// InstanceCount - The number of virtual machine instances to create.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// BulkCreationParametersFragment parameters for creating multiple virtual machines as a single action.
type BulkCreationParametersFragment struct {
	// InstanceCount - The number of virtual machine instances to create.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// CloudError error from a REST request.
type CloudError struct {
	// Error - The cloud error that occurred
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody body of an error from a REST request.
type CloudErrorBody struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Target - The error target.
	Target *string `json:"target,omitempty"`
	// Details - Inner errors.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ComputeDataDisk a data disks attached to a virtual machine.
type ComputeDataDisk struct {
	// Name - Gets data disk name.
	Name *string `json:"name,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	// DiskSizeGiB - Gets data disk size in GiB.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
}

// ComputeDataDiskFragment a data disks attached to a virtual machine.
type ComputeDataDiskFragment struct {
	// Name - Gets data disk name.
	Name *string `json:"name,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	// DiskSizeGiB - Gets data disk size in GiB.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
}

// ComputeVMInstanceViewStatus status information about a virtual machine.
type ComputeVMInstanceViewStatus struct {
	// Code - Gets the status Code.
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Gets the short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - Gets the message associated with the status.
	Message *string `json:"message,omitempty"`
}

// ComputeVMInstanceViewStatusFragment status information about a virtual machine.
type ComputeVMInstanceViewStatusFragment struct {
	// Code - Gets the status Code.
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Gets the short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - Gets the message associated with the status.
	Message *string `json:"message,omitempty"`
}

// ComputeVMProperties properties of a virtual machine returned by the Microsoft.Compute API.
type ComputeVMProperties struct {
	// Statuses - Gets the statuses of the virtual machine.
	Statuses *[]ComputeVMInstanceViewStatus `json:"statuses,omitempty"`
	// OsType - Gets the OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// VMSize - Gets the size of the virtual machine.
	VMSize *string `json:"vmSize,omitempty"`
	// NetworkInterfaceID - Gets the network interface ID of the virtual machine.
	NetworkInterfaceID *string `json:"networkInterfaceId,omitempty"`
	// OsDiskID - Gets OS disk blob uri for the virtual machine.
	OsDiskID *string `json:"osDiskId,omitempty"`
	// DataDiskIds - Gets data disks blob uri for the virtual machine.
	DataDiskIds *[]string `json:"dataDiskIds,omitempty"`
	// DataDisks - Gets all data disks attached to the virtual machine.
	DataDisks *[]ComputeDataDisk `json:"dataDisks,omitempty"`
}

// ComputeVMPropertiesFragment properties of a virtual machine returned by the Microsoft.Compute API.
type ComputeVMPropertiesFragment struct {
	// Statuses - Gets the statuses of the virtual machine.
	Statuses *[]ComputeVMInstanceViewStatusFragment `json:"statuses,omitempty"`
	// OsType - Gets the OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// VMSize - Gets the size of the virtual machine.
	VMSize *string `json:"vmSize,omitempty"`
	// NetworkInterfaceID - Gets the network interface ID of the virtual machine.
	NetworkInterfaceID *string `json:"networkInterfaceId,omitempty"`
	// OsDiskID - Gets OS disk blob uri for the virtual machine.
	OsDiskID *string `json:"osDiskId,omitempty"`
	// DataDiskIds - Gets data disks blob uri for the virtual machine.
	DataDiskIds *[]string `json:"dataDiskIds,omitempty"`
	// DataDisks - Gets all data disks attached to the virtual machine.
	DataDisks *[]ComputeDataDiskFragment `json:"dataDisks,omitempty"`
}

// CostThresholdProperties properties of a cost threshold item.
type CostThresholdProperties struct {
	// ThresholdID - The ID of the cost threshold item.
	ThresholdID *string `json:"thresholdId,omitempty"`
	// PercentageThreshold - The value of the percentage cost threshold.
	PercentageThreshold *PercentageCostThresholdProperties `json:"percentageThreshold,omitempty"`
	// DisplayOnChart - Indicates whether this threshold will be displayed on cost charts. Possible values include: 'Enabled', 'Disabled'
	DisplayOnChart CostThresholdStatus `json:"displayOnChart,omitempty"`
	// SendNotificationWhenExceeded - Indicates whether notifications will be sent when this threshold is exceeded. Possible values include: 'Enabled', 'Disabled'
	SendNotificationWhenExceeded CostThresholdStatus `json:"sendNotificationWhenExceeded,omitempty"`
	// NotificationSent - Indicates the datetime when notifications were last sent for this threshold.
	NotificationSent *string `json:"notificationSent,omitempty"`
}

// CustomImage a custom image.
type CustomImage struct {
	autorest.Response `json:"-"`
	// CustomImageProperties - The properties of the resource.
	*CustomImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomImage.
func (ci CustomImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CustomImageProperties != nil {
		objectMap["properties"] = ci.CustomImageProperties
	}
	if ci.Location != nil {
		objectMap["location"] = ci.Location
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomImage struct.
func (ci *CustomImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customImageProperties CustomImageProperties
				err = json.Unmarshal(*v, &customImageProperties)
				if err != nil {
					return err
				}
				ci.CustomImageProperties = &customImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ci.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ci.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ci.Tags = tags
			}
		}
	}

	return nil
}

// CustomImageFragment a custom image.
type CustomImageFragment struct {
	// CustomImagePropertiesFragment - The properties of the resource.
	*CustomImagePropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomImageFragment.
func (cif CustomImageFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cif.CustomImagePropertiesFragment != nil {
		objectMap["properties"] = cif.CustomImagePropertiesFragment
	}
	if cif.Tags != nil {
		objectMap["tags"] = cif.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomImageFragment struct.
func (cif *CustomImageFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customImagePropertiesFragment CustomImagePropertiesFragment
				err = json.Unmarshal(*v, &customImagePropertiesFragment)
				if err != nil {
					return err
				}
				cif.CustomImagePropertiesFragment = &customImagePropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cif.Tags = tags
			}
		}
	}

	return nil
}

// CustomImageList the response of a list operation.
type CustomImageList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]CustomImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomImageListIterator provides access to a complete listing of CustomImage values.
type CustomImageListIterator struct {
	i    int
	page CustomImageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomImageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomImageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomImageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomImageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomImageListIterator) Response() CustomImageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomImageListIterator) Value() CustomImage {
	if !iter.page.NotDone() {
		return CustomImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomImageListIterator type.
func NewCustomImageListIterator(page CustomImageListPage) CustomImageListIterator {
	return CustomImageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cil CustomImageList) IsEmpty() bool {
	return cil.Value == nil || len(*cil.Value) == 0
}

// customImageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cil CustomImageList) customImageListPreparer(ctx context.Context) (*http.Request, error) {
	if cil.NextLink == nil || len(to.String(cil.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cil.NextLink)))
}

// CustomImageListPage contains a page of CustomImage values.
type CustomImageListPage struct {
	fn  func(context.Context, CustomImageList) (CustomImageList, error)
	cil CustomImageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomImageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomImageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cil)
	if err != nil {
		return err
	}
	page.cil = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomImageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomImageListPage) NotDone() bool {
	return !page.cil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomImageListPage) Response() CustomImageList {
	return page.cil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomImageListPage) Values() []CustomImage {
	if page.cil.IsEmpty() {
		return nil
	}
	return *page.cil.Value
}

// Creates a new instance of the CustomImageListPage type.
func NewCustomImageListPage(getNextPage func(context.Context, CustomImageList) (CustomImageList, error)) CustomImageListPage {
	return CustomImageListPage{fn: getNextPage}
}

// CustomImageProperties properties of a custom image.
type CustomImageProperties struct {
	// VM - The virtual machine from which the image is to be created.
	VM *CustomImagePropertiesFromVM `json:"vm,omitempty"`
	// Vhd - The VHD from which the image is to be created.
	Vhd *CustomImagePropertiesCustom `json:"vhd,omitempty"`
	// Description - The description of the custom image.
	Description *string `json:"description,omitempty"`
	// Author - The author of the custom image.
	Author *string `json:"author,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the custom image.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ManagedImageID - The Managed Image Id backing the custom image.
	ManagedImageID *string `json:"managedImageId,omitempty"`
	// ManagedSnapshotID - The Managed Snapshot Id backing the custom image.
	ManagedSnapshotID *string `json:"managedSnapshotId,omitempty"`
	// DataDiskStorageInfo - Storage information about the data disks present in the custom image
	DataDiskStorageInfo *[]DataDiskStorageTypeInfo `json:"dataDiskStorageInfo,omitempty"`
	// CustomImagePlan - Storage information about the plan related to this custom image
	CustomImagePlan *CustomImagePropertiesFromPlan `json:"customImagePlan,omitempty"`
	// IsPlanAuthorized - Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// CustomImagePropertiesCustom properties for creating a custom image from a VHD.
type CustomImagePropertiesCustom struct {
	// ImageName - The image name.
	ImageName *string `json:"imageName,omitempty"`
	// SysPrep - Indicates whether sysprep has been run on the VHD.
	SysPrep *bool `json:"sysPrep,omitempty"`
	// OsType - The OS type of the custom image (i.e. Windows, Linux). Possible values include: 'Windows', 'Linux', 'None'
	OsType CustomImageOsType `json:"osType,omitempty"`
}

// CustomImagePropertiesCustomFragment properties for creating a custom image from a VHD.
type CustomImagePropertiesCustomFragment struct {
	// ImageName - The image name.
	ImageName *string `json:"imageName,omitempty"`
	// SysPrep - Indicates whether sysprep has been run on the VHD.
	SysPrep *bool `json:"sysPrep,omitempty"`
	// OsType - The OS type of the custom image (i.e. Windows, Linux). Possible values include: 'Windows', 'Linux', 'None'
	OsType CustomImageOsType `json:"osType,omitempty"`
}

// CustomImagePropertiesFragment properties of a custom image.
type CustomImagePropertiesFragment struct {
	// VM - The virtual machine from which the image is to be created.
	VM *CustomImagePropertiesFromVMFragment `json:"vm,omitempty"`
	// Vhd - The VHD from which the image is to be created.
	Vhd *CustomImagePropertiesCustomFragment `json:"vhd,omitempty"`
	// Description - The description of the custom image.
	Description *string `json:"description,omitempty"`
	// Author - The author of the custom image.
	Author *string `json:"author,omitempty"`
	// ManagedImageID - The Managed Image Id backing the custom image.
	ManagedImageID *string `json:"managedImageId,omitempty"`
	// ManagedSnapshotID - The Managed Snapshot Id backing the custom image.
	ManagedSnapshotID *string `json:"managedSnapshotId,omitempty"`
	// DataDiskStorageInfo - Storage information about the data disks present in the custom image
	DataDiskStorageInfo *[]DataDiskStorageTypeInfoFragment `json:"dataDiskStorageInfo,omitempty"`
	// CustomImagePlan - Storage information about the plan related to this custom image
	CustomImagePlan *CustomImagePropertiesFromPlanFragment `json:"customImagePlan,omitempty"`
	// IsPlanAuthorized - Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`
}

// CustomImagePropertiesFromPlan properties for plan on a custom image.
type CustomImagePropertiesFromPlan struct {
	// ID - The id of the plan, equivalent to name of the plan
	ID *string `json:"id,omitempty"`
	// Publisher - The publisher for the plan from the marketplace image the custom image is derived from
	Publisher *string `json:"publisher,omitempty"`
	// Offer - The offer for the plan from the marketplace image the custom image is derived from
	Offer *string `json:"offer,omitempty"`
}

// CustomImagePropertiesFromPlanFragment properties for plan on a custom image.
type CustomImagePropertiesFromPlanFragment struct {
	// ID - The id of the plan, equivalent to name of the plan
	ID *string `json:"id,omitempty"`
	// Publisher - The publisher for the plan from the marketplace image the custom image is derived from
	Publisher *string `json:"publisher,omitempty"`
	// Offer - The offer for the plan from the marketplace image the custom image is derived from
	Offer *string `json:"offer,omitempty"`
}

// CustomImagePropertiesFromVM properties for creating a custom image from a virtual machine.
type CustomImagePropertiesFromVM struct {
	// SourceVMID - The source vm identifier.
	SourceVMID *string `json:"sourceVmId,omitempty"`
	// WindowsOsInfo - The Windows OS information of the VM.
	WindowsOsInfo *WindowsOsInfo `json:"windowsOsInfo,omitempty"`
	// LinuxOsInfo - The Linux OS information of the VM.
	LinuxOsInfo *LinuxOsInfo `json:"linuxOsInfo,omitempty"`
}

// CustomImagePropertiesFromVMFragment properties for creating a custom image from a virtual machine.
type CustomImagePropertiesFromVMFragment struct {
	// SourceVMID - The source vm identifier.
	SourceVMID *string `json:"sourceVmId,omitempty"`
	// WindowsOsInfo - The Windows OS information of the VM.
	WindowsOsInfo *WindowsOsInfoFragment `json:"windowsOsInfo,omitempty"`
	// LinuxOsInfo - The Linux OS information of the VM.
	LinuxOsInfo *LinuxOsInfoFragment `json:"linuxOsInfo,omitempty"`
}

// CustomImagesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CustomImagesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomImagesCreateOrUpdateFuture) Result(client CustomImagesClient) (ci CustomImage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CustomImagesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.CustomImagesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ci.Response.Response, err = future.GetResult(sender); err == nil && ci.Response.Response.StatusCode != http.StatusNoContent {
		ci, err = client.CreateOrUpdateResponder(ci.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.CustomImagesCreateOrUpdateFuture", "Result", ci.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomImagesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomImagesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomImagesDeleteFuture) Result(client CustomImagesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CustomImagesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.CustomImagesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataDiskProperties request body for adding a new or existing data disk to a virtual machine.
type DataDiskProperties struct {
	// AttachNewDataDiskOptions - Specifies options to attach a new disk to the virtual machine.
	AttachNewDataDiskOptions *AttachNewDataDiskOptions `json:"attachNewDataDiskOptions,omitempty"`
	// ExistingLabDiskID - Specifies the existing lab disk id to attach to virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
	// HostCaching - Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Possible values include: 'HostCachingOptionsNone', 'HostCachingOptionsReadOnly', 'HostCachingOptionsReadWrite'
	HostCaching HostCachingOptions `json:"hostCaching,omitempty"`
}

// DataDiskPropertiesFragment request body for adding a new or existing data disk to a virtual machine.
type DataDiskPropertiesFragment struct {
	// AttachNewDataDiskOptions - Specifies options to attach a new disk to the virtual machine.
	AttachNewDataDiskOptions *AttachNewDataDiskOptionsFragment `json:"attachNewDataDiskOptions,omitempty"`
	// ExistingLabDiskID - Specifies the existing lab disk id to attach to virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
	// HostCaching - Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Possible values include: 'HostCachingOptionsNone', 'HostCachingOptionsReadOnly', 'HostCachingOptionsReadWrite'
	HostCaching HostCachingOptions `json:"hostCaching,omitempty"`
}

// DataDiskStorageTypeInfo storage information about the data disks present in the custom image
type DataDiskStorageTypeInfo struct {
	// Lun - Disk Lun
	Lun *string `json:"lun,omitempty"`
	// StorageType - Disk Storage Type. Possible values include: 'Standard', 'Premium', 'StandardSSD'
	StorageType StorageType `json:"storageType,omitempty"`
}

// DataDiskStorageTypeInfoFragment storage information about the data disks present in the custom image
type DataDiskStorageTypeInfoFragment struct {
	// Lun - Disk Lun
	Lun *string `json:"lun,omitempty"`
	// StorageType - Disk Storage Type. Possible values include: 'Standard', 'Premium', 'StandardSSD'
	StorageType StorageType `json:"storageType,omitempty"`
}

// DayDetails properties of a daily schedule.
type DayDetails struct {
	// Time - The time of day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// DayDetailsFragment properties of a daily schedule.
type DayDetailsFragment struct {
	// Time - The time of day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// DetachDataDiskProperties request body for detaching data disk from a virtual machine.
type DetachDataDiskProperties struct {
	// ExistingLabDiskID - Specifies the disk resource ID to detach from virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
}

// DetachDiskProperties properties of the disk to detach.
type DetachDiskProperties struct {
	// LeasedByLabVMID - The resource ID of the Lab VM to which the disk is attached.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// Disk a Disk.
type Disk struct {
	autorest.Response `json:"-"`
	// DiskProperties - The properties of the resource.
	*DiskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DiskProperties != nil {
		objectMap["properties"] = d.DiskProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Disk struct.
func (d *Disk) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskProperties DiskProperties
				err = json.Unmarshal(*v, &diskProperties)
				if err != nil {
					return err
				}
				d.DiskProperties = &diskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DiskFragment a Disk.
type DiskFragment struct {
	// DiskPropertiesFragment - The properties of the resource.
	*DiskPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DiskFragment.
func (df DiskFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if df.DiskPropertiesFragment != nil {
		objectMap["properties"] = df.DiskPropertiesFragment
	}
	if df.Tags != nil {
		objectMap["tags"] = df.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskFragment struct.
func (df *DiskFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskPropertiesFragment DiskPropertiesFragment
				err = json.Unmarshal(*v, &diskPropertiesFragment)
				if err != nil {
					return err
				}
				df.DiskPropertiesFragment = &diskPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				df.Tags = tags
			}
		}
	}

	return nil
}

// DiskList the response of a list operation.
type DiskList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Disk `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskListIterator provides access to a complete listing of Disk values.
type DiskListIterator struct {
	i    int
	page DiskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskListIterator) Response() DiskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskListIterator) Value() Disk {
	if !iter.page.NotDone() {
		return Disk{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskListIterator type.
func NewDiskListIterator(page DiskListPage) DiskListIterator {
	return DiskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DiskList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// diskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DiskList) diskListPreparer(ctx context.Context) (*http.Request, error) {
	if dl.NextLink == nil || len(to.String(dl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DiskListPage contains a page of Disk values.
type DiskListPage struct {
	fn func(context.Context, DiskList) (DiskList, error)
	dl DiskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dl)
	if err != nil {
		return err
	}
	page.dl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskListPage) Response() DiskList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskListPage) Values() []Disk {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DiskListPage type.
func NewDiskListPage(getNextPage func(context.Context, DiskList) (DiskList, error)) DiskListPage {
	return DiskListPage{fn: getNextPage}
}

// DiskProperties properties of a disk.
type DiskProperties struct {
	// DiskType - The storage type for the disk (i.e. Standard, Premium). Possible values include: 'Standard', 'Premium', 'StandardSSD'
	DiskType StorageType `json:"diskType,omitempty"`
	// DiskSizeGiB - The size of the disk in GibiBytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
	// LeasedByLabVMID - The resource ID of the VM to which this disk is leased.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
	// DiskBlobName - When backed by a blob, the name of the VHD blob without extension.
	DiskBlobName *string `json:"diskBlobName,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the disk.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// HostCaching - The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
	HostCaching *string `json:"hostCaching,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// DiskPropertiesFragment properties of a disk.
type DiskPropertiesFragment struct {
	// DiskType - The storage type for the disk (i.e. Standard, Premium). Possible values include: 'Standard', 'Premium', 'StandardSSD'
	DiskType StorageType `json:"diskType,omitempty"`
	// DiskSizeGiB - The size of the disk in GibiBytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
	// LeasedByLabVMID - The resource ID of the VM to which this disk is leased.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
	// DiskBlobName - When backed by a blob, the name of the VHD blob without extension.
	DiskBlobName *string `json:"diskBlobName,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// HostCaching - The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
	HostCaching *string `json:"hostCaching,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
}

// DisksAttachFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksAttachFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DisksAttachFuture) Result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksAttachFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.DisksAttachFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DisksCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DisksCreateOrUpdateFuture) Result(client DisksClient) (d Disk, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.DisksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.DisksCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DisksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DisksDeleteFuture) Result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.DisksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisksDetachFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksDetachFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DisksDetachFuture) Result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksDetachFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.DisksDetachFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Environment an environment, which is essentially an ARM template deployment.
type Environment struct {
	autorest.Response `json:"-"`
	// EnvironmentProperties - The properties of the resource.
	*EnvironmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Environment.
func (e Environment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EnvironmentProperties != nil {
		objectMap["properties"] = e.EnvironmentProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Environment struct.
func (e *Environment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentProperties EnvironmentProperties
				err = json.Unmarshal(*v, &environmentProperties)
				if err != nil {
					return err
				}
				e.EnvironmentProperties = &environmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentDeploymentProperties properties of an environment deployment.
type EnvironmentDeploymentProperties struct {
	// ArmTemplateID - The Azure Resource Manager template's identifier.
	ArmTemplateID *string `json:"armTemplateId,omitempty"`
	// Parameters - The parameters of the Azure Resource Manager template.
	Parameters *[]ArmTemplateParameterProperties `json:"parameters,omitempty"`
}

// EnvironmentDeploymentPropertiesFragment properties of an environment deployment.
type EnvironmentDeploymentPropertiesFragment struct {
	// ArmTemplateID - The Azure Resource Manager template's identifier.
	ArmTemplateID *string `json:"armTemplateId,omitempty"`
	// Parameters - The parameters of the Azure Resource Manager template.
	Parameters *[]ArmTemplateParameterPropertiesFragment `json:"parameters,omitempty"`
}

// EnvironmentFragment an environment, which is essentially an ARM template deployment.
type EnvironmentFragment struct {
	// EnvironmentPropertiesFragment - The properties of the resource.
	*EnvironmentPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EnvironmentFragment.
func (ef EnvironmentFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ef.EnvironmentPropertiesFragment != nil {
		objectMap["properties"] = ef.EnvironmentPropertiesFragment
	}
	if ef.Tags != nil {
		objectMap["tags"] = ef.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentFragment struct.
func (ef *EnvironmentFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentPropertiesFragment EnvironmentPropertiesFragment
				err = json.Unmarshal(*v, &environmentPropertiesFragment)
				if err != nil {
					return err
				}
				ef.EnvironmentPropertiesFragment = &environmentPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ef.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentList the response of a list operation.
type EnvironmentList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Environment `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EnvironmentListIterator provides access to a complete listing of Environment values.
type EnvironmentListIterator struct {
	i    int
	page EnvironmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EnvironmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnvironmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EnvironmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EnvironmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EnvironmentListIterator) Response() EnvironmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EnvironmentListIterator) Value() Environment {
	if !iter.page.NotDone() {
		return Environment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EnvironmentListIterator type.
func NewEnvironmentListIterator(page EnvironmentListPage) EnvironmentListIterator {
	return EnvironmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el EnvironmentList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// environmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el EnvironmentList) environmentListPreparer(ctx context.Context) (*http.Request, error) {
	if el.NextLink == nil || len(to.String(el.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// EnvironmentListPage contains a page of Environment values.
type EnvironmentListPage struct {
	fn func(context.Context, EnvironmentList) (EnvironmentList, error)
	el EnvironmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EnvironmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnvironmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.el)
	if err != nil {
		return err
	}
	page.el = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EnvironmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EnvironmentListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EnvironmentListPage) Response() EnvironmentList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EnvironmentListPage) Values() []Environment {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the EnvironmentListPage type.
func NewEnvironmentListPage(getNextPage func(context.Context, EnvironmentList) (EnvironmentList, error)) EnvironmentListPage {
	return EnvironmentListPage{fn: getNextPage}
}

// EnvironmentProperties properties of an environment.
type EnvironmentProperties struct {
	// DeploymentProperties - The deployment properties of the environment.
	DeploymentProperties *EnvironmentDeploymentProperties `json:"deploymentProperties,omitempty"`
	// ArmTemplateDisplayName - The display name of the Azure Resource Manager template that produced the environment.
	ArmTemplateDisplayName *string `json:"armTemplateDisplayName,omitempty"`
	// ResourceGroupID - READ-ONLY; The identifier of the resource group containing the environment's resources.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
	// CreatedByUser - READ-ONLY; The creator of the environment.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// EnvironmentPropertiesFragment properties of an environment.
type EnvironmentPropertiesFragment struct {
	// DeploymentProperties - The deployment properties of the environment.
	DeploymentProperties *EnvironmentDeploymentPropertiesFragment `json:"deploymentProperties,omitempty"`
	// ArmTemplateDisplayName - The display name of the Azure Resource Manager template that produced the environment.
	ArmTemplateDisplayName *string `json:"armTemplateDisplayName,omitempty"`
}

// EnvironmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EnvironmentsCreateOrUpdateFuture) Result(client EnvironmentsClient) (e Environment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.EnvironmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.EnvironmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateOrUpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.EnvironmentsCreateOrUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnvironmentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EnvironmentsDeleteFuture) Result(client EnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.EnvironmentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.EnvironmentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EvaluatePoliciesProperties properties for evaluating a policy set.
type EvaluatePoliciesProperties struct {
	// FactName - The fact name.
	FactName *string `json:"factName,omitempty"`
	// FactData - The fact data.
	FactData *string `json:"factData,omitempty"`
	// ValueOffset - The value offset.
	ValueOffset *string `json:"valueOffset,omitempty"`
	// UserObjectID - The user for which policies will be evaluated
	UserObjectID *string `json:"userObjectId,omitempty"`
}

// EvaluatePoliciesRequest request body for evaluating a policy set.
type EvaluatePoliciesRequest struct {
	// Policies - Policies to evaluate.
	Policies *[]EvaluatePoliciesProperties `json:"policies,omitempty"`
}

// EvaluatePoliciesResponse response body for evaluating a policy set.
type EvaluatePoliciesResponse struct {
	autorest.Response `json:"-"`
	// Results - Results of evaluating a policy set.
	Results *[]PolicySetResult `json:"results,omitempty"`
}

// Event an event to be notified for.
type Event struct {
	// EventName - The event type for which this notification is enabled (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
}

// EventFragment an event to be notified for.
type EventFragment struct {
	// EventName - The event type for which this notification is enabled (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
}

// ExportResourceUsageParameters the parameters of the export operation.
type ExportResourceUsageParameters struct {
	// BlobStorageAbsoluteSasURI - The blob storage absolute sas uri with write permission to the container which the usage data needs to be uploaded to.
	BlobStorageAbsoluteSasURI *string `json:"blobStorageAbsoluteSasUri,omitempty"`
	// UsageStartDate - The start time of the usage. If not provided, usage will be reported since the beginning of data collection.
	UsageStartDate *date.Time `json:"usageStartDate,omitempty"`
}

// ExternalSubnet subnet information as returned by the Microsoft.Network API.
type ExternalSubnet struct {
	// ID - Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name.
	Name *string `json:"name,omitempty"`
}

// ExternalSubnetFragment subnet information as returned by the Microsoft.Network API.
type ExternalSubnetFragment struct {
	// ID - Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name.
	Name *string `json:"name,omitempty"`
}

// Formula a formula for creating a VM, specifying an image base and other parameters
type Formula struct {
	autorest.Response `json:"-"`
	// FormulaProperties - The properties of the resource.
	*FormulaProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Formula.
func (f Formula) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.FormulaProperties != nil {
		objectMap["properties"] = f.FormulaProperties
	}
	if f.Location != nil {
		objectMap["location"] = f.Location
	}
	if f.Tags != nil {
		objectMap["tags"] = f.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Formula struct.
func (f *Formula) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var formulaProperties FormulaProperties
				err = json.Unmarshal(*v, &formulaProperties)
				if err != nil {
					return err
				}
				f.FormulaProperties = &formulaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				f.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				f.Tags = tags
			}
		}
	}

	return nil
}

// FormulaFragment a formula for creating a VM, specifying an image base and other parameters
type FormulaFragment struct {
	// FormulaPropertiesFragment - The properties of the resource.
	*FormulaPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FormulaFragment.
func (ff FormulaFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ff.FormulaPropertiesFragment != nil {
		objectMap["properties"] = ff.FormulaPropertiesFragment
	}
	if ff.Tags != nil {
		objectMap["tags"] = ff.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FormulaFragment struct.
func (ff *FormulaFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var formulaPropertiesFragment FormulaPropertiesFragment
				err = json.Unmarshal(*v, &formulaPropertiesFragment)
				if err != nil {
					return err
				}
				ff.FormulaPropertiesFragment = &formulaPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ff.Tags = tags
			}
		}
	}

	return nil
}

// FormulaList the response of a list operation.
type FormulaList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Formula `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FormulaListIterator provides access to a complete listing of Formula values.
type FormulaListIterator struct {
	i    int
	page FormulaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FormulaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FormulaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FormulaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FormulaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FormulaListIterator) Response() FormulaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FormulaListIterator) Value() Formula {
	if !iter.page.NotDone() {
		return Formula{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FormulaListIterator type.
func NewFormulaListIterator(page FormulaListPage) FormulaListIterator {
	return FormulaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fl FormulaList) IsEmpty() bool {
	return fl.Value == nil || len(*fl.Value) == 0
}

// formulaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fl FormulaList) formulaListPreparer(ctx context.Context) (*http.Request, error) {
	if fl.NextLink == nil || len(to.String(fl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fl.NextLink)))
}

// FormulaListPage contains a page of Formula values.
type FormulaListPage struct {
	fn func(context.Context, FormulaList) (FormulaList, error)
	fl FormulaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FormulaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FormulaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.fl)
	if err != nil {
		return err
	}
	page.fl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FormulaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FormulaListPage) NotDone() bool {
	return !page.fl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FormulaListPage) Response() FormulaList {
	return page.fl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FormulaListPage) Values() []Formula {
	if page.fl.IsEmpty() {
		return nil
	}
	return *page.fl.Value
}

// Creates a new instance of the FormulaListPage type.
func NewFormulaListPage(getNextPage func(context.Context, FormulaList) (FormulaList, error)) FormulaListPage {
	return FormulaListPage{fn: getNextPage}
}

// FormulaProperties properties of a formula.
type FormulaProperties struct {
	// Description - The description of the formula.
	Description *string `json:"description,omitempty"`
	// Author - The author of the formula.
	Author *string `json:"author,omitempty"`
	// OsType - The OS type of the formula.
	OsType *string `json:"osType,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the formula.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// FormulaContent - The content of the formula.
	FormulaContent *LabVirtualMachineCreationParameter `json:"formulaContent,omitempty"`
	// VM - Information about a VM from which a formula is to be created.
	VM *FormulaPropertiesFromVM `json:"vm,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// FormulaPropertiesFragment properties of a formula.
type FormulaPropertiesFragment struct {
	// Description - The description of the formula.
	Description *string `json:"description,omitempty"`
	// Author - The author of the formula.
	Author *string `json:"author,omitempty"`
	// OsType - The OS type of the formula.
	OsType *string `json:"osType,omitempty"`
	// FormulaContent - The content of the formula.
	FormulaContent *LabVirtualMachineCreationParameterFragment `json:"formulaContent,omitempty"`
	// VM - Information about a VM from which a formula is to be created.
	VM *FormulaPropertiesFromVMFragment `json:"vm,omitempty"`
}

// FormulaPropertiesFromVM information about a VM from which a formula is to be created.
type FormulaPropertiesFromVM struct {
	// LabVMID - The identifier of the VM from which a formula is to be created.
	LabVMID *string `json:"labVmId,omitempty"`
}

// FormulaPropertiesFromVMFragment information about a VM from which a formula is to be created.
type FormulaPropertiesFromVMFragment struct {
	// LabVMID - The identifier of the VM from which a formula is to be created.
	LabVMID *string `json:"labVmId,omitempty"`
}

// FormulasCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FormulasCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FormulasCreateOrUpdateFuture) Result(client FormulasClient) (f Formula, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.FormulasCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.FormulasCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CreateOrUpdateResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.FormulasCreateOrUpdateFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryImage a gallery image.
type GalleryImage struct {
	// GalleryImageProperties - The properties of the resource.
	*GalleryImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImage.
func (gi GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gi.GalleryImageProperties != nil {
		objectMap["properties"] = gi.GalleryImageProperties
	}
	if gi.Location != nil {
		objectMap["location"] = gi.Location
	}
	if gi.Tags != nil {
		objectMap["tags"] = gi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImage struct.
func (gi *GalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageProperties GalleryImageProperties
				err = json.Unmarshal(*v, &galleryImageProperties)
				if err != nil {
					return err
				}
				gi.GalleryImageProperties = &galleryImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gi.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageList the response of a list operation.
type GalleryImageList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]GalleryImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryImageListIterator provides access to a complete listing of GalleryImage values.
type GalleryImageListIterator struct {
	i    int
	page GalleryImageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GalleryImageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryImageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GalleryImageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GalleryImageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GalleryImageListIterator) Response() GalleryImageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GalleryImageListIterator) Value() GalleryImage {
	if !iter.page.NotDone() {
		return GalleryImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GalleryImageListIterator type.
func NewGalleryImageListIterator(page GalleryImageListPage) GalleryImageListIterator {
	return GalleryImageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gil GalleryImageList) IsEmpty() bool {
	return gil.Value == nil || len(*gil.Value) == 0
}

// galleryImageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gil GalleryImageList) galleryImageListPreparer(ctx context.Context) (*http.Request, error) {
	if gil.NextLink == nil || len(to.String(gil.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gil.NextLink)))
}

// GalleryImageListPage contains a page of GalleryImage values.
type GalleryImageListPage struct {
	fn  func(context.Context, GalleryImageList) (GalleryImageList, error)
	gil GalleryImageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GalleryImageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GalleryImageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.gil)
	if err != nil {
		return err
	}
	page.gil = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GalleryImageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GalleryImageListPage) NotDone() bool {
	return !page.gil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GalleryImageListPage) Response() GalleryImageList {
	return page.gil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GalleryImageListPage) Values() []GalleryImage {
	if page.gil.IsEmpty() {
		return nil
	}
	return *page.gil.Value
}

// Creates a new instance of the GalleryImageListPage type.
func NewGalleryImageListPage(getNextPage func(context.Context, GalleryImageList) (GalleryImageList, error)) GalleryImageListPage {
	return GalleryImageListPage{fn: getNextPage}
}

// GalleryImageProperties properties of a gallery image.
type GalleryImageProperties struct {
	// Author - The author of the gallery image.
	Author *string `json:"author,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the gallery image.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Description - The description of the gallery image.
	Description *string `json:"description,omitempty"`
	// ImageReference - The image reference of the gallery image.
	ImageReference *GalleryImageReference `json:"imageReference,omitempty"`
	// Icon - The icon of the gallery image.
	Icon *string `json:"icon,omitempty"`
	// Enabled - Indicates whether this gallery image is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// PlanID - The third party plan that applies to this image
	PlanID *string `json:"planId,omitempty"`
	// IsPlanAuthorized - Indicates if the plan has been authorized for programmatic deployment.
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`
}

// GalleryImageReference the reference information for an Azure Marketplace image.
type GalleryImageReference struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GalleryImageReferenceFragment the reference information for an Azure Marketplace image.
type GalleryImageReferenceFragment struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GenerateArmTemplateRequest parameters for generating an ARM template for deploying artifacts.
type GenerateArmTemplateRequest struct {
	// VirtualMachineName - The resource name of the virtual machine.
	VirtualMachineName *string `json:"virtualMachineName,omitempty"`
	// Parameters - The parameters of the ARM template.
	Parameters *[]ParameterInfo `json:"parameters,omitempty"`
	// Location - The location of the virtual machine.
	Location *string `json:"location,omitempty"`
	// FileUploadOptions - Options for uploading the files for the artifact. UploadFilesAndGenerateSasTokens is the default value. Possible values include: 'FileUploadOptionsUploadFilesAndGenerateSasTokens', 'FileUploadOptionsNone'
	FileUploadOptions FileUploadOptions `json:"fileUploadOptions,omitempty"`
}

// GenerateUploadURIParameter properties for generating an upload URI.
type GenerateUploadURIParameter struct {
	// BlobName - The blob name of the upload URI.
	BlobName *string `json:"blobName,omitempty"`
}

// GenerateUploadURIResponse response body for generating an upload URI.
type GenerateUploadURIResponse struct {
	autorest.Response `json:"-"`
	// UploadURI - The upload URI for the VHD.
	UploadURI *string `json:"uploadUri,omitempty"`
}

// GlobalSchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GlobalSchedulesExecuteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *GlobalSchedulesExecuteFuture) Result(client GlobalSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.GlobalSchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.GlobalSchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GlobalSchedulesRetargetFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GlobalSchedulesRetargetFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *GlobalSchedulesRetargetFuture) Result(client GlobalSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.GlobalSchedulesRetargetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.GlobalSchedulesRetargetFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HourDetails properties of an hourly schedule.
type HourDetails struct {
	// Minute - Minutes of the hour the schedule will run.
	Minute *int32 `json:"minute,omitempty"`
}

// HourDetailsFragment properties of an hourly schedule.
type HourDetailsFragment struct {
	// Minute - Minutes of the hour the schedule will run.
	Minute *int32 `json:"minute,omitempty"`
}

// IdentityProperties properties of a managed identity
type IdentityProperties struct {
	// Type - Managed identity.
	Type *string `json:"type,omitempty"`
	// PrincipalID - The principal id of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant identifier of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// ClientSecretURL - The client secret URL of the identity.
	ClientSecretURL *string `json:"clientSecretUrl,omitempty"`
}

// ImportLabVirtualMachineRequest this represents the payload required to import a virtual machine from a
// different lab into the current one
type ImportLabVirtualMachineRequest struct {
	// SourceVirtualMachineResourceID - The full resource ID of the virtual machine to be imported.
	SourceVirtualMachineResourceID *string `json:"sourceVirtualMachineResourceId,omitempty"`
	// DestinationVirtualMachineName - The name of the virtual machine in the destination lab
	DestinationVirtualMachineName *string `json:"destinationVirtualMachineName,omitempty"`
}

// InboundNatRule a rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load
// balancer.
type InboundNatRule struct {
	// TransportProtocol - The transport protocol for the endpoint. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// FrontendPort - The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port to which the external traffic will be redirected.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// InboundNatRuleFragment a rule for NAT - exposing a VM's port (backendPort) on the public IP address
// using a load balancer.
type InboundNatRuleFragment struct {
	// TransportProtocol - The transport protocol for the endpoint. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// FrontendPort - The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port to which the external traffic will be redirected.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// Lab a lab.
type Lab struct {
	autorest.Response `json:"-"`
	// LabProperties - The properties of the resource.
	*LabProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LabProperties != nil {
		objectMap["properties"] = l.LabProperties
	}
	if l.Location != nil {
		objectMap["location"] = l.Location
	}
	if l.Tags != nil {
		objectMap["tags"] = l.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Lab struct.
func (l *Lab) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labProperties LabProperties
				err = json.Unmarshal(*v, &labProperties)
				if err != nil {
					return err
				}
				l.LabProperties = &labProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				l.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				l.Tags = tags
			}
		}
	}

	return nil
}

// LabAnnouncementProperties properties of a lab's announcement banner
type LabAnnouncementProperties struct {
	// Title - The plain text title for the lab announcement
	Title *string `json:"title,omitempty"`
	// Markdown - The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
	Markdown *string `json:"markdown,omitempty"`
	// Enabled - Is the lab announcement active/enabled at this time?. Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Enabled EnableStatus `json:"enabled,omitempty"`
	// ExpirationDate - The time at which the announcement expires (null for never)
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Expired - Has this announcement expired?
	Expired *bool `json:"expired,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabAnnouncementPropertiesFragment properties of a lab's announcement banner
type LabAnnouncementPropertiesFragment struct {
	// Title - The plain text title for the lab announcement
	Title *string `json:"title,omitempty"`
	// Markdown - The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
	Markdown *string `json:"markdown,omitempty"`
	// Enabled - Is the lab announcement active/enabled at this time?. Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Enabled EnableStatus `json:"enabled,omitempty"`
	// ExpirationDate - The time at which the announcement expires (null for never)
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Expired - Has this announcement expired?
	Expired *bool `json:"expired,omitempty"`
}

// LabCost a cost item.
type LabCost struct {
	autorest.Response `json:"-"`
	// LabCostProperties - The properties of the resource.
	*LabCostProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabCost.
func (lc LabCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.LabCostProperties != nil {
		objectMap["properties"] = lc.LabCostProperties
	}
	if lc.Location != nil {
		objectMap["location"] = lc.Location
	}
	if lc.Tags != nil {
		objectMap["tags"] = lc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabCost struct.
func (lc *LabCost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labCostProperties LabCostProperties
				err = json.Unmarshal(*v, &labCostProperties)
				if err != nil {
					return err
				}
				lc.LabCostProperties = &labCostProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lc.Tags = tags
			}
		}
	}

	return nil
}

// LabCostDetailsProperties the properties of a lab cost item.
type LabCostDetailsProperties struct {
	// Date - The date of the cost item.
	Date *date.Time `json:"date,omitempty"`
	// Cost - The cost component of the cost item.
	Cost *float64 `json:"cost,omitempty"`
	// CostType - The type of the cost. Possible values include: 'Unavailable', 'Reported', 'Projected'
	CostType CostType `json:"costType,omitempty"`
}

// LabCostProperties properties of a cost item.
type LabCostProperties struct {
	// TargetCost - The target cost properties
	TargetCost *TargetCostProperties `json:"targetCost,omitempty"`
	// LabCostSummary - READ-ONLY; The lab cost summary component of the cost data.
	LabCostSummary *LabCostSummaryProperties `json:"labCostSummary,omitempty"`
	// LabCostDetails - READ-ONLY; The lab cost details component of the cost data.
	LabCostDetails *[]LabCostDetailsProperties `json:"labCostDetails,omitempty"`
	// ResourceCosts - READ-ONLY; The resource cost component of the cost data.
	ResourceCosts *[]LabResourceCostProperties `json:"resourceCosts,omitempty"`
	// CurrencyCode - The currency code of the cost.
	CurrencyCode *string `json:"currencyCode,omitempty"`
	// StartDateTime - The start time of the cost data.
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// EndDateTime - The end time of the cost data.
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// CreatedDate - The creation date of the cost.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabCostSummaryProperties the properties of the cost summary.
type LabCostSummaryProperties struct {
	// EstimatedLabCost - The cost component of the cost item.
	EstimatedLabCost *float64 `json:"estimatedLabCost,omitempty"`
}

// LabFragment a lab.
type LabFragment struct {
	// LabPropertiesFragment - The properties of the resource.
	*LabPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabFragment.
func (lf LabFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lf.LabPropertiesFragment != nil {
		objectMap["properties"] = lf.LabPropertiesFragment
	}
	if lf.Tags != nil {
		objectMap["tags"] = lf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabFragment struct.
func (lf *LabFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labPropertiesFragment LabPropertiesFragment
				err = json.Unmarshal(*v, &labPropertiesFragment)
				if err != nil {
					return err
				}
				lf.LabPropertiesFragment = &labPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lf.Tags = tags
			}
		}
	}

	return nil
}

// LabList the response of a list operation.
type LabList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Lab `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LabListIterator provides access to a complete listing of Lab values.
type LabListIterator struct {
	i    int
	page LabListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LabListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LabListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LabListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LabListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LabListIterator) Response() LabList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LabListIterator) Value() Lab {
	if !iter.page.NotDone() {
		return Lab{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LabListIterator type.
func NewLabListIterator(page LabListPage) LabListIterator {
	return LabListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ll LabList) IsEmpty() bool {
	return ll.Value == nil || len(*ll.Value) == 0
}

// labListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ll LabList) labListPreparer(ctx context.Context) (*http.Request, error) {
	if ll.NextLink == nil || len(to.String(ll.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ll.NextLink)))
}

// LabListPage contains a page of Lab values.
type LabListPage struct {
	fn func(context.Context, LabList) (LabList, error)
	ll LabList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LabListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LabListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ll)
	if err != nil {
		return err
	}
	page.ll = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LabListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LabListPage) NotDone() bool {
	return !page.ll.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LabListPage) Response() LabList {
	return page.ll
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LabListPage) Values() []Lab {
	if page.ll.IsEmpty() {
		return nil
	}
	return *page.ll.Value
}

// Creates a new instance of the LabListPage type.
func NewLabListPage(getNextPage func(context.Context, LabList) (LabList, error)) LabListPage {
	return LabListPage{fn: getNextPage}
}

// LabProperties properties of a lab.
type LabProperties struct {
	// DefaultStorageAccount - READ-ONLY; The lab's default storage account.
	DefaultStorageAccount *string `json:"defaultStorageAccount,omitempty"`
	// DefaultPremiumStorageAccount - READ-ONLY; The lab's default premium storage account.
	DefaultPremiumStorageAccount *string `json:"defaultPremiumStorageAccount,omitempty"`
	// ArtifactsStorageAccount - READ-ONLY; The lab's artifact storage account.
	ArtifactsStorageAccount *string `json:"artifactsStorageAccount,omitempty"`
	// PremiumDataDiskStorageAccount - READ-ONLY; The lab's premium data disk storage account.
	PremiumDataDiskStorageAccount *string `json:"premiumDataDiskStorageAccount,omitempty"`
	// VaultName - READ-ONLY; The lab's Key vault.
	VaultName *string `json:"vaultName,omitempty"`
	// LabStorageType - Type of storage used by the lab. It can be either Premium or Standard. Default is Premium. Possible values include: 'Standard', 'Premium', 'StandardSSD'
	LabStorageType StorageType `json:"labStorageType,omitempty"`
	// MandatoryArtifactsResourceIdsLinux - The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
	MandatoryArtifactsResourceIdsLinux *[]string `json:"mandatoryArtifactsResourceIdsLinux,omitempty"`
	// MandatoryArtifactsResourceIdsWindows - The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
	MandatoryArtifactsResourceIdsWindows *[]string `json:"mandatoryArtifactsResourceIdsWindows,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the lab.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// PremiumDataDisks - The setting to enable usage of premium data disks.
	// When its value is 'Enabled', creation of standard or premium data disks is allowed.
	// When its value is 'Disabled', only creation of standard data disks is allowed. Possible values include: 'PremiumDataDiskDisabled', 'PremiumDataDiskEnabled'
	PremiumDataDisks PremiumDataDisk `json:"premiumDataDisks,omitempty"`
	// EnvironmentPermission - The access rights to be granted to the user when provisioning an environment. Possible values include: 'Reader', 'Contributor'
	EnvironmentPermission EnvironmentPermission `json:"environmentPermission,omitempty"`
	// Announcement - The properties of any lab announcement associated with this lab
	Announcement *LabAnnouncementProperties `json:"announcement,omitempty"`
	// Support - The properties of any lab support message associated with this lab
	Support *LabSupportProperties `json:"support,omitempty"`
	// VMCreationResourceGroup - READ-ONLY; The resource group in which all new lab virtual machines will be created. To let DevTest Labs manage resource group creation, set this value to null.
	VMCreationResourceGroup *string `json:"vmCreationResourceGroup,omitempty"`
	// PublicIPID - READ-ONLY; The public IP address for the lab's load balancer.
	PublicIPID *string `json:"publicIpId,omitempty"`
	// LoadBalancerID - READ-ONLY; The load balancer used to for lab VMs that use shared IP address.
	LoadBalancerID *string `json:"loadBalancerId,omitempty"`
	// NetworkSecurityGroupID - READ-ONLY; The Network Security Group attached to the lab VMs Network interfaces to restrict open ports.
	NetworkSecurityGroupID *string `json:"networkSecurityGroupId,omitempty"`
	// ExtendedProperties - Extended properties of the lab used for experimental features
	ExtendedProperties map[string]*string `json:"extendedProperties"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for LabProperties.
func (lp LabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lp.LabStorageType != "" {
		objectMap["labStorageType"] = lp.LabStorageType
	}
	if lp.MandatoryArtifactsResourceIdsLinux != nil {
		objectMap["mandatoryArtifactsResourceIdsLinux"] = lp.MandatoryArtifactsResourceIdsLinux
	}
	if lp.MandatoryArtifactsResourceIdsWindows != nil {
		objectMap["mandatoryArtifactsResourceIdsWindows"] = lp.MandatoryArtifactsResourceIdsWindows
	}
	if lp.PremiumDataDisks != "" {
		objectMap["premiumDataDisks"] = lp.PremiumDataDisks
	}
	if lp.EnvironmentPermission != "" {
		objectMap["environmentPermission"] = lp.EnvironmentPermission
	}
	if lp.Announcement != nil {
		objectMap["announcement"] = lp.Announcement
	}
	if lp.Support != nil {
		objectMap["support"] = lp.Support
	}
	if lp.ExtendedProperties != nil {
		objectMap["extendedProperties"] = lp.ExtendedProperties
	}
	return json.Marshal(objectMap)
}

// LabPropertiesFragment properties of a lab.
type LabPropertiesFragment struct {
	// LabStorageType - Type of storage used by the lab. It can be either Premium or Standard. Default is Premium. Possible values include: 'Standard', 'Premium', 'StandardSSD'
	LabStorageType StorageType `json:"labStorageType,omitempty"`
	// MandatoryArtifactsResourceIdsLinux - The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
	MandatoryArtifactsResourceIdsLinux *[]string `json:"mandatoryArtifactsResourceIdsLinux,omitempty"`
	// MandatoryArtifactsResourceIdsWindows - The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
	MandatoryArtifactsResourceIdsWindows *[]string `json:"mandatoryArtifactsResourceIdsWindows,omitempty"`
	// PremiumDataDisks - The setting to enable usage of premium data disks.
	// When its value is 'Enabled', creation of standard or premium data disks is allowed.
	// When its value is 'Disabled', only creation of standard data disks is allowed. Possible values include: 'PremiumDataDiskDisabled', 'PremiumDataDiskEnabled'
	PremiumDataDisks PremiumDataDisk `json:"premiumDataDisks,omitempty"`
	// EnvironmentPermission - The access rights to be granted to the user when provisioning an environment. Possible values include: 'Reader', 'Contributor'
	EnvironmentPermission EnvironmentPermission `json:"environmentPermission,omitempty"`
	// Announcement - The properties of any lab announcement associated with this lab
	Announcement *LabAnnouncementPropertiesFragment `json:"announcement,omitempty"`
	// Support - The properties of any lab support message associated with this lab
	Support *LabSupportPropertiesFragment `json:"support,omitempty"`
	// ExtendedProperties - Extended properties of the lab used for experimental features
	ExtendedProperties map[string]*string `json:"extendedProperties"`
}

// MarshalJSON is the custom marshaler for LabPropertiesFragment.
func (lpf LabPropertiesFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpf.LabStorageType != "" {
		objectMap["labStorageType"] = lpf.LabStorageType
	}
	if lpf.MandatoryArtifactsResourceIdsLinux != nil {
		objectMap["mandatoryArtifactsResourceIdsLinux"] = lpf.MandatoryArtifactsResourceIdsLinux
	}
	if lpf.MandatoryArtifactsResourceIdsWindows != nil {
		objectMap["mandatoryArtifactsResourceIdsWindows"] = lpf.MandatoryArtifactsResourceIdsWindows
	}
	if lpf.PremiumDataDisks != "" {
		objectMap["premiumDataDisks"] = lpf.PremiumDataDisks
	}
	if lpf.EnvironmentPermission != "" {
		objectMap["environmentPermission"] = lpf.EnvironmentPermission
	}
	if lpf.Announcement != nil {
		objectMap["announcement"] = lpf.Announcement
	}
	if lpf.Support != nil {
		objectMap["support"] = lpf.Support
	}
	if lpf.ExtendedProperties != nil {
		objectMap["extendedProperties"] = lpf.ExtendedProperties
	}
	return json.Marshal(objectMap)
}

// LabResourceCostProperties the properties of a resource cost item.
type LabResourceCostProperties struct {
	// Resourcename - The name of the resource.
	Resourcename *string `json:"resourcename,omitempty"`
	// ResourceUID - The unique identifier of the resource.
	ResourceUID *string `json:"resourceUId,omitempty"`
	// ResourceCost - The cost component of the resource cost item.
	ResourceCost *float64 `json:"resourceCost,omitempty"`
	// ResourceType - The logical resource type (ex. virtualmachine, storageaccount)
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceOwner - The owner of the resource (ex. janedoe@microsoft.com)
	ResourceOwner *string `json:"resourceOwner,omitempty"`
	// ResourcePricingTier - The category of the resource (ex. Premium_LRS, Standard_DS1)
	ResourcePricingTier *string `json:"resourcePricingTier,omitempty"`
	// ResourceStatus - The status of the resource (ex. Active)
	ResourceStatus *string `json:"resourceStatus,omitempty"`
	// ResourceID - The ID of the resource
	ResourceID *string `json:"resourceId,omitempty"`
	// ExternalResourceID - The ID of the external resource
	ExternalResourceID *string `json:"externalResourceId,omitempty"`
}

// LabsClaimAnyVMFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsClaimAnyVMFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabsClaimAnyVMFuture) Result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsClaimAnyVMFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabsClaimAnyVMFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsCreateEnvironmentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsCreateEnvironmentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabsCreateEnvironmentFuture) Result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsCreateEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabsCreateEnvironmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabsCreateOrUpdateFuture) Result(client LabsClient) (l Lab, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if l.Response.Response, err = future.GetResult(sender); err == nil && l.Response.Response.StatusCode != http.StatusNoContent {
		l, err = client.CreateOrUpdateResponder(l.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.LabsCreateOrUpdateFuture", "Result", l.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabsDeleteFuture) Result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsExportResourceUsageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsExportResourceUsageFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabsExportResourceUsageFuture) Result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsExportResourceUsageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabsExportResourceUsageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsImportVirtualMachineFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LabsImportVirtualMachineFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabsImportVirtualMachineFuture) Result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsImportVirtualMachineFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabsImportVirtualMachineFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabSupportProperties properties of a lab's support banner
type LabSupportProperties struct {
	// Enabled - Is the lab support banner active/enabled at this time?. Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Enabled EnableStatus `json:"enabled,omitempty"`
	// Markdown - The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
	Markdown *string `json:"markdown,omitempty"`
}

// LabSupportPropertiesFragment properties of a lab's support banner
type LabSupportPropertiesFragment struct {
	// Enabled - Is the lab support banner active/enabled at this time?. Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Enabled EnableStatus `json:"enabled,omitempty"`
	// Markdown - The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
	Markdown *string `json:"markdown,omitempty"`
}

// LabVhd properties of a VHD in the lab.
type LabVhd struct {
	// ID - The URI to the VHD.
	ID *string `json:"id,omitempty"`
}

// LabVhdList the response of a list operation.
type LabVhdList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabVhd `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LabVhdListIterator provides access to a complete listing of LabVhd values.
type LabVhdListIterator struct {
	i    int
	page LabVhdListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LabVhdListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LabVhdListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LabVhdListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LabVhdListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LabVhdListIterator) Response() LabVhdList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LabVhdListIterator) Value() LabVhd {
	if !iter.page.NotDone() {
		return LabVhd{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LabVhdListIterator type.
func NewLabVhdListIterator(page LabVhdListPage) LabVhdListIterator {
	return LabVhdListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvl LabVhdList) IsEmpty() bool {
	return lvl.Value == nil || len(*lvl.Value) == 0
}

// labVhdListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvl LabVhdList) labVhdListPreparer(ctx context.Context) (*http.Request, error) {
	if lvl.NextLink == nil || len(to.String(lvl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvl.NextLink)))
}

// LabVhdListPage contains a page of LabVhd values.
type LabVhdListPage struct {
	fn  func(context.Context, LabVhdList) (LabVhdList, error)
	lvl LabVhdList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LabVhdListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LabVhdListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lvl)
	if err != nil {
		return err
	}
	page.lvl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LabVhdListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LabVhdListPage) NotDone() bool {
	return !page.lvl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LabVhdListPage) Response() LabVhdList {
	return page.lvl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LabVhdListPage) Values() []LabVhd {
	if page.lvl.IsEmpty() {
		return nil
	}
	return *page.lvl.Value
}

// Creates a new instance of the LabVhdListPage type.
func NewLabVhdListPage(getNextPage func(context.Context, LabVhdList) (LabVhdList, error)) LabVhdListPage {
	return LabVhdListPage{fn: getNextPage}
}

// LabVirtualMachine a virtual machine.
type LabVirtualMachine struct {
	autorest.Response `json:"-"`
	// LabVirtualMachineProperties - The properties of the resource.
	*LabVirtualMachineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachine.
func (lvm LabVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvm.LabVirtualMachineProperties != nil {
		objectMap["properties"] = lvm.LabVirtualMachineProperties
	}
	if lvm.Location != nil {
		objectMap["location"] = lvm.Location
	}
	if lvm.Tags != nil {
		objectMap["tags"] = lvm.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachine struct.
func (lvm *LabVirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachineProperties LabVirtualMachineProperties
				err = json.Unmarshal(*v, &labVirtualMachineProperties)
				if err != nil {
					return err
				}
				lvm.LabVirtualMachineProperties = &labVirtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lvm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lvm.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvm.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvm.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineCreationParameter properties for creating a virtual machine.
type LabVirtualMachineCreationParameter struct {
	// LabVirtualMachineCreationParameterProperties - The properties of the resource.
	*LabVirtualMachineCreationParameterProperties `json:"properties,omitempty"`
	// Name - The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`
	// Location - The location of the new virtual machine or environment
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachineCreationParameter.
func (lvmcp LabVirtualMachineCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvmcp.LabVirtualMachineCreationParameterProperties != nil {
		objectMap["properties"] = lvmcp.LabVirtualMachineCreationParameterProperties
	}
	if lvmcp.Name != nil {
		objectMap["name"] = lvmcp.Name
	}
	if lvmcp.Location != nil {
		objectMap["location"] = lvmcp.Location
	}
	if lvmcp.Tags != nil {
		objectMap["tags"] = lvmcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachineCreationParameter struct.
func (lvmcp *LabVirtualMachineCreationParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachineCreationParameterProperties LabVirtualMachineCreationParameterProperties
				err = json.Unmarshal(*v, &labVirtualMachineCreationParameterProperties)
				if err != nil {
					return err
				}
				lvmcp.LabVirtualMachineCreationParameterProperties = &labVirtualMachineCreationParameterProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvmcp.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvmcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvmcp.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineCreationParameterFragment properties for creating a virtual machine.
type LabVirtualMachineCreationParameterFragment struct {
	// LabVirtualMachineCreationParameterPropertiesFragment - The properties of the resource.
	*LabVirtualMachineCreationParameterPropertiesFragment `json:"properties,omitempty"`
	// Name - The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`
	// Location - The location of the new virtual machine or environment
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachineCreationParameterFragment.
func (lvmcpf LabVirtualMachineCreationParameterFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvmcpf.LabVirtualMachineCreationParameterPropertiesFragment != nil {
		objectMap["properties"] = lvmcpf.LabVirtualMachineCreationParameterPropertiesFragment
	}
	if lvmcpf.Name != nil {
		objectMap["name"] = lvmcpf.Name
	}
	if lvmcpf.Location != nil {
		objectMap["location"] = lvmcpf.Location
	}
	if lvmcpf.Tags != nil {
		objectMap["tags"] = lvmcpf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachineCreationParameterFragment struct.
func (lvmcpf *LabVirtualMachineCreationParameterFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachineCreationParameterPropertiesFragment LabVirtualMachineCreationParameterPropertiesFragment
				err = json.Unmarshal(*v, &labVirtualMachineCreationParameterPropertiesFragment)
				if err != nil {
					return err
				}
				lvmcpf.LabVirtualMachineCreationParameterPropertiesFragment = &labVirtualMachineCreationParameterPropertiesFragment
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvmcpf.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvmcpf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvmcpf.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineCreationParameterProperties properties for virtual machine creation.
type LabVirtualMachineCreationParameterProperties struct {
	// BulkCreationParameters - The number of virtual machine instances to create.
	BulkCreationParameters *BulkCreationParameters `json:"bulkCreationParameters,omitempty"`
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ComputeID - The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`
	// PlanID - The id of the plan associated with the virtual machine image
	PlanID *string `json:"planId,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfaceProperties `json:"networkInterface,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// DataDiskParameters - New or existing data disks to attach to the virtual machine after creation
	DataDiskParameters *[]DataDiskProperties `json:"dataDiskParameters,omitempty"`
	// ScheduleParameters - Virtual Machine schedules to be created
	ScheduleParameters *[]ScheduleCreationParameter `json:"scheduleParameters,omitempty"`
	// LastKnownPowerState - Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
}

// LabVirtualMachineCreationParameterPropertiesFragment properties for virtual machine creation.
type LabVirtualMachineCreationParameterPropertiesFragment struct {
	// BulkCreationParameters - The number of virtual machine instances to create.
	BulkCreationParameters *BulkCreationParametersFragment `json:"bulkCreationParameters,omitempty"`
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ComputeID - The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallPropertiesFragment `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusPropertiesFragment `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReferenceFragment `json:"galleryImageReference,omitempty"`
	// PlanID - The id of the plan associated with the virtual machine image
	PlanID *string `json:"planId,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfacePropertiesFragment `json:"networkInterface,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// DataDiskParameters - New or existing data disks to attach to the virtual machine after creation
	DataDiskParameters *[]DataDiskPropertiesFragment `json:"dataDiskParameters,omitempty"`
	// ScheduleParameters - Virtual Machine schedules to be created
	ScheduleParameters *[]ScheduleCreationParameterFragment `json:"scheduleParameters,omitempty"`
	// LastKnownPowerState - Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
}

// LabVirtualMachineFragment a virtual machine.
type LabVirtualMachineFragment struct {
	// LabVirtualMachinePropertiesFragment - The properties of the resource.
	*LabVirtualMachinePropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachineFragment.
func (lvmf LabVirtualMachineFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvmf.LabVirtualMachinePropertiesFragment != nil {
		objectMap["properties"] = lvmf.LabVirtualMachinePropertiesFragment
	}
	if lvmf.Tags != nil {
		objectMap["tags"] = lvmf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachineFragment struct.
func (lvmf *LabVirtualMachineFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachinePropertiesFragment LabVirtualMachinePropertiesFragment
				err = json.Unmarshal(*v, &labVirtualMachinePropertiesFragment)
				if err != nil {
					return err
				}
				lvmf.LabVirtualMachinePropertiesFragment = &labVirtualMachinePropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvmf.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineList the response of a list operation.
type LabVirtualMachineList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabVirtualMachine `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LabVirtualMachineListIterator provides access to a complete listing of LabVirtualMachine values.
type LabVirtualMachineListIterator struct {
	i    int
	page LabVirtualMachineListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LabVirtualMachineListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LabVirtualMachineListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LabVirtualMachineListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LabVirtualMachineListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LabVirtualMachineListIterator) Response() LabVirtualMachineList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LabVirtualMachineListIterator) Value() LabVirtualMachine {
	if !iter.page.NotDone() {
		return LabVirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LabVirtualMachineListIterator type.
func NewLabVirtualMachineListIterator(page LabVirtualMachineListPage) LabVirtualMachineListIterator {
	return LabVirtualMachineListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lvml LabVirtualMachineList) IsEmpty() bool {
	return lvml.Value == nil || len(*lvml.Value) == 0
}

// labVirtualMachineListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lvml LabVirtualMachineList) labVirtualMachineListPreparer(ctx context.Context) (*http.Request, error) {
	if lvml.NextLink == nil || len(to.String(lvml.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lvml.NextLink)))
}

// LabVirtualMachineListPage contains a page of LabVirtualMachine values.
type LabVirtualMachineListPage struct {
	fn   func(context.Context, LabVirtualMachineList) (LabVirtualMachineList, error)
	lvml LabVirtualMachineList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LabVirtualMachineListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LabVirtualMachineListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lvml)
	if err != nil {
		return err
	}
	page.lvml = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LabVirtualMachineListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LabVirtualMachineListPage) NotDone() bool {
	return !page.lvml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LabVirtualMachineListPage) Response() LabVirtualMachineList {
	return page.lvml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LabVirtualMachineListPage) Values() []LabVirtualMachine {
	if page.lvml.IsEmpty() {
		return nil
	}
	return *page.lvml.Value
}

// Creates a new instance of the LabVirtualMachineListPage type.
func NewLabVirtualMachineListPage(getNextPage func(context.Context, LabVirtualMachineList) (LabVirtualMachineList, error)) LabVirtualMachineListPage {
	return LabVirtualMachineListPage{fn: getNextPage}
}

// LabVirtualMachineProperties properties of a virtual machine.
type LabVirtualMachineProperties struct {
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ComputeID - The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`
	// PlanID - The id of the plan associated with the virtual machine image
	PlanID *string `json:"planId,omitempty"`
	// ComputeVM - READ-ONLY; The compute virtual machine properties.
	ComputeVM *ComputeVMProperties `json:"computeVm,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfaceProperties `json:"networkInterface,omitempty"`
	// ApplicableSchedule - READ-ONLY; The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableSchedule `json:"applicableSchedule,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// DataDiskParameters - New or existing data disks to attach to the virtual machine after creation
	DataDiskParameters *[]DataDiskProperties `json:"dataDiskParameters,omitempty"`
	// ScheduleParameters - Virtual Machine schedules to be created
	ScheduleParameters *[]ScheduleCreationParameter `json:"scheduleParameters,omitempty"`
	// LastKnownPowerState - Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabVirtualMachinePropertiesFragment properties of a virtual machine.
type LabVirtualMachinePropertiesFragment struct {
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ComputeID - The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallPropertiesFragment `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusPropertiesFragment `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReferenceFragment `json:"galleryImageReference,omitempty"`
	// PlanID - The id of the plan associated with the virtual machine image
	PlanID *string `json:"planId,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfacePropertiesFragment `json:"networkInterface,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage', 'FromSharedGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// DataDiskParameters - New or existing data disks to attach to the virtual machine after creation
	DataDiskParameters *[]DataDiskPropertiesFragment `json:"dataDiskParameters,omitempty"`
	// ScheduleParameters - Virtual Machine schedules to be created
	ScheduleParameters *[]ScheduleCreationParameterFragment `json:"scheduleParameters,omitempty"`
	// LastKnownPowerState - Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
}

// LinuxOsInfo information about a Linux OS.
type LinuxOsInfo struct {
	// LinuxOsState - The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied). Possible values include: 'NonDeprovisioned', 'DeprovisionRequested', 'DeprovisionApplied'
	LinuxOsState LinuxOsState `json:"linuxOsState,omitempty"`
}

// LinuxOsInfoFragment information about a Linux OS.
type LinuxOsInfoFragment struct {
	// LinuxOsState - The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied). Possible values include: 'NonDeprovisioned', 'DeprovisionRequested', 'DeprovisionApplied'
	LinuxOsState LinuxOsState `json:"linuxOsState,omitempty"`
}

// NetworkInterfaceProperties properties of a network interface.
type NetworkInterfaceProperties struct {
	// VirtualNetworkID - The resource ID of the virtual network.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
	// SubnetID - The resource ID of the sub net.
	SubnetID *string `json:"subnetId,omitempty"`
	// PublicIPAddressID - The resource ID of the public IP address.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`
	// PublicIPAddress - The public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// PrivateIPAddress - The private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// DNSName - The DNS name.
	DNSName *string `json:"dnsName,omitempty"`
	// RdpAuthority - The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// SSHAuthority - The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// SharedPublicIPAddressConfiguration - The configuration for sharing a public IP address across multiple virtual machines.
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`
}

// NetworkInterfacePropertiesFragment properties of a network interface.
type NetworkInterfacePropertiesFragment struct {
	// VirtualNetworkID - The resource ID of the virtual network.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
	// SubnetID - The resource ID of the sub net.
	SubnetID *string `json:"subnetId,omitempty"`
	// PublicIPAddressID - The resource ID of the public IP address.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`
	// PublicIPAddress - The public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// PrivateIPAddress - The private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// DNSName - The DNS name.
	DNSName *string `json:"dnsName,omitempty"`
	// RdpAuthority - The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// SSHAuthority - The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// SharedPublicIPAddressConfiguration - The configuration for sharing a public IP address across multiple virtual machines.
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfigurationFragment `json:"sharedPublicIpAddressConfiguration,omitempty"`
}

// NotificationChannel a notification.
type NotificationChannel struct {
	autorest.Response `json:"-"`
	// NotificationChannelProperties - The properties of the resource.
	*NotificationChannelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for NotificationChannel.
func (nc NotificationChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nc.NotificationChannelProperties != nil {
		objectMap["properties"] = nc.NotificationChannelProperties
	}
	if nc.Location != nil {
		objectMap["location"] = nc.Location
	}
	if nc.Tags != nil {
		objectMap["tags"] = nc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotificationChannel struct.
func (nc *NotificationChannel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notificationChannelProperties NotificationChannelProperties
				err = json.Unmarshal(*v, &notificationChannelProperties)
				if err != nil {
					return err
				}
				nc.NotificationChannelProperties = &notificationChannelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nc.Tags = tags
			}
		}
	}

	return nil
}

// NotificationChannelFragment a notification.
type NotificationChannelFragment struct {
	// NotificationChannelPropertiesFragment - The properties of the resource.
	*NotificationChannelPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for NotificationChannelFragment.
func (ncf NotificationChannelFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncf.NotificationChannelPropertiesFragment != nil {
		objectMap["properties"] = ncf.NotificationChannelPropertiesFragment
	}
	if ncf.Tags != nil {
		objectMap["tags"] = ncf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotificationChannelFragment struct.
func (ncf *NotificationChannelFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notificationChannelPropertiesFragment NotificationChannelPropertiesFragment
				err = json.Unmarshal(*v, &notificationChannelPropertiesFragment)
				if err != nil {
					return err
				}
				ncf.NotificationChannelPropertiesFragment = &notificationChannelPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ncf.Tags = tags
			}
		}
	}

	return nil
}

// NotificationChannelList the response of a list operation.
type NotificationChannelList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]NotificationChannel `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// NotificationChannelListIterator provides access to a complete listing of NotificationChannel values.
type NotificationChannelListIterator struct {
	i    int
	page NotificationChannelListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NotificationChannelListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotificationChannelListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NotificationChannelListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NotificationChannelListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NotificationChannelListIterator) Response() NotificationChannelList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NotificationChannelListIterator) Value() NotificationChannel {
	if !iter.page.NotDone() {
		return NotificationChannel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NotificationChannelListIterator type.
func NewNotificationChannelListIterator(page NotificationChannelListPage) NotificationChannelListIterator {
	return NotificationChannelListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ncl NotificationChannelList) IsEmpty() bool {
	return ncl.Value == nil || len(*ncl.Value) == 0
}

// notificationChannelListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ncl NotificationChannelList) notificationChannelListPreparer(ctx context.Context) (*http.Request, error) {
	if ncl.NextLink == nil || len(to.String(ncl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ncl.NextLink)))
}

// NotificationChannelListPage contains a page of NotificationChannel values.
type NotificationChannelListPage struct {
	fn  func(context.Context, NotificationChannelList) (NotificationChannelList, error)
	ncl NotificationChannelList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NotificationChannelListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotificationChannelListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ncl)
	if err != nil {
		return err
	}
	page.ncl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NotificationChannelListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NotificationChannelListPage) NotDone() bool {
	return !page.ncl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NotificationChannelListPage) Response() NotificationChannelList {
	return page.ncl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NotificationChannelListPage) Values() []NotificationChannel {
	if page.ncl.IsEmpty() {
		return nil
	}
	return *page.ncl.Value
}

// Creates a new instance of the NotificationChannelListPage type.
func NewNotificationChannelListPage(getNextPage func(context.Context, NotificationChannelList) (NotificationChannelList, error)) NotificationChannelListPage {
	return NotificationChannelListPage{fn: getNextPage}
}

// NotificationChannelProperties properties of a schedule.
type NotificationChannelProperties struct {
	// WebHookURL - The webhook URL to send notifications to.
	WebHookURL *string `json:"webHookUrl,omitempty"`
	// EmailRecipient - The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
	EmailRecipient *string `json:"emailRecipient,omitempty"`
	// NotificationLocale - The locale to use when sending a notification (fallback for unsupported languages is EN).
	NotificationLocale *string `json:"notificationLocale,omitempty"`
	// Description - Description of notification.
	Description *string `json:"description,omitempty"`
	// Events - The list of event for which this notification is enabled.
	Events *[]Event `json:"events,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the notification channel.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// NotificationChannelPropertiesFragment properties of a schedule.
type NotificationChannelPropertiesFragment struct {
	// WebHookURL - The webhook URL to send notifications to.
	WebHookURL *string `json:"webHookUrl,omitempty"`
	// EmailRecipient - The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
	EmailRecipient *string `json:"emailRecipient,omitempty"`
	// NotificationLocale - The locale to use when sending a notification (fallback for unsupported languages is EN).
	NotificationLocale *string `json:"notificationLocale,omitempty"`
	// Description - Description of notification.
	Description *string `json:"description,omitempty"`
	// Events - The list of event for which this notification is enabled.
	Events *[]EventFragment `json:"events,omitempty"`
}

// NotificationSettings notification settings for a schedule.
type NotificationSettings struct {
	// Status - If notifications are enabled for this schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TimeInMinutes - Time in minutes before event at which notification will be sent.
	TimeInMinutes *int32 `json:"timeInMinutes,omitempty"`
	// WebhookURL - The webhook URL to which the notification will be sent.
	WebhookURL *string `json:"webhookUrl,omitempty"`
	// EmailRecipient - The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
	EmailRecipient *string `json:"emailRecipient,omitempty"`
	// NotificationLocale - The locale to use when sending a notification (fallback for unsupported languages is EN).
	NotificationLocale *string `json:"notificationLocale,omitempty"`
}

// NotificationSettingsFragment notification settings for a schedule.
type NotificationSettingsFragment struct {
	// Status - If notifications are enabled for this schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TimeInMinutes - Time in minutes before event at which notification will be sent.
	TimeInMinutes *int32 `json:"timeInMinutes,omitempty"`
	// WebhookURL - The webhook URL to which the notification will be sent.
	WebhookURL *string `json:"webhookUrl,omitempty"`
	// EmailRecipient - The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
	EmailRecipient *string `json:"emailRecipient,omitempty"`
	// NotificationLocale - The locale to use when sending a notification (fallback for unsupported languages is EN).
	NotificationLocale *string `json:"notificationLocale,omitempty"`
}

// NotifyParameters properties for generating a Notification.
type NotifyParameters struct {
	// EventName - The type of event (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
	// JSONPayload - Properties for the notification in json format.
	JSONPayload *string `json:"jsonPayload,omitempty"`
}

// OperationError error details for the operation in case of a failure.
type OperationError struct {
	// Code - The error code of the operation error.
	Code *string `json:"code,omitempty"`
	// Message - The error message of the operation error.
	Message *string `json:"message,omitempty"`
}

// OperationMetadata the REST API operation supported by DevTestLab ResourceProvider.
type OperationMetadata struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operations
	Display *OperationMetadataDisplay `json:"display,omitempty"`
}

// OperationMetadataDisplay the object that describes the operations
type OperationMetadataDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationResult an Operation Result
type OperationResult struct {
	autorest.Response `json:"-"`
	// Status - The operation status.
	Status *string `json:"status,omitempty"`
	// StatusCode - The status code for the operation. Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'MovedPermanently', 'Redirect', 'SeeOther', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	// Error - Error details for the operation in case of a failure.
	Error *OperationError `json:"error,omitempty"`
}

// ParameterInfo information about an artifact's parameter.
type ParameterInfo struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ParametersValueFileInfo a file containing a set of parameter values for an ARM template.
type ParametersValueFileInfo struct {
	// FileName - File name.
	FileName *string `json:"fileName,omitempty"`
	// ParametersValueInfo - Contents of the file.
	ParametersValueInfo interface{} `json:"parametersValueInfo,omitempty"`
}

// PercentageCostThresholdProperties properties of a percentage cost threshold.
type PercentageCostThresholdProperties struct {
	// ThresholdValue - The cost threshold value.
	ThresholdValue *float64 `json:"thresholdValue,omitempty"`
}

// Policy a Policy.
type Policy struct {
	autorest.Response `json:"-"`
	// PolicyProperties - The properties of the resource.
	*PolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PolicyProperties != nil {
		objectMap["properties"] = p.PolicyProperties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Policy struct.
func (p *Policy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				p.PolicyProperties = &policyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		}
	}

	return nil
}

// PolicyFragment a Policy.
type PolicyFragment struct {
	// PolicyPropertiesFragment - The properties of the resource.
	*PolicyPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PolicyFragment.
func (pf PolicyFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pf.PolicyPropertiesFragment != nil {
		objectMap["properties"] = pf.PolicyPropertiesFragment
	}
	if pf.Tags != nil {
		objectMap["tags"] = pf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PolicyFragment struct.
func (pf *PolicyFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyPropertiesFragment PolicyPropertiesFragment
				err = json.Unmarshal(*v, &policyPropertiesFragment)
				if err != nil {
					return err
				}
				pf.PolicyPropertiesFragment = &policyPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pf.Tags = tags
			}
		}
	}

	return nil
}

// PolicyList the response of a list operation.
type PolicyList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Policy `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PolicyListIterator provides access to a complete listing of Policy values.
type PolicyListIterator struct {
	i    int
	page PolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PolicyListIterator) Response() PolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PolicyListIterator) Value() Policy {
	if !iter.page.NotDone() {
		return Policy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PolicyListIterator type.
func NewPolicyListIterator(page PolicyListPage) PolicyListIterator {
	return PolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl PolicyList) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// policyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl PolicyList) policyListPreparer(ctx context.Context) (*http.Request, error) {
	if pl.NextLink == nil || len(to.String(pl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// PolicyListPage contains a page of Policy values.
type PolicyListPage struct {
	fn func(context.Context, PolicyList) (PolicyList, error)
	pl PolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pl)
	if err != nil {
		return err
	}
	page.pl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PolicyListPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PolicyListPage) Response() PolicyList {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PolicyListPage) Values() []Policy {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the PolicyListPage type.
func NewPolicyListPage(getNextPage func(context.Context, PolicyList) (PolicyList, error)) PolicyListPage {
	return PolicyListPage{fn: getNextPage}
}

// PolicyProperties properties of a Policy.
type PolicyProperties struct {
	// Description - The description of the policy.
	Description *string `json:"description,omitempty"`
	// Status - The status of the policy. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
	// FactName - The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc. Possible values include: 'PolicyFactNameUserOwnedLabVMCount', 'PolicyFactNameUserOwnedLabPremiumVMCount', 'PolicyFactNameLabVMCount', 'PolicyFactNameLabPremiumVMCount', 'PolicyFactNameLabVMSize', 'PolicyFactNameGalleryImage', 'PolicyFactNameUserOwnedLabVMCountInSubnet', 'PolicyFactNameLabTargetCost', 'PolicyFactNameEnvironmentTemplate', 'PolicyFactNameScheduleEditPermission'
	FactName PolicyFactName `json:"factName,omitempty"`
	// FactData - The fact data of the policy.
	FactData *string `json:"factData,omitempty"`
	// Threshold - The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
	Threshold *string `json:"threshold,omitempty"`
	// EvaluatorType - The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy). Possible values include: 'AllowedValuesPolicy', 'MaxValuePolicy'
	EvaluatorType PolicyEvaluatorType `json:"evaluatorType,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the policy.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// PolicyPropertiesFragment properties of a Policy.
type PolicyPropertiesFragment struct {
	// Description - The description of the policy.
	Description *string `json:"description,omitempty"`
	// Status - The status of the policy. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
	// FactName - The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc. Possible values include: 'PolicyFactNameUserOwnedLabVMCount', 'PolicyFactNameUserOwnedLabPremiumVMCount', 'PolicyFactNameLabVMCount', 'PolicyFactNameLabPremiumVMCount', 'PolicyFactNameLabVMSize', 'PolicyFactNameGalleryImage', 'PolicyFactNameUserOwnedLabVMCountInSubnet', 'PolicyFactNameLabTargetCost', 'PolicyFactNameEnvironmentTemplate', 'PolicyFactNameScheduleEditPermission'
	FactName PolicyFactName `json:"factName,omitempty"`
	// FactData - The fact data of the policy.
	FactData *string `json:"factData,omitempty"`
	// Threshold - The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
	Threshold *string `json:"threshold,omitempty"`
	// EvaluatorType - The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy). Possible values include: 'AllowedValuesPolicy', 'MaxValuePolicy'
	EvaluatorType PolicyEvaluatorType `json:"evaluatorType,omitempty"`
}

// PolicySetResult result of a policy set evaluation.
type PolicySetResult struct {
	// HasError - A value indicating whether this policy set evaluation has discovered violations.
	HasError *bool `json:"hasError,omitempty"`
	// PolicyViolations - The list of policy violations.
	PolicyViolations *[]PolicyViolation `json:"policyViolations,omitempty"`
}

// PolicyViolation policy violation.
type PolicyViolation struct {
	// Code - The code of the policy violation.
	Code *string `json:"code,omitempty"`
	// Message - The message of the policy violation.
	Message *string `json:"message,omitempty"`
}

// Port properties of a network port.
type Port struct {
	// TransportProtocol - Protocol type of the port. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// BackendPort - Backend port of the target virtual machine.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// PortFragment properties of a network port.
type PortFragment struct {
	// TransportProtocol - Protocol type of the port. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// BackendPort - Backend port of the target virtual machine.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// ProviderOperationResult result of the request to list REST API operations
type ProviderOperationResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]OperationMetadata `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderOperationResultIterator provides access to a complete listing of OperationMetadata values.
type ProviderOperationResultIterator struct {
	i    int
	page ProviderOperationResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderOperationResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderOperationResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderOperationResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderOperationResultIterator) Response() ProviderOperationResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderOperationResultIterator) Value() OperationMetadata {
	if !iter.page.NotDone() {
		return OperationMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderOperationResultIterator type.
func NewProviderOperationResultIterator(page ProviderOperationResultPage) ProviderOperationResultIterator {
	return ProviderOperationResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (por ProviderOperationResult) IsEmpty() bool {
	return por.Value == nil || len(*por.Value) == 0
}

// providerOperationResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (por ProviderOperationResult) providerOperationResultPreparer(ctx context.Context) (*http.Request, error) {
	if por.NextLink == nil || len(to.String(por.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(por.NextLink)))
}

// ProviderOperationResultPage contains a page of OperationMetadata values.
type ProviderOperationResultPage struct {
	fn  func(context.Context, ProviderOperationResult) (ProviderOperationResult, error)
	por ProviderOperationResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderOperationResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.por)
	if err != nil {
		return err
	}
	page.por = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderOperationResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderOperationResultPage) NotDone() bool {
	return !page.por.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderOperationResultPage) Response() ProviderOperationResult {
	return page.por
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderOperationResultPage) Values() []OperationMetadata {
	if page.por.IsEmpty() {
		return nil
	}
	return *page.por.Value
}

// Creates a new instance of the ProviderOperationResultPage type.
func NewProviderOperationResultPage(getNextPage func(context.Context, ProviderOperationResult) (ProviderOperationResult, error)) ProviderOperationResultPage {
	return ProviderOperationResultPage{fn: getNextPage}
}

// RdpConnection represents a .rdp file
type RdpConnection struct {
	autorest.Response `json:"-"`
	// Contents - The contents of the .rdp file
	Contents *string `json:"contents,omitempty"`
}

// ResizeLabVirtualMachineProperties request body for resizing a virtual machine.
type ResizeLabVirtualMachineProperties struct {
	// Size - Specifies the size of the virtual machine.
	Size *string `json:"size,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RetargetScheduleProperties properties for retargeting a virtual machine schedule.
type RetargetScheduleProperties struct {
	// CurrentResourceID - The resource Id of the virtual machine on which the schedule operates
	CurrentResourceID *string `json:"currentResourceId,omitempty"`
	// TargetResourceID - The resource Id of the virtual machine that the schedule should be retargeted to
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// Schedule a schedule.
type Schedule struct {
	autorest.Response `json:"-"`
	// ScheduleProperties - The properties of the resource.
	*ScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ScheduleProperties != nil {
		objectMap["properties"] = s.ScheduleProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Schedule struct.
func (s *Schedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleProperties ScheduleProperties
				err = json.Unmarshal(*v, &scheduleProperties)
				if err != nil {
					return err
				}
				s.ScheduleProperties = &scheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleCreationParameter properties for creating a schedule.
type ScheduleCreationParameter struct {
	// ScheduleCreationParameterProperties - The properties of the schedule.
	*ScheduleCreationParameterProperties `json:"properties,omitempty"`
	// Name - The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`
	// Location - The location of the new virtual machine or environment
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScheduleCreationParameter.
func (scp ScheduleCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ScheduleCreationParameterProperties != nil {
		objectMap["properties"] = scp.ScheduleCreationParameterProperties
	}
	if scp.Name != nil {
		objectMap["name"] = scp.Name
	}
	if scp.Location != nil {
		objectMap["location"] = scp.Location
	}
	if scp.Tags != nil {
		objectMap["tags"] = scp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleCreationParameter struct.
func (scp *ScheduleCreationParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleCreationParameterProperties ScheduleCreationParameterProperties
				err = json.Unmarshal(*v, &scheduleCreationParameterProperties)
				if err != nil {
					return err
				}
				scp.ScheduleCreationParameterProperties = &scheduleCreationParameterProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scp.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				scp.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleCreationParameterFragment properties for creating a schedule.
type ScheduleCreationParameterFragment struct {
	// ScheduleCreationParameterPropertiesFragment - The properties of the schedule.
	*ScheduleCreationParameterPropertiesFragment `json:"properties,omitempty"`
	// Name - The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`
	// Location - The location of the new virtual machine or environment
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScheduleCreationParameterFragment.
func (scpf ScheduleCreationParameterFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scpf.ScheduleCreationParameterPropertiesFragment != nil {
		objectMap["properties"] = scpf.ScheduleCreationParameterPropertiesFragment
	}
	if scpf.Name != nil {
		objectMap["name"] = scpf.Name
	}
	if scpf.Location != nil {
		objectMap["location"] = scpf.Location
	}
	if scpf.Tags != nil {
		objectMap["tags"] = scpf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleCreationParameterFragment struct.
func (scpf *ScheduleCreationParameterFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleCreationParameterPropertiesFragment ScheduleCreationParameterPropertiesFragment
				err = json.Unmarshal(*v, &scheduleCreationParameterPropertiesFragment)
				if err != nil {
					return err
				}
				scpf.ScheduleCreationParameterPropertiesFragment = &scheduleCreationParameterPropertiesFragment
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scpf.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scpf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				scpf.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleCreationParameterProperties properties for schedule creation.
type ScheduleCreationParameterProperties struct {
	// Status - The status of the schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`
	// WeeklyRecurrence - If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetails `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetails `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetails `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// NotificationSettings - Notification settings.
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`
	// TargetResourceID - The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// ScheduleCreationParameterPropertiesFragment properties for schedule creation.
type ScheduleCreationParameterPropertiesFragment struct {
	// Status - The status of the schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`
	// WeeklyRecurrence - If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetailsFragment `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetailsFragment `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetailsFragment `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// NotificationSettings - Notification settings.
	NotificationSettings *NotificationSettingsFragment `json:"notificationSettings,omitempty"`
	// TargetResourceID - The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// ScheduleFragment a schedule.
type ScheduleFragment struct {
	// SchedulePropertiesFragment - The properties of the resource.
	*SchedulePropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScheduleFragment.
func (sf ScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sf.SchedulePropertiesFragment != nil {
		objectMap["properties"] = sf.SchedulePropertiesFragment
	}
	if sf.Tags != nil {
		objectMap["tags"] = sf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleFragment struct.
func (sf *ScheduleFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var schedulePropertiesFragment SchedulePropertiesFragment
				err = json.Unmarshal(*v, &schedulePropertiesFragment)
				if err != nil {
					return err
				}
				sf.SchedulePropertiesFragment = &schedulePropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sf.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleList the response of a list operation.
type ScheduleList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Schedule `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScheduleListIterator provides access to a complete listing of Schedule values.
type ScheduleListIterator struct {
	i    int
	page ScheduleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScheduleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScheduleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScheduleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScheduleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScheduleListIterator) Response() ScheduleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScheduleListIterator) Value() Schedule {
	if !iter.page.NotDone() {
		return Schedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScheduleListIterator type.
func NewScheduleListIterator(page ScheduleListPage) ScheduleListIterator {
	return ScheduleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ScheduleList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// scheduleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ScheduleList) scheduleListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ScheduleListPage contains a page of Schedule values.
type ScheduleListPage struct {
	fn func(context.Context, ScheduleList) (ScheduleList, error)
	sl ScheduleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScheduleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScheduleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScheduleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScheduleListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScheduleListPage) Response() ScheduleList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScheduleListPage) Values() []Schedule {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ScheduleListPage type.
func NewScheduleListPage(getNextPage func(context.Context, ScheduleList) (ScheduleList, error)) ScheduleListPage {
	return ScheduleListPage{fn: getNextPage}
}

// ScheduleProperties properties of a schedule.
type ScheduleProperties struct {
	// Status - The status of the schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`
	// WeeklyRecurrence - If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetails `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetails `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetails `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// NotificationSettings - Notification settings.
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the schedule.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// TargetResourceID - The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// SchedulePropertiesFragment properties of a schedule.
type SchedulePropertiesFragment struct {
	// Status - The status of the schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`
	// WeeklyRecurrence - If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetailsFragment `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetailsFragment `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetailsFragment `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// NotificationSettings - Notification settings.
	NotificationSettings *NotificationSettingsFragment `json:"notificationSettings,omitempty"`
	// TargetResourceID - The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// SchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SchedulesExecuteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SchedulesExecuteFuture) Result(client SchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.SchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.SchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Secret a secret.
type Secret struct {
	autorest.Response `json:"-"`
	// SecretProperties - The properties of the resource.
	*SecretProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SecretProperties != nil {
		objectMap["properties"] = s.SecretProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Secret struct.
func (s *Secret) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secretProperties SecretProperties
				err = json.Unmarshal(*v, &secretProperties)
				if err != nil {
					return err
				}
				s.SecretProperties = &secretProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// SecretFragment a secret.
type SecretFragment struct {
	// SecretPropertiesFragment - The properties of the resource.
	*SecretPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecretFragment.
func (sf SecretFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sf.SecretPropertiesFragment != nil {
		objectMap["properties"] = sf.SecretPropertiesFragment
	}
	if sf.Tags != nil {
		objectMap["tags"] = sf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecretFragment struct.
func (sf *SecretFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secretPropertiesFragment SecretPropertiesFragment
				err = json.Unmarshal(*v, &secretPropertiesFragment)
				if err != nil {
					return err
				}
				sf.SecretPropertiesFragment = &secretPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sf.Tags = tags
			}
		}
	}

	return nil
}

// SecretList the response of a list operation.
type SecretList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Secret `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecretListIterator provides access to a complete listing of Secret values.
type SecretListIterator struct {
	i    int
	page SecretListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretListIterator) Response() SecretList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretListIterator) Value() Secret {
	if !iter.page.NotDone() {
		return Secret{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretListIterator type.
func NewSecretListIterator(page SecretListPage) SecretListIterator {
	return SecretListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SecretList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// secretListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SecretList) secretListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SecretListPage contains a page of Secret values.
type SecretListPage struct {
	fn func(context.Context, SecretList) (SecretList, error)
	sl SecretList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretListPage) Response() SecretList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretListPage) Values() []Secret {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SecretListPage type.
func NewSecretListPage(getNextPage func(context.Context, SecretList) (SecretList, error)) SecretListPage {
	return SecretListPage{fn: getNextPage}
}

// SecretProperties properties of a secret.
type SecretProperties struct {
	// Value - The value of the secret for secret creation.
	Value *string `json:"value,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// SecretPropertiesFragment properties of a secret.
type SecretPropertiesFragment struct {
	// Value - The value of the secret for secret creation.
	Value *string `json:"value,omitempty"`
}

// SecretsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecretsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SecretsCreateOrUpdateFuture) Result(client SecretsClient) (s Secret, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.SecretsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.SecretsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.SecretsCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceFabric a Service Fabric.
type ServiceFabric struct {
	autorest.Response `json:"-"`
	// ServiceFabricProperties - The properties of the resource.
	*ServiceFabricProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceFabric.
func (sf ServiceFabric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sf.ServiceFabricProperties != nil {
		objectMap["properties"] = sf.ServiceFabricProperties
	}
	if sf.Location != nil {
		objectMap["location"] = sf.Location
	}
	if sf.Tags != nil {
		objectMap["tags"] = sf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceFabric struct.
func (sf *ServiceFabric) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceFabricProperties ServiceFabricProperties
				err = json.Unmarshal(*v, &serviceFabricProperties)
				if err != nil {
					return err
				}
				sf.ServiceFabricProperties = &serviceFabricProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sf.Tags = tags
			}
		}
	}

	return nil
}

// ServiceFabricFragment a Service Fabric.
type ServiceFabricFragment struct {
	// ServiceFabricPropertiesFragment - The properties of the resource.
	*ServiceFabricPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceFabricFragment.
func (sff ServiceFabricFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sff.ServiceFabricPropertiesFragment != nil {
		objectMap["properties"] = sff.ServiceFabricPropertiesFragment
	}
	if sff.Tags != nil {
		objectMap["tags"] = sff.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceFabricFragment struct.
func (sff *ServiceFabricFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceFabricPropertiesFragment ServiceFabricPropertiesFragment
				err = json.Unmarshal(*v, &serviceFabricPropertiesFragment)
				if err != nil {
					return err
				}
				sff.ServiceFabricPropertiesFragment = &serviceFabricPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sff.Tags = tags
			}
		}
	}

	return nil
}

// ServiceFabricList the response of a list operation.
type ServiceFabricList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ServiceFabric `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceFabricListIterator provides access to a complete listing of ServiceFabric values.
type ServiceFabricListIterator struct {
	i    int
	page ServiceFabricListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceFabricListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceFabricListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceFabricListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceFabricListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceFabricListIterator) Response() ServiceFabricList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceFabricListIterator) Value() ServiceFabric {
	if !iter.page.NotDone() {
		return ServiceFabric{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceFabricListIterator type.
func NewServiceFabricListIterator(page ServiceFabricListPage) ServiceFabricListIterator {
	return ServiceFabricListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sfl ServiceFabricList) IsEmpty() bool {
	return sfl.Value == nil || len(*sfl.Value) == 0
}

// serviceFabricListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sfl ServiceFabricList) serviceFabricListPreparer(ctx context.Context) (*http.Request, error) {
	if sfl.NextLink == nil || len(to.String(sfl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sfl.NextLink)))
}

// ServiceFabricListPage contains a page of ServiceFabric values.
type ServiceFabricListPage struct {
	fn  func(context.Context, ServiceFabricList) (ServiceFabricList, error)
	sfl ServiceFabricList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceFabricListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceFabricListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sfl)
	if err != nil {
		return err
	}
	page.sfl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceFabricListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceFabricListPage) NotDone() bool {
	return !page.sfl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceFabricListPage) Response() ServiceFabricList {
	return page.sfl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceFabricListPage) Values() []ServiceFabric {
	if page.sfl.IsEmpty() {
		return nil
	}
	return *page.sfl.Value
}

// Creates a new instance of the ServiceFabricListPage type.
func NewServiceFabricListPage(getNextPage func(context.Context, ServiceFabricList) (ServiceFabricList, error)) ServiceFabricListPage {
	return ServiceFabricListPage{fn: getNextPage}
}

// ServiceFabricProperties properties of a service fabric.
type ServiceFabricProperties struct {
	// ExternalServiceFabricID - The backing service fabric resource's id
	ExternalServiceFabricID *string `json:"externalServiceFabricId,omitempty"`
	// EnvironmentID - The resource id of the environment under which the service fabric resource is present
	EnvironmentID *string `json:"environmentId,omitempty"`
	// ApplicableSchedule - READ-ONLY; The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableSchedule `json:"applicableSchedule,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// ServiceFabricPropertiesFragment properties of a service fabric.
type ServiceFabricPropertiesFragment struct {
	// ExternalServiceFabricID - The backing service fabric resource's id
	ExternalServiceFabricID *string `json:"externalServiceFabricId,omitempty"`
	// EnvironmentID - The resource id of the environment under which the service fabric resource is present
	EnvironmentID *string `json:"environmentId,omitempty"`
}

// ServiceFabricSchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServiceFabricSchedulesExecuteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceFabricSchedulesExecuteFuture) Result(client ServiceFabricSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ServiceFabricSchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ServiceFabricSchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceFabricsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServiceFabricsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceFabricsCreateOrUpdateFuture) Result(client ServiceFabricsClient) (sf ServiceFabric, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ServiceFabricsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ServiceFabricsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sf.Response.Response, err = future.GetResult(sender); err == nil && sf.Response.Response.StatusCode != http.StatusNoContent {
		sf, err = client.CreateOrUpdateResponder(sf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.ServiceFabricsCreateOrUpdateFuture", "Result", sf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceFabricsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceFabricsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceFabricsDeleteFuture) Result(client ServiceFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ServiceFabricsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ServiceFabricsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceFabricsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceFabricsStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceFabricsStartFuture) Result(client ServiceFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ServiceFabricsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ServiceFabricsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceFabricsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceFabricsStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceFabricsStopFuture) Result(client ServiceFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ServiceFabricsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ServiceFabricsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceRunner a container for a managed identity to execute DevTest lab services.
type ServiceRunner struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceRunner.
func (sr ServiceRunner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Identity != nil {
		objectMap["identity"] = sr.Identity
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	return json.Marshal(objectMap)
}

// SharedPublicIPAddressConfiguration properties of a virtual machine that determine how it is connected to
// a load balancer.
type SharedPublicIPAddressConfiguration struct {
	// InboundNatRules - The incoming NAT rules
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
}

// SharedPublicIPAddressConfigurationFragment properties of a virtual machine that determine how it is
// connected to a load balancer.
type SharedPublicIPAddressConfigurationFragment struct {
	// InboundNatRules - The incoming NAT rules
	InboundNatRules *[]InboundNatRuleFragment `json:"inboundNatRules,omitempty"`
}

// ShutdownNotificationContent the contents of a shutdown notification. Webhooks can use this type to
// deserialize the request body when they get notified of an imminent shutdown.
type ShutdownNotificationContent struct {
	// SkipURL - The URL to skip auto-shutdown.
	SkipURL *string `json:"skipUrl,omitempty"`
	// DelayURL60 - The URL to delay shutdown by 60 minutes.
	DelayURL60 *string `json:"delayUrl60,omitempty"`
	// DelayURL120 - The URL to delay shutdown by 2 hours.
	DelayURL120 *string `json:"delayUrl120,omitempty"`
	// VMName - The virtual machine to be shut down.
	VMName *string `json:"vmName,omitempty"`
	// GUID - The GUID for the virtual machine to be shut down.
	GUID *string `json:"guid,omitempty"`
	// Owner - The owner of the virtual machine.
	Owner *string `json:"owner,omitempty"`
	// VMURL - The URL of the virtual machine.
	VMURL *string `json:"vmUrl,omitempty"`
	// MinutesUntilShutdown - Minutes remaining until shutdown
	MinutesUntilShutdown *string `json:"minutesUntilShutdown,omitempty"`
	// EventType - The event for which a notification will be sent.
	EventType *string `json:"eventType,omitempty"`
	// Text - The text for the notification.
	Text *string `json:"text,omitempty"`
	// SubscriptionID - The subscription ID for the schedule.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroupName - The resource group name for the schedule.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// LabName - The lab for the schedule.
	LabName *string `json:"labName,omitempty"`
}

// Subnet subnet information.
type Subnet struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name of the subnet as seen in the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// AllowPublicIP - The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)). Possible values include: 'Default', 'Deny', 'Allow'
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetFragment subnet information.
type SubnetFragment struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name of the subnet as seen in the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// AllowPublicIP - The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)). Possible values include: 'Default', 'Deny', 'Allow'
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetOverride property overrides on a subnet of a virtual network.
type SubnetOverride struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name given to the subnet within the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// UseInVMCreationPermission - Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UseInVMCreationPermission UsagePermissionType `json:"useInVmCreationPermission,omitempty"`
	// UsePublicIPAddressPermission - Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UsePublicIPAddressPermission UsagePermissionType `json:"usePublicIpAddressPermission,omitempty"`
	// SharedPublicIPAddressConfiguration - Properties that virtual machines on this subnet will share.
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`
	// VirtualNetworkPoolName - The virtual network pool associated with this subnet.
	VirtualNetworkPoolName *string `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetOverrideFragment property overrides on a subnet of a virtual network.
type SubnetOverrideFragment struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name given to the subnet within the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// UseInVMCreationPermission - Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UseInVMCreationPermission UsagePermissionType `json:"useInVmCreationPermission,omitempty"`
	// UsePublicIPAddressPermission - Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UsePublicIPAddressPermission UsagePermissionType `json:"usePublicIpAddressPermission,omitempty"`
	// SharedPublicIPAddressConfiguration - Properties that virtual machines on this subnet will share.
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfigurationFragment `json:"sharedPublicIpAddressConfiguration,omitempty"`
	// VirtualNetworkPoolName - The virtual network pool associated with this subnet.
	VirtualNetworkPoolName *string `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetSharedPublicIPAddressConfiguration configuration for public IP address sharing.
type SubnetSharedPublicIPAddressConfiguration struct {
	// AllowedPorts - Backend ports that virtual machines on this subnet are allowed to expose
	AllowedPorts *[]Port `json:"allowedPorts,omitempty"`
}

// SubnetSharedPublicIPAddressConfigurationFragment configuration for public IP address sharing.
type SubnetSharedPublicIPAddressConfigurationFragment struct {
	// AllowedPorts - Backend ports that virtual machines on this subnet are allowed to expose
	AllowedPorts *[]PortFragment `json:"allowedPorts,omitempty"`
}

// TargetCostProperties properties of a cost target.
type TargetCostProperties struct {
	// Status - Target cost status. Possible values include: 'TargetCostStatusEnabled', 'TargetCostStatusDisabled'
	Status TargetCostStatus `json:"status,omitempty"`
	// Target - Lab target cost
	Target *int32 `json:"target,omitempty"`
	// CostThresholds - Cost thresholds.
	CostThresholds *[]CostThresholdProperties `json:"costThresholds,omitempty"`
	// CycleStartDateTime - Reporting cycle start date.
	CycleStartDateTime *date.Time `json:"cycleStartDateTime,omitempty"`
	// CycleEndDateTime - Reporting cycle end date.
	CycleEndDateTime *date.Time `json:"cycleEndDateTime,omitempty"`
	// CycleType - Reporting cycle type. Possible values include: 'CalendarMonth', 'Custom'
	CycleType ReportingCycleType `json:"cycleType,omitempty"`
}

// UpdateResource represents an update resource
type UpdateResource struct {
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateResource.
func (ur UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ur.Tags != nil {
		objectMap["tags"] = ur.Tags
	}
	return json.Marshal(objectMap)
}

// User profile of a lab user.
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - The properties of the resource.
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.Location != nil {
		objectMap["location"] = u.Location
	}
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				u.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		}
	}

	return nil
}

// UserFragment profile of a lab user.
type UserFragment struct {
	// UserPropertiesFragment - The properties of the resource.
	*UserPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UserFragment.
func (uf UserFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uf.UserPropertiesFragment != nil {
		objectMap["properties"] = uf.UserPropertiesFragment
	}
	if uf.Tags != nil {
		objectMap["tags"] = uf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserFragment struct.
func (uf *UserFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userPropertiesFragment UserPropertiesFragment
				err = json.Unmarshal(*v, &userPropertiesFragment)
				if err != nil {
					return err
				}
				uf.UserPropertiesFragment = &userPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				uf.Tags = tags
			}
		}
	}

	return nil
}

// UserIdentity identity attributes of a lab user.
type UserIdentity struct {
	// PrincipalName - Set to the principal name / UPN of the client JWT making the request.
	PrincipalName *string `json:"principalName,omitempty"`
	// PrincipalID - Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - Set to the tenant ID of the client JWT making the request.
	TenantID *string `json:"tenantId,omitempty"`
	// ObjectID - Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
	ObjectID *string `json:"objectId,omitempty"`
	// AppID - Set to the app Id of the client JWT making the request.
	AppID *string `json:"appId,omitempty"`
}

// UserIdentityFragment identity attributes of a lab user.
type UserIdentityFragment struct {
	// PrincipalName - Set to the principal name / UPN of the client JWT making the request.
	PrincipalName *string `json:"principalName,omitempty"`
	// PrincipalID - Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - Set to the tenant ID of the client JWT making the request.
	TenantID *string `json:"tenantId,omitempty"`
	// ObjectID - Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
	ObjectID *string `json:"objectId,omitempty"`
	// AppID - Set to the app Id of the client JWT making the request.
	AppID *string `json:"appId,omitempty"`
}

// UserList the response of a list operation.
type UserList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]User `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserListIterator provides access to a complete listing of User values.
type UserListIterator struct {
	i    int
	page UserListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserListIterator) Response() UserList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserListIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserListIterator type.
func NewUserListIterator(page UserListPage) UserListIterator {
	return UserListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ul UserList) IsEmpty() bool {
	return ul.Value == nil || len(*ul.Value) == 0
}

// userListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ul UserList) userListPreparer(ctx context.Context) (*http.Request, error) {
	if ul.NextLink == nil || len(to.String(ul.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ul.NextLink)))
}

// UserListPage contains a page of User values.
type UserListPage struct {
	fn func(context.Context, UserList) (UserList, error)
	ul UserList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ul)
	if err != nil {
		return err
	}
	page.ul = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserListPage) NotDone() bool {
	return !page.ul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserListPage) Response() UserList {
	return page.ul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserListPage) Values() []User {
	if page.ul.IsEmpty() {
		return nil
	}
	return *page.ul.Value
}

// Creates a new instance of the UserListPage type.
func NewUserListPage(getNextPage func(context.Context, UserList) (UserList, error)) UserListPage {
	return UserListPage{fn: getNextPage}
}

// UserProperties properties of a lab user profile.
type UserProperties struct {
	// Identity - The identity of the user.
	Identity *UserIdentity `json:"identity,omitempty"`
	// SecretStore - The secret store of the user.
	SecretStore *UserSecretStore `json:"secretStore,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the user profile.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// UserPropertiesFragment properties of a lab user profile.
type UserPropertiesFragment struct {
	// Identity - The identity of the user.
	Identity *UserIdentityFragment `json:"identity,omitempty"`
	// SecretStore - The secret store of the user.
	SecretStore *UserSecretStoreFragment `json:"secretStore,omitempty"`
}

// UsersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UsersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UsersCreateOrUpdateFuture) Result(client UsersClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.UsersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.UsersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.CreateOrUpdateResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.UsersCreateOrUpdateFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UsersDeleteFuture) Result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UserSecretStore properties of a user's secret store.
type UserSecretStore struct {
	// KeyVaultURI - The URI of the user's Key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyVaultID - The ID of the user's Key vault.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// UserSecretStoreFragment properties of a user's secret store.
type UserSecretStoreFragment struct {
	// KeyVaultURI - The URI of the user's Key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyVaultID - The ID of the user's Key vault.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// VirtualMachinesAddDataDiskFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesAddDataDiskFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesAddDataDiskFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesAddDataDiskFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesAddDataDiskFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesApplyArtifactsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesApplyArtifactsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesApplyArtifactsFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesApplyArtifactsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesApplyArtifactsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineSchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineSchedulesExecuteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachineSchedulesExecuteFuture) Result(client VirtualMachineSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineSchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineSchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesClaimFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesClaimFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesClaimFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesClaimFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesClaimFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesCreateOrUpdateFuture) Result(client VirtualMachinesClient) (lvm LabVirtualMachine, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lvm.Response.Response, err = future.GetResult(sender); err == nil && lvm.Response.Response.StatusCode != http.StatusNoContent {
		lvm, err = client.CreateOrUpdateResponder(lvm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesCreateOrUpdateFuture", "Result", lvm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachinesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesDeleteFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesDetachDataDiskFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesDetachDataDiskFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesDetachDataDiskFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesDetachDataDiskFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesDetachDataDiskFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesRedeployFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesRedeployFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesRedeployFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesRedeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesRedeployFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesResizeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesResizeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesResizeFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesResizeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesResizeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesRestartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesRestartFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesStartFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesStopFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesTransferDisksFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesTransferDisksFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesTransferDisksFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesTransferDisksFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesTransferDisksFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesUnClaimFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesUnClaimFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachinesUnClaimFuture) Result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesUnClaimFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesUnClaimFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetwork a virtual network.
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	// VirtualNetworkProperties - The properties of the resource.
	*VirtualNetworkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkProperties != nil {
		objectMap["properties"] = vn.VirtualNetworkProperties
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkProperties VirtualNetworkProperties
				err = json.Unmarshal(*v, &virtualNetworkProperties)
				if err != nil {
					return err
				}
				vn.VirtualNetworkProperties = &virtualNetworkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkFragment a virtual network.
type VirtualNetworkFragment struct {
	// VirtualNetworkPropertiesFragment - The properties of the resource.
	*VirtualNetworkPropertiesFragment `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFragment.
func (vnf VirtualNetworkFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnf.VirtualNetworkPropertiesFragment != nil {
		objectMap["properties"] = vnf.VirtualNetworkPropertiesFragment
	}
	if vnf.Tags != nil {
		objectMap["tags"] = vnf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkFragment struct.
func (vnf *VirtualNetworkFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFragment VirtualNetworkPropertiesFragment
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFragment)
				if err != nil {
					return err
				}
				vnf.VirtualNetworkPropertiesFragment = &virtualNetworkPropertiesFragment
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vnf.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkList the response of a list operation.
type VirtualNetworkList struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkListIterator provides access to a complete listing of VirtualNetwork values.
type VirtualNetworkListIterator struct {
	i    int
	page VirtualNetworkListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListIterator) Response() VirtualNetworkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkListIterator type.
func NewVirtualNetworkListIterator(page VirtualNetworkListPage) VirtualNetworkListIterator {
	return VirtualNetworkListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnl VirtualNetworkList) IsEmpty() bool {
	return vnl.Value == nil || len(*vnl.Value) == 0
}

// virtualNetworkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnl VirtualNetworkList) virtualNetworkListPreparer(ctx context.Context) (*http.Request, error) {
	if vnl.NextLink == nil || len(to.String(vnl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnl.NextLink)))
}

// VirtualNetworkListPage contains a page of VirtualNetwork values.
type VirtualNetworkListPage struct {
	fn  func(context.Context, VirtualNetworkList) (VirtualNetworkList, error)
	vnl VirtualNetworkList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vnl)
	if err != nil {
		return err
	}
	page.vnl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListPage) NotDone() bool {
	return !page.vnl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkListPage) Response() VirtualNetworkList {
	return page.vnl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListPage) Values() []VirtualNetwork {
	if page.vnl.IsEmpty() {
		return nil
	}
	return *page.vnl.Value
}

// Creates a new instance of the VirtualNetworkListPage type.
func NewVirtualNetworkListPage(getNextPage func(context.Context, VirtualNetworkList) (VirtualNetworkList, error)) VirtualNetworkListPage {
	return VirtualNetworkListPage{fn: getNextPage}
}

// VirtualNetworkProperties properties of a virtual network.
type VirtualNetworkProperties struct {
	// AllowedSubnets - The allowed subnets of the virtual network.
	AllowedSubnets *[]Subnet `json:"allowedSubnets,omitempty"`
	// Description - The description of the virtual network.
	Description *string `json:"description,omitempty"`
	// ExternalProviderResourceID - The Microsoft.Network resource identifier of the virtual network.
	ExternalProviderResourceID *string `json:"externalProviderResourceId,omitempty"`
	// ExternalSubnets - READ-ONLY; The external subnet properties.
	ExternalSubnets *[]ExternalSubnet `json:"externalSubnets,omitempty"`
	// SubnetOverrides - The subnet overrides of the virtual network.
	SubnetOverrides *[]SubnetOverride `json:"subnetOverrides,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the virtual network.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// VirtualNetworkPropertiesFragment properties of a virtual network.
type VirtualNetworkPropertiesFragment struct {
	// AllowedSubnets - The allowed subnets of the virtual network.
	AllowedSubnets *[]SubnetFragment `json:"allowedSubnets,omitempty"`
	// Description - The description of the virtual network.
	Description *string `json:"description,omitempty"`
	// ExternalProviderResourceID - The Microsoft.Network resource identifier of the virtual network.
	ExternalProviderResourceID *string `json:"externalProviderResourceId,omitempty"`
	// SubnetOverrides - The subnet overrides of the virtual network.
	SubnetOverrides *[]SubnetOverrideFragment `json:"subnetOverrides,omitempty"`
}

// VirtualNetworksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworksCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworksCreateOrUpdateFuture) Result(client VirtualNetworksClient) (vn VirtualNetwork, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualNetworksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vn.Response.Response, err = future.GetResult(sender); err == nil && vn.Response.Response.StatusCode != http.StatusNoContent {
		vn, err = client.CreateOrUpdateResponder(vn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.VirtualNetworksCreateOrUpdateFuture", "Result", vn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworksDeleteFuture) Result(client VirtualNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualNetworksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualNetworksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WeekDetails properties of a weekly schedule.
type WeekDetails struct {
	// Weekdays - The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
	Weekdays *[]string `json:"weekdays,omitempty"`
	// Time - The time of the day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// WeekDetailsFragment properties of a weekly schedule.
type WeekDetailsFragment struct {
	// Weekdays - The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
	Weekdays *[]string `json:"weekdays,omitempty"`
	// Time - The time of the day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// WindowsOsInfo information about a Windows OS.
type WindowsOsInfo struct {
	// WindowsOsState - The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied). Possible values include: 'NonSysprepped', 'SysprepRequested', 'SysprepApplied'
	WindowsOsState WindowsOsState `json:"windowsOsState,omitempty"`
}

// WindowsOsInfoFragment information about a Windows OS.
type WindowsOsInfoFragment struct {
	// WindowsOsState - The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied). Possible values include: 'NonSysprepped', 'SysprepRequested', 'SysprepApplied'
	WindowsOsState WindowsOsState `json:"windowsOsState,omitempty"`
}
