import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import { Tooltip } from '@patternfly/react-core/dist/js/components/Tooltip/Tooltip';
import styles from '@patternfly/react-styles/css/components/Table/table';
export const BodyCell = (_a) => {
    var { 'data-label': dataLabel = '', className = '', colSpan, component = 'td', isVisible, parentId, textCenter = false, tooltip: tooltipProp = '', onMouseEnter: onMouseEnterProp = () => { }, children, 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    errorText, isValid, isOpen, ariaControls, editableValue, value, name } = _a, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    props = __rest(_a, ['data-label', "className", "colSpan", "component", "isVisible", "parentId", "textCenter", "tooltip", "onMouseEnter", "children", "errorText", "isValid", "isOpen", "ariaControls", "editableValue", "value", "name"]);
    const mappedProps = Object.assign(Object.assign({}, (dataLabel ? { 'data-label': dataLabel } : {})), props);
    const [tooltip, setTooltip] = React.useState('');
    const onMouseEnter = (event) => {
        if (event.target.offsetWidth < event.target.scrollWidth) {
            setTooltip(tooltipProp || event.target.innerHTML);
        }
        else {
            setTooltip('');
        }
        onMouseEnterProp(event);
    };
    const Component = component;
    const cell = (React.createElement(Component, Object.assign({}, mappedProps, { onMouseEnter: onMouseEnter, className: css(className, textCenter && styles.modifiers.center), colSpan: colSpan }), children));
    const bodyCell = tooltip !== '' ? React.createElement(Tooltip, { content: tooltip }, cell) : cell;
    return (parentId !== undefined && colSpan === undefined) || !isVisible ? null : bodyCell;
};
//# sourceMappingURL=BodyCell.js.map