import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/Table/table';
import { Tooltip } from '@patternfly/react-core/dist/js/components/Tooltip/Tooltip';
export const HeaderCell = (_a) => {
    var { className = '', component = 'th', scope = '', textCenter = false, tooltip: tooltipProp = '', onMouseEnter: onMouseEnterProp = () => { }, children, 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    isVisible, dataLabel = '' } = _a, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    props = __rest(_a, ["className", "component", "scope", "textCenter", "tooltip", "onMouseEnter", "children", "isVisible", "dataLabel"]);
    const mappedProps = Object.assign(Object.assign({}, (scope ? { scope } : {})), props);
    const [tooltip, setTooltip] = React.useState('');
    const onMouseEnter = (event) => {
        if (event.target.offsetWidth < event.target.scrollWidth) {
            setTooltip(tooltipProp || event.target.innerHTML);
        }
        else {
            setTooltip('');
        }
        onMouseEnterProp(event);
    };
    const Component = component;
    const cell = (React.createElement(Component, Object.assign({}, mappedProps, { onMouseEnter: onMouseEnter, className: css(className, textCenter && styles.modifiers.center) }), children));
    return tooltip !== '' ? React.createElement(Tooltip, { content: tooltip }, cell) : cell;
};
//# sourceMappingURL=HeaderCell.js.map