import { __rest } from "tslib";
import * as React from 'react';
import { getOUIAProps } from '@patternfly/react-core/dist/js/helpers/ouia';
import { debounce } from '@patternfly/react-core/dist/js/helpers/util';
import styles from '@patternfly/react-styles/css/components/Table/table';
import inlineStyles from '@patternfly/react-styles/css/components/InlineEdit/inline-edit';
import { css } from '@patternfly/react-styles';
export class RowWrapper extends React.Component {
    constructor(props) {
        super(props);
        this.handleScroll = (event) => {
            if (!this._unmounted) {
                this.props.onScroll(event);
            }
        };
        this.handleResize = (event) => {
            if (!this._unmounted) {
                this.props.onResize(event);
            }
        };
        if (props.onScroll) {
            this.handleScroll = debounce(this.handleScroll, 100);
        }
        if (props.onResize) {
            this.handleResize = debounce(this.handleResize, 100);
        }
    }
    componentDidMount() {
        this._unmounted = false;
        if (this.props.onScroll) {
            window.addEventListener('scroll', this.handleScroll);
        }
        if (this.props.onResize) {
            window.addEventListener('resize', this.handleResize);
        }
    }
    componentWillUnmount() {
        this._unmounted = true;
        if (this.props.onScroll) {
            window.removeEventListener('scroll', this.handleScroll);
        }
        if (this.props.onResize) {
            window.removeEventListener('resize', this.handleResize);
        }
    }
    render() {
        const _a = this.props, { 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onScroll, onResize, row: { isExpanded, isEditable }, rowProps, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        trRef, className, ouiaId } = _a, props = __rest(_a, ["onScroll", "onResize", "row", "rowProps", "trRef", "className", "ouiaId"]);
        return (React.createElement("tr", Object.assign({}, props, { ref: trRef, className: css(className, isExpanded !== undefined && styles.tableExpandableRow, isExpanded && styles.modifiers.expanded, isEditable && inlineStyles.modifiers.inlineEditable), hidden: isExpanded !== undefined && !isExpanded }, getOUIAProps('TableRow', ouiaId))));
    }
}
RowWrapper.defaultProps = {
    className: '',
    row: {
        isOpen: undefined,
        isExpanded: undefined,
        isHeightAuto: undefined,
        isEditable: undefined
    },
    rowProps: null
};
//# sourceMappingURL=RowWrapper.js.map