import { __rest } from "tslib";
import * as React from 'react';
import LongArrowAltUpIcon from '@patternfly/react-icons/dist/js/icons/long-arrow-alt-up-icon';
import LongArrowAltDownIcon from '@patternfly/react-icons/dist/js/icons/long-arrow-alt-down-icon';
import ArrowsAltVIcon from '@patternfly/react-icons/dist/js/icons/arrows-alt-v-icon';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/Table/table';
import { SortByDirection } from './Table';
import { TableText } from './TableText';
export const SortColumn = (_a) => {
    var { children = null, className = '', isSortedBy = false, onSort = null, sortDirection = '' } = _a, props = __rest(_a, ["children", "className", "isSortedBy", "onSort", "sortDirection"]);
    let SortedByIcon;
    if (isSortedBy) {
        SortedByIcon = sortDirection === SortByDirection.asc ? LongArrowAltUpIcon : LongArrowAltDownIcon;
    }
    else {
        SortedByIcon = ArrowsAltVIcon;
    }
    return (React.createElement("button", Object.assign({}, props, { className: css(className, styles.tableButton), onClick: event => onSort && onSort(event) }),
        React.createElement("div", { className: css(className, styles.tableButtonContent) },
            React.createElement(TableText, null, children),
            React.createElement("span", { className: css(styles.tableSortIndicator) },
                React.createElement(SortedByIcon, null)))));
};
//# sourceMappingURL=SortColumn.js.map