import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Table/table';
import stylesGrid from '@patternfly/react-styles/css/components/Table/table-grid';
import { getOUIAProps } from '@patternfly/react-core/dist/js/helpers/ouia';
import { DropdownDirection, DropdownPosition } from '@patternfly/react-core/dist/js/components/Dropdown/dropdownConstants';
import inlineStyles from '@patternfly/react-styles/css/components/InlineEdit/inline-edit';
import { css } from '@patternfly/react-styles';
import { Provider } from './base';
import { BodyCell } from './BodyCell';
import { HeaderCell } from './HeaderCell';
import { RowWrapper } from './RowWrapper';
import { BodyWrapper } from './BodyWrapper';
import { toCamel } from './utils';
import { calculateColumns } from './utils/headerUtils';
export var TableGridBreakpoint;
(function (TableGridBreakpoint) {
    TableGridBreakpoint["none"] = "";
    TableGridBreakpoint["grid"] = "grid";
    TableGridBreakpoint["gridMd"] = "grid-md";
    TableGridBreakpoint["gridLg"] = "grid-lg";
    TableGridBreakpoint["gridXl"] = "grid-xl";
    TableGridBreakpoint["grid2xl"] = "grid-2xl";
})(TableGridBreakpoint || (TableGridBreakpoint = {}));
export var TableVariant;
(function (TableVariant) {
    TableVariant["compact"] = "compact";
})(TableVariant || (TableVariant = {}));
export var SortByDirection;
(function (SortByDirection) {
    SortByDirection["asc"] = "asc";
    SortByDirection["desc"] = "desc";
})(SortByDirection || (SortByDirection = {}));
export const TableContext = React.createContext({
    headerData: null,
    headerRows: null,
    rows: []
});
export class Table extends React.Component {
    constructor() {
        super(...arguments);
        this.isSelected = (row) => row.selected === true;
        this.areAllRowsSelected = (rows) => {
            if (rows === undefined || rows.length === 0) {
                return false;
            }
            return rows.every(row => this.isSelected(row) || (row.hasOwnProperty('parent') && !row.showSelect));
        };
    }
    componentDidMount() {
        if (this.props.onRowEdit && process.env.NODE_ENV !== 'production' && !Table.hasWarnBeta) {
            // eslint-disable-next-line no-console
            console.warn('You are using a beta component feature (onRowEdit). These api parts are subject to change in the future.');
            Table.hasWarnBeta = true;
        }
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, caption, header, className, gridBreakPoint, onSort, onSelect, canSelectAll, sortBy, children, actions, actionResolver, areActionsDisabled, onCollapse, onExpand, onRowEdit, rowLabeledBy, dropdownPosition, dropdownDirection, contentId, expandId, variant, rows, cells, bodyWrapper, rowWrapper, borders, role, ouiaId } = _a, props = __rest(_a, ['aria-label', "caption", "header", "className", "gridBreakPoint", "onSort", "onSelect", "canSelectAll", "sortBy", "children", "actions", "actionResolver", "areActionsDisabled", "onCollapse", "onExpand", "onRowEdit", "rowLabeledBy", "dropdownPosition", "dropdownDirection", "contentId", "expandId", "variant", "rows", "cells", "bodyWrapper", "rowWrapper", "borders", "role", "ouiaId"]);
        if (!ariaLabel && !caption && !header && role !== 'presentation') {
            // eslint-disable-next-line no-console
            console.error('Table: Specify at least one of: header, caption, aria-label');
        }
        const headerData = calculateColumns(cells, {
            sortBy,
            onSort,
            onSelect,
            canSelectAll,
            allRowsSelected: onSelect ? this.areAllRowsSelected(rows) : false,
            actions,
            actionResolver,
            areActionsDisabled,
            onCollapse,
            onRowEdit,
            onExpand,
            rowLabeledBy,
            expandId,
            contentId,
            dropdownPosition,
            dropdownDirection,
            firstUserColumnIndex: [onCollapse, onSelect].filter(callback => callback).length
        });
        const table = (React.createElement(TableContext.Provider, { value: {
                headerData,
                headerRows: null,
                rows
            } },
            header,
            React.createElement(Provider, Object.assign({}, props, { "aria-label": ariaLabel, renderers: {
                    body: {
                        wrapper: bodyWrapper || BodyWrapper,
                        row: rowWrapper || RowWrapper,
                        cell: BodyCell
                    },
                    header: {
                        cell: HeaderCell
                    }
                }, columns: headerData, role: role, className: css(styles.table, gridBreakPoint &&
                    stylesGrid.modifiers[toCamel(gridBreakPoint).replace(/-?2xl/, '_2xl')], styles.modifiers[variant], ((onCollapse && variant === TableVariant.compact) || onExpand) && styles.modifiers.expandable, variant === TableVariant.compact && borders === false ? styles.modifiers.noBorderRows : null, className) }, getOUIAProps('Table', ouiaId)),
                caption && React.createElement("caption", null, caption),
                children)));
        if (onRowEdit) {
            return React.createElement("form", { className: css(inlineStyles.inlineEdit) }, table);
        }
        return table;
    }
}
Table.hasWarnBeta = false;
Table.defaultProps = {
    children: null,
    className: '',
    variant: null,
    borders: true,
    rowLabeledBy: 'simple-node',
    expandId: 'expandable-toggle',
    contentId: 'expanded-content',
    dropdownPosition: DropdownPosition.right,
    dropdownDirection: DropdownDirection.down,
    header: undefined,
    caption: undefined,
    'aria-label': undefined,
    gridBreakPoint: TableGridBreakpoint.gridMd,
    role: 'grid',
    canSelectAll: true
};
//# sourceMappingURL=Table.js.map