import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Breadcrumb/breadcrumb';
import { css } from '@patternfly/react-styles';
import { getOUIAProps } from '../../helpers';
export const Breadcrumb = (_a) => {
    var { children = null, className = '', 'aria-label': ariaLabel = 'Breadcrumb', ouiaId } = _a, props = __rest(_a, ["children", "className", 'aria-label', "ouiaId"]);
    return (React.createElement("nav", Object.assign({}, props, { "aria-label": ariaLabel, className: css(styles.breadcrumb, className) }, getOUIAProps('Breadcrumb', ouiaId)),
        React.createElement("ol", { className: css(styles.breadcrumbList) }, children)));
};
//# sourceMappingURL=Breadcrumb.js.map