import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/FormControl/form-control';
import { css } from '@patternfly/react-styles';
import { ValidatedOptions } from '../../helpers/constants';
export class FormSelect extends React.Component {
    constructor(props) {
        super(props);
        this.handleChange = (event) => {
            this.props.onChange(event.currentTarget.value, event);
        };
        if (!props.id && !props['aria-label']) {
            // eslint-disable-next-line no-console
            console.error('FormSelect requires either an id or aria-label to be specified');
        }
    }
    render() {
        const _a = this.props, { children, className, value, validated, isDisabled, isRequired } = _a, props = __rest(_a, ["children", "className", "value", "validated", "isDisabled", "isRequired"]);
        return (React.createElement("select", Object.assign({}, props, { className: css(styles.formControl, className, validated === ValidatedOptions.success && styles.modifiers.success), "aria-invalid": validated === ValidatedOptions.error, onChange: this.handleChange, disabled: isDisabled, required: isRequired, value: value }), children));
    }
}
FormSelect.defaultProps = {
    className: '',
    value: '',
    validated: 'default',
    isDisabled: false,
    isRequired: false,
    onBlur: () => undefined,
    onFocus: () => undefined,
    onChange: () => undefined
};
//# sourceMappingURL=FormSelect.js.map