"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const table_grid_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table-grid"));
const ouia_1 = require("@patternfly/react-core/dist/js/helpers/ouia");
const dropdownConstants_1 = require("@patternfly/react-core/dist/js/components/Dropdown/dropdownConstants");
const inline_edit_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/InlineEdit/inline-edit"));
const react_styles_1 = require("@patternfly/react-styles");
const base_1 = require("./base");
const BodyCell_1 = require("./BodyCell");
const HeaderCell_1 = require("./HeaderCell");
const RowWrapper_1 = require("./RowWrapper");
const BodyWrapper_1 = require("./BodyWrapper");
const utils_1 = require("./utils");
const headerUtils_1 = require("./utils/headerUtils");
var TableGridBreakpoint;
(function (TableGridBreakpoint) {
    TableGridBreakpoint["none"] = "";
    TableGridBreakpoint["grid"] = "grid";
    TableGridBreakpoint["gridMd"] = "grid-md";
    TableGridBreakpoint["gridLg"] = "grid-lg";
    TableGridBreakpoint["gridXl"] = "grid-xl";
    TableGridBreakpoint["grid2xl"] = "grid-2xl";
})(TableGridBreakpoint = exports.TableGridBreakpoint || (exports.TableGridBreakpoint = {}));
var TableVariant;
(function (TableVariant) {
    TableVariant["compact"] = "compact";
})(TableVariant = exports.TableVariant || (exports.TableVariant = {}));
var SortByDirection;
(function (SortByDirection) {
    SortByDirection["asc"] = "asc";
    SortByDirection["desc"] = "desc";
})(SortByDirection = exports.SortByDirection || (exports.SortByDirection = {}));
exports.TableContext = React.createContext({
    headerData: null,
    headerRows: null,
    rows: []
});
class Table extends React.Component {
    constructor() {
        super(...arguments);
        this.isSelected = (row) => row.selected === true;
        this.areAllRowsSelected = (rows) => {
            if (rows === undefined || rows.length === 0) {
                return false;
            }
            return rows.every(row => this.isSelected(row) || (row.hasOwnProperty('parent') && !row.showSelect));
        };
    }
    componentDidMount() {
        if (this.props.onRowEdit && process.env.NODE_ENV !== 'production' && !Table.hasWarnBeta) {
            // eslint-disable-next-line no-console
            console.warn('You are using a beta component feature (onRowEdit). These api parts are subject to change in the future.');
            Table.hasWarnBeta = true;
        }
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, caption, header, className, gridBreakPoint, onSort, onSelect, canSelectAll, sortBy, children, actions, actionResolver, areActionsDisabled, onCollapse, onExpand, onRowEdit, rowLabeledBy, dropdownPosition, dropdownDirection, contentId, expandId, variant, rows, cells, bodyWrapper, rowWrapper, borders, role, ouiaId } = _a, props = tslib_1.__rest(_a, ['aria-label', "caption", "header", "className", "gridBreakPoint", "onSort", "onSelect", "canSelectAll", "sortBy", "children", "actions", "actionResolver", "areActionsDisabled", "onCollapse", "onExpand", "onRowEdit", "rowLabeledBy", "dropdownPosition", "dropdownDirection", "contentId", "expandId", "variant", "rows", "cells", "bodyWrapper", "rowWrapper", "borders", "role", "ouiaId"]);
        if (!ariaLabel && !caption && !header && role !== 'presentation') {
            // eslint-disable-next-line no-console
            console.error('Table: Specify at least one of: header, caption, aria-label');
        }
        const headerData = headerUtils_1.calculateColumns(cells, {
            sortBy,
            onSort,
            onSelect,
            canSelectAll,
            allRowsSelected: onSelect ? this.areAllRowsSelected(rows) : false,
            actions,
            actionResolver,
            areActionsDisabled,
            onCollapse,
            onRowEdit,
            onExpand,
            rowLabeledBy,
            expandId,
            contentId,
            dropdownPosition,
            dropdownDirection,
            firstUserColumnIndex: [onCollapse, onSelect].filter(callback => callback).length
        });
        const table = (React.createElement(exports.TableContext.Provider, { value: {
                headerData,
                headerRows: null,
                rows
            } },
            header,
            React.createElement(base_1.Provider, Object.assign({}, props, { "aria-label": ariaLabel, renderers: {
                    body: {
                        wrapper: bodyWrapper || BodyWrapper_1.BodyWrapper,
                        row: rowWrapper || RowWrapper_1.RowWrapper,
                        cell: BodyCell_1.BodyCell
                    },
                    header: {
                        cell: HeaderCell_1.HeaderCell
                    }
                }, columns: headerData, role: role, className: react_styles_1.css(table_1.default.table, gridBreakPoint &&
                    table_grid_1.default.modifiers[utils_1.toCamel(gridBreakPoint).replace(/-?2xl/, '_2xl')], table_1.default.modifiers[variant], ((onCollapse && variant === TableVariant.compact) || onExpand) && table_1.default.modifiers.expandable, variant === TableVariant.compact && borders === false ? table_1.default.modifiers.noBorderRows : null, className) }, ouia_1.getOUIAProps('Table', ouiaId)),
                caption && React.createElement("caption", null, caption),
                children)));
        if (onRowEdit) {
            return React.createElement("form", { className: react_styles_1.css(inline_edit_1.default.inlineEdit) }, table);
        }
        return table;
    }
}
exports.Table = Table;
Table.hasWarnBeta = false;
Table.defaultProps = {
    children: null,
    className: '',
    variant: null,
    borders: true,
    rowLabeledBy: 'simple-node',
    expandId: 'expandable-toggle',
    contentId: 'expanded-content',
    dropdownPosition: dropdownConstants_1.DropdownPosition.right,
    dropdownDirection: dropdownConstants_1.DropdownDirection.down,
    header: undefined,
    caption: undefined,
    'aria-label': undefined,
    gridBreakPoint: TableGridBreakpoint.gridMd,
    role: 'grid',
    canSelectAll: true
};
//# sourceMappingURL=Table.js.map