/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.RunRootBuildWorkBuildOperationType;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationFiringBuildWorkerExecutor
implements BuildWorkExecutor {
    private final BuildWorkExecutor delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperationFiringBuildWorkerExecutor(BuildWorkExecutor delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void execute(GradleInternal gradle, Collection<? super Throwable> failures) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new ExecuteTasks(gradle, failures));
    }

    private class ExecuteTasks
    implements RunnableBuildOperation {
        private final GradleInternal gradle;
        private final Collection<? super Throwable> taskFailures;

        public ExecuteTasks(GradleInternal gradle, Collection<? super Throwable> taskFailures) {
            this.gradle = gradle;
            this.taskFailures = taskFailures;
        }

        public void run(BuildOperationContext context) {
            ArrayList failures = new ArrayList();
            BuildOperationFiringBuildWorkerExecutor.this.delegate.execute(this.gradle, failures);
            if (!failures.isEmpty()) {
                context.failed((Throwable)failures.get(0));
            }
            this.taskFailures.addAll(failures);
        }

        public BuildOperationDescriptor.Builder description() {
            BuildOperationDescriptor.Builder builder = BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Run tasks"));
            if (this.gradle.getParent() == null) {
                builder.operationType(BuildOperationCategory.RUN_WORK_ROOT_BUILD);
                long buildStartTime = ((BuildRequestMetaData)this.gradle.getServices().get(BuildRequestMetaData.class)).getStartTime();
                builder.details((Object)new RunRootBuildWorkBuildOperationType.Details(buildStartTime));
            } else {
                builder.operationType(BuildOperationCategory.RUN_WORK);
            }
            builder.totalProgress(this.gradle.getTaskGraph().size());
            return builder;
        }
    }
}

