/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ThreadDumper {
    private static final Comparator<ThreadInfo> THREAD_INFO_COMPARATOR = Comparator.comparing(o1 -> ThreadDumper.isEDT(o1.getThreadName())).thenComparing(o -> o.getThreadState() == Thread.State.RUNNABLE).thenComparingInt(o -> o.getStackTrace().length).reversed();

    @NotNull
    public static String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        ThreadDumper.dumpThreadInfos(ThreadDumper.getThreadInfos(ManagementFactory.getThreadMXBean()), writer);
        String string2 = writer.toString();
        if (string2 == null) {
            ThreadDumper.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    private static ThreadInfo[] getThreadInfos(@NotNull ThreadMXBean threadMXBean) {
        ThreadInfo[] threads;
        if (threadMXBean == null) {
            ThreadDumper.$$$reportNull$$$0(5);
        }
        try {
            threads = ThreadDumper.sort(threadMXBean.dumpAllThreads(false, false));
        }
        catch (Exception ignored) {
            threads = ThreadDumper.sort(threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE));
        }
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(6);
        }
        return threads;
    }

    public static boolean isEDT(@NotNull ThreadInfo info2) {
        if (info2 == null) {
            ThreadDumper.$$$reportNull$$$0(7);
        }
        return ThreadDumper.isEDT(info2.getThreadName());
    }

    public static boolean isEDT(@NotNull String threadName) {
        if (threadName == null) {
            ThreadDumper.$$$reportNull$$$0(8);
        }
        return threadName.startsWith("AWT-EventQueue");
    }

    private static StackTraceElement[] dumpThreadInfos(@NotNull ThreadInfo[] threadInfo, @NotNull Writer f) {
        if (threadInfo == null) {
            ThreadDumper.$$$reportNull$$$0(9);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(10);
        }
        StackTraceElement[] edtStack = null;
        for (ThreadInfo info2 : threadInfo) {
            if (info2 == null) continue;
            if (ThreadDumper.isEDT(info2)) {
                edtStack = info2.getStackTrace();
            }
            ThreadDumper.dumpThreadInfo(info2, f);
        }
        return edtStack;
    }

    @NotNull
    private static ThreadInfo[] sort(@NotNull ThreadInfo[] threads) {
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(11);
        }
        Arrays.sort(threads, THREAD_INFO_COMPARATOR);
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(12);
        }
        return threads;
    }

    private static void dumpThreadInfo(@NotNull ThreadInfo info2, @NotNull Writer f) {
        if (info2 == null) {
            ThreadDumper.$$$reportNull$$$0(13);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(14);
        }
        ThreadDumper.dumpCallStack(info2, f, info2.getStackTrace());
    }

    private static void dumpCallStack(@NotNull ThreadInfo info2, @NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        if (info2 == null) {
            ThreadDumper.$$$reportNull$$$0(15);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(16);
        }
        if (stackTraceElements == null) {
            ThreadDumper.$$$reportNull$$$0(17);
        }
        try {
            StringBuilder sb = new StringBuilder("\"").append(info2.getThreadName()).append("\"");
            sb.append(" prio=0 tid=0x0 nid=0x0 ").append(ThreadDumper.getReadableState(info2.getThreadState())).append("\n");
            sb.append("     java.lang.Thread.State: ").append((Object)info2.getThreadState()).append("\n");
            if (info2.getLockName() != null) {
                sb.append(" on ").append(info2.getLockName());
            }
            if (info2.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId());
            }
            if (info2.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info2.isInNative()) {
                sb.append(" (in native)");
            }
            f.write(sb + "\n");
            ThreadDumper.printStackTrace(f, stackTraceElements);
            f.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printStackTrace(@NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(21);
        }
        if (stackTraceElements == null) {
            ThreadDumper.$$$reportNull$$$0(22);
        }
        try {
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getReadableState(@NotNull Thread.State state) {
        if (state == null) {
            ThreadDumper.$$$reportNull$$$0(25);
        }
        switch (state) {
            case BLOCKED: {
                return "blocked";
            }
            case TIMED_WAITING: 
            case WAITING: {
                return "waiting on condition";
            }
            case RUNNABLE: {
                return "runnable";
            }
            case NEW: {
                return "new";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/ThreadDumper";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadMXBean";
                break;
            }
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullThreadDump";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsToString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpEdtStackTrace";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadInfos";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/ThreadDumper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDumpInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadDumpInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getThreadInfos";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEDT";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadInfos";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadInfo";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "dumpCallStack";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "printStackTrace";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getEdtStackForCrash";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReadableState";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

