/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageExtension;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceContributor;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceProviderBean;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceService;
import org.jetbrains.kotlin.com.intellij.psi.ReferenceRange;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import org.jetbrains.kotlin.com.intellij.util.ProcessingContext;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME.getName());
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = ContainerUtil.newConcurrentMap();

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(Language language) {
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl();
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguageOrAny(language)) {
            contributor.registerReferenceProviders(registrar);
        }
        List<PsiReferenceProviderBean> referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguageOrAny(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern<PsiElement> pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                @Override
                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (context2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement(element, context2);
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReferencesByElement";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReferencesByElement";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        registrar.markInitialized();
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceRegistrarImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        PsiReferenceRegistrarImpl registrar;
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(1);
        }
        if ((registrar = this.myRegistrars.get(language)) == null) {
            ReferenceProvidersRegistryImpl referenceProvidersRegistryImpl = this;
            synchronized (referenceProvidersRegistryImpl) {
                registrar = this.myRegistrars.get(language);
                if (registrar == null) {
                    registrar = ReferenceProvidersRegistryImpl.createRegistrar(language);
                    this.myRegistrars.put(language, registrar);
                }
            }
        }
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceRegistrarImpl;
    }

    @Override
    @NotNull
    protected PsiReference[] doGetReferencesFromProviders(@NotNull PsiElement context2, @NotNull PsiReferenceService.Hints hints) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers;
        MultiMap<Double, PsiReference[]> allReferencesMap;
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(3);
        }
        if (hints == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(4);
        }
        if ((allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context2, providers = this.getRegistrar(context2.getLanguage()).getPairsByElement(context2, hints))).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List<PsiReference> result2 = ContainerUtil.newSmartList();
        double maxPriority = ReferenceProvidersRegistryImpl.getMaxPriority(allReferencesMap.keySet());
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences(allReferencesMap.get(maxPriority));
        ContainerUtil.addAllNotNull(result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull(result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static MultiMap<Double, PsiReference[]> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context2, @NotNull List<? extends ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(7);
        }
        if (providers == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(8);
        }
        MultiMap<Double, PsiReference[]> map2 = new MultiMap<Double, PsiReference[]>();
        for (ProviderBinding.ProviderInfo<ProcessingContext> providerInfo : providers) {
            PsiReference[] refs = ReferenceProvidersRegistryImpl.getReferences(context2, providerInfo);
            if ((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal()) && Registry.is("ide.check.reference.provider.underlying.element")) {
                ReferenceProvidersRegistryImpl.assertReferenceUnderlyingElement(context2, refs, providerInfo.provider);
            }
            if (refs.length <= 0) continue;
            map2.putValue(providerInfo.priority, refs);
        }
        MultiMap<Double, PsiReference[]> multiMap = map2;
        if (multiMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    private static void assertReferenceUnderlyingElement(@NotNull PsiElement context2, PsiReference[] refs, PsiReferenceProvider provider) {
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(10);
        }
        for (PsiReference reference : refs) {
            if (reference != null) assert (reference.getElement() == context2) : "reference " + reference + " was created for " + context2 + " but target " + reference.getElement() + ", provider " + provider;
        }
    }

    @NotNull
    private static PsiReference[] getReferences(@NotNull PsiElement context2, @NotNull ProviderBinding.ProviderInfo<? extends ProcessingContext> providerInfo) {
        PsiReference[] psiReferenceArray;
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(11);
        }
        if (providerInfo == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(12);
        }
        try {
            psiReferenceArray = providerInfo.provider.getReferencesByElement(context2, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(14);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(13);
        }
        return psiReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull MultiMap<Double, PsiReference[]> allReferencesMap, double maxPriority, @NotNull List<? extends PsiReference> list2) {
        if (allReferencesMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(15);
        }
        if (list2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(16);
        }
        List<PsiReference> result2 = ContainerUtil.newSmartList();
        for (Map.Entry<Double, Collection<PsiReference[]>> entry : allReferencesMap.entrySet()) {
            if (maxPriority == entry.getKey()) continue;
            for (PsiReference[] references : entry.getValue()) {
                void maxPriorityRefs;
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges((List<? extends PsiReference>)maxPriorityRefs, references)) continue;
                ContainerUtil.addAllNotNull(result2, references);
            }
        }
        List<PsiReference> list3 = result2;
        if (list3 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(17);
        }
        return list3;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<? extends PsiReference> higherPriorityRefs, @NotNull PsiReference[] lowerPriorityRefs) {
        if (higherPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(18);
        }
        if (lowerPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(19);
        }
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference psiReference : higherPriorityRefs) {
                if (psiReference == null || !ReferenceRange.containsRangeInElement(psiReference, ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            List<PsiReference> list2 = Collections.emptyList();
            if (list2 == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(20);
            }
            return list2;
        }
        List<PsiReference> list3 = ContainerUtil.newSmartList();
        for (PsiReference[] reference : references) {
            ContainerUtil.addAllNotNull(list3, reference);
        }
        List<PsiReference> list4 = list3;
        if (list4 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(21);
        }
        return list4;
    }

    private static double getMaxPriority(@NotNull Set<Double> doubles) {
        if (doubles == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(22);
        }
        double maxPriority = -100.0;
        for (Double aDouble : doubles) {
            if (!(aDouble > maxPriority)) continue;
            maxPriority = aDouble;
        }
        return maxPriority;
    }

    @Deprecated
    public static void disableUnderlyingElementChecks(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(23);
        }
        Registry.get("ide.check.reference.provider.underlying.element").setValue(false, parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allReferencesMap";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPriorityRefs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "higherPriorityRefs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerPriorityRefs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubles";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegistrar";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrar";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetReferencesFromProviders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowerPriorityReferences";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferencesFromProviders";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertReferenceUnderlyingElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLowerPriorityReferences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "haveNotIntersectedTextRanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMaxPriority";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "disableUnderlyingElementChecks";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

