/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.components.AbstractTypeCheckerContextForConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintIncorporator;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintInjector$TypeCheckerContext$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.model.CapturedTypeFromSubtyping;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstrainingTypeIsError;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.IncorporationConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.InitialConstraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.MutableVariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.CapturedTypeMarker;
import org.jetbrains.kotlin.types.model.DefinitelyNotNullTypeMarker;
import org.jetbrains.kotlin.types.model.DynamicTypeMarker;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.RawTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariance;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0014\u0010\"\u001a\u00020#*\u00020\u00142\u0006\u0010$\u001a\u00020\u0016H\u0002J\u001c\u0010%\u001a\u00020#*\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;", "", "constraintIncorporator", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;", "typeApproximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "ALLOWED_DEPTH_DELTA_FOR_INCORPORATION", "", "getConstraintIncorporator", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;", "getKotlinTypeRefiner", "()Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "addInitialEqualityConstraint", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "a", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "b", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintPosition;", "addInitialSubtypeConstraint", "lowerType", "upperType", "addSubTypeConstraintAndIncorporateIt", "incorporatePosition", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "updateAllowedTypeDepth", "initialType", "isAllowedType", "", "type", "shouldWeSkipConstraint", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "constraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "Context", "TypeCheckerContext", "resolution"})
public final class ConstraintInjector {
    private final int ALLOWED_DEPTH_DELTA_FOR_INCORPORATION = 1;
    @NotNull
    private final ConstraintIncorporator constraintIncorporator;
    @NotNull
    private final AbstractTypeApproximator typeApproximator;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;

    public final void addInitialSubtypeConstraint(@NotNull Context c, @NotNull KotlinTypeMarker lowerType, @NotNull KotlinTypeMarker upperType, @NotNull ConstraintPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)lowerType, (String)"lowerType");
        Intrinsics.checkParameterIsNotNull((Object)upperType, (String)"upperType");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        InitialConstraint initialConstraint = new InitialConstraint(lowerType, upperType, ConstraintKind.UPPER, position);
        IncorporationConstraintPosition incorporationPosition = new IncorporationConstraintPosition(position, initialConstraint);
        c.addInitialConstraint(initialConstraint);
        this.updateAllowedTypeDepth(c, lowerType);
        this.updateAllowedTypeDepth(c, upperType);
        this.addSubTypeConstraintAndIncorporateIt(c, lowerType, upperType, incorporationPosition);
    }

    public final void addInitialEqualityConstraint(@NotNull Context c, @NotNull KotlinTypeMarker a, @NotNull KotlinTypeMarker b, @NotNull ConstraintPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        InitialConstraint initialConstraint = new InitialConstraint(a, b, ConstraintKind.EQUALITY, position);
        IncorporationConstraintPosition incorporationPosition = new IncorporationConstraintPosition(position, initialConstraint);
        c.addInitialConstraint(initialConstraint);
        this.updateAllowedTypeDepth(c, a);
        this.updateAllowedTypeDepth(c, b);
        this.addSubTypeConstraintAndIncorporateIt(c, a, b, incorporationPosition);
        this.addSubTypeConstraintAndIncorporateIt(c, b, a, incorporationPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSubTypeConstraintAndIncorporateIt(Context c, KotlinTypeMarker lowerType, KotlinTypeMarker upperType, IncorporationConstraintPosition incorporatePosition) {
        Stack possibleNewConstraints = new Stack();
        TypeCheckerContext typeCheckerContext = new TypeCheckerContext(c, incorporatePosition, lowerType, upperType, possibleNewConstraints);
        typeCheckerContext.runIsSubtypeOf(lowerType, upperType);
        while (true) {
            Constraint constraint;
            MutableVariableWithConstraints constraints;
            void typeVariable2;
            Object object = possibleNewConstraints;
            boolean bl = false;
            if (!(!object.isEmpty())) break;
            Pair pair = (Pair)possibleNewConstraints.pop();
            object = (TypeVariableMarker)pair.component1();
            Constraint constraint2 = (Constraint)pair.component2();
            if (this.shouldWeSkipConstraint(c, (TypeVariableMarker)typeVariable2, constraint2)) continue;
            if (c.getNotFixedTypeVariables().get(MarkerExtensionsKt.freshTypeConstructor((TypeVariableMarker)typeVariable2, c)) == null) {
                Void void_ = typeCheckerContext.fixedTypeVariable((TypeVariableMarker)typeVariable2);
                throw null;
            }
            if (constraints.addConstraint(constraint2) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            Constraint it = constraint;
            boolean bl4 = false;
            this.constraintIncorporator.incorporate(typeCheckerContext, (TypeVariableMarker)typeVariable2, it);
        }
    }

    private final void updateAllowedTypeDepth(Context c, KotlinTypeMarker initialType) {
        boolean bl = false;
        boolean bl2 = false;
        Context $this$with = c;
        boolean bl3 = false;
        int n = c.getMaxTypeDepthFromInitialConstraints();
        int n2 = $this$with.typeDepth(initialType);
        Context context2 = c;
        boolean bl4 = false;
        int n3 = Math.max(n, n2);
        context2.setMaxTypeDepthFromInitialConstraints(n3);
    }

    private final boolean shouldWeSkipConstraint(@NotNull Context $this$shouldWeSkipConstraint, TypeVariableMarker typeVariable2, Constraint constraint) {
        boolean bl = constraint.getKind() != ConstraintKind.EQUALITY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        KotlinTypeMarker constraintType = constraint.getType();
        if (!this.isAllowedType($this$shouldWeSkipConstraint, constraintType)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)$this$shouldWeSkipConstraint.typeConstructor(constraintType), (Object)$this$shouldWeSkipConstraint.freshTypeConstructor(typeVariable2))) {
            return !$this$shouldWeSkipConstraint.isMarkedNullable($this$shouldWeSkipConstraint.lowerBoundIfFlexible(constraintType)) || constraint.getKind() != ConstraintKind.LOWER;
        }
        return constraint.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition && constraint.getKind() == ConstraintKind.UPPER && $this$shouldWeSkipConstraint.isNullableAny(constraintType);
    }

    private final boolean isAllowedType(@NotNull Context $this$isAllowedType, KotlinTypeMarker type2) {
        return $this$isAllowedType.typeDepth(type2) <= $this$isAllowedType.getMaxTypeDepthFromInitialConstraints() + this.ALLOWED_DEPTH_DELTA_FOR_INCORPORATION;
    }

    @NotNull
    public final ConstraintIncorporator getConstraintIncorporator() {
        return this.constraintIncorporator;
    }

    @NotNull
    public final AbstractTypeApproximator getTypeApproximator() {
        return this.typeApproximator;
    }

    @NotNull
    public final KotlinTypeRefiner getKotlinTypeRefiner() {
        return this.kotlinTypeRefiner;
    }

    public ConstraintInjector(@NotNull ConstraintIncorporator constraintIncorporator, @NotNull AbstractTypeApproximator typeApproximator, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkParameterIsNotNull((Object)constraintIncorporator, (String)"constraintIncorporator");
        Intrinsics.checkParameterIsNotNull((Object)typeApproximator, (String)"typeApproximator");
        Intrinsics.checkParameterIsNotNull((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.constraintIncorporator = constraintIncorporator;
        this.typeApproximator = typeApproximator;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
        this.ALLOWED_DEPTH_DELTA_FOR_INCORPORATION = 1;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH&R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0018\u0010\f\u001a\u00020\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "allTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "getAllTypeVariables", "()Ljava/util/Map;", "fixedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "getFixedTypeVariables", "maxTypeDepthFromInitialConstraints", "", "getMaxTypeDepthFromInitialConstraints", "()I", "setMaxTypeDepthFromInitialConstraints", "(I)V", "notFixedTypeVariables", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/MutableVariableWithConstraints;", "getNotFixedTypeVariables", "addError", "", "error", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "addInitialConstraint", "initialConstraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/InitialConstraint;", "resolution"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        @NotNull
        public Map<TypeConstructorMarker, TypeVariableMarker> getAllTypeVariables();

        public int getMaxTypeDepthFromInitialConstraints();

        public void setMaxTypeDepthFromInitialConstraints(int var1);

        @NotNull
        public Map<TypeConstructorMarker, MutableVariableWithConstraints> getNotFixedTypeVariables();

        @NotNull
        public Map<TypeConstructorMarker, KotlinTypeMarker> getFixedTypeVariables();

        public void addInitialConstraint(@NotNull InitialConstraint var1);

        public void addError(@NotNull KotlinCallDiagnostic var1);

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static boolean identicalArguments(Context $this, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return TypeSystemInferenceExtensionContext.DefaultImpls.identicalArguments($this, a, b);
            }

            public static boolean anySuperTypeConstructor(Context $this, @NotNull KotlinTypeMarker $this$anySuperTypeConstructor, @NotNull Function1<? super TypeConstructorMarker, Boolean> predicate) {
                Intrinsics.checkParameterIsNotNull((Object)$this$anySuperTypeConstructor, (String)"$this$anySuperTypeConstructor");
                Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
                return TypeSystemInferenceExtensionContext.DefaultImpls.anySuperTypeConstructor($this, $this$anySuperTypeConstructor, predicate);
            }

            @Nullable
            public static List<SimpleTypeMarker> fastCorrespondingSupertypes(Context $this, @NotNull SimpleTypeMarker $this$fastCorrespondingSupertypes, @NotNull TypeConstructorMarker constructor) {
                Intrinsics.checkParameterIsNotNull((Object)$this$fastCorrespondingSupertypes, (String)"$this$fastCorrespondingSupertypes");
                Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.fastCorrespondingSupertypes($this, $this$fastCorrespondingSupertypes, constructor);
            }

            @NotNull
            public static TypeArgumentMarker get(Context $this, @NotNull TypeArgumentListMarker $this$get, int index2) {
                Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
                return TypeSystemInferenceExtensionContext.DefaultImpls.get($this, $this$get, index2);
            }

            @Nullable
            public static TypeArgumentMarker getArgumentOrNull(Context $this, @NotNull SimpleTypeMarker $this$getArgumentOrNull, int index2) {
                Intrinsics.checkParameterIsNotNull((Object)$this$getArgumentOrNull, (String)"$this$getArgumentOrNull");
                return TypeSystemInferenceExtensionContext.DefaultImpls.getArgumentOrNull($this, $this$getArgumentOrNull, index2);
            }

            public static boolean hasFlexibleNullability(Context $this, @NotNull KotlinTypeMarker $this$hasFlexibleNullability) {
                Intrinsics.checkParameterIsNotNull((Object)$this$hasFlexibleNullability, (String)"$this$hasFlexibleNullability");
                return TypeSystemInferenceExtensionContext.DefaultImpls.hasFlexibleNullability($this, $this$hasFlexibleNullability);
            }

            public static boolean isCapturedType(Context $this, @NotNull KotlinTypeMarker $this$isCapturedType) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isCapturedType, (String)"$this$isCapturedType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedType($this, $this$isCapturedType);
            }

            public static boolean isClassType(Context $this, @NotNull SimpleTypeMarker $this$isClassType) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isClassType, (String)"$this$isClassType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isClassType($this, $this$isClassType);
            }

            public static boolean isDefinitelyNotNullType(Context $this, @NotNull KotlinTypeMarker $this$isDefinitelyNotNullType) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isDefinitelyNotNullType, (String)"$this$isDefinitelyNotNullType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyNotNullType($this, $this$isDefinitelyNotNullType);
            }

            public static boolean isDynamic(Context $this, @NotNull KotlinTypeMarker $this$isDynamic) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isDynamic, (String)"$this$isDynamic");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDynamic($this, $this$isDynamic);
            }

            public static boolean isFlexible(Context $this, @NotNull KotlinTypeMarker $this$isFlexible) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isFlexible, (String)"$this$isFlexible");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexible($this, $this$isFlexible);
            }

            public static boolean isIntegerLiteralType(Context $this, @NotNull SimpleTypeMarker $this$isIntegerLiteralType) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isIntegerLiteralType, (String)"$this$isIntegerLiteralType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isIntegerLiteralType($this, $this$isIntegerLiteralType);
            }

            public static boolean isNothing(Context $this, @NotNull KotlinTypeMarker $this$isNothing) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isNothing, (String)"$this$isNothing");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNothing($this, $this$isNothing);
            }

            public static boolean isNullableAny(Context $this, @NotNull KotlinTypeMarker $this$isNullableAny) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isNullableAny, (String)"$this$isNullableAny");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableAny($this, $this$isNullableAny);
            }

            public static boolean isNullableNothing(Context $this, @NotNull KotlinTypeMarker $this$isNullableNothing) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isNullableNothing, (String)"$this$isNullableNothing");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableNothing($this, $this$isNullableNothing);
            }

            public static boolean isSimpleType(Context $this, @NotNull KotlinTypeMarker $this$isSimpleType) {
                Intrinsics.checkParameterIsNotNull((Object)$this$isSimpleType, (String)"$this$isSimpleType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isSimpleType($this, $this$isSimpleType);
            }

            @NotNull
            public static SimpleTypeMarker lowerBoundIfFlexible(Context $this, @NotNull KotlinTypeMarker $this$lowerBoundIfFlexible) {
                Intrinsics.checkParameterIsNotNull((Object)$this$lowerBoundIfFlexible, (String)"$this$lowerBoundIfFlexible");
                return TypeSystemInferenceExtensionContext.DefaultImpls.lowerBoundIfFlexible($this, $this$lowerBoundIfFlexible);
            }

            public static int size(Context $this, @NotNull TypeArgumentListMarker $this$size) {
                Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"$this$size");
                return TypeSystemInferenceExtensionContext.DefaultImpls.size($this, $this$size);
            }

            @NotNull
            public static TypeConstructorMarker typeConstructor(Context $this, @NotNull KotlinTypeMarker $this$typeConstructor) {
                Intrinsics.checkParameterIsNotNull((Object)$this$typeConstructor, (String)"$this$typeConstructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeConstructor($this, $this$typeConstructor);
            }

            public static int typeDepth(Context $this, @NotNull KotlinTypeMarker $this$typeDepth) {
                Intrinsics.checkParameterIsNotNull((Object)$this$typeDepth, (String)"$this$typeDepth");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeDepth($this, $this$typeDepth);
            }

            @NotNull
            public static SimpleTypeMarker upperBoundIfFlexible(Context $this, @NotNull KotlinTypeMarker $this$upperBoundIfFlexible) {
                Intrinsics.checkParameterIsNotNull((Object)$this$upperBoundIfFlexible, (String)"$this$upperBoundIfFlexible");
                return TypeSystemInferenceExtensionContext.DefaultImpls.upperBoundIfFlexible($this, $this$upperBoundIfFlexible);
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\bF\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u00a2\u0006\u0002\u0010\u0010J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\tH\u0016J\u0018\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0016J \u00100\u001a\u00020'2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\t2\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020'2\u0006\u0010.\u001a\u00020)2\u0006\u00106\u001a\u00020\tH\u0016J\t\u00107\u001a\u000208H\u0096\u0001J\u0018\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020)H\u0016J\u001b\u0010<\u001a\u0004\u0018\u0001082\u0006\u0010*\u001a\u0002082\u0006\u0010=\u001a\u00020>H\u0096\u0001J\u0013\u0010?\u001a\u0004\u0018\u00010\t2\u0006\u0010*\u001a\u00020\tH\u0096\u0001J1\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\t0E2\b\u00101\u001a\u0004\u0018\u00010\t2\u0006\u0010F\u001a\u00020>H\u0096\u0001J\t\u0010G\u001a\u00020HH\u0096\u0001J\u0019\u0010I\u001a\u00020\t2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020)H\u0096\u0001J\u0019\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u0002082\u0006\u0010O\u001a\u000208H\u0096\u0001J'\u0010P\u001a\u0002082\u0006\u0010L\u001a\u00020)2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020C0E2\u0006\u0010R\u001a\u00020 H\u0096\u0001J\u0011\u0010S\u001a\u00020C2\u0006\u0010T\u001a\u00020UH\u0096\u0001J\u0011\u0010V\u001a\u00020W2\u0006\u0010.\u001a\u00020\u000eH\u0096\u0001J\u0019\u0010X\u001a\u00020C2\u0006\u0010*\u001a\u00020\t2\u0006\u0010Y\u001a\u00020ZH\u0096\u0001J\u0019\u0010[\u001a\u0004\u0018\u0001082\f\u0010\\\u001a\b\u0012\u0004\u0012\u0002080EH\u0096\u0001J\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u000eJ\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\u000f0E2\u0006\u0010.\u001a\u00020\u000eH\u0016J\u0012\u0010a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010b\u001a\u00020)H\u0016J\u0019\u0010c\u001a\u00020 2\u0006\u0010:\u001a\u0002082\u0006\u0010;\u001a\u000208H\u0096\u0001J\u0017\u0010d\u001a\u00020\t2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\t0EH\u0096\u0001J\u0017\u0010d\u001a\u0002082\f\u0010e\u001a\b\u0012\u0004\u0012\u0002080EH\u0096\u0001J\u0010\u0010f\u001a\u00020 2\u0006\u0010*\u001a\u00020\tH\u0002J\u0019\u0010g\u001a\u00020 2\u0006\u0010h\u001a\u00020)2\u0006\u0010i\u001a\u00020)H\u0096\u0001J\u0010\u0010j\u001a\u00020 2\u0006\u0010*\u001a\u000208H\u0016J\u0011\u0010k\u001a\u00020\u00172\u0006\u0010l\u001a\u00020 H\u0096\u0001J\t\u0010m\u001a\u000208H\u0096\u0001J\t\u0010n\u001a\u000208H\u0096\u0001J\t\u0010o\u001a\u000208H\u0096\u0001J\u0010\u0010p\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0016J\u0010\u0010q\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0016J\b\u0010r\u001a\u00020KH\u0002J\u0016\u0010s\u001a\u00020'2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ\u0010\u0010t\u001a\u00020u2\u0006\u0010*\u001a\u000208H\u0016J\u001d\u0010v\u001a\u00020H2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\t0xH\u0096\u0001J!\u0010y\u001a\u00020 *\u00020\t2\u0012\u0010z\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020 0{H\u0096\u0001J\r\u0010|\u001a\u00020}*\u00020\tH\u0096\u0001J\r\u0010~\u001a\u00020\u007f*\u000208H\u0096\u0001J\u0010\u0010\u0080\u0001\u001a\u0004\u0018\u00010A*\u000208H\u0096\u0001J\u0011\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001*\u000208H\u0096\u0001J\u0012\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001*\u00030\u0085\u0001H\u0096\u0001J\u0011\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0085\u0001*\u00020\tH\u0096\u0001J\u0012\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001*\u00030\u0085\u0001H\u0096\u0001J\u0010\u0010\u0089\u0001\u001a\u0004\u0018\u000108*\u00020\tH\u0096\u0001J\u000e\u0010\u008a\u0001\u001a\u00020C*\u00020\tH\u0096\u0001J\u000e\u0010\u008b\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\r\u0010F\u001a\u00020>*\u00020AH\u0096\u0001J\"\u0010\u008c\u0001\u001a\u00020 *\u00020\t2\u0012\u0010z\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020 0{H\u0096\u0001J\u000e\u0010\u008d\u0001\u001a\u000208*\u00020\u000eH\u0096\u0001J\u001e\u0010\u008e\u0001\u001a\n\u0012\u0004\u0012\u000208\u0018\u00010E*\u0002082\u0006\u0010L\u001a\u00020)H\u0096\u0001J\u000e\u0010\u008f\u0001\u001a\u00020)*\u00020\u000eH\u0096\u0001J\u0017\u0010\u0090\u0001\u001a\u00020C*\u00020\u007f2\u0007\u0010\u0091\u0001\u001a\u00020}H\u0096\u0003J\u000e\u0010\u0092\u0001\u001a\u00020\t*\u00020)H\u0096\u0001J\u0017\u0010\u0093\u0001\u001a\u00020C*\u00020\t2\u0007\u0010\u0091\u0001\u001a\u00020}H\u0096\u0001J\u0019\u0010\u0094\u0001\u001a\u0004\u0018\u00010C*\u0002082\u0007\u0010\u0091\u0001\u001a\u00020}H\u0096\u0001J\u0017\u0010\u0095\u0001\u001a\u00020U*\u00020)2\u0007\u0010\u0091\u0001\u001a\u00020}H\u0096\u0001J\u000e\u0010\u0096\u0001\u001a\u00020\t*\u00020CH\u0096\u0001J\u000e\u0010\u0097\u0001\u001a\u00020)*\u00020UH\u0096\u0001J\u0017\u0010\u0098\u0001\u001a\u00020\t*\u00020U2\u0007\u0010\u0091\u0001\u001a\u00020}H\u0096\u0001J\u000e\u0010\u0099\u0001\u001a\u00020Z*\u00020CH\u0096\u0001J\u000e\u0010\u0099\u0001\u001a\u00020Z*\u00020UH\u0096\u0001J\u000e\u0010\u009a\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u009b\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u009c\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u009d\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u009e\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u009f\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00a0\u0001\u001a\u00020 *\u000208H\u0096\u0001J\u000e\u0010\u00a1\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00a2\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00a3\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00a4\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00a5\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00a6\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00a6\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00a7\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00a8\u0001\u001a\u00020 *\u000208H\u0096\u0001J\u000e\u0010\u00a9\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00aa\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00ab\u0001\u001a\u00020 *\u000208H\u0096\u0001J\u000e\u0010\u00ac\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00ad\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010\u00ae\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00af\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00b0\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00b1\u0001\u001a\u00020 *\u000208H\u0096\u0001J\u000e\u0010\u00b2\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00b3\u0001\u001a\u00020 *\u000208H\u0096\u0001J\u000e\u0010\u00b4\u0001\u001a\u00020 *\u00020CH\u0096\u0001J\u000e\u0010\u00b5\u0001\u001a\u00020 *\u000208H\u0096\u0001J\u000e\u0010\u00b6\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00b7\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000e\u0010\u00b8\u0001\u001a\u00020 *\u00020)H\u0096\u0001J\u000e\u0010N\u001a\u000208*\u00030\u0085\u0001H\u0096\u0001J\u000e\u0010\u00b9\u0001\u001a\u000208*\u00020\tH\u0096\u0001J\u000f\u00101\u001a\u0004\u0018\u00010\t*\u00020AH\u0096\u0001J\u000e\u0010\u00ba\u0001\u001a\u00020\t*\u00020\tH\u0096\u0001J\u000e\u0010\u00bb\u0001\u001a\u000208*\u000208H\u0096\u0001J\u000e\u0010\u00bc\u0001\u001a\u00020 *\u00020\tH\u0096\u0001J\u000f\u0010\u00bd\u0001\u001a\u000208*\u00030\u0082\u0001H\u0096\u0001J\u000e\u0010\u00be\u0001\u001a\u00020}*\u00020)H\u0096\u0001J\u0014\u0010\u00bf\u0001\u001a\b\u0012\u0004\u0012\u00020\t0\u0012*\u000208H\u0096\u0001J\u000e\u0010\u00c0\u0001\u001a\u00020\t*\u00020\tH\u0096\u0001J\u000e\u0010\u00c1\u0001\u001a\u00020\t*\u00020\tH\u0096\u0001J\u001d\u0010\u00c2\u0001\u001a\u000208*\u0002082\r\u0010\u00c3\u0001\u001a\b\u0012\u0004\u0012\u00020C0EH\u0096\u0001J\u0016\u0010\u00c4\u0001\u001a\u00020\t*\u00020H2\u0006\u0010*\u001a\u00020\tH\u0096\u0001J\u0016\u0010\u00c5\u0001\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\t0\u0012H\u0096\u0001J\u000e\u0010\u00c6\u0001\u001a\u00020}*\u00020\u007fH\u0096\u0001J\u0014\u0010\u00c7\u0001\u001a\b\u0012\u0004\u0012\u00020\t0\u0012*\u00020)H\u0096\u0001J\u000e\u0010\u00c8\u0001\u001a\u000208*\u00020)H\u0096\u0001J\r\u0010b\u001a\u00020)*\u00020\tH\u0096\u0001J\r\u0010b\u001a\u00020)*\u000208H\u0096\u0001J\u000e\u0010\u00c9\u0001\u001a\u00020C*\u00020AH\u0096\u0001J\u000e\u0010\u00ca\u0001\u001a\u00020}*\u00020\tH\u0096\u0001J\u000e\u0010\u00ca\u0001\u001a\u00020}*\u000208H\u0096\u0001J\u000e\u0010O\u001a\u000208*\u00030\u0085\u0001H\u0096\u0001J\u000e\u0010\u00cb\u0001\u001a\u00020}*\u00020UH\u0096\u0001J\u000e\u0010\u00cc\u0001\u001a\u000208*\u00020\tH\u0096\u0001J\u0016\u0010\u00cd\u0001\u001a\u00020\t*\u00020\t2\u0006\u0010R\u001a\u00020 H\u0096\u0001J\u0016\u0010\u00cd\u0001\u001a\u000208*\u0002082\u0006\u0010R\u001a\u00020 H\u0096\u0001R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006\u00ce\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$TypeCheckerContext;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/AbstractTypeCheckerContextForConstraintSystem;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "baseLowerType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "baseUpperType", "possibleNewConstraints", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Ljava/util/List;)V", "allTypeVariablesWithConstraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getAllTypeVariablesWithConstraints", "()Ljava/util/Collection;", "baseContext", "Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext;", "getBaseContext", "()Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext;", "getBaseLowerType", "()Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "getBaseUpperType", "getC", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector$Context;", "isErrorTypeAllowed", "", "()Z", "getPosition", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "getPossibleNewConstraints", "()Ljava/util/List;", "addConstraint", "", "typeVariableConstructor", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "type", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintKind;", "addLowerConstraint", "typeVariable", "subType", "addNewIncorporatedConstraint", "lowerType", "upperType", "constraintContext", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintContext;", "addUpperConstraint", "superType", "anyType", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "areEqualTypeConstructors", "a", "b", "captureFromArguments", "status", "Lorg/jetbrains/kotlin/types/model/CaptureStatus;", "captureFromExpression", "createCapturedType", "Lorg/jetbrains/kotlin/types/model/CapturedTypeMarker;", "constructorProjection", "Lorg/jetbrains/kotlin/types/model/TypeArgumentMarker;", "constructorSupertypes", "", "captureStatus", "createEmptySubstitutor", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "createErrorTypeWithCustomConstructor", "debugName", "", "constructor", "createFlexibleType", "lowerBound", "upperBound", "createSimpleType", "arguments", "nullable", "createStarProjection", "typeParameter", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "createStubType", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "createTypeArgument", "variance", "Lorg/jetbrains/kotlin/types/model/TypeVariance;", "findCommonIntegerLiteralTypesSuperType", "explicitSupertypes", "fixedTypeVariable", "", "variable", "getConstraintsForVariable", "getTypeVariable", "typeConstructor", "identicalArguments", "intersectTypes", "types", "isCapturedTypeFromSubtyping", "isEqualTypeConstructors", "c1", "c2", "isMyTypeVariable", "newBaseTypeCheckerContext", "errorTypesEqualToAnything", "nothingType", "nullableAnyType", "nullableNothingType", "prepareType", "refineType", "renderBaseConstraint", "runIsSubtypeOf", "substitutionSupertypePolicy", "Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext$SupertypesPolicy;", "typeSubstitutorByTypeConstructor", "map", "", "anySuperTypeConstructor", "predicate", "Lkotlin/Function1;", "argumentsCount", "", "asArgumentList", "Lorg/jetbrains/kotlin/types/model/TypeArgumentListMarker;", "asCapturedType", "asDefinitelyNotNullType", "Lorg/jetbrains/kotlin/types/model/DefinitelyNotNullTypeMarker;", "asDynamicType", "Lorg/jetbrains/kotlin/types/model/DynamicTypeMarker;", "Lorg/jetbrains/kotlin/types/model/FlexibleTypeMarker;", "asFlexibleType", "asRawType", "Lorg/jetbrains/kotlin/types/model/RawTypeMarker;", "asSimpleType", "asTypeArgument", "canHaveUndefinedNullability", "contains", "defaultType", "fastCorrespondingSupertypes", "freshTypeConstructor", "get", "index", "getApproximatedIntegerLiteralType", "getArgument", "getArgumentOrNull", "getParameter", "getType", "getTypeConstructor", "getUpperBound", "getVariance", "hasExactAnnotation", "hasFlexibleNullability", "hasNoInferAnnotation", "isAnyConstructor", "isCapturedType", "isCapturedTypeConstructor", "isClassType", "isClassTypeConstructor", "isCommonFinalClassConstructor", "isDefinitelyNotNullType", "isDenotable", "isDynamic", "isError", "isFlexible", "isIntegerLiteralType", "isIntegerLiteralTypeConstructor", "isIntersection", "isMarkedNullable", "isNothing", "isNothingConstructor", "isNullableAny", "isNullableNothing", "isNullableType", "isPrimitiveType", "isSimpleType", "isSingleClassifierType", "isStarProjection", "isStubType", "isUninferredParameter", "isUnit", "isUnitTypeConstructor", "lowerBoundIfFlexible", "makeDefinitelyNotNullOrNotNull", "makeSimpleTypeDefinitelyNotNullOrNotNull", "mayBeTypeVariable", "original", "parametersCount", "possibleIntegerTypes", "removeAnnotations", "removeExactAnnotation", "replaceArguments", "newArguments", "safeSubstitute", "singleBestRepresentative", "size", "supertypes", "toErrorType", "typeConstructorProjection", "typeDepth", "upperBoundCount", "upperBoundIfFlexible", "withNullability", "resolution"})
    private final class TypeCheckerContext
    extends AbstractTypeCheckerContextForConstraintSystem
    implements ConstraintIncorporator.Context,
    TypeSystemInferenceExtensionContext {
        @NotNull
        private final AbstractTypeCheckerContext baseContext;
        @NotNull
        private final Context c;
        @NotNull
        private final IncorporationConstraintPosition position;
        @NotNull
        private final KotlinTypeMarker baseLowerType;
        @NotNull
        private final KotlinTypeMarker baseUpperType;
        @NotNull
        private final List<Pair<TypeVariableMarker, Constraint>> possibleNewConstraints;

        @NotNull
        public final AbstractTypeCheckerContext getBaseContext() {
            return this.baseContext;
        }

        @Override
        @NotNull
        public AbstractTypeCheckerContext.SupertypesPolicy substitutionSupertypePolicy(@NotNull SimpleTypeMarker type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.baseContext.substitutionSupertypePolicy(type2);
        }

        @Override
        public boolean areEqualTypeConstructors(@NotNull TypeConstructorMarker a, @NotNull TypeConstructorMarker b) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return this.baseContext.areEqualTypeConstructors(a, b);
        }

        @Override
        @NotNull
        public KotlinTypeMarker prepareType(@NotNull KotlinTypeMarker type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.baseContext.prepareType(type2);
        }

        @Override
        @NotNull
        public KotlinTypeMarker refineType(@NotNull KotlinTypeMarker type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return type2 instanceof KotlinType ? (KotlinTypeMarker)ConstraintInjector.this.getKotlinTypeRefiner().refineType((KotlinType)type2) : type2;
        }

        public final void runIsSubtypeOf(@NotNull KotlinTypeMarker lowerType, @NotNull KotlinTypeMarker upperType) {
            Intrinsics.checkParameterIsNotNull((Object)lowerType, (String)"lowerType");
            Intrinsics.checkParameterIsNotNull((Object)upperType, (String)"upperType");
            TypeCheckerContext typeCheckerContext = this;
            if (typeCheckerContext == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.AbstractTypeCheckerContext");
            }
            if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(typeCheckerContext, lowerType, upperType)) {
                this.c.addError(new NewConstraintError(lowerType, upperType, this.position));
            }
        }

        @Override
        public boolean isMyTypeVariable(@NotNull SimpleTypeMarker type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.mayBeTypeVariable(type2) && this.c.getAllTypeVariables().containsKey(this.typeConstructor(type2));
        }

        @Override
        public void addUpperConstraint(@NotNull TypeConstructorMarker typeVariable2, @NotNull KotlinTypeMarker superType) {
            Intrinsics.checkParameterIsNotNull((Object)typeVariable2, (String)"typeVariable");
            Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
            this.addConstraint(typeVariable2, superType, ConstraintKind.UPPER);
        }

        @Override
        public void addLowerConstraint(@NotNull TypeConstructorMarker typeVariable2, @NotNull KotlinTypeMarker subType) {
            Intrinsics.checkParameterIsNotNull((Object)typeVariable2, (String)"typeVariable");
            Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
            this.addConstraint(typeVariable2, subType, ConstraintKind.LOWER);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCapturedTypeFromSubtyping(KotlinTypeMarker type2) {
            KotlinTypeMarker kotlinTypeMarker = type2;
            if (!(kotlinTypeMarker instanceof CapturedTypeMarker)) {
                kotlinTypeMarker = null;
            }
            CapturedTypeMarker capturedTypeMarker = (CapturedTypeMarker)kotlinTypeMarker;
            if (capturedTypeMarker == null) return false;
            CaptureStatus captureStatus = this.captureStatus(capturedTypeMarker);
            if (captureStatus == null) return false;
            switch (ConstraintInjector$TypeCheckerContext$WhenMappings.$EnumSwitchMapping$0[captureStatus.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    String string2 = "Captured type for incorporation shouldn't escape from incorporation: " + type2 + '\n' + this.renderBaseConstraint();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void addConstraint(TypeConstructorMarker typeVariableConstructor, KotlinTypeMarker type2, ConstraintKind kind) {
            TypeVariableMarker typeVariableMarker = this.c.getAllTypeVariables().get(typeVariableConstructor);
            if (typeVariableMarker == null) {
                String string2 = "Should by type variableConstructor: " + typeVariableConstructor + ". " + this.c.getAllTypeVariables().values();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            TypeVariableMarker typeVariable2 = typeVariableMarker;
            this.addNewIncorporatedConstraint(typeVariable2, type2, new ConstraintContext(kind, SetsKt.emptySet()));
        }

        @Override
        public void addNewIncorporatedConstraint(@NotNull KotlinTypeMarker lowerType, @NotNull KotlinTypeMarker upperType) {
            Intrinsics.checkParameterIsNotNull((Object)lowerType, (String)"lowerType");
            Intrinsics.checkParameterIsNotNull((Object)upperType, (String)"upperType");
            if (ConstraintInjector.this.isAllowedType(this.c, lowerType) && ConstraintInjector.this.isAllowedType(this.c, upperType)) {
                this.runIsSubtypeOf(lowerType, upperType);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addNewIncorporatedConstraint(@NotNull TypeVariableMarker typeVariable2, @NotNull KotlinTypeMarker type2, @NotNull ConstraintContext constraintContext) {
            void kind;
            Intrinsics.checkParameterIsNotNull((Object)typeVariable2, (String)"typeVariable");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)constraintContext, (String)"constraintContext");
            ConstraintContext constraintContext2 = constraintContext;
            ConstraintKind constraintKind = constraintContext2.component1();
            Set<TypeVariableMarker> derivedFrom = constraintContext2.component2();
            KotlinTypeMarker targetType = type2;
            if (this.isUninferredParameter(targetType)) {
                return;
            }
            if (this.isError(targetType)) {
                this.c.addError(new ConstrainingTypeIsError(typeVariable2, targetType, this.position));
                return;
            }
            if (this.contains(type2, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new Function1<KotlinTypeMarker, Boolean>(this){

                public final boolean invoke(@NotNull KotlinTypeMarker p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return TypeCheckerContext.access$isCapturedTypeFromSubtyping((TypeCheckerContext)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(TypeCheckerContext.class);
                }

                public final String getName() {
                    return "isCapturedTypeFromSubtyping";
                }

                public final String getSignature() {
                    return "isCapturedTypeFromSubtyping(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)Z";
                }
            }))) {
                KotlinTypeMarker superType;
                KotlinTypeMarker subType;
                if (kind == ConstraintKind.UPPER && (subType = ConstraintInjector.this.getTypeApproximator().approximateToSubType(type2, TypeApproximatorConfiguration.SubtypeCapturedTypesApproximation.INSTANCE)) != null) {
                    targetType = subType;
                }
                if (kind == ConstraintKind.LOWER && (superType = ConstraintInjector.this.getTypeApproximator().approximateToSuperType(type2, TypeApproximatorConfiguration.SubtypeCapturedTypesApproximation.INSTANCE)) != null) {
                    targetType = superType;
                }
                if (targetType == type2) {
                    this.c.addError(new CapturedTypeFromSubtyping(typeVariable2, type2, this.position));
                    return;
                }
            }
            this.possibleNewConstraints.add((Pair<TypeVariableMarker, Constraint>)TuplesKt.to((Object)typeVariable2, (Object)new Constraint((ConstraintKind)kind, targetType, this.position, 0, derivedFrom, 8, null)));
        }

        @Override
        @NotNull
        public Collection<VariableWithConstraints> getAllTypeVariablesWithConstraints() {
            return this.c.getNotFixedTypeVariables().values();
        }

        @Override
        @Nullable
        public TypeVariableMarker getTypeVariable(@NotNull TypeConstructorMarker typeConstructor2) {
            Intrinsics.checkParameterIsNotNull((Object)typeConstructor2, (String)"typeConstructor");
            TypeVariableMarker typeVariable2 = this.c.getAllTypeVariables().get(typeConstructor2);
            if (typeVariable2 != null && !this.c.getNotFixedTypeVariables().containsKey(typeConstructor2)) {
                Void void_ = this.fixedTypeVariable(typeVariable2);
                throw null;
            }
            return typeVariable2;
        }

        @NotNull
        public List<Constraint> getConstraintsForVariable(@NotNull TypeVariableMarker typeVariable2) {
            Intrinsics.checkParameterIsNotNull((Object)typeVariable2, (String)"typeVariable");
            Object object = this.c.getNotFixedTypeVariables().get(this.freshTypeConstructor(typeVariable2));
            if (object == null || (object = ((MutableVariableWithConstraints)object).getConstraints()) == null) {
                Void void_ = this.fixedTypeVariable(typeVariable2);
                throw null;
            }
            return object;
        }

        @NotNull
        public final Void fixedTypeVariable(@NotNull TypeVariableMarker variable2) {
            Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
            String string2 = "Type variable " + variable2 + " should not be fixed!\n" + this.renderBaseConstraint();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }

        private final String renderBaseConstraint() {
            return "Base constraint: " + this.baseLowerType + " <: " + this.baseUpperType + " from position: " + this.position;
        }

        @NotNull
        public final Context getC() {
            return this.c;
        }

        @NotNull
        public final IncorporationConstraintPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final KotlinTypeMarker getBaseLowerType() {
            return this.baseLowerType;
        }

        @NotNull
        public final KotlinTypeMarker getBaseUpperType() {
            return this.baseUpperType;
        }

        @NotNull
        public final List<Pair<TypeVariableMarker, Constraint>> getPossibleNewConstraints() {
            return this.possibleNewConstraints;
        }

        public TypeCheckerContext(@NotNull Context c, @NotNull IncorporationConstraintPosition position, @NotNull KotlinTypeMarker baseLowerType, @NotNull KotlinTypeMarker baseUpperType, List<Pair<TypeVariableMarker, Constraint>> possibleNewConstraints) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            Intrinsics.checkParameterIsNotNull((Object)baseLowerType, (String)"baseLowerType");
            Intrinsics.checkParameterIsNotNull((Object)baseUpperType, (String)"baseUpperType");
            Intrinsics.checkParameterIsNotNull(possibleNewConstraints, (String)"possibleNewConstraints");
            this.c = c;
            this.position = position;
            this.baseLowerType = baseLowerType;
            this.baseUpperType = baseUpperType;
            this.possibleNewConstraints = possibleNewConstraints;
            this.baseContext = this.newBaseTypeCheckerContext(this.isErrorTypeEqualsToAnything());
        }

        @Override
        public boolean isErrorTypeAllowed() {
            return this.c.isErrorTypeAllowed();
        }

        @Override
        @NotNull
        public SimpleTypeMarker anyType() {
            return this.c.anyType();
        }

        @Override
        @Nullable
        public SimpleTypeMarker captureFromArguments(@NotNull SimpleTypeMarker type2, @NotNull CaptureStatus status2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)((Object)status2), (String)"status");
            return this.c.captureFromArguments(type2, status2);
        }

        @Override
        @Nullable
        public KotlinTypeMarker captureFromExpression(@NotNull KotlinTypeMarker type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.c.captureFromExpression(type2);
        }

        @Override
        @NotNull
        public CapturedTypeMarker createCapturedType(@NotNull TypeArgumentMarker constructorProjection, @NotNull List<? extends KotlinTypeMarker> constructorSupertypes, @Nullable KotlinTypeMarker lowerType, @NotNull CaptureStatus captureStatus) {
            Intrinsics.checkParameterIsNotNull((Object)constructorProjection, (String)"constructorProjection");
            Intrinsics.checkParameterIsNotNull(constructorSupertypes, (String)"constructorSupertypes");
            Intrinsics.checkParameterIsNotNull((Object)((Object)captureStatus), (String)"captureStatus");
            return this.c.createCapturedType(constructorProjection, constructorSupertypes, lowerType, captureStatus);
        }

        @Override
        @NotNull
        public TypeSubstitutorMarker createEmptySubstitutor() {
            return this.c.createEmptySubstitutor();
        }

        @Override
        @NotNull
        public KotlinTypeMarker createErrorTypeWithCustomConstructor(@NotNull String debugName, @NotNull TypeConstructorMarker constructor) {
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            return this.c.createErrorTypeWithCustomConstructor(debugName, constructor);
        }

        @Override
        @NotNull
        public KotlinTypeMarker createFlexibleType(@NotNull SimpleTypeMarker lowerBound, @NotNull SimpleTypeMarker upperBound) {
            Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
            return this.c.createFlexibleType(lowerBound, upperBound);
        }

        @Override
        @NotNull
        public SimpleTypeMarker createSimpleType(@NotNull TypeConstructorMarker constructor, @NotNull List<? extends TypeArgumentMarker> arguments2, boolean nullable) {
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
            return this.c.createSimpleType(constructor, arguments2, nullable);
        }

        @Override
        @NotNull
        public TypeArgumentMarker createStarProjection(@NotNull TypeParameterMarker typeParameter) {
            Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
            return this.c.createStarProjection(typeParameter);
        }

        @Override
        @NotNull
        public StubTypeMarker createStubType(@NotNull TypeVariableMarker typeVariable2) {
            Intrinsics.checkParameterIsNotNull((Object)typeVariable2, (String)"typeVariable");
            return this.c.createStubType(typeVariable2);
        }

        @Override
        @NotNull
        public TypeArgumentMarker createTypeArgument(@NotNull KotlinTypeMarker type2, @NotNull TypeVariance variance) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)((Object)variance), (String)"variance");
            return this.c.createTypeArgument(type2, variance);
        }

        @Override
        @Nullable
        public SimpleTypeMarker findCommonIntegerLiteralTypesSuperType(@NotNull List<? extends SimpleTypeMarker> explicitSupertypes) {
            Intrinsics.checkParameterIsNotNull(explicitSupertypes, (String)"explicitSupertypes");
            return this.c.findCommonIntegerLiteralTypesSuperType(explicitSupertypes);
        }

        @Override
        public boolean identicalArguments(@NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return this.c.identicalArguments(a, b);
        }

        @Override
        @NotNull
        public KotlinTypeMarker intersectTypes(@NotNull List<? extends KotlinTypeMarker> types2) {
            Intrinsics.checkParameterIsNotNull(types2, (String)"types");
            return this.c.intersectTypes(types2);
        }

        @Override
        @NotNull
        public SimpleTypeMarker intersectTypes(@NotNull List<? extends SimpleTypeMarker> types2) {
            Intrinsics.checkParameterIsNotNull(types2, (String)"types");
            return this.c.intersectTypes(types2);
        }

        @Override
        public boolean isEqualTypeConstructors(@NotNull TypeConstructorMarker c1, @NotNull TypeConstructorMarker c2) {
            Intrinsics.checkParameterIsNotNull((Object)c1, (String)"c1");
            Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c2");
            return this.c.isEqualTypeConstructors(c1, c2);
        }

        @Override
        @NotNull
        public AbstractTypeCheckerContext newBaseTypeCheckerContext(boolean errorTypesEqualToAnything) {
            return this.c.newBaseTypeCheckerContext(errorTypesEqualToAnything);
        }

        @Override
        @NotNull
        public SimpleTypeMarker nothingType() {
            return this.c.nothingType();
        }

        @Override
        @NotNull
        public SimpleTypeMarker nullableAnyType() {
            return this.c.nullableAnyType();
        }

        @Override
        @NotNull
        public SimpleTypeMarker nullableNothingType() {
            return this.c.nullableNothingType();
        }

        @Override
        @NotNull
        public TypeSubstitutorMarker typeSubstitutorByTypeConstructor(@NotNull Map<TypeConstructorMarker, ? extends KotlinTypeMarker> map2) {
            Intrinsics.checkParameterIsNotNull(map2, (String)"map");
            return this.c.typeSubstitutorByTypeConstructor(map2);
        }

        @Override
        public boolean anySuperTypeConstructor(@NotNull KotlinTypeMarker $this$anySuperTypeConstructor, @NotNull Function1<? super TypeConstructorMarker, Boolean> predicate) {
            Intrinsics.checkParameterIsNotNull((Object)$this$anySuperTypeConstructor, (String)"$this$anySuperTypeConstructor");
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            return this.c.anySuperTypeConstructor($this$anySuperTypeConstructor, predicate);
        }

        @Override
        public int argumentsCount(@NotNull KotlinTypeMarker $this$argumentsCount) {
            Intrinsics.checkParameterIsNotNull((Object)$this$argumentsCount, (String)"$this$argumentsCount");
            return this.c.argumentsCount($this$argumentsCount);
        }

        @Override
        @NotNull
        public TypeArgumentListMarker asArgumentList(@NotNull SimpleTypeMarker $this$asArgumentList) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asArgumentList, (String)"$this$asArgumentList");
            return this.c.asArgumentList($this$asArgumentList);
        }

        @Override
        @Nullable
        public CapturedTypeMarker asCapturedType(@NotNull SimpleTypeMarker $this$asCapturedType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asCapturedType, (String)"$this$asCapturedType");
            return this.c.asCapturedType($this$asCapturedType);
        }

        @Override
        @Nullable
        public DefinitelyNotNullTypeMarker asDefinitelyNotNullType(@NotNull SimpleTypeMarker $this$asDefinitelyNotNullType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asDefinitelyNotNullType, (String)"$this$asDefinitelyNotNullType");
            return this.c.asDefinitelyNotNullType($this$asDefinitelyNotNullType);
        }

        @Override
        @Nullable
        public DynamicTypeMarker asDynamicType(@NotNull FlexibleTypeMarker $this$asDynamicType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asDynamicType, (String)"$this$asDynamicType");
            return this.c.asDynamicType($this$asDynamicType);
        }

        @Override
        @Nullable
        public FlexibleTypeMarker asFlexibleType(@NotNull KotlinTypeMarker $this$asFlexibleType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asFlexibleType, (String)"$this$asFlexibleType");
            return this.c.asFlexibleType($this$asFlexibleType);
        }

        @Override
        @Nullable
        public RawTypeMarker asRawType(@NotNull FlexibleTypeMarker $this$asRawType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asRawType, (String)"$this$asRawType");
            return this.c.asRawType($this$asRawType);
        }

        @Override
        @Nullable
        public SimpleTypeMarker asSimpleType(@NotNull KotlinTypeMarker $this$asSimpleType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asSimpleType, (String)"$this$asSimpleType");
            return this.c.asSimpleType($this$asSimpleType);
        }

        @Override
        @NotNull
        public TypeArgumentMarker asTypeArgument(@NotNull KotlinTypeMarker $this$asTypeArgument) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asTypeArgument, (String)"$this$asTypeArgument");
            return this.c.asTypeArgument($this$asTypeArgument);
        }

        @Override
        public boolean canHaveUndefinedNullability(@NotNull KotlinTypeMarker $this$canHaveUndefinedNullability) {
            Intrinsics.checkParameterIsNotNull((Object)$this$canHaveUndefinedNullability, (String)"$this$canHaveUndefinedNullability");
            return this.c.canHaveUndefinedNullability($this$canHaveUndefinedNullability);
        }

        @Override
        @NotNull
        public CaptureStatus captureStatus(@NotNull CapturedTypeMarker $this$captureStatus) {
            Intrinsics.checkParameterIsNotNull((Object)$this$captureStatus, (String)"$this$captureStatus");
            return this.c.captureStatus($this$captureStatus);
        }

        @Override
        public boolean contains(@NotNull KotlinTypeMarker $this$contains, @NotNull Function1<? super KotlinTypeMarker, Boolean> predicate) {
            Intrinsics.checkParameterIsNotNull((Object)$this$contains, (String)"$this$contains");
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            return this.c.contains($this$contains, predicate);
        }

        @Override
        @NotNull
        public SimpleTypeMarker defaultType(@NotNull TypeVariableMarker $this$defaultType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$defaultType, (String)"$this$defaultType");
            return this.c.defaultType($this$defaultType);
        }

        @Override
        @Nullable
        public List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull SimpleTypeMarker $this$fastCorrespondingSupertypes, @NotNull TypeConstructorMarker constructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$fastCorrespondingSupertypes, (String)"$this$fastCorrespondingSupertypes");
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            return this.c.fastCorrespondingSupertypes($this$fastCorrespondingSupertypes, constructor);
        }

        @Override
        @NotNull
        public TypeConstructorMarker freshTypeConstructor(@NotNull TypeVariableMarker $this$freshTypeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$freshTypeConstructor, (String)"$this$freshTypeConstructor");
            return this.c.freshTypeConstructor($this$freshTypeConstructor);
        }

        @Override
        @NotNull
        public TypeArgumentMarker get(@NotNull TypeArgumentListMarker $this$get, int index2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
            return this.c.get($this$get, index2);
        }

        @Override
        @NotNull
        public KotlinTypeMarker getApproximatedIntegerLiteralType(@NotNull TypeConstructorMarker $this$getApproximatedIntegerLiteralType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getApproximatedIntegerLiteralType, (String)"$this$getApproximatedIntegerLiteralType");
            return this.c.getApproximatedIntegerLiteralType($this$getApproximatedIntegerLiteralType);
        }

        @Override
        @NotNull
        public TypeArgumentMarker getArgument(@NotNull KotlinTypeMarker $this$getArgument, int index2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getArgument, (String)"$this$getArgument");
            return this.c.getArgument($this$getArgument, index2);
        }

        @Override
        @Nullable
        public TypeArgumentMarker getArgumentOrNull(@NotNull SimpleTypeMarker $this$getArgumentOrNull, int index2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getArgumentOrNull, (String)"$this$getArgumentOrNull");
            return this.c.getArgumentOrNull($this$getArgumentOrNull, index2);
        }

        @Override
        @NotNull
        public TypeParameterMarker getParameter(@NotNull TypeConstructorMarker $this$getParameter, int index2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getParameter, (String)"$this$getParameter");
            return this.c.getParameter($this$getParameter, index2);
        }

        @Override
        @NotNull
        public KotlinTypeMarker getType(@NotNull TypeArgumentMarker $this$getType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getType, (String)"$this$getType");
            return this.c.getType($this$getType);
        }

        @Override
        @NotNull
        public TypeConstructorMarker getTypeConstructor(@NotNull TypeParameterMarker $this$getTypeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getTypeConstructor, (String)"$this$getTypeConstructor");
            return this.c.getTypeConstructor($this$getTypeConstructor);
        }

        @Override
        @NotNull
        public KotlinTypeMarker getUpperBound(@NotNull TypeParameterMarker $this$getUpperBound, int index2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getUpperBound, (String)"$this$getUpperBound");
            return this.c.getUpperBound($this$getUpperBound, index2);
        }

        @Override
        @NotNull
        public TypeVariance getVariance(@NotNull TypeArgumentMarker $this$getVariance) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getVariance, (String)"$this$getVariance");
            return this.c.getVariance($this$getVariance);
        }

        @Override
        @NotNull
        public TypeVariance getVariance(@NotNull TypeParameterMarker $this$getVariance) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getVariance, (String)"$this$getVariance");
            return this.c.getVariance($this$getVariance);
        }

        @Override
        public boolean hasExactAnnotation(@NotNull KotlinTypeMarker $this$hasExactAnnotation) {
            Intrinsics.checkParameterIsNotNull((Object)$this$hasExactAnnotation, (String)"$this$hasExactAnnotation");
            return this.c.hasExactAnnotation($this$hasExactAnnotation);
        }

        @Override
        public boolean hasFlexibleNullability(@NotNull KotlinTypeMarker $this$hasFlexibleNullability) {
            Intrinsics.checkParameterIsNotNull((Object)$this$hasFlexibleNullability, (String)"$this$hasFlexibleNullability");
            return this.c.hasFlexibleNullability($this$hasFlexibleNullability);
        }

        @Override
        public boolean hasNoInferAnnotation(@NotNull KotlinTypeMarker $this$hasNoInferAnnotation) {
            Intrinsics.checkParameterIsNotNull((Object)$this$hasNoInferAnnotation, (String)"$this$hasNoInferAnnotation");
            return this.c.hasNoInferAnnotation($this$hasNoInferAnnotation);
        }

        @Override
        public boolean isAnyConstructor(@NotNull TypeConstructorMarker $this$isAnyConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isAnyConstructor, (String)"$this$isAnyConstructor");
            return this.c.isAnyConstructor($this$isAnyConstructor);
        }

        @Override
        public boolean isCapturedType(@NotNull KotlinTypeMarker $this$isCapturedType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isCapturedType, (String)"$this$isCapturedType");
            return this.c.isCapturedType($this$isCapturedType);
        }

        @Override
        public boolean isCapturedTypeConstructor(@NotNull TypeConstructorMarker $this$isCapturedTypeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isCapturedTypeConstructor, (String)"$this$isCapturedTypeConstructor");
            return this.c.isCapturedTypeConstructor($this$isCapturedTypeConstructor);
        }

        @Override
        public boolean isClassType(@NotNull SimpleTypeMarker $this$isClassType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isClassType, (String)"$this$isClassType");
            return this.c.isClassType($this$isClassType);
        }

        @Override
        public boolean isClassTypeConstructor(@NotNull TypeConstructorMarker $this$isClassTypeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isClassTypeConstructor, (String)"$this$isClassTypeConstructor");
            return this.c.isClassTypeConstructor($this$isClassTypeConstructor);
        }

        @Override
        public boolean isCommonFinalClassConstructor(@NotNull TypeConstructorMarker $this$isCommonFinalClassConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isCommonFinalClassConstructor, (String)"$this$isCommonFinalClassConstructor");
            return this.c.isCommonFinalClassConstructor($this$isCommonFinalClassConstructor);
        }

        @Override
        public boolean isDefinitelyNotNullType(@NotNull KotlinTypeMarker $this$isDefinitelyNotNullType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isDefinitelyNotNullType, (String)"$this$isDefinitelyNotNullType");
            return this.c.isDefinitelyNotNullType($this$isDefinitelyNotNullType);
        }

        @Override
        public boolean isDenotable(@NotNull TypeConstructorMarker $this$isDenotable) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isDenotable, (String)"$this$isDenotable");
            return this.c.isDenotable($this$isDenotable);
        }

        @Override
        public boolean isDynamic(@NotNull KotlinTypeMarker $this$isDynamic) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isDynamic, (String)"$this$isDynamic");
            return this.c.isDynamic($this$isDynamic);
        }

        @Override
        public boolean isError(@NotNull KotlinTypeMarker $this$isError) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isError, (String)"$this$isError");
            return this.c.isError($this$isError);
        }

        @Override
        public boolean isError(@NotNull TypeConstructorMarker $this$isError) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isError, (String)"$this$isError");
            return this.c.isError($this$isError);
        }

        @Override
        public boolean isFlexible(@NotNull KotlinTypeMarker $this$isFlexible) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isFlexible, (String)"$this$isFlexible");
            return this.c.isFlexible($this$isFlexible);
        }

        @Override
        public boolean isIntegerLiteralType(@NotNull SimpleTypeMarker $this$isIntegerLiteralType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isIntegerLiteralType, (String)"$this$isIntegerLiteralType");
            return this.c.isIntegerLiteralType($this$isIntegerLiteralType);
        }

        @Override
        public boolean isIntegerLiteralTypeConstructor(@NotNull TypeConstructorMarker $this$isIntegerLiteralTypeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isIntegerLiteralTypeConstructor, (String)"$this$isIntegerLiteralTypeConstructor");
            return this.c.isIntegerLiteralTypeConstructor($this$isIntegerLiteralTypeConstructor);
        }

        @Override
        public boolean isIntersection(@NotNull TypeConstructorMarker $this$isIntersection) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isIntersection, (String)"$this$isIntersection");
            return this.c.isIntersection($this$isIntersection);
        }

        @Override
        public boolean isMarkedNullable(@NotNull SimpleTypeMarker $this$isMarkedNullable) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isMarkedNullable, (String)"$this$isMarkedNullable");
            return this.c.isMarkedNullable($this$isMarkedNullable);
        }

        @Override
        public boolean isNothing(@NotNull KotlinTypeMarker $this$isNothing) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isNothing, (String)"$this$isNothing");
            return this.c.isNothing($this$isNothing);
        }

        @Override
        public boolean isNothingConstructor(@NotNull TypeConstructorMarker $this$isNothingConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isNothingConstructor, (String)"$this$isNothingConstructor");
            return this.c.isNothingConstructor($this$isNothingConstructor);
        }

        @Override
        public boolean isNullableAny(@NotNull KotlinTypeMarker $this$isNullableAny) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isNullableAny, (String)"$this$isNullableAny");
            return this.c.isNullableAny($this$isNullableAny);
        }

        @Override
        public boolean isNullableNothing(@NotNull KotlinTypeMarker $this$isNullableNothing) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isNullableNothing, (String)"$this$isNullableNothing");
            return this.c.isNullableNothing($this$isNullableNothing);
        }

        @Override
        public boolean isNullableType(@NotNull KotlinTypeMarker $this$isNullableType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isNullableType, (String)"$this$isNullableType");
            return this.c.isNullableType($this$isNullableType);
        }

        @Override
        public boolean isPrimitiveType(@NotNull SimpleTypeMarker $this$isPrimitiveType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isPrimitiveType, (String)"$this$isPrimitiveType");
            return this.c.isPrimitiveType($this$isPrimitiveType);
        }

        @Override
        public boolean isSimpleType(@NotNull KotlinTypeMarker $this$isSimpleType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isSimpleType, (String)"$this$isSimpleType");
            return this.c.isSimpleType($this$isSimpleType);
        }

        @Override
        public boolean isSingleClassifierType(@NotNull SimpleTypeMarker $this$isSingleClassifierType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isSingleClassifierType, (String)"$this$isSingleClassifierType");
            return this.c.isSingleClassifierType($this$isSingleClassifierType);
        }

        @Override
        public boolean isStarProjection(@NotNull TypeArgumentMarker $this$isStarProjection) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isStarProjection, (String)"$this$isStarProjection");
            return this.c.isStarProjection($this$isStarProjection);
        }

        @Override
        public boolean isStubType(@NotNull SimpleTypeMarker $this$isStubType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isStubType, (String)"$this$isStubType");
            return this.c.isStubType($this$isStubType);
        }

        @Override
        public boolean isUninferredParameter(@NotNull KotlinTypeMarker $this$isUninferredParameter) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isUninferredParameter, (String)"$this$isUninferredParameter");
            return this.c.isUninferredParameter($this$isUninferredParameter);
        }

        @Override
        public boolean isUnit(@NotNull KotlinTypeMarker $this$isUnit) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isUnit, (String)"$this$isUnit");
            return this.c.isUnit($this$isUnit);
        }

        @Override
        public boolean isUnitTypeConstructor(@NotNull TypeConstructorMarker $this$isUnitTypeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isUnitTypeConstructor, (String)"$this$isUnitTypeConstructor");
            return this.c.isUnitTypeConstructor($this$isUnitTypeConstructor);
        }

        @Override
        @NotNull
        public SimpleTypeMarker lowerBound(@NotNull FlexibleTypeMarker $this$lowerBound) {
            Intrinsics.checkParameterIsNotNull((Object)$this$lowerBound, (String)"$this$lowerBound");
            return this.c.lowerBound($this$lowerBound);
        }

        @Override
        @NotNull
        public SimpleTypeMarker lowerBoundIfFlexible(@NotNull KotlinTypeMarker $this$lowerBoundIfFlexible) {
            Intrinsics.checkParameterIsNotNull((Object)$this$lowerBoundIfFlexible, (String)"$this$lowerBoundIfFlexible");
            return this.c.lowerBoundIfFlexible($this$lowerBoundIfFlexible);
        }

        @Override
        @Nullable
        public KotlinTypeMarker lowerType(@NotNull CapturedTypeMarker $this$lowerType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$lowerType, (String)"$this$lowerType");
            return this.c.lowerType($this$lowerType);
        }

        @Override
        @NotNull
        public KotlinTypeMarker makeDefinitelyNotNullOrNotNull(@NotNull KotlinTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
            Intrinsics.checkParameterIsNotNull((Object)$this$makeDefinitelyNotNullOrNotNull, (String)"$this$makeDefinitelyNotNullOrNotNull");
            return this.c.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull);
        }

        @Override
        @NotNull
        public SimpleTypeMarker makeSimpleTypeDefinitelyNotNullOrNotNull(@NotNull SimpleTypeMarker $this$makeSimpleTypeDefinitelyNotNullOrNotNull) {
            Intrinsics.checkParameterIsNotNull((Object)$this$makeSimpleTypeDefinitelyNotNullOrNotNull, (String)"$this$makeSimpleTypeDefinitelyNotNullOrNotNull");
            return this.c.makeSimpleTypeDefinitelyNotNullOrNotNull($this$makeSimpleTypeDefinitelyNotNullOrNotNull);
        }

        @Override
        public boolean mayBeTypeVariable(@NotNull KotlinTypeMarker $this$mayBeTypeVariable) {
            Intrinsics.checkParameterIsNotNull((Object)$this$mayBeTypeVariable, (String)"$this$mayBeTypeVariable");
            return this.c.mayBeTypeVariable($this$mayBeTypeVariable);
        }

        @Override
        @NotNull
        public SimpleTypeMarker original(@NotNull DefinitelyNotNullTypeMarker $this$original) {
            Intrinsics.checkParameterIsNotNull((Object)$this$original, (String)"$this$original");
            return this.c.original($this$original);
        }

        @Override
        public int parametersCount(@NotNull TypeConstructorMarker $this$parametersCount) {
            Intrinsics.checkParameterIsNotNull((Object)$this$parametersCount, (String)"$this$parametersCount");
            return this.c.parametersCount($this$parametersCount);
        }

        @Override
        @NotNull
        public Collection<KotlinTypeMarker> possibleIntegerTypes(@NotNull SimpleTypeMarker $this$possibleIntegerTypes) {
            Intrinsics.checkParameterIsNotNull((Object)$this$possibleIntegerTypes, (String)"$this$possibleIntegerTypes");
            return this.c.possibleIntegerTypes($this$possibleIntegerTypes);
        }

        @Override
        @NotNull
        public KotlinTypeMarker removeAnnotations(@NotNull KotlinTypeMarker $this$removeAnnotations) {
            Intrinsics.checkParameterIsNotNull((Object)$this$removeAnnotations, (String)"$this$removeAnnotations");
            return this.c.removeAnnotations($this$removeAnnotations);
        }

        @Override
        @NotNull
        public KotlinTypeMarker removeExactAnnotation(@NotNull KotlinTypeMarker $this$removeExactAnnotation) {
            Intrinsics.checkParameterIsNotNull((Object)$this$removeExactAnnotation, (String)"$this$removeExactAnnotation");
            return this.c.removeExactAnnotation($this$removeExactAnnotation);
        }

        @Override
        @NotNull
        public SimpleTypeMarker replaceArguments(@NotNull SimpleTypeMarker $this$replaceArguments, @NotNull List<? extends TypeArgumentMarker> newArguments2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$replaceArguments, (String)"$this$replaceArguments");
            Intrinsics.checkParameterIsNotNull(newArguments2, (String)"newArguments");
            return this.c.replaceArguments($this$replaceArguments, newArguments2);
        }

        @Override
        @NotNull
        public KotlinTypeMarker safeSubstitute(@NotNull TypeSubstitutorMarker $this$safeSubstitute, @NotNull KotlinTypeMarker type2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$safeSubstitute, (String)"$this$safeSubstitute");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.c.safeSubstitute($this$safeSubstitute, type2);
        }

        @Override
        @Nullable
        public KotlinTypeMarker singleBestRepresentative(@NotNull Collection<? extends KotlinTypeMarker> $this$singleBestRepresentative) {
            Intrinsics.checkParameterIsNotNull($this$singleBestRepresentative, (String)"$this$singleBestRepresentative");
            return this.c.singleBestRepresentative($this$singleBestRepresentative);
        }

        @Override
        public int size(@NotNull TypeArgumentListMarker $this$size) {
            Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"$this$size");
            return this.c.size($this$size);
        }

        @Override
        @NotNull
        public Collection<KotlinTypeMarker> supertypes(@NotNull TypeConstructorMarker $this$supertypes) {
            Intrinsics.checkParameterIsNotNull((Object)$this$supertypes, (String)"$this$supertypes");
            return this.c.supertypes($this$supertypes);
        }

        @Override
        @NotNull
        public SimpleTypeMarker toErrorType(@NotNull TypeConstructorMarker $this$toErrorType) {
            Intrinsics.checkParameterIsNotNull((Object)$this$toErrorType, (String)"$this$toErrorType");
            return this.c.toErrorType($this$toErrorType);
        }

        @Override
        @NotNull
        public TypeConstructorMarker typeConstructor(@NotNull KotlinTypeMarker $this$typeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$typeConstructor, (String)"$this$typeConstructor");
            return this.c.typeConstructor($this$typeConstructor);
        }

        @Override
        @NotNull
        public TypeConstructorMarker typeConstructor(@NotNull SimpleTypeMarker $this$typeConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)$this$typeConstructor, (String)"$this$typeConstructor");
            return this.c.typeConstructor($this$typeConstructor);
        }

        @Override
        @NotNull
        public TypeArgumentMarker typeConstructorProjection(@NotNull CapturedTypeMarker $this$typeConstructorProjection) {
            Intrinsics.checkParameterIsNotNull((Object)$this$typeConstructorProjection, (String)"$this$typeConstructorProjection");
            return this.c.typeConstructorProjection($this$typeConstructorProjection);
        }

        @Override
        public int typeDepth(@NotNull KotlinTypeMarker $this$typeDepth) {
            Intrinsics.checkParameterIsNotNull((Object)$this$typeDepth, (String)"$this$typeDepth");
            return this.c.typeDepth($this$typeDepth);
        }

        @Override
        public int typeDepth(@NotNull SimpleTypeMarker $this$typeDepth) {
            Intrinsics.checkParameterIsNotNull((Object)$this$typeDepth, (String)"$this$typeDepth");
            return this.c.typeDepth($this$typeDepth);
        }

        @Override
        @NotNull
        public SimpleTypeMarker upperBound(@NotNull FlexibleTypeMarker $this$upperBound) {
            Intrinsics.checkParameterIsNotNull((Object)$this$upperBound, (String)"$this$upperBound");
            return this.c.upperBound($this$upperBound);
        }

        @Override
        public int upperBoundCount(@NotNull TypeParameterMarker $this$upperBoundCount) {
            Intrinsics.checkParameterIsNotNull((Object)$this$upperBoundCount, (String)"$this$upperBoundCount");
            return this.c.upperBoundCount($this$upperBoundCount);
        }

        @Override
        @NotNull
        public SimpleTypeMarker upperBoundIfFlexible(@NotNull KotlinTypeMarker $this$upperBoundIfFlexible) {
            Intrinsics.checkParameterIsNotNull((Object)$this$upperBoundIfFlexible, (String)"$this$upperBoundIfFlexible");
            return this.c.upperBoundIfFlexible($this$upperBoundIfFlexible);
        }

        @Override
        @NotNull
        public KotlinTypeMarker withNullability(@NotNull KotlinTypeMarker $this$withNullability, boolean nullable) {
            Intrinsics.checkParameterIsNotNull((Object)$this$withNullability, (String)"$this$withNullability");
            return this.c.withNullability($this$withNullability, nullable);
        }

        @Override
        @NotNull
        public SimpleTypeMarker withNullability(@NotNull SimpleTypeMarker $this$withNullability, boolean nullable) {
            Intrinsics.checkParameterIsNotNull((Object)$this$withNullability, (String)"$this$withNullability");
            return this.c.withNullability($this$withNullability, nullable);
        }

        public static final /* synthetic */ boolean access$isCapturedTypeFromSubtyping(TypeCheckerContext $this, KotlinTypeMarker type2) {
            return $this.isCapturedTypeFromSubtyping(type2);
        }
    }
}

