/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cleanup;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;

public class DefaultBuildOutputCleanupRegistry
implements BuildOutputCleanupRegistry {
    private final FileCollectionFactory fileCollectionFactory;
    private final Set<FileCollection> outputs = Sets.newHashSet();
    private Set<String> resolvedPaths;

    public DefaultBuildOutputCleanupRegistry(FileCollectionFactory fileCollectionFactory) {
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public synchronized void registerOutputs(Object files) {
        if (this.resolvedPaths != null) {
            this.resolvedPaths = null;
        }
        this.outputs.add((FileCollection)this.fileCollectionFactory.resolving(new Object[]{files}));
    }

    @Override
    public boolean isOutputOwnedByBuild(File file) {
        Set<String> safeToDelete = this.getResolvedPaths();
        for (File absoluteFile = file.getAbsoluteFile(); absoluteFile != null; absoluteFile = absoluteFile.getParentFile()) {
            if (!safeToDelete.contains(absoluteFile.getPath())) continue;
            return true;
        }
        return false;
    }

    private Set<String> getResolvedPaths() {
        if (this.resolvedPaths == null) {
            this.doResolvePaths();
        }
        return this.resolvedPaths;
    }

    private synchronized void doResolvePaths() {
        if (this.resolvedPaths == null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (FileCollection output : this.outputs) {
                for (File file : output) {
                    result.add(file.getAbsolutePath());
                }
            }
            this.resolvedPaths = result;
        }
    }
}

