/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.serializer;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.verification.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.DependencyVerifierBuilder;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DependencyVerificationsXmlReader {
    public static void readFromXml(InputStream in, DependencyVerifierBuilder builder) {
        try {
            SAXParser saxParser = DependencyVerificationsXmlReader.createSecureParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            VerifiersHandler handler = new VerifiersHandler(builder);
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Unable to read dependency verification metadata", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    public static DependencyVerifier readFromXml(InputStream in) {
        DependencyVerifierBuilder builder = new DependencyVerifierBuilder();
        DependencyVerificationsXmlReader.readFromXml(in, builder);
        return builder.build();
    }

    private static SAXParser createSecureParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://xml.org/sax/features/namespaces", false);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return spf.newSAXParser();
    }

    private static class VerifiersHandler
    extends DefaultHandler {
        private final Interner<String> stringInterner = Interners.newStrongInterner();
        private final DependencyVerifierBuilder builder;
        private boolean inMetadata;
        private boolean inComponents;
        private ModuleComponentIdentifier currentComponent;
        private ModuleComponentArtifactIdentifier currentArtifact;
        private ChecksumKind currentChecksum;

        public VerifiersHandler(DependencyVerifierBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("verification-metadata".equals(qName)) {
                this.inMetadata = true;
            } else if ("components".equals(qName)) {
                this.assertInMetadata();
                this.inComponents = true;
            } else if ("component".equals(qName)) {
                this.assertInComponents();
                this.currentComponent = this.createComponentId(attributes);
            } else if ("artifact".equals(qName)) {
                this.assertValidComponent();
                this.currentArtifact = this.createArtifactId(attributes);
            } else if (this.currentChecksum != null && "also-trust".equals(qName)) {
                this.builder.addChecksum(this.currentArtifact, this.currentChecksum, this.getAttribute(attributes, "value"), null);
            } else if (this.currentArtifact != null) {
                this.currentChecksum = ChecksumKind.valueOf(qName);
                this.builder.addChecksum(this.currentArtifact, this.currentChecksum, this.getAttribute(attributes, "value"), this.getNullableAttribute(attributes, "origin"));
            }
        }

        private void assertInComponents() {
            VerifiersHandler.assertContext(this.inComponents, "<component> must be found under the <components> tag");
        }

        private void assertInMetadata() {
            VerifiersHandler.assertContext(this.inMetadata, "<components> must be found under the <verification-metadata> tag");
        }

        private void assertValidComponent() {
            VerifiersHandler.assertContext(this.currentComponent != null, "<artifact> must be found  under the <component> tag");
        }

        private static void assertContext(boolean test, String message) {
            if (!test) {
                throw new InvalidUserDataException("Invalid dependency verification metadata file: " + message);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("verification-metadata".equals(qName)) {
                this.inMetadata = false;
            } else if ("components".equals(qName)) {
                this.inComponents = false;
            } else if ("component".equals(qName)) {
                this.currentComponent = null;
            } else if ("artifact".equals(qName)) {
                this.currentArtifact = null;
                this.currentChecksum = null;
            }
        }

        private ModuleComponentFileArtifactIdentifier createArtifactId(Attributes attributes) {
            return new ModuleComponentFileArtifactIdentifier(this.currentComponent, this.getAttribute(attributes, "name"));
        }

        private ModuleComponentIdentifier createComponentId(Attributes attributes) {
            return DefaultModuleComponentIdentifier.newId(this.createModuleId(attributes), this.getAttribute(attributes, "version"));
        }

        private ModuleIdentifier createModuleId(Attributes attributes) {
            return DefaultModuleIdentifier.newId(this.getAttribute(attributes, "group"), this.getAttribute(attributes, "name"));
        }

        private String getAttribute(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            VerifiersHandler.assertContext(value != null, "Missing attribute: " + name);
            return (String)this.stringInterner.intern((Object)value);
        }

        private String getNullableAttribute(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value == null) {
                return null;
            }
            return (String)this.stringInterner.intern((Object)value);
        }
    }
}

