/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.action.AbstractMavenPublishAction;
import org.gradle.api.publication.maven.internal.action.DefaultMavenDeployRetrier;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.repository.DefaultProxySelector;

public class MavenDeployAction
extends AbstractMavenPublishAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenDeployAction.class);
    private static final String MAX_DEPLOY_ATTEMPTS = "org.gradle.internal.remote.repository.deploy.max.attempts";
    private static final String INITIAL_BACKOFF_MS = "org.gradle.internal.remote.repository.deploy.initial.backoff";
    private org.apache.maven.artifact.ant.RemoteRepository remoteRepository;
    private org.apache.maven.artifact.ant.RemoteRepository remoteSnapshotRepository;
    private final int maxDeployAttempts = Integer.getInteger("org.gradle.internal.remote.repository.deploy.max.attempts", 3);
    private final int initialBackOff = Integer.getInteger("org.gradle.internal.remote.repository.deploy.initial.backoff", 1000);

    public MavenDeployAction(String packaging, MavenProjectIdentity projectIdentity, List<File> wagonJars) {
        super(packaging, projectIdentity, wagonJars);
    }

    public void setRepositories(org.apache.maven.artifact.ant.RemoteRepository repository, org.apache.maven.artifact.ant.RemoteRepository snapshotRepository) {
        this.remoteRepository = repository;
        this.remoteSnapshotRepository = snapshotRepository;
    }

    @Override
    protected void publishArtifacts(Collection<Artifact> artifacts, RepositorySystem repositorySystem, RepositorySystemSession session) throws DeploymentException {
        org.apache.maven.artifact.ant.RemoteRepository gradleRepo = this.remoteRepository;
        if (artifacts.iterator().next().isSnapshot() && this.remoteSnapshotRepository != null) {
            gradleRepo = this.remoteSnapshotRepository;
        }
        if (gradleRepo == null) {
            throw new GradleException("Must specify a repository for deployment");
        }
        RemoteRepository aetherRepo = this.createRepository(gradleRepo);
        DeployRequest request = new DeployRequest();
        request.setRepository(aetherRepo);
        for (Artifact artifact : artifacts) {
            request.addArtifact(artifact);
        }
        LOGGER.info("Deploying to {}", (Object)gradleRepo.getUrl());
        DefaultMavenDeployRetrier deployRetrier = new DefaultMavenDeployRetrier(() -> {
            repositorySystem.deploy(session, request);
            return null;
        }, this.remoteRepository, this.maxDeployAttempts, this.initialBackOff);
        deployRetrier.deployWithRetry();
    }

    private RemoteRepository createRepository(org.apache.maven.artifact.ant.RemoteRepository gradleRepo) {
        org.apache.maven.artifact.ant.Proxy proxy;
        RemoteRepository repo = new RemoteRepository("remote", gradleRepo.getLayout(), gradleRepo.getUrl());
        org.apache.maven.artifact.ant.Authentication auth = gradleRepo.getAuthentication();
        if (auth != null) {
            repo.setAuthentication(new Authentication(auth.getUserName(), auth.getPassword(), auth.getPrivateKey(), auth.getPassphrase()));
        }
        if ((proxy = gradleRepo.getProxy()) != null) {
            DefaultProxySelector proxySelector = new DefaultProxySelector();
            Authentication proxyAuth = new Authentication(proxy.getUserName(), proxy.getPassword());
            proxySelector.add(new Proxy(proxy.getType(), proxy.getHost(), proxy.getPort(), proxyAuth), proxy.getNonProxyHosts());
            repo.setProxy(proxySelector.getProxy(repo));
        }
        return repo;
    }
}

