/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.util.GUtil;

public abstract class JvmGradlePluginProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public JvmGradlePluginProjectInitDescriptor(DocumentationRegistry documentationRegistry) {
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.GRADLE_PLUGIN;
    }

    @Override
    public void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder, TemplateFactory templateFactory) {
        super.generate(settings, buildScriptBuilder, templateFactory);
        String pluginId = settings.getPackageName() + ".greeting";
        String pluginClassName = StringUtils.capitalize((String)GUtil.toCamelCase((CharSequence)settings.getProjectName())) + "Plugin";
        String testClassName = pluginClassName + "Test";
        String functionalTestClassName = pluginClassName + "FunctionalTest";
        buildScriptBuilder.fileComment("This generated file contains a sample Gradle plugin project to get you started.").fileComment("For more details take a look at the Writing Custom Plugins chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("custom_plugins"));
        buildScriptBuilder.plugin("Apply the Java Gradle plugin development plugin to add support for developing Gradle plugins", "java-gradle-plugin");
        buildScriptBuilder.block(null, "gradlePlugin", (Action<? super ScriptBlockBuilder>)((Action)b -> b.containerElement("Define the plugin", "plugins", "greeting", (Action<? super ScriptBlockBuilder>)((Action)g -> {
            g.propertyAssignment(null, "id", pluginId);
            g.propertyAssignment(null, "implementationClass", this.withPackage(settings, pluginClassName));
        }))));
        BuildScriptBuilder.Expression functionalTestSourceSet = buildScriptBuilder.createContainerElement("Add a source set for the functional test suite", "sourceSets", "functionalTest", "functionalTestSourceSet");
        buildScriptBuilder.methodInvocation(null, "gradlePlugin.testSourceSets", functionalTestSourceSet);
        BuildScriptBuilder.Expression functionalTestConfiguration = buildScriptBuilder.containerElementExpression("configurations", "functionalTestImplementation");
        BuildScriptBuilder.Expression testConfiguration = buildScriptBuilder.containerElementExpression("configurations", "testImplementation");
        buildScriptBuilder.methodInvocation(null, functionalTestConfiguration, "extendsFrom", testConfiguration);
        BuildScriptBuilder.Expression functionalTest = buildScriptBuilder.taskRegistration("Add a task to run the functional tests", "functionalTest", "Test", (Action<? super ScriptBlockBuilder>)((Action)b -> {
            b.propertyAssignment(null, "testClassesDirs", buildScriptBuilder.propertyExpression(functionalTestSourceSet, "output.classesDirs"));
            b.propertyAssignment(null, "classpath", buildScriptBuilder.propertyExpression(functionalTestSourceSet, "runtimeClasspath"));
        }));
        buildScriptBuilder.taskMethodInvocation("Run the functional tests as part of `check`", "check", "Task", "dependsOn", functionalTest);
        TemplateOperation sourceTemplate = this.sourceTemplate(settings, templateFactory, pluginId, pluginClassName);
        TemplateOperation testTemplate = this.testTemplate(settings, templateFactory, pluginId, testClassName);
        TemplateOperation functionalTestTemplate = this.functionalTestTemplate(settings, templateFactory, pluginId, functionalTestClassName);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, testTemplate, functionalTestTemplate).generate();
    }

    @Override
    public Optional<String> getFurtherReading() {
        return Optional.of(this.documentationRegistry.getTopicGuidesFor("Plugin%20Development"));
    }

    protected abstract TemplateOperation sourceTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);

    protected abstract TemplateOperation testTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);

    protected abstract TemplateOperation functionalTestTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);
}

