/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;

public class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourPluginsPath;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        String fromProperty = System.getProperty("idea.home.path", System.getProperty("idea.home"));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else if (insideIde && (ourHomePath = PathManager.getHomePathFor(PathManager.class)) == null) {
            String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
            throw new RuntimeException("Could not find installation home path. Please " + advice);
        }
        if (ourHomePath != null && SystemInfo.isWindows) {
            ourHomePath = PathManager.canonicalPath(ourHomePath);
        }
        ourBinDirectories = ourHomePath != null ? PathManager.getBinDirectories(new File(ourHomePath)) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        return ourHomePath;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass2) {
        String rootPath;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        File root2 = new File(rootPath).getAbsoluteFile();
        while ((root2 = root2.getParentFile()) != null && !PathManager.isIdeaHome(root2)) {
        }
        return root2 != null ? root2.getPath() : null;
    }

    private static boolean isIdeaHome(@NotNull File root2) {
        if (root2 == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        for (String binDir : PathManager.getBinDirectories(root2)) {
            if (!new File(binDir, "idea.properties").isFile()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String[] getBinDirectories(@NotNull File root2) {
        if (root2 == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        SmartList<String> binDirs = new SmartList<String>();
        String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root2, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(binDirs);
        if (stringArray == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + "/" + "bin";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file2 = new File(binDir, fileName);
            if (!file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file2;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        if ((file2 = PathManager.findBinFile(fileName)) != null) {
            File file3 = file2;
            if (file3 == null) {
                PathManager.$$$reportNull$$$0(9);
            }
            return file3;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string2 = PathManager.getHomePath() + "/" + "plugins";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string2 = ourConfigPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String fromProp = System.getProperty("idea.config.path");
        ourConfigPath = fromProp != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(fromProp)) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + "/" + "config");
        String string3 = ourConfigPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        String string2 = PathManager.platformPath(selector, "Library/Preferences", "config");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string2 = ourPluginsPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(21);
            }
            return string2;
        }
        ourPluginsPath = System.getProperty("idea.plugins.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.plugins.path"))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Application Support", "") : PathManager.getConfigPath() + "/" + "plugins");
        String string3 = ourPluginsPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return string3;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string2 = ourSystemPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(26);
            }
            return string2;
        }
        ourSystemPath = System.getProperty("idea.system.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + "/" + "system");
        FileUtilRt.createDirectory(new File(ourSystemPath));
        String string3 = ourSystemPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        String string2 = PathManager.platformPath(selector, "Library/Caches", "system");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(29);
        }
        return string2;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtilRt.createDirectory(indexRoot);
        File file2 = indexRoot;
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        return file2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context2, @NotNull String path2) {
        URL url;
        if (context2 == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        if ((url = context2.getResource(path2)) == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(@NotNull URL resourceURL, @NotNull String resourcePath) {
        if (resourceURL == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path2 = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path2.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = FileUtilRt.toSystemDependentName((String)paths.first);
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return StringUtil.trimEnd(resultPath, "/");
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path2 = PathManager.getHomePath();
        if (new File(path2, "community/.idea").isDirectory()) {
            String string2 = path2 + "/community";
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(44);
            }
            return string2;
        }
        if (new File(path2, "ultimate/community/.idea").isDirectory()) {
            String string3 = path2 + "/ultimate/community";
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(45);
            }
            return string3;
        }
        String string4 = path2;
        if (string4 == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        return string4;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass2) {
        String resourceRoot;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class")) != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        path2 = FileUtil.expandUserHome(path2);
        String string2 = FileUtil.toCanonicalPath(new File(path2).getAbsolutePath());
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(50);
        }
        return string2;
    }

    @NotNull
    public static String trimPathQuotes(@NotNull String path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(51);
        }
        if (path2.length() >= 3 && StringUtil.startsWithChar(path2, '\"') && StringUtil.endsWithChar(path2, '\"')) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        String string2 = path2;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(52);
        }
        return string2;
    }

    @NotNull
    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        String string2 = PathManager.platformPath(selector, macPart, null, null, null, fallback);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        return string2;
    }

    @NotNull
    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        String userHome = SystemProperties.getUserHome();
        if (macPart != null && SystemInfo.isMac) {
            String string2 = userHome + "/" + macPart + "/" + selector;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(58);
            }
            return string2;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            String string3 = dir + "/" + selector;
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(59);
            }
            return string3;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = userHome + "/" + xdgDir;
            }
            String string4 = dir + "/" + selector;
            if (string4 == null) {
                PathManager.$$$reportNull$$$0(60);
            }
            return string4;
        }
        String string5 = userHome + "/." + selector + (!fallback.isEmpty() ? "/" + fallback : "");
        if (string5 == null) {
            PathManager.$$$reportNull$$$0(61);
        }
        return string5;
    }

    @NotNull
    private static String canonicalPath(@NotNull String path2) {
        String string2;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(62);
        }
        try {
            string2 = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            String string3 = path2;
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(64);
            }
            return string3;
        }
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(63);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 36: 
            case 49: 
            case 51: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 23: 
            case 28: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceURL";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "trimPathQuotes";
                break;
            }
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "platformPath";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBinDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "extractRoot";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "trimPathQuotes";
                break;
            }
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "canonicalPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

