/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationNamesInfo;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ProgressSlide;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.org.jdom.Element;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName = "JetBrains s.r.o.";
    private String myCopyrightStart = "2000";
    private String myShortCompanyName;
    private String myCompanyUrl = "https://www.jetbrains.com/";
    private Color myProgressColor;
    private Color myCopyrightForeground;
    private Color myAboutForeground;
    private Color myAboutLinkColor;
    private Rectangle myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight = 2;
    private int myProgressY = 350;
    private int myLicenseOffsetX = 114;
    private int myLicenseOffsetY = 85;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private Color mySplashTextColor = new Color(0, 35, 135);
    private String myIconUrl = "/icon.png";
    private String mySmallIconUrl = "/icon_small.png";
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee = true;
    private String myCustomizeIDEWizardStepsProvider;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp = true;
    private boolean myHasContextHelp = true;
    private String myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
    private String[] myEssentialPluginsIds;
    private String myFUStatisticsSettingsUrl;
    private String myEventLogSettingsUrl;
    private String myJetbrainsTvUrl;
    private String myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
    private String myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private final List<ProgressSlide> myProgressSlides = new ArrayList<ProgressSlide>();
    private static ApplicationInfoImpl ourShadowInstance;
    private static volatile boolean myInStressTest;

    ApplicationInfoImpl() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            this.loadState(JDOMUtil.load(ApplicationInfoImpl.class, resource));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public BuildNumber getBuild() {
        return BuildNumber.fromString(this.myBuildNumber);
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        if (ourShadowInstance == null) {
            ourShadowInstance = new ApplicationInfoImpl();
        }
        ApplicationInfoImpl applicationInfoImpl = ourShadowInstance;
        if (applicationInfoImpl == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        return applicationInfoImpl;
    }

    private void loadState(Element parentNode) {
        Element subscriptionsElement;
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        String pluginsHost;
        Element pluginsElement;
        Element whatsnewElement;
        Element feedbackElement;
        Element youtrackElement;
        Element supportElement;
        Element helpElement;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconEap;
        Element iconElement;
        Element aboutLogoElement;
        Element buildElement;
        Element companyElement;
        Element versionElement = ApplicationInfoImpl.getChild(parentNode, "version");
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue("major");
            this.myMinorVersion = versionElement.getAttributeValue("minor");
            this.myMicroVersion = versionElement.getAttributeValue("micro");
            this.myPatchVersion = versionElement.getAttributeValue("patch");
            this.myFullVersionFormat = versionElement.getAttributeValue("full");
            this.myCodeName = versionElement.getAttributeValue("codename");
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue("eap"));
            this.myVersionSuffix = versionElement.getAttributeValue("suffix");
            if (this.myVersionSuffix == null && this.myEAP) {
                this.myVersionSuffix = "EAP";
            }
        }
        if ((companyElement = ApplicationInfoImpl.getChild(parentNode, "company")) != null) {
            this.myCompanyName = companyElement.getAttributeValue("name", this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue("url", this.myCompanyUrl);
            this.myCopyrightStart = companyElement.getAttributeValue("copyrightStart", this.myCopyrightStart);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(parentNode, "build")) != null) {
            String majorReleaseDateString;
            this.myBuildNumber = buildElement.getAttributeValue("number");
            this.myApiVersion = buildElement.getAttributeValue("apiVersion");
            ApplicationInfoImpl.setBuildNumber(this.myApiVersion, this.myBuildNumber);
            String dateString = buildElement.getAttributeValue("date");
            if ("__BUILD_DATE__".equals(dateString)) {
                this.myBuildDate = new GregorianCalendar();
                try (JarFile bootstrapJar2 = new JarFile(PathManager.getHomePath() + "/lib/bootstrap.jar");){
                    JarEntry jarEntry = bootstrapJar2.entries().nextElement();
                    this.myBuildDate.setTime(new Date(jarEntry.getTime()));
                }
                catch (Exception bootstrapJar2) {}
            } else {
                this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
            }
            if ((majorReleaseDateString = buildElement.getAttributeValue("majorReleaseDate")) != null) {
                this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
            }
        }
        Thread currentThread = Thread.currentThread();
        currentThread.setName(currentThread.getName() + " " + this.myMajorVersion + "." + this.myMinorVersion + "#" + this.myBuildNumber + " " + ApplicationNamesInfo.getInstance().getProductName() + ", eap:" + this.myEAP + ", os:" + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ", java-version:" + SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_RUNTIME_VERSION);
        Element logoElement = ApplicationInfoImpl.getChild(parentNode, "logo");
        if (logoElement != null) {
            this.mySplashImageUrl = logoElement.getAttributeValue("url");
            this.mySplashTextColor = ApplicationInfoImpl.parseColor(logoElement.getAttributeValue("textcolor"));
            String v = logoElement.getAttributeValue("progressColor");
            if (v != null) {
                this.myProgressColor = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = logoElement.getAttributeValue("progressTailIcon")) != null) {
                this.myProgressTailIconName = v;
            }
            if ((v = logoElement.getAttributeValue("progressHeight")) != null) {
                this.myProgressHeight = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue("progressY")) != null) {
                this.myProgressY = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue("licenseOffsetX")) != null) {
                this.myLicenseOffsetX = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue("licenseOffsetY")) != null) {
                this.myLicenseOffsetY = Integer.parseInt(v);
            }
            for (Element child : ApplicationInfoImpl.getChildren(logoElement, "progressSlide")) {
                String slideUrl = child.getAttributeValue("url");
                assert (slideUrl != null);
                String progressPercentString = child.getAttributeValue("progressPercent");
                assert (progressPercentString != null);
                int progressPercentInt = Integer.parseInt(progressPercentString);
                assert (progressPercentInt <= 100 && progressPercentInt >= 0);
                float progressPercentFloat = (float)progressPercentInt / 100.0f;
                ProgressSlide progressSlide = new ProgressSlide(slideUrl, progressPercentFloat);
                this.myProgressSlides.add(progressSlide);
            }
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(parentNode, "about")) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue("url");
            String v = aboutLogoElement.getAttributeValue("foreground");
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue("copyrightForeground")) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue("linkColor")) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new Rectangle(Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH));
                }
                catch (NumberFormatException progressSlide) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(parentNode, "icon")) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue("size16", this.mySmallIconUrl);
            this.myBigIconUrl = iconElement.getAttributeValue("size128", (String)null);
            String toolWindowIcon = iconElement.getAttributeValue("size12");
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
            this.mySvgIconUrl = iconElement.getAttributeValue("svg");
            this.mySmallSvgIconUrl = iconElement.getAttributeValue("svg-small");
        }
        if ((iconEap = ApplicationInfoImpl.getChild(parentNode, "icon-eap")) != null) {
            this.mySvgEapIconUrl = iconEap.getAttributeValue("svg");
            this.mySmallSvgEapIconUrl = iconEap.getAttributeValue("svg-small");
        }
        if ((packageElement = ApplicationInfoImpl.getChild(parentNode, "package")) != null) {
            this.myPackageCode = packageElement.getAttributeValue("code");
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(parentNode, "licensee")) != null) {
            this.myShowLicensee = Boolean.valueOf(showLicensee.getAttributeValue("show"));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(parentNode, "welcome-screen")) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue("logo-url");
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(parentNode, "customize-ide-wizard")) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue("provider");
        }
        if ((helpElement = ApplicationInfoImpl.getChild(parentNode, "help")) != null) {
            String attValue;
            String webHelpUrl = helpElement.getAttributeValue("webhelp-url");
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue("has-context-help");
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        Element updateUrls = ApplicationInfoImpl.getChild(parentNode, "update-urls");
        this.myUpdateUrls = new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(parentNode, "documentation");
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue("url");
        }
        if ((supportElement = ApplicationInfoImpl.getChild(parentNode, "support")) != null) {
            this.mySupportUrl = supportElement.getAttributeValue("url");
        }
        if ((youtrackElement = ApplicationInfoImpl.getChild(parentNode, "youtrack")) != null) {
            this.myYoutrackUrl = youtrackElement.getAttributeValue("url");
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(parentNode, "feedback")) != null) {
            this.myFeedbackUrl = feedbackElement.getAttributeValue("url");
        }
        if ((whatsnewElement = ApplicationInfoImpl.getChild(parentNode, "whatsnew")) != null) {
            this.myWhatsNewUrl = whatsnewElement.getAttributeValue("url");
        }
        if ((pluginsElement = ApplicationInfoImpl.getChild(parentNode, "plugins")) != null) {
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url3 = pluginsElement.getAttributeValue("url");
            if (url3 != null) {
                this.myPluginManagerUrl = StringUtil.trimEnd(url3, "/");
            }
            if ((listUrl = pluginsElement.getAttributeValue("list-url")) != null) {
                this.myPluginsListUrl = listUrl;
            }
            if ((channelListUrl = pluginsElement.getAttributeValue("channel-list-url")) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = pluginsElement.getAttributeValue("download-url")) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if (!this.getBuild().isSnapshot()) {
                this.myBuiltinPluginsUrl = StringUtil.nullize(pluginsElement.getAttributeValue("builtin-url"));
            }
        }
        if ((pluginsHost = System.getProperty("idea.plugins.host")) != null) {
            this.myPluginManagerUrl = StringUtil.trimEnd(pluginsHost, "/");
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            this.myPluginsListUrl = null;
        }
        this.myPluginManagerUrl = ObjectUtils.coalesce(this.myPluginManagerUrl, "https://plugins.jetbrains.com");
        this.myPluginsListUrl = ObjectUtils.coalesce(this.myPluginsListUrl, this.myPluginManagerUrl + "/plugins/list/");
        this.myChannelsListUrl = ObjectUtils.coalesce(this.myChannelsListUrl, this.myPluginManagerUrl + "/channels/list/");
        this.myPluginsDownloadUrl = ObjectUtils.coalesce(this.myPluginsDownloadUrl, this.myPluginManagerUrl + "/pluginManager/");
        Element keymapElement = ApplicationInfoImpl.getChild(parentNode, "keymap");
        if (keymapElement != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue("win");
            this.myMacKeymapUrl = keymapElement.getAttributeValue("mac");
        }
        List<Element> essentialPluginsElements = ApplicationInfoImpl.getChildren(parentNode, "essential-plugin");
        List<String> essentialPluginsIds = ContainerUtil.mapNotNull(essentialPluginsElements, element -> {
            String id = element.getTextTrim();
            return StringUtil.isNotEmpty(id) ? id : null;
        });
        this.myEssentialPluginsIds = ArrayUtilRt.toStringArray(essentialPluginsIds);
        Element statisticsElement = ApplicationInfoImpl.getChild(parentNode, "statistics");
        if (statisticsElement != null) {
            this.myFUStatisticsSettingsUrl = statisticsElement.getAttributeValue("fus-settings");
            this.myEventLogSettingsUrl = statisticsElement.getAttributeValue("event-log-settings");
        } else {
            this.myFUStatisticsSettingsUrl = "https://www.jetbrains.com/idea/statistics/fus-assistant.xml";
            this.myEventLogSettingsUrl = "https://resources.jetbrains.com/storage/fus/config/%s/lion-v3-assistant.xml";
        }
        Element tvElement = ApplicationInfoImpl.getChild(parentNode, "jetbrains-tv");
        if (tvElement != null) {
            this.myJetbrainsTvUrl = tvElement.getAttributeValue("url");
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(parentNode, "evaluation")) != null && (url2 = evaluationElement.getAttributeValue("license-url")) != null && !url2.isEmpty()) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(parentNode, "licensing")) != null && (url = licensingElement.getAttributeValue("key-conversion-url")) != null && !url.isEmpty()) {
            this.myKeyConversionUrl = url.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(parentNode, "subscriptions")) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue("formid");
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue("news-key");
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue("news-value", "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue("tips-key");
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue("tips-available"));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue("additional-form-data");
        }
    }

    @NotNull
    private static List<Element> getChildren(Element parentNode, String name) {
        List<Element> list2 = parentNode.getChildren(name, parentNode.getNamespace());
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static Element getChild(Element parentNode, String name) {
        return parentNode.getChild(name, parentNode.getNamespace());
    }

    static String shortenCompanyName(String name) {
        return StringUtil.trimEnd(StringUtil.trimEnd(name, " s.r.o."), " Inc.");
    }

    private static void setBuildNumber(String apiVersion, String buildNumber) {
        PluginManagerCore.BUILD_NUMBER = apiVersion != null ? apiVersion : buildNumber;
    }

    private static GregorianCalendar parseDate(String dateString) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }

    private static Color parseColor(String colorString) {
        long rgb = Long.parseLong(colorString, 16);
        return new Color((int)rgb, rgb > 0xFFFFFFL);
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(3);
        }
        return "org.jetbrains.kotlin.com.intellij".equals(pluginId) || ArrayUtil.contains(pluginId, this.myEssentialPluginsIds);
    }

    public List<String> getEssentialPluginsIds() {
        return ContainerUtil.immutableList(this.myEssentialPluginsIds);
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private String myCheckingUrl;
        private String myPatchesUrl;

        private UpdateUrlsImpl(Element element) {
            if (element != null) {
                this.myCheckingUrl = element.getAttributeValue("check");
                this.myPatchesUrl = element.getAttributeValue("patches");
            }
        }
    }
}

