/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.ConditionalExecution;

public class AbstractConditionalExecution<T>
implements ConditionalExecution<T> {
    private final CountDownLatch finished = new CountDownLatch(1);
    private final RunnableFuture<T> runnable;
    private final ResourceLock resourceLock;

    public AbstractConditionalExecution(Callable<T> callable, ResourceLock resourceLock) {
        this.runnable = new FutureTask<T>(callable);
        this.resourceLock = resourceLock;
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    @Override
    public Runnable getExecution() {
        return this.runnable;
    }

    @Override
    public T await() {
        boolean interrupted = false;
        while (true) {
            try {
                this.finished.await();
            }
            catch (InterruptedException e) {
                this.cancel();
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            return (T)this.runnable.get();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    @Override
    public void complete() {
        this.finished.countDown();
    }

    @Override
    public boolean isComplete() {
        return this.finished.getCount() == 0L;
    }

    @Override
    public void cancel() {
        this.runnable.cancel(true);
    }
}

