/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.ComponentVerificationMetadata;
import org.gradle.internal.xml.SimpleXmlWriter;

public class DependencyVerificationsXmlWriter {
    private static final String SPACES = "   ";
    private final SimpleXmlWriter writer;

    private DependencyVerificationsXmlWriter(OutputStream out) throws IOException {
        this.writer = new SimpleXmlWriter(out, SPACES);
    }

    public static void serialize(DependencyVerifier verifier, OutputStream out) throws IOException {
        try {
            DependencyVerificationsXmlWriter writer = new DependencyVerificationsXmlWriter(out);
            writer.write(verifier);
        }
        finally {
            out.close();
        }
    }

    private void write(DependencyVerifier verifier) throws IOException {
        this.writer.startElement("verification-metadata");
        this.writeVerifications(verifier.getVerificationMetadata());
        this.writer.endElement();
        this.writer.close();
    }

    private void writeVerifications(Collection<ComponentVerificationMetadata> verifications) throws IOException {
        this.writer.startElement("components");
        for (ComponentVerificationMetadata verification : verifications) {
            this.writeVerification(verification);
        }
        this.writer.endElement();
    }

    private void writeVerification(ComponentVerificationMetadata verification) throws IOException {
        ModuleComponentIdentifier mci = verification.getComponentId();
        this.writer.startElement("component");
        this.writer.attribute("group", mci.getGroup());
        this.writer.attribute("name", mci.getModule());
        this.writer.attribute("version", mci.getVersion());
        this.writeArtifactVerifications(verification.getArtifactVerifications());
        this.writer.endElement();
    }

    private void writeArtifactVerifications(List<ArtifactVerificationMetadata> verifications) throws IOException {
        for (ArtifactVerificationMetadata verification : verifications) {
            this.writeArtifactVerification(verification);
        }
    }

    private void writeArtifactVerification(ArtifactVerificationMetadata verification) throws IOException {
        String artifact = verification.getArtifactName();
        this.writer.startElement("artifact");
        this.writer.attribute("name", artifact);
        this.writeChecksums(verification.getChecksums());
        this.writer.endElement();
    }

    private void writeChecksums(List<Checksum> checksums) throws IOException {
        for (Checksum checksum : checksums) {
            Set<String> alternatives;
            String kind = checksum.getKind().name();
            String value = checksum.getValue();
            this.writer.startElement(kind);
            this.writer.attribute("value", value);
            String origin = checksum.getOrigin();
            if (origin != null) {
                this.writer.attribute("origin", origin);
            }
            if ((alternatives = checksum.getAlternatives()) != null) {
                for (String alternative : alternatives) {
                    this.writer.startElement("also-trust");
                    this.writer.attribute("value", alternative);
                    this.writer.endElement();
                }
            }
            this.writer.endElement();
        }
    }
}

