/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);

    private HashCode hashClassBytes(byte[] classBytes) {
        byte[] signature;
        ClassReader reader;
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.emptySet());
        if (extractor.shouldExtractApiClassFrom(reader = new ClassReader(classBytes)) && (signature = extractor.extractApiClassFrom(reader)) != null) {
            return Hashing.hashBytes((byte[])signature);
        }
        return null;
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        try {
            if (!this.isClassFile(fileSnapshot.getName())) {
                return null;
            }
            Path path = Paths.get(fileSnapshot.getAbsolutePath(), new String[0]);
            byte[] classBytes = Files.readAllBytes(path);
            return this.hashClassBytes(classBytes);
        }
        catch (Exception e) {
            LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)fileSnapshot.getName(), (Object)e);
            return fileSnapshot.getHash();
        }
    }

    @Override
    public HashCode hash(ZipEntry zipEntry) throws IOException {
        byte[] content;
        if (!this.isClassFile(zipEntry.getName())) {
            return null;
        }
        if (zipEntry.size() >= 0) {
            content = new byte[zipEntry.size()];
            ByteStreams.readFully((InputStream)zipEntry.getInputStream(), (byte[])content);
        } else {
            content = ByteStreams.toByteArray((InputStream)zipEntry.getInputStream());
        }
        return this.hashClassBytes(content);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
    }
}

