/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.RejectedVersion;

public class RejectedByAttributesVersion
extends RejectedVersion {
    private static final Comparator<AttributeMatcher.MatchingDescription> DESCRIPTION_COMPARATOR = new Comparator<AttributeMatcher.MatchingDescription>(){

        @Override
        public int compare(AttributeMatcher.MatchingDescription o1, AttributeMatcher.MatchingDescription o2) {
            return o1.getRequestedAttribute().getName().compareTo(o2.getRequestedAttribute().getName());
        }
    };
    private final List<AttributeMatcher.MatchingDescription> matchingDescription;

    public RejectedByAttributesVersion(ModuleComponentIdentifier id, List<AttributeMatcher.MatchingDescription> matchingDescription) {
        super(id);
        this.matchingDescription = matchingDescription;
    }

    @Override
    public void describeTo(TreeFormatter builder) {
        Collections.sort(this.matchingDescription, DESCRIPTION_COMPARATOR);
        builder.node(this.getId().getVersion());
        builder.startChildren();
        for (AttributeMatcher.MatchingDescription description : this.matchingDescription) {
            builder.node("Attribute '" + description.getRequestedAttribute().getName() + "'");
            if (description.isMatch()) {
                builder.append((CharSequence)" matched. ");
            } else {
                builder.append((CharSequence)" didn't match. ");
            }
            builder.append((CharSequence)("Requested " + RejectedByAttributesVersion.prettify(description.getRequestedValue()) + ", was: " + RejectedByAttributesVersion.prettify(description.getFound())));
        }
        builder.endChildren();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RejectedByAttributesVersion that = (RejectedByAttributesVersion)o;
        return Objects.equal((Object)this.getId(), (Object)that.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    private static String prettify(AttributeValue<?> value) {
        if (value.isPresent()) {
            return "'" + value.get() + "'";
        }
        return "not found";
    }

    public List<AttributeMatcher.MatchingDescription> getMatchingDescription() {
        return this.matchingDescription;
    }
}

