/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.SingleMessageLogger;

public class DefaultDependencyConstraintSet
extends DelegatingDomainObjectSet<DependencyConstraint>
implements DependencyConstraintSet {
    private final Describable displayName;
    private final Configuration clientConfiguration;

    public DefaultDependencyConstraintSet(Describable displayName, Configuration clientConfiguration, DomainObjectSet<DependencyConstraint> backingSet) {
        super(backingSet);
        this.displayName = displayName;
        this.clientConfiguration = clientConfiguration;
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    public boolean add(DependencyConstraint dependencyConstraints) {
        this.warnIfConfigurationIsDeprecated();
        return super.add((Object)dependencyConstraints);
    }

    private void warnIfConfigurationIsDeprecated() {
        List alternatives = ((DeprecatableConfiguration)this.clientConfiguration).getDeclarationAlternatives();
        if (alternatives != null) {
            DeprecationLogger.nagUserOfReplacedConfiguration((String)this.clientConfiguration.getName(), (SingleMessageLogger.ConfigurationDeprecationType)SingleMessageLogger.ConfigurationDeprecationType.DEPENDENCY_DECLARATION, (List)alternatives);
        }
    }

    public boolean addAll(Collection<? extends DependencyConstraint> dependencyConstraints) {
        boolean added = false;
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            added |= this.add(dependencyConstraint);
        }
        return added;
    }
}

