/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.filter;

import com.xemantic.tadedon.servlet.CacheForcingFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class CheCacheForcingFilter
extends CacheForcingFilter {
    private Set<Pattern> actionPatterns = new HashSet<Pattern>();

    @Override
    public void init(FilterConfig filterConfig) {
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("pattern")) continue;
            this.actionPatterns.add(Pattern.compile(filterConfig.getInitParameter(name)));
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        for (Pattern pattern : this.actionPatterns) {
            if (!pattern.matcher(((HttpServletRequest)request).getRequestURI()).matches()) continue;
            super.doFilter(request, response, chain);
            return;
        }
        chain.doFilter(request, response);
    }
}

