<?php
/*---------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

namespace Microsoft\PhpParser;

class CharacterCodes {
    const _0 = 0x30;
    const _1 = 0x31;
    const _2 = 0x32;
    const _3 = 0x33;
    const _4 = 0x34;
    const _5 = 0x35;
    const _6 = 0x36;
    const _7 = 0x37;
    const _8 = 0x38;
    const _9 = 0x39;

    const a = 0x61;
    const b = 0x62;
    const c = 0x63;
    const d = 0x64;
    const e = 0x65;
    const f = 0x66;
    const g = 0x67;
    const h = 0x68;
    const i = 0x69;
    const j = 0x6A;
    const k = 0x6B;
    const l = 0x6C;
    const m = 0x6D;
    const n = 0x6E;
    const o = 0x6F;
    const p = 0x70;
    const q = 0x71;
    const r = 0x72;
    const s = 0x73;
    const t = 0x74;
    const u = 0x75;
    const v = 0x76;
    const w = 0x77;
    const x = 0x78;
    const y = 0x79;
    const z = 0x7A;

    const A = 0x41;
    const B = 0x42;
    const C = 0x43;
    const D = 0x44;
    const E = 0x45;
    const F = 0x46;
    const G = 0x47;
    const H = 0x48;
    const I = 0x49;
    const J = 0x4A;
    const K = 0x4B;
    const L = 0x4C;
    const M = 0x4D;
    const N = 0x4E;
    const O = 0x4F;
    const P = 0x50;
    const Q = 0x51;
    const R = 0x52;
    const S = 0x53;
    const T = 0x54;
    const U = 0x55;
    const V = 0x56;
    const W = 0x57;
    const X = 0x58;
    const Y = 0x59;
    const Z = 0x5a;

    const _underscore = 0x5F;            // _
    const _dollar = 0x24;                // $
    const _ampersand = 0x26;             // &
    const _asterisk = 0x2A;              // *
    const _at = 0x40;                    // @
    const _backslash = 0x5C;             // \
    const _backtick = 0x60;              // `
    const _bar = 0x7C;                   // |
    const _caret = 0x5E;                 // ^
    const _closeBrace = 0x7D;            // }
    const _closeBracket = 0x5D;          // ]
    const _closeParen = 0x29;            // )
    const _colon = 0x3A;                 // :
    const _comma = 0x2C;                 // ;
    const _dot = 0x2E;                   // .
    const _doubleQuote = 0x22;           // "
    const _equals = 0x3D;                // =
    const _exclamation = 0x21;           // !
    const _greaterThan = 0x3E;           // >
    const _hash = 0x23;                  // #
    const _lessThan = 0x3C;              // <
    const _minus = 0x2D;                 // -
    const _openBrace = 0x7B;             // {
    const _openBracket = 0x5B;           // [
    const _openParen = 0x28;             // (
    const _percent = 0x25;               // %
    const _plus = 0x2B;                  // +
    const _question = 0x3F;              // ?
    const _semicolon = 0x3B;             // ;
    const _singleQuote = 0x27;           // '
    const _slash = 0x2F;                 // /
    const _tilde = 0x7E;                 // ~

    const _backspace = 0x08;             // \b
    const _formFeed = 0x0C;              // \f
    const _byteOrderMark = 0xFEFF;
    const _space = 0x20;
    const _newline = 0x0A;               // \n
    const _return = 0x0D;                // \r
    const _tab = 0x09;                   // \t
    const _verticalTab = 0x0B;           // \v
}
