"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Production = void 0;
var fs = require("fs-extra");
var glob = require("glob-promise");
var path = require("path");
var cli_error_1 = require("./cli-error");
var command_1 = require("./command");
var logger_1 = require("./logger");
var yarn_1 = require("./yarn");
/**
 * Generates the assembly directory, copying only subset of files and cleaning up some folders
 * @author Florent Benoit
 */
var Production = /** @class */ (function () {
    function Production(rootFolder, assemblyFolder, productionDirectory) {
        this.rootFolder = rootFolder;
        this.assemblyFolder = assemblyFolder;
        this.productionDirectory = productionDirectory;
        this.dependencies = [];
        this.toCopyFiles = [];
        this.dependencies = [];
        this.command = new command_1.Command(productionDirectory);
    }
    Production.prototype.create = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        logger_1.Logger.info('🗂  Get dependencies...');
                        // get dependencies
                        return [4 /*yield*/, this.getDependencies()];
                    case 1:
                        // get dependencies
                        _a.sent();
                        logger_1.Logger.info('🗃  Resolving files...');
                        return [4 /*yield*/, this.resolveFiles()];
                    case 2:
                        _a.sent();
                        logger_1.Logger.info('✍️  Copying files...');
                        return [4 /*yield*/, this.copyFiles()];
                    case 3:
                        _a.sent();
                        logger_1.Logger.info('✂️  Cleaning-up files...');
                        return [4 /*yield*/, this.cleanup()];
                    case 4:
                        _a.sent();
                        logger_1.Logger.info("\uD83C\uDF89  Theia production-ready available in " + this.productionDirectory + ".");
                        return [2 /*return*/, path.resolve(this.productionDirectory)];
                }
            });
        });
    };
    Production.prototype.copyFiles = function () {
        return __awaiter(this, void 0, void 0, function () {
            var assemblyLength, rootDirLength;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        assemblyLength = this.assemblyFolder.length;
                        rootDirLength = this.rootFolder.length;
                        return [4 /*yield*/, Promise.all(this.toCopyFiles.map(function (file) {
                                var destFile;
                                if (file.startsWith(_this.assemblyFolder)) {
                                    destFile = file.substring(assemblyLength);
                                }
                                else {
                                    destFile = file.substring(rootDirLength);
                                }
                                return fs.copy(file, path.join(_this.productionDirectory, destFile));
                            }))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Production.prototype.cleanup = function () {
        return __awaiter(this, void 0, void 0, function () {
            var sizeBefore, sizeAfter;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getSize()];
                    case 1:
                        sizeBefore = _a.sent();
                        return [4 /*yield*/, this.yarnClean()];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, this.cleanupFind()];
                    case 3:
                        _a.sent();
                        return [4 /*yield*/, this.getSize()];
                    case 4:
                        sizeAfter = _a.sent();
                        logger_1.Logger.info('Removed :' + (sizeBefore - sizeAfter) + ' KiB');
                        return [2 /*return*/];
                }
            });
        });
    };
    Production.prototype.getSize = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = parseInt;
                        return [4 /*yield*/, this.command.exec('du -s -k . | cut -f1')];
                    case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent(), 10])];
                }
            });
        });
    };
    Production.prototype.yarnClean = function () {
        return __awaiter(this, void 0, void 0, function () {
            var yarnCleanFolder, yarnCleanPath, yarnCleanDestPath, output;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        yarnCleanFolder = path.resolve(__dirname, '../src/conf');
                        yarnCleanPath = path.join(yarnCleanFolder, '.yarnclean');
                        return [4 /*yield*/, fs.copy(path.join(this.rootFolder, 'yarn.lock'), path.join(this.productionDirectory, 'yarn.lock'))];
                    case 1:
                        _a.sent();
                        yarnCleanDestPath = path.join(this.productionDirectory, '.yarnclean');
                        return [4 /*yield*/, fs.copy(yarnCleanPath, yarnCleanDestPath)];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, this.command.exec('yarn autoclean --force')];
                    case 3:
                        output = _a.sent();
                        return [4 /*yield*/, fs.remove(yarnCleanDestPath)];
                    case 4:
                        _a.sent();
                        logger_1.Logger.info(output);
                        return [2 /*return*/];
                }
            });
        });
    };
    Production.prototype.cleanupFind = function () {
        return __awaiter(this, void 0, void 0, function () {
            var cleanupFindFolder, cleanupFindContent, command;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        cleanupFindFolder = path.resolve(__dirname, '../src/conf');
                        return [4 /*yield*/, fs.readFile(path.join(cleanupFindFolder, 'cleanup-find'))];
                    case 1:
                        cleanupFindContent = _a.sent();
                        command = new command_1.Command(this.productionDirectory);
                        return [4 /*yield*/, Promise.all(cleanupFindContent
                                .toString()
                                .split('\n')
                                .map(function (line) { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            if (!(line.length > 0 && !line.startsWith('#'))) return [3 /*break*/, 2];
                                            return [4 /*yield*/, command.exec("find . -name " + line + " | xargs rm -rf {}")];
                                        case 1:
                                            _a.sent();
                                            _a.label = 2;
                                        case 2: return [2 /*return*/];
                                    }
                                });
                            }); }))];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Production.prototype.resolveFiles = function () {
        return __awaiter(this, void 0, void 0, function () {
            var globOptions, _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
            var _this = this;
            return __generator(this, function (_l) {
                switch (_l.label) {
                    case 0:
                        // check dependency folders are there
                        this.dependencies.forEach(function (dependency) {
                            if (!fs.existsSync(dependency)) {
                                throw new cli_error_1.CliError('The dependency ' + dependency + ' is referenced but is not available on the filesystem');
                            }
                        });
                        globOptions = { nocase: true, nosort: true, nodir: true, dot: true };
                        _a = this;
                        _c = (_b = this.toCopyFiles.concat).apply;
                        _d = [[]];
                        return [4 /*yield*/, Promise.all(this.dependencies.map(function (dependencyDirectory) {
                                return glob
                                    .promise('**', Object.assign(globOptions, { cwd: dependencyDirectory }))
                                    .then(function (data) { return data.map(function (name) { return path.join(dependencyDirectory, name); }); });
                            }))];
                    case 1:
                        _a.toCopyFiles = _c.apply(_b, _d.concat([_l.sent()]));
                        // add as well the lib folder
                        _e = this;
                        _g = (_f = this.toCopyFiles).concat;
                        return [4 /*yield*/, glob
                                .promise('lib/**', Object.assign(globOptions, { cwd: this.assemblyFolder }))
                                .then(function (data) { return data.map(function (name) { return path.join(_this.assemblyFolder, name); }); })];
                    case 2:
                        // add as well the lib folder
                        _e.toCopyFiles = _g.apply(_f, [_l.sent()]);
                        _h = this;
                        _k = (_j = this.toCopyFiles).concat;
                        return [4 /*yield*/, glob
                                .promise('src-gen/**', Object.assign(globOptions, { cwd: this.assemblyFolder }))
                                .then(function (data) { return data.map(function (name) { return path.join(_this.assemblyFolder, name); }); })];
                    case 3:
                        _h.toCopyFiles = _k.apply(_j, [_l.sent()]);
                        this.toCopyFiles = this.toCopyFiles.concat(path.join(this.assemblyFolder, 'package.json'));
                        return [2 /*return*/, Promise.resolve(true)];
                }
            });
        });
    };
    Production.prototype.getDependencies = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this;
                        return [4 /*yield*/, new yarn_1.Yarn('', Production.ASSEMBLY_DIRECTORY, Production.FORBIDDEN_PACKAGES, Production.EXCLUDED_PACKAGES).getDependencies('@eclipse-che/theia-assembly')];
                    case 1:
                        _a.dependencies = _b.sent();
                        return [2 /*return*/, Promise.resolve(true)];
                }
            });
        });
    };
    /**
     * Ensure we've no dependencies to these packages that bring a lot of dependencies !
     */
    Production.FORBIDDEN_PACKAGES = ['webpack', 'webpack-cli', '@theia/application-manager'];
    /**
     * Remove these client dependencies as they're already bundled with webpack
     */
    Production.EXCLUDED_PACKAGES = [
        'electron',
        'react',
        'react-virtualized',
        'onigasm',
        'oniguruma',
        '@theia/monaco',
        'react-dom',
        'font-awesome',
        '@theia/monaco-editor-core',
    ];
    Production.ASSEMBLY_DIRECTORY = path.resolve('examples/assembly');
    return Production;
}());
exports.Production = Production;
//# sourceMappingURL=production.js.map